{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    <table class="table table-bordered blockContainer showInlineTable equalSplit" style="margin-top:-1px;">
        <tbody>
        {foreach key=FIELD_NAME item=FIELD_MODEL from=$PROVIDER_MODEL}
            <tr>
                <td class="fieldLabel wide" id="HelpDesk_detailView_fieldLabel_description" style="width:30%">
                    <label class="muted pull-right marginRight10px">
                        {assign var=FIELD_NAME value=$FIELD_MODEL->get('name')}
                        {vtranslate($FIELD_MODEL->get('label') , $QUALIFIED_MODULE_NAME)}
                    </label>
                </td>
                <td class="fieldValue wide" colspan="3" style="width:70%;">
                    {assign var=FIELD_TYPE value=$FIELD_MODEL->getFieldDataType()}
                    {assign var=FIELD_VALUE value=$RECORD_MODEL->get($FIELD_NAME)}
                    {if $FIELD_TYPE == 'picklist'}
                        <select class="select2 span3 marginLeftZero" name="{$FIELD_NAME}" placeholder="{vtranslate('LBL_SELECT_OPTION','Magsoft')}">
                            <option value="">{vtranslate('LBL_SELECT_OPTION','Magsoft')}</option>
                            {assign var=PICKLIST_VALUES value=$FIELD_MODEL->get('picklistvalues')}
                            {foreach item=PICKLIST_VALUE key=PICKLIST_KEY from=$PICKLIST_VALUES}
                                <option value="{$PICKLIST_KEY}" {if $FIELD_VALUE eq $PICKLIST_KEY} selected {/if}>
                                    {vtranslate($PICKLIST_VALUE, $QUALIFIED_MODULE_NAME)}
                                </option>
                            {/foreach}
                        </select>
                    {elseif $FIELD_TYPE == 'radio'}
                        <input type="radio" name="{$FIELD_NAME}" value='1' {if $FIELD_VALUE} checked="checked" {/if} />
                        &nbsp;{vtranslate('LBL_YES', $QUALIFIED_MODULE_NAME)}&nbsp;&nbsp;&nbsp;
                        <input type="radio" name="{$FIELD_NAME}" value='0' {if !$FIELD_VALUE} checked="checked" {/if} />
                        &nbsp;{vtranslate('LBL_NO', $QUALIFIED_MODULE_NAME)}
                    {elseif $FIELD_TYPE == 'password'}
                        <input type="password" name="{$FIELD_NAME}" class="span3" autocomplete="new-password" data-validation-engine="validate[required]" value="{$FIELD_VALUE}"/>
                    {else}
                        <input type="text" name="{$FIELD_NAME}" class="span3" {if $FIELD_NAME == 'username'} data-validation-engine="validate[required]" {/if} value="{$FIELD_VALUE}"/>
                    {/if}
                </td>
            </tr>
        {/foreach}
        <tr>
            <td colspan="4" class="fieldValue narrowWidthType alert alert-info">
                {if $PROVIDER_NAME == 'BulkSms'}
                    1. BulkSms - Registe uma conta em
                    &nbsp;<a href="http://smsbulk.pt" target="_blank">SmsBulk.pt</a>
                    <br/>
                    2. Obtenha o UID API, insira-o em User Sid e a sua senha em Pass Token
                    <br/>
                    3. Coloque o número <code>1</code> em Unicode (1)
                    <br/>
                    4. Configure um remetente e insira-o em Remetente
                    <br/>
                    Nota - Os números móveis dos clientes devem excluir o prefixo 351
                {elseif $PROVIDER_NAME == 'Twilio'}
                    1. Twilio - Registe uma conta em
                    &nbsp;<a href="https://twilio.com" target="_blank">Twilio.com</a>
                    <br/>
                    2. Em Account encontre o Live AccountSID e a senha AuthToken
                    <br/>
                    3. Importante - obtenha um número que permita envio de sms's
                    <br/>
                    4. Coloque o número que escolheu sem espaços. Ex: +15005550006
                    <br/>
                    Nota - Os números móveis dos clientes devem conter o prefixo +351
                {elseif $PROVIDER_NAME == 'ClickATell'}
                    1. ClickATell - Registe uma conta em
                    &nbsp;<a href="https://clickatell.com" target="_blank">Clickatell.com (modo Developers)</a>
                    <br/>
                    2. Username e Password que recebeu por email em User Sid e Pass Token
                    <br/>
                    3. Obtenha o Api Id auto-criado e valide um remetente em Manage Sender ID
                    <br/>
                    4. Na opção Seq 1 coloque o número <code>1</code>
                    <br/>
                    Nota - Os números móveis dos clientes devem conter o prefixo 351
                {elseif $PROVIDER_NAME == 'Nexmo'}
                    1. Nexmo - Registe uma conta em
                    &nbsp;<a href="https://dashboard.nexmo.com" target="_blank">Nexmo.com</a>
                    <br/>
                    2. Coloque o User Sid e Pass Token (dados do user)
                    <br/>
                    3. Preencha a api_key e api_secret que encontra na conta Nexmo
                    <br/>
                    4. Coloque em Remetente o nº de envio que registou na Nexmo
                    <br/>
                    5. Em codificação coloque o valor <code>unicode</code>
                    <br/>
                    Nota - Os números móveis dos clientes devem conter o prefixo 351
                {elseif $PROVIDER_NAME == 'KeepSms'}
                    1. BulkSms - Registe uma conta em
                    &nbsp;<a href="http://keepsms.com/?utm_campaign=magsoft" target="_blank">KeepSms.com</a>
                    <br/>
                    2. Insira o seu Username em User Sid e a sua senha em Pass Token
                    <br/>
                    3. Configure um remetente e insira-o em Remetente
                    <br/>
                    4. Coloque <code>gsm-pt</code> em Unicode
                    <br/>
                    Nota - Os números móveis dos clientes devem conter o prefixo 351
                {elseif $PROVIDER_NAME == 'AppySms'}
                    1. AppySms - Registe uma conta em
                    &nbsp;<a href="http://appyprime.pt/appysms/produto/pack-magsoft/" target="_blank">AppyPrime.pt</a>
                    <br/>
                    2. No painel AppySms em <a href="http://appysms.appyprime.pt/Documentacion/type/http" target="_blank">Apis de Integração</a> adicione um novo IP com o endereço 0.0.0.0 e sub-rede /0
                    <br/>
                    3. Insira o seu Username em User Sid e a sua senha em Pass Token
                    <br/>
                    4. Insira um nome ou número em Remetente
                    <br/>
                    5. Coloque <code>gsm-pt</code> em Codificação
                    <br/>
                    Nota - Os números móveis dos clientes devem conter o prefixo 351
                {elseif $PROVIDER_NAME == 'SmsApi'}
                    1. SmsApi - Registe uma conta em
                    &nbsp;<a href="https://www.smsapi.com/en/signup" target="_blank">SmsApi.com</a>
                    <br/>
                    2. Insira o Email em User Sid e a sua API tokens (OAuth) em Pass Token
                    <br/>
                    3. A API tokens (OAuth) pode ser obtida em OAuth tokens / Generate access token
                    &nbsp;<a href="https://ssl.smsapi.com/react/oauth/manage" target="_blank">API Settings</a>
                    <br/>
                    4. Configure um remetente no site smsapi em (Senders) e insira-o em Remetente
                    <br/>
                    Nota - Os números móveis dos clientes devem conter o prefixo 351
                {/if}
            </td>
        </tr>
        </tbody>
    </table>
{/strip}