{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ********************************************************************************/
-->*}
{strip}
    <div class="container-fluid" id="OutgoingServerDetails">
        <div class="widget_header row-fluid">
            <div class="span8"><h3>{vtranslate('LBL_OUTGOING_SERVER', $QUALIFIED_MODULE)}</h3></div>
            <div class="span4">
                <div class="pull-right">
                    <button class="btn editButton" data-url='{$MODEL->getEditViewUrl()}' type="button" title="{vtranslate('LBL_EDIT', $QUALIFIED_MODULE)}">
                        <strong>{vtranslate('LBL_EDIT', $QUALIFIED_MODULE)}</strong></button>
                </div>
            </div>
        </div>
        <hr>
        <div class="contents row-fluid">
            <table class="table table-bordered detailview-table themeTableColor">
                <thead>
                <tr class="blockHeader">
                    <th colspan="2" class="{$WIDTHTYPE}">
                        <span class="alignMiddle">{vtranslate('LBL_MAIL_SERVER_SMTP', $QUALIFIED_MODULE)}</span>
                    </th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td width="25%" class="{$WIDTHTYPE} fieldLabel">
                        <label class="muted pull-right marginRight10px">{vtranslate('LBL_SERVER_NAME', $QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="{$WIDTHTYPE} fieldValue"><span>{$MODEL->get('server')}</span></td>
                </tr>
                <tr>
                    <td class="{$WIDTHTYPE} fieldLabel">
                        <label class="muted pull-right marginRight10px">{vtranslate('LBL_EMAIL_ADDRESS', $QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="{$WIDTHTYPE} fieldValue"><span>{$MODEL->get('server_username')}</span></td>
                </tr>
                <tr>
                    <td class="{$WIDTHTYPE} fieldLabel">
                        <label class="muted pull-right marginRight10px">{vtranslate('LBL_PASSWORD', $QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="{$WIDTHTYPE} fieldValue">
                        <span class="password">{if $MODEL->get('server_password') neq ''}**oculta**{/if}&nbsp;</span>
                    </td>
                </tr>
                <tr>
                    <td class="{$WIDTHTYPE} fieldLabel">
                        <label class="muted pull-right marginRight10px">{vtranslate('LBL_FROM_EMAIL', $QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="{$WIDTHTYPE} fieldValue"><span>{$MODEL->get('from_email_field')}</span></td>
                </tr>
                <tr>
                    <td class="{$WIDTHTYPE} fieldLabel">
                        <label class="muted pull-right marginRight10px">{vtranslate('LBL_SMTP_EMAIL', $QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="{$WIDTHTYPE} fieldValue"><span>{$MODEL->get('smtp_type')}</span></td>
                </tr>
                <tr>
                    <td class="{$WIDTHTYPE} fieldLabel">
                        <label class="muted pull-right marginRight10px">{vtranslate('LBL_REQUIRES_AUTHENTICATION', $QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="{$WIDTHTYPE} fieldValue">
                        <span>{if $MODEL->isSmtpAuthEnabled()}{vtranslate('LBL_YES', $QUALIFIED_MODULE)} {else}{vtranslate('LBL_NO_SINGLE', $QUALIFIED_MODULE)}{/if}</span>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
{/strip}