{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
*
 ********************************************************************************/
-->*}
{strip}
    <div class="container-fluid">
        <div class="widget_header">
            <h3>{vtranslate('CustomerPortal', $QUALIFIED_MODULE)}</h3>
        </div>
        <hr>
        <br>
        <div class="contents row-fluid">
            <form id="customerPortalForm" class="form-horizontal">
                <div class="row-fluid">
                    <div>
                        <input type="hidden" name="portalModulesInfo" value=""/>
                        <div class="row-fluid">
                            <div class="notification span12">
                                <div class="alert alert-danger">
                                    <i class="fa fa-info" style="margin-top:2px"></i>
                                    <span style="margin-left: 2%">{vtranslate('LBL_PORTAL_ACCESS', $QUALIFIED_MODULE)}</span>
                                </div>
                            </div>
                        </div>
                        <div class="well">
                            <label class="marginBottom10px">{vtranslate('LBL_PRIVILEGES', $QUALIFIED_MODULE)}.&nbsp;{vtranslate('LBL_PREVILEGES_MESSAGE', $QUALIFIED_MODULE)}</label>
                            <div>
						<span class="row-fluid">
							<select name="privileges" class="select2 span3">
								{foreach item=USER_MODEL from=$USER_PORTAL}
                                    {assign var=USER_ID value=$USER_MODEL->getId()}
                                    <option value="{$USER_ID}" {if $CURRENT_PORTAL_USER eq $USER_ID} selected {/if}>{$USER_MODEL->getName()}</option>
                                {/foreach}
							</select>
						</span>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="notification span12">
                                <div class="alert alert-danger">
                                    <i class="fa fa-info" style="margin-top:2px"></i>
                                    <span style="margin-left: 2%">{vtranslate('LBL_USER_ATTRIBUTE', $QUALIFIED_MODULE)}</span>
                                </div>
                            </div>
                        </div>
                        <div class="well">
                            <label class="marginBottom10px">{vtranslate('LBL_DEFAULT_ASSIGNEE', $QUALIFIED_MODULE)}.&nbsp;{vtranslate('LBL_DEFAULT_ASSIGNEE_MESSAGE', $QUALIFIED_MODULE)}</label>
                            <div>
						<span class="row-fluid">
							<select name="defaultAssignee" class="select2 span3">
								<optgroup style="border: none" label="{vtranslate('LBL_USERS', $QUALIFIED_MODULE)}">
									{foreach item=USER_MODEL from=$USER_MODELS}
                                        {assign var=USER_ID value=$USER_MODEL->getId()}
                                        <option value="{$USER_ID}" {if $CURRENT_DEFAULT_ASSIGNEE eq $USER_ID} selected {/if}>{$USER_MODEL->getName()}</option>
                                    {/foreach}
								</optgroup>
								<optgroup style="border: none" label="{vtranslate('LBL_GROUPS', $QUALIFIED_MODULE)}">
									{foreach item=GROUP_MODEL from=$GROUP_MODELS}
                                        {assign var=GROUP_ID value=$GROUP_MODEL->getId()}
                                        <option value="{$GROUP_ID}" {if $CURRENT_DEFAULT_ASSIGNEE eq $GROUP_ID} selected {/if}>{$GROUP_MODEL->getName()}</option>
                                    {/foreach}
								</optgroup>
							</select>
						</span>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="notification span12">
                                <div class="alert alert-info">
                                    <i class="fa fa-info" style="margin-top:2px"></i>
                                    <span style="margin-left: 2%"><a href="{$PORTAL_URL}">{$PORTAL_URL}</a></span><br><br>
                                    <span>{vtranslate('LBL_PORTAL_URL_MESSAGE', $QUALIFIED_MODULE)}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div><i class="fa fa-info"></i>&nbsp;{vtranslate('LBL_DRAG_AND_DROP_MESSAGE', $QUALIFIED_MODULE)}
                    </div>
                    <br>
                    <table id="portalModulesTable" class="table table-bordered table-condensed listViewEntriesTable">
                        <thead>
                        <tr class="listViewHeaders">
                            <th class="wide">
                                <span style="padding-left: 30px;">{vtranslate('LBL_MODULE_NAME', $QUALIFIED_MODULE)}</span>
                            </th>
                            <th class="wide">
                                {vtranslate('LBL_ENABLE_MODULE', $QUALIFIED_MODULE)}
                            </th>
                            <th class="wide">
                                {vtranslate('LBL_VIEW_ALL_RECORDS', $QUALIFIED_MODULE)}
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        {foreach key=TAB_ID item=MODEL from=$MODULES_MODELS}
                            {assign var=MODULE_NAME value=$MODEL->get('name')}
                            <tr class="portalModuleRow" data-id="{$TAB_ID}" data-sequence="{$MODEL->get('sequence')}" data-module="{$MODULE_NAME}">
                                <input type="hidden" name="portalModulesInfo[{$TAB_ID}][sequence]" value="{$MODEL->get('sequence')}"/>
                                <td class="wide">
                                    <div class="row-fluid">&nbsp;
                                        <span class="span1"><a><img src="{vimage_path('drag.png')}" border="0" title="{vtranslate('LBL_DRAG',$MODULE)}"/></a></span>
                                        <span class="span9">{vtranslate($MODULE_NAME, $MODULE_NAME)}</span>
                                    </div>
                                </td>
                                <td class="wide">
                                    <input type="hidden" name="portalModulesInfo[{$TAB_ID}][visible]" value="0"/>
                                    <label class="check-switch">
                                        <input type="checkbox" name="portalModulesInfo[{$TAB_ID}][visible]" value="1" {if $MODEL->get('visible') == '1'} checked {/if} />
                                        <span></span>
                                    </label>
                                </td>
                                <td class="wide">
                                    <label class="radio inline">
                                        <div class="pretty p-default p-round">
                                            <input type="radio" name="portalModulesInfo[{$TAB_ID}][prefValue]" value="1" {if $MODEL->get('prefvalue') == '1'} checked="checked" {/if} />
                                            <div class="state p-success">
                                                <label>{vtranslate('LBL_YES', $QUALIFIED_MODULE)}</label>
                                            </div>
                                        </div>
                                    </label>
                                    <label class="radio inline">
                                        <div class="pretty p-default p-round">
                                            <input type="radio" name="portalModulesInfo[{$TAB_ID}][prefValue]" value="0" {if $MODEL->get('prefvalue') == '0'} checked="checked" {/if} />
                                            <div class="state p-danger">
                                                <label>{vtranslate('LBL_PERMISSION_DENIED', $QUALIFIED_MODULE)}</label>
                                            </div>
                                        </div>
                                    </label>
                                </td>
                            </tr>
                        {/foreach}
                        </tbody>
                    </table>
                </div>
                <div class="row-fluid">
                    <br>
                    <button class="btn btn-success pull-right" type="submit" disabled="true" name="savePortalInfo">
                        <strong>{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}</strong></button>
                </div>
                <br>
            </form>
        </div>
    </div>
{/strip}