{*<!--
/*********************************************************************************
  ** The contents of this file are subject to the magsoft CRM Public License Version 1.0
   * ("License"); You may not use this file except in compliance with the License
   * The Original Code is:  magsoft CRM Software
   * The Initial Developer of the Original Code is magsoft.
   * Portions created by magsoft are Copyright (C) magsoft.
   * All Rights Reserved.
  *
 ********************************************************************************/
-->*}
{strip}
    <div class="container-fluid">
    <div class="row-fluid reportsDetailHeader">
        <input type="hidden" name="date_filters" data-value='{ZEND_JSON::encode($DATE_FILTERS)}'/>
        <form id="detailView" onSubmit="return false;">
            <input type="hidden" name="date_filters" data-value='{Magsoft_Util_Helper::toSafeHTML(ZEND_JSON::encode($DATE_FILTERS))}'/>
            <div class="reportHeader row-fluid">
                <div class='span6'>
                    <h3>{vtranslate($REPORT_MODEL->getName(),$MODULE)}</h3>
                    <div id="noOfRecords">{vtranslate('LBL_NO_OF_RECORDS',$MODULE)}
                        &nbsp;<span id="countValue" class="color-blue">{$COUNT}</span>
                    </div>
                    {if $COUNT > 2000}
                        <br>
                        <span class="color-red" id="moreRecordsText"> ({vtranslate('LBL_MORE_RECORDS_TXT',$MODULE)})</span>
                    {else}
                        <br>
                        <span class="color-red hide" id="moreRecordsText"> ({vtranslate('LBL_MORE_RECORDS_TXT',$MODULE)})</span>
                    {/if}
                </div>
                <div class='span6'>
                    <span class="pull-right">
                        <div class="btn-toolbar">
                        	{foreach item=DETAILVIEW_LINK from=$DETAILVIEW_LINKS}
                                {assign var=LINKNAME value=$DETAILVIEW_LINK->getLabel()}
                                {assign var=ICON value=$DETAILVIEW_LINK->getIcon()}
                                <div class="btn-group">
                                    <a class="btn tooltip-left" style="background-color: #ffffff" data-tooltip="{$LINKNAME}" name="{$LINKNAME}" href="{$DETAILVIEW_LINK->getUrl()}" target="_blank">
                						<span>{$ICON}</span>
            						</a>
                                </div>
                            {/foreach}
                        	<div class="btn-group">
                            	<button onclick='window.location.href="{$REPORT_MODEL->getDuplicateRecordUrl()}"' type="button" class="cursorPointer btn tooltip-left" data-tooltip="{vtranslate('LBL_DUPLICATE',$MODULE)}">
                                	<i class="fa fa-clone" alt="{vtranslate('LBL_DUPLICATE',$MODULE)}"></i>
                            	</button>
                        	</div>
                        	{if $REPORT_MODEL->isEditable() eq true}
                                <div class="btn-group">
                                <button onclick='window.location.href="{$REPORT_MODEL->getEditViewUrl()}"' type="button" class="cursorPointer btn tooltip-left" data-tooltip="{vtranslate('LBL_CUSTOMIZE',$MODULE)}">
                                    <i class="fa fa-pencil" alt="{vtranslate('LBL_CUSTOMIZE',$MODULE)}"></i>
                                </button>
                            </div>
                            {/if}
                        </div>
                    </span>
                </div>
            </div>
            <br>
            <div class="row-fluid">
                <input type="hidden" id="recordId" value="{$RECORD_ID}"/>
                {assign var=RECORD_STRUCTURE value=array()}
                {assign var=PRIMARY_MODULE_LABEL value=vtranslate($PRIMARY_MODULE, $PRIMARY_MODULE)}
                {foreach key=BLOCK_LABEL item=BLOCK_FIELDS from=$PRIMARY_MODULE_RECORD_STRUCTURE}
                    {assign var=PRIMARY_MODULE_BLOCK_LABEL value=vtranslate($BLOCK_LABEL, $PRIMARY_MODULE)}
                    {assign var=key value="$PRIMARY_MODULE_LABEL $PRIMARY_MODULE_BLOCK_LABEL"}
                    {if $LINEITEM_FIELD_IN_CALCULATION eq false && $BLOCK_LABEL eq 'LBL_ITEM_DETAILS'}
                        {* dont show the line item fields block when Inventory fields are selected for calculations *}
                    {else}
                        {$RECORD_STRUCTURE[$key] = $BLOCK_FIELDS}
                    {/if}
                {/foreach}
                {foreach key=MODULE_LABEL item=SECONDARY_MODULE_RECORD_STRUCTURE from=$SECONDARY_MODULE_RECORD_STRUCTURES}
                    {assign var=SECONDARY_MODULE_LABEL value=vtranslate($MODULE_LABEL, $MODULE_LABEL)}
                    {foreach key=BLOCK_LABEL item=BLOCK_FIELDS from=$SECONDARY_MODULE_RECORD_STRUCTURE}
                        {assign var=SECONDARY_MODULE_BLOCK_LABEL value=vtranslate($BLOCK_LABEL, $MODULE_LABEL)}
                        {assign var=key value="$SECONDARY_MODULE_LABEL $SECONDARY_MODULE_BLOCK_LABEL"}
                        {$RECORD_STRUCTURE[$key] = $BLOCK_FIELDS}
                    {/foreach}
                {/foreach}
                <div class='row-fluid'>
                    {assign var=filterConditionNotExists value=(count($SELECTED_ADVANCED_FILTER_FIELDS[1]['columns']) eq 0 and count($SELECTED_ADVANCED_FILTER_FIELDS[2]['columns']) eq 0)}
                    <button class="btn row-fluid" name="modify_condition" data-val="{$filterConditionNotExists}" style="text-transform: uppercase">
                        {vtranslate('LBL_MODIFY_CONDITION', $MODULE)}&nbsp;&nbsp;
                        <i class="{if $filterConditionNotExists eq true}fa fa-angle-right{else}fa fa-angle-down{/if}"></i>
                    </button>
                </div>
                <br>
                <div id='filterContainer' class='{if $filterConditionNotExists eq true}hide{/if}'>
                    {include file='AdvanceFilter.tpl'|@vtemplate_path RECORD_STRUCTURE=$RECORD_STRUCTURE ADVANCE_CRITERIA=$SELECTED_ADVANCED_FILTER_FIELDS COLUMNNAME_API=getReportFilterColumnName}
                </div>
                <div class="row-fluid">
                    <div>
                        <button class="btn generateReport" data-mode="generate" value="{vtranslate('LBL_GENERATE_NOW',$MODULE)}"/>
                        <strong>{vtranslate('LBL_GENERATE_NOW',$MODULE)}</strong>
                        </button>&nbsp;&nbsp;
                        <button class="btn btn-success generateReport" data-mode="save" value="{vtranslate('LBL_SAVE',$MODULE)}"/>
                        <strong>{vtranslate('LBL_SAVE',$MODULE)}</strong>
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <br>
    <div class='border1px well' style="padding:10px 15px; margin-bottom:-1px;">
        <h3>{vtranslate($PRIMARY_MODULE, $PRIMARY_MODULE)} - {vtranslate($REPORT_MODEL->getName(),$MODULE)}</h3>
    </div>
    <div id="reportContentsDiv" style="padding:0;">
{/strip}