/*+**********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/

var PreviewDoc_Js = {
    token: '',
    registerDoc: function () {
        var self = PreviewDoc_Js;
        var content_list = $('td[data-field-type="documentsFileUpload"]');
        for (var i = 0; i < content_list.length; i++) {
            var element = $(content_list[i]);
            var preview = $(content_list[i]).attr('rel');
            $(content_list[i]).attr('rel', 'preview');
            var a = element.children('a');
            if (a) {
                var href = a.attr('href');
                if (href) {
                    var click = a.attr('onclick');
                    $('i.fa-download').addClass("hide");
                    classApply = 'append';
                    if (!element.hasClass(classApply)) {
                        element.addClass(classApply).prepend('<span>' + self.previewIcon(content_list[i], href) + '</span>');
                    }
                }
            }
        }
    },
    registerDocdetail: function () {
        var self = PreviewDoc_Js;
        var content_list = $('span[data-field-type="documentsFileUpload"]');
        for (var i = 0; i < content_list.length; i++) {
            var element = $(content_list[i]);
            var preview = $(content_list[i]).attr('rel');

            $(content_list[i]).attr('rel', 'preview');
            var a = element.children('a');
            if (a) {
                var href = a.attr('href');
                if (href) {
                    var click = a.attr('onclick');
                    $('i.fa-download').addClass("hide");
                    element.prepend('<span>' + self.previewIcon(content_list[i], href) + '</span>');
                }
            }
        }
    },
    registerDocWidget: function () {
        var self = PreviewDoc_Js;
        var content_list = $('span#DownloadableLink');
        for (var i = 0; i < content_list.length; i++) {
            var preview = $(content_list[i]).attr('rel');
            if (!preview) {
                $(content_list[i]).attr('rel', 'preview');
                var element = $(content_list[i]);
                var a = element.children('a[onclick^="Javascript:"]');
                var click = a.attr('onclick');
                var href = a.attr('href');
                $('i.fa-download').addClass("hide");
                element.prepend(self.previewIcon(content_list[i], href));
            }
        }
    },
    registerDocHome: function () {
        var self = PreviewDoc_Js;
        var content_list = $('.dashboardWidget a[href^="index.php?module=Documents&view=Detail"]');
        if (content_list.length > 0) {
            for (var i = 0; i < content_list.length; i++) {
                var element = $(content_list[i]).parent('div');
                var a = $(content_list[i]);
                var preview = a.attr('rel');
                if (!preview) {
                    a.attr('rel', 'preview');
                    var href = a.attr('href');
                    $('i.fa-download').addClass("hide");
                    element.html(self.previewIconHome(content_list[i], href) + filename).prepend(a);
                }
            }
        }
    },
    downloadIcon: function (element, click, href) {
        element = $(element);
        return '<a class="PreviewDoc" style="padding: 0 2px;" onclick="' + click + '" href="' + href + '" title="Download"><i class="fa fa-cloud-download" title="Download"></i></a>';
    },
    downloadIconHome: function (element, href) {
        var self = PreviewDoc_Js;
        element = $(element);
        var parseLink = self.parseLink(href);
        href = "index.php?module=PreviewDoc&action=DownloadFile&record=" + parseLink.record;
        if (parseLink.record == '') {
            return '';
        }
        return '<a class="PreviewDocHome" style="padding: 0 2px;" onclick="PreviewDoc_Js.DownloadFile(event);return false;" href="' + href + '" title="Download"><i class="fa fa-cloud-download" title="Download"></i></a>';
    },
    previewIcon: function (element, href) {
        var self = PreviewDoc_Js;
        element = $(element);
        var data = self.parseLink(href);

        href = 'index.php?module=PreviewDoc&action=Preview&' + data.url + '';
        if (data.url == '') {
            return '';
        }
        return '<a class="PreviewDoc" style="padding: 0 2px 0 0;" data-record="' + data.record + '" data-fileid="' + data.fileid + '" onclick="PreviewDoc_Js.eventPreviewFile(event);return false;" href="' + href + '" title="Preview"><i class="fa fa-picture-o" title="Preview"></i></a>';
    },
    previewIconHome: function (element, href) {
        var self = PreviewDoc_Js;
        element = $(element);
        var data = self.parseLink(href);

        href = 'index.php?module=PreviewDoc&action=Preview&' + data.url + '';
        if (data.url == '') {
            return '';
        }
        return '<a class="PreviewDoc" style="padding: 0 2px 0 0;" data-record="' + data.record + '" onclick="PreviewDoc_Js.eventPreviewFile(event);return false;" href="' + href + '" title="Preview"><i class="fa fa-picture-o" title="Preview"></i></a>';
    },
    parseLink: function (href) {
        if (typeof (href) == "undefined") {
            return {'url': '', 'record': '', 'fileid': ''};
        } else {
            href = href.split('?');
            href = href[1];
            href = href.split('&');
        }
        var record, fileid;
        var record, fileid;
        for (var i = 0; i < href.length; i++) {
            var _href = href[i];
            _href = _href.split('=');
            if (_href[0] === 'record') {
                record = _href[1];
            }
            if (_href[0] === 'fileid') {
                fileid = _href[1];
            }
        }
        var _return = {'url': 'record=' + record + '&fileid=' + fileid, 'record': record, 'fileid': fileid};
        return _return;
    },
    eventPreviewFile: function (e) {
        var self = PreviewDoc_Js;
        e.stopPropagation();
        e.preventDefault();
        var obj = jQuery(e.currentTarget);
        self.checkType(obj);
    },
    checkType: function (obj) {
        var self = PreviewDoc_Js;
        var post = {
            "data": {
                module: "PreviewDoc",
                action: "CheckType",
                fileid: obj.data('fileid'),
                record: obj.data('record')
            }, dataType: 'json'
        };
        AppConnector.request(post).then(function (responce) {
            if (responce.success === true) {
                var type = responce.result.type;
                if (type == "MS") {
                    var dataType = "json";
                    var show = responce.result.show;
                } else {
                    var dataType = "html";
                }
                var height = document.documentElement.clientHeight - 100;
                var post = {
                    "data": {
                        'module': "PreviewDoc",
                        'action': "Preview",
                        'fileid': obj.data('fileid'),
                        'record': obj.data('record'),
                        'type': type,
                        'height': height
                    }, "dataType": dataType
                };
                AppConnector.request(post).then(function (data) {
                    if (type == "MS") {
                        if (show == "SHOW") {
                            bootbox.confirm('<div"><h5> ' +
                                'Preview of MS Office docs launching through https://view.officeapps.live.com' +
                                '</h5></div><div > <br /> ' +
                                '<input type="checkbox" onclick="PreviewDoc_Js.showWarning(this)" /><label style="display:inline;margin-left:3px">' +
                                'Don`t show again' +
                                '</label><br /></div>',
                                function (result) {
                                    if (result === true) {
                                        self.previewMS(data.result);
                                    }
                                });
                        } else {
                            self.previewMS(data.result);
                        }
                    } else {
                        var popUp = {"data": data, "css": {"width": "85%", "height": "auto"}};
                        app.showModalWindow(popUp);
                    }
                });
            } else {
                var _params = {
                    title: 'Error',
                    text: responce.error.message,
                    animation: 'show',
                    type: 'error'
                }
                Magsoft_Helper_Js.showPnotify(_params);
            }
        });

    },
    previewMS: function (link) {

        var ws = parseInt(jQuery(window).width() * 0.85);
        var hs = parseInt(jQuery(window).height() * 0.85);
        var parametr = "menubar=no,toolbar=no,location=no,directories=no,resizable=yes,scrollbars=yes,width=" + ws + ",height=" + hs;
        var c = window.open(link, 'MS', parametr);
        c.focus();
    },
    showWarning: function (element) {
        var self = PreviewDoc_Js;
        if (jQuery(element).prop("checked")) {
            self.saveDontShowWarning();
        } else {
            self.saveShowWarning();
        }
    },
    saveShowWarning: function () {
        post = {"data": {module: "PreviewDoc", action: "Setting", show: "SHOW", dataType: 'json'}};
        AppConnector.request(post);
    },
    saveDontShowWarning: function () {
        post = {"data": {module: "PreviewDoc", action: "Setting", show: "NONE", dataType: 'json'}};
        AppConnector.request(post);
    },
}

$(document).ready(function () {
    var MutationObserver = window.MutationObserver || window.WebKitMutationObserver || window.MozMutationObserver;
    var module = jQuery('#module').val();
    var view = jQuery('#view').val();
    var relatedModule = jQuery('input[name="relatedModuleName"]').val();
    if (module === "Documents") {
        if (view === "List") {
            PreviewDoc_Js.registerDoc();
            var target = document.querySelector('#listViewContents');
            var observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    PreviewDoc_Js.registerDoc();
                });
            });
            var config = {childList: true};
            observer.observe(target, config);
        }
        if (view === "Detail") {
            PreviewDoc_Js.registerDocdetail();
            var target = document.querySelector('#detailView');
            var observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    PreviewDoc_Js.registerDocdetail();
                });
            });
            var config = {childList: true};
            observer.observe(target, config);
        }
    } else if (relatedModule === "Documents") {
        PreviewDoc_Js.registerDoc();
        var target = document.querySelector('.contents');
        var observer = new MutationObserver(function (mutations) {
            mutations.forEach(function (mutation) {
                PreviewDoc_Js.registerDoc();
                if (jQuery("div").is(".widgetContainer_documents")) {
                    jQuery('.widget_contents').on("Magsoft.Widget.PostLoad", function () {
                        PreviewDoc_Js.registerDocWidget();
                    });
                }
            });
        });
        var config = {childList: true};
        observer.observe(target, config);
    } else {
        if (jQuery("div").is(".contents")) {
            var target = document.querySelector('.contents');
            var observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    PreviewDoc_Js.registerDoc();
                    if (jQuery("div").is(".widgetContainer_documents")) {
                        jQuery('.widget_contents').on("Magsoft.Widget.PostLoad", function () {
                            PreviewDoc_Js.registerDocWidget();
                        });
                    }
                });
            });
            var config = {childList: true};
            observer.observe(target, config);
        }
    }
    if (jQuery("div").is(".widgetContainer_documents")) {
        jQuery('.widget_contents').on("Magsoft.Widget.PostLoad", function () {
            PreviewDoc_Js.registerDocWidget();
        });
    }
});