{*<!--/************************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/-->*}

{strip}
<div>
    <br>
	<form action="javascript:void(0);" method="POST" id="EditView">
        <div class="row-fluid">
            <div class="span6">
                <h3 class="title widgetTextOverflowEllipsis">{vtranslate('JSLBL_Settings',$MODULE)}</h3>
            </div>

            {if $MAILBOX && $MAILBOX->exists()}
            <div class="span6">
                <div class="pull-right">
                    <button class="btn edit" onclick="MailManager.open_settings()"><strong>{vtranslate('LBL_EDIT',$MODULE)}</strong></button>&nbsp;
                    <button class="btn btn-danger" onclick="MailManager.remove_settings(this.form);"><strong>{vtranslate('LBL_DELETE_Mailbox',$MODULE)}</strong></button>
                </div>
            </div>
            {/if}
        </div>
		<hr>
		{if $MAILBOX && $MAILBOX->exists()}
			<table class="table table-bordered blockContainer showInlineTable">
				<thead>
					<tr>
						<th class="blockHeader" colspan="4">{vtranslate('LBL_MAILBOX_DETAILS', $MODULE)}</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td class="fieldLabel">
							<label class="muted pull-right">{vtranslate('LBL_ACCOUNT_TYPE',$MODULE)}</label>
						</td>
						<td class="fieldValue narrowWidthType" style="width: 70%;">
							<div>
								{if $SERVERNAME eq 'gmail'}
									{vtranslate('JSLBL_Gmail',$MODULE)}
								{elseif $SERVERNAME eq 'yahoo'}
									{vtranslate('JSLBL_Yahoo',$MODULE)}
								{elseif $SERVERNAME eq 'fastmail'}
									{vtranslate('JSLBL_Fastmail',$MODULE)}
								{elseif $SERVERNAME eq 'other'}
									{vtranslate('JSLBL_Other',$MODULE)}
								{/if}
							</div>
						</td>
					</tr>
					<tr>
						<td class="fieldLabel">
							<label class="muted pull-right">{vtranslate('LBL_Mail_Server',$MODULE)}</label>
						</td>
						<td class="fieldValue narrowWidthType" style="width: 70%;">
							<div>{$MAILBOX->server()}</div>
						</td>
					</tr>
					<tr>
						<td class="fieldLabel">
							<label class="muted pull-right">{vtranslate('LBL_Username',$MODULE)}</label>
						</td>
						<td class="fieldValue narrowWidthType" style="width: 70%;">
							<div>{$MAILBOX->username()}</div>
						</td>
					</tr>
					<tr>
						<td class="fieldLabel">
							<label class="muted pull-right">{vtranslate('LBL_REFRESH_TIME',$MODULE)}</label>
						</td>
						<td class="fieldValue narrowWidthType" style="width: 70%;">
							<div>
								{if strcasecmp($MAILBOX->refreshTimeOut(), '300000')==0}
									{vtranslate('LBL_5_MIN',$MODULE)}
								{elseif strcasecmp($MAILBOX->refreshTimeOut(), '600000')==0}
									{vtranslate('LBL_10_MIN',$MODULE)}
								{else}
									{vtranslate('LBL_NONE',$MODULE)}
								{/if}
							</div>
						</td>
					</tr>
                    <tr>
						<td class="fieldLabel">
							<label class="muted pull-right">{vtranslate('LBL_SELECTED_FOLDER',$MODULE)}</label>
						</td>
						<td class="fieldValue narrowWidthType" style="width: 70%;">
							<div>{$MAILBOX->folder()}</div>
						</td>
					</tr>
				</tbody>
			</table>
		{else}
		<br>
			<div class="well">
				<center>
					<br>
					<img src="layouts/vlayout/skins/images/mail_manager_banner.jpg">
					<br>
					<div>{vtranslate('LBL_MODULE_DESCRIPTION',$MODULE)}</div>
					<br>
					<br>
					<a href="javascript:;" onclick="MailManager.open_settings();">
						<u class="cursorPointer color-blue" style="font-size:14px; padding:4px 10px;">{vtranslate('LBL_CREATE_MAILBOX', $MODULE)}</u>
					</a>
					<br>
					<br>
					<br>
				</center>
			</div>
		{/if}
	</form>
</div>
{/strip}