{*<!--/************************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/-->*}

{strip}
    {if $FOLDERS}
        <div id="foldersList" class="row-fluid">
            <div>
                {assign var=INBOX_ADDED value=0}
                {assign var=TRASH_ADDED value=0}
                {assign var=DRAFTS_ADDED value=0}
                {assign var=SPAM_ADDED value=0}
                {assign var=ARCHIVE_ADDED value=0}
                {assign var=SENT_ADDED value=0}
                <ul class="nav nav-list">
                    {foreach item=FOLDER from=$FOLDERS}
                        {if stripos($FOLDER->name(), 'inbox') !== false && $INBOX_ADDED == 0}
                            {assign var=INBOX_ADDED value=1}
                            {assign var=INBOX_FOLDER value=$FOLDER->name()}
                            <li class="cursorPointer mm_folder mmMainFolder" data-foldername="{$FOLDER->name()}">
                                <a class="mm_folder" id='_mailfolder_{$FOLDER->name()}' href='#{$FOLDER->name()}' onclick="MailManager.clearSearchString(); MailManager.folder_open('{$FOLDER->name()}'); ">
                                    <i class="fa fa-inbox" aria-hidden="true"></i>&nbsp;&nbsp;
                                    <b>{vtranslate('LBL_INBOX', $MODULE)}</b>
                                    <span class="pull-right mmUnreadCountBadge color-red{if !$FOLDER->unreadCount()} hide{/if}">
                                        {$FOLDER->unreadCount()}
                                    </span>
                                </a>
                            </li>
                        {/if}
                    {/foreach}
                    {foreach item=FOLDER from=$FOLDERS}
                        {if stripos($FOLDER->name(), 'drafts') !== false && $DRAFTS_ADDED == 0}
                            {assign var=DRAFTS_ADDED value=1}
                            {assign var=DRAFTS_FOLDER value=$FOLDER->name()}
                            <li class="cursorPointer mm_folder mmMainFolder" data-foldername="INBOX.Drafts">
                                <a class="mm_folder" id="_mailfolder_mm_drafts" onclick="MailManager.folder_drafts(0);">
                                    <i class="fa fa-floppy-o" aria-hidden="true"></i>&nbsp;&nbsp;
                                    <b>{vtranslate('LBL_Drafts', $MODULE)}</b>
                                </a>
                            </li>
                        {/if}
                    {/foreach}
                    {foreach item=FOLDER from=$FOLDERS}
                        {if $FOLDER->isSentFolder() && $SENT_ADDED == 0}
                        {*{if stripos($FOLDER->name(), 'sent') !== false && $SENT_ADDED == 0}*}
                            {assign var=SENT_ADDED value=1}
                            {assign var=SENT_FOLDER value=$FOLDER->name()}
                            <li class="cursorPointer mm_folder mmMainFolder" data-foldername="{$FOLDER->name()}">
                                <a class="mm_folder" id='_mailfolder_{$FOLDER->name()}' href='#{$FOLDER->name()}' onclick="MailManager.clearSearchString(); MailManager.folder_open('{$FOLDER->name()}'); ">
                                    <i class="fa fa-paper-plane" aria-hidden="true"></i>&nbsp;&nbsp;
                                    <b>{vtranslate('LBL_SENT', $MODULE)}</b>
                                    <span class="pull-right mmUnreadCountBadge color-red{if !$FOLDER->unreadCount()} hide{/if}">
                                        {$FOLDER->unreadCount()}
                                    </span>
                                </a>
                            </li>
                        {/if}
                    {/foreach}
                    {foreach item=FOLDER from=$FOLDERS}
                        {if stripos($FOLDER->name(), 'trash') !== false && $TRASH_ADDED == 0}
                            {assign var=TRASH_ADDED value=1}
                            {assign var=TRASH_FOLDER value=$FOLDER->name()}
                            <li class="cursorPointer mm_folder mmMainFolder" data-foldername="{$FOLDER->name()}">
                                <a class="mm_folder" id='_mailfolder_{$FOLDER->name()}' href='#{$FOLDER->name()}' onclick="MailManager.clearSearchString(); MailManager.folder_open('{$FOLDER->name()}'); ">
                                    <i class="fa fa-trash-o" aria-hidden="true"></i>&nbsp;&nbsp;
                                    <b>{vtranslate('LBL_TRASH', $MODULE)}</b>
                                    <span class="pull-right mmUnreadCountBadge color-red{if !$FOLDER->unreadCount()} hide{/if}">
                                        {$FOLDER->unreadCount()}
                                    </span>
                                </a>
                            </li>
                        {/if}
                    {/foreach}
                    {foreach item=FOLDER from=$FOLDERS}
                        {if stripos($FOLDER->name(), 'spam') !== false && $SPAM_ADDED == 0}
                            {assign var=SPAM_ADDED value=1}
                            {assign var=SPAM_FOLDER value=$FOLDER->name()}
                            <li class="cursorPointer mm_folder mmMainFolder" data-foldername="{$FOLDER->name()}">
                                <a class="mm_folder" id='_mailfolder_{$FOLDER->name()}' href='#{$FOLDER->name()}' onclick="MailManager.clearSearchString(); MailManager.folder_open('{$FOLDER->name()}'); ">
                                    <i class="fa fa-shield" aria-hidden="true"></i>&nbsp;&nbsp;
                                    <b>{vtranslate('LBL_SPAM', $MODULE)}</b>
                                    <span class="pull-right mmUnreadCountBadge color-red{if !$FOLDER->unreadCount()} hide{/if}">
                                        {$FOLDER->unreadCount()}
                                    </span>
                                </a>
                            </li>
                        {/if}
                    {/foreach}
                    {foreach item=FOLDER from=$FOLDERS}
                        {if stripos($FOLDER->name(), 'archive') !== false && $ARCHIVE_ADDED == 0}
                            {assign var=ARCHIVE_ADDED value=1}
                            {assign var=ARCHIVE_FOLDER value=$FOLDER->name()}
                            <li class="cursorPointer mm_folder mmMainFolder" data-foldername="{$FOLDER->name()}">
                                <a class="mm_folder" id='_mailfolder_{$FOLDER->name()}' href='#{$FOLDER->name()}' onclick="MailManager.clearSearchString(); MailManager.folder_open('{$FOLDER->name()}'); ">
                                    <i class="fa fa-file-archive-o" aria-hidden="true"></i>&nbsp;&nbsp;
                                    <b>{vtranslate('LBL_ARCHIVE', $MODULE)}</b>
                                    <span class="pull-right mmUnreadCountBadge color-red{if !$FOLDER->unreadCount()} hide{/if}">
                                        {$FOLDER->unreadCount()}
                                    </span>
                                </a>
                            </li>
                        {/if}
                    {/foreach}
                    {*<br>
                    <span class="padding15px"><b>{vtranslate('LBL_Folders', $MODULE)}</b></span>*}

                    {assign var=IGNORE_FOLDERS value=array($INBOX_FOLDER, $SENT_FOLDER, $TRASH_FOLDER, $DRAFTS_FOLDER, $SPAM_FOLDER, $ARCHIVE_FOLDER)}
                    {foreach item=FOLDER from=$FOLDERS}
                        {if !in_array($FOLDER->name(), $IGNORE_FOLDERS)}
                            <li class="cursorPointer mm_folder mmOtherFolder" data-foldername="{$FOLDER->name()}">
                                <a class="mm_folder" id='_mailfolder_{$FOLDER->name()}' href='#{$FOLDER->name()}' onclick="MailManager.clearSearchString(); MailManager.folder_open('{$FOLDER->name()}'); ">
                                    <b>{$FOLDER->name()}</b>
                                    <span class="pull-right mmUnreadCountBadge color-red{if !$FOLDER->unreadCount()} hide{/if}">
                                        {$FOLDER->unreadCount()}
                                    </span>
                                </a>
                            </li>
                        {/if}
                    {/foreach}
                </ul>
            </div>
        </div>
    {/if}
{/strip}