{*<!--
/*********************************************************************************
  ** The contents of this file are subject to the magsoft CRM Public License Version 1.0
   * ("License"); You may not use this file except in compliance with the License
   * The Original Code is:  magsoft CRM Software
   * The Initial Developer of the Original Code is magsoft.
   * Portions created by magsoft are Copyright (C) magsoft.
   * All Rights Reserved.
  *
 ********************************************************************************/
-->*}
{strip}
    {if $MODULE_NAME eq 'Webforms'}
        <input type="text" readonly=""/>
    {else}
        {assign var="FIELD_INFO" value=Magsoft_Util_Helper::toSafeHTML(Zend_Json::encode($FIELD_MODEL->getFieldInfo()))}
        {assign var="SPECIAL_VALIDATOR" value=$FIELD_MODEL->getValidator()}
        <div class="input-group">
            <span class="input-group-btn tooltip-top" data-tooltip="{$MAX_UPLOAD_LIMIT_MB}{vtranslate('MB',$MODULE)} max">
                <span class="btn btn-success btn-file">
                    <i class="fa fa-picture-o" aria-hidden="true"></i>
                    <input type="file" class="input-large" {if $MODULE eq 'Products' || $MODULE eq 'HelpDesk'} multiple maxlength="6" {/if} name="{$FIELD_MODEL->getFieldName()}[]" value="{$FIELD_MODEL->get('fieldvalue')}"
                           data-validation-engine="validate[{if ($FIELD_MODEL->isMandatory() eq true) and (empty($IMAGE_DETAILS))} required,{/if}funcCall[Magsoft_Base_Validator_Js.invokeValidation]]"
                           data-fieldinfo='{$FIELD_INFO}' {if !empty($SPECIAL_VALIDATOR)}data-validator={Zend_Json::encode($SPECIAL_VALIDATOR)}{/if}/>
                </span>
            </span>
            <input type="text" class="form-control" readonly>
        </div>
        {if $MODULE eq 'Products' || $MODULE eq 'HelpDesk'}
            <div id="MultiFile1_wrap_list" class="MultiFile-list"></div>
        {/if}
        <div>
            {foreach key=ITER item=IMAGE_INFO from=$IMAGE_DETAILS}
                {if !empty($IMAGE_INFO.path) && !empty({$IMAGE_INFO.orgname})}
                    <div class="col-md-6" style="margin:10px 0 0 10px; padding:10px 10px 6px !important; background-color:#ffffff; border-radius:2px; border:1px solid #dddddd; width:unset;">
                        <span name="existingImages"><a href="{$IMAGE_INFO.path}_{$IMAGE_INFO.orgname}" data-lightbox="imagegallery" data-title="{$IMAGE_INFO.orgname}"><img style="max-height: 90px;" src="{$IMAGE_INFO.path}_{$IMAGE_INFO.orgname}" data-image-id="{$IMAGE_INFO.id}"></a></span>
                        <span class="row-fluid">
                        <span class="row-fluid imagename">[{$IMAGE_INFO.name}]</span>
                        <hr>
                        <span class="row-fluid"><input type="button" id="file_{$ITER}" value="{vtranslate('LBL_DELETE',$QUALIFIED_MODULE)}" class="imageDelete btn btn-mini btn-danger" style="width: 100%"></span>
                        </span>
                    </div>
                {/if}
            {/foreach}
        </div>
    {/if}
{/strip}