{************************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************}
<div style="padding:5px 20px;">
    {* Comupte the nubmer of columns required *}
    {assign var="SPANSIZE" value=12}
    {if $MINILIST_WIDGET_MODEL->getHeaderCount()}
        {assign var="SPANSIZE" value=12/$MINILIST_WIDGET_MODEL->getHeaderCount()}
    {/if}
    <div class="row-fluid" style="margin-bottom:6px; padding-bottom:6px; border-bottom: 1px dashed #dddddd;">
        {foreach item=FIELD from=$MINILIST_WIDGET_MODEL->getHeaders()}
            <div class="span{$SPANSIZE}"><strong>{vtranslate($FIELD->get('label'),$BASE_MODULE)}</strong></div>
        {/foreach}
    </div>
    {assign var="MINILIST_WIDGET_RECORDS" value=$MINILIST_WIDGET_MODEL->getRecords()}

    {foreach item=RECORD from=$MINILIST_WIDGET_RECORDS}
        <div class="row-fluid" style="padding:10px 0; border-bottom:1px solid #eeeeee;">
            {foreach item=FIELD from=$MINILIST_WIDGET_MODEL->getHeaders() name="minilistWidgetModelRowHeaders"}
                <div class="span{$SPANSIZE} textOverflowEllipsis" style="overflow: visible;" title="{strip_tags($RECORD->get($FIELD->get('name')))}">
                    {if $smarty.foreach.minilistWidgetModelRowHeaders.last}
                        <a href="{$RECORD->getDetailViewUrl()}" class="pull-right tooltip-left" data-tooltip="{vtranslate('LBL_SHOW_COMPLETE_DETAILS',$MODULE_NAME)}"><i class="fa fa-chevron-right" title="{vtranslate('LBL_SHOW_COMPLETE_DETAILS',$MODULE_NAME)}"></i></a>
                    {/if}
                    <a href="{$RECORD->getDetailViewUrl()}">{strip_tags($RECORD->get($FIELD->get('name')))}</a>
                </div>
            {/foreach}
        </div>
    {/foreach}

    {if count($MINILIST_WIDGET_RECORDS) >= $MINILIST_WIDGET_MODEL->getRecordLimit()}
        <div class="row-fluid" style="padding:5px 15px 15px 0">
            <a class="pull-right" href="index.php?module={$MINILIST_WIDGET_MODEL->getTargetModule()}&view=List&mode=showListViewRecords&viewname={$WIDGET->get('filterid')}">{vtranslate('LBL_ALL_RECORDS')}
                <i class="fa fa-angle-double-right"></i></a>
        </div>
    {/if}
</div>