{*<!--
/*********************************************************************************
  ** The contents of this file are subject to the magsoft CRM Public License Version 1.0
   * ("License"); You may not use this file except in compliance with the License
   * The Original Code is:  magsoft CRM Software
   * The Initial Developer of the Original Code is magsoft.
   * Portions created by magsoft are Copyright (C) magsoft.
   * All Rights Reserved.
  *
 ********************************************************************************/
-->*}
{strip}
    <div style='padding:5px 20px;'>
    {if $HISTORIES neq false}
        {foreach key=$index item=HISTORY from=$HISTORIES}
            {assign var=MODELNAME value=get_class($HISTORY)}
            {if $MODELNAME == 'ModTracker_Record_Model'}
                {assign var=USER value=$HISTORY->getModifiedBy()}
                {assign var=TIME value=$HISTORY->getActivityTime()}
                {assign var=PARENT value=$HISTORY->getParent()}
                {assign var=MOD_NAME value=$HISTORY->getParent()->getModule()->getName()}
                {assign var=SINGLE_MODULE_NAME value='SINGLE_'|cat:$MOD_NAME}
                {assign var=TRANSLATED_MODULE_NAME value = vtranslate($SINGLE_MODULE_NAME ,$MOD_NAME)}
                {assign var=PROCEED value= TRUE}
                {if ($HISTORY->isRelationLink()) or ($HISTORY->isRelationUnLink())}
                    {assign var=RELATION value=$HISTORY->getRelationInstance()}
                    {if !($RELATION->getLinkedRecord())}
                        {assign var=PROCEED value= FALSE}
                    {/if}
                {/if}
                {if $PROCEED}
                    <div class="row-fluid" style='border-bottom:1px solid #eeeeee;padding:10px 0;'>
                        <div class="span1">
                            <icon style="line-height: 26px;" id="module_icon_{$MOD_NAME}" class="module_icon_default" alt="{$TRANSLATED_MODULE_NAME}" title="{$TRANSLATED_MODULE_NAME}"></icon>
                            {*<img width='20px' src="{vimage_path($MOD_NAME|cat:'.png')}" alt="{$TRANSLATED_MODULE_NAME}" title="{$TRANSLATED_MODULE_NAME}" />&nbsp;&nbsp;*}
                        </div>
                        <div class="span11">
                            <p class="pull-right muted" style="padding-right:5px; margin-bottom:0; margin-top:3px">
                                <small class="tooltip-left" data-tooltip='{Magsoft_Util_Helper::formatDateTimeIntoDayString("$TIME")}' title='{Magsoft_Util_Helper::formatDateTimeIntoDayString("$TIME")}'>
                                    <i class="fa fa-history" style="cursor:default;"></i> {Magsoft_Util_Helper::formatDateDiffInStrings("$TIME")}
                                </small>
                            </p>
                            {assign var=DETAILVIEW_URL value=$PARENT->getDetailViewUrl()}
                            {if $HISTORY->isUpdate()}
                                {assign var=FIELDS value=$HISTORY->getFieldInstances()}
                                <div>
                                    <div><b>{$USER->getName()}</b> {vtranslate('LBL_UPDATED')}&nbsp;-&nbsp;
                                        <a class="cursorPointer" {if stripos($DETAILVIEW_URL, 'javascript:')===0} onclick='{$DETAILVIEW_URL|substr:strlen("javascript:")}' {else} onclick='window.location.href="{$DETAILVIEW_URL}"' {/if}>
                                            {$PARENT->getName()}
                                        </a>
                                    </div>
                                    {foreach from=$FIELDS key=INDEX item=FIELD}
                                        {if $INDEX lt 2}
                                            {if $FIELD && $FIELD->getFieldInstance() && $FIELD->getFieldInstance()->isViewableInDetailView()}
                                                <div class='font-x-small'>
                                                    {vtranslate($FIELD->getName(), $FIELD->getModuleName())}
                                                    &nbsp;
                                                    <i class="fa fa-angle-right" style="cursor:default;"></i>
                                                    &nbsp;
                                                    {if $FIELD->get('prevalue') neq '' && $FIELD->get('postvalue') neq '' && !($FIELD->getFieldInstance()->getFieldDataType() eq 'reference' && ($FIELD->get('postvalue') eq '0' || $FIELD->get('prevalue') eq '0'))}
                                                        {vtranslate('LBL_FROM')}
                                                        &nbsp;
                                                        {if $FIELD->get('prevalue')|strstr:'data:image/png;base64'}
                                                            <br><img style="max-width: 220px;" src="{$FIELD->get('prevalue')}">
                                                        {else}
                                                            <b>{Magsoft_Util_Helper::toMagsoft7SafeHTML($FIELD->getDisplayValue(decode_html($FIELD->get('prevalue'))))}</b>
                                                        {/if}
                                                    {elseif $FIELD->get('postvalue') eq '' || ($FIELD->getFieldInstance()->getFieldDataType() eq 'reference' && $FIELD->get('postvalue') eq '0')}
                                                        <b>{vtranslate('LBL_DELETED')}</b>
                                                        &nbsp;
                                                        ( <del>{Magsoft_Util_Helper::toMagsoft7SafeHTML($FIELD->getDisplayValue(decode_html($FIELD->get('prevalue'))))}</del> )
                                                    {else}
                                                        {vtranslate('LBL_CHANGED')}
                                                    {/if}
                                                    {if $FIELD->get('postvalue') neq '' && !($FIELD->getFieldInstance()->getFieldDataType() eq 'reference' && $FIELD->get('postvalue') eq '0')}
                                                        &nbsp;
                                                        {vtranslate('LBL_TO')}
                                                        &nbsp;
                                                        {if $FIELD->get('postvalue')|strstr:'data:image/png;base64'}
                                                            <img style="max-width: 220px;" src="{$FIELD->get('postvalue')}">
                                                        {else}
                                                            <b>{Magsoft_Util_Helper::toMagsoft7SafeHTML($FIELD->getDisplayValue(decode_html($FIELD->get('postvalue'))))}</b>
                                                        {/if}
                                                    {/if}
                                                </div>
                                            {/if}
                                        {else}
                                            <a href="{$PARENT->getUpdatesUrl()}">{vtranslate('LBL_MORE')}</a>
                                            {break}
                                        {/if}
                                    {/foreach}
                                </div>
                            {elseif $HISTORY->isCreate()}
                                <div style='margin-top:3px'>
                                    <b>{$USER->getName()}</b> {vtranslate('LBL_ADDED')}&nbsp;-&nbsp;
                                    <a class="cursorPointer" {if stripos($DETAILVIEW_URL, 'javascript:')===0}
                                        onclick='{$DETAILVIEW_URL|substr:strlen("javascript:")}' {else} onclick='window.location.href="{$DETAILVIEW_URL}"' {/if}>
                                        {$PARENT->getName()}</a>
                                </div>
                            {elseif ($HISTORY->isRelationLink() || $HISTORY->isRelationUnLink())}
                                {assign var=RELATION value=$HISTORY->getRelationInstance()}
                                {assign var=LINKED_RECORD_DETAIL_URL value=$RELATION->getLinkedRecord()->getDetailViewUrl()}
                                {assign var=PARENT_DETAIL_URL value=$RELATION->getParent()->getParent()->getDetailViewUrl()}
                                <div style='margin-top:3px'>
                                    <b>{$USER->getName()}</b>
                                    {if $HISTORY->isRelationLink()}
                                        &nbsp;
                                        {vtranslate('LBL_ADDED', $MODULE_NAME)}
                                    {else}
                                        &nbsp;
                                        {vtranslate('LBL_REMOVED', $MODULE_NAME)}
                                    {/if}
                                    {if $RELATION->getLinkedRecord()->getModuleName() eq 'Calendar'}
                                        {if isPermitted('Calendar', 'DetailView', $RELATION->getLinkedRecord()->getId()) eq 'yes'}
                                            &nbsp;-&nbsp;
                                            <a class="cursorPointer" {if stripos($LINKED_RECORD_DETAIL_URL, 'javascript:')===0} onclick='{$LINKED_RECORD_DETAIL_URL|substr:strlen("javascript:")}'
                                                    {else} onclick='window.location.href="{$LINKED_RECORD_DETAIL_URL}"' {/if}>{$RELATION->getLinkedRecord()->getName()}</a>
                                        {else}
                                            &nbsp;
                                            {vtranslate($RELATION->getLinkedRecord()->getModuleName(), $RELATION->getLinkedRecord()->getModuleName())}
                                        {/if}
                                    {else}
                                        &nbsp;
                                        <a class="cursorPointer" {if stripos($LINKED_RECORD_DETAIL_URL, 'javascript:')===0} onclick='{$LINKED_RECORD_DETAIL_URL|substr:strlen("javascript:")}'
                                                {else} onclick='window.location.href="{$LINKED_RECORD_DETAIL_URL}"' {/if}>{$RELATION->getLinkedRecord()->getName()}</a>
                                    {/if}
                                    &nbsp;
                                    {vtranslate('LBL_FOR')}&nbsp;-&nbsp;
                                    <a class="cursorPointer" {if stripos($PARENT_DETAIL_URL, 'javascript:')===0}
                                        onclick='{$PARENT_DETAIL_URL|substr:strlen("javascript:")}' {else} onclick='window.location.href="{$PARENT_DETAIL_URL}"' {/if}>
                                        {$RELATION->getParent()->getParent()->getName()}</a>
                                </div>
                            {elseif $HISTORY->isRestore()}
                                <div style='margin-top:3px'>
                                    <b>{$USER->getName()}</b> {vtranslate('LBL_RESTORED')}&nbsp;-&nbsp;
                                    <a class="cursorPointer" {if stripos($DETAILVIEW_URL, 'javascript:')===0}
                                        onclick='{$DETAILVIEW_URL|substr:strlen("javascript:")}' {else} onclick='window.location.href="{$DETAILVIEW_URL}"' {/if}>
                                        {$PARENT->getName()}</a>
                                </div>
                            {elseif $HISTORY->isDelete()}
                                <div style='margin-top:3px'>
                                    <b>{$USER->getName()}</b> {vtranslate('LBL_DELETED')}&nbsp;-&nbsp;
                                    <a class="cursorPointer" {if stripos($DETAILVIEW_URL, 'javascript:')===0}
                                        onclick='{$DETAILVIEW_URL|substr:strlen("javascript:")}' {else} onclick='window.location.href="{$DETAILVIEW_URL}"' {/if}>
                                        {$PARENT->getName()}</a>
                                </div>
                            {/if}
                        </div>
                    </div>
                {/if}
            {elseif $MODELNAME == 'ModComments_Record_Model'}
                <div class="row-fluid" style='border-bottom:1px solid #eeeeee;padding:10px 0;'>
                    <div class="span1">
                        <icon style="line-height: 26px;" id="module_icon_ModComments"></icon>
                        {*<image width='20px' src="{vimage_path('Comments.png')}"/>&nbsp;&nbsp;*}
                    </div>
                    <div class="span11">
                        {assign var=COMMENT_TIME value=$HISTORY->getCommentedTime()}
                        <p class="pull-right muted" style="padding-right:5px; margin-bottom:0; margin-top:3px;">
                            <small class="tooltip-left" data-tooltip="{Magsoft_Util_Helper::formatDateTimeIntoDayString("$COMMENT_TIME")}" title="{Magsoft_Util_Helper::formatDateTimeIntoDayString("$COMMENT_TIME")}">
                                <i class="fa fa-history" style="cursor:default;"></i> {Magsoft_Util_Helper::formatDateDiffInStrings("$COMMENT_TIME")}
                            </small>
                        </p>
                        <div>
                            <b>{$HISTORY->getCommentedByModel()->getName()}</b> {vtranslate('LBL_COMMENTED')} {vtranslate('LBL_ON')}&nbsp;-&nbsp;
                            <a class="textOverflowEllipsis" href="{$HISTORY->getParentRecordModel()->getDetailViewUrl()}">{$HISTORY->getParentRecordModel()->getName()}</a>
                        </div>
                        <div class='font-x-small'>"{nl2br($HISTORY->get('commentcontent'))}"</div>
                    </div>
                </div>
            {/if}
        {/foreach}
        </div>
        {if $NEXTPAGE}
            <span>
			<a href="javascript:;" class="load-more textAlignCenter pull-right" style="min-width: 90px;" data-page="{$PAGE}" data-nextpage="{$NEXTPAGE}">{vtranslate('LBL_MORE')}
                &nbsp;<i class="fa fa-angle-double-down"></i></a>
	</span>
        {/if}
    {else}
        <span class="noDataMsg tooltip-top" data-tooltip="{vtranslate('LBL_NO_UPDATES_OR_COMMENTS', $MODULE_NAME)}">
		<i class="fa fa-inbox fa-5x" style="cursor:default;" title="{vtranslate('LBL_NO_UPDATES_OR_COMMENTS', $MODULE_NAME)}"></i>
	</span>
    {/if}
{/strip}