{*<!--
/*********************************************************************************
  ** The contents of this file are subject to the magsoft CRM Public License Version 1.0
   * ("License"); You may not use this file except in compliance with the License
   * The Original Code is:  magsoft CRM Software
   * The Initial Developer of the Original Code is magsoft.
   * Portions created by magsoft are Copyright (C) magsoft.
   * All Rights Reserved.
  *
 ********************************************************************************/
-->*}
{strip}
    {if $MODULE eq 'Home'}
        <div class="row_dash animated fadeInDown">
            {assign var="topMenus" value=$MENU_STRUCTURE->getTop()}
            {foreach key=moduleName item=moduleModel from=$topMenus name=topmenu}
                {assign var='translatedModuleLabel' value=vtranslate($moduleModel->get('label'),$moduleName)}
                <div class="col-md-6">
                    <a href="{$moduleModel->getDefaultUrl()}">
                        <div class="panel dashboard-stats rounded">
                            {assign var="image_module" value="{vimage_path("summary_{$moduleName}.png")}"}
                            {if file_exists($image_module)}
                                <img src='{$image_module}' class="stats-icon"/>
                            {else}
                                <img src='layouts/vlayout/skins/images/summary_General.png' class="stats-icon"/>
                            {/if}
                            {*<i id="dashes_item_{$moduleName}" class="fa stats-icon dashes_icon_default"></i>*}
                            <h3>
                                {if $moduleName eq 'HelpDesk'}
                                    {$TICKETCOUNT}
                                {elseif $moduleName eq 'Accounts'}
                                    {$ACCOUNTCOUNT}
                                {elseif $moduleName eq 'Project'}
                                    {$PROJECTCOUNT}
                                {elseif $moduleName eq 'Documents'}
                                    {$DOCUMENTCOUNT}
                                {elseif $moduleName eq 'Contacts'}
                                    {$CONTACTCOUNT}
                                {elseif $moduleName eq 'Calendar'}
                                    {$CALENDARCOUNT}
                                {elseif $moduleName eq 'Quotes'}
                                    {$QUOTECOUNT}
                                {elseif $moduleName eq 'Products'}
                                    {$PRODUCTCOUNT}
                                {elseif $moduleName eq 'PurchaseOrder'}
                                    {$PURCHASECOUNT}
                                {elseif $moduleName eq 'SalesOrder'}
                                    {$SALESCOUNT}
                                {elseif $moduleName eq 'Invoice'}
                                    {$INVOICECOUNT}
                                {elseif $moduleName eq 'Services'}
                                    {$SERVICECOUNT}
                                {elseif $moduleName eq 'ServiceContracts'}
                                    {$CONTRACTCOUNT}
                                {elseif $moduleName eq 'Leads'}
                                    {$LEADCOUNT}
                                {elseif $moduleName eq 'Potentials'}
                                    {$POTENTIALCOUNT}
                                {elseif $moduleName eq 'Campaigns'}
                                    {$CAMPAIGNCOUNT}
                                {elseif $moduleName eq 'Assets'}
                                    {$ASSETCOUNT}
                                {elseif $moduleName eq 'Vendors'}
                                    {$VENDORCOUNT}
                                {else}
                                    <i class="fa fa-code" aria-hidden="true"></i>
                                {/if}
                                {*<small class="text-green"><i class="fa fa-caret-up"></i> {vtranslate('LBL_RECORD')}</small>*}
                            </h3>
                            <p class="text-muted">{$translatedModuleLabel}</p>
                        </div>
                    </a>
                </div>
            {/foreach}
        </div>
    {/if}
    <div class="gridster animated fadeInUp">
        <ul>
            {assign var=COLUMNS value=2}
            {assign var=ROW value=1}
            {foreach from=$WIDGETS item=WIDGET name=count}
                {assign var=WIDGETDOMID value=$WIDGET->get('linkid')}
                {if $WIDGET->getName() eq 'MiniList'}
                    {assign var=WIDGETDOMID value=$WIDGET->get('linkid')|cat:'-':$WIDGET->get('widgetid')}
                {elseif $WIDGET->getName() eq 'Notebook'}
                    {assign var=WIDGETDOMID value=$WIDGET->get('linkid')|cat:'-':$WIDGET->get('widgetid')}
                {/if}
                <li id="{$WIDGETDOMID}" {if $smarty.foreach.count.index % $COLUMNS == 0 and $smarty.foreach.count.index != 0} {assign var=ROWCOUNT value=$ROW+1} data-row="{$WIDGET->getPositionRow($ROWCOUNT)}" {else} data-row="{$WIDGET->getPositionRow($ROW)}" {/if}
                        {assign var=COLCOUNT value=($smarty.foreach.count.index % $COLUMNS)+1} data-col="{$WIDGET->getPositionCol($COLCOUNT)}" data-sizex="{$WIDGET->getWidth()}" data-sizey="{$WIDGET->getHeight()}"
                    class="dashboardWidget dashboardWidget_{$smarty.foreach.count.index}" data-url="{$WIDGET->getUrl()}" data-mode="open" data-name="{$WIDGET->getName()}">
                </li>
            {/foreach}
        </ul>
        <input type="hidden" id=row value="{$ROWCOUNT}"/>
        <input type="hidden" id=col value="{$COLCOUNT}"/>
        <input type="hidden" id="userDateFormat" value="{$CURRENT_USER->get('date_format')}"/>
    </div>
{/strip}