{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
*
 ********************************************************************************/
-->*}
{strip}
{* Change to this also refer: RecentComments.tpl *}
{assign var="COMMENT_TEXTAREA_DEFAULT_ROWS" value="2"}
{assign var="PRIVATE_COMMENT_MODULES" value=Magsoft_Functions::getPrivateCommentModules()}
{assign var=CREATE_PERMISSION value=$COMMENTS_MODULE_MODEL->isPermitted('CreateView')}
{assign var=EDIT_PERMISSION value=$COMMENTS_MODULE_MODEL->isPermitted('EditView')}
<div class="commentContainer">
    <div class="commentTitle row-fluid">
        {if $CREATE_PERMISSION}
            <div class="addCommentBlock">
                <div>
                    <textarea name="commentcontent" rows="{$COMMENT_TEXTAREA_DEFAULT_ROWS}" class="commentcontent" placeholder="{vtranslate('LBL_ADD_YOUR_COMMENT_HERE', $MODULE_NAME)}"></textarea>
                </div>
                	{if in_array($MODULE_NAME, $PRIVATE_COMMENT_MODULES)}
                		<div class="pretty p-default p-smooth">
                			<input type="checkbox" id="is_private" checked>
                			<div class="state p-primary">
                				<label>{vtranslate('LBL_INTERNAL_COMMENT')}</label>
                			</div>
                		</div>
					{/if}
                <div class="pull-right">
                    <button class="btn btn-success saveComment marginRightZero" type="button" data-mode="add">
                        <strong>{vtranslate('LBL_POST', $MODULE_NAME)}</strong>
                    </button>
                </div>
            </div>
        {/if}
    </div>
    <br>
    <div class="commentsList commentsBody">
        {include file='CommentsList.tpl'|@vtemplate_path COMMENT_MODULE_MODEL=$COMMENTS_MODULE_MODEL CREATE_PERMISSION=$CREATE_PERMISSION EDIT_PERMISSION=$EDIT_PERMISSION}
    </div>
    {if $CREATE_PERMISSION}
        <div class="hide basicAddCommentBlock">
            <div class="row-fluid">
                <div class="span12">
                    <textarea class="commentcontenthidden fullWidthAlways" rows="{$COMMENT_TEXTAREA_DEFAULT_ROWS}" name="commentcontent" placeholder="{vtranslate('LBL_ADD_YOUR_COMMENT_HERE', $MODULE_NAME)}"></textarea>
                </div>
            </div>
            	{if in_array($MODULE_NAME, $PRIVATE_COMMENT_MODULES)}
                	<div class="pretty p-default p-smooth">
                		<input type="checkbox" id="is_private" checked>
                		<div class="state p-primary">
                			<label>{vtranslate('LBL_INTERNAL_COMMENT')}</label>
                		</div>
                	</div>
				{/if}
            <div class="pull-right">
				<input type="hidden" name="is_private">
                <button class="btn btn-success saveComment" type="button" data-mode="add">
                    <strong>{vtranslate('LBL_POST', $MODULE_NAME)}</strong>
                </button>
                <a class="cursorPointer closeCommentBlock cancelLink" type="reset">{vtranslate('LBL_CANCEL', $MODULE_NAME)}</a>
            </div>
        </div>
    {/if}
    {if $EDIT_PERMISSION}
        <div class="hide basicEditCommentBlock" style="min-height: 128px;">
            <div class="row-fluid">
                <div class="span12">
                    <input type="text" name="reasonToEdit" placeholder="{vtranslate('LBL_REASON_FOR_CHANGING_COMMENT', $MODULE_NAME)}" class="input-block-level"/>
                </div>
            </div>
            <div class="row-fluid">
                <div class="span12">
                    <textarea class="commentcontenthidden fullWidthAlways" name="commentcontent" rows="{$COMMENT_TEXTAREA_DEFAULT_ROWS}"></textarea>
                </div>
            </div>
            	{if in_array($MODULE_NAME, $PRIVATE_COMMENT_MODULES)}
                	<div class="pretty p-default p-smooth">
                		<input type="checkbox" id="is_private" checked>
                		<div class="state p-primary">
                			<label>{vtranslate('LBL_INTERNAL_COMMENT')}</label>
                		</div>
                	</div>
				{/if}
            <div class="pull-right">
				<input type="hidden" name="is_private">
                <button class="btn btn-success saveComment" type="button" data-mode="edit">
                    <strong>{vtranslate('LBL_POST', $MODULE_NAME)}</strong>
                </button>
                <a class="cursorPointer closeCommentBlock cancelLink" type="reset">{vtranslate('LBL_CANCEL', $MODULE_NAME)}</a>
            </div>
        </div>
    {/if}
</div>
{/strip}