{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    <div class="relatedContainer">
        {assign var=RELATED_MODULE_NAME value=$RELATED_MODULE->get('name')}
        <input type="hidden" name="currentPageNum" value="{$PAGING->getCurrentPage()}"/>
        <input type="hidden" name="relatedModuleName" class="relatedModuleName" value="{$RELATED_MODULE_NAME}"/>
        <input type="hidden" value="{$ORDER_BY}" id="orderBy">
        <input type="hidden" value="{$SORT_ORDER}" id="sortOrder">
        <input type="hidden" value="{$RELATED_ENTIRES_COUNT}" id="noOfEntries">
        <input type='hidden' value="{$PAGING->getPageLimit()}" id='pageLimit'>
        <input type='hidden' value="{$TOTAL_ENTRIES}" id='totalCount'>
        <div class="relatedHeader">
            <div class="btn-toolbar row-fluid">
                <div class="span6">
                    {foreach item=RELATED_LINK from=$RELATED_LIST_LINKS['LISTVIEWBASIC']}
                        <div class="btn-group">
                            {assign var=IS_SELECT_BUTTON value={$RELATED_LINK->get('_selectRelation')}}
                            <button type="button" class="btn btn-dark
                            	{if $IS_SELECT_BUTTON eq true} selectRelation {/if}"
                                    {if $IS_SELECT_BUTTON eq true} data-moduleName={$RELATED_LINK->get('_module')->get('name')} {/if}
                                    {if ($RELATED_LINK->isPageLoadLink())}
                                    {if $RELATION_FIELD} data-name="{$RELATION_FIELD->getName()}" {/if}data-url="{$RELATED_LINK->getUrl()}"
                                    {/if}
                                    {if $IS_SELECT_BUTTON neq true}name="addButton"{/if}>{if $IS_SELECT_BUTTON eq false}
                                    <i class="fa fa-plus"></i>
                                {else}
                                    <i class="fa fa-check-square-o"></i>
                                {/if}
                            </button>
                            <button type="button" class="btn addButton
                            	{if $IS_SELECT_BUTTON eq true} selectRelation {/if}"
                                    {if $IS_SELECT_BUTTON eq true} data-moduleName={$RELATED_LINK->get('_module')->get('name')} {/if}
                                    {if ($RELATED_LINK->isPageLoadLink())}
                                    {if $RELATION_FIELD} data-name="{$RELATION_FIELD->getName()}" {/if}data-url="{$RELATED_LINK->getUrl()}"
                                    {/if}
                                    {if $IS_SELECT_BUTTON neq true}name="addButton"{/if}>
                                {$RELATED_LINK->getLabel()}
                            </button>
                        </div>
                    {/foreach}
                    &nbsp;
                </div>
                <div class="span6">
                    <div class="pull-right">
                        {if !empty($RELATED_RECORDS)}
                            <span class="pageNumbers">
            				<span class="pageNumbersText"> {$PAGING->getRecordStartRange()} {vtranslate('LBL_to', $RELATED_MODULE_NAME)} {$PAGING->getRecordEndRange()} / {$TOTAL_ENTRIES}
            				</span>
        				</span>
                        {else}{/if}
                        <span class="btn-group">
            				<button class="btn" id="relatedListPreviousPageButton" {if !$PAGING->isPrevPageExists()} disabled {/if} type="button"><span class="fa fa-chevron-left"></span></button>
            				<button class="btn dropdown-toggle" type="button" id="relatedListPageJump" data-toggle="dropdown" {if $PAGE_COUNT eq 1} disabled {/if}>
                			<i class="fa fa-files-o" title="{vtranslate('LBL_LISTVIEW_PAGE_JUMP',$moduleName)}"></i>
            				</button>
            				<ul class="listViewBasicAction dropdown-menu" id="relatedListPageJumpDropDown">
                				<li>
                    				<span class="row-fluid">
                        				<span class="span3"><span class="pull-right">{vtranslate('LBL_PAGE',$moduleName)}</span></span>
                        				<span class="span4">
                            				<input type="text" id="pageToJump" class="listViewPagingInput" value="{$PAGING->getCurrentPage()}"/>
                        				</span>
                        				<span class="span2 textAlignCenter">
                            			{vtranslate('LBL_OF',$moduleName)}
                        				</span>
                        				<span class="span3" id="totalPageCount">{$PAGE_COUNT}</span>
                    				</span>
                				</li>
            				</ul>
            				<button class="btn" id="relatedListNextPageButton" {if (!$PAGING->isNextPageExists()) or ($PAGE_COUNT eq 1)} disabled {/if} type="button"><span class="fa fa-chevron-right"></span></button>
        				</span>
                    </div>
                </div>
            </div>
        </div>
        {*<div class="contents-topscroll" style="min-height:12px;"></div>*}
        <div id="ipo" class="relatedContents contents-bottomscroll">
            <div class="bottomscroll-div">
                {assign var=WIDTHTYPE value=$USER_MODEL->get('rowheight')}
                <table class="table table-bordered listViewEntriesTable">
                    <thead>
                    <tr class="listViewHeaders">
                        {foreach item=HEADER_FIELD from=$RELATED_HEADERS}
                            <th {if $HEADER_FIELD@last} colspan="2" {/if} nowrap>
                                {if $HEADER_FIELD->get('column') eq 'access_count' or $HEADER_FIELD->get('column') eq 'idlists'}
                                    <a href="javascript:void(0);" class="noSorting">{vtranslate($HEADER_FIELD->get('label'), $RELATED_MODULE_NAME)}</a>
                                {elseif $HEADER_FIELD->get('column') eq 'time_start'}
                                {else}
                                    <a href="javascript:void(0);" class="relatedListHeaderValues" data-nextsortorderval="{if $COLUMN_NAME eq $HEADER_FIELD->get('column')}{$NEXT_SORT_ORDER}{else}ASC{/if}" data-fieldname="{$HEADER_FIELD->get('column')}">{vtranslate($HEADER_FIELD->get('label'), $RELATED_MODULE_NAME)}
                                        &nbsp;{if $COLUMN_NAME eq $HEADER_FIELD->get('column')}
                                        <i class="{$SORT_IMAGE}"></i>{/if}
                                    </a>
                                {/if}
                            </th>
                        {/foreach}
                        {if $MODULE_NAME eq 'HelpDesk' && $RELATED_MODULE_NAME eq 'Products'}
                        <th nowrap colspan="2">
                        	<a href="javascript:void(0);" class="noSorting">{vtranslate('LBL_ASSIGN_QUANTITY')}</a>
                    	</th>
                    	{/if}
                    </tr>
                    </thead>
                    {if $RELATED_MODULE->isQuickSearchEnabled()}
                        {if $RELATED_MODULE_NAME neq 'Calendar'}
                            <tr class="opacsearch">
                                {foreach item=LISTVIEW_HEADER from=$RELATED_HEADERS}
                                    {if $LISTVIEW_HEADER->getFieldDataType() eq 'reference' or $LISTVIEW_HEADER->getFieldDataType() eq 'date' or $LISTVIEW_HEADER->getFieldDataType() eq 'datetime' or $LISTVIEW_HEADER->getFieldDataType() eq 'time' or $LISTVIEW_HEADER->getFieldName() eq 'folderid' or ($RELATED_MODULE_NAME eq 'PriceBooks' and $LISTVIEW_HEADER->getFieldName() eq 'unit_price' or $LISTVIEW_HEADER->getFieldName() eq 'listprice')}
                                        <td>
                                            <input type="text" class="span1 listSearchContributor" disabled>
                                        </td>
                                    {else}
                                        <td>
                                            {assign var=FIELD_UI_TYPE_MODEL value=$LISTVIEW_HEADER->getUITypeModel()}
                                            {include file=vtemplate_path($FIELD_UI_TYPE_MODEL->getListSearchTemplateName(),$MODULE)
                                            FIELD_MODEL= $LISTVIEW_HEADER SEARCH_INFO=$SEARCH_DETAILS[$LISTVIEW_HEADER->getName()] USER_MODEL=$USER_MODEL}
                                        </td>
                                    {/if}
                                {/foreach}
                                {if $MODULE_NAME eq 'HelpDesk' && $RELATED_MODULE_NAME eq 'Products'}
                                    <td>
                                        <a class="btn pull-right" data-trigger="listSearch" style="padding: 6px 10px;"><i class="fa fa-search"></i></a>
                                    </td>
                                    <td colspan="2" nowrap>
                                    </td>
                                {else}
                                    <td class="{$WIDTHTYPE}">
                                        <a class="btn pull-right" data-trigger="listSearch" style="padding: 6px 10px;"><i class="fa fa-search"></i></a>
                                    </td>
                                {/if}
                            </tr>
                        {/if}
                    {/if}
                    {foreach item=RELATED_RECORD from=$RELATED_RECORDS}
                        <tr class="listViewEntries" data-id='{$RELATED_RECORD->getId()}'
                                {if $RELATED_MODULE_NAME eq 'Calendar'}
                                {assign var=DETAILVIEWPERMITTED value=isPermitted($RELATED_MODULE_NAME, 'DetailView', $RELATED_RECORD->getId())}
                            {if $DETAILVIEWPERMITTED eq 'yes'}
                                data-recordUrl='{$RELATED_RECORD->getDetailViewUrl()}'
                            {/if}
                                {else}
                            data-recordUrl='{$RELATED_RECORD->getDetailViewUrl()}'
                                {/if}>
                            {foreach item=HEADER_FIELD from=$RELATED_HEADERS}
                                {assign var=RELATED_HEADERNAME value=$HEADER_FIELD->get('name')}
                            <td class="{$WIDTHTYPE}" data-field-type="{$HEADER_FIELD->getFieldDataType()}" nowrap>
                                {if $HEADER_FIELD@first}
                                    {if $RELATED_MODULE_NAME eq 'HelpDesk'}
                                        {assign var="NUMBEROFDAYS" value=$RELATED_RECORD->getCreatedtimeValue()}
                                        {assign var="CLOSEDINDAYS" value=$RELATED_RECORD->getModifiedtimeValue()}
                                        {assign var="DATECLOSED" value=$RELATED_RECORD->getClosedtimeValue()}
                                        <span class="tooltip-right" data-tooltip='
                                		{if $RELATED_RECORD->getDisplayValue('ticketstatus') eq 'Encerrado' || $RELATED_RECORD->getDisplayValue('ticketstatus') eq 'Closed' || $RELATED_RECORD->getDisplayValue('ticketstatus') eq 'Entregue'}
                	                		{vtranslate('Closed', $MODULE_NAME)} {Magsoft_Util_Helper::extendDateFormat("$DATECLOSED")}
                	            		{else}
                	                		{Magsoft_Util_Helper::extendDateFormat("$NUMBEROFDAYS")}
                	            		{/if}'>
                	            		{if $RELATED_RECORD->getDisplayValue('ticketstatus') eq 'Encerrado' || $RELATED_RECORD->getDisplayValue('ticketstatus') eq 'Closed' || $RELATED_RECORD->getDisplayValue('ticketstatus') eq 'Entregue'}
                                            <a class="call-to-action" data-target=".mainwindow" href="{$RELATED_RECORD->getFullDetailViewUrl()}">
                                    		<i class="fa fa-check-circle fa-lg" style="color:#3EBEBD;" aria-hidden="true"></i>
                                    		</a>
                	            		{elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") lte '5'}
                		            		<a class="call-to-action" data-target=".mainwindow" href="{$RELATED_RECORD->getFullDetailViewUrl()}">
                		            		<i class="fa fa-circle-thin fa-lg" style="color:#3EBEBD;" aria-hidden="true"></i>
                		            		</a>
                	            		{elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") gt '5' and Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") lte '10'}
                		            		<a class="call-to-action" data-target=".mainwindow" href="{$RELATED_RECORD->getFullDetailViewUrl()}">
                		            		<i class="fa fa-circle-thin fa-lg" style="color:#FFDC00;" aria-hidden="true"></i>
                		            		</a>
                	            		{elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") gt '10' and Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") lte '15'}
                		            		<a class="call-to-action" data-target=".mainwindow" href="{$RELATED_RECORD->getFullDetailViewUrl()}">
                		            		<i class="fa fa-circle-thin fa-lg" style="color:#FF851B;" aria-hidden="true"></i>
                		            		</a>
                	            		{elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") gt '15' and Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") lte '45'}
                		            		<a class="call-to-action" data-target=".mainwindow" href="{$RELATED_RECORD->getFullDetailViewUrl()}">
                		            		<i class="fa fa-circle-thin fa-lg" style="color:#FF4136;" aria-hidden="true"></i>
                		            		</a>
                	            		{elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") gt '45'}
                                    		<a class="call-to-action" data-target=".mainwindow" href="{$RELATED_RECORD->getFullDetailViewUrl()}">
                                    		<i class="fa fa-circle-thin fa-lg" style="color:#111111;" aria-hidden="true"></i>
                                    		</a>
                                        {/if}
                                		</span>
                                    {elseif $RELATED_MODULE_NAME eq 'Contacts'}
                                        {assign var="NUMBEROFDAYS" value=$RELATED_RECORD->getCreatedtimeValue()}
                                        <span class="tooltip-right" data-tooltip='{Magsoft_Util_Helper::extendDateFormat("$NUMBEROFDAYS")}'>
                                            <a class="call-to-action" data-target=".mainwindow" href="{$RELATED_RECORD->getFullDetailViewUrl()}">
                                                <i class="fa fa-circle-thin fa-lg" style="color:#0074D9" aria-hidden="true"></i>
                                            </a>
                                        </span>
                                    {elseif $RELATED_MODULE_NAME eq 'SMSNotifier'}
                                        {assign var="RECORDSTATUS" value=$RELATED_RECORD->getSmsStatus()}
                                        {if $RECORDSTATUS}
                                            {if $RECORDSTATUS == 'Processing'}
                                                {assign var="TDSTATUSCOLOR" value="#FFFF00"}
                                            {elseif $RECORDSTATUS == 'Dispatched'}
                                                {assign var="TDSTATUSCOLOR" value="#BDF97D"}
                                            {elseif $RECORDSTATUS == 'Delivered'}
                                                {assign var="TDSTATUSCOLOR" value="#BDF97D"}
                                            {elseif $RECORDSTATUS eq 'Failed'}
                                                {assign var="TDSTATUSCOLOR" value="#FF3322"}
                                                {*{elseif $RECORDSTATUS eq 'Error'}*}
                                            {elseif $RECORDSTATUS|strstr:'ERR'}
                                                {assign var="TDSTATUSCOLOR" value="#FB6B5B"}
                                            {else}
                                                {assign var="TDSTATUSCOLOR" value="#99FFEE"}
                                            {/if}
                                        {/if}
                                        <span class="tooltip-right" data-tooltip='{$RECORDSTATUS} - {$RELATED_RECORD->getToNumber()}'>
                                            <a class="call-to-action" data-target=".mainwindow" href="{$RELATED_RECORD->getFullDetailViewUrl()}">
                                                <i class="fa fa-circle-thin fa-lg" style="color:{$TDSTATUSCOLOR}" aria-hidden="true"></i>
                                            </a>
                                        </span>
                                    {else}
                                        <a class="call-to-action tooltip-right" data-tooltip="{vtranslate('LBL_GO_TO_PREVIEW', $MODULE)}" data-target=".mainwindow" href="{$RELATED_RECORD->getFullDetailViewUrl()}">
                                            <i class="fa fa-circle-thin fa-lg" style="color:#0074D9" aria-hidden="true"></i>
                                        </a>
                                    {/if}
                                    &nbsp;&nbsp;
                                {/if}
                                {if ($HEADER_FIELD->isNameField() eq true) or ($HEADER_FIELD->get('uitype') eq '4')}
                                    <a href="{$RELATED_RECORD->getDetailViewUrl()}">{$RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME)}</a>
                                {elseif $RELATED_HEADERNAME eq 'access_count'}
                                    {$RELATED_RECORD->getAccessCountValue($PARENT_RECORD->getId())}
                                {elseif $RELATED_HEADERNAME eq 'time_start'}
                                {elseif ($HEADER_FIELD->get('uitype') eq '72') or ($HEADER_FIELD->get('uitype') eq '71')}
                                	{CurrencyField::convertToUserFormat($RELATED_RECORD->get($RELATED_HEADERNAME), null, true)} {$USER_MODEL->get('currency_symbol')}
                                {elseif $RELATED_HEADERNAME eq 'unit_price'}
                                    {CurrencyField::convertToUserFormat($RELATED_RECORD->get($RELATED_HEADERNAME), null, true)} {$USER_MODEL->get('currency_symbol')}
                                {elseif $RELATED_HEADERNAME eq 'listprice'}
                                    {CurrencyField::convertToUserFormat($RELATED_RECORD->get($HEADER_FIELD->get('name')), null, true)} {$USER_MODEL->get('currency_symbol')}
                                    {assign var="LISTPRICE" value=$RELATED_RECORD->get($HEADER_FIELD->get('name'))}
                                {elseif $RELATED_HEADERNAME eq 'filename'}
                                    {$RELATED_RECORD->get($RELATED_HEADERNAME)}
                                {elseif $RELATED_HEADERNAME eq 'qtyinstock'}
                                    {if $RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME) gt '0'}
                                        <span class="qtyinstock color-green">{$RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME)}</span>
                                    {else}
                                        <span class="qtyinstock color-red">{$RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME)}</span>
                                    {/if}
                                {elseif $HEADER_FIELD->get('uitype') eq '979' && $RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME) neq ''}
                                    <img alt="Digisign" style="min-width: 50px;" src="{vimage_path('digital_sign.png')}">
                                {elseif $RELATED_HEADERNAME eq 'ticketstatus' or $RELATED_HEADERNAME eq 'taskstatus' or $RELATED_HEADERNAME eq 'eventstatus'}
                                    {assign var=STATUSNAME value=$RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME)}
                                    {*{assign var=STATUSNAME value=$RELATED_RECORD->get('ticketstatus')}*}
                                    {if $STATUSNAME|strstr:'Aberto'}
                                        <span class="color-red">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Open'}
                                        <span class="color-red">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Encerrado'}
                                        <span class="color-green"><i class="fa fa-check" aria-hidden="true"></i> {$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Closed'}
                                        <span class="color-green"><i class="fa fa-check" aria-hidden="true"></i> {$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Entregue'}
                                        <span class="color-green">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Andamento'}
                                        <span class="color-grey">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Progress'}
                                        <span class="color-grey">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Aguarda'}
                                        <span class="color-blue">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Wait'}
                                        <span class="color-blue">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Realizado'}
                                    	<span class="color-green"><i class="fa fa-check" aria-hidden="true"></i> {$STATUSNAME}</span>
                                	{elseif $STATUSNAME|strstr:'Completed'}
                                    	<span class="color-green"><i class="fa fa-check" aria-hidden="true"></i> {$STATUSNAME}</span>
                                	{elseif $STATUSNAME|strstr:'Concluído'}
                                    	<span class="color-green"><i class="fa fa-check" aria-hidden="true"></i> {$STATUSNAME}</span>
                                    {else}
                                        <span class="color-yellow">{$STATUSNAME}</span>
                                    {/if}
                                {elseif $HEADER_FIELD->get('uitype') eq '9' && $RELATED_RECORD->get($RELATED_HEADERNAME) neq ''}
                                    {$RELATED_RECORD->get($RELATED_HEADERNAME)}%
                                    <div class="progress-bar">
                                        <span class="progress-bar-fill" style="width: {$RELATED_RECORD->get($RELATED_HEADERNAME)|regex_replace:'/[.,][0-9]+/':''}%;"></span>
                                    </div>
                                {elseif $RELATED_HEADERNAME eq 'start_date' || $RELATED_HEADERNAME eq 'end_date'}
                                    {$RELATED_RECORD->getTimeSheetValue($RELATED_HEADERNAME)}
                                {elseif $RELATED_HEADERNAME eq 'workedhours' || $RELATED_HEADERNAME eq 'hours' || $RELATED_HEADERNAME eq 'used_units'}
                                    {if $RELATED_RECORD->get($RELATED_HEADERNAME) neq '0' && $RELATED_RECORD->get($RELATED_HEADERNAME) neq ''}
                                        <span class="tooltip-top" data-tooltip="{$RELATED_RECORD->getTimeSheetValueTime($RELATED_HEADERNAME)}">{$RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME)} <img src="{vimage_path('information.png')}" style="vertical-align: bottom"></span>
                                    {else}
                                        {$RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME)}
                                    {/if}
                                {else}
                                    {$RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME)}
                                {/if}
                                {if $HEADER_FIELD@last}
                                    </td>
                                    <td nowrap class="{$WIDTHTYPE}">
                                        <div class="pull-right actions">
                                    <span class="actionImages">
                                        {if $RELATED_MODULE_NAME eq 'Calendar'}
                                            {if $IS_EDITABLE && $RELATED_RECORD->get('taskstatus') neq vtranslate('Held', $MODULE) && $RELATED_RECORD->get('taskstatus') neq vtranslate('Completed', $MODULE)}
                                                <a class="markAsHeld tooltip-left" data-tooltip="{vtranslate('LBL_MARK_AS_HELD', $MODULE)}"><i title="{vtranslate('LBL_MARK_AS_HELD', $MODULE)}" class="fa fa-check btn btn-default btn-mini color-confirm"></i></a>
                                                &nbsp;
                                            {/if}
                                            {if $IS_EDITABLE && $RELATED_RECORD->get('taskstatus') eq vtranslate('Held', $MODULE)}
                                            <a class="holdFollowupOn tooltip-left" data-tooltip="{vtranslate('LBL_HOLD_FOLLOWUP_ON', "Events")}"><i title="{vtranslate('LBL_HOLD_FOLLOWUP_ON', "Events")}" class="fa fa-flag btn btn-default btn-mini color-flag"></i></a>
                                            &nbsp;
                                        {/if}
                                            {*{if $DETAILVIEWPERMITTED eq 'yes'}
                                                <!--<a class="tooltip-left" data-tooltip="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE)}" href="{$RELATED_RECORD->getFullDetailViewUrl()}"><i title="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE)}" class="fa fa-info btn btn-default btn-mini color-info"></i></a>&nbsp;-->
                                                {/if}
                                            {else}
                                                <!--<a class="tooltip-left" data-tooltip="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE)}" href="{$RELATED_RECORD->getFullDetailViewUrl()}"><i title="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE)}" class="fa fa-info btn btn-default btn-mini color-info"></i></a>&nbsp;-->
                                            *}
                                        {/if}
                                        {if $IS_EDITABLE}
                                            {if $RELATED_MODULE_NAME eq 'PriceBooks'}
                                                <a data-url="index.php?module=PriceBooks&view=ListPriceUpdate&record={$PARENT_RECORD->getId()}&relid={$RELATED_RECORD->getId()}&currentPrice={$LISTPRICE}"
                                                   class="editListPrice cursorPointer tooltip-left" data-tooltip="{vtranslate('LBL_EDIT', $MODULE)}" data-related-recordid='{$RELATED_RECORD->getId()}' data-list-price={$LISTPRICE}>
                                                    <i class="fa fa-eur btn btn-default btn-mini color-edit" title="{vtranslate('LBL_EDIT', $MODULE)}"></i>
                                                </a>
                                                &nbsp;
                                            {elseif $RELATED_MODULE_NAME eq 'Calendar'}
                                                {if isPermitted($RELATED_MODULE_NAME, 'EditView', $RELATED_RECORD->getId()) eq 'yes'}
                                                <a class="tooltip-left" data-tooltip="{vtranslate('LBL_EDIT', $MODULE)}" href='{$RELATED_RECORD->getEditViewUrl()}'><i title="{vtranslate('LBL_EDIT', $MODULE)}" class="fa fa-pencil btn btn-default btn-mini color-edit"></i></a>
                                                &nbsp;
                                                {/if}
                                            {else}
                                                <a class="tooltip-left" data-tooltip="{vtranslate('LBL_EDIT', $MODULE)}" href='{$RELATED_RECORD->getEditViewUrl()}'><i title="{vtranslate('LBL_EDIT', $MODULE)}" class="fa fa-pencil btn btn-default btn-mini color-edit"></i></a>
                                                &nbsp;
                                            {/if}
                                        {/if}
                                        {if $IS_DELETABLE}
                                            {if $RELATED_MODULE_NAME eq 'Calendar'}
                                                {if isPermitted($RELATED_MODULE_NAME, 'Delete', $RELATED_RECORD->getId()) eq 'yes'}
                                                    <a class="relationDelete tooltip-left" data-tooltip="{vtranslate('LBL_UNLINK', $MODULE)}"><i title="{vtranslate('LBL_UNLINK', $MODULE)}" class="fa fa-chain-broken btn btn-default btn-mini color-delete"></i></a>
                                                {/if}
                                            {else}
                                                {if ($MODULE_NAME eq 'Products' && $RELATED_MODULE_NAME eq 'HelpDesk') or $RELATED_MODULE_NAME eq 'SMSNotifier' or ($MODULE_NAME eq 'Contacts' && $RELATED_MODULE_NAME eq 'Invoice') or ($MODULE_NAME eq 'Accounts' && $RELATED_MODULE_NAME eq 'Invoice') or ($MODULE_NAME eq 'HelpDesk' && $RELATED_MODULE_NAME eq 'Invoice')}
                                                {else}
                                                	<a class="relationDelete tooltip-left" data-tooltip="{vtranslate('LBL_UNLINK', $MODULE)}"><i title="{vtranslate('LBL_UNLINK', $MODULE)}" class="fa fa-chain-broken btn btn-default btn-mini color-delete"></i></a>
                                                {/if}
                                            {/if}
                                        {/if}
                                    </span>
                                        </div>
                                    </td>
                                {/if}
                                </td>
                            {/foreach}
                            {if $MODULE_NAME eq 'HelpDesk' && $RELATED_MODULE_NAME eq 'Products'}
                            {assign var=tkt_pr value=$RELATED_RECORD->ticker_rel_product_qnty($PARENT_RECORD->getId(),$RELATED_RECORD->getId())}
                            <td colspan="2" nowrap>
                       			<input class="tkt_rel_id" name="tkt_rel_id" type="hidden" value="{$tkt_pr.relid}" />
                       			<div class="row-fluid input-append">
                       				<input style="margin-bottom:0;max-width:40px;" class="input-small txt_assignqty" type="text" value="{$tkt_pr.productid}" name="txt_assignqty">
									<span class="add-on">
										<span class="btn_save_qnty" data-relrecordid='{$RELATED_RECORD->getId()}' data-parentid='{$PARENT_RECORD->getId()}'>{vtranslate('LBL_SAVE', $MODULE)}</span>
										{*<i data-relrecordid='{$RELATED_RECORD->getId()}' data-parentid='{$PARENT_RECORD->getId()}' class="fa fa-calculator btn_save_qnty" title="{vtranslate('LBL_SAVE', $MODULE)}"></i>*}
										{*<button data-relrecordid='{$RELATED_RECORD->getId()}' data-parentid='{$PARENT_RECORD->getId()}' type="button" class="btn btn-info btn_save_qnty">{vtranslate('LBL_SAVE', $MODULE)}</button>*}
									</span>
								</div>
                       		</td>
                    		{/if}
                        </tr>
                    {/foreach}
                </table>
                {if empty($RELATED_RECORDS)}
                    <table class="emptyRecordsDiv">
                        <tbody>
                        <tr>
                            <td>
                                {assign var=SINGLE_RELATED_MODULE value="SINGLE_$RELATED_MODULE_NAME"}
                                <img class="no_records" src="{vimage_path('no_records_list.png')}" alt="{vtranslate('LBL_NO_RECORDS')}" title="{vtranslate('LBL_NO_RECORDS')}"/>
                                <br>
                                <br>
                                {vtranslate('LBL_NO', $MODULE)} {vtranslate($SINGLE_RELATED_MODULE, $RELATED_MODULE_NAME)} {vtranslate('LBL_FOUND')}
                            </td>
                        </tr>
                        </tbody>
                    </table>
                {/if}
            </div>
        </div>
    </div>
{/strip}
<script>
    jQuery(function () {
        jQuery('.call-to-action').modalLoadContent({
            debugMode: false
        });
        jQuery('.call-to-action').click(function (e) {
            NProgress.start();
            e.stopPropagation();
            NProgress.done();
        });
    });
</script>