{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
*
 ********************************************************************************/
-->*}
{strip}
    <input type="hidden" id="view" value="{$VIEW}"/>
    <input type="hidden" id="pageStartRange" value="{$PAGING_MODEL->getRecordStartRange()}"/>
    <input type="hidden" id="pageEndRange" value="{$PAGING_MODEL->getRecordEndRange()}"/>
    <input type="hidden" id="previousPageExist" value="{$PAGING_MODEL->isPrevPageExists()}"/>
    <input type="hidden" id="nextPageExist" value="{$PAGING_MODEL->isNextPageExists()}"/>
    <input type="hidden" id="alphabetSearchKey" value="{$MODULE_MODEL->getAlphabetSearchField()}"/>
    <input type="hidden" id="Operator" value="{$OPERATOR}"/>
    <input type="hidden" id="alphabetValue" value="{$ALPHABET_VALUE}"/>
    <input type="hidden" id="totalCount" value="{$LISTVIEW_COUNT}"/>
    <input type='hidden' value="{$PAGE_NUMBER}" id='pageNumber'>
    <input type='hidden' value="{$PAGING_MODEL->getPageLimit()}" id='pageLimit'>
    <input type="hidden" value="{$LISTVIEW_ENTRIES_COUNT}" id="noOfEntries">
    {assign var = ALPHABETS_LABEL value = vtranslate('LBL_ALPHABETS', 'Magsoft')}
    {assign var = ALPHABETS value = ','|explode:$ALPHABETS_LABEL}
    <div class="alphabetSorting noprint hide">
        <table>
            <tbody>
            <tr>
                {foreach item=ALPHABET from=$ALPHABETS}
                    <td class="alphabetSearch textAlignCenter cursorPointer {if $ALPHABET_VALUE eq $ALPHABET} highlightBackgroundColor {/if}">
                        <a id="{$ALPHABET}" href="#">{$ALPHABET}</a>
                    </td>
                {/foreach}
            </tr>
            </tbody>
        </table>
    </div>
    {*<div class="contents-topscroll" style="min-height:10px;"></div>*}
    <div id="ipo" class="listViewEntriesDiv contents-bottomscroll" style="margin-top:8px;">
        <div class="bottomscroll-div">
            <input type="hidden" value="{$ORDER_BY}" id="orderBy">
            <input type="hidden" value="{$SORT_ORDER}" id="sortOrder">
            <span class="listViewLoadingImageBlock hide modal noprint" id="loadingListViewModal">
				<img class="listViewLoadingImage" src="{vimage_path('loading.gif')}" alt="no-image" title="{vtranslate('LBL_LOADING', $MODULE)}"/>
				<p class="listViewLoadingMsg">{vtranslate('LBL_LOADING_LISTVIEW_CONTENTS', $MODULE)}........</p>
			</span>
            {assign var=WIDTHTYPE value=$CURRENT_USER_MODEL->get('rowheight')}
            <table class="table table-bordered listViewEntriesTable">
                <thead>
                <tr class="listViewHeaders">
                    <th width="5%">
                        <div class="pretty p-default p-smooth">
                            <input type="checkbox" id="listViewEntriesMainCheckBox"/>
                            <div class="state p-primary">
                                <label></label>
                            </div>
                        </div>
                    </th>
                    {foreach item=LISTVIEW_HEADER from=$LISTVIEW_HEADERS}
                        <th nowrap {if $LISTVIEW_HEADER@last} colspan="2" {/if}>
                            <a href="javascript:void(0);" class="listViewHeaderValues" data-nextsortorderval="{if $COLUMN_NAME eq $LISTVIEW_HEADER->get('column')}{$NEXT_SORT_ORDER}{else}ASC{/if}" data-columnname="{$LISTVIEW_HEADER->get('column')}">{vtranslate($LISTVIEW_HEADER->get('label'), $MODULE)}
                                &nbsp;{if $COLUMN_NAME eq $LISTVIEW_HEADER->get('column')}
                                <i class="{$SORT_IMAGE}"></i>{/if}
                            </a>
                        </th>
                    {/foreach}
                </tr>
                </thead>
                {if $MODULE_MODEL->isQuickSearchEnabled()}
                    <tr class="opacsearch">
                        <td>
                            <div id="selectAllMsgDiv" class="noprint">
                                <a id="selectAllMsg"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;<span id="totalRecordsCount"></span></a>
                            </div>
                            <div id="deSelectAllMsgDiv" class="msgDiv noprint">
                                <a id="deSelectAllMsg"><i class="fa fa-close" aria-hidden="true"></i></a>
                            </div>
                        </td>
                        {foreach item=LISTVIEW_HEADER from=$LISTVIEW_HEADERS}
                            <td>
                                {assign var=FIELD_UI_TYPE_MODEL value=$LISTVIEW_HEADER->getUITypeModel()}
                                {include file=vtemplate_path($FIELD_UI_TYPE_MODEL->getListSearchTemplateName(),$MODULE_NAME)
                                FIELD_MODEL= $LISTVIEW_HEADER SEARCH_INFO=$SEARCH_DETAILS[$LISTVIEW_HEADER->getName()] USER_MODEL=$CURRENT_USER_MODEL}
                            </td>
                        {/foreach}
                        <td>
                            <button class="btn pull-right" data-trigger="listSearch" style="padding: 6px 10px;">
                                <i class="fa fa-search"></i>
                            </button>
                        </td>
                    </tr>
                {/if}
                {foreach item=LISTVIEW_ENTRY from=$LISTVIEW_ENTRIES name=listview}
                    <tr class="listViewEntries" data-id='{$LISTVIEW_ENTRY->getId()}' data-recordUrl='{$LISTVIEW_ENTRY->getDetailViewUrl()}' id="{$MODULE}_listView_row_{$smarty.foreach.listview.index+1}">
                        <td width="5%" class="{$WIDTHTYPE}" style="padding-right: 0 !important;min-width: 48px;">
                            <div class="pretty p-default p-smooth">
                                <input type="checkbox" value="{$LISTVIEW_ENTRY->getId()}" class="listViewEntriesCheckBox"/>
                                <div class="state p-primary">
                                    <label></label>
                                </div>
                            </div>
                            {if $MODULE eq 'HelpDesk'}
                                {assign var="NUMBEROFDAYS" value=$LISTVIEW_ENTRY->getCreatedtimeValue()}
                                {assign var="CLOSEDINDAYS" value=$LISTVIEW_ENTRY->getModifiedtimeValue()}
                                {assign var="DATECLOSED" value=$LISTVIEW_ENTRY->getClosedtimeValue()}
                                <span class="tooltip-right" data-tooltip='
                                {if $LISTVIEW_ENTRY->getDisplayValue('ticketstatus') eq 'Encerrado' || $LISTVIEW_ENTRY->getDisplayValue('ticketstatus') eq 'Closed' || $LISTVIEW_ENTRY->getDisplayValue('ticketstatus') eq 'Entregue'}
                	                {vtranslate('Closed', $MODULE_NAME)} {Magsoft_Util_Helper::extendDateFormat("$DATECLOSED")}
                	            {else}
                	                {Magsoft_Util_Helper::extendDateFormat("$NUMBEROFDAYS")}
                	            {/if}'>
                	            {if $LISTVIEW_ENTRY->getDisplayValue('ticketstatus') eq 'Encerrado' || $LISTVIEW_ENTRY->getDisplayValue('ticketstatus') eq 'Closed' || $LISTVIEW_ENTRY->getDisplayValue('ticketstatus') eq 'Entregue'}
                                    <a class="call-to-action" data-target=".mainwindow" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}">
                                    <i class="fa fa-check-circle fa-lg" style="color:#3EBEBD;" aria-hidden="true"></i>
                                    </a>
                	            {elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") lte '5'}
                		            <a class="call-to-action" data-target=".mainwindow" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}">
                		            <i class="fa fa-circle-thin fa-lg" style="color:#3EBEBD;" aria-hidden="true"></i>
                		            </a>
                	            {elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") gt '5' and Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") lte '10'}
                		            <a class="call-to-action" data-target=".mainwindow" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}">
                		            <i class="fa fa-circle-thin fa-lg" style="color:#FFDC00;" aria-hidden="true"></i>
                		            </a>
                	            {elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") gt '10' and Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") lte '15'}
                		            <a class="call-to-action" data-target=".mainwindow" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}">
                		            <i class="fa fa-circle-thin fa-lg" style="color:#FF851B;" aria-hidden="true"></i>
                		            </a>
                	            {elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") gt '15' and Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") lte '45'}
                		            <a class="call-to-action" data-target=".mainwindow" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}">
                		            <i class="fa fa-circle-thin fa-lg" style="color:#FF4136;" aria-hidden="true"></i>
                		            </a>
                	            {elseif Magsoft_Util_Helper::formatDateDays("$NUMBEROFDAYS") gt '45'}
                                    <a class="call-to-action" data-target=".mainwindow" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}">
                                    <i class="fa fa-circle-thin fa-lg" style="color:#111111;" aria-hidden="true"></i>
                                    </a>
                                {/if}
                                </span>
                            {elseif $MODULE eq 'Contacts'}
                                {assign var="NUMBEROFDAYS" value=$LISTVIEW_ENTRY->getCreatedtimeValue()}
                                <span class="tooltip-right" data-tooltip='{Magsoft_Util_Helper::extendDateFormat("$NUMBEROFDAYS")}'>
                                    <a class="call-to-action" data-target=".mainwindow" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}">
                                        <i class="fa fa-circle-thin fa-lg" style="color:#0074D9" aria-hidden="true"></i>
                                    </a>
                                </span>
                            {elseif $MODULE eq 'SMSNotifier'}
                                {assign var="RECORDSTATUS" value=$LISTVIEW_ENTRY->getSmsStatus()}
                                {if $RECORDSTATUS}
                                    {if $RECORDSTATUS == 'Processing'}
                                        {assign var="TDSTATUSCOLOR" value="#FFFF00"}
                                    {elseif $RECORDSTATUS == 'Dispatched'}
                                        {assign var="TDSTATUSCOLOR" value="#BDF97D"}
                                    {elseif $RECORDSTATUS == 'Delivered'}
                                        {assign var="TDSTATUSCOLOR" value="#BDF97D"}
                                    {elseif $RECORDSTATUS eq 'Failed'}
                                        {assign var="TDSTATUSCOLOR" value="#FF3322"}
                                        {*{elseif $RECORDSTATUS eq 'Error'}*}
                                    {elseif $RECORDSTATUS|strstr:'ERR'}
                                        {assign var="TDSTATUSCOLOR" value="#FB6B5B"}
                                    {else}
                                        {assign var="TDSTATUSCOLOR" value="#99FFEE"}
                                    {/if}
                                {/if}
                                <span class="tooltip-right" data-tooltip='{$RECORDSTATUS} - {$LISTVIEW_ENTRY->getToNumber()}'>
                                    <a class="call-to-action" data-target=".mainwindow" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}">
                                        <i class="fa fa-circle-thin fa-lg" style="color:{$TDSTATUSCOLOR}" aria-hidden="true"></i>
                                    </a>
                                </span>
                            {else}
                                <a class="call-to-action tooltip-right" data-tooltip="{vtranslate('LBL_GO_TO_PREVIEW', $MODULE)}" data-target=".mainwindow" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}">
                                    <i class="fa fa-circle-thin fa-lg" style="color:#0074D9" aria-hidden="true"></i>
                                </a>
                            {/if}
                        </td>
                        {foreach item=LISTVIEW_HEADER from=$LISTVIEW_HEADERS}
                            {assign var=LISTVIEW_HEADERNAME value=$LISTVIEW_HEADER->get('name')}
                        <td class="listViewEntryValue {$WIDTHTYPE}" data-field-type="{$LISTVIEW_HEADER->getFieldDataType()}" nowrap>
                            {if ($LISTVIEW_HEADER->isNameField() eq true or $LISTVIEW_HEADER->get('uitype') eq '4') and $MODULE_MODEL->isListViewNameFieldNavigationEnabled() eq true}
                                <a href="{$LISTVIEW_ENTRY->getDetailViewUrl()}">{$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}</a>
                            {elseif ($LISTVIEW_HEADER->get('uitype') eq '72') or ($LISTVIEW_HEADER->get('uitype') eq '71')}
                                {assign var=CURRENCY_SYMBOL_PLACEMENT value={$CURRENT_USER_MODEL->get('currency_symbol_placement')}}
                                {if $CURRENCY_SYMBOL_PLACEMENT eq '1.0$'}
                                    {$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)} {$CURRENT_USER_MODEL->get('currency_symbol')}
                                {else}
                                    {$CURRENT_USER_MODEL->get('currency_symbol')} {$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}
                                {/if}
                                {*<!--{elseif $LISTVIEW_HEADERNAME eq 'days'}
                                    {if $LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME) >= '3'}
                                    <span class="color-red">{decimalFormat($LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME))}</span>
                                    {elseif $LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME) >= '2'}
                                    <span class="color-yellow">{decimalFormat($LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME))}</span>
                                    {elseif $LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME) < '2'}
                                    <span class="color-green">{decimalFormat($LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME))}</span>
                                    {else}
                                        {decimalFormat($LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME))}
                                    {/if}-->*}
                            {elseif $LISTVIEW_HEADERNAME eq 'qtyinstock'}
                                {if $LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME) gt '0'}
                                    <span class="color-green">{$LISTVIEW_ENTRY->getDisplayValue($LISTVIEW_HEADERNAME)}</span>
                                {else}
                                    <span class="color-red">{$LISTVIEW_ENTRY->getDisplayValue($LISTVIEW_HEADERNAME)}</span>
                                {/if}
                            {elseif $LISTVIEW_HEADER->get('uitype') eq '979' && $LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME) neq ''}
                                <img style="min-width: 50px;" src="{vimage_path('digital_sign.png')}">
                            {elseif $LISTVIEW_HEADER->get('uitype') eq '9' && $LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME) neq ''}
                                {$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}%
                                <div class="progress-bar">
                                    <span class="progress-bar-fill" style="width: {$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)|regex_replace:'/[.,][0-9]+/':''}%;"></span>
                                </div>
                            {elseif $LISTVIEW_HEADERNAME eq 'start_date' || $LISTVIEW_HEADERNAME eq 'end_date'}
                                {$LISTVIEW_ENTRY->getTimeSheetValue($LISTVIEW_HEADERNAME)}
                            {*{elseif $LISTVIEW_HEADERNAME eq 'workedhours' || $LISTVIEW_HEADERNAME eq 'hours' || $LISTVIEW_HEADERNAME eq 'used_units'}*}
                            {elseif $LISTVIEW_HEADERNAME eq 'workedhours' || $LISTVIEW_HEADERNAME eq 'hours'}
                                {if $LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME) neq '0' && $LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME) neq ''}
                                    <span class="tooltip-top" data-tooltip="{$LISTVIEW_ENTRY->getTimeSheetValueTime($LISTVIEW_HEADERNAME)}">{$LISTVIEW_ENTRY->getDisplayValue($LISTVIEW_HEADERNAME)} <img src="{vimage_path('information.png')}" style="vertical-align: bottom"></span>
                                {else}
                                    {$LISTVIEW_ENTRY->getDisplayValue($LISTVIEW_HEADERNAME)}
                                {/if}
                            {else}
                                {if $LISTVIEW_HEADER->getFieldDataType() eq 'double'}
                                    {decimalFormat($LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME))}
                                {elseif $LISTVIEW_HEADERNAME eq 'ticketstatus'}
                                    {assign var=STATUSNAME value=$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}
                                    {*{assign var=STATUSNAME value=$RECORD->get('ticketstatus')}*}
                                    {if $STATUSNAME|strstr:'Aberto'}
                                        <span class="color-red">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Open'}
                                        <span class="color-red">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Encerrado'}
                                        <span class="color-green"><i class="fa fa-check" aria-hidden="true"></i> {$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Closed'}
                                        <span class="color-green"><i class="fa fa-check" aria-hidden="true"></i> {$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Entregue'}
                                        <span class="color-green">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Andamento'}
                                        <span class="color-grey">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Progress'}
                                        <span class="color-grey">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Aguarda'}
                                        <span class="color-blue">{$STATUSNAME}</span>
                                    {elseif $STATUSNAME|strstr:'Wait'}
                                        <span class="color-blue">{$STATUSNAME}</span>
                                    {else}
                                        <span class="color-yellow">{$STATUSNAME}</span>
                                    {/if}
                                {else}
                                    {$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}
                                {/if}
                            {/if}
                            {if $LISTVIEW_HEADER@last}
                                </td>
                                <td nowrap class="{$WIDTHTYPE}">
                                    <div class="actions pull-right">
										<span class="actionImages">
											{*<!--<a class="tooltip-left" data-tooltip="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE)}" href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}"><i title="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE)}" class="fa fa-info btn btn-default btn-mini color-info"></i></a>&nbsp;-->*}
                                            {if $IS_MODULE_EDITABLE}
                                                <a class="tooltip-left" data-tooltip="{vtranslate('LBL_EDIT', $MODULE)}" href='{$LISTVIEW_ENTRY->getEditViewUrl()}'><i title="{vtranslate('LBL_EDIT', $MODULE)}" class="fa fa-pencil btn btn-default btn-mini color-edit"></i></a>
                                                &nbsp;
                                            {/if}
                                            {if $IS_MODULE_DELETABLE}
                                                <a class="deleteRecordButton tooltip-left" data-tooltip="{vtranslate('LBL_DELETE', $MODULE)}"><i title="{vtranslate('LBL_DELETE', $MODULE)}" class="fa fa-remove btn btn-default btn-mini color-delete"></i></a>
                                            {/if}
										</span>
                                    </div>
                                </td>
                            {/if}
                            </td>
                        {/foreach}
                    </tr>
                {/foreach}
            </table>
            <!--added this div for Temporarily -->
            {if $LISTVIEW_ENTRIES_COUNT eq '0'}
                <table class="emptyRecordsDiv">
                    <tbody>
                    <tr>
                        <td>
                            {assign var=SINGLE_MODULE value="SINGLE_$MODULE"}
                            <img class="no_records" src="{vimage_path('no_records_list.png')}" alt="{vtranslate('LBL_NO_RECORDS')}" title="{vtranslate('LBL_NO_RECORDS')}"/>
                            <br>
                            <br>
                            {if $IS_RECORD_CREATABLE && $MODULE neq 'SMSNotifier'}
                            {vtranslate('LBL_EQ_ZERO')} {vtranslate($SINGLE_MODULE, $MODULE)} {vtranslate('LBL_FOUND')}.
                                &nbsp;
                                <a href="{$MODULE_MODEL->getCreateRecordUrl()}">
                                    <strong>{vtranslate('LBL_CREATE')} {vtranslate($SINGLE_MODULE, $MODULE)}<strong>
                                </a>
                            {elseif $MODULE eq 'SMSNotifier'}
                                <br>
                                <br>
                                <a href="index.php?module=SMSNotifier&parent=Settings&view=List">
                                    <strong>{vtranslate('LBL_SERVER_CONFIG', $MODULE)}<strong>
                                </a>
                            {/if}
                        </td>
                    </tr>
                    </tbody>
                </table>
            {/if}
        </div>
    </div>
{/strip}
{if $MODULE eq 'EmailTemplates'}
    <script>
        function resizeIframe(obj) {
            obj.style.height = 0;
            obj.style.height = obj.contentWindow.document.documentElement.scrollHeight + 'px';
        }
    </script>
{/if}
<script>
    jQuery(function () {
        jQuery('.call-to-action').modalLoadContent({
            debugMode: false
        });
        jQuery('.call-to-action').click(function (e) {
            NProgress.start();
            e.stopPropagation();
            NProgress.done();
        });
    });
</script>