/*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/

Magsoft_Detail_Js("HelpDesk_Detail_Js", {
    generateInvoice: function (id) {
        var postData = {
            module: 'HelpDesk',
            action: 'ConvertToInvoice',
            parentId: id,
        };
        NProgress.start();
        AppConnector.request(postData).then(
            function (response) {
                if (response.success) {
                    var invoiceid = response.result.data;
                    var invoicenumber = response.result.number;
                    var linkinvoice = 'index.php?module=Invoice&view=Detail&record=' + invoiceid;
                    var params = {
                        //title: app.vtranslate('JS_MESSAGE'),
                        title: app.vtranslate('JS_MESSAGE'),
                        text: app.vtranslate('JS_LBL_INVOICE_CREATED') + " <a href='" + linkinvoice + "'><span class='color-red'>" + app.vtranslate('JS_INVENTORY_RESUME') + " " + invoicenumber + "</span></a>",
                        animation: 'show',
                        type: 'success'
                    };
                    Magsoft_Helper_Js.showPnotify(params);
                    //window.location = linkinvoice;
                    Magsoft_Detail_Js.reloadRelatedList();
                    NProgress.done();
                } else {
                    Magsoft_Helper_Js.showPnotify(app.vtranslate('JS_LBL_NO_PRODUCTS_OR_SERVICES'));
                    NProgress.done();
                }
            },
            function (error, err) {

            }
        );
    }
}, {
    registerEventForAddingRelatedRecord: function () {
        var thisInstance = this;
        var detailContentsHolder = this.getContentHolder();
        detailContentsHolder.on('click', '[name="addButton"]', function (e) {
            var element = jQuery(e.currentTarget);
            var selectedTabElement = thisInstance.getSelectedTab();
            var relatedModuleName = thisInstance.getRelatedModuleName();
            var quickCreateNode = jQuery('#quickCreateModules').find('[data-name="' + relatedModuleName + '"]');
            if (quickCreateNode.length <= 0) {
                window.location.href = element.data('url');
                return;
            }

            var relatedController = new Magsoft_RelatedList_Js(thisInstance.getRecordId(), app.getModuleName(), selectedTabElement, relatedModuleName);
            relatedController.addRelatedRecord(element).then(function (data) {
                var relatedController2 = new HelpDesk_RelatedList_Js(thisInstance.getRecordId(), app.getModuleName(), selectedTabElement, relatedModuleName);
                relatedController2.registerEvents();
            });
        })
    },
    registerEventForRelatedList: function () {
        var thisInstance = this;
        var detailContentsHolder = this.getContentHolder();
        detailContentsHolder.on('click', '.relatedListHeaderValues', function (e) {
            var element = jQuery(e.currentTarget);
            var selectedTabElement = thisInstance.getSelectedTab();
            var relatedModuleName = thisInstance.getRelatedModuleName();
            var relatedController = new HelpDesk_RelatedList_Js(thisInstance.getRecordId(), app.getModuleName(), selectedTabElement, relatedModuleName);
            relatedController.sortHandler(element);
            relatedController.registerEvents();
        });

        detailContentsHolder.on('click', 'button.selectRelation', function (e) {
            var selectedTabElement = thisInstance.getSelectedTab();
            var relatedModuleName = thisInstance.getRelatedModuleName();
            var relatedController = new HelpDesk_RelatedList_Js(thisInstance.getRecordId(), app.getModuleName(), selectedTabElement, relatedModuleName);
            relatedController.showSelectRelationPopup().then(function (data) {
                relatedController.registerEvents();
            });
        });

        detailContentsHolder.on('click', 'a.relationDelete', function (e) {
            e.stopImmediatePropagation();
            var element = jQuery(e.currentTarget);
            var instance = Magsoft_Detail_Js.getInstance();
            //var key = instance.getDeleteMessageKey();
            //var message = app.vtranslate(key);
            var message = app.vtranslate('LBL_UNLINK_CONFIRMATION');
            Magsoft_Helper_Js.showConfirmationBox({'message': message}).then(
                function (e) {
                    var row = element.closest('tr');
                    var relatedRecordid = row.data('id');
                    var selectedTabElement = thisInstance.getSelectedTab();
                    var relatedModuleName = thisInstance.getRelatedModuleName();
                    var relatedController = new HelpDesk_RelatedList_Js(thisInstance.getRecordId(), app.getModuleName(), selectedTabElement, relatedModuleName);
                    relatedController.deleteRelation([relatedRecordid]).then(function (response) {
                        relatedController.loadRelatedList().then(function (data) {
                            relatedController.registerEvents();
                        });
                    });
                },
                function (error, err) {
                }
            );
        });
    },
    registerEventForRelatedTabClick: function () {
        var thisInstance = new HelpDesk_Detail_Js();
        var detailContentsHolder = thisInstance.getContentHolder();
        var detailContainer = detailContentsHolder.closest('div.contentsDiv');

        jQuery('.related', detailContainer).on('click', 'li', function (e, urlAttributes) {
            var tabElement = jQuery(e.currentTarget);
            var element = jQuery('<div></div>');
            element.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true,
                    'elementToBlock': detailContainer
                }
            });
            //NProgress.start();
            var url = tabElement.data('url');
            if (typeof urlAttributes != 'undefined') {
                var callBack = urlAttributes.callback;
                delete urlAttributes.callback;
            }

            thisInstance.loadContents(url, urlAttributes).then(
                function (data) {
                    thisInstance.deSelectAllrelatedTabs();
                    thisInstance.markTabAsSelected(tabElement);
                    element.progressIndicator({'mode': 'hide'});
                    thisInstance.registerRelatedListEvents();
                    if (typeof callBack == 'function') {
                        callBack(data);
                    }
                    //Summary tab is clicked
                    if (tabElement.data('linkKey') == thisInstance.detailViewSummaryTabLabel) {
                        thisInstance.loadWidgets();
                        thisInstance.registerSummaryViewContainerEvents(detailContentsHolder);
                        thisInstance.registerEventForPicklistDependencySetup(thisInstance.getForm());
                    } else if (tabElement.data('linkKey') == thisInstance.detailViewDetailsTabLabel) {
                        thisInstance.registerEventForPicklistDependencySetup(thisInstance.getForm());
                    }

                    app.showSelect2ElementView(detailContentsHolder.find('select.select2'));
                    app.changeSelectElementView(detailContentsHolder);

                    // Let listeners know about page state change.
                    //NProgress.done();
                    app.notifyPostAjaxReady();
                },
                function () {
                    //TODO : handle error
                    element.progressIndicator({'mode': 'hide'});
                    //NProgress.done();
                }
            );
        });
    },

    registerQtdFieldClickEvent: function () {
        var detailContentsHolder = this.getContentHolder();
        detailContentsHolder.on('click', '.txt_assignqty', function (e) {
            e.stopPropagation();
        })
    },

    registerSaveQtdFieldClickEvent: function () {
        var detailContentsHolder = this.getContentHolder();
        detailContentsHolder.on('click', '.btn_save_qnty', function (e) {
            e.stopPropagation();
            var element = jQuery(e.currentTarget);
            var relrecordid = element.data('relrecordid');
            var parentid = element.data('parentid');
            var tkt_rel_id = element.closest('td').find('.tkt_rel_id').val();
            var assign_qty = element.closest('td').find('.txt_assignqty').val();
            //if (assign_qty == '' || assign_qty == 0) {
            if (assign_qty == '') {
                //Magsoft_Helper_Js.showPnotify(app.vtranslate('JS_VALUE_SHOULD_BE_GREATER_THAN_ZERO'));
                Magsoft_Helper_Js.showPnotify(app.vtranslate('JS_VALUE_MUST_NOT_BE_EMPTY'));
            } else {
                var params = {};
                params['module'] = app.getModuleName();
                params['view'] = 'Detail';
                params['mode'] = 'deductproduct_qty';
                params['relrecordid'] = relrecordid;
                params['parentid'] = parentid;
                params['assign_qty'] = assign_qty;
                params['tkt_rel_id'] = tkt_rel_id;

                var message = app.vtranslate('JS_LBL_TQD_WILL_DEDUCT');
                Magsoft_Helper_Js.showConfirmationBox({'message': message}).then(
                    function (e) {
                        var progressInstance = jQuery.progressIndicator();
                        AppConnector.request(params).then(function (data) {
                            progressInstance.progressIndicator({'mode': 'hide'});
                            var returnedData = JSON.parse(data);
                            var sendsuccess = returnedData.result.message;
                            var finalqtd = returnedData.result.finalqtd;
                            var param = {
                                text: sendsuccess + finalqtd,
                                type: 'success',
                                icon: 'fa fa-sort-numeric-asc'
                            };
                            Magsoft_Helper_Js.showPnotify(param);

                            var recordLabelElement = element.closest('tr').find('.qtyinstock');
                            if (recordLabelElement.length > 0) {
                                recordLabelElement.text(finalqtd);
                            }
                        });
                    },
                    function (error, err) {

                    }
                );
            }
        })
    },

    registerEventForImageGraphics: function () {
        var imageContainer = jQuery('.cycle-slideshow');
        imageContainer.cycle({
            speed: 900,
            log: false,
        });
        imageContainer.find('img').on('mouseenter', function () {
            imageContainer.cycle('pause');
        }).on('mouseout', function () {
            imageContainer.cycle('resume');
        })
    },

    registerRelatedListEvents: function () {
        var selectedTabElement = this.getSelectedTab();
        var relatedModuleName = this.getRelatedModuleName();
        var relatedController = new HelpDesk_RelatedList_Js(this.getRecordId(), app.getModuleName(), selectedTabElement, relatedModuleName);
        //relatedController.registerEvents();
    },
    registerEvents: function () {
        this.registerRelatedListEvents();
        this.registerQtdFieldClickEvent();
        this.registerSaveQtdFieldClickEvent();
        //this.registerEventForImageGraphics();
        this._super();
    }
})