{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    <span class="span tooltip-right" data-tooltip="{vtranslate($MODULE_NAME)}">
    	<img src='{vimage_path("summary_{$MODULE_NAME}.png")}' class="summaryImg"/>
    </span>
    <span class="span10">
        <span class="row-fluid">
            <h4 class="recordLabel pushDown" title="{$RECORD->getName()}">
                {foreach item=NAME_FIELD from=$MODULE_MODEL->getNameFields()}
                    {assign var=FIELD_MODEL value=$MODULE_MODEL->getField($NAME_FIELD)}
                    {if $FIELD_MODEL->getPermissions()}
                        <span>{$RECORD->getDisplayValue('ticket_no')}</span>
                        &nbsp;-&nbsp;
                        <span class="{$NAME_FIELD}">{$RECORD->get($NAME_FIELD)}</span>
                    {/if}
                {/foreach}
            </h4>
        </span>
        <span class="row-fluid">
            {assign var=STATUS value=$RECORD->get('ticketstatus')}
            {if !empty($STATUS)}
            <span class="muted">{vtranslate('LBL_STATUS',$MODULE_NAME)} - </span>
            {if $STATUS|strstr:'Open'}
                <span class="ticketstatus_label color-red">{$RECORD->getDisplayValue('ticketstatus')}</span>
            {elseif $STATUS|strstr:'Progress'}
                <span class="ticketstatus_label color-grey">{$RECORD->getDisplayValue('ticketstatus')}</span>
            {elseif $STATUS|strstr:'Wait'}
                <span class="ticketstatus_label color-blue">{$RECORD->getDisplayValue('ticketstatus')}</span>
            {elseif $STATUS|strstr:'Aguarda'}
            	<span class="ticketstatus_label color-blue">{$RECORD->getDisplayValue('ticketstatus')}</span>
            {elseif $STATUS|strstr:'Closed'}
                <span class="ticketstatus_label color-green"><i class="fa fa-check" aria-hidden="true"></i> {$RECORD->getDisplayValue('ticketstatus')}</span>
            {elseif $STATUS|strstr:'Entregue'}
                <span class="ticketstatus_label color-green">{$RECORD->getDisplayValue('ticketstatus')}</span>
            {else}
                <span class="ticketstatus_label color-yellow">{$RECORD->getDisplayValue('ticketstatus')}</span>
            {/if}
            {/if}
            {assign var=ORCAMENTO value=$RECORD->get('orcamento_id')}
            {if !empty($ORCAMENTO) && ($ORCAMENTO neq '0')}
                {assign var=CURRENCY_SYMBOL_PLACEMENT value={$CURRENT_USER_MODEL->get('currency_symbol_placement')}}
                {if !empty($STATUS)}
                &nbsp;-&nbsp;
                {/if}
                <span class="orcamento_id_label color-blue">
        			{if $CURRENCY_SYMBOL_PLACEMENT eq '1.0$'}
                        {$RECORD->getDisplayValue('orcamento_id')} {$USER_MODEL->get('currency_symbol')}
                    {else}
                        {$USER_MODEL->get('currency_symbol')} {$RECORD->getDisplayValue('orcamento_id')}
                    {/if}
                </span>
            {/if}
        </span>
    </span>
{/strip}