/*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/
jQuery.Class("MapView", {

    url: "index.php?module=Google&action=MapAjax&mode=getLocation",

    /**
     * function to make api request to google maps.
     * On completion display the image
     */
    showMap: function () {
        var record = jQuery('#map_record').html();
        var module = jQuery('#map_module').html();
        MapView.url += '&recordid=' + record + '&source_module=' + module;
        jQuery.ajax({
            url: MapView.url
        }).done(function (res) {
            var result = JSON.parse(res);
            var address = result["address"];
            var map_url = MapView.getStaticMapURL(address, "512x712");
            var location = jQuery.trim((address).replace(/\,/g, " "));
            if (location != '' && location != null) {
                jQuery("#map_address").html(location);
                jQuery('#map_address').show();
            }
            jQuery("#map_canvas").append("<img id='map_image' style='border-top: 1px solid #eeeeee;'></img>");
            jQuery("#map_image").attr("src", map_url);
            jQuery("#map_image").addClass('cursorPointer');
            jQuery("#map_image").on('click', function () {
                window.open(MapView.getQueryString(address, '_parent'));
            });
            jQuery("#map_link").on('click', function () {
                window.open(MapView.getQueryString(address, '_parent'));
            });
        });
    },
    /**
     * get the googleapis url based on the address and the size of the image.
     */
    getStaticMapURL: function (address, size) {
        var encoded_address = encodeURIComponent(address);
        var url = "https://maps.googleapis.com/maps/api/staticmap?size=" + size + "&key=AIzaSyBQbxmjDqrOyeF3Tb0RtzdJ-85mN1wKKJk&maptype=roadmap&markers=size:mid%7Ccolor:red%7C" + encoded_address;
        return url;
    },

    getQueryString: function (address) {
        address = address.replace(/ /g, '+');
        return "https://maps.google.com/maps?q=" + address;
    }

}, {});

jQuery(document).ready(function () {
    MapView.showMap();
});