{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
*
 ********************************************************************************/
-->*}
{strip}
    <div class="SendEmailFormStep2" name="emailPreview">
        <input type="hidden" name="parentRecord" value="{$PARENT_RECORD}"/>
        <input type="hidden" name="recordId" value="{$RECORD_ID}"/>
        <br><br>
        <div class="well well-large" style="margin: 0 3%; padding: 0;">
            <div class="modal-header blockHeader emailPreviewHeader" style="height:30px;">
                <h3 class='pull-left'>{vtranslate('SINGLE_Emails', $MODULE)} {vtranslate('LBL_INFO', $MODULE)}</h3>
                <div class='pull-right'>
				<span class="btn-toolbar">
					<span class="btn-group">
						<button type="button" name="previewReply" class="btn" data-mode="emailReply">
							{vtranslate('LBL_REPLY',$MODULE)}
						</button>
					</span>
					<span class="btn-group">
						<button type="button" name="previewForward" class="btn" data-mode="emailForward">
							{vtranslate('LBL_FORWARD',$MODULE)}
						</button>
					</span>
                    {if !($RECORD->isSentMail())}
                        <span class="btn-group">
							<button type="button" name="previewEdit" class="btn" data-mode="emailEdit">
								{vtranslate('LBL_EDIT',$MODULE)}
							</button>
						</span>
                    {/if}
                    <span class="btn-group">
						<button type="button" name="previewPrint" class="btn" data-mode="previewPrint">
							{vtranslate('LBL_PRINT',$MODULE)}
						</button>
					</span>
				</span>
                </div>
            </div>
			<div class="mainwindow" style="padding-bottom: 15px;">
				<div style="margin: -15px -15px 15px -15px" class="modal-header contentsBackground">
					<button class="close modal-load-content-close" aria-hidden="true" data-dismiss="modal" type="button" title="{vtranslate('LBL_CLOSE')}">&times;</button>
					{*<a class="pull-right pushDown marginRight10px tooltip-left" data-tooltip="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE_NAME)}" onclick="window.location.href='{$RECORD->getDetailViewUrl()}'">
                        <span class="color-grey">{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE_NAME)}</span>
                    </a>*}
					<h3>{vtranslate('LBL_GO_TO_PREVIEW')}</h3>
				</div>
            <form class="form-horizontal emailPreview" method="POST">
            <div class="padding20">
                <div class="row-fluid">
				<span class="span12 row-fluid">
					<span class="span">
						<span class="muted"><strong>{vtranslate('LBL_FROM',$MODULE)}:</strong></span>
					</span>
					<span class="span9">
						<span class="row-fluid">{$FROM}</span>
					</span>
				</span>
                </div>
                <hr><div class="row-fluid">
				<span class="span12 row-fluid">
					<span class="span">
						<span class="muted"><strong>{vtranslate('LBL_TO',$MODULE)}:</strong></span>
					</span>
					<span class="span9">
                        {if empty($TO)}
                            {assign var=TO value=array()}
                        {/if}
                        {assign var=TO_EMAILS value=","|implode:$TO}
						{$find = [']', '[', '&quot;', '"', "\\"]}
						{$repl = ['', '', '', '', '']}
                        <span class="row-fluid">{$TO_EMAILS|replace:$find:$repl}</span>
					</span>
				</span>
                </div>
                {if !empty($CC)}
                    <hr><div class="row-fluid">
				<span class="span12 row-fluid">
					<span class="span">
						<span class="muted"><strong>{vtranslate('LBL_CC',$MODULE)}:</strong></span>
					</span>
					<span class="span9">
						<span class="row-fluid">
							{$CC}
						</span>
					</span>
				</span>
                    </div>
                {/if}
                {if !empty($BCC)}
                    <hr><div class="row-fluid">
				<span class="span12 row-fluid">
					<span class="span">
						<span class="muted"><strong>{vtranslate('LBL_BCC',$MODULE)}:</strong></span>
					</span>
					<span class="span9">
						<span class="row-fluid">
							{$BCC}
						</span>
					</span>
				</span>
                    </div>
                {/if}
                <hr><div class="row-fluid">
				<span class="span12 row-fluid">
					<span class="span">
						<span class="muted"><strong>{vtranslate('LBL_SUBJECT',$MODULE)}</strong></span>
					</span>
					<span class="span9">
						<span class="row-fluid">
							{$RECORD->get('subject')}
						</span>
					</span>
				</span>
                </div>
                <hr><div class="row-fluid">
				<span class="span12 row-fluid">
					<span class="span">
						<span class="muted"><strong>{vtranslate('LBL_ATTACHMENT',$MODULE)}:</strong></span>
					</span>
					<span class="span9">
						<span class="row-fluid">
							{foreach item=ATTACHMENT_DETAILS  from=$RECORD->getAttachmentDetails()}
                                <a &nbsp;
                                        {if array_key_exists('docid',$ATTACHMENT_DETAILS)}
                                &nbsp; href="index.php?module=Documents&action=DownloadFile&record={$ATTACHMENT_DETAILS['docid']}
                                                &fileid={$ATTACHMENT_DETAILS['fileid']}"
                                        {else}
                                &nbsp; href="index.php?module=Emails&action=DownloadFile&attachment_id={$ATTACHMENT_DETAILS['fileid']}"
                                        {/if}><i class="fa fa-download" aria-hidden="true"></i> {$ATTACHMENT_DETAILS['attachment']}</a>
                                &nbsp;&nbsp;
                            {/foreach}
						</span>
					</span>
				</span>
                </div>
                <hr><div class="row-fluid">
				<span class="span12 row-fluid">
					<span class="span">
						<span class="muted"><strong>{vtranslate('LBL_DESCRIPTION',$MODULE)}:</strong></span>
					</span>
					<span class="span12 marginLeftZero">
						{*<hr>*}
						<br>
						<span class="row-fluid">
							{decode_html($RECORD->get('description'))}
						</span>
					</span>
				</span>
                </div>
            	</div>
                <div class="row-fluid">
                    <span><hr/></span>
                </div>
				<div style="height:30px;">
					{*<span class="span2 textAlignRight"><strong>{vtranslate('LBL_OWNER',$MODULE)}:</strong></span>*}
					<span class="span">
					<strong>{getOwnerName($RECORD->get('assigned_user_id'))}</strong>
					&nbsp;-&nbsp;
					<span class="muted">
						{if $RECORD->get('email_flag') eq "SAVED"}
							<small><em>{vtranslate('LBL_DRAFTED_ON',$MODULE)}</em></small>
							<span><small><em>&nbsp;{Magsoft_Util_Helper::formatDateTimeIntoDayString($RECORD->get('createdtime'))}</em></small></span>
						{elseif $RECORD->get('email_flag') eq "MailManager"}
                            <small><em>{vtranslate('LBL_MAIL_DATE',$MODULE)} : </em></small>
						{assign var="MAIL_DATE" value=$RECORD->get('date_start')|@cat:' '|@cat:$RECORD->get('time_start')}
                            <span><small><em>&nbsp;{Magsoft_Util_Helper::formatDateTimeIntoDayString($MAIL_DATE)}</em></small></span>
                        {elseif $RECORD->get('email_flag') eq "FAILED"}
							<small><em>{vtranslate('LBL_FAILED_ON',$MODULE)}</em></small>
							<span><small><em>&nbsp;{Magsoft_Util_Helper::formatDateTimeIntoDayString($RECORD->get('createdtime'))}</em></small></span>
						{else}
                            <small><em>{vtranslate('LBL_SENT_ON',$MODULE)}</em></small>
						{assign var="SEND_TIME" value=$RECORD->get('date_start')|@cat:' '|@cat:$RECORD->get('time_start')}
                            <span><small><em>&nbsp;{Magsoft_Util_Helper::formatDateTimeIntoDayString($SEND_TIME)}</em></small></span>
						{/if}
					</span>
				</span>
				</div>
            </form>
			</div>
        </div>
        <br><br>
    </div>
    {include file='JSResources.tpl'|vtemplate_path}
{/strip}