{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    {if !empty($CUSTOM_VIEWS)}
        {assign var=RELATED_MODULE_NAME value=$RELATED_MODULE->get('name')}
        <div class="relatedContainer listViewPageDiv margin0px">
            <input type="hidden" name="emailEnabledModules" value='true'/>
            <input type="hidden" id="view" value="{$VIEW}"/>
            <input type="hidden" name="currentPageNum" value="{$PAGING->getCurrentPage()}"/>
            <input type="hidden" name="relatedModuleName" class="relatedModuleName" value="{$RELATED_MODULE_NAME}"/>
            <input type="hidden" value="{$ORDER_BY}" id="orderBy">
            <input type="hidden" value="{$SORT_ORDER}" id="sortOrder">
            <input type="hidden" value="{$RELATED_ENTIRES_COUNT}" id="noOfEntries">
            <input type='hidden' value="{$PAGING->getPageLimit()}" id='pageLimit'>
            <input type="hidden" id="recordsCount" value=""/>
            <input type="hidden" id="selectedIds" name="selectedIds" data-selected-ids={ZEND_JSON::encode($SELECTED_IDS)}/>
            <input type="hidden" id="excludedIds" name="excludedIds" data-excluded-ids={ZEND_JSON::encode($EXCLUDED_IDS)}/>
            <input type="hidden" id="recordsCount" name="recordsCount"/>
            <input type='hidden' value="{$TOTAL_ENTRIES}" id='totalCount'>
            <div class="relatedHeader">
                <div class="btn-toolbar row-fluid">
                    <div class="span5">
                        {foreach item=RELATED_LINK from=$RELATED_LIST_LINKS['LISTVIEWBASIC']}
                            <div class="btn-group">
                                {assign var=IS_SELECT_BUTTON value={$RELATED_LINK->get('_selectRelation')}}
                                {assign var=IS_SEND_EMAIL_BUTTON value={$RELATED_LINK->get('_sendEmail')}}
                                <button type="button" class="btn btn-dark
                            	{if $IS_SELECT_BUTTON eq true} selectRelation {/if}"
                                        {if $IS_SELECT_BUTTON eq true} data-moduleName="{$RELATED_LINK->get('_module')->get('name')}" {/if}
                                        {if $RELATION_FIELD} data-name="{$RELATION_FIELD->getName()}" {/if}
                                        {if $IS_SEND_EMAIL_BUTTON eq true} onclick="{$RELATED_LINK->getUrl()}" {else} data-url="{$RELATED_LINK->getUrl()}"{/if}
                                        {if ($IS_SELECT_BUTTON eq false) and ($IS_SEND_EMAIL_BUTTON eq false)}
                                        name="addButton">
                                    <i class="fa fa-plus"></i>
                                    {else} >
                                    <i class="fa fa-check-square-o"></i>
                                    {/if}
                                </button>
                                <button type="button" class="btn addButton
                            	{if $IS_SELECT_BUTTON eq true} selectRelation {/if}"
                                        {if $IS_SELECT_BUTTON eq true} data-moduleName="{$RELATED_LINK->get('_module')->get('name')}" {/if}
                                        {if $RELATION_FIELD} data-name="{$RELATION_FIELD->getName()}" {/if}
                                        {if $IS_SEND_EMAIL_BUTTON eq true} onclick="{$RELATED_LINK->getUrl()}" {else} data-url="{$RELATED_LINK->getUrl()}"{/if}
                                        {if ($IS_SELECT_BUTTON eq false) and ($IS_SEND_EMAIL_BUTTON eq false)}
                                    name="addButton"{/if}>
                                    {$RELATED_LINK->getLabel()}
                                </button>
                            </div>
                        {/foreach}
                        &nbsp;
                    </div>
                    <div class="span3">
                        <span class="customFilterMainSpan row-fluid">
                            {if $CUSTOM_VIEWS|@count gt 0}
                                <select id="recordsFilter" class="span12" data-placeholder="{vtranslate('LBL_SELECT_TO_LOAD_LIST', $RELATED_MODULE_NAME)}">
                                    <option></option>
                                    {foreach key=GROUP_LABEL item=GROUP_CUSTOM_VIEWS from=$CUSTOM_VIEWS}
                                        <optgroup label="{if $GROUP_LABEL eq 'Mine'} {vtranslate($GROUP_LABEL)} {else} {vtranslate($GROUP_LABEL)} {/if}">
                                            {foreach item="CUSTOM_VIEW" from=$GROUP_CUSTOM_VIEWS}
                                                <option id="filterOptionId_{$CUSTOM_VIEW->get('cvid')}" value="{$CUSTOM_VIEW->get('cvid')}" class="filterOptionId_{$CUSTOM_VIEW->get('cvid')}{if $CURRENT_USER_MODEL->isAdminUser()} adminlogged{/if}" data-id="{$CUSTOM_VIEW->get('cvid')}">{if $CUSTOM_VIEW->get('viewname') eq 'All'}{vtranslate($CUSTOM_VIEW->get('viewname'), $RELATED_MODULE_NAME)} {vtranslate($RELATED_MODULE_NAME)}{else}{vtranslate($CUSTOM_VIEW->get('viewname'), $RELATED_MODULE_NAME)}{/if}{if $GROUP_LABEL neq 'Mine'} [ {$CUSTOM_VIEW->getOwnerName()} ] {/if}</option>
                                            {/foreach}
                                        </optgroup>
                                    {/foreach}
                                </select>
                                <i class="fa fa-sort-amount-asc filterImage" style="display:none;margin-right:10px;"></i>
		                    {else}
                                <input type="hidden" value="0" id="customFilter"/>
                            {/if}
                        </span>
                    </div>
                    <div class="span4">
                        <div class="pull-right">
                            {if !empty($RELATED_RECORDS)}
                                <span class="pageNumbers">
                                    <span class="pageNumbersText"> {$PAGING->getRecordStartRange()} {vtranslate('LBL_to', $RELATED_MODULE_NAME)} {$PAGING->getRecordEndRange()} / {$TOTAL_ENTRIES}
                                    </span>
                                </span>
                            {else}{/if}
                            <span class="btn-group">
                                <button class="btn" id="relatedListPreviousPageButton" {if !$PAGING->isPrevPageExists()} disabled {/if} type="button"><span class="fa fa-chevron-left"></span></button>
                                <button class="btn dropdown-toggle" type="button" id="relatedListPageJump" data-toggle="dropdown" {if $PAGE_COUNT eq 1} disabled {/if}>
                                    <i class="fa fa-files-o" title="{vtranslate('LBL_LISTVIEW_PAGE_JUMP',$moduleName)}"></i>
                                </button>
                                <ul class="listViewBasicAction dropdown-menu" id="relatedListPageJumpDropDown">
                                    <li>
                                        <span class="row-fluid">
                                            <span class="span3"><span class="pull-right">{vtranslate('LBL_PAGE',$moduleName)}</span></span>
                                            <span class="span4">
                                                <input type="text" id="pageToJump" class="listViewPagingInput" value="{$PAGING->getCurrentPage()}"/>
                                            </span>
                                            <span class="span2 textAlignCenter">
                                                {vtranslate('LBL_OF',$moduleName)}
                                            </span>
                                            <span class="span3" id="totalPageCount">{$PAGE_COUNT}</span>
                                        </span>
                                    </li>
                                </ul>
                                <button class="btn" id="relatedListNextPageButton" {if (!$PAGING->isNextPageExists()) or ($PAGE_COUNT eq 1)} disabled {/if} type="button"><span class="fa fa-chevron-right"></span></button>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div id="selectAllMsgDiv" class="alert-block msgDiv">
                <strong><a id="selectAllMsg">{vtranslate('LBL_SELECT_ALL',$MODULE)}&nbsp;{vtranslate($RELATED_MODULE_NAME)}&nbsp;(<span id="totalRecordsCount"></span>)</a></strong>
            </div>
            <div id="deSelectAllMsgDiv" class="alert-block msgDiv">
                <strong><a id="deSelectAllMsg">{vtranslate('LBL_DESELECT_ALL_RECORDS',$MODULE)}</a></strong>
            </div>
            <div class="contents-topscroll">
                <div class="topscroll-div">
                    &nbsp;
                </div>
            </div>
            <div class="relatedContents contents-bottomscroll" style="min-height:350px;">
                <div class="bottomscroll-div">
                    {assign var=WIDTHTYPE value=$USER_MODEL->get('rowheight')}
                    {if empty($RELATED_RECORDS)}
                        <table class="emptyRecordsDiv" style="border-top: 1px solid #dddddd;">
                            <tbody>
                            <tr>
                                <td>
                                    {assign var=SINGLE_RELATED_MODULE value="SINGLE_$RELATED_MODULE_NAME"}
                                    <img class="no_records" src="{vimage_path('no_records_list.png')}" alt="{vtranslate('LBL_NO_RECORDS')}" title="{vtranslate('LBL_NO_RECORDS')}"/>
                                    <br>
                                    <br>
                                    {vtranslate('LBL_NO', $MODULE)} {vtranslate($SINGLE_RELATED_MODULE, $RELATED_MODULE_NAME)} {vtranslate('LBL_FOUND')}
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    {else}
                    <table class="table table-bordered listViewEntriesTable">
                        <thead>
                        <tr class="listViewHeaders">
                            <th width="5%">
                                <div class="pretty p-default p-smooth">
                                    <input type="checkbox" id="listViewEntriesMainCheckBox"/>
                                    <div class="state p-primary">
                                        <label></label>
                                    </div>
                                </div>
                            </th>
                            {foreach item=HEADER_FIELD from=$RELATED_HEADERS}
                                <th nowrap>
                                    {if $HEADER_FIELD->get('column') eq 'access_count' or $HEADER_FIELD->get('column') eq 'idlists' }
                                        <a href="javascript:void(0);" class="noSorting">{vtranslate($HEADER_FIELD->get('label'), $RELATED_MODULE_NAME)}</a>
                                    {elseif $HEADER_FIELD->get('column') eq 'time_start'}
                                    {else}
                                        <a href="javascript:void(0);" class="relatedListHeaderValues" data-nextsortorderval="{if $COLUMN_NAME eq $HEADER_FIELD->get('column')}{$NEXT_SORT_ORDER}{else}ASC{/if}" data-fieldname="{$HEADER_FIELD->get('column')}">{vtranslate($HEADER_FIELD->get('label'), $RELATED_MODULE_NAME)}
                                            &nbsp;{if $COLUMN_NAME eq $HEADER_FIELD->get('column')}
                                            <i class="{$SORT_IMAGE}"></i>{/if}
                                        </a>
                                    {/if}
                                </th>
                            {/foreach}
                            <th nowrap colspan="2">
                                <a href="javascript:void(0);" class="noSorting">{vtranslate('Status', $RELATED_MODULE_NAME)}</a>
                            </th>
                        </tr>
                        </thead>
                        {foreach item=RELATED_RECORD from=$RELATED_RECORDS}
                            <tr class="listViewEntries" data-id='{$RELATED_RECORD->getId()}' data-recordUrl='{$RELATED_RECORD->getDetailViewUrl()}'>
                                <td width="5%" class="wide" style="padding-right: 0 !important;min-width: 48px;">
                                    <div class="pretty p-default p-smooth">
                                        <input type="checkbox" value="{$RELATED_RECORD->getId()}" class="listViewEntriesCheckBox"/>
                                        <div class="state p-primary">
                                            <label></label>
                                        </div>
                                    </div>
                                    <a class="call-to-action tooltip-right" data-tooltip="{vtranslate('LBL_GO_TO_PREVIEW', $MODULE)}" data-target=".mainwindow" href="{$RELATED_RECORD->getDetailViewUrl()}"><i class="fa fa-circle-thin fa-lg" style="color:#0074D9" aria-hidden="true"></i></a>
                                </td>
                                {foreach item=HEADER_FIELD from=$RELATED_HEADERS}
                                    {assign var=RELATED_HEADERNAME value=$HEADER_FIELD->get('name')}
                                    <td nowrap class="{$WIDTHTYPE}">
                                        {if $HEADER_FIELD->isNameField() eq true or $HEADER_FIELD->get('uitype') eq '4'}
                                            <a href="{$RELATED_RECORD->getDetailViewUrl()}">{$RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME)}</a>
                                        {elseif $RELATED_HEADERNAME eq 'access_count'}
                                            {$RELATED_RECORD->getAccessCountValue($PARENT_RECORD->getId())}
                                        {elseif $RELATED_HEADERNAME eq 'time_start'}
                                        {else}
                                            {$RELATED_RECORD->getDisplayValue($RELATED_HEADERNAME)}
                                        {/if}
                                    </td>
                                {/foreach}
                                <td nowrap class="{$WIDTHTYPE}">
                                    <span class="currentStatus btn-group">
                                        <i title="{vtranslate('LBL_EDIT', $MODULE)}" class="icon-arrow-down alignMiddle editRelatedStatus"></i>&nbsp;&nbsp;
                                        {if $RELATED_RECORD->get('status') eq 'Contacted - Never Contact Again'}
                                            <span class="color-red statusValue dropdown-toggle" data-toggle="dropdown">{vtranslate($RELATED_RECORD->get('status'),$MODULE)}</span>
                                        {elseif $RELATED_RECORD->get('status') eq 'Contacted - Unsuccessful'}
                                        	<span class="color-yellow statusValue dropdown-toggle" data-toggle="dropdown">{vtranslate($RELATED_RECORD->get('status'),$MODULE)}</span>
                                        {elseif $RELATED_RECORD->get('status') eq 'Contacted - Successful'}
                                        	<span class="color-green statusValue dropdown-toggle" data-toggle="dropdown">{vtranslate($RELATED_RECORD->get('status'),$MODULE)}</span>
                                        {else}
                                        	<span class="statusValue" data-toggle="dropdown">{vtranslate($RELATED_RECORD->get('status'),$MODULE)}</span>
                                        {/if}
                                        <ul class="dropdown-menu pull-right">
                                            {foreach key=STATUS_ID item=STATUS from=$STATUS_VALUES}
                                                <li id="{$STATUS_ID}" data-status="{vtranslate($STATUS, $MODULE)}">
                                                    <a>{vtranslate($STATUS, $MODULE)}</a>
                                                </li>
                                            {/foreach}
                                        </ul>
                                    </span>
                                </td>
                                <td nowrap class="{$WIDTHTYPE}">
                                    <div class="pull-right actions">
                                        <span class="actionImages">
                                            {*<!--<a class="tooltip-left" data-tooltip="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE)}" href="{$RELATED_RECORD->getFullDetailViewUrl()}"><i title="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE)}" class="fa fa-info btn btn-default btn-mini color-info"></i></a>&nbsp;-->*}
                                            {if $IS_EDITABLE}
                                                <a class="tooltip-left" data-tooltip="{vtranslate('LBL_EDIT', $MODULE)}" href='{$RELATED_RECORD->getEditViewUrl()}'><i title="{vtranslate('LBL_EDIT', $MODULE)}" class="fa fa-pencil btn btn-default btn-mini color-edit"></i></a>
                                                &nbsp;
                                            {/if}
                                            {if $IS_DELETABLE}
                                                <a class="relationDelete tooltip-left" data-tooltip="{vtranslate('LBL_UNLINK', $MODULE)}"><i title="{vtranslate('LBL_UNLINK', $MODULE)}" class="fa fa-chain-broken btn btn-default btn-mini color-delete"></i></a>
                                            {/if}
                                        </span>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </table>
                    {/if}
                </div>
            </div>
        </div>
    {else}
        {include file='RelatedList.tpl'|@vtemplate_path}
    {/if}
{/strip}
<script>
    jQuery(function () {
        jQuery('.call-to-action').modalLoadContent({
            debugMode: false
        });
        jQuery('.call-to-action').click(function (e) {
            NProgress.start();
            e.stopPropagation();
            NProgress.done();
        });
    });
</script>