{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    <div class="modelContainer" style="width:40em;">
        <div class="modal-header contentsBackground">
            <button class="close" aria-hidden="true" data-dismiss="modal" type="button" title="{vtranslate('LBL_CLOSE')}">&times;</button>
            <h3>{vtranslate('LBL_CREATE_FOLLOWUP_EVENT', "Events")}</h3>
        </div>
        {assign var=RECORD_ID value="{$RECORD_MODEL->get('id')}"}
        {assign var="dateFormat" value=$USER_MODEL->get('date_format')}
        {assign var="timeformat" value=$USER_MODEL->get('hour_format')}
        {assign var="currentDate" value=Magsoft_Date_UIType::getDisplayDateValue('')}
        {assign var="time" value=Magsoft_Time_UIType::getDisplayTimeValue(null)}
        {assign var="currentTimeInMagsoftFormat" value=Magsoft_Time_UIType::getDisplayValue($time)}
        {assign var=FOLLOW_UP_LABEL value={vtranslate('LBL_HOLD_FOLLOWUP_ON',"Events")}}
        <form class="form-horizontal followupCreateView" id="followupQuickCreate" name="followupQuickCreate" method="post" action="index.php">
            <input type="hidden" name="module" value="{$MODULE}">
            <input type="hidden" name="action" value="SaveFollowupAjax"/>
            <input type="hidden" name="mode" value="createFollowupEvent">
            <input type="hidden" name="record" value="{$RECORD_ID}"/>
            <input type="hidden" name="defaultCallDuration" value="{$USER_MODEL->get('callduration')}"/>
            <input type="hidden" name="defaultOtherEventDuration" value="{$USER_MODEL->get('othereventduration')}"/>
            <input class="dateField" type="hidden" name="date_start" value="{$STARTDATE}" data-date-format="{$dateFormat}" data-fieldinfo="{Magsoft_Util_Helper::toSafeHTML(ZEND_JSON::encode($STARTDATEFIELDMODEL))}"/>
            <div class="modal-body">
                {$FIELD_INFO['label'] = {$FOLLOW_UP_LABEL}}
                <div class="control-group">
                        <h4>{$FOLLOW_UP_LABEL}</h4>
                        <br>
                        <div class="input-append row-fluid">
                        	<div class="input-append time">
                            <input type="text" name="followup_time_start" class="timepicker-default input-small"
                                   value="{$currentTimeInMagsoftFormat}" data-format="{$timeformat}" data-validation-engine="validate[ required,funcCall[Magsoft_Base_Validator_Js.invokeValidation]]"/>
                            <span class="add-on cursorPointer">
                            <i class="fa fa-clock-o"></i>
                        </span>
                        </div>
                            <div class="span6 row-fluid date">
                                <input name="followup_date_start" type="text" class="span9 dateField" data-date-format="{$dateFormat}" type="text" data-fieldinfo='{Magsoft_Util_Helper::toSafeHTML(ZEND_JSON::encode($FIELD_INFO))}'
                                       value="{$currentDate}" data-validation-engine="validate[ required,funcCall[Magsoft_Base_Validator_Js.invokeValidation]] validate[funcCall[Magsoft_greaterThanDependentField_Validator_Js.invokeValidation,]]"/>
                                <span class="add-on"><i class="fa fa-calendar-check-o"></i></span>
                            </div>
                        </div>
                    <br>
                </div>
            </div>
        	<div class="modal-footer quickCreateActions">
            	<a class="cancelLink cancelLinkContainer pull-right" type="reset" data-dismiss="modal">{vtranslate('LBL_CANCEL', $MODULE)}</a>
                <button class="btn btn-success" type="submit">
                    <strong>{vtranslate('LBL_CREATE', $MODULE)}</strong></button>
            </div>
        </form>
    </div>
{/strip}
