<?php
/* * *******************************************************************************
 * The content of this file is subject to the Magsoft Customer Portal license.
 * ("License"); You may not use this file except in compliance with the License
 * All Rights Reserved.
 * ****************************************************************************** */
?>
<div id="page-wrapper">
    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header"><?php echo Language::translate($module); ?></h1>
        </div>
        <!-- /.col-lg-12 -->
    </div>
    <?php
    if (isset($data['plugin_data']['views']['header'])) {
        foreach ($data['plugin_data']['views']['header'] as $pluginname => $viewname) {
            Template::displayPlugin($pluginname, $data, $viewname);
        }
    }
    ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <?php echo Language::translate($module);
                    $allowCreateTicketPortal = '';
                    include_once '../config.php';
                    $createTicket = $allowCreateTicketPortal;
                    if ($createTicket == true) { ?>
                        <div class="input-group pull-right">
                            <a href="index.php?module=HelpDesk&action=new" class="btn btn-warning btn-sm pull-right"><?php echo Language::translate("New Ticket"); ?></a>
                        </div>
                    <?php } ?>
                    <div class="clearfix"></div>
                </div>
                <!-- /.panel-heading -->
                <div class="panel-body">
                    <?php if (isset($data['tickets']) && count($data['tickets']) > 0 && $data['tickets'] != "") { ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                <thead>
                                <tr>
                                    <?php foreach ($data['tableheader'] as $hf) echo "<th>" . Language::translate($hf['fielddata']) . "</th>"; ?>
                                </tr>
                                </thead>
                                <tfoot>
                                <?php foreach ($data['tableheader'] as $hf) echo "<td></td>"; ?>
                                </tfoot>
                                <tbody>
                                <?php
                                foreach ($data['tickets'] as $tkf) {

                                    echo "<tr>";
                                    foreach ($tkf as $tkv) echo "<td>" . Language::translate($tkv['fielddata']) . "</td>";
                                    echo "</tr>";

                                }

                                ?>
                                </tbody>
                            </table>
                            <div class="panel-footer-table">
                                <!--<div class="input-group" style="width:100%; text-align:right;">
                                <a href="index.php?module=HelpDesk&action=new" class="btn btn-warning btn-sm pull-right"><?php echo Language::translate("New Ticket"); ?></a>
                                </div>-->
                                <div class="row">
                                    <div id="footer-left" class="col-sm-6 pull-left">
                                    </div>
                                    <div id="footer-right" class="col-sm-6 pull-right">
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                        <h2><?php echo Language::translate("No " . $module . " records Found!"); ?></h2>
                        <br>
                    <?php } ?>
                </div>
                <!-- /.panel-body -->
            </div>
            <!-- /.panel -->
        </div>
        <!-- /.col-lg-12 -->
    </div>
    <!-- /.row -->
    <?php
    if (isset($data['plugin_data']['views']['footer'])) {
        foreach ($data['plugin_data']['views']['footer'] as $pluginname => $viewname) {
            Template::displayPlugin($pluginname, $data, $viewname);
        }
    }
    ?>
</div>
<!-- /#page-wrapper -->
<script>
    $(document).ready(function () {
        $('#dataTables-example').dataTable({
            //"iDisplayLength": 50,
            //"oSearch": {"sSearch": "Aberto"}
            //"orderFixed": [ 4, 'asc' ]
            "language": {
                "lengthMenu": "_MENU_",
                "search": "",
                "searchPlaceholder": "Pesquisar ...",
                "zeroRecords": "Sem resultados encontrados",
                "info": "Página _PAGE_ de _PAGES_",
                "infoEmpty": "Sem resultados",
                "infoFiltered": "(total: _MAX_)",
                "paginate": {
                    "first": "Primeira",
                    "last": "Última",
                    "next": "Seguinte",
                    "previous": "Anterior"
                }
            }
        });
        $("#dataTables-example_info").detach().appendTo('#footer-left');
        $("#dataTables-example_paginate").detach().appendTo('#footer-right');
        $("tfoot").detach().appendTo('#dataTables-example_filter');
    });
</script>
<!--<style>
	tfoot {
    	display: table-header-group;
	}
</style>-->
<!--<script>
	    $(document).ready(function() {
	        $('#dataTables-example').dataTable( {
    			//"iDisplayLength": 50,
    			//"oSearch": {"sSearch": "Aberto"}
    			//"orderFixed": [ 4, 'asc' ]
            		"language": {
            		"lengthMenu": "_MENU_",
            		"search": "",
            		"searchPlaceholder": "Pesquisar ...",
            		"zeroRecords": "Sem resultados encontrados",
            		"info": "Página _PAGE_ de _PAGES_",
            		"infoEmpty": "Sem resultados",
            		"infoFiltered": "(total: _MAX_)",
            		"paginate": {
        				"first": "Primeira",
        				"last": "Última",
        				"next": "Seguinte",
        				"previous": "Anterior"
    				}
        		},
        		initComplete: function () {
            		//this.api().columns().every( function () {
            		this.api().columns([5]).every( function () {
                		var column = this;
                		var select = $('<select class="form-control input-sm"><option value="">Mostrar Todos</option></select>')
                    		.appendTo( $(column.footer()).empty() )
                    		//.appendTo( $(column.header()).empty() )
                    		.on( 'change', function () {
                        		var val = $.fn.dataTable.util.escapeRegex(
                            		$(this).val()
                        		);
                        		column
                            		.search( val ? '^'+val+'$' : '', true, false )
                            		.draw();
                    		} );
                		column.data().unique().sort().each( function ( d, j ) {
                    		var val = $('<div/>').html(d).text();
							select.append( '<option value="' + val + '">' + val + '</option>' )
                		} );
            		} );
        		}
  			} );
	        $("#dataTables-example_info").detach().appendTo('#footer-left');
			$("#dataTables-example_paginate").detach().appendTo('#footer-right');
			$("tfoot").detach().appendTo('#dataTables-example_filter');
	    });
</script>-->