{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ********************************************************************************/
-->*}
{strip}
    <div class="container-fluid">
        <div class="contents row-fluid">
            {assign var=WIDTHTYPE value=$CURRENT_USER_MODEL->get('rowheight')}
            <form id="OutgoingServerForm" class="form-horizontal" data-detail-url="{$MODEL->getDetailViewUrl()}" method="POST">
                <div class="widget_header row-fluid">
                    <div class="span12">
                        <h3>{vtranslate('LBL_OUTGOING_SERVER', $QUALIFIED_MODULE)}</h3>{vtranslate('LBL_OUTGOING_SERVER_DESC', $QUALIFIED_MODULE)}
                    </div>
                </div>
                <hr>
                <input type="hidden" name="default" value="false"/>
                <input type="hidden" name="server_port" value="0"/>
                <input type="hidden" name="server_type" value="email"/>
                <input type="hidden" name="id" value="{$MODEL->get('id')}"/>
                <div class="row-fluid hide errorMessage">
                    <div class="alert alert-error" id="error-thrown">
                    </div>
                    <div class="alert alert-error">
                        {vtranslate('LBL_TESTMAILSTATUS', $QUALIFIED_MODULE)}
                        <strong>{vtranslate('LBL_MAILSENDERROR', $QUALIFIED_MODULE)}</strong>
                    </div>
                </div>
                <div class="row-fluid hide successMessage">
                    <div class="alert alert-success">
                        <strong>Email configurado com sucesso</strong>
                    </div>
                </div>
                <div class="alert alert-info">{vtranslate('LBL_OUTGOING_SERVER_NOTE', $QUALIFIED_MODULE)}</div>
                <table class="table table-bordered detailview-table themeTableColor">
                    <thead>
                    <tr class="blockHeader">
                        <th colspan="2" class="{$WIDTHTYPE}">{vtranslate('LBL_MAIL_SERVER_SMTP', $QUALIFIED_MODULE)}</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td width="20%" class="fieldLabel {$WIDTHTYPE}"><label class="muted pull-right marginRight10px"><span class="redColor">*</span>{vtranslate('LBL_SERVER_NAME', $QUALIFIED_MODULE)}
                            </label></td>
                        <td class="fieldValue {$WIDTHTYPE}">
                            <input type="text" placeholder="localhost ou mail.dominio.com ou ip" name="server" data-validation-engine='validate[required]' value="{$MODEL->get('server')}">
                        </td>
                    </tr>
                    <tr>
                        <td class="fieldLabel {$WIDTHTYPE}">
                            <label class="muted pull-right marginRight10px">{vtranslate('LBL_EMAIL_ADDRESS', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td class="fieldValue {$WIDTHTYPE}">
                            <input type="text" placeholder="exemplo@email.com" name="server_username" value="{$MODEL->get('server_username')}">
                        </td>
                    </tr>
                    <tr>
                        <td class="fieldLabel {$WIDTHTYPE}">
                            <label class="muted pull-right marginRight10px">{vtranslate('LBL_PASSWORD', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td class="fieldValue {$WIDTHTYPE}">
                            <input type="password" placeholder="password do email" name="server_password" autocomplete="new-password" value="{$MODEL->get('server_password')}">
                        </td>
                    </tr>
                    <tr>
                        <td class="fieldLabel {$WIDTHTYPE}">
                            <label class="muted pull-right marginRight10px">{vtranslate('LBL_FROM_EMAIL', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td class="fieldValue {$WIDTHTYPE}">
                            <input type="text" placeholder="exemplo@email.com" name="from_email_field" data-validation-engine="validate[funcCall[Magsoft_Base_Validator_Js.invokeValidation]]" data-validator='{Zend_Json::encode([['name' => 'Email']])}' value="{$MODEL->get('from_email_field')}">
                        </td>
                    </tr>
                    <tr>
                        <td class="fieldLabel {$WIDTHTYPE}">
                            <label class="muted pull-right marginRight10px"><label class="muted pull-right marginRight10px"><span class="redColor">*</span>{vtranslate('LBL_SMTP_EMAIL', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td class="fieldValue {$WIDTHTYPE}">
                            <select class="chzn-select" name="smtp_type" style="min-width: 225px;" data-validation-engine='validate[required]'>
                                <option value="{$MODEL->get('smtp_type')}">{vtranslate('LBL_SELECT',$MODULE)}</option>
                                <option value="isSMTP" {if $MODEL->get('smtp_type') eq 'isSMTP' || $MODEL->get('smtp_type') eq ''}selected='selected'{/if}>{vtranslate('isSMTP', $QUALIFIED_MODULE)}</option>
                                <option value="isSendmail" {if $MODEL->get('smtp_type') eq 'isSendmail'}selected='selected'{/if}>{vtranslate('isSendmail', $QUALIFIED_MODULE)}</option>
                                <option value="isMail" {if $MODEL->get('smtp_type') eq 'isMail'}selected='selected'{/if}>{vtranslate('isMail', $QUALIFIED_MODULE)}</option>
                                {*<option value="isQmail" {if $MODEL->get('smtp_type') eq 'isQmail'}selected='selected'{/if}>{vtranslate('isQmail', $QUALIFIED_MODULE)}</option>*}
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="fieldLabel {$WIDTHTYPE}">
                            <label class="muted pull-right marginRight10px">{vtranslate('LBL_REQUIRES_AUTHENTICATION', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td class="fieldValue {$WIDTHTYPE}">
                            <label class="check-switch">
                                <input type="checkbox" name="smtp_auth" {if $MODEL->isSmtpAuthEnabled() || $MODEL->isSmtpAuthEnabled() eq ''}checked{/if} >
                                <span></span>
                            </label>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <br>
                <div class="row-fluid btn-toolbar">
                    <a type="reset" class="cancelLink" title="{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}">{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}</a>
                    <div class="pull-right">
                        <button class="btn btn-success saveButton" type="submit" title="{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}">
                            <strong>{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}</strong>
                        </button>
                    </div>
                </div>
                <br>
            </form>
        </div>
    </div>
{/strip}