<?php

// ******************************************************************************
// Software: mPDF, Unicode-HTML Free PDF generator                              *
// Version:  6.1        based on                                                *
//           FPDF by Olivier PLATHEY                                            *
//           HTML2FPDF by Renato Coelho                                         *
// Date:     2016-03-25                                                         *
// Author:   Ian Back <ianb@bpm1.com>                                           *
// License:  GPL                                                                *
//                                                                              *
// Changes:  See changelog.txt                                                  *
// ******************************************************************************

define('mPDF_VERSION', '6.1');
// ITS4YOU MaJu
define('PDFMAKER_mPDF_VERSION','7');
// ITS4YOU-END

//Scale factor
define('_MPDFK', (72 / 25.4));

// Specify which font metrics to use:
// 'winTypo' uses sTypoAscender etc from the OS/2 table and is the one usually recommended - BUT
// 'win' use WinAscent etc from OS/2 and inpractice seems to be used more commonly in Windows environment
// 'mac' uses Ascender etc from hhea table, and is used on Mac/OSX environment
if (!defined('_FONT_DESCRIPTOR')) {
	define("_FONT_DESCRIPTOR", 'win'); // Values: '' [BLANK] or 'win', 'mac', 'winTypo'
}

/* -- HTML-CSS -- */
define('_BORDER_ALL', 15);
define('_BORDER_TOP', 8);
define('_BORDER_RIGHT', 4);
define('_BORDER_BOTTOM', 2);
define('_BORDER_LEFT', 1);
/* -- END HTML-CSS -- */

// mPDF 6.0
// Used for $textvars - user settings via CSS
define('FD_UNDERLINE', 1); // font-decoration
define('FD_LINETHROUGH', 2);
define('FD_OVERLINE', 4);
define('FA_SUPERSCRIPT', 8); // font-(vertical)-align
define('FA_SUBSCRIPT', 16);
define('FT_UPPERCASE', 32); // font-transform
define('FT_LOWERCASE', 64);
define('FT_CAPITALIZE', 128);
define('FC_KERNING', 256); // font-(other)-controls
define('FC_SMALLCAPS', 512);


if (!defined('_MPDF_PATH')) {
	define('_MPDF_PATH', dirname(preg_replace('/\\\\/', '/', __FILE__)) . '/');
}

if (!defined('_MPDF_URI')) {
	define('_MPDF_URI', _MPDF_PATH);
}

require_once _MPDF_PATH . 'includes/functions.php';
require_once _MPDF_PATH . 'config_lang2fonts.php';

require_once _MPDF_PATH . 'classes/ucdn.php'; // mPDF 6.0

/* -- OTL -- */
require_once _MPDF_PATH . 'classes/indic.php'; // mPDF 6.0
require_once _MPDF_PATH . 'classes/myanmar.php'; // mPDF 6.0
require_once _MPDF_PATH . 'classes/sea.php'; // mPDF 6.0
/* -- END OTL -- */

require_once _MPDF_PATH . 'Tag.php';
require_once _MPDF_PATH . 'MpdfException.php';

if (!defined('_JPGRAPH_PATH')) {
	define("_JPGRAPH_PATH", _MPDF_PATH . 'jpgraph/');
}

if (!defined('_MPDF_TEMP_PATH')) {
	define("_MPDF_TEMP_PATH", _MPDF_PATH . 'tmp/');
}

if (!defined('_MPDF_TTFONTPATH')) {
	define('_MPDF_TTFONTPATH', _MPDF_PATH . 'ttfonts/');
}

if (!defined('_MPDF_TTFONTDATAPATH')) {
	define('_MPDF_TTFONTDATAPATH', _MPDF_PATH . 'ttfontdata/');
}

$errorlevel = error_reporting();
$errorlevel = error_reporting($errorlevel & ~E_NOTICE);

//error_reporting(E_ALL);

if (function_exists("date_default_timezone_set")) {
	if (ini_get("date.timezone") == "") {
		date_default_timezone_set("Europe/London");
	}
}

if (!function_exists('mb_strlen')) {
	throw new MpdfException('mPDF requires mb_string functions. Ensure that mb_string extension is loaded.');
}

if (!defined('PHP_VERSION_ID')) {
	$version = explode('.', PHP_VERSION);
	define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
}

class mPDF
{

	///////////////////////////////
	// EXTERNAL (PUBLIC) VARIABLES
	// Define these in config.php
	///////////////////////////////
	var $useFixedNormalLineHeight; // mPDF 6
	var $useFixedTextBaseline; // mPDF 6
	var $adjustFontDescLineheight; // mPDF 6
	var $interpolateImages; // mPDF 6
	var $defaultPagebreakType; // mPDF 6 pagebreaktype
	var $indexUseSubentries; // mPDF 6

	var $autoScriptToLang; // mPDF 6
	var $baseScript; // mPDF 6
	var $autoVietnamese; // mPDF 6
	var $autoArabic; // mPDF 6

	var $CJKforceend;
	var $h2bookmarks;
	var $h2toc;
	var $decimal_align;
	var $margBuffer;
	var $splitTableBorderWidth;

	var $bookmarkStyles;
	var $useActiveForms;

	var $repackageTTF;
	var $allowCJKorphans;
	var $allowCJKoverflow;

	var $useKerning;
	var $restrictColorSpace;
	var $bleedMargin;
	var $crossMarkMargin;
	var $cropMarkMargin;
	var $cropMarkLength;
	var $nonPrintMargin;

	var $PDFX;
	var $PDFXauto;

	var $PDFA;
	var $PDFAauto;
	var $ICCProfile;

	var $printers_info;
	var $iterationCounter;
	var $smCapsScale;
	var $smCapsStretch;

	var $backupSubsFont;
	var $backupSIPFont;
	var $debugfonts;
	var $useAdobeCJK;
	var $percentSubset;
	var $maxTTFFilesize;
	var $BMPonly;

	var $tableMinSizePriority;

	var $dpi;
	var $watermarkImgAlphaBlend;
	var $watermarkImgBehind;
	var $justifyB4br;
	var $packTableData;
	var $pgsIns;
	var $simpleTables;
	var $enableImports;

	var $debug;

	var $showStats;
	var $setAutoTopMargin;
	var $setAutoBottomMargin;
	var $autoMarginPadding;
	var $collapseBlockMargins;
	var $falseBoldWeight;
	var $normalLineheight;
	var $progressBar;
	var $incrementFPR1;
	var $incrementFPR2;
	var $incrementFPR3;
	var $incrementFPR4;

	var $SHYlang;
	var $SHYleftmin;
	var $SHYrightmin;
	var $SHYcharmin;
	var $SHYcharmax;
	var $SHYlanguages;

	// PageNumber Conditional Text
	var $pagenumPrefix;
	var $pagenumSuffix;

	var $nbpgPrefix;
	var $nbpgSuffix;
	var $showImageErrors;
	var $allow_output_buffering;
	var $autoPadding;
	var $useGraphs;
	var $tabSpaces;
	var $autoLangToFont;
	var $watermarkTextAlpha;
	var $watermarkImageAlpha;
	var $watermark_size;
	var $watermark_pos;
	var $annotSize;
	var $annotMargin;
	var $annotOpacity;
	var $title2annots;
	var $keepColumns;
	var $keep_table_proportions;
	var $ignore_table_widths;
	var $ignore_table_percents;
	var $list_number_suffix;

	var $list_auto_mode; // mPDF 6
	var $list_indent_first_level; // mPDF 6
	var $list_indent_default; // mPDF 6
	var $list_marker_offset; // mPDF 6

	var $useSubstitutions;
	var $CSSselectMedia;

	var $forcePortraitHeaders;
	var $forcePortraitMargins;
	var $displayDefaultOrientation;
	var $ignore_invalid_utf8;
	var $allowedCSStags;
	var $onlyCoreFonts;
	var $allow_charset_conversion;

	var $jSWord;
	var $jSmaxChar;
	var $jSmaxCharLast;
	var $jSmaxWordLast;

	var $max_colH_correction;

	var $table_error_report;
	var $table_error_report_param;
	var $biDirectional;
	var $text_input_as_HTML;
	var $anchor2Bookmark;
	var $shrink_tables_to_fit;

	var $allow_html_optional_endtags;

	var $img_dpi;

	var $defaultheaderfontsize;
	var $defaultheaderfontstyle;
	var $defaultheaderline;
	var $defaultfooterfontsize;
	var $defaultfooterfontstyle;
	var $defaultfooterline;
	var $header_line_spacing;
	var $footer_line_spacing;

	var $pregCJKchars;
	var $pregRTLchars;
	var $pregCURSchars; // mPDF 6

	var $mirrorMargins;
	var $watermarkText;
	var $watermarkImage;
	var $showWatermarkText;
	var $showWatermarkImage;

	var $fontsizes;

	var $defaultPageNumStyle; // mPDF 6

    // ITS4YOU MaJu
//PDFMaker customized variables
var $PDFMakerRecord;
var $PDFMakerTemplateid;
var $PDFMakerSubtotalAble;
var $PDFMakerSubtotalsArray;
var $PDFMakerDispHeader;
var $PDFMakerDispFooter;
var $PDFMakerSplitCounter = 0;
// ITS4YOU-END

	//////////////////////
	// CLASS OBJECTS
	//////////////////////
	var $otl; // mPDF 5.7.1
	var $cssmgr;
	var $grad;
	var $bmp;
	var $wmf;
	var $tocontents;
	var $mpdfform;
	var $directw;

	//////////////////////
	// INTERNAL VARIABLES
	//////////////////////
	var $script2lang;
	var $viet;
	var $pashto;
	var $urdu;
	var $persian;
	var $sindhi;
	var $extrapagebreak; // mPDF 6 pagebreaktype

	var $uniqstr; // mPDF 5.7.2
	var $hasOC;

	var $textvar; // mPDF 5.7.1
	var $fontLanguageOverride; // mPDF 5.7.1
	var $OTLtags; // mPDF 5.7.1
	var $OTLdata;  // mPDF 5.7.1

	var $writingToC;
	var $layers;
	var $current_layer;
	var $open_layer_pane;
	var $decimal_offset;
	var $inMeter;

	var $CJKleading;
	var $CJKfollowing;
	var $CJKoverflow;

	var $textshadow;

	var $colsums;
	var $spanborder;
	var $spanborddet;

	var $visibility;

	var $useRC128encryption;
	var $uniqid;

	var $kerning;
	var $fixedlSpacing;
	var $minwSpacing;
	var $lSpacingCSS;
	var $wSpacingCSS;

	var $spotColorIDs;
	var $SVGcolors;
	var $spotColors;
	var $defTextColor;
	var $defDrawColor;
	var $defFillColor;

	var $tableBackgrounds;
	var $inlineDisplayOff;
	var $kt_y00;
	var $kt_p00;
	var $upperCase;
	var $checkSIP;
	var $checkSMP;
	var $checkCJK;

	var $watermarkImgAlpha;
	var $PDFAXwarnings;
	var $MetadataRoot;
	var $OutputIntentRoot;
	var $InfoRoot;
	var $current_filename;
	var $parsers;
	var $current_parser;
	var $_obj_stack;
	var $_don_obj_stack;
	var $_current_obj_id;
	var $tpls;
	var $tpl;
	var $tplprefix;
	var $_res;

	var $pdf_version;
	var $noImageFile;
	var $lastblockbottommargin;
	var $baselineC;

	// mPDF 5.7.3  inline text-decoration parameters
	var $baselineSup;
	var $baselineSub;
	var $baselineS;
	var $subPos;
	var $subArrMB;
	var $ReqFontStyle;
	var $tableClipPath;

	var $fullImageHeight;

	var $inFixedPosBlock;  // Internal flag for position:fixed block
	var $fixedPosBlock;  // Buffer string for position:fixed block
	var $fixedPosBlockDepth;
	var $fixedPosBlockBBox;
	var $fixedPosBlockSave;
	var $maxPosL;
	var $maxPosR;
	var $loaded;

	var $extraFontSubsets;

	var $docTemplateStart;  // Internal flag for page (page no. -1) that docTemplate starts on

	var $time0;

	// Classes
	var $indic;
	var $barcode;

	var $SHYpatterns;
	var $loadedSHYpatterns;
	var $loadedSHYdictionary;
	var $SHYdictionary;
	var $SHYdictionaryWords;

	var $spanbgcolorarray;
	var $default_font;
	var $headerbuffer;
	var $lastblocklevelchange;
	var $nestedtablejustfinished;
	var $linebreakjustfinished;
	var $cell_border_dominance_L;
	var $cell_border_dominance_R;
	var $cell_border_dominance_T;
	var $cell_border_dominance_B;
	var $table_keep_together;
	var $plainCell_properties;
	var $shrin_k1;
	var $outerfilled;

	var $blockContext;
	var $floatDivs;

	var $patterns;
	var $pageBackgrounds;

	var $bodyBackgroundGradient;
	var $bodyBackgroundImage;
	var $bodyBackgroundColor;

	var $writingHTMLheader; // internal flag - used both for writing HTMLHeaders/Footers and FixedPos block
	var $writingHTMLfooter;

	var $angle;

	var $gradients;

	var $kwt_Reference;
	var $kwt_BMoutlines;
	var $kwt_toc;

	var $tbrot_BMoutlines;
	var $tbrot_toc;

	var $col_BMoutlines;
	var $col_toc;

	var $currentGraphId;
	var $graphs;

	var $floatbuffer;
	var $floatmargins;

	var $bullet;
	var $bulletarray;

	var $currentLang;
	var $default_lang;

	var $default_available_fonts;

	var $pageTemplate;
	var $docTemplate;
	var $docTemplateContinue;

	var $arabGlyphs;
	var $arabHex;
	var $persianGlyphs;
	var $persianHex;
	var $arabVowels;
	var $arabPrevLink;
	var $arabNextLink;

	var $formobjects; // array of Form Objects for WMF
	var $InlineProperties;
	var $InlineAnnots;
	var $InlineBDF; // mPDF 6 Bidirectional formatting
	var $InlineBDFctr; // mPDF 6

	var $ktAnnots;
	var $tbrot_Annots;
	var $kwt_Annots;
	var $columnAnnots;
	var $columnForms;

	var $PageAnnots;

	var $pageDim; // Keep track of page wxh for orientation changes - set in _beginpage, used in _putannots

	var $breakpoints;

	var $tableLevel;
	var $tbctr;
	var $innermostTableLevel;
	var $saveTableCounter;
	var $cellBorderBuffer;

	var $saveHTMLFooter_height;
	var $saveHTMLFooterE_height;

	var $firstPageBoxHeader;
	var $firstPageBoxHeaderEven;
	var $firstPageBoxFooter;
	var $firstPageBoxFooterEven;

	var $page_box;

	var $show_marks; // crop or cross marks
	var $basepathIsLocal;

	var $use_kwt;
	var $kwt;
	var $kwt_height;
	var $kwt_y0;
	var $kwt_x0;
	var $kwt_buffer;
	var $kwt_Links;
	var $kwt_moved;
	var $kwt_saved;

	var $PageNumSubstitutions;

	var $table_borders_separate;
	var $base_table_properties;
	var $borderstyles;

	var $blockjustfinished;

	var $orig_bMargin;
	var $orig_tMargin;
	var $orig_lMargin;
	var $orig_rMargin;
	var $orig_hMargin;
	var $orig_fMargin;

	var $pageHTMLheaders;
	var $pageHTMLfooters;

	var $saveHTMLHeader;
	var $saveHTMLFooter;

	var $HTMLheaderPageLinks;
	var $HTMLheaderPageAnnots;
	var $HTMLheaderPageForms;

	// See config_fonts.php for these next 5 values
	var $available_unifonts;
	var $sans_fonts;
	var $serif_fonts;
	var $mono_fonts;
	var $defaultSubsFont;

	// List of ALL available CJK fonts (incl. styles) (Adobe add-ons)  hw removed
	var $available_CJK_fonts;

	var $HTMLHeader;
	var $HTMLFooter;
	var $HTMLHeaderE;
	var $HTMLFooterE;
	var $bufferoutput;

	// CJK fonts
	var $Big5_widths;
	var $GB_widths;
	var $SJIS_widths;
	var $UHC_widths;

	// SetProtection
	var $encrypted; // whether document is protected
	var $Uvalue; // U entry in pdf document
	var $Ovalue; // O entry in pdf document
	var $Pvalue; // P entry in pdf document

	var $enc_obj_id; //encryption object id
	var $last_rc4_key; //last RC4 key encrypted (cached for optimisation)
	var $last_rc4_key_c; //last RC4 computed key

	var $encryption_key;

	var $padding; //used for encryption

	// Bookmark
	var $BMoutlines;
	var $OutlineRoot;

	// INDEX
	var $ColActive;
	var $Reference;
	var $CurrCol;
	var $NbCol;
	var $y0;   //Top ordinate of columns

	var $ColL;
	var $ColWidth;
	var $ColGap;

	// COLUMNS
	var $ColR;
	var $ChangeColumn;
	var $columnbuffer;
	var $ColDetails;
	var $columnLinks;
	var $colvAlign;

	// Substitutions
	var $substitute;  // Array of substitution strings e.g. <ttz>112</ttz>
	var $entsearch;  // Array of HTML entities (>ASCII 127) to substitute
	var $entsubstitute; // Array of substitution decimal unicode for the Hi entities

	// Default values if no style sheet offered	(cf. http://www.w3.org/TR/CSS21/sample.html)
	var $defaultCSS;
	var $lastoptionaltag; // Save current block item which HTML specifies optionsl endtag
	var $pageoutput;
	var $charset_in;
	var $blk;
	var $blklvl;
	var $ColumnAdjust;

	var $ws; // Word spacing

	var $HREF;
	var $pgwidth;
	var $fontlist;
	var $oldx;
	var $oldy;
	var $B;
	var $I;

	var $tdbegin;
	var $table;
	var $cell;
	var $col;
	var $row;

	var $divbegin;
	var $divwidth;
	var $divheight;
	var $spanbgcolor;

	// mPDF 6 Used for table cell (block-type) properties
	var $cellTextAlign;
	var $cellLineHeight;
	var $cellLineStackingStrategy;
	var $cellLineStackingShift;

	// mPDF 6  Lists
	var $listcounter;
	var $listlvl;
	var $listtype;
	var $listitem;

	var $pjustfinished;
	var $ignorefollowingspaces;
	var $SMALL;
	var $BIG;
	var $dash_on;
	var $dotted_on;

	var $textbuffer;
	var $currentfontstyle;
	var $currentfontfamily;
	var $currentfontsize;
	var $colorarray;
	var $bgcolorarray;
	var $internallink;
	var $enabledtags;

	var $lineheight;
	var $basepath;
	var $textparam;

	var $specialcontent;
	var $selectoption;
	var $objectbuffer;

	// Table Rotation
	var $table_rotate;
	var $tbrot_maxw;
	var $tbrot_maxh;
	var $tablebuffer;
	var $tbrot_align;
	var $tbrot_Links;

	var $keep_block_together; // Keep a Block from page-break-inside: avoid

	var $tbrot_y0;
	var $tbrot_x0;
	var $tbrot_w;
	var $tbrot_h;

	var $mb_enc;
	var $directionality;

	var $extgstates; // Used for alpha channel - Transparency (Watermark)
	var $mgl;
	var $mgt;
	var $mgr;
	var $mgb;

	var $tts;
	var $ttz;
	var $tta;

	// Best to alter the below variables using default stylesheet above
	var $page_break_after_avoid;
	var $margin_bottom_collapse;
	var $default_font_size; // in pts
	var $original_default_font_size; // used to save default sizes when using table default
	var $original_default_font;
	var $watermark_font;
	var $defaultAlign;

	// TABLE
	var $defaultTableAlign;
	var $tablethead;
	var $thead_font_weight;
	var $thead_font_style;
	var $thead_font_smCaps;
	var $thead_valign_default;
	var $thead_textalign_default;
	var $tabletfoot;
	var $tfoot_font_weight;
	var $tfoot_font_style;
	var $tfoot_font_smCaps;
	var $tfoot_valign_default;
	var $tfoot_textalign_default;

	var $trow_text_rotate;

	var $cellPaddingL;
	var $cellPaddingR;
	var $cellPaddingT;
	var $cellPaddingB;
	var $table_border_attr_set;
	var $table_border_css_set;

	var $shrin_k; // factor with which to shrink tables - used internally - do not change
	var $shrink_this_table_to_fit; // 0 or false to disable; value (if set) gives maximum factor to reduce fontsize
	var $MarginCorrection; // corrects for OddEven Margins
	var $margin_footer;
	var $margin_header;

	var $tabletheadjustfinished;
	var $usingCoreFont;
	var $charspacing;

	//Private properties FROM FPDF
	var $DisplayPreferences;
	var $flowingBlockAttr;
	var $page; //current page number
	var $n; //current object number
	var $offsets; //array of object offsets
	var $buffer; //buffer holding in-memory PDF
	var $pages; //array containing pages
	var $state; //current document state
	var $compress; //compression flag
	var $DefOrientation; //default orientation
	var $CurOrientation; //current orientation
	var $OrientationChanges; //array indicating orientation changes
	var $k; //scale factor (number of points in user unit)
	var $fwPt;
	var $fhPt; //dimensions of page format in points
	var $fw;
	var $fh; //dimensions of page format in user unit
	var $wPt;
	var $hPt; //current dimensions of page in points
	var $w;
	var $h; //current dimensions of page in user unit
	var $lMargin; //left margin
	var $tMargin; //top margin
	var $rMargin; //right margin
	var $bMargin; //page break margin
	var $cMarginL; //cell margin Left
	var $cMarginR; //cell margin Right
	var $cMarginT; //cell margin Left
	var $cMarginB; //cell margin Right
	var $DeflMargin; //Default left margin
	var $DefrMargin; //Default right margin
	var $x;
	var $y; //current position in user unit for cell positioning
	var $lasth; //height of last cell printed
	var $LineWidth; //line width in user unit
	var $CoreFonts; //array of standard font names
	var $fonts; //array of used fonts
	var $FontFiles; //array of font files
	var $images; //array of used images
	var $PageLinks; //array of links in pages
	var $links; //array of internal links
	var $FontFamily; //current font family
	var $FontStyle; //current font style
	var $CurrentFont; //current font info
	var $FontSizePt; //current font size in points
	var $FontSize; //current font size in user unit
	var $DrawColor; //commands for drawing color
	var $FillColor; //commands for filling color
	var $TextColor; //commands for text color
	var $ColorFlag; //indicates whether fill and text colors are different
	var $autoPageBreak; //automatic page breaking
	var $PageBreakTrigger; //threshold used to trigger page breaks
	var $InFooter; //flag set when processing footer

	var $InHTMLFooter;
	var $processingFooter; //flag set when processing footer - added for columns
	var $processingHeader; //flag set when processing header - added for columns
	var $ZoomMode; //zoom display mode
	var $LayoutMode; //layout display mode
	var $title; //title
	var $subject; //subject
	var $author; //author
	var $keywords; //keywords
	var $creator; //creator

	var $aliasNbPg; //alias for total number of pages
	var $aliasNbPgGp; //alias for total number of pages in page group

	//var $aliasNbPgHex;	// mPDF 6 deleted
	//var $aliasNbPgGpHex;	// mPDF 6 deleted

	var $ispre;
	var $outerblocktags;
	var $innerblocktags;

	// **********************************
	// **********************************
	// **********************************
	// **********************************
	// **********************************
	// **********************************
	// **********************************
	// **********************************
	// **********************************

	private $tag;

	public function __construct($mode = '', $format = 'A4', $default_font_size = 0, $default_font = '', $mgl = 15, $mgr = 15, $mgt = 16, $mgb = 16, $mgh = 9, $mgf = 9, $orientation = 'P')
	{
		/* -- BACKGROUNDS -- */
		if (!class_exists('grad', false)) {
			include(_MPDF_PATH . 'classes/grad.php');
		}
		if (empty($this->grad)) {
			$this->grad = new grad($this);
		}
		/* -- END BACKGROUNDS -- */
		/* -- FORMS -- */
		if (!class_exists('mpdfform', false)) {
			include(_MPDF_PATH . 'classes/mpdfform.php');
		}
		if (empty($this->mpdfform)) {
			$this->mpdfform = new mpdfform($this);
		}
		/* -- END FORMS -- */

		$this->time0 = microtime(true);
		//Some checks
		$this->_dochecks();

		$this->writingToC = false;
		$this->layers = array();
		$this->current_layer = 0;
		$this->open_layer_pane = false;

		$this->visibility = 'visible';

		//Initialization of properties
		$this->spotColors = array();
		$this->spotColorIDs = array();
		$this->tableBackgrounds = array();
		$this->uniqstr = '20110230'; // mPDF 5.7.2
		$this->kt_y00 = '';
		$this->kt_p00 = '';
		$this->iterationCounter = false;
		$this->BMPonly = array();
		$this->page = 0;
		$this->n = 2;
		$this->buffer = '';
		$this->objectbuffer = array();
		$this->pages = array();
		$this->OrientationChanges = array();
		$this->state = 0;
		$this->fonts = array();
		$this->FontFiles = array();
		$this->images = array();
		$this->links = array();
		$this->InFooter = false;
		$this->processingFooter = false;
		$this->processingHeader = false;
		$this->lasth = 0;
		$this->FontFamily = '';
		$this->FontStyle = '';
		$this->FontSizePt = 9;
		$this->U = false;
		// Small Caps
		$this->upperCase = array();
		$this->smCapsScale = 1;
		$this->smCapsStretch = 100;
		$this->margBuffer = 0;
		$this->inMeter = false;
		$this->decimal_offset = 0;

		$this->defTextColor = $this->TextColor = $this->SetTColor($this->ConvertColor(0), true);
		$this->defDrawColor = $this->DrawColor = $this->SetDColor($this->ConvertColor(0), true);
		$this->defFillColor = $this->FillColor = $this->SetFColor($this->ConvertColor(255), true);

		//SVG color names array
		//http://www.w3schools.com/css/css_colornames.asp
		$this->SVGcolors = array('antiquewhite' => '#FAEBD7', 'aqua' => '#00FFFF', 'aquamarine' => '#7FFFD4', 'beige' => '#F5F5DC', 'black' => '#000000',
			'blue' => '#0000FF', 'brown' => '#A52A2A', 'cadetblue' => '#5F9EA0', 'chocolate' => '#D2691E', 'cornflowerblue' => '#6495ED', 'crimson' => '#DC143C',
			'darkblue' => '#00008B', 'darkgoldenrod' => '#B8860B', 'darkgreen' => '#006400', 'darkmagenta' => '#8B008B', 'darkorange' => '#FF8C00',
			'darkred' => '#8B0000', 'darkseagreen' => '#8FBC8F', 'darkslategray' => '#2F4F4F', 'darkviolet' => '#9400D3', 'deepskyblue' => '#00BFFF',
			'dodgerblue' => '#1E90FF', 'firebrick' => '#B22222', 'forestgreen' => '#228B22', 'fuchsia' => '#FF00FF', 'gainsboro' => '#DCDCDC', 'gold' => '#FFD700',
			'gray' => '#808080', 'green' => '#008000', 'greenyellow' => '#ADFF2F', 'hotpink' => '#FF69B4', 'indigo' => '#4B0082', 'khaki' => '#F0E68C',
			'lavenderblush' => '#FFF0F5', 'lemonchiffon' => '#FFFACD', 'lightcoral' => '#F08080', 'lightgoldenrodyellow' => '#FAFAD2', 'lightgreen' => '#90EE90',
			'lightsalmon' => '#FFA07A', 'lightskyblue' => '#87CEFA', 'lightslategray' => '#778899', 'lightyellow' => '#FFFFE0', 'lime' => '#00FF00', 'limegreen' => '#32CD32',
			'magenta' => '#FF00FF', 'maroon' => '#800000', 'mediumaquamarine' => '#66CDAA', 'mediumorchid' => '#BA55D3', 'mediumseagreen' => '#3CB371',
			'mediumspringgreen' => '#00FA9A', 'mediumvioletred' => '#C71585', 'midnightblue' => '#191970', 'mintcream' => '#F5FFFA', 'moccasin' => '#FFE4B5', 'navy' => '#000080',
			'olive' => '#808000', 'orange' => '#FFA500', 'orchid' => '#DA70D6', 'palegreen' => '#98FB98',
			'palevioletred' => '#D87093', 'peachpuff' => '#FFDAB9', 'pink' => '#FFC0CB', 'powderblue' => '#B0E0E6', 'purple' => '#800080',
			'red' => '#FF0000', 'royalblue' => '#4169E1', 'salmon' => '#FA8072', 'seagreen' => '#2E8B57', 'sienna' => '#A0522D', 'silver' => '#C0C0C0', 'skyblue' => '#87CEEB',
			'slategray' => '#708090', 'springgreen' => '#00FF7F', 'steelblue' => '#4682B4', 'tan' => '#D2B48C', 'teal' => '#008080', 'thistle' => '#D8BFD8', 'turquoise' => '#40E0D0',
			'violetred' => '#D02090', 'white' => '#FFFFFF', 'yellow' => '#FFFF00',
			'aliceblue' => '#f0f8ff', 'azure' => '#f0ffff', 'bisque' => '#ffe4c4', 'blanchedalmond' => '#ffebcd', 'blueviolet' => '#8a2be2', 'burlywood' => '#deb887',
			'chartreuse' => '#7fff00', 'coral' => '#ff7f50', 'cornsilk' => '#fff8dc', 'cyan' => '#00ffff', 'darkcyan' => '#008b8b', 'darkgray' => '#a9a9a9',
			'darkgrey' => '#a9a9a9', 'darkkhaki' => '#bdb76b', 'darkolivegreen' => '#556b2f', 'darkorchid' => '#9932cc', 'darksalmon' => '#e9967a',
			'darkslateblue' => '#483d8b', 'darkslategrey' => '#2f4f4f', 'darkturquoise' => '#00ced1', 'deeppink' => '#ff1493', 'dimgray' => '#696969',
			'dimgrey' => '#696969', 'floralwhite' => '#fffaf0', 'ghostwhite' => '#f8f8ff', 'goldenrod' => '#daa520', 'grey' => '#808080', 'honeydew' => '#f0fff0',
			'indianred' => '#cd5c5c', 'ivory' => '#fffff0', 'lavender' => '#e6e6fa', 'lawngreen' => '#7cfc00', 'lightblue' => '#add8e6', 'lightcyan' => '#e0ffff',
			'lightgray' => '#d3d3d3', 'lightgrey' => '#d3d3d3', 'lightpink' => '#ffb6c1', 'lightseagreen' => '#20b2aa', 'lightslategrey' => '#778899',
			'lightsteelblue' => '#b0c4de', 'linen' => '#faf0e6', 'mediumblue' => '#0000cd', 'mediumpurple' => '#9370db', 'mediumslateblue' => '#7b68ee',
			'mediumturquoise' => '#48d1cc', 'mistyrose' => '#ffe4e1', 'navajowhite' => '#ffdead', 'oldlace' => '#fdf5e6', 'olivedrab' => '#6b8e23', 'orangered' => '#ff4500',
			'palegoldenrod' => '#eee8aa', 'paleturquoise' => '#afeeee', 'papayawhip' => '#ffefd5', 'peru' => '#cd853f', 'plum' => '#dda0dd', 'rosybrown' => '#bc8f8f',
			'saddlebrown' => '#8b4513', 'sandybrown' => '#f4a460', 'seashell' => '#fff5ee', 'slateblue' => '#6a5acd', 'slategrey' => '#708090', 'snow' => '#fffafa',
			'tomato' => '#ff6347', 'violet' => '#ee82ee', 'wheat' => '#f5deb3', 'whitesmoke' => '#f5f5f5', 'yellowgreen' => '#9acd32');

		// Uppercase alternatives (for Small Caps)
		if (empty($this->upperCase)) {
			@include(_MPDF_PATH . 'includes/upperCase.php');
		}
		$this->extrapagebreak = true; // mPDF 6 pagebreaktype

		$this->ColorFlag = false;
		$this->extgstates = array();

		$this->mb_enc = 'windows-1252';
		$this->directionality = 'ltr';
		$this->defaultAlign = 'L';
		$this->defaultTableAlign = 'L';

		$this->fixedPosBlockSave = array();
		$this->extraFontSubsets = 0;

		$this->SHYpatterns = array();
		$this->loadedSHYdictionary = false;
		$this->SHYdictionary = array();
		$this->SHYdictionaryWords = array();
		$this->blockContext = 1;
		$this->floatDivs = array();
		$this->DisplayPreferences = '';

		$this->patterns = array();  // Tiling patterns used for backgrounds
		$this->pageBackgrounds = array();
		$this->writingHTMLheader = false; // internal flag - used both for writing HTMLHeaders/Footers and FixedPos block
		$this->writingHTMLfooter = false; // internal flag - used both for writing HTMLHeaders/Footers and FixedPos block
		$this->gradients = array();

		$this->kwt_Reference = array();
		$this->kwt_BMoutlines = array();
		$this->kwt_toc = array();

		$this->tbrot_BMoutlines = array();
		$this->tbrot_toc = array();

		$this->col_BMoutlines = array();
		$this->col_toc = array();
		$this->graphs = array();

		$this->pgsIns = array();
		$this->PDFAXwarnings = array();
		$this->inlineDisplayOff = false;
		$this->lSpacingCSS = '';
		$this->wSpacingCSS = '';
		$this->fixedlSpacing = false;
		$this->minwSpacing = 0;


		$this->baselineC = 0.35; // Baseline for text
		// mPDF 5.7.3  inline text-decoration parameters
		$this->baselineSup = 0.5; // Sets default change in baseline for <sup> text as factor of preceeding fontsize
		// 0.35 has been recommended; 0.5 matches applications like MS Word
		$this->baselineSub = -0.2; // Sets default change in baseline for <sub> text as factor of preceeding fontsize
		$this->baselineS = 0.3;  // Sets default height for <strike> text as factor of fontsize
		$this->baselineO = 1.1;  // Sets default height for overline text as factor of fontsize

		$this->noImageFile = str_replace("\\", "/", dirname(__FILE__)) . '/includes/no_image.jpg';
		$this->subPos = 0;
		$this->normalLineheight = 1.3; // This should be overridden in config.php - but it is so important a default value is put here
		// These are intended as configuration variables, and should be set in config.php - which will override these values;
		// set here as failsafe as will cause an error if not defined
		$this->incrementFPR1 = 10;
		$this->incrementFPR2 = 10;
		$this->incrementFPR3 = 10;
		$this->incrementFPR4 = 10;

		$this->fullImageHeight = false;
		$this->floatbuffer = array();
		$this->floatmargins = array();
		$this->formobjects = array(); // array of Form Objects for WMF
		$this->InlineProperties = array();
		$this->InlineAnnots = array();
		$this->InlineBDF = array(); // mPDF 6
		$this->InlineBDFctr = 0; // mPDF 6
		$this->tbrot_Annots = array();
		$this->kwt_Annots = array();
		$this->columnAnnots = array();
		$this->pageDim = array();
		$this->breakpoints = array(); // used in columnbuffer
		$this->tableLevel = 0;
		$this->tbctr = array(); // counter for nested tables at each level
		$this->page_box = array();
		$this->show_marks = ''; // crop or cross marks
		$this->kwt = false;
		$this->kwt_height = 0;
		$this->kwt_y0 = 0;
		$this->kwt_x0 = 0;
		$this->kwt_buffer = array();
		$this->kwt_Links = array();
		$this->kwt_moved = false;
		$this->kwt_saved = false;
		$this->PageNumSubstitutions = array();
		$this->base_table_properties = array();
		$this->borderstyles = array('inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double');
		$this->tbrot_align = 'C';

		$this->pageHTMLheaders = array();
		$this->pageHTMLfooters = array();
		$this->HTMLheaderPageLinks = array();
		$this->HTMLheaderPageAnnots = array();

		$this->HTMLheaderPageForms = array();
		$this->columnForms = array();
		$this->tbrotForms = array();
		$this->useRC128encryption = false;
		$this->uniqid = '';

		$this->pageoutput = array();

		$this->bufferoutput = false;
		$this->encrypted = false;      //whether document is protected
		$this->BMoutlines = array();
		$this->ColActive = 0;          //Flag indicating that columns are on (the index is being processed)
		$this->Reference = array();    //Array containing the references
		$this->CurrCol = 0;               //Current column number
		$this->ColL = array(0);   // Array of Left pos of columns - absolute - needs Margin correction for Odd-Even
		$this->ColR = array(0);   // Array of Right pos of columns - absolute pos - needs Margin correction for Odd-Even
		$this->ChangeColumn = 0;
		$this->columnbuffer = array();
		$this->ColDetails = array();  // Keeps track of some column details
		$this->columnLinks = array();  // Cross references PageLinks
		$this->substitute = array();  // Array of substitution strings e.g. <ttz>112</ttz>
		$this->entsearch = array();  // Array of HTML entities (>ASCII 127) to substitute
		$this->entsubstitute = array(); // Array of substitution decimal unicode for the Hi entities
		$this->lastoptionaltag = '';
		$this->charset_in = '';
		$this->blk = array();
		$this->blklvl = 0;
		$this->tts = false;
		$this->ttz = false;
		$this->tta = false;
		$this->ispre = false;

		$this->checkSIP = false;
		$this->checkSMP = false;
		$this->checkCJK = false;

		$this->page_break_after_avoid = false;
		$this->margin_bottom_collapse = false;
		$this->tablethead = 0;
		$this->tabletfoot = 0;
		$this->table_border_attr_set = 0;
		$this->table_border_css_set = 0;
		$this->shrin_k = 1.0;
		$this->shrink_this_table_to_fit = 0;
		$this->MarginCorrection = 0;

		$this->tabletheadjustfinished = false;
		$this->usingCoreFont = false;
		$this->charspacing = 0;

		$this->autoPageBreak = true;

		require(_MPDF_PATH . 'config.php'); // config data

		$this->_setPageSize($format, $orientation);
		$this->DefOrientation = $orientation;

		$this->margin_header = $mgh;
		$this->margin_footer = $mgf;

		$bmargin = $mgb;

		$this->DeflMargin = $mgl;
		$this->DefrMargin = $mgr;

		$this->orig_tMargin = $mgt;
		$this->orig_bMargin = $bmargin;
		$this->orig_lMargin = $this->DeflMargin;
		$this->orig_rMargin = $this->DefrMargin;
		$this->orig_hMargin = $this->margin_header;
		$this->orig_fMargin = $this->margin_footer;

		if ($this->setAutoTopMargin == 'pad') {
			$mgt += $this->margin_header;
		}
		if ($this->setAutoBottomMargin == 'pad') {
			$mgb += $this->margin_footer;
		}
		$this->SetMargins($this->DeflMargin, $this->DefrMargin, $mgt); // sets l r t margin
		//Automatic page break
		$this->SetAutoPageBreak($this->autoPageBreak, $bmargin); // sets $this->bMargin & PageBreakTrigger

		$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;

		//Interior cell margin (1 mm) ? not used
		$this->cMarginL = 1;
		$this->cMarginR = 1;
		//Line width (0.2 mm)
		$this->LineWidth = .567 / _MPDFK;

		//To make the function Footer() work - replaces {nb} with page number
		$this->AliasNbPages();
		$this->AliasNbPageGroups();

		//$this->aliasNbPgHex = '{nbHEXmarker}';	// mPDF 6 deleted
		//$this->aliasNbPgGpHex = '{nbpgHEXmarker}';	// mPDF 6 deleted
		//Enable all tags as default
		$this->DisableTags();
		//Full width display mode
		$this->SetDisplayMode(100); // fullwidth?		'fullpage'
		//Compression
		$this->SetCompression(true);
		//Set default display preferences
		$this->SetDisplayPreferences('');

		// Font data
		require(_MPDF_PATH . 'config_fonts.php');

		// check for a custom config file that can add/overwrite the default config
		if (defined('_MPDF_SYSTEM_TTFONTS_CONFIG') && file_exists(_MPDF_SYSTEM_TTFONTS_CONFIG)) {
			require(_MPDF_SYSTEM_TTFONTS_CONFIG);
		}

		// Available fonts
		$this->available_unifonts = array();
		foreach ($this->fontdata AS $f => $fs) {
			if (isset($fs['R']) && $fs['R']) {
				$this->available_unifonts[] = $f;
			}
			if (isset($fs['B']) && $fs['B']) {
				$this->available_unifonts[] = $f . 'B';
			}
			if (isset($fs['I']) && $fs['I']) {
				$this->available_unifonts[] = $f . 'I';
			}
			if (isset($fs['BI']) && $fs['BI']) {
				$this->available_unifonts[] = $f . 'BI';
			}
		}

		$this->default_available_fonts = $this->available_unifonts;

		$optcore = false;
		$onlyCoreFonts = false;
		if (preg_match('/([\-+])aCJK/i', $mode, $m)) {
			$mode = preg_replace('/([\-+])aCJK/i', '', $mode); // mPDF 6
			if ($m[1] == '+') {
				$this->useAdobeCJK = true;
			} else {
				$this->useAdobeCJK = false;
			}
		}

		if (strlen($mode) == 1) {
			if ($mode == 's') {
				$this->percentSubset = 100;
				$mode = '';
			} elseif ($mode == 'c') {
				$onlyCoreFonts = true;
				$mode = '';
			}
		} elseif (substr($mode, -2) == '-s') {
			$this->percentSubset = 100;
			$mode = substr($mode, 0, strlen($mode) - 2);
		} elseif (substr($mode, -2) == '-c') {
			$onlyCoreFonts = true;
			$mode = substr($mode, 0, strlen($mode) - 2);
		} elseif (substr($mode, -2) == '-x') {
			$optcore = true;
			$mode = substr($mode, 0, strlen($mode) - 2);
		}

		// Autodetect if mode is a language_country string (en-GB or en_GB or en)
		if ($mode && $mode != 'UTF-8') { // mPDF 6
			list ($coreSuitable, $mpdf_pdf_unifont) = GetLangOpts($mode, $this->useAdobeCJK, $this->fontdata);
			if ($coreSuitable && $optcore) {
				$onlyCoreFonts = true;
			}
			if ($mpdf_pdf_unifont) {  // mPDF 6
				$default_font = $mpdf_pdf_unifont;
			}
			$this->currentLang = $mode;
			$this->default_lang = $mode;
		}

		$this->onlyCoreFonts = $onlyCoreFonts;

		if ($this->onlyCoreFonts) {
			$this->setMBencoding('windows-1252'); // sets $this->mb_enc
		} else {
			$this->setMBencoding('UTF-8'); // sets $this->mb_enc
		}
		@mb_regex_encoding('UTF-8'); // required only for mb_ereg... and mb_split functions
		// Adobe CJK fonts
		$this->available_CJK_fonts = array('gb', 'big5', 'sjis', 'uhc', 'gbB', 'big5B', 'sjisB', 'uhcB', 'gbI', 'big5I', 'sjisI', 'uhcI',
			'gbBI', 'big5BI', 'sjisBI', 'uhcBI');


		//Standard fonts
		$this->CoreFonts = array('ccourier' => 'Courier', 'ccourierB' => 'Courier-Bold', 'ccourierI' => 'Courier-Oblique', 'ccourierBI' => 'Courier-BoldOblique',
			'chelvetica' => 'Helvetica', 'chelveticaB' => 'Helvetica-Bold', 'chelveticaI' => 'Helvetica-Oblique', 'chelveticaBI' => 'Helvetica-BoldOblique',
			'ctimes' => 'Times-Roman', 'ctimesB' => 'Times-Bold', 'ctimesI' => 'Times-Italic', 'ctimesBI' => 'Times-BoldItalic',
			'csymbol' => 'Symbol', 'czapfdingbats' => 'ZapfDingbats');
		$this->fontlist = array("ctimes", "ccourier", "chelvetica", "csymbol", "czapfdingbats");

		// Substitutions
		$this->setHiEntitySubstitutions();

		if ($this->onlyCoreFonts) {
			$this->useSubstitutions = true;
			$this->SetSubstitutions();
		} else {
			$this->useSubstitutions = false;
		}

		/* -- HTML-CSS -- */

		if (!class_exists('cssmgr', false)) {
			include(_MPDF_PATH . 'classes/cssmgr.php');
		}
		$this->cssmgr = new cssmgr($this);
		// mPDF 6
		if (file_exists(_MPDF_PATH . 'mpdf.css')) {
			$css = file_get_contents(_MPDF_PATH . 'mpdf.css');
			$this->cssmgr->ReadCSS('<style> ' . $css . ' </style>');
		}
		/* -- END HTML-CSS -- */

		if ($default_font == '') {
			if ($this->onlyCoreFonts) {
				if (in_array(strtolower($this->defaultCSS['BODY']['FONT-FAMILY']), $this->mono_fonts)) {
					$default_font = 'ccourier';
				} elseif (in_array(strtolower($this->defaultCSS['BODY']['FONT-FAMILY']), $this->sans_fonts)) {
					$default_font = 'chelvetica';
				} else {
					$default_font = 'ctimes';
				}
			} else {
				$default_font = $this->defaultCSS['BODY']['FONT-FAMILY'];
			}
		}
		if (!$default_font_size) {
			$mmsize = $this->ConvertSize($this->defaultCSS['BODY']['FONT-SIZE']);
			$default_font_size = $mmsize * (_MPDFK);
		}

		if ($default_font) {
			$this->SetDefaultFont($default_font);
		}
		if ($default_font_size) {
			$this->SetDefaultFontSize($default_font_size);
		}

		$this->SetLineHeight(); // lineheight is in mm

		$this->SetFColor($this->ConvertColor(255));
		$this->HREF = '';
		$this->oldy = -1;
		$this->B = 0;
		$this->I = 0;

		// mPDF 6  Lists
		$this->listlvl = 0;
		$this->listtype = array();
		$this->listitem = array();
		$this->listcounter = array();

		$this->tdbegin = false;
		$this->table = array();
		$this->cell = array();
		$this->col = -1;
		$this->row = -1;
		$this->cellBorderBuffer = array();

		$this->divbegin = false;
		// mPDF 6
		$this->cellTextAlign = '';
		$this->cellLineHeight = '';
		$this->cellLineStackingStrategy = '';
		$this->cellLineStackingShift = '';

		$this->divwidth = 0;
		$this->divheight = 0;
		$this->spanbgcolor = false;
		$this->spanborder = false;
		$this->spanborddet = array();

		$this->blockjustfinished = false;
		$this->ignorefollowingspaces = true; //in order to eliminate exceeding left-side spaces
		$this->dash_on = false;
		$this->dotted_on = false;
		$this->textshadow = '';

		$this->currentfontfamily = '';
		$this->currentfontsize = '';
		$this->currentfontstyle = '';
		$this->colorarray = ''; // mPDF 6
		$this->spanbgcolorarray = ''; // mPDF 6
		$this->textbuffer = array();
		$this->internallink = array();
		$this->basepath = "";

		$this->SetBasePath('');

		$this->textparam = array();

		$this->specialcontent = '';
		$this->selectoption = array();

		/* -- IMPORTS -- */

		$this->tpls = array();
		$this->tpl = 0;
		$this->tplprefix = "/TPL";
		$this->res = array();
		if ($this->enableImports) {
			$this->SetImportUse();
		}
		/* -- END IMPORTS -- */

		if ($this->progressBar) {
			$this->StartProgressBarOutput($this->progressBar);
		} // *PROGRESS-BAR*

		$this->tag = new Tag($this);
	}

	function _setPageSize($format, &$orientation)
	{
		//Page format
		if (is_string($format)) {
			if ($format == '') {
				$format = 'A4';
			}
			$pfo = 'P';
			if (preg_match('/([0-9a-zA-Z]*)-L/i', $format, $m)) { // e.g. A4-L = A4 landscape
				$format = $m[1];
				$pfo = 'L';
			}
			$format = $this->_getPageFormat($format);
			if (!$format) {
				throw new MpdfException('Unknown page format: ' . $format);
			} else {
				$orientation = $pfo;
			}

			$this->fwPt = $format[0];
			$this->fhPt = $format[1];
		} else {
			if (!$format[0] || !$format[1]) {
				throw new MpdfException('Invalid page format: ' . $format[0] . ' ' . $format[1]);
			}
			$this->fwPt = $format[0] * _MPDFK;
			$this->fhPt = $format[1] * _MPDFK;
		}
		$this->fw = $this->fwPt / _MPDFK;
		$this->fh = $this->fhPt / _MPDFK;
		//Page orientation
		$orientation = strtolower($orientation);
		if ($orientation == 'p' or $orientation == 'portrait') {
			$orientation = 'P';
			$this->wPt = $this->fwPt;
			$this->hPt = $this->fhPt;
		} elseif ($orientation == 'l' or $orientation == 'landscape') {
			$orientation = 'L';
			$this->wPt = $this->fhPt;
			$this->hPt = $this->fwPt;
		} else
			throw new MpdfException('Incorrect orientation: ' . $orientation);
		$this->CurOrientation = $orientation;

		$this->w = $this->wPt / _MPDFK;
		$this->h = $this->hPt / _MPDFK;
	}

	function _getPageFormat($format)
	{
		switch (strtoupper($format)) {
			case '4A0': {
					$format = array(4767.87, 6740.79);
					break;
				}
			case '2A0': {
					$format = array(3370.39, 4767.87);
					break;
				}
			case 'A0': {
					$format = array(2383.94, 3370.39);
					break;
				}
			case 'A1': {
					$format = array(1683.78, 2383.94);
					break;
				}
			case 'A2': {
					$format = array(1190.55, 1683.78);
					break;
				}
			case 'A3': {
					$format = array(841.89, 1190.55);
					break;
				}
			case 'A4': {
					$format = array(595.28, 841.89);
					break;
				}
			case 'A5': {
					$format = array(419.53, 595.28);
					break;
				}
			case 'A6': {
					$format = array(297.64, 419.53);
					break;
				}
			case 'A7': {
					$format = array(209.76, 297.64);
					break;
				}
			case 'A8': {
					$format = array(147.40, 209.76);
					break;
				}
			case 'A9': {
					$format = array(104.88, 147.40);
					break;
				}
			case 'A10': {
					$format = array(73.70, 104.88);
					break;
				}
			case 'B0': {
					$format = array(2834.65, 4008.19);
					break;
				}
			case 'B1': {
					$format = array(2004.09, 2834.65);
					break;
				}
			case 'B2': {
					$format = array(1417.32, 2004.09);
					break;
				}
			case 'B3': {
					$format = array(1000.63, 1417.32);
					break;
				}
			case 'B4': {
					$format = array(708.66, 1000.63);
					break;
				}
			case 'B5': {
					$format = array(498.90, 708.66);
					break;
				}
			case 'B6': {
					$format = array(354.33, 498.90);
					break;
				}
			case 'B7': {
					$format = array(249.45, 354.33);
					break;
				}
			case 'B8': {
					$format = array(175.75, 249.45);
					break;
				}
			case 'B9': {
					$format = array(124.72, 175.75);
					break;
				}
			case 'B10': {
					$format = array(87.87, 124.72);
					break;
				}
			case 'C0': {
					$format = array(2599.37, 3676.54);
					break;
				}
			case 'C1': {
					$format = array(1836.85, 2599.37);
					break;
				}
			case 'C2': {
					$format = array(1298.27, 1836.85);
					break;
				}
			case 'C3': {
					$format = array(918.43, 1298.27);
					break;
				}
			case 'C4': {
					$format = array(649.13, 918.43);
					break;
				}
			case 'C5': {
					$format = array(459.21, 649.13);
					break;
				}
			case 'C6': {
					$format = array(323.15, 459.21);
					break;
				}
			case 'C7': {
					$format = array(229.61, 323.15);
					break;
				}
			case 'C8': {
					$format = array(161.57, 229.61);
					break;
				}
			case 'C9': {
					$format = array(113.39, 161.57);
					break;
				}
			case 'C10': {
					$format = array(79.37, 113.39);
					break;
				}
			case 'RA0': {
					$format = array(2437.80, 3458.27);
					break;
				}
			case 'RA1': {
					$format = array(1729.13, 2437.80);
					break;
				}
			case 'RA2': {
					$format = array(1218.90, 1729.13);
					break;
				}
			case 'RA3': {
					$format = array(864.57, 1218.90);
					break;
				}
			case 'RA4': {
					$format = array(609.45, 864.57);
					break;
				}
			case 'SRA0': {
					$format = array(2551.18, 3628.35);
					break;
				}
			case 'SRA1': {
					$format = array(1814.17, 2551.18);
					break;
				}
			case 'SRA2': {
					$format = array(1275.59, 1814.17);
					break;
				}
			case 'SRA3': {
					$format = array(907.09, 1275.59);
					break;
				}
			case 'SRA4': {
					$format = array(637.80, 907.09);
					break;
				}
			case 'LETTER': {
					$format = array(612.00, 792.00);
					break;
				}
			case 'LEGAL': {
					$format = array(612.00, 1008.00);
					break;
				}
			case 'LEDGER': {
					$format = array(1224.00, 792.00);
					break;
				}
			case 'TABLOID': {
					$format = array(792.00, 1224.00);
					break;
				}
			case 'EXECUTIVE': {
					$format = array(521.86, 756.00);
					break;
				}
			case 'FOLIO': {
					$format = array(612.00, 936.00);
					break;
				}
			case 'B': {
					$format = array(362.83, 561.26);
					break;
				}  //	'B' format paperback size 128x198mm
			case 'A': {
					$format = array(314.65, 504.57);
					break;
				}  //	'A' format paperback size 111x178mm
			case 'DEMY': {
					$format = array(382.68, 612.28);
					break;
				}  //	'Demy' format paperback size 135x216mm
			case 'ROYAL': {
					$format = array(433.70, 663.30);
					break;
				} //	'Royal' format paperback size 153x234mm
			default: {
					$format = array(595.28, 841.89);
					break;
				}
		}
		return $format;
	}

	/* -- PROGRESS-BAR -- */

	function StartProgressBarOutput($mode = 1)
	{
		// must be relative path, or URI (not a file system path)
		if (!defined('_MPDF_URI')) {
			$this->progressBar = false;
			if ($this->debug) {
				throw new MpdfException("You need to define _MPDF_URI to use the progress bar!");
			} else
				return false;
		}
		$this->progressBar = $mode;
		if ($this->progbar_altHTML) {
			echo $this->progbar_altHTML;
		} else {
			echo '<html>
	<head>
	<title>mPDF File Progress</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<link rel="stylesheet" type="text/css" href="' . _MPDF_URI . 'progbar.css" />
		</head>
	<body>
	<div class="main">
		<div class="heading">' . $this->progbar_heading . '</div>
		<div class="demo">
	   ';
			if ($this->progressBar == 2) {
				echo '		<table width="100%"><tr><td style="width: 50%;">
			<span class="barheading">Writing HTML code</span> <br/>

			<div class="progressBar">
			<div id="element1"  class="innerBar">&nbsp;</div>
			</div>
			<span class="code" id="box1"></span>
			</td><td style="width: 50%;">
			<span class="barheading">Autosizing elements</span> <br/>
			<div class="progressBar">
			<div id="element4"  class="innerBar">&nbsp;</div>
			</div>
			<span class="code" id="box4"></span>
			<br/><br/>
			<span class="barheading">Writing Tables</span> <br/>
			<div class="progressBar">
			<div id="element7"  class="innerBar">&nbsp;</div>
			</div>
			<span class="code" id="box7"></span>
			</td></tr>
			<tr><td><br /><br /></td><td></td></tr>
			<tr><td style="width: 50%;">
	';
			}
			echo '			<span class="barheading">Writing PDF file</span> <br/>
			<div class="progressBar">
			<div id="element2"  class="innerBar">&nbsp;</div>
			</div>
			<span class="code" id="box2"></span>
	   ';
			if ($this->progressBar == 2) {
				echo '
			</td><td style="width: 50%;">
			<span class="barheading">Memory usage</span> <br/>
			<div class="progressBar">
			<div id="element5"  class="innerBar">&nbsp;</div>
			</div>
			<span id="box5">0</span> ' . ini_get("memory_limit") . '<br />
			<br/><br/>
			<span class="barheading">Memory usage (peak)</span> <br/>
			<div class="progressBar">
			<div id="element6"  class="innerBar">&nbsp;</div>
			</div>
			<span id="box6">0</span> ' . ini_get("memory_limit") . '<br />
			</td></tr>
			</table>
	   ';
			}
			echo '			<br/><br/>
		<span id="box3"></span>

		</div>
	   ';
		}
		ob_flush();
		flush();
	}

	function UpdateProgressBar($el, $val, $txt = '')
	{
		// $val should be a string - 5 = actual value, +15 = increment

		if ($this->progressBar < 2) {
			if ($el > 3) {
				return;
			} elseif ($el == 1) {
				$el = 2;
			}
		}
		echo '<script type="text/javascript">';
		if ($val) {
			echo ' document.getElementById(\'element' . $el . '\').style.width=\'' . $val . '%\'; ';
		}
		if ($txt) {
			echo ' document.getElementById(\'box' . $el . '\').innerHTML=\'' . $txt . '\'; ';
		}
		if ($this->progressBar == 2) {
			$m = round(memory_get_usage(true) / 1048576);
			$m2 = round(memory_get_peak_usage(true) / 1048576);
			$mem = $m * 100 / (ini_get("memory_limit") + 0);
			$mem2 = $m2 * 100 / (ini_get("memory_limit") + 0);
			echo ' document.getElementById(\'element5\').style.width=\'' . $mem . '%\'; ';
			echo ' document.getElementById(\'element6\').style.width=\'' . $mem2 . '%\'; ';
			echo ' document.getElementById(\'box5\').innerHTML=\'' . $m . 'MB / \'; ';
			echo ' document.getElementById(\'box6\').innerHTML=\'' . $m2 . 'MB / \'; ';
		}
		echo '</script>' . "\n";
		ob_flush();
		flush();
	}

	/* -- END PROGRESS-BAR -- */

	function RestrictUnicodeFonts($res)
	{
		// $res = array of (Unicode) fonts to restrict to: e.g. norasi|norasiB - language specific
		if (count($res)) { // Leave full list of available fonts if passed blank array
			$this->available_unifonts = $res;
		} else {
			$this->available_unifonts = $this->default_available_fonts;
		}
		if (count($this->available_unifonts) == 0) {
			$this->available_unifonts[] = $this->default_available_fonts[0];
		}
		$this->available_unifonts = array_values($this->available_unifonts);
	}

	function setMBencoding($enc)
	{
		if ($this->mb_enc != $enc) {
			$this->mb_enc = $enc;
			mb_internal_encoding($this->mb_enc);
		}
	}

	function SetMargins($left, $right, $top)
	{
		//Set left, top and right margins
		$this->lMargin = $left;
		$this->rMargin = $right;
		$this->tMargin = $top;
	}

	function ResetMargins()
	{
		//ReSet left, top margins
		if (($this->forcePortraitHeaders || $this->forcePortraitMargins) && $this->DefOrientation == 'P' && $this->CurOrientation == 'L') {
			if (($this->mirrorMargins) && (($this->page) % 2 == 0)) { // EVEN
				$this->tMargin = $this->orig_rMargin;
				$this->bMargin = $this->orig_lMargin;
			} else { // ODD	// OR NOT MIRRORING MARGINS/FOOTERS
				$this->tMargin = $this->orig_lMargin;
				$this->bMargin = $this->orig_rMargin;
			}
			$this->lMargin = $this->DeflMargin;
			$this->rMargin = $this->DefrMargin;
			$this->MarginCorrection = 0;
			$this->PageBreakTrigger = $this->h - $this->bMargin;
		} elseif (($this->mirrorMargins) && (($this->page) % 2 == 0)) { // EVEN
			$this->lMargin = $this->DefrMargin;
			$this->rMargin = $this->DeflMargin;
			$this->MarginCorrection = $this->DefrMargin - $this->DeflMargin;
		} else { // ODD	// OR NOT MIRRORING MARGINS/FOOTERS
			$this->lMargin = $this->DeflMargin;
			$this->rMargin = $this->DefrMargin;
			if ($this->mirrorMargins) {
				$this->MarginCorrection = $this->DeflMargin - $this->DefrMargin;
			}
		}
		$this->x = $this->lMargin;
	}

	function SetLeftMargin($margin)
	{
		//Set left margin
		$this->lMargin = $margin;
		if ($this->page > 0 and $this->x < $margin)
			$this->x = $margin;
	}

	function SetTopMargin($margin)
	{
		//Set top margin
		$this->tMargin = $margin;
	}

	function SetRightMargin($margin)
	{
		//Set right margin
		$this->rMargin = $margin;
	}

	function SetAutoPageBreak($auto, $margin = 0)
	{
		//Set auto page break mode and triggering margin
		$this->autoPageBreak = $auto;
		$this->bMargin = $margin;
		$this->PageBreakTrigger = $this->h - $margin;
	}

	function SetDisplayMode($zoom, $layout = 'continuous')
	{
		//Set display mode in viewer
		if ($zoom == 'fullpage' or $zoom == 'fullwidth' or $zoom == 'real' or $zoom == 'default' or ! is_string($zoom))
			$this->ZoomMode = $zoom;
		else
			throw new MpdfException('Incorrect zoom display mode: ' . $zoom);
		if ($layout == 'single' or $layout == 'continuous' or $layout == 'two' or $layout == 'twoleft' or $layout == 'tworight' or $layout == 'default')
			$this->LayoutMode = $layout;
		else
			throw new MpdfException('Incorrect layout display mode: ' . $layout);
	}

	function SetCompression($compress)
	{
		//Set page compression
		if (function_exists('gzcompress'))
			$this->compress = $compress;
		else
			$this->compress = false;
	}

	function SetTitle($title)
	{
		//Title of document // Arrives as UTF-8
		$this->title = $title;
	}

	function SetSubject($subject)
	{
		//Subject of document
		$this->subject = $subject;
	}

	function SetAuthor($author)
	{
		//Author of document
		$this->author = $author;
	}

	function SetKeywords($keywords)
	{
		//Keywords of document
		$this->keywords = $keywords;
	}

	function SetCreator($creator)
	{
		//Creator of document
		$this->creator = $creator;
	}

	function SetAnchor2Bookmark($x)
	{
		$this->anchor2Bookmark = $x;
	}

	function AliasNbPages($alias = '{nb}')
	{
		//Define an alias for total number of pages
		$this->aliasNbPg = $alias;
	}

	function AliasNbPageGroups($alias = '{nbpg}')
	{
		//Define an alias for total number of pages in a group
		$this->aliasNbPgGp = $alias;
	}

	function SetAlpha($alpha, $bm = 'Normal', $return = false, $mode = 'B')
	{
		// alpha: real value from 0 (transparent) to 1 (opaque)
		// bm:    blend mode, one of the following:
		//          Normal, Multiply, Screen, Overlay, Darken, Lighten, ColorDodge, ColorBurn,
		//          HardLight, SoftLight, Difference, Exclusion, Hue, Saturation, Color, Luminosity
		// set alpha for stroking (CA) and non-stroking (ca) operations
		// mode determines F (fill) S (stroke) B (both)
		if (($this->PDFA || $this->PDFX) && $alpha != 1) {
			if (($this->PDFA && !$this->PDFAauto) || ($this->PDFX && !$this->PDFXauto)) {
				$this->PDFAXwarnings[] = "Image opacity must be 100% (Opacity changed to 100%)";
			}
			$alpha = 1;
		}
		$a = array('BM' => '/' . $bm);
		if ($mode == 'F' || $mode == 'B')
			$a['ca'] = $alpha; // mPDF 5.7.2
		if ($mode == 'S' || $mode == 'B')
			$a['CA'] = $alpha; // mPDF 5.7.2
		$gs = $this->AddExtGState($a);
		if ($return) {
			return sprintf('/GS%d gs', $gs);
		} else {
			$this->_out(sprintf('/GS%d gs', $gs));
		}
	}

	function AddExtGState($parms)
	{
		$n = count($this->extgstates);
		// check if graphics state already exists
		for ($i = 1; $i <= $n; $i++) {
			if (count($this->extgstates[$i]['parms']) == count($parms)) {
				$same = true;
				foreach ($this->extgstates[$i]['parms'] AS $k => $v) {
					if (!isset($parms[$k]) || $parms[$k] != $v) {
						$same = false;
						break;
					}
				}
				if ($same) {
					return $i;
				}
			}
		}
		$n++;
		$this->extgstates[$n]['parms'] = $parms;
		return $n;
	}

	function SetVisibility($v)
	{
		if (($this->PDFA || $this->PDFX) && $this->visibility != 'visible') {
			$this->PDFAXwarnings[] = "Cannot set visibility to anything other than full when using PDFA or PDFX";
			return '';
		} elseif (!$this->PDFA && !$this->PDFX)
			$this->pdf_version = '1.5';
		if ($this->visibility != 'visible') {
			$this->_out('EMC');
			$this->hasOC = intval($this->hasOC);
		}
		if ($v == 'printonly') {
			$this->_out('/OC /OC1 BDC');
			$this->hasOC = ($this->hasOC | 1);
		} elseif ($v == 'screenonly') {
			$this->_out('/OC /OC2 BDC');
			$this->hasOC = ($this->hasOC | 2);
		} elseif ($v == 'hidden') {
			$this->_out('/OC /OC3 BDC');
			$this->hasOC = ($this->hasOC | 4);
		} elseif ($v != 'visible')
			throw new MpdfException('Incorrect visibility: ' . $v);
		$this->visibility = $v;
	}

	function Open()
	{
		//Begin document
		if ($this->state == 0) {
			// Was is function _begindoc()
			// Start document
			$this->state = 1;
			$this->_out('%PDF-' . $this->pdf_version);
			$this->_out('%' . chr(226) . chr(227) . chr(207) . chr(211)); // 4 chars > 128 to show binary file
		}
	}

	// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// DEPRACATED but included for backwards compatability
	// Depracated - can use AddPage for all
	function AddPages($a = '', $b = '', $c = '', $d = '', $e = '', $f = '', $g = '', $h = '', $i = '', $j = '', $k = '', $l = '', $m = '', $n = '', $o = '', $p = 0, $q = 0, $r = 0, $s = 0, $t = '', $u = '')
	{
		throw new MpdfException('function AddPages is depracated as of mPDF 6. Please use AddPage or HTML code methods instead.');
	}

	function startPageNums()
	{
		throw new MpdfException('function startPageNums is depracated as of mPDF 6.');
	}

	function setUnvalidatedText($a = '', $b = -1)
	{
		throw new MpdfException('function setUnvalidatedText is depracated as of mPDF 6. Please use SetWatermarkText instead.');
	}

	function SetAutoFont($a)
	{
		throw new MpdfException('function SetAutoFont is depracated as of mPDF 6. Please use autoScriptToLang instead. See config.php');
	}

	function Reference($a)
	{
		throw new MpdfException('function Reference is depracated as of mPDF 6. Please use IndexEntry instead.');
	}

	function ReferenceSee($a, $b)
	{
		throw new MpdfException('function ReferenceSee is depracated as of mPDF 6. Please use IndexEntrySee instead.');
	}

	function CreateReference($a = 1, $b = '', $c = '', $d = 3, $e = 1, $f = '', $g = 5, $h = '', $i = '', $j = false)
	{
		throw new MpdfException('function CreateReference is depracated as of mPDF 6. Please use InsertIndex instead.');
	}

	function CreateIndex($a = 1, $b = '', $c = '', $d = 3, $e = 1, $f = '', $g = 5, $h = '', $i = '', $j = false)
	{
		throw new MpdfException('function CreateIndex is depracated as of mPDF 6. Please use InsertIndex instead.');
	}

	// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	function Close()
	{
		// Check old Aliases - now depracated mPDF 6
		if (isset($this->UnvalidatedText)) {
			throw new MpdfException('$mpdf->UnvalidatedText is depracated as of mPDF 6. Please use $mpdf->watermarkText  instead.');
		}
		if (isset($this->TopicIsUnvalidated)) {
			throw new MpdfException('$mpdf->TopicIsUnvalidated is depracated as of mPDF 6. Please use $mpdf->showWatermarkText instead.');
		}
		if (isset($this->AliasNbPg)) {
			throw new MpdfException('$mpdf->AliasNbPg is depracated as of mPDF 6. Please use $mpdf->aliasNbPg instead.');
		}
		if (isset($this->AliasNbPgGp)) {
			throw new MpdfException('$mpdf->AliasNbPgGp is depracated as of mPDF 6. Please use $mpdf->aliasNbPgGp instead.');
		}
		if (isset($this->BiDirectional)) {
			throw new MpdfException('$mpdf->BiDirectional is depracated as of mPDF 6. Please use $mpdf->biDirectional instead.');
		}
		if (isset($this->Anchor2Bookmark)) {
			throw new MpdfException('$mpdf->Anchor2Bookmark is depracated as of mPDF 6. Please use $mpdf->anchor2Bookmark instead.');
		}
		if (isset($this->KeepColumns)) {
			throw new MpdfException('$mpdf->KeepColumns is depracated as of mPDF 6. Please use $mpdf->keepColumns instead.');
		}
		if (isset($this->useOddEven)) {
			throw new MpdfException('$mpdf->useOddEven is depracated as of mPDF 6. Please use $mpdf->mirrorMargins instead.');
		}
		if (isset($this->useSubstitutionsMB)) {
			throw new MpdfException('$mpdf->useSubstitutionsMB is depracated as of mPDF 6. Please use $mpdf->useSubstitutions instead.');
		}
		if (isset($this->useLang)) {
			throw new MpdfException('$mpdf->useLang is depracated as of mPDF 6. Please use $mpdf->autoLangToFont instead.');
		}
		if (isset($this->useAutoFont)) {
			throw new MpdfException('$mpdf->useAutoFont is depracated. Please use $mpdf->autoScriptToLang instead.');
		}

		if ($this->progressBar) {
			$this->UpdateProgressBar(2, '2', 'Closing last page');
		} // *PROGRESS-BAR*
		//Terminate document
		if ($this->state == 3)
			return;
		if ($this->page == 0)
			$this->AddPage($this->CurOrientation);
		if (count($this->cellBorderBuffer)) {
			$this->printcellbuffer();
		} // *TABLES*
		if ($this->tablebuffer) {
			$this->printtablebuffer();
		} // *TABLES*
		/* -- COLUMNS -- */

		if ($this->ColActive) {
			$this->SetColumns(0);
			$this->ColActive = 0;
			if (count($this->columnbuffer)) {
				$this->printcolumnbuffer();
			}
		}
		/* -- END COLUMNS -- */

		// BODY Backgrounds
		$s = '';

		$s .= $this->PrintBodyBackgrounds();

		$s .= $this->PrintPageBackgrounds();
		$this->pages[$this->page] = preg_replace('/(___BACKGROUND___PATTERNS' . $this->uniqstr . ')/', "\n" . $s . "\n" . '\\1', $this->pages[$this->page]);
		$this->pageBackgrounds = array();

		if ($this->visibility != 'visible')
			$this->SetVisibility('visible');
		$this->EndLayer();

		if (!$this->tocontents || !$this->tocontents->TOCmark) { //Page footer
			// ITS4YOU VlZa
    		//$this->InFooter=true;
    		//$this->Footer();
    		//$this->InFooter=false;
            if($this->PDFMakerDispFooter["df_last"] !== false || ($this->page == 1 && $this->PDFMakerDispFooter["df_first"] !== false)) {
        		$this->InFooter=true;
        		$this->Footer();
        		$this->InFooter=false;
    		}
    		// ITS4YOU-END
		}
		if ($this->tocontents && ($this->tocontents->TOCmark || count($this->tocontents->m_TOC))) {
			$this->tocontents->insertTOC();
		} // *TOC*
		//Close page
		$this->_endpage();

		//Close document
		$this->_enddoc();
	}

	/* -- BACKGROUNDS -- */

	function _resizeBackgroundImage($imw, $imh, $cw, $ch, $resize = 0, $repx, $repy, $pba = array(), $size = array())
	{
		// pba is background positioning area (from CSS background-origin) may not always be set [x,y,w,h]
		// size is from CSS3 background-size - takes precendence over old resize
		//	$w - absolute length or % or auto or cover | contain
		//	$h - absolute length or % or auto or cover | contain
		if (isset($pba['w']))
			$cw = $pba['w'];
		if (isset($pba['h']))
			$ch = $pba['h'];

		$cw = $cw * _MPDFK;
		$ch = $ch * _MPDFK;
		if (empty($size) && !$resize) {
			return array($imw, $imh, $repx, $repy);
		}

		if (isset($size['w']) && $size['w']) {
			if ($size['w'] == 'contain') {
				// Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area.
				// Same as resize==3
				$h = $imh * $cw / $imw;
				$w = $cw;
				if ($h > $ch) {
					$w = $w * $ch / $h;
					$h = $ch;
				}
			} elseif ($size['w'] == 'cover') {
				// Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area.
				$h = $imh * $cw / $imw;
				$w = $cw;
				if ($h < $ch) {
					$w = $w * $h / $ch;
					$h = $ch;
				}
			} else {
				if (stristr($size['w'], '%')) {
					$size['w'] += 0;
					$size['w'] /= 100;
					$size['w'] = ($cw * $size['w']);
				}
				if (stristr($size['h'], '%')) {
					$size['h'] += 0;
					$size['h'] /= 100;
					$size['h'] = ($ch * $size['h']);
				}
				if ($size['w'] == 'auto' && $size['h'] == 'auto') {
					$w = $imw;
					$h = $imh;
				} elseif ($size['w'] == 'auto' && $size['h'] != 'auto') {
					$w = $imw * $size['h'] / $imh;
					$h = $size['h'];
				} elseif ($size['w'] != 'auto' && $size['h'] == 'auto') {
					$h = $imh * $size['w'] / $imw;
					$w = $size['w'];
				} else {
					$w = $size['w'];
					$h = $size['h'];
				}
			}
			return array($w, $h, $repx, $repy);
		} elseif ($resize == 1 && $imw > $cw) {
			$h = $imh * $cw / $imw;
			return array($cw, $h, $repx, $repy);
		} elseif ($resize == 2 && $imh > $ch) {
			$w = $imw * $ch / $imh;
			return array($w, $ch, $repx, $repy);
		} elseif ($resize == 3) {
			$w = $imw;
			$h = $imh;
			if ($w > $cw) {
				$h = $h * $cw / $w;
				$w = $cw;
			}
			if ($h > $ch) {
				$w = $w * $ch / $h;
				$h = $ch;
			}
			return array($w, $h, $repx, $repy);
		} elseif ($resize == 4) {
			$h = $imh * $cw / $imw;
			return array($cw, $h, $repx, $repy);
		} elseif ($resize == 5) {
			$w = $imw * $ch / $imh;
			return array($w, $ch, $repx, $repy);
		} elseif ($resize == 6) {
			return array($cw, $ch, $repx, $repy);
		}
		return array($imw, $imh, $repx, $repy);
	}

	function SetBackground(&$properties, &$maxwidth)
	{
		if (isset($properties['BACKGROUND-ORIGIN']) && ($properties['BACKGROUND-ORIGIN'] == 'border-box' || $properties['BACKGROUND-ORIGIN'] == 'content-box')) {
			$origin = $properties['BACKGROUND-ORIGIN'];
		} else {
			$origin = 'padding-box';
		}
		if (isset($properties['BACKGROUND-SIZE'])) {
			if (stristr($properties['BACKGROUND-SIZE'], 'contain')) {
				$bsw = $bsh = 'contain';
			} elseif (stristr($properties['BACKGROUND-SIZE'], 'cover')) {
				$bsw = $bsh = 'cover';
			} else {
				$bsw = $bsh = 'auto';
				$sz = preg_split('/\s+/', trim($properties['BACKGROUND-SIZE']));
				if (count($sz) == 2) {
					$bsw = $sz[0];
					$bsh = $sz[1];
				} else {
					$bsw = $sz[0];
				}
				if (!stristr($bsw, '%') && !stristr($bsw, 'auto')) {
					$bsw = $this->ConvertSize($bsw, $maxwidth, $this->FontSize);
				}
				if (!stristr($bsh, '%') && !stristr($bsh, 'auto')) {
					$bsh = $this->ConvertSize($bsh, $maxwidth, $this->FontSize);
				}
			}
			$size = array('w' => $bsw, 'h' => $bsh);
		} else {
			$size = false;
		} // mPDF 6
		if (preg_match('/(-moz-)*(repeating-)*(linear|radial)-gradient/', $properties['BACKGROUND-IMAGE'])) {
			return array('gradient' => $properties['BACKGROUND-IMAGE'], 'origin' => $origin, 'size' => $size);
		} else {
			$file = $properties['BACKGROUND-IMAGE'];
			$sizesarray = $this->Image($file, 0, 0, 0, 0, '', '', false, false, false, false, true);
			if (isset($sizesarray['IMAGE_ID'])) {
				$image_id = $sizesarray['IMAGE_ID'];
				$orig_w = $sizesarray['WIDTH'] * _MPDFK;  // in user units i.e. mm
				$orig_h = $sizesarray['HEIGHT'] * _MPDFK;  // (using $this->img_dpi)
				if (isset($properties['BACKGROUND-IMAGE-RESOLUTION'])) {
					if (preg_match('/from-image/i', $properties['BACKGROUND-IMAGE-RESOLUTION']) && isset($sizesarray['set-dpi']) && $sizesarray['set-dpi'] > 0) {
						$orig_w *= $this->img_dpi / $sizesarray['set-dpi'];
						$orig_h *= $this->img_dpi / $sizesarray['set-dpi'];
					} elseif (preg_match('/(\d+)dpi/i', $properties['BACKGROUND-IMAGE-RESOLUTION'], $m)) {
						$dpi = $m[1];
						if ($dpi > 0) {
							$orig_w *= $this->img_dpi / $dpi;
							$orig_h *= $this->img_dpi / $dpi;
						}
					}
				}
				$x_repeat = true;
				$y_repeat = true;
				if (isset($properties['BACKGROUND-REPEAT'])) {
					if ($properties['BACKGROUND-REPEAT'] == 'no-repeat' || $properties['BACKGROUND-REPEAT'] == 'repeat-x') {
						$y_repeat = false;
					}
					if ($properties['BACKGROUND-REPEAT'] == 'no-repeat' || $properties['BACKGROUND-REPEAT'] == 'repeat-y') {
						$x_repeat = false;
					}
				}
				$x_pos = 0;
				$y_pos = 0;
				if (isset($properties['BACKGROUND-POSITION'])) {
					$ppos = preg_split('/\s+/', $properties['BACKGROUND-POSITION']);
					$x_pos = $ppos[0];
					$y_pos = $ppos[1];
					if (!stristr($x_pos, '%')) {
						$x_pos = $this->ConvertSize($x_pos, $maxwidth, $this->FontSize);
					}
					if (!stristr($y_pos, '%')) {
						$y_pos = $this->ConvertSize($y_pos, $maxwidth, $this->FontSize);
					}
				}
				if (isset($properties['BACKGROUND-IMAGE-RESIZE'])) {
					$resize = $properties['BACKGROUND-IMAGE-RESIZE'];
				} else {
					$resize = 0;
				}
				if (isset($properties['BACKGROUND-IMAGE-OPACITY'])) {
					$opacity = $properties['BACKGROUND-IMAGE-OPACITY'];
				} else {
					$opacity = 1;
				}
				return array('image_id' => $image_id, 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $x_pos, 'y_pos' => $y_pos, 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'resize' => $resize, 'opacity' => $opacity, 'itype' => $sizesarray['itype'], 'origin' => $origin, 'size' => $size);
			}
		}
		return false;
	}

	/* -- END BACKGROUNDS -- */

	function PrintBodyBackgrounds()
	{
		$s = '';
		$clx = 0;
		$cly = 0;
		$clw = $this->w;
		$clh = $this->h;
		// If using bleed and trim margins in paged media
		if ($this->pageDim[$this->page]['outer_width_LR'] || $this->pageDim[$this->page]['outer_width_TB']) {
			$clx = $this->pageDim[$this->page]['outer_width_LR'] - $this->pageDim[$this->page]['bleedMargin'];
			$cly = $this->pageDim[$this->page]['outer_width_TB'] - $this->pageDim[$this->page]['bleedMargin'];
			$clw = $this->w - 2 * $clx;
			$clh = $this->h - 2 * $cly;
		}

		if ($this->bodyBackgroundColor) {
			$s .= 'q ' . $this->SetFColor($this->bodyBackgroundColor, true) . "\n";
			if ($this->bodyBackgroundColor{0} == 5) { // RGBa
				$s .= $this->SetAlpha(ord($this->bodyBackgroundColor{4}) / 100, 'Normal', true, 'F') . "\n";
			} elseif ($this->bodyBackgroundColor{0} == 6) { // CMYKa
				$s .= $this->SetAlpha(ord($this->bodyBackgroundColor{5}) / 100, 'Normal', true, 'F') . "\n";
			}
			$s .= sprintf('%.3F %.3F %.3F %.3F re f Q', ($clx * _MPDFK), ($cly * _MPDFK), $clw * _MPDFK, $clh * _MPDFK) . "\n";
		}

		/* -- BACKGROUNDS -- */
		if ($this->bodyBackgroundGradient) {
			$g = $this->grad->parseBackgroundGradient($this->bodyBackgroundGradient);
			if ($g) {
				$s .= $this->grad->Gradient($clx, $cly, $clw, $clh, (isset($g['gradtype']) ? $g['gradtype'] : null), $g['stops'], $g['colorspace'], $g['coords'], $g['extend'], true);
			}
		}
		if ($this->bodyBackgroundImage) {
			if (isset($this->bodyBackgroundImage['gradient']) && $this->bodyBackgroundImage['gradient'] && preg_match('/(-moz-)*(repeating-)*(linear|radial)-gradient/', $this->bodyBackgroundImage['gradient'])) {
				$g = $this->grad->parseMozGradient($this->bodyBackgroundImage['gradient']);
				if ($g) {
					$s .= $this->grad->Gradient($clx, $cly, $clw, $clh, $g['type'], $g['stops'], $g['colorspace'], $g['coords'], $g['extend'], true);
				}
			} elseif ($this->bodyBackgroundImage['image_id']) { // Background pattern
				$n = count($this->patterns) + 1;
				// If using resize, uses TrimBox (not including the bleed)
				list($orig_w, $orig_h, $x_repeat, $y_repeat) = $this->_resizeBackgroundImage($this->bodyBackgroundImage['orig_w'], $this->bodyBackgroundImage['orig_h'], $clw, $clh, $this->bodyBackgroundImage['resize'], $this->bodyBackgroundImage['x_repeat'], $this->bodyBackgroundImage['y_repeat']);

				$this->patterns[$n] = array('x' => $clx, 'y' => $cly, 'w' => $clw, 'h' => $clh, 'pgh' => $this->h, 'image_id' => $this->bodyBackgroundImage['image_id'], 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $this->bodyBackgroundImage['x_pos'], 'y_pos' => $this->bodyBackgroundImage['y_pos'], 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'itype' => $this->bodyBackgroundImage['itype']);
				if (($this->bodyBackgroundImage['opacity'] > 0 || $this->bodyBackgroundImage['opacity'] === '0') && $this->bodyBackgroundImage['opacity'] < 1) {
					$opac = $this->SetAlpha($this->bodyBackgroundImage['opacity'], 'Normal', true);
				} else {
					$opac = '';
				}
				$s .= sprintf('q /Pattern cs /P%d scn %s %.3F %.3F %.3F %.3F re f Q', $n, $opac, ($clx * _MPDFK), ($cly * _MPDFK), $clw * _MPDFK, $clh * _MPDFK) . "\n";
			}
		}
		/* -- END BACKGROUNDS -- */
		return $s;
	}

	function _setClippingPath($clx, $cly, $clw, $clh)
	{
		$s = ' q 0 w '; // Line width=0
		$s .= sprintf('%.3F %.3F m ', ($clx) * _MPDFK, ($this->h - ($cly)) * _MPDFK); // start point TL before the arc
		$s .= sprintf('%.3F %.3F l ', ($clx) * _MPDFK, ($this->h - ($cly + $clh)) * _MPDFK); // line to BL
		$s .= sprintf('%.3F %.3F l ', ($clx + $clw) * _MPDFK, ($this->h - ($cly + $clh)) * _MPDFK); // line to BR
		$s .= sprintf('%.3F %.3F l ', ($clx + $clw) * _MPDFK, ($this->h - ($cly)) * _MPDFK); // line to TR
		$s .= sprintf('%.3F %.3F l ', ($clx) * _MPDFK, ($this->h - ($cly)) * _MPDFK); // line to TL
		$s .= ' W n '; // Ends path no-op & Sets the clipping path
		return $s;
	}

	function PrintPageBackgrounds($adjustmenty = 0)
	{
		$s = '';

		ksort($this->pageBackgrounds);
		foreach ($this->pageBackgrounds AS $bl => $pbs) {
			foreach ($pbs AS $pb) {
				if ((!isset($pb['image_id']) && !isset($pb['gradient'])) || isset($pb['shadowonly'])) { // Background colour or boxshadow
					if ($pb['z-index'] > 0) {
						$this->current_layer = $pb['z-index'];
						$s .= "\n" . '/OCBZ-index /ZI' . $pb['z-index'] . ' BDC' . "\n";
					}

					if ($pb['visibility'] != 'visible') {
						if ($pb['visibility'] == 'printonly')
							$s .= '/OC /OC1 BDC' . "\n";
						elseif ($pb['visibility'] == 'screenonly')
							$s .= '/OC /OC2 BDC' . "\n";
						elseif ($pb['visibility'] == 'hidden')
							$s .= '/OC /OC3 BDC' . "\n";
					}
					// Box shadow
					if (isset($pb['shadow']) && $pb['shadow']) {
						$s .= $pb['shadow'] . "\n";
					}
					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= $pb['clippath'] . "\n";
					}
					$s .= 'q ' . $this->SetFColor($pb['col'], true) . "\n";
					if ($pb['col']{0} == 5) { // RGBa
						$s .= $this->SetAlpha(ord($pb['col']{4}) / 100, 'Normal', true, 'F') . "\n";
					} elseif ($pb['col']{0} == 6) { // CMYKa
						$s .= $this->SetAlpha(ord($pb['col']{5}) / 100, 'Normal', true, 'F') . "\n";
					}
					$s .= sprintf('%.3F %.3F %.3F %.3F re f Q', $pb['x'] * _MPDFK, ($this->h - $pb['y']) * _MPDFK, $pb['w'] * _MPDFK, -$pb['h'] * _MPDFK) . "\n";
					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= 'Q' . "\n";
					}
					if ($pb['visibility'] != 'visible')
						$s .= 'EMC' . "\n";

					if ($pb['z-index'] > 0) {
						$s .= "\n" . 'EMCBZ-index' . "\n";
						$this->current_layer = 0;
					}
				}
			}
			/* -- BACKGROUNDS -- */
			foreach ($pbs AS $pb) {
				if ((isset($pb['gradient']) && $pb['gradient']) || (isset($pb['image_id']) && $pb['image_id'])) {
					if ($pb['z-index'] > 0) {
						$this->current_layer = $pb['z-index'];
						$s .= "\n" . '/OCGZ-index /ZI' . $pb['z-index'] . ' BDC' . "\n";
					}
					if ($pb['visibility'] != 'visible') {
						if ($pb['visibility'] == 'printonly')
							$s .= '/OC /OC1 BDC' . "\n";
						elseif ($pb['visibility'] == 'screenonly')
							$s .= '/OC /OC2 BDC' . "\n";
						elseif ($pb['visibility'] == 'hidden')
							$s .= '/OC /OC3 BDC' . "\n";
					}
				}
				if (isset($pb['gradient']) && $pb['gradient']) {
					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= $pb['clippath'] . "\n";
					}
					$s .= $this->grad->Gradient($pb['x'], $pb['y'], $pb['w'], $pb['h'], $pb['gradtype'], $pb['stops'], $pb['colorspace'], $pb['coords'], $pb['extend'], true);
					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= 'Q' . "\n";
					}
				} elseif (isset($pb['image_id']) && $pb['image_id']) { // Background Image
					$pb['y'] -= $adjustmenty;
					$pb['h'] += $adjustmenty;
					$n = count($this->patterns) + 1;
					list($orig_w, $orig_h, $x_repeat, $y_repeat) = $this->_resizeBackgroundImage($pb['orig_w'], $pb['orig_h'], $pb['w'], $pb['h'], $pb['resize'], $pb['x_repeat'], $pb['y_repeat'], $pb['bpa'], $pb['size']);
					$this->patterns[$n] = array('x' => $pb['x'], 'y' => $pb['y'], 'w' => $pb['w'], 'h' => $pb['h'], 'pgh' => $this->h, 'image_id' => $pb['image_id'], 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $pb['x_pos'], 'y_pos' => $pb['y_pos'], 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'itype' => $pb['itype'], 'bpa' => $pb['bpa']);
					$x = $pb['x'] * _MPDFK;
					$y = ($this->h - $pb['y']) * _MPDFK;
					$w = $pb['w'] * _MPDFK;
					$h = -$pb['h'] * _MPDFK;
					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= $pb['clippath'] . "\n";
					}
					if ($this->writingHTMLfooter || $this->writingHTMLheader) { // Write each (tiles) image rather than use as a pattern
						$iw = $pb['orig_w'] / _MPDFK;
						$ih = $pb['orig_h'] / _MPDFK;

						$w = $pb['w'];
						$h = $pb['h'];
						$x0 = $pb['x'];
						$y0 = $pb['y'];

						if (isset($pb['bpa']) && $pb['bpa']) {
							$w = $pb['bpa']['w'];
							$h = $pb['bpa']['h'];
							$x0 = $pb['bpa']['x'];
							$y0 = $pb['bpa']['y'];
						}

						if (isset($pb['size']['w']) && $pb['size']['w']) {
							$size = $pb['size'];

							if ($size['w'] == 'contain') {
								// Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area.
								// Same as resize==3
								$ih = $ih * $pb['bpa']['w'] / $iw;
								$iw = $pb['bpa']['w'];
								if ($ih > $pb['bpa']['h']) {
									$iw = $iw * $pb['bpa']['h'] / $ih;
									$ih = $pb['bpa']['h'];
								}
							} elseif ($size['w'] == 'cover') {
								// Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area.
								$ih = $ih * $pb['bpa']['w'] / $iw;
								$iw = $pb['bpa']['w'];
								if ($ih < $pb['bpa']['h']) {
									$iw = $iw * $ih / $pb['bpa']['h'];
									$ih = $pb['bpa']['h'];
								}
							} else {
								if (stristr($size['w'], '%')) {
									$size['w'] += 0;
									$size['w'] /= 100;
									$size['w'] = ($pb['bpa']['w'] * $size['w']);
								}
								if (stristr($size['h'], '%')) {
									$size['h'] += 0;
									$size['h'] /= 100;
									$size['h'] = ($pb['bpa']['h'] * $size['h']);
								}
								if ($size['w'] == 'auto' && $size['h'] == 'auto') {
									$iw = $iw;
									$ih = $ih;
								} elseif ($size['w'] == 'auto' && $size['h'] != 'auto') {
									$iw = $iw * $size['h'] / $ih;
									$ih = $size['h'];
								} elseif ($size['w'] != 'auto' && $size['h'] == 'auto') {
									$ih = $ih * $size['w'] / $iw;
									$iw = $size['w'];
								} else {
									$iw = $size['w'];
									$ih = $size['h'];
								}
							}
						}

						// Number to repeat
						if ($pb['x_repeat']) {
							$nx = ceil($pb['w'] / $iw) + 1;
						} else {
							$nx = 1;
						}
						if ($pb['y_repeat']) {
							$ny = ceil($pb['h'] / $ih) + 1;
						} else {
							$ny = 1;
						}

						$x_pos = $pb['x_pos'];
						if (stristr($x_pos, '%')) {
							$x_pos += 0;
							$x_pos /= 100;
							$x_pos = ($pb['bpa']['w'] * $x_pos) - ($iw * $x_pos);
						}
						$y_pos = $pb['y_pos'];
						if (stristr($y_pos, '%')) {
							$y_pos += 0;
							$y_pos /= 100;
							$y_pos = ($pb['bpa']['h'] * $y_pos) - ($ih * $y_pos);
						}
						if ($nx > 1) {
							while ($x_pos > ($pb['x'] - $pb['bpa']['x'])) {
								$x_pos -= $iw;
							}
						}
						if ($ny > 1) {
							while ($y_pos > ($pb['y'] - $pb['bpa']['y'])) {
								$y_pos -= $ih;
							}
						}
						for ($xi = 0; $xi < $nx; $xi++) {
							for ($yi = 0; $yi < $ny; $yi++) {
								$x = $x0 + $x_pos + ($iw * $xi);
								$y = $y0 + $y_pos + ($ih * $yi);
								if ($pb['opacity'] > 0 && $pb['opacity'] < 1) {
									$opac = $this->SetAlpha($pb['opacity'], 'Normal', true);
								} else {
									$opac = '';
								}
								$s .= sprintf("q %s %.3F 0 0 %.3F %.3F %.3F cm /I%d Do Q", $opac, $iw * _MPDFK, $ih * _MPDFK, $x * _MPDFK, ($this->h - ($y + $ih)) * _MPDFK, $pb['image_id']) . "\n";
							}
						}
					} else {
						if (($pb['opacity'] > 0 || $pb['opacity'] === '0') && $pb['opacity'] < 1) {
							$opac = $this->SetAlpha($pb['opacity'], 'Normal', true);
						} else {
							$opac = '';
						}
						$s .= sprintf('q /Pattern cs /P%d scn %s %.3F %.3F %.3F %.3F re f Q', $n, $opac, $x, $y, $w, $h) . "\n";
					}
					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= 'Q' . "\n";
					}
				}
				if ((isset($pb['gradient']) && $pb['gradient']) || (isset($pb['image_id']) && $pb['image_id'])) {
					if ($pb['visibility'] != 'visible')
						$s .= 'EMC' . "\n";

					if ($pb['z-index'] > 0) {
						$s .= "\n" . 'EMCGZ-index' . "\n";
						$this->current_layer = 0;
					}
				}
			}
			/* -- END BACKGROUNDS -- */
		}
		return $s;
	}

	function PrintTableBackgrounds($adjustmenty = 0)
	{
		$s = '';
		/* -- BACKGROUNDS -- */
		ksort($this->tableBackgrounds);
		foreach ($this->tableBackgrounds AS $bl => $pbs) {
			foreach ($pbs AS $pb) {
				if ((!isset($pb['gradient']) || !$pb['gradient']) && (!isset($pb['image_id']) || !$pb['image_id'])) {
					$s .= 'q ' . $this->SetFColor($pb['col'], true) . "\n";
					if ($pb['col']{0} == 5) { // RGBa
						$s .= $this->SetAlpha(ord($pb['col']{4}) / 100, 'Normal', true, 'F') . "\n";
					} elseif ($pb['col']{0} == 6) { // CMYKa
						$s .= $this->SetAlpha(ord($pb['col']{5}) / 100, 'Normal', true, 'F') . "\n";
					}
					$s .= sprintf('%.3F %.3F %.3F %.3F re %s Q', $pb['x'] * _MPDFK, ($this->h - $pb['y']) * _MPDFK, $pb['w'] * _MPDFK, -$pb['h'] * _MPDFK, 'f') . "\n";
				}
				if (isset($pb['gradient']) && $pb['gradient']) {
					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= $pb['clippath'] . "\n";
					}
					$s .= $this->grad->Gradient($pb['x'], $pb['y'], $pb['w'], $pb['h'], $pb['gradtype'], $pb['stops'], $pb['colorspace'], $pb['coords'], $pb['extend'], true);
					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= 'Q' . "\n";
					}
				}
				if (isset($pb['image_id']) && $pb['image_id']) { // Background pattern
					$pb['y'] -= $adjustmenty;
					$pb['h'] += $adjustmenty;
					$n = count($this->patterns) + 1;
					list($orig_w, $orig_h, $x_repeat, $y_repeat) = $this->_resizeBackgroundImage($pb['orig_w'], $pb['orig_h'], $pb['w'], $pb['h'], $pb['resize'], $pb['x_repeat'], $pb['y_repeat']);
					$this->patterns[$n] = array('x' => $pb['x'], 'y' => $pb['y'], 'w' => $pb['w'], 'h' => $pb['h'], 'pgh' => $this->h, 'image_id' => $pb['image_id'], 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $pb['x_pos'], 'y_pos' => $pb['y_pos'], 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'itype' => $pb['itype']);
					$x = $pb['x'] * _MPDFK;
					$y = ($this->h - $pb['y']) * _MPDFK;
					$w = $pb['w'] * _MPDFK;
					$h = -$pb['h'] * _MPDFK;

					// mPDF 5.7.3
					if (($this->writingHTMLfooter || $this->writingHTMLheader) && (!isset($pb['clippath']) || $pb['clippath'] == '')) {
						// Set clipping path
						$pb['clippath'] = sprintf(' q 0 w %.3F %.3F m %.3F %.3F l %.3F %.3F l %.3F %.3F l %.3F %.3F l W n ', $x, $y, $x, $y + $h, $x + $w, $y + $h, $x + $w, $y, $x, $y);
					}

					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= $pb['clippath'] . "\n";
					}

					// mPDF 5.7.3
					if ($this->writingHTMLfooter || $this->writingHTMLheader) { // Write each (tiles) image rather than use as a pattern
						$iw = $pb['orig_w'] / _MPDFK;
						$ih = $pb['orig_h'] / _MPDFK;

						$w = $pb['w'];
						$h = $pb['h'];
						$x0 = $pb['x'];
						$y0 = $pb['y'];

						if (isset($pb['bpa']) && $pb['bpa']) {
							$w = $pb['bpa']['w'];
							$h = $pb['bpa']['h'];
							$x0 = $pb['bpa']['x'];
							$y0 = $pb['bpa']['y'];
						}
						// At present 'bpa' (background page area) is not set for tablebackgrounds - only pagebackgrounds
						// For now, just set it as:
						else {
							$pb['bpa'] = array('x' => $x0, 'y' => $y0, 'w' => $w, 'h' => $h);
						}

						if (isset($pb['size']['w']) && $pb['size']['w']) {
							$size = $pb['size'];

							if ($size['w'] == 'contain') {
								// Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area.
								// Same as resize==3
								$ih = $ih * $pb['bpa']['w'] / $iw;
								$iw = $pb['bpa']['w'];
								if ($ih > $pb['bpa']['h']) {
									$iw = $iw * $pb['bpa']['h'] / $ih;
									$ih = $pb['bpa']['h'];
								}
							} elseif ($size['w'] == 'cover') {
								// Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area.
								$ih = $ih * $pb['bpa']['w'] / $iw;
								$iw = $pb['bpa']['w'];
								if ($ih < $pb['bpa']['h']) {
									$iw = $iw * $ih / $pb['bpa']['h'];
									$ih = $pb['bpa']['h'];
								}
							} else {
								if (stristr($size['w'], '%')) {
									$size['w'] += 0;
									$size['w'] /= 100;
									$size['w'] = ($pb['bpa']['w'] * $size['w']);
								}
								if (stristr($size['h'], '%')) {
									$size['h'] += 0;
									$size['h'] /= 100;
									$size['h'] = ($pb['bpa']['h'] * $size['h']);
								}
								if ($size['w'] == 'auto' && $size['h'] == 'auto') {
									$iw = $iw;
									$ih = $ih;
								} elseif ($size['w'] == 'auto' && $size['h'] != 'auto') {
									$iw = $iw * $size['h'] / $ih;
									$ih = $size['h'];
								} elseif ($size['w'] != 'auto' && $size['h'] == 'auto') {
									$ih = $ih * $size['w'] / $iw;
									$iw = $size['w'];
								} else {
									$iw = $size['w'];
									$ih = $size['h'];
								}
							}
						}

						// Number to repeat
						if (isset($pb['x_repeat']) && $pb['x_repeat']) {
							$nx = ceil($pb['w'] / $iw) + 1;
						} else {
							$nx = 1;
						}
						if (isset($pb['y_repeat']) && $pb['y_repeat']) {
							$ny = ceil($pb['h'] / $ih) + 1;
						} else {
							$ny = 1;
						}

						$x_pos = $pb['x_pos'];
						if (stristr($x_pos, '%')) {
							$x_pos += 0;
							$x_pos /= 100;
							$x_pos = ($pb['bpa']['w'] * $x_pos) - ($iw * $x_pos);
						}
						$y_pos = $pb['y_pos'];
						if (stristr($y_pos, '%')) {
							$y_pos += 0;
							$y_pos /= 100;
							$y_pos = ($pb['bpa']['h'] * $y_pos) - ($ih * $y_pos);
						}
						if ($nx > 1) {
							while ($x_pos > ($pb['x'] - $pb['bpa']['x'])) {
								$x_pos -= $iw;
							}
						}
						if ($ny > 1) {
							while ($y_pos > ($pb['y'] - $pb['bpa']['y'])) {
								$y_pos -= $ih;
							}
						}
						for ($xi = 0; $xi < $nx; $xi++) {
							for ($yi = 0; $yi < $ny; $yi++) {
								$x = $x0 + $x_pos + ($iw * $xi);
								$y = $y0 + $y_pos + ($ih * $yi);
								if ($pb['opacity'] > 0 && $pb['opacity'] < 1) {
									$opac = $this->SetAlpha($pb['opacity'], 'Normal', true);
								} else {
									$opac = '';
								}
								$s .= sprintf("q %s %.3F 0 0 %.3F %.3F %.3F cm /I%d Do Q", $opac, $iw * _MPDFK, $ih * _MPDFK, $x * _MPDFK, ($this->h - ($y + $ih)) * _MPDFK, $pb['image_id']) . "\n";
							}
						}
					} else {
						if (($pb['opacity'] > 0 || $pb['opacity'] === '0') && $pb['opacity'] < 1) {
							$opac = $this->SetAlpha($pb['opacity'], 'Normal', true);
						} else {
							$opac = '';
						}
						$s .= sprintf('q /Pattern cs /P%d scn %s %.3F %.3F %.3F %.3F re f Q', $n, $opac, $x, $y, $w, $h) . "\n";
					}

					if (isset($pb['clippath']) && $pb['clippath']) {
						$s .= 'Q' . "\n";
					}
				}
			}
		}
		/* -- END BACKGROUNDS -- */
		return $s;
	}

	function BeginLayer($id)
	{
		if ($this->current_layer > 0)
			$this->EndLayer();
		if ($id < 1) {
			return false;
		}
		if (!isset($this->layers[$id])) {
			$this->layers[$id] = array('name' => 'Layer ' . ($id));
			if (($this->PDFA || $this->PDFX)) {
				$this->PDFAXwarnings[] = "Cannot use layers when using PDFA or PDFX";
				return '';
			} elseif (!$this->PDFA && !$this->PDFX) {
				$this->pdf_version = '1.5';
			}
		}
		$this->current_layer = $id;
		$this->_out('/OCZ-index /ZI' . $id . ' BDC');

		$this->pageoutput[$this->page] = array();
	}

	function EndLayer()
	{
		if ($this->current_layer > 0) {
			$this->_out('EMCZ-index');
			$this->current_layer = 0;
		}
	}

	function AddPageByArray($a)
	{
		if (!is_array($a)) {
			$a = array();
		}
		$orientation = (isset($a['orientation']) ? $a['orientation'] : '');
		$condition = (isset($a['condition']) ? $a['condition'] : (isset($a['type']) ? $a['type'] : ''));
		$resetpagenum = (isset($a['resetpagenum']) ? $a['resetpagenum'] : '');
		$pagenumstyle = (isset($a['pagenumstyle']) ? $a['pagenumstyle'] : '');
		$suppress = (isset($a['suppress']) ? $a['suppress'] : '');
		$mgl = (isset($a['mgl']) ? $a['mgl'] : (isset($a['margin-left']) ? $a['margin-left'] : ''));
		$mgr = (isset($a['mgr']) ? $a['mgr'] : (isset($a['margin-right']) ? $a['margin-right'] : ''));
		$mgt = (isset($a['mgt']) ? $a['mgt'] : (isset($a['margin-top']) ? $a['margin-top'] : ''));
		$mgb = (isset($a['mgb']) ? $a['mgb'] : (isset($a['margin-bottom']) ? $a['margin-bottom'] : ''));
		$mgh = (isset($a['mgh']) ? $a['mgh'] : (isset($a['margin-header']) ? $a['margin-header'] : ''));
		$mgf = (isset($a['mgf']) ? $a['mgf'] : (isset($a['margin-footer']) ? $a['margin-footer'] : ''));
		$ohname = (isset($a['ohname']) ? $a['ohname'] : (isset($a['odd-header-name']) ? $a['odd-header-name'] : ''));
		$ehname = (isset($a['ehname']) ? $a['ehname'] : (isset($a['even-header-name']) ? $a['even-header-name'] : ''));
		$ofname = (isset($a['ofname']) ? $a['ofname'] : (isset($a['odd-footer-name']) ? $a['odd-footer-name'] : ''));
		$efname = (isset($a['efname']) ? $a['efname'] : (isset($a['even-footer-name']) ? $a['even-footer-name'] : ''));
		$ohvalue = (isset($a['ohvalue']) ? $a['ohvalue'] : (isset($a['odd-header-value']) ? $a['odd-header-value'] : 0));
		$ehvalue = (isset($a['ehvalue']) ? $a['ehvalue'] : (isset($a['even-header-value']) ? $a['even-header-value'] : 0));
		$ofvalue = (isset($a['ofvalue']) ? $a['ofvalue'] : (isset($a['odd-footer-value']) ? $a['odd-footer-value'] : 0));
		$efvalue = (isset($a['efvalue']) ? $a['efvalue'] : (isset($a['even-footer-value']) ? $a['even-footer-value'] : 0));
		$pagesel = (isset($a['pagesel']) ? $a['pagesel'] : (isset($a['pageselector']) ? $a['pageselector'] : ''));
		$newformat = (isset($a['newformat']) ? $a['newformat'] : (isset($a['sheet-size']) ? $a['sheet-size'] : ''));

		$this->AddPage($orientation, $condition, $resetpagenum, $pagenumstyle, $suppress, $mgl, $mgr, $mgt, $mgb, $mgh, $mgf, $ohname, $ehname, $ofname, $efname, $ohvalue, $ehvalue, $ofvalue, $efvalue, $pagesel, $newformat);
	}

	// mPDF 6 pagebreaktype
	function _preForcedPagebreak($pagebreaktype)
	{
		if ($pagebreaktype == 'cloneall') {
			// Close any open block tags
			$arr = array();
			$ai = 0;
			for ($b = $this->blklvl; $b > 0; $b--) {
				$this->tag->CloseTag($this->blk[$b]['tag'], $arr, $ai);
			}
			if ($this->blklvl == 0 && !empty($this->textbuffer)) { //Output previously buffered content
				$this->printbuffer($this->textbuffer, 1);
				$this->textbuffer = array();
			}
		} elseif ($pagebreaktype == 'clonebycss') {
			// Close open block tags whilst box-decoration-break==clone
			$arr = array();
			$ai = 0;
			for ($b = $this->blklvl; $b > 0; $b--) {
				if (isset($this->blk[$b]['box_decoration_break']) && $this->blk[$b]['box_decoration_break'] == 'clone') {
					$this->tag->CloseTag($this->blk[$b]['tag'], $arr, $ai);
				} else {
					if ($b == $this->blklvl && !empty($this->textbuffer)) { //Output previously buffered content
						$this->printbuffer($this->textbuffer, 1);
						$this->textbuffer = array();
					}
					break;
				}
			}
		} elseif (!empty($this->textbuffer)) { //Output previously buffered content
			$this->printbuffer($this->textbuffer, 1);
			$this->textbuffer = array();
		}
	}

	// mPDF 6 pagebreaktype
	function _postForcedPagebreak($pagebreaktype, $startpage, $save_blk, $save_blklvl)
	{
		if ($pagebreaktype == 'cloneall') {
			$this->blk = array();
			$this->blk[0] = $save_blk[0];
			// Re-open block tags
			$this->blklvl = 0;
			$arr = array();
			$i = 0;
			for ($b = 1; $b <= $save_blklvl; $b++) {
				$this->tag->OpenTag($save_blk[$b]['tag'], $save_blk[$b]['attr'], $arr, $i);
			}
		} elseif ($pagebreaktype == 'clonebycss') {
			$this->blk = array();
			$this->blk[0] = $save_blk[0];
			// Don't re-open tags for lowest level elements - so need to do some adjustments
			for ($b = 1; $b <= $this->blklvl; $b++) {
				$this->blk[$b] = $save_blk[$b];
				$this->blk[$b]['startpage'] = 0;
				$this->blk[$b]['y0'] = $this->y; // ?? $this->tMargin
				if (($this->page - $startpage) % 2) {
					if (isset($this->blk[$b]['x0'])) {
						$this->blk[$b]['x0'] += $this->MarginCorrection;
					} else {
						$this->blk[$b]['x0'] = $this->MarginCorrection;
					}
				}
				//for Float DIV
				$this->blk[$b]['marginCorrected'][$this->page] = true;
			}

			// Re-open block tags for any that have box_decoration_break==clone
			$arr = array();
			$i = 0;
			for ($b = $this->blklvl + 1; $b <= $save_blklvl; $b++) {
				if ($b < $this->blklvl) {
					$this->lastblocklevelchange = -1;
				}
				$this->tag->OpenTag($save_blk[$b]['tag'], $save_blk[$b]['attr'], $arr, $i);
			}
			if ($this->blk[$this->blklvl]['box_decoration_break'] != 'clone') {
				$this->lastblocklevelchange = -1;
			}
		} else {
			$this->lastblocklevelchange = -1;
		}
	}

	function AddPage($orientation = '', $condition = '', $resetpagenum = '', $pagenumstyle = '', $suppress = '', $mgl = '', $mgr = '', $mgt = '', $mgb = '', $mgh = '', $mgf = '', $ohname = '', $ehname = '', $ofname = '', $efname = '', $ohvalue = 0, $ehvalue = 0, $ofvalue = 0, $efvalue = 0, $pagesel = '', $newformat = '')
	{

		/* -- CSS-FLOAT -- */
		// Float DIV
		// Cannot do with columns on, or if any change in page orientation/margins etc.
		// If next page already exists - i.e background /headers and footers already written
		if ($this->state > 0 && $this->page < count($this->pages)) {
			$bak_cml = $this->cMarginL;
			$bak_cmr = $this->cMarginR;
			$bak_dw = $this->divwidth;
			// Paint Div Border if necessary
			if ($this->blklvl > 0) {
				$save_tr = $this->table_rotate; // *TABLES*
				$this->table_rotate = 0; // *TABLES*
				if ($this->y == $this->blk[$this->blklvl]['y0']) {
					$this->blk[$this->blklvl]['startpage'] ++;
				}
				if (($this->y > $this->blk[$this->blklvl]['y0']) || $this->flowingBlockAttr['is_table']) {
					$toplvl = $this->blklvl;
				} else {
					$toplvl = $this->blklvl - 1;
				}
				$sy = $this->y;
				for ($bl = 1; $bl <= $toplvl; $bl++) {
					$this->PaintDivBB('pagebottom', 0, $bl);
				}
				$this->y = $sy;
				$this->table_rotate = $save_tr; // *TABLES*
			}
			$s = $this->PrintPageBackgrounds();

			// Writes after the marker so not overwritten later by page background etc.
			$this->pages[$this->page] = preg_replace('/(___BACKGROUND___PATTERNS' . $this->uniqstr . ')/', '\\1' . "\n" . $s . "\n", $this->pages[$this->page]);
			$this->pageBackgrounds = array();
			$family = $this->FontFamily;
			$style = $this->FontStyle;
			$size = $this->FontSizePt;
			$lw = $this->LineWidth;
			$dc = $this->DrawColor;
			$fc = $this->FillColor;
			$tc = $this->TextColor;
			$cf = $this->ColorFlag;

			$this->printfloatbuffer();

			//Move to next page
			$this->page++;
			$this->ResetMargins();
			$this->SetAutoPageBreak($this->autoPageBreak, $this->bMargin);
			$this->x = $this->lMargin;
			$this->y = $this->tMargin;
			$this->FontFamily = '';
			$this->_out('2 J');
			$this->LineWidth = $lw;
			$this->_out(sprintf('%.3F w', $lw * _MPDFK));
			if ($family)
				$this->SetFont($family, $style, $size, true, true);
			$this->DrawColor = $dc;
			if ($dc != $this->defDrawColor)
				$this->_out($dc);
			$this->FillColor = $fc;
			if ($fc != $this->defFillColor)
				$this->_out($fc);
			$this->TextColor = $tc;
			$this->ColorFlag = $cf;
			for ($bl = 1; $bl <= $this->blklvl; $bl++) {
				$this->blk[$bl]['y0'] = $this->y;
				// Don't correct more than once for background DIV containing a Float
				if (!isset($this->blk[$bl]['marginCorrected'][$this->page])) {
					$this->blk[$bl]['x0'] += $this->MarginCorrection;
				}
				$this->blk[$bl]['marginCorrected'][$this->page] = true;
			}
			$this->cMarginL = $bak_cml;
			$this->cMarginR = $bak_cmr;
			$this->divwidth = $bak_dw;
			return '';
		}
		/* -- END CSS-FLOAT -- */

		//Start a new page
		if ($this->state == 0)
			$this->Open();

		$bak_cml = $this->cMarginL;
		$bak_cmr = $this->cMarginR;
		$bak_dw = $this->divwidth;


		$bak_lh = $this->lineheight;

		$orientation = substr(strtoupper($orientation), 0, 1);
		$condition = strtoupper($condition);


		if ($condition == 'E') { // only adds new page if needed to create an Even page
			if (!$this->mirrorMargins || ($this->page) % 2 == 0) {
				return false;
			}
		} elseif ($condition == 'O') { // only adds new page if needed to create an Odd page
			if (!$this->mirrorMargins || ($this->page) % 2 == 1) {
				return false;
			}
		} elseif ($condition == 'NEXT-EVEN') { // always adds at least one new page to create an Even page
			if (!$this->mirrorMargins) {
				$condition = '';
			} else {
				if ($pagesel) {
					$pbch = $pagesel;
					$pagesel = '';
				} // *CSS-PAGE*
				else {
					$pbch = false;
				} // *CSS-PAGE*
				$this->AddPage($this->CurOrientation, 'O');
				$this->extrapagebreak = true; // mPDF 6 pagebreaktype
				if ($pbch) {
					$pagesel = $pbch;
				} // *CSS-PAGE*
				$condition = '';
			}
		} elseif ($condition == 'NEXT-ODD') { // always adds at least one new page to create an Odd page
			if (!$this->mirrorMargins) {
				$condition = '';
			} else {
				if ($pagesel) {
					$pbch = $pagesel;
					$pagesel = '';
				} // *CSS-PAGE*
				else {
					$pbch = false;
				} // *CSS-PAGE*
				$this->AddPage($this->CurOrientation, 'E');
				$this->extrapagebreak = true; // mPDF 6 pagebreaktype
				if ($pbch) {
					$pagesel = $pbch;
				} // *CSS-PAGE*
				$condition = '';
			}
		}


		if ($resetpagenum || $pagenumstyle || $suppress) {
			$this->PageNumSubstitutions[] = array('from' => ($this->page + 1), 'reset' => $resetpagenum, 'type' => $pagenumstyle, 'suppress' => $suppress);
		}


		$save_tr = $this->table_rotate; // *TABLES*
		$this->table_rotate = 0; // *TABLES*
		$save_kwt = $this->kwt;
		$this->kwt = 0;
		$save_layer = $this->current_layer;
		$save_vis = $this->visibility;

		if ($this->visibility != 'visible')
			$this->SetVisibility('visible');
		$this->EndLayer();

		// Paint Div Border if necessary
		//PAINTS BACKGROUND COLOUR OR BORDERS for DIV - DISABLED FOR COLUMNS (cf. AcceptPageBreak) AT PRESENT in ->PaintDivBB
		if (!$this->ColActive && $this->blklvl > 0) {
			if (isset($this->blk[$this->blklvl]['y0']) && $this->y == $this->blk[$this->blklvl]['y0'] && !$this->extrapagebreak) { // mPDF 6 pagebreaktype
				if (isset($this->blk[$this->blklvl]['startpage'])) {
					$this->blk[$this->blklvl]['startpage'] ++;
				} else {
					$this->blk[$this->blklvl]['startpage'] = 1;
				}
			}
			if ((isset($this->blk[$this->blklvl]['y0']) && $this->y > $this->blk[$this->blklvl]['y0']) || $this->flowingBlockAttr['is_table'] || $this->extrapagebreak) {
				$toplvl = $this->blklvl;
			} // mPDF 6 pagebreaktype
			else {
				$toplvl = $this->blklvl - 1;
			}
			$sy = $this->y;
			for ($bl = 1; $bl <= $toplvl; $bl++) {

				if (isset($this->blk[$bl]['z-index']) && $this->blk[$bl]['z-index'] > 0) {
					$this->BeginLayer($this->blk[$bl]['z-index']);
				}
				if (isset($this->blk[$bl]['visibility']) && $this->blk[$bl]['visibility'] && $this->blk[$bl]['visibility'] != 'visible') {
					$this->SetVisibility($this->blk[$bl]['visibility']);
				}
				$this->PaintDivBB('pagebottom', 0, $bl);
			}
			$this->y = $sy;
			// RESET block y0 and x0 - see below
		}
		$this->extrapagebreak = false; // mPDF 6 pagebreaktype

		if ($this->visibility != 'visible')
			$this->SetVisibility('visible');
		$this->EndLayer();

		// BODY Backgrounds
		if ($this->page > 0) {
			$s = '';
			$s .= $this->PrintBodyBackgrounds();

			$s .= $this->PrintPageBackgrounds();
			$this->pages[$this->page] = preg_replace('/(___BACKGROUND___PATTERNS' . $this->uniqstr . ')/', "\n" . $s . "\n" . '\\1', $this->pages[$this->page]);
			$this->pageBackgrounds = array();
		}

		$save_kt = $this->keep_block_together;
		$this->keep_block_together = 0;

		$save_cols = false;
		/* -- COLUMNS -- */
		if ($this->ColActive) {
			$save_cols = true;
			$save_nbcol = $this->NbCol; // other values of gap and vAlign will not change by setting Columns off
			$this->SetColumns(0);
		}
		/* -- END COLUMNS -- */


		$family = $this->FontFamily;
		$style = $this->FontStyle;
		$size = $this->FontSizePt;
		$this->ColumnAdjust = true; // enables column height adjustment for the page
		$lw = $this->LineWidth;
		$dc = $this->DrawColor;
		$fc = $this->FillColor;
		$tc = $this->TextColor;
		$cf = $this->ColorFlag;
		if ($this->page > 0) {
			//Page footer
	// ITS4YOU MaJu
		//Page footer
		//$this->InFooter=true;

		//$this->Reset();
		//$this->pageoutput[$this->page] = array();

		//$this->Footer();
        if($this->page == 1){
            if($this->PDFMakerDispFooter["df_first"] !== false) {
        		//Page footer
        		$this->InFooter=true;

        		$this->Reset();
        		$this->pageoutput[$this->page] = array();

        		$this->Footer();
    		}
		} else {
            if($this->PDFMakerDispFooter["df_other"] !== false) {
        		//Page footer
        		$this->InFooter=true;

        		$this->Reset();
        		$this->pageoutput[$this->page] = array();

        		$this->Footer();
    		}
        }
		// ITS4YOU-END
			//Close page
			$this->_endpage();
		}


		//Start new page
		$this->_beginpage($orientation, $mgl, $mgr, $mgt, $mgb, $mgh, $mgf, $ohname, $ehname, $ofname, $efname, $ohvalue, $ehvalue, $ofvalue, $efvalue, $pagesel, $newformat);
		if ($this->docTemplate) {
			$pagecount = $this->SetSourceFile($this->docTemplate);
			if (($this->page - $this->docTemplateStart) > $pagecount) {
				if ($this->docTemplateContinue) {
					$tplIdx = $this->ImportPage($pagecount);
					$this->UseTemplate($tplIdx);
				}
			} else {
				$tplIdx = $this->ImportPage(($this->page - $this->docTemplateStart));
				$this->UseTemplate($tplIdx);
			}
		}
		if ($this->pageTemplate) {
			$this->UseTemplate($this->pageTemplate);
		}

		// Tiling Patterns
		$this->_out('___PAGE___START' . $this->uniqstr);
		$this->_out('___BACKGROUND___PATTERNS' . $this->uniqstr);
		$this->_out('___HEADER___MARKER' . $this->uniqstr);
		$this->pageBackgrounds = array();

		//Set line cap style to square
		$this->SetLineCap(2);
		//Set line width
		$this->LineWidth = $lw;
		$this->_out(sprintf('%.3F w', $lw * _MPDFK));
		//Set font
		if ($family)
			$this->SetFont($family, $style, $size, true, true); // forces write

		//Set colors
		$this->DrawColor = $dc;
		if ($dc != $this->defDrawColor)
			$this->_out($dc);
		$this->FillColor = $fc;
		if ($fc != $this->defFillColor)
			$this->_out($fc);
		$this->TextColor = $tc;
		$this->ColorFlag = $cf;

		//Page header
	// ITS4YOU VlZa
	//$this->Header();
    if($this->page == 1)
    {
        if($this->PDFMakerDispHeader["dh_first"] !== false)
            $this->Header();
    } else {
        if($this->PDFMakerDispHeader["dh_other"] !== false)
            $this->Header();
    }
	// ITS4YOU-END

		//Restore line width
		if ($this->LineWidth != $lw) {
			$this->LineWidth = $lw;
			$this->_out(sprintf('%.3F w', $lw * _MPDFK));
		}
		//Restore font
		if ($family)
			$this->SetFont($family, $style, $size, true, true); // forces write

		//Restore colors
		if ($this->DrawColor != $dc) {
			$this->DrawColor = $dc;
			$this->_out($dc);
		}
		if ($this->FillColor != $fc) {
			$this->FillColor = $fc;
			$this->_out($fc);
		}
		$this->TextColor = $tc;
		$this->ColorFlag = $cf;
		$this->InFooter = false;

		if ($save_layer > 0)
			$this->BeginLayer($save_layer);

		if ($save_vis != 'visible')
			$this->SetVisibility($save_vis);

		/* -- COLUMNS -- */
		if ($save_cols) {
			// Restore columns
			$this->SetColumns($save_nbcol, $this->colvAlign, $this->ColGap);
		}
		if ($this->ColActive) {
			$this->SetCol(0);
		}
		/* -- END COLUMNS -- */


		//RESET BLOCK BORDER TOP
		if (!$this->ColActive) {
			for ($bl = 1; $bl <= $this->blklvl; $bl++) {
				$this->blk[$bl]['y0'] = $this->y;
				if (isset($this->blk[$bl]['x0'])) {
					$this->blk[$bl]['x0'] += $this->MarginCorrection;
				} else {
					$this->blk[$bl]['x0'] = $this->MarginCorrection;
				}
				// Added mPDF 3.0 Float DIV
				$this->blk[$bl]['marginCorrected'][$this->page] = true;
			}
		}


		$this->table_rotate = $save_tr; // *TABLES*
		$this->kwt = $save_kwt;

		$this->keep_block_together = $save_kt;

		$this->cMarginL = $bak_cml;
		$this->cMarginR = $bak_cmr;
		$this->divwidth = $bak_dw;

		$this->lineheight = $bak_lh;
	}

	function PageNo()
	{
		//Get current page number
		return $this->page;
	}

	function AddSpotColorsFromFile($file)
	{
		$colors = @file($file);
		if (!$colors) {
			throw new MpdfException("Cannot load spot colors file - " . $file);
		}
		foreach ($colors AS $sc) {
			list($name, $c, $m, $y, $k) = preg_split("/\t/", $sc);
			$c = intval($c);
			$m = intval($m);
			$y = intval($y);
			$k = intval($k);
			$this->AddSpotColor($name, $c, $m, $y, $k);
		}
	}

	function AddSpotColor($name, $c, $m, $y, $k)
	{
		$name = strtoupper(trim($name));
		if (!isset($this->spotColors[$name])) {
			$i = count($this->spotColors) + 1;
			$this->spotColors[$name] = array('i' => $i, 'c' => $c, 'm' => $m, 'y' => $y, 'k' => $k);
			$this->spotColorIDs[$i] = $name;
		}
	}

	function SetColor($col, $type = '')
	{
		$out = '';
		if (!$col) {
			return '';
		} // mPDF 6
		if ($col{0} == 3 || $col{0} == 5) { // RGB / RGBa
			$out = sprintf('%.3F %.3F %.3F rg', ord($col{1}) / 255, ord($col{2}) / 255, ord($col{3}) / 255);
		} elseif ($col{0} == 1) { // GRAYSCALE
			$out = sprintf('%.3F g', ord($col{1}) / 255);
		} elseif ($col{0} == 2) { // SPOT COLOR
			$out = sprintf('/CS%d cs %.3F scn', ord($col{1}), ord($col{2}) / 100);
		} elseif ($col{0} == 4 || $col{0} == 6) { // CMYK / CMYKa
			$out = sprintf('%.3F %.3F %.3F %.3F k', ord($col{1}) / 100, ord($col{2}) / 100, ord($col{3}) / 100, ord($col{4}) / 100);
		}
		if ($type == 'Draw') {
			$out = strtoupper($out);
		} // e.g. rg => RG
		elseif ($type == 'CodeOnly') {
			$out = preg_replace('/\s(rg|g|k)/', '', $out);
		}
		return $out;
	}

	function SetDColor($col, $return = false)
	{
		$out = $this->SetColor($col, 'Draw');
		if ($return) {
			return $out;
		}
		if ($out == '') {
			return '';
		}
		$this->DrawColor = $out;
		if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['DrawColor']) && $this->pageoutput[$this->page]['DrawColor'] != $this->DrawColor) || !isset($this->pageoutput[$this->page]['DrawColor']))) {
			$this->_out($this->DrawColor);
		}
		$this->pageoutput[$this->page]['DrawColor'] = $this->DrawColor;
	}

	function SetFColor($col, $return = false)
	{
		$out = $this->SetColor($col, 'Fill');
		if ($return) {
			return $out;
		}
		if ($out == '') {
			return '';
		}
		$this->FillColor = $out;
		$this->ColorFlag = ($out != $this->TextColor);
		if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['FillColor']) && $this->pageoutput[$this->page]['FillColor'] != $this->FillColor) || !isset($this->pageoutput[$this->page]['FillColor']))) {
			$this->_out($this->FillColor);
		}
		$this->pageoutput[$this->page]['FillColor'] = $this->FillColor;
	}

	function SetTColor($col, $return = false)
	{
		$out = $this->SetColor($col, 'Text');
		if ($return) {
			return $out;
		}
		if ($out == '') {
			return '';
		}
		$this->TextColor = $out;
		$this->ColorFlag = ($this->FillColor != $out);
	}

	function SetDrawColor($r, $g = -1, $b = -1, $col4 = -1, $return = false)
	{
		//Set color for all stroking operations
		$col = array();
		if (($r == 0 and $g == 0 and $b == 0 && $col4 == -1) or $g == -1) {
			$col = $this->ConvertColor($r);
		} elseif ($col4 == -1) {
			$col = $this->ConvertColor('rgb(' . $r . ',' . $g . ',' . $b . ')');
		} else {
			$col = $this->ConvertColor('cmyk(' . $r . ',' . $g . ',' . $b . ',' . $col4 . ')');
		}
		$out = $this->SetDColor($col, $return);
		return $out;
	}

	function SetFillColor($r, $g = -1, $b = -1, $col4 = -1, $return = false)
	{
		//Set color for all filling operations
		$col = array();
		if (($r == 0 and $g == 0 and $b == 0 && $col4 == -1) or $g == -1) {
			$col = $this->ConvertColor($r);
		} elseif ($col4 == -1) {
			$col = $this->ConvertColor('rgb(' . $r . ',' . $g . ',' . $b . ')');
		} else {
			$col = $this->ConvertColor('cmyk(' . $r . ',' . $g . ',' . $b . ',' . $col4 . ')');
		}
		$out = $this->SetFColor($col, $return);
		return $out;
	}

	function SetTextColor($r, $g = -1, $b = -1, $col4 = -1, $return = false)
	{
		//Set color for text
		$col = array();
		if (($r == 0 and $g == 0 and $b == 0 && $col4 == -1) or $g == -1) {
			$col = $this->ConvertColor($r);
		} elseif ($col4 == -1) {
			$col = $this->ConvertColor('rgb(' . $r . ',' . $g . ',' . $b . ')');
		} else {
			$col = $this->ConvertColor('cmyk(' . $r . ',' . $g . ',' . $b . ',' . $col4 . ')');
		}
		$out = $this->SetTColor($col, $return);
		return $out;
	}

	function _getCharWidth(&$cw, $u, $isdef = true)
	{
		$w = 0;
		if ($u == 0) {
			$w = false;
		} elseif (isset($cw[$u * 2 + 1])) {
			$w = (ord($cw[$u * 2]) << 8) + ord($cw[$u * 2 + 1]);
		}
		if ($w == 65535) {
			return 0;
		} elseif ($w) {
			return $w;
		} elseif ($isdef) {
			return false;
		} else {
			return 0;
		}
	}

	function _charDefined(&$cw, $u)
	{
		$w = 0;
		if ($u == 0) {
			return false;
		}
		if (isset($cw[$u * 2 + 1])) {
			$w = (ord($cw[$u * 2]) << 8) + ord($cw[$u * 2 + 1]);
		}
		if ($w) {
			return true;
		} else {
			return false;
		}
	}

	function GetCharWidthCore($c)
	{
		//Get width of a single character in the current Core font
		$c = (string) $c;
		$w = 0;
		// Soft Hyphens chr(173)
		if ($c == chr(173) && $this->FontFamily != 'csymbol' && $this->FontFamily != 'czapfdingbats') {
			return 0;
		} elseif (($this->textvar & FC_SMALLCAPS) && isset($this->upperCase[ord($c)])) {  // mPDF 5.7.1
			$charw = $this->CurrentFont['cw'][chr($this->upperCase[ord($c)])];
			if ($charw !== false) {
				$charw = $charw * $this->smCapsScale * $this->smCapsStretch / 100;
				$w+=$charw;
			}
		} elseif (isset($this->CurrentFont['cw'][$c])) {
			$w += $this->CurrentFont['cw'][$c];
		} elseif (isset($this->CurrentFont['cw'][ord($c)])) {
			$w += $this->CurrentFont['cw'][ord($c)];
		}
		$w *= ($this->FontSize / 1000);
		if ($this->minwSpacing || $this->fixedlSpacing) {
			if ($c == ' ')
				$nb_spaces = 1;
			else
				$nb_spaces = 0;
			$w += $this->fixedlSpacing + ($nb_spaces * $this->minwSpacing);
		}
		return ($w);
	}

	function GetCharWidthNonCore($c, $addSubset = true)
	{
		//Get width of a single character in the current Non-Core font
		$c = (string) $c;
		$w = 0;
		$unicode = $this->UTF8StringToArray($c, $addSubset);
		$char = $unicode[0];
		/* -- CJK-FONTS -- */
		if ($this->CurrentFont['type'] == 'Type0') { // CJK Adobe fonts
			if ($char == 173) {
				return 0;
			} // Soft Hyphens
			elseif (isset($this->CurrentFont['cw'][$char])) {
				$w+=$this->CurrentFont['cw'][$char];
			} elseif (isset($this->CurrentFont['MissingWidth'])) {
				$w += $this->CurrentFont['MissingWidth'];
			} else {
				$w += 500;
			}
		} else {
			/* -- END CJK-FONTS -- */
			if ($char == 173) {
				return 0;
			} // Soft Hyphens
			elseif (($this->textvar & FC_SMALLCAPS) && isset($this->upperCase[$char])) { // mPDF 5.7.1
				$charw = $this->_getCharWidth($this->CurrentFont['cw'], $this->upperCase[$char]);
				if ($charw !== false) {
					$charw = $charw * $this->smCapsScale * $this->smCapsStretch / 100;
					$w+=$charw;
				} elseif (isset($this->CurrentFont['desc']['MissingWidth'])) {
					$w += $this->CurrentFont['desc']['MissingWidth'];
				} elseif (isset($this->CurrentFont['MissingWidth'])) {
					$w += $this->CurrentFont['MissingWidth'];
				} else {
					$w += 500;
				}
			} else {
				$charw = $this->_getCharWidth($this->CurrentFont['cw'], $char);
				if ($charw !== false) {
					$w+=$charw;
				} elseif (isset($this->CurrentFont['desc']['MissingWidth'])) {
					$w += $this->CurrentFont['desc']['MissingWidth'];
				} elseif (isset($this->CurrentFont['MissingWidth'])) {
					$w += $this->CurrentFont['MissingWidth'];
				} else {
					$w += 500;
				}
			}
		} // *CJK-FONTS*
		$w *= ($this->FontSize / 1000);
		if ($this->minwSpacing || $this->fixedlSpacing) {
			if ($c == ' ')
				$nb_spaces = 1;
			else
				$nb_spaces = 0;
			$w += $this->fixedlSpacing + ($nb_spaces * $this->minwSpacing);
		}
		return ($w);
	}

	function GetCharWidth($c, $addSubset = true)
	{
		if (!$this->usingCoreFont) {
			return $this->GetCharWidthNonCore($c, $addSubset);
		} else {
			return $this->GetCharWidthCore($c);
		}
	}

	function GetStringWidth($s, $addSubset = true, $OTLdata = false, $textvar = 0, $includeKashida = false)
	{ // mPDF 5.7.1
		//Get width of a string in the current font
		$s = (string) $s;
		$cw = &$this->CurrentFont['cw'];
		$w = 0;
		$kerning = 0;
		$lastchar = 0;
		$nb_carac = 0;
		$nb_spaces = 0;
		$kashida = 0;
		// mPDF ITERATION
		if ($this->iterationCounter)
			$s = preg_replace('/{iteration ([a-zA-Z0-9_]+)}/', '\\1', $s);
		if (!$this->usingCoreFont) {
			$discards = substr_count($s, "\xc2\xad"); // mPDF 6 soft hyphens [U+00AD]
			$unicode = $this->UTF8StringToArray($s, $addSubset);
			if ($this->minwSpacing || $this->fixedlSpacing) {
				$nb_spaces = mb_substr_count($s, ' ', $this->mb_enc);
				$nb_carac = count($unicode) - $discards; // mPDF 6
				// mPDF 5.7.1
				// Use GPOS OTL
				if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
					if (isset($OTLdata['group']) && $OTLdata['group']) {
						$nb_carac -= substr_count($OTLdata['group'], 'M');
					}
				}
			}
			/* -- CJK-FONTS -- */
			if ($this->CurrentFont['type'] == 'Type0') { // CJK Adobe fonts
				foreach ($unicode as $char) {
					if ($char == 0x00AD) {
						continue;
					} // mPDF 6 soft hyphens [U+00AD]
					if (isset($cw[$char])) {
						$w+=$cw[$char];
					} elseif (isset($this->CurrentFont['MissingWidth'])) {
						$w += $this->CurrentFont['MissingWidth'];
					} else {
						$w += 500;
					}
				}
			} else {
				/* -- END CJK-FONTS -- */
				foreach ($unicode as $i => $char) {
					if ($char == 0x00AD) {
						continue;
					} // mPDF 6 soft hyphens [U+00AD]
					if (($textvar & FC_SMALLCAPS) && isset($this->upperCase[$char])) {
						$charw = $this->_getCharWidth($cw, $this->upperCase[$char]);
						if ($charw !== false) {
							$charw = $charw * $this->smCapsScale * $this->smCapsStretch / 100;
							$w+=$charw;
						} elseif (isset($this->CurrentFont['desc']['MissingWidth'])) {
							$w += $this->CurrentFont['desc']['MissingWidth'];
						} elseif (isset($this->CurrentFont['MissingWidth'])) {
							$w += $this->CurrentFont['MissingWidth'];
						} else {
							$w += 500;
						}
					} else {
						$charw = $this->_getCharWidth($cw, $char);
						if ($charw !== false) {
							$w+=$charw;
						} elseif (isset($this->CurrentFont['desc']['MissingWidth'])) {
							$w += $this->CurrentFont['desc']['MissingWidth'];
						} elseif (isset($this->CurrentFont['MissingWidth'])) {
							$w += $this->CurrentFont['MissingWidth'];
						} else {
							$w += 500;
						}
						// mPDF 5.7.1
						// Use GPOS OTL
						// ...GetStringWidth...
						if (isset($this->CurrentFont['useOTL']) && ($this->CurrentFont['useOTL'] & 0xFF) && !empty($OTLdata)) {
							if (isset($OTLdata['GPOSinfo'][$i]['wDir']) && $OTLdata['GPOSinfo'][$i]['wDir'] == 'RTL') {
								if (isset($OTLdata['GPOSinfo'][$i]['XAdvanceR']) && $OTLdata['GPOSinfo'][$i]['XAdvanceR']) {
									$w += $OTLdata['GPOSinfo'][$i]['XAdvanceR'] * 1000 / $this->CurrentFont['unitsPerEm'];
								}
							} else {
								if (isset($OTLdata['GPOSinfo'][$i]['XAdvanceL']) && $OTLdata['GPOSinfo'][$i]['XAdvanceL']) {
									$w += $OTLdata['GPOSinfo'][$i]['XAdvanceL'] * 1000 / $this->CurrentFont['unitsPerEm'];
								}
							}
							// Kashida from GPOS
							// Kashida is set as an absolute length value (already set as a proportion based on useKashida %)
							if ($includeKashida && isset($OTLdata['GPOSinfo'][$i]['kashida_space']) && $OTLdata['GPOSinfo'][$i]['kashida_space']) {
								$kashida += $OTLdata['GPOSinfo'][$i]['kashida_space'];
							}
						}
						if (($textvar & FC_KERNING) && $lastchar) {
							if (isset($this->CurrentFont['kerninfo'][$lastchar][$char])) {
								$kerning += $this->CurrentFont['kerninfo'][$lastchar][$char];
							}
						}
						$lastchar = $char;
					}
				}
			} // *CJK-FONTS*
		} else {
			if ($this->FontFamily != 'csymbol' && $this->FontFamily != 'czapfdingbats') {
				$s = str_replace(chr(173), '', $s);
			}
			$nb_carac = $l = strlen($s);
			if ($this->minwSpacing || $this->fixedlSpacing) {
				$nb_spaces = substr_count($s, ' ');
			}
			for ($i = 0; $i < $l; $i++) {
				if (($textvar & FC_SMALLCAPS) && isset($this->upperCase[ord($s[$i])])) {  // mPDF 5.7.1
					$charw = $cw[chr($this->upperCase[ord($s[$i])])];
					if ($charw !== false) {
						$charw = $charw * $this->smCapsScale * $this->smCapsStretch / 100;
						$w+=$charw;
					}
				} elseif (isset($cw[$s[$i]])) {
					$w += $cw[$s[$i]];
				} elseif (isset($cw[ord($s[$i])])) {
					$w += $cw[ord($s[$i])];
				}
				if (($textvar & FC_KERNING) && $i > 0) { // mPDF 5.7.1
					if (isset($this->CurrentFont['kerninfo'][$s[($i - 1)]][$s[$i]])) {
						$kerning += $this->CurrentFont['kerninfo'][$s[($i - 1)]][$s[$i]];
					}
				}
			}
		}
		unset($cw);
		if ($textvar & FC_KERNING) {
			$w += $kerning;
		} // mPDF 5.7.1
		$w *= ($this->FontSize / 1000);
		$w += (($nb_carac + $nb_spaces) * $this->fixedlSpacing) + ($nb_spaces * $this->minwSpacing);
		$w += $kashida / _MPDFK;

		return ($w);
	}

	function SetLineWidth($width)
	{
		//Set line width
		$this->LineWidth = $width;
		$lwout = (sprintf('%.3F w', $width * _MPDFK));
		if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['LineWidth']) && $this->pageoutput[$this->page]['LineWidth'] != $lwout) || !isset($this->pageoutput[$this->page]['LineWidth']))) {
			$this->_out($lwout);
		}
		$this->pageoutput[$this->page]['LineWidth'] = $lwout;
	}

	function Line($x1, $y1, $x2, $y2)
	{
		//Draw a line
		$this->_out(sprintf('%.3F %.3F m %.3F %.3F l S', $x1 * _MPDFK, ($this->h - $y1) * _MPDFK, $x2 * _MPDFK, ($this->h - $y2) * _MPDFK));
	}

	function Arrow($x1, $y1, $x2, $y2, $headsize = 3, $fill = 'B', $angle = 25)
	{
		//F == fill //S == stroke //B == stroke and fill
		// angle = splay of arrowhead - 1 - 89 degrees
		if ($fill == 'F')
			$fill = 'f';
		elseif ($fill == 'FD' or $fill == 'DF' or $fill == 'B')
			$fill = 'B';
		else
			$fill = 'S';
		$a = atan2(($y2 - $y1), ($x2 - $x1));
		$b = $a + deg2rad($angle);
		$c = $a - deg2rad($angle);
		$x3 = $x2 - ($headsize * cos($b));
		$y3 = $this->h - ($y2 - ($headsize * sin($b)));
		$x4 = $x2 - ($headsize * cos($c));
		$y4 = $this->h - ($y2 - ($headsize * sin($c)));

		$x5 = $x3 - ($x3 - $x4) / 2; // mid point of base of arrowhead - to join arrow line to
		$y5 = $y3 - ($y3 - $y4) / 2;

		$s = '';
		$s.=sprintf('%.3F %.3F m %.3F %.3F l S', $x1 * _MPDFK, ($this->h - $y1) * _MPDFK, $x5 * _MPDFK, $y5 * _MPDFK);
		$this->_out($s);

		$s = '';
		$s.=sprintf('%.3F %.3F m %.3F %.3F l %.3F %.3F l %.3F %.3F l %.3F %.3F l ', $x5 * _MPDFK, $y5 * _MPDFK, $x3 * _MPDFK, $y3 * _MPDFK, $x2 * _MPDFK, ($this->h - $y2) * _MPDFK, $x4 * _MPDFK, $y4 * _MPDFK, $x5 * _MPDFK, $y5 * _MPDFK);
		$s.=$fill;
		$this->_out($s);
	}

	function Rect($x, $y, $w, $h, $style = '')
	{
		//Draw a rectangle
		if ($style == 'F')
			$op = 'f';
		elseif ($style == 'FD' or $style == 'DF')
			$op = 'B';
		else
			$op = 'S';
		$this->_out(sprintf('%.3F %.3F %.3F %.3F re %s', $x * _MPDFK, ($this->h - $y) * _MPDFK, $w * _MPDFK, -$h * _MPDFK, $op));
	}

	function AddFont($family, $style = '')
	{
		if (empty($family)) {
			return;
		}
		$family = strtolower($family);
		$style = strtoupper($style);
		$style = str_replace('U', '', $style);
		if ($style == 'IB')
			$style = 'BI';
		$fontkey = $family . $style;
		// check if the font has been already added
		if (isset($this->fonts[$fontkey])) {
			return;
		}

		/* -- CJK-FONTS -- */
		if (in_array($family, $this->available_CJK_fonts)) {
			if (empty($this->Big5_widths)) {
				require(_MPDF_PATH . 'includes/CJKdata.php');
			}
			$this->AddCJKFont($family); // don't need to add style
			return;
		}
		/* -- END CJK-FONTS -- */

		if ($this->usingCoreFont) {
			throw new MpdfException("mPDF Error - problem with Font management");
		}

		$stylekey = $style;
		if (!$style) {
			$stylekey = 'R';
		}

		if (!isset($this->fontdata[$family][$stylekey]) || !$this->fontdata[$family][$stylekey]) {
			throw new MpdfException('mPDF Error - Font is not supported - ' . $family . ' ' . $style);
		}

		$name = '';
		$originalsize = 0;
		$sip = false;
		$smp = false;
		$useOTL = 0; // mPDF 5.7.1
		$fontmetrics = ''; // mPDF 6
		$haskerninfo = false;
		$haskernGPOS = false;
		$hassmallcapsGSUB = false;
		$BMPselected = false;
		$GSUBScriptLang = array();
		$GSUBFeatures = array();
		$GSUBLookups = array();
		$GPOSScriptLang = array();
		$GPOSFeatures = array();
		$GPOSLookups = array();
		if (file_exists(_MPDF_TTFONTDATAPATH . $fontkey . '.mtx.php')) {
			include(_MPDF_TTFONTDATAPATH . $fontkey . '.mtx.php');
		}

		$ttffile = '';
		if (defined('_MPDF_SYSTEM_TTFONTS')) {
			$ttffile = _MPDF_SYSTEM_TTFONTS . $this->fontdata[$family][$stylekey];
			if (!file_exists($ttffile)) {
				$ttffile = '';
			}
		}
		if (!$ttffile) {
			$ttffile = _MPDF_TTFONTPATH . $this->fontdata[$family][$stylekey];
			if (!file_exists($ttffile)) {
				throw new MpdfException("mPDF Error - cannot find TTF TrueType font file - " . $ttffile);
			}
		}
		$ttfstat = stat($ttffile);

		if (isset($this->fontdata[$family]['TTCfontID'][$stylekey])) {
			$TTCfontID = $this->fontdata[$family]['TTCfontID'][$stylekey];
		} else {
			$TTCfontID = 0;
		}

		$BMPonly = false;
		if (in_array($family, $this->BMPonly)) {
			$BMPonly = true;
		}
		$regenerate = false;
		if ($BMPonly && !$BMPselected) {
			$regenerate = true;
		} elseif (!$BMPonly && $BMPselected) {
			$regenerate = true;
		}
		// mPDF 5.7.1
		if (isset($this->fontdata[$family]['useOTL']) && $this->fontdata[$family]['useOTL'] && $useOTL != $this->fontdata[$family]['useOTL']) {
			$regenerate = true;
			$useOTL = $this->fontdata[$family]['useOTL'];
		} elseif ((!isset($this->fontdata[$family]['useOTL']) || !$this->fontdata[$family]['useOTL']) && $useOTL) {
			$regenerate = true;
			$useOTL = 0;
		}
		if (_FONT_DESCRIPTOR != $fontmetrics) {
			$regenerate = true;
		} // mPDF 6
		if (!isset($name) || $originalsize != $ttfstat['size'] || $regenerate) {
			if (!class_exists('TTFontFile', false)) {
				include(_MPDF_PATH . 'classes/ttfontsuni.php');
			}
			$ttf = new TTFontFile();
			$ttf->getMetrics($ttffile, $fontkey, $TTCfontID, $this->debugfonts, $BMPonly, $useOTL); // mPDF 5.7.1
			$cw = $ttf->charWidths;
			$kerninfo = $ttf->kerninfo;
			if ($kerninfo)
				$haskerninfo = true;
			$haskernGPOS = $ttf->haskernGPOS;
			$hassmallcapsGSUB = $ttf->hassmallcapsGSUB;
			$name = preg_replace('/[ ()]/', '', $ttf->fullName);
			$sip = $ttf->sipset;
			$smp = $ttf->smpset;
			// mPDF 6
			$GSUBScriptLang = $ttf->GSUBScriptLang;
			$GSUBFeatures = $ttf->GSUBFeatures;
			$GSUBLookups = $ttf->GSUBLookups;
			$rtlPUAstr = $ttf->rtlPUAstr;
			$GPOSScriptLang = $ttf->GPOSScriptLang;
			$GPOSFeatures = $ttf->GPOSFeatures;
			$GPOSLookups = $ttf->GPOSLookups;
			$glyphIDtoUni = $ttf->glyphIDtoUni;


			$desc = array(
				'CapHeight' => round($ttf->capHeight),
				'XHeight' => round($ttf->xHeight),
				'FontBBox' => '[' . round($ttf->bbox[0]) . " " . round($ttf->bbox[1]) . " " . round($ttf->bbox[2]) . " " . round($ttf->bbox[3]) . ']', /* FontBBox from head table */

				/* 		'MaxWidth' => round($ttf->advanceWidthMax),	// AdvanceWidthMax from hhea table	NB ArialUnicode MS = 31990 ! */
				'Flags' => $ttf->flags,
				'Ascent' => round($ttf->ascent),
				'Descent' => round($ttf->descent),
				'Leading' => round($ttf->lineGap),
				'ItalicAngle' => $ttf->italicAngle,
				'StemV' => round($ttf->stemV),
				'MissingWidth' => round($ttf->defaultWidth)
			);
			$panose = '';
			if (count($ttf->panose)) {
				$panoseArray = array_merge(array($ttf->sFamilyClass, $ttf->sFamilySubClass), $ttf->panose);
				foreach ($panoseArray as $value)
					$panose .= ' ' . dechex($value);
			}
			$unitsPerEm = round($ttf->unitsPerEm);
			$up = round($ttf->underlinePosition);
			$ut = round($ttf->underlineThickness);
			$strp = round($ttf->strikeoutPosition); // mPDF 6
			$strs = round($ttf->strikeoutSize); // mPDF 6
			$originalsize = $ttfstat['size'] + 0;
			$type = 'TTF';
			//Generate metrics .php file
			$s = '<?php' . "\n";
			$s.='$name=\'' . $name . "';\n";
			$s.='$type=\'' . $type . "';\n";
			$s.='$desc=' . var_export($desc, true) . ";\n";
			$s.='$unitsPerEm=' . $unitsPerEm . ";\n";
			$s.='$up=' . $up . ";\n";
			$s.='$ut=' . $ut . ";\n";
			$s.='$strp=' . $strp . ";\n"; // mPDF 6
			$s.='$strs=' . $strs . ";\n"; // mPDF 6
			$s.='$ttffile=\'' . $ttffile . "';\n";
			$s.='$TTCfontID=\'' . $TTCfontID . "';\n";
			$s.='$originalsize=' . $originalsize . ";\n";
			if ($sip)
				$s.='$sip=true;' . "\n";
			else
				$s.='$sip=false;' . "\n";
			if ($smp)
				$s.='$smp=true;' . "\n";
			else
				$s.='$smp=false;' . "\n";
			if ($BMPonly)
				$s.='$BMPselected=true;' . "\n";
			else
				$s.='$BMPselected=false;' . "\n";
			$s.='$fontkey=\'' . $fontkey . "';\n";
			$s.='$panose=\'' . $panose . "';\n";
			if ($haskerninfo)
				$s.='$haskerninfo=true;' . "\n";
			else
				$s.='$haskerninfo=false;' . "\n";
			if ($haskernGPOS)
				$s.='$haskernGPOS=true;' . "\n";
			else
				$s.='$haskernGPOS=false;' . "\n";
			if ($hassmallcapsGSUB)
				$s.='$hassmallcapsGSUB=true;' . "\n";
			else
				$s.='$hassmallcapsGSUB=false;' . "\n";
			$s.='$fontmetrics=\'' . _FONT_DESCRIPTOR . "';\n"; // mPDF 6

			$s.='// TypoAscender/TypoDescender/TypoLineGap = ' . round($ttf->typoAscender) . ', ' . round($ttf->typoDescender) . ', ' . round($ttf->typoLineGap) . "\n";
			$s.='// usWinAscent/usWinDescent = ' . round($ttf->usWinAscent) . ', ' . round(-$ttf->usWinDescent) . "\n";
			$s.='// hhea Ascent/Descent/LineGap = ' . round($ttf->hheaascent) . ', ' . round($ttf->hheadescent) . ', ' . round($ttf->hhealineGap) . "\n";

			//  mPDF 5.7.1
			if (isset($this->fontdata[$family]['useOTL'])) {
				$s.='$useOTL=' . $this->fontdata[$family]['useOTL'] . ';' . "\n";
			} else
				$s.='$useOTL=0x0000;' . "\n";
			if ($rtlPUAstr) {
				$s.='$rtlPUAstr=\'' . $rtlPUAstr . "';\n";
			} else
				$s.='$rtlPUAstr=\'\';' . "\n";
			if (count($GSUBScriptLang)) {
				$s.='$GSUBScriptLang=' . var_export($GSUBScriptLang, true) . ";\n";
			}
			if (count($GSUBFeatures)) {
				$s.='$GSUBFeatures=' . var_export($GSUBFeatures, true) . ";\n";
			}
			if (count($GSUBLookups)) {
				$s.='$GSUBLookups=' . var_export($GSUBLookups, true) . ";\n";
			}
			if (count($GPOSScriptLang)) {
				$s.='$GPOSScriptLang=' . var_export($GPOSScriptLang, true) . ";\n";
			}
			if (count($GPOSFeatures)) {
				$s.='$GPOSFeatures=' . var_export($GPOSFeatures, true) . ";\n";
			}
			if (count($GPOSLookups)) {
				$s.='$GPOSLookups=' . var_export($GPOSLookups, true) . ";\n";
			}
			if ($kerninfo) {
				$s.='$kerninfo=' . var_export($kerninfo, true) . ";\n";
			}
			$s.="?>";
			if (is_writable(dirname(_MPDF_TTFONTDATAPATH . 'x'))) {
				$fh = fopen(_MPDF_TTFONTDATAPATH . $fontkey . '.mtx.php', "w");
				fwrite($fh, $s, strlen($s));
				fclose($fh);
				$fh = fopen(_MPDF_TTFONTDATAPATH . $fontkey . '.cw.dat', "wb");
				fwrite($fh, $cw, strlen($cw));
				fclose($fh);
				// mPDF 5.7.1
				$fh = fopen(_MPDF_TTFONTDATAPATH . $fontkey . '.gid.dat', "wb");
				fwrite($fh, $glyphIDtoUni, strlen($glyphIDtoUni));
				fclose($fh);
				if (file_exists(_MPDF_TTFONTDATAPATH . $fontkey . '.cgm'))
					unlink(_MPDF_TTFONTDATAPATH . $fontkey . '.cgm');
				if (file_exists(_MPDF_TTFONTDATAPATH . $fontkey . '.z'))
					unlink(_MPDF_TTFONTDATAPATH . $fontkey . '.z');
				if (file_exists(_MPDF_TTFONTDATAPATH . $fontkey . '.cw127.php'))
					unlink(_MPDF_TTFONTDATAPATH . $fontkey . '.cw127.php');
				if (file_exists(_MPDF_TTFONTDATAPATH . $fontkey . '.cw'))
					unlink(_MPDF_TTFONTDATAPATH . $fontkey . '.cw');
			}
			elseif ($this->debugfonts) {
				throw new MpdfException('Cannot write to the font caching directory - ' . _MPDF_TTFONTDATAPATH);
			}
			unset($ttf);
		} else {
			$cw = '';
			$glyphIDtoUni = '';
			if (file_exists(_MPDF_TTFONTDATAPATH . $fontkey . '.cw.dat'))
				$cw = file_get_contents(_MPDF_TTFONTDATAPATH . $fontkey . '.cw.dat');
			if (file_exists(_MPDF_TTFONTDATAPATH . $fontkey . '.gid.dat'))
				$glyphIDtoUni = file_get_contents(_MPDF_TTFONTDATAPATH . $fontkey . '.gid.dat');
		}

		/* -- OTL -- */
		// mPDF 5.7.1
		// Use OTL OpenType Table Layout - GSUB
		if (isset($this->fontdata[$family]['useOTL']) && ($this->fontdata[$family]['useOTL'])) {
			if (!class_exists('otl', false)) {
				include(_MPDF_PATH . 'classes/otl.php');
			}
			if (empty($this->otl)) {
				$this->otl = new otl($this);
			}
		}
		/* -- END OTL -- */

		if (isset($this->fontdata[$family]['sip-ext']) && $this->fontdata[$family]['sip-ext']) {
			$sipext = $this->fontdata[$family]['sip-ext'];
		} else {
			$sipext = '';
		}

		// Override with values from config_font.php
		if (isset($this->fontdata[$family]['Ascent']) && $this->fontdata[$family]['Ascent']) {
			$desc['Ascent'] = $this->fontdata[$family]['Ascent'];
		}
		if (isset($this->fontdata[$family]['Descent']) && $this->fontdata[$family]['Descent']) {
			$desc['Descent'] = $this->fontdata[$family]['Descent'];
		}
		if (isset($this->fontdata[$family]['Leading']) && $this->fontdata[$family]['Leading']) {
			$desc['Leading'] = $this->fontdata[$family]['Leading'];
		}



		$i = count($this->fonts) + $this->extraFontSubsets + 1;
		if ($sip || $smp) {
			$this->fonts[$fontkey] = array('i' => $i, 'type' => $type, 'name' => $name, 'desc' => $desc, 'panose' => $panose, 'unitsPerEm' => $unitsPerEm, 'up' => $up, 'ut' => $ut, 'strs' => $strs, 'strp' => $strp, 'cw' => $cw, 'ttffile' => $ttffile, 'fontkey' => $fontkey, 'subsets' => array(0 => range(0, 127)), 'subsetfontids' => array($i), 'used' => false, 'sip' => $sip, 'sipext' => $sipext, 'smp' => $smp, 'TTCfontID' => $TTCfontID, 'useOTL' => (isset($this->fontdata[$family]['useOTL']) ? $this->fontdata[$family]['useOTL'] : false), 'useKashida' => (isset($this->fontdata[$family]['useKashida']) ? $this->fontdata[$family]['useKashida'] : false), 'GSUBScriptLang' => $GSUBScriptLang, 'GSUBFeatures' => $GSUBFeatures, 'GSUBLookups' => $GSUBLookups, 'GPOSScriptLang' => $GPOSScriptLang, 'GPOSFeatures' => $GPOSFeatures, 'GPOSLookups' => $GPOSLookups, 'rtlPUAstr' => $rtlPUAstr, 'glyphIDtoUni' => $glyphIDtoUni, 'haskerninfo' => $haskerninfo, 'haskernGPOS' => $haskernGPOS, 'hassmallcapsGSUB' => $hassmallcapsGSUB); // mPDF 5.7.1	// mPDF 6
		} else {
			$ss = array();
			for ($s = 32; $s < 128; $s++) {
				$ss[$s] = $s;
			}
			$this->fonts[$fontkey] = array('i' => $i, 'type' => $type, 'name' => $name, 'desc' => $desc, 'panose' => $panose, 'unitsPerEm' => $unitsPerEm, 'up' => $up, 'ut' => $ut, 'strs' => $strs, 'strp' => $strp, 'cw' => $cw, 'ttffile' => $ttffile, 'fontkey' => $fontkey, 'subset' => $ss, 'used' => false, 'sip' => $sip, 'sipext' => $sipext, 'smp' => $smp, 'TTCfontID' => $TTCfontID, 'useOTL' => (isset($this->fontdata[$family]['useOTL']) ? $this->fontdata[$family]['useOTL'] : false), 'useKashida' => (isset($this->fontdata[$family]['useKashida']) ? $this->fontdata[$family]['useKashida'] : false), 'GSUBScriptLang' => $GSUBScriptLang, 'GSUBFeatures' => $GSUBFeatures, 'GSUBLookups' => $GSUBLookups, 'GPOSScriptLang' => $GPOSScriptLang, 'GPOSFeatures' => $GPOSFeatures, 'GPOSLookups' => $GPOSLookups, 'rtlPUAstr' => $rtlPUAstr, 'glyphIDtoUni' => $glyphIDtoUni, 'haskerninfo' => $haskerninfo, 'haskernGPOS' => $haskernGPOS, 'hassmallcapsGSUB' => $hassmallcapsGSUB); // mPDF 5.7.1	// mPDF 6
		}
		if ($haskerninfo) {
			$this->fonts[$fontkey]['kerninfo'] = $kerninfo;
		}
		$this->FontFiles[$fontkey] = array('length1' => $originalsize, 'type' => "TTF", 'ttffile' => $ttffile, 'sip' => $sip, 'smp' => $smp);
		unset($cw);
	}

	function SetFont($family, $style = '', $size = 0, $write = true, $forcewrite = false)
	{
		$family = strtolower($family);
		if (!$this->onlyCoreFonts) {
			if ($family == 'sans' || $family == 'sans-serif') {
				$family = $this->sans_fonts[0];
			}
			if ($family == 'serif') {
				$family = $this->serif_fonts[0];
			}
			if ($family == 'mono' || $family == 'monospace') {
				$family = $this->mono_fonts[0];
			}
		}
		if (isset($this->fonttrans[$family]) && $this->fonttrans[$family]) {
			$family = $this->fonttrans[$family];
		}
		if ($family == '') {
			if ($this->FontFamily) {
				$family = $this->FontFamily;
			} elseif ($this->default_font) {
				$family = $this->default_font;
			} else {
				throw new MpdfException("No font or default font set!");
			}
		}
		$this->ReqFontStyle = $style; // required or requested style - used later for artificial bold/italic

		if (($family == 'csymbol') || ($family == 'czapfdingbats') || ($family == 'ctimes') || ($family == 'ccourier') || ($family == 'chelvetica')) {
			if ($this->PDFA || $this->PDFX) {
				if ($family == 'csymbol' || $family == 'czapfdingbats') {
					throw new MpdfException("Symbol and Zapfdingbats cannot be embedded in mPDF (required for PDFA1-b or PDFX/1-a).");
				}
				if ($family == 'ctimes' || $family == 'ccourier' || $family == 'chelvetica') {
					if (($this->PDFA && !$this->PDFAauto) || ($this->PDFX && !$this->PDFXauto)) {
						$this->PDFAXwarnings[] = "Core Adobe font " . ucfirst($family) . " cannot be embedded in mPDF, which is required for PDFA1-b or PDFX/1-a. (Embedded font will be substituted.)";
					}
					if ($family == 'chelvetica') {
						$family = 'sans';
					}
					if ($family == 'ctimes') {
						$family = 'serif';
					}
					if ($family == 'ccourier') {
						$family = 'mono';
					}
				}
				$this->usingCoreFont = false;
			} else {
				$this->usingCoreFont = true;
			}
			if ($family == 'csymbol' || $family == 'czapfdingbats') {
				$style = '';
			}
		} else {
			$this->usingCoreFont = false;
		}

		// mPDF 5.7.1
		if ($style) {
			$style = strtoupper($style);
			if ($style == 'IB')
				$style = 'BI';
		}
		if ($size == 0)
			$size = $this->FontSizePt;

		$fontkey = $family . $style;

		$stylekey = $style;
		if (!$stylekey) {
			$stylekey = "R";
		}

		if (!$this->onlyCoreFonts && !$this->usingCoreFont) {
			if (!isset($this->fonts[$fontkey]) || count($this->default_available_fonts) != count($this->available_unifonts)) { // not already added
				/* -- CJK-FONTS -- */
				// CJK fonts
				if (in_array($fontkey, $this->available_CJK_fonts)) {
					if (!isset($this->fonts[$fontkey])) { // already added
						if (empty($this->Big5_widths)) {
							require(_MPDF_PATH . 'includes/CJKdata.php');
						}
						$this->AddCJKFont($family); // don't need to add style
					}
				}
				// Test to see if requested font/style is available - or substitute
				else
				/* -- END CJK-FONTS -- */
				if (!in_array($fontkey, $this->available_unifonts)) {
					// If font[nostyle] exists - set it
					if (in_array($family, $this->available_unifonts)) {
						$style = '';
					}

					// elseif only one font available - set it (assumes if only one font available it will not have a style)
					elseif (count($this->available_unifonts) == 1) {
						$family = $this->available_unifonts[0];
						$style = '';
					} else {
						$found = 0;
						// else substitute font of similar type
						if (in_array($family, $this->sans_fonts)) {
							$i = array_intersect($this->sans_fonts, $this->available_unifonts);
							if (count($i)) {
								$i = array_values($i);
								// with requested style if possible
								if (!in_array(($i[0] . $style), $this->available_unifonts)) {
									$style = '';
								}
								$family = $i[0];
								$found = 1;
							}
						} elseif (in_array($family, $this->serif_fonts)) {
							$i = array_intersect($this->serif_fonts, $this->available_unifonts);
							if (count($i)) {
								$i = array_values($i);
								// with requested style if possible
								if (!in_array(($i[0] . $style), $this->available_unifonts)) {
									$style = '';
								}
								$family = $i[0];
								$found = 1;
							}
						} elseif (in_array($family, $this->mono_fonts)) {
							$i = array_intersect($this->mono_fonts, $this->available_unifonts);
							if (count($i)) {
								$i = array_values($i);
								// with requested style if possible
								if (!in_array(($i[0] . $style), $this->available_unifonts)) {
									$style = '';
								}
								$family = $i[0];
								$found = 1;
							}
						}

						if (!$found) {
							// set first available font
							$fs = $this->available_unifonts[0];
							preg_match('/^([a-z_0-9\-]+)([BI]{0,2})$/', $fs, $fas); // Allow "-"
							// with requested style if possible
							$ws = $fas[1] . $style;
							if (in_array($ws, $this->available_unifonts)) {
								$family = $fas[1]; // leave $style as is
							} elseif (in_array($fas[1], $this->available_unifonts)) {
								// or without style
								$family = $fas[1];
								$style = '';
							} else {
								// or with the style specified
								$family = $fas[1];
								$style = $fas[2];
							}
						}
					}
					$fontkey = $family . $style;
				}
			}
			// try to add font (if not already added)
			$this->AddFont($family, $style);

			//Test if font is already selected
			if ($this->FontFamily == $family && $this->FontFamily == $this->currentfontfamily && $this->FontStyle == $style && $this->FontStyle == $this->currentfontstyle && $this->FontSizePt == $size && $this->FontSizePt == $this->currentfontsize && !$forcewrite) {
				return $family;
			}

			$fontkey = $family . $style;

			//Select it
			$this->FontFamily = $family;
			$this->FontStyle = $style;
			$this->FontSizePt = $size;
			$this->FontSize = $size / _MPDFK;
			$this->CurrentFont = &$this->fonts[$fontkey];
			if ($write) {
				$fontout = (sprintf('BT /F%d %.3F Tf ET', $this->CurrentFont['i'], $this->FontSizePt));
				if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['Font']) && $this->pageoutput[$this->page]['Font'] != $fontout) || !isset($this->pageoutput[$this->page]['Font']))) {
					$this->_out($fontout);
				}
				$this->pageoutput[$this->page]['Font'] = $fontout;
			}



			// Added - currentfont (lowercase) used in HTML2PDF
			$this->currentfontfamily = $family;
			$this->currentfontsize = $size;
			$this->currentfontstyle = $style;
			$this->setMBencoding('UTF-8');
		} else {  // if using core fonts
			if ($this->PDFA || $this->PDFX) {
				throw new MpdfException('Core Adobe fonts cannot be embedded in mPDF (required for PDFA1-b or PDFX/1-a) - cannot use option to use core fonts.');
			}
			$this->setMBencoding('windows-1252');

			//Test if font is already selected
			if (($this->FontFamily == $family) AND ( $this->FontStyle == $style) AND ( $this->FontSizePt == $size) && !$forcewrite) {
				return $family;
			}

			if (!isset($this->CoreFonts[$fontkey])) {
				if (in_array($family, $this->serif_fonts)) {
					$family = 'ctimes';
				} elseif (in_array($family, $this->mono_fonts)) {
					$family = 'ccourier';
				} else {
					$family = 'chelvetica';
				}
				$this->usingCoreFont = true;
				$fontkey = $family . $style;
			}

			if (!isset($this->fonts[$fontkey])) {
				// STANDARD CORE FONTS
				if (isset($this->CoreFonts[$fontkey])) {
					//Load metric file
					$file = $family;
					if ($family == 'ctimes' || $family == 'chelvetica' || $family == 'ccourier') {
						$file.=strtolower($style);
					}
					$file.='.php';
					include(_MPDF_PATH . 'font/' . $file);
					if (!isset($cw)) {
						throw new MpdfException('Could not include font metric file');
					}
					$i = count($this->fonts) + $this->extraFontSubsets + 1;
					$this->fonts[$fontkey] = array('i' => $i, 'type' => 'core', 'name' => $this->CoreFonts[$fontkey], 'desc' => $desc, 'up' => $up, 'ut' => $ut, 'cw' => $cw);
					if ($this->useKerning && isset($kerninfo)) {
						$this->fonts[$fontkey]['kerninfo'] = $kerninfo;
					}
				} else {
					throw new MpdfException('mPDF error - Font not defined');
				}
			}
			//Test if font is already selected
			if (($this->FontFamily == $family) AND ( $this->FontStyle == $style) AND ( $this->FontSizePt == $size) && !$forcewrite) {
				return $family;
			}
			//Select it
			$this->FontFamily = $family;
			$this->FontStyle = $style;
			$this->FontSizePt = $size;
			$this->FontSize = $size / _MPDFK;
			$this->CurrentFont = &$this->fonts[$fontkey];
			if ($write) {
				$fontout = (sprintf('BT /F%d %.3F Tf ET', $this->CurrentFont['i'], $this->FontSizePt));
				if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['Font']) && $this->pageoutput[$this->page]['Font'] != $fontout) || !isset($this->pageoutput[$this->page]['Font']))) {
					$this->_out($fontout);
				}
				$this->pageoutput[$this->page]['Font'] = $fontout;
			}
			// Added - currentfont (lowercase) used in HTML2PDF
			$this->currentfontfamily = $family;
			$this->currentfontsize = $size;
			$this->currentfontstyle = $style;
		}

		return $family;
	}

	function SetFontSize($size, $write = true)
	{
		//Set font size in points
		if ($this->FontSizePt == $size)
			return;
		$this->FontSizePt = $size;
		$this->FontSize = $size / _MPDFK;
		$this->currentfontsize = $size;
		if ($write) {
			$fontout = (sprintf('BT /F%d %.3F Tf ET', $this->CurrentFont['i'], $this->FontSizePt));
			// Edited mPDF 3.0
			if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['Font']) && $this->pageoutput[$this->page]['Font'] != $fontout) || !isset($this->pageoutput[$this->page]['Font']))) {
				$this->_out($fontout);
			}
			$this->pageoutput[$this->page]['Font'] = $fontout;
		}
	}

	function AddLink()
	{
		//Create a new internal link
		$n = count($this->links) + 1;
		$this->links[$n] = array(0, 0);
		return $n;
	}

	function SetLink($link, $y = 0, $page = -1)
	{
		//Set destination of internal link
		if ($y == -1)
			$y = $this->y;
		if ($page == -1)
			$page = $this->page;
		$this->links[$link] = array($page, $y);
	}

	function Link($x, $y, $w, $h, $link)
	{
		$l = array($x * _MPDFK, $this->hPt - $y * _MPDFK, $w * _MPDFK, $h * _MPDFK, $link);
		if ($this->keep_block_together) { // don't write yet
			return;
		} elseif ($this->table_rotate) { // *TABLES*
			$this->tbrot_Links[$this->page][] = $l; // *TABLES*
			return; // *TABLES*
		} // *TABLES*
		elseif ($this->kwt) {
			$this->kwt_Links[$this->page][] = $l;
			return;
		}

		if ($this->writingHTMLheader || $this->writingHTMLfooter) {
			$this->HTMLheaderPageLinks[] = $l;
			return;
		}
		//Put a link on the page
		$this->PageLinks[$this->page][] = $l;
		// Save cross-reference to Column buffer
		$ref = count($this->PageLinks[$this->page]) - 1; // *COLUMNS*
		$this->columnLinks[$this->CurrCol][INTVAL($this->x)][INTVAL($this->y)] = $ref; // *COLUMNS*
	}

	function Text($x, $y, $txt, $OTLdata = array(), $textvar = 0, $aixextra = '', $coordsys = '', $return = false)
	{
		// Output (or return) a string
		// Called (internally) by Watermark() & _tableWrite() [rotated cells] & TableHeaderFooter() & WriteText()
		// Called also from classes/svg.php
		// Expects Font to be set
		// Expects input to be mb_encoded if necessary and RTL reversed & OTL processed
		// ARTIFICIAL BOLD AND ITALIC
		$s = 'q ';
		if ($this->falseBoldWeight && strpos($this->ReqFontStyle, "B") !== false && strpos($this->FontStyle, "B") === false) {
			$s .= '2 Tr 1 J 1 j ';
			$s .= sprintf('%.3F w ', ($this->FontSize / 130) * _MPDFK * $this->falseBoldWeight);
			$tc = strtoupper($this->TextColor); // change 0 0 0 rg to 0 0 0 RG
			if ($this->FillColor != $tc) {
				$s .= $tc . ' ';
			}  // stroke (outline) = same colour as text(fill)
		}
		if (strpos($this->ReqFontStyle, "I") !== false && strpos($this->FontStyle, "I") === false) {
			$aix = '1 0 0.261799 1 %.3F %.3F Tm';
		} else {
			$aix = '%.3F %.3F Td';
		}

		$aix = $aixextra . $aix;

		if ($this->ColorFlag)
			$s.=$this->TextColor . ' ';

		$this->CurrentFont['used'] = true;

		if ($this->usingCoreFont) {
			$txt2 = str_replace(chr(160), chr(32), $txt);
		} else {
			$txt2 = str_replace(chr(194) . chr(160), chr(32), $txt);
		}

		$px = $x;
		$py = $y;
		if ($coordsys != 'SVG') {
			$px = $x * _MPDFK;
			$py = ($this->h - $y) * _MPDFK;
		}


		/*         * ************** SIMILAR TO Cell() ************************ */

		// IF corefonts AND NOT SmCaps AND NOT Kerning
		// Just output text
		if ($this->usingCoreFont && !($textvar & FC_SMALLCAPS) && !($textvar & FC_KERNING)) {
			$txt2 = $this->_escape($txt2);
			$s .=sprintf('BT ' . $aix . ' (%s) Tj ET', $px, $py, $txt2);
		}


		// IF NOT corefonts [AND NO wordspacing] AND NOT SIP/SMP AND NOT SmCaps AND NOT Kerning AND NOT OTL
		// Just output text
		elseif (!$this->usingCoreFont && !($textvar & FC_SMALLCAPS) && !($textvar & FC_KERNING) && !(isset($this->CurrentFont['useOTL']) && ($this->CurrentFont['useOTL'] & 0xFF) && !empty($OTLdata['GPOSinfo']))) {
			// IF SIP/SMP
			if ($this->CurrentFont['sip'] || $this->CurrentFont['smp']) {
				$txt2 = $this->UTF8toSubset($txt2);
				$s .=sprintf('BT ' . $aix . ' %s Tj ET', $px, $py, $txt2);
			}
			// NOT SIP/SMP
			else {
				$txt2 = $this->UTF8ToUTF16BE($txt2, false);
				$txt2 = $this->_escape($txt2);
				$s .=sprintf('BT ' . $aix . ' (%s) Tj ET', $px, $py, $txt2);
			}
		}

		// IF NOT corefonts [AND IS wordspacing] AND NOT SIP AND NOT SmCaps AND NOT Kerning AND NOT OTL
		// Not required here (cf. Cell() )
		// ELSE (IF SmCaps || Kerning || OTL) [corefonts or not corefonts; SIP or SMP or BMP]
		else {
			$s .= $this->applyGPOSpdf($txt2, $aix, $px, $py, $OTLdata, $textvar);
		}
		/*         * ************** END ************************ */

		$s .= ' ';

		if (($textvar & FD_UNDERLINE) && $txt != '') { // mPDF 5.7.1
			$c = strtoupper($this->TextColor); // change 0 0 0 rg to 0 0 0 RG
			if ($this->FillColor != $c) {
				$s.= ' ' . $c . ' ';
			}
			if (isset($this->CurrentFont['up']) && $this->CurrentFont['up']) {
				$up = $this->CurrentFont['up'];
			} else {
				$up = -100;
			}
			$adjusty = (-$up / 1000 * $this->FontSize);
			if (isset($this->CurrentFont['ut']) && $this->CurrentFont['ut']) {
				$ut = $this->CurrentFont['ut'] / 1000 * $this->FontSize;
			} else {
				$ut = 60 / 1000 * $this->FontSize;
			}
			$olw = $this->LineWidth;
			$s.=' ' . (sprintf(' %.3F w', $ut * _MPDFK));
			$s.=' ' . $this->_dounderline($x, $y + $adjusty, $txt, $OTLdata, $textvar);
			$s.=' ' . (sprintf(' %.3F w', $olw * _MPDFK));
			if ($this->FillColor != $c) {
				$s.= ' ' . $this->FillColor . ' ';
			}
		}
		// STRIKETHROUGH
		if (($textvar & FD_LINETHROUGH) && $txt != '') { // mPDF 5.7.1
			$c = strtoupper($this->TextColor); // change 0 0 0 rg to 0 0 0 RG
			if ($this->FillColor != $c) {
				$s.= ' ' . $c . ' ';
			}
			//Superscript and Subscript Y coordinate adjustment (now for striked-through texts)
			if (isset($this->CurrentFont['desc']['CapHeight']) && $this->CurrentFont['desc']['CapHeight']) {
				$ch = $this->CurrentFont['desc']['CapHeight'];
			} else {
				$ch = 700;
			}
			$adjusty = (-$ch / 1000 * $this->FontSize) * 0.35;
			if (isset($this->CurrentFont['ut']) && $this->CurrentFont['ut']) {
				$ut = $this->CurrentFont['ut'] / 1000 * $this->FontSize;
			} else {
				$ut = 60 / 1000 * $this->FontSize;
			}
			$olw = $this->LineWidth;
			$s.=' ' . (sprintf(' %.3F w', $ut * _MPDFK));
			$s.=' ' . $this->_dounderline($x, $y + $adjusty, $txt, $OTLdata, $textvar);
			$s.=' ' . (sprintf(' %.3F w', $olw * _MPDFK));
			if ($this->FillColor != $c) {
				$s.= ' ' . $this->FillColor . ' ';
			}
		}
		$s .= 'Q';

		if ($return) {
			return $s . " \n";
		}
		$this->_out($s);
	}

	/* -- DIRECTW -- */

	function WriteText($x, $y, $txt)
	{
		// Output a string using Text() but does encoding and text reversing of RTL
		$txt = $this->purify_utf8_text($txt);
		if ($this->text_input_as_HTML) {
			$txt = $this->all_entities_to_utf8($txt);
		}
		if ($this->usingCoreFont) {
			$txt = mb_convert_encoding($txt, $this->mb_enc, 'UTF-8');
		}

		// DIRECTIONALITY
		if (preg_match("/([" . $this->pregRTLchars . "])/u", $txt)) {
			$this->biDirectional = true;
		} // *OTL*

		$textvar = 0;
		$save_OTLtags = $this->OTLtags;
		$this->OTLtags = array();
		if ($this->useKerning) {
			if ($this->CurrentFont['haskernGPOS']) {
				$this->OTLtags['Plus'] .= ' kern';
			} else {
				$textvar = ($textvar | FC_KERNING);
			}
		}

		/* -- OTL -- */
		// Use OTL OpenType Table Layout - GSUB & GPOS
		if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
			$txt = $this->otl->applyOTL($txt, $this->CurrentFont['useOTL']);
			$OTLdata = $this->otl->OTLdata;
		}
		/* -- END OTL -- */
		$this->OTLtags = $save_OTLtags;

		$this->magic_reverse_dir($txt, $this->directionality, $OTLdata);

		$this->Text($x, $y, $txt, $OTLdata, $textvar);
	}

	function WriteCell($w, $h = 0, $txt = '', $border = 0, $ln = 0, $align = '', $fill = 0, $link = '', $currentx = 0)
	{
		//Output a cell using Cell() but does encoding and text reversing of RTL
		$txt = $this->purify_utf8_text($txt);
		if ($this->text_input_as_HTML) {
			$txt = $this->all_entities_to_utf8($txt);
		}
		if ($this->usingCoreFont) {
			$txt = mb_convert_encoding($txt, $this->mb_enc, 'UTF-8');
		}
		// DIRECTIONALITY
		if (preg_match("/([" . $this->pregRTLchars . "])/u", $txt)) {
			$this->biDirectional = true;
		} // *OTL*

		$textvar = 0;
		$save_OTLtags = $this->OTLtags;
		$this->OTLtags = array();
		if ($this->useKerning) {
			if ($this->CurrentFont['haskernGPOS']) {
				$this->OTLtags['Plus'] .= ' kern';
			} else {
				$textvar = ($textvar | FC_KERNING);
			}
		}

		/* -- OTL -- */
		// Use OTL OpenType Table Layout - GSUB & GPOS
		if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
			$txt = $this->otl->applyOTL($txt, $this->CurrentFont['useOTL']);
			$OTLdata = $this->otl->OTLdata;
		}
		/* -- END OTL -- */
		$this->OTLtags = $save_OTLtags;

		$this->magic_reverse_dir($txt, $this->directionality, $OTLdata);

		$this->Cell($w, $h, $txt, $border, $ln, $align, $fill, $link, $currentx, 0, 0, 'M', 0, false, $OTLdata, $textvar);
	}

	/* -- END DIRECTW -- */

	function ResetSpacing()
	{
		if ($this->ws != 0) {
			$this->_out('BT 0 Tw ET');
		}
		$this->ws = 0;
		if ($this->charspacing != 0) {
			$this->_out('BT 0 Tc ET');
		}
		$this->charspacing = 0;
	}

	function SetSpacing($cs, $ws)
	{
		if (intval($cs * 1000) == 0) {
			$cs = 0;
		}
		if ($cs) {
			$this->_out(sprintf('BT %.3F Tc ET', $cs));
		} elseif ($this->charspacing != 0) {
			$this->_out('BT 0 Tc ET');
		}
		$this->charspacing = $cs;
		if (intval($ws * 1000) == 0) {
			$ws = 0;
		}
		if ($ws) {
			$this->_out(sprintf('BT %.3F Tw ET', $ws));
		} elseif ($this->ws != 0) {
			$this->_out('BT 0 Tw ET');
		}
		$this->ws = $ws;
	}

	// WORD SPACING
	function GetJspacing($nc, $ns, $w, $inclCursive, &$cOTLdata)
	{
		$kashida_present = false;
		$kashida_space = 0;
		if ($w > 0 && $inclCursive && isset($this->CurrentFont['useKashida']) && $this->CurrentFont['useKashida'] && !empty($cOTLdata)) {
			for ($c = 0; $c < count($cOTLdata); $c++) {
				for ($i = 0; $i < strlen($cOTLdata[$c]['group']); $i++) {
					if (isset($cOTLdata[$c]['GPOSinfo'][$i]['kashida']) && $cOTLdata[$c]['GPOSinfo'][$i]['kashida'] > 0) {
						$kashida_present = true;
						break 2;
					}
				}
			}
		}

		if ($kashida_present) {
			$k_ctr = 0;  // Number of kashida points
			$k_total = 0;  // Total of kashida values (priority)
			// Reset word
			$max_kashida_in_word = 0;
			$last_kashida_in_word = -1;

			for ($c = 0; $c < count($cOTLdata); $c++) {
				for ($i = 0; $i < strlen($cOTLdata[$c]['group']); $i++) {

					if ($cOTLdata[$c]['group']{$i} == 'S') {
						// Save from last word
						if ($max_kashida_in_word) {
							$k_ctr++;
							$k_total = $max_kashida_in_word;
						}
						// Reset word
						$max_kashida_in_word = 0;
						$last_kashida_in_word = -1;
					}

					if (isset($cOTLdata[$c]['GPOSinfo'][$i]['kashida']) && $cOTLdata[$c]['GPOSinfo'][$i]['kashida'] > 0) {
						if ($max_kashida_in_word) {
							if ($cOTLdata[$c]['GPOSinfo'][$i]['kashida'] > $max_kashida_in_word) {
								$max_kashida_in_word = $cOTLdata[$c]['GPOSinfo'][$i]['kashida'];
								$cOTLdata[$c]['GPOSinfo'][$last_kashida_in_word]['kashida'] = 0;
								$last_kashida_in_word = $i;
							} else {
								$cOTLdata[$c]['GPOSinfo'][$i]['kashida'] = 0;
							}
						} else {
							$max_kashida_in_word = $cOTLdata[$c]['GPOSinfo'][$i]['kashida'];
							$last_kashida_in_word = $i;
						}
					}
				}
			}
			// Save from last word
			if ($max_kashida_in_word) {
				$k_ctr++;
				$k_total = $max_kashida_in_word;
			}

			// Number of kashida points = $k_ctr
			// $useKashida is a % value from CurrentFont/config_fonts.php
			// % ratio divided between word-spacing and kashida-spacing
			$kashida_space_ratio = intval($this->CurrentFont['useKashida']) / 100;


			$kashida_space = $w * $kashida_space_ratio;

			$tatw = $this->_getCharWidth($this->CurrentFont['cw'], 0x0640);
			// Only use kashida if each allocated kashida width is > 0.01 x width of a tatweel
			// Otherwise fontstretch is too small and errors
			// If not just leave to adjust word-spacing
			if ($tatw && (($kashida_space / $k_ctr) / $tatw) > 0.01) {
				for ($c = 0; $c < count($cOTLdata); $c++) {
					for ($i = 0; $i < strlen($cOTLdata[$c]['group']); $i++) {
						if (isset($cOTLdata[$c]['GPOSinfo'][$i]['kashida']) && $cOTLdata[$c]['GPOSinfo'][$i]['kashida'] > 0) {
							// At this point kashida is a number representing priority (higher number - higher priority)
							// We are now going to set it as an actual length
							// This shares it equally amongst words:
							$cOTLdata[$c]['GPOSinfo'][$i]['kashida_space'] = (1 / $k_ctr) * $kashida_space;
						}
					}
				}
				$w -= $kashida_space;
			}
		}

		$ws = 0;
		$charspacing = 0;
		$ww = $this->jSWord;
		$ncx = $nc - 1;
		if ($nc == 0) {
			return array(0, 0, 0);
		}
		// Only word spacing allowed / possible
		elseif ($this->fixedlSpacing !== false || $inclCursive) {
			if ($ns) {
				$ws = $w / $ns;
			}
		} elseif ($nc == 1) {
			$charspacing = $w;
		} elseif (!$ns) {
			$charspacing = $w / ($ncx );
			if (($this->jSmaxChar > 0) && ($charspacing > $this->jSmaxChar)) {
				$charspacing = $this->jSmaxChar;
			}
		} elseif ($ns == ($ncx )) {
			$charspacing = $w / $ns;
		} else {
			if ($this->usingCoreFont) {
				$cs = ($w * (1 - $this->jSWord)) / ($ncx );
				if (($this->jSmaxChar > 0) && ($cs > $this->jSmaxChar)) {
					$cs = $this->jSmaxChar;
					$ww = 1 - (($cs * ($ncx )) / $w);
				}
				$charspacing = $cs;
				$ws = ($w * ($ww) ) / $ns;
			} else {
				$cs = ($w * (1 - $this->jSWord)) / ($ncx - $ns);
				if (($this->jSmaxChar > 0) && ($cs > $this->jSmaxChar)) {
					$cs = $this->jSmaxChar;
					$ww = 1 - (($cs * ($ncx - $ns)) / $w);
				}
				$charspacing = $cs;
				$ws = (($w * ($ww) ) / $ns) - $charspacing;
			}
		}
		return array($charspacing, $ws, $kashida_space);
	}

	function Cell($w, $h = 0, $txt = '', $border = 0, $ln = 0, $align = '', $fill = 0, $link = '', $currentx = 0, $lcpaddingL = 0, $lcpaddingR = 0, $valign = 'M', $spanfill = 0, $exactWidth = false, $OTLdata = false, $textvar = 0, $lineBox = false)
	{  // mPDF 5.7.1
		//Output a cell
		// Expects input to be mb_encoded if necessary and RTL reversed
		// NON_BREAKING SPACE
		if ($this->usingCoreFont) {
			$txt = str_replace(chr(160), chr(32), $txt);
		} else {
			$txt = str_replace(chr(194) . chr(160), chr(32), $txt);
		}

		$oldcolumn = $this->CurrCol;
		// Automatic page break
		// Allows PAGE-BREAK-AFTER = avoid to work
		if (isset($this->blk[$this->blklvl])) {
			$bottom = $this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['margin_bottom'];
		} else {
			$bottom = 0;
		}
		if (!$this->tableLevel && (($this->y + $this->divheight > $this->PageBreakTrigger) || ($this->y + $h > $this->PageBreakTrigger) ||
			($this->y + ($h * 2) + $bottom > $this->PageBreakTrigger && $this->blk[$this->blklvl]['page_break_after_avoid'])) and ! $this->InFooter and $this->AcceptPageBreak()) { // mPDF 5.7.2
			$x = $this->x; //Current X position
			// WORD SPACING
			$ws = $this->ws; //Word Spacing
			$charspacing = $this->charspacing; //Character Spacing
			$this->ResetSpacing();

			$this->AddPage($this->CurOrientation);
			// Added to correct for OddEven Margins
			$x += $this->MarginCorrection;
			if ($currentx) {
				$currentx += $this->MarginCorrection;
			}
			$this->x = $x;
			// WORD SPACING
			$this->SetSpacing($charspacing, $ws);
		}

		// Test: to put line through centre of cell: $this->Line($this->x,$this->y+($h/2),$this->x+50,$this->y+($h/2));
		// Test: to put border around cell as it is specified: $border='LRTB';


		/* -- COLUMNS -- */
		// COLS
		// COLUMN CHANGE
		if ($this->CurrCol != $oldcolumn) {
			if ($currentx) {
				$currentx += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
			}
			$this->x += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
		}

		// COLUMNS Update/overwrite the lowest bottom of printing y value for a column
		if ($this->ColActive) {
			if ($h) {
				$this->ColDetails[$this->CurrCol]['bottom_margin'] = $this->y + $h;
			} else {
				$this->ColDetails[$this->CurrCol]['bottom_margin'] = $this->y + $this->divheight;
			}
		}
		/* -- END COLUMNS -- */


		if ($w == 0)
			$w = $this->w - $this->rMargin - $this->x;
		$s = '';
		if ($fill == 1 && $this->FillColor) {
			if ((isset($this->pageoutput[$this->page]['FillColor']) && $this->pageoutput[$this->page]['FillColor'] != $this->FillColor) || !isset($this->pageoutput[$this->page]['FillColor'])) {
				$s .= $this->FillColor . ' ';
			}
			$this->pageoutput[$this->page]['FillColor'] = $this->FillColor;
		}


		if ($lineBox && isset($lineBox['boxtop']) && $txt) { // i.e. always from WriteFlowingBlock/finishFlowingBlock (but not objects -
			// which only have $lineBox['top'] set)
			$boxtop = $this->y + $lineBox['boxtop'];
			$boxbottom = $this->y + $lineBox['boxbottom'];
			$glyphYorigin = $lineBox['glyphYorigin'];
			$baseline_shift = $lineBox['baseline-shift'];
			$bord_boxtop = $bg_boxtop = $boxtop = $boxtop - $baseline_shift;
			$bord_boxbottom = $bg_boxbottom = $boxbottom = $boxbottom - $baseline_shift;
			$bord_boxheight = $bg_boxheight = $boxheight = $boxbottom - $boxtop;

			// If inline element BACKGROUND has bounding box set by parent element:
			if (isset($lineBox['background-boxtop'])) {
				$bg_boxtop = $this->y + $lineBox['background-boxtop'] - $lineBox['background-baseline-shift'];
				$bg_boxbottom = $this->y + $lineBox['background-boxbottom'] - $lineBox['background-baseline-shift'];
				$bg_boxheight = $bg_boxbottom - $bg_boxtop;
			}
			// If inline element BORDER has bounding box set by parent element:
			if (isset($lineBox['border-boxtop'])) {
				$bord_boxtop = $this->y + $lineBox['border-boxtop'] - $lineBox['border-baseline-shift'];
				$bord_boxbottom = $this->y + $lineBox['border-boxbottom'] - $lineBox['border-baseline-shift'];
				$bord_boxheight = $bord_boxbottom - $bord_boxtop;
			}
		} else {
			$boxtop = $this->y;
			$boxheight = $h;
			$boxbottom = $this->y + $h;
			$baseline_shift = 0;
			if ($txt != '') {
				// FONT SIZE - this determines the baseline caculation
				$bfs = $this->FontSize;
				//Calculate baseline Superscript and Subscript Y coordinate adjustment
				$bfx = $this->baselineC;
				$baseline = $bfx * $bfs;

				if ($textvar & FA_SUPERSCRIPT) {
					$baseline_shift = $this->textparam['text-baseline'];
				} // mPDF 5.7.1	// mPDF 6
				elseif ($textvar & FA_SUBSCRIPT) {
					$baseline_shift = $this->textparam['text-baseline'];
				} // mPDF 5.7.1	// mPDF 6
				elseif ($this->bullet) {
					$baseline += ($bfx - 0.7) * $this->FontSize;
				}

				// Vertical align (for Images)
				if ($valign == 'T') {
					$va = (0.5 * $bfs * $this->normalLineheight);
				} elseif ($valign == 'B') {
					$va = $h - (0.5 * $bfs * $this->normalLineheight);
				} else {
					$va = 0.5 * $h;
				} // Middle
				// ONLY SET THESE IF WANT TO CONFINE BORDER +/- FILL TO FIT FONTSIZE - NOT FULL CELL AS IS ORIGINAL FUNCTION
				// spanfill or spanborder are set in FlowingBlock functions
				if ($spanfill || !empty($this->spanborddet) || $link != '') {
					$exth = 0.2; // Add to fontsize to increase height of background / link / border
					$boxtop = $this->y + $baseline + $va - ($this->FontSize * (1 + $exth / 2) * (0.5 + $bfx));
					$boxheight = $this->FontSize * (1 + $exth);
					$boxbottom = $boxtop + $boxheight;
				}
				$glyphYorigin = $baseline + $va;
			}
			$boxtop -= $baseline_shift;
			$boxbottom -= $baseline_shift;
			$bord_boxtop = $bg_boxtop = $boxtop;
			$bord_boxbottom = $bg_boxbottom = $boxbottom;
			$bord_boxheight = $bg_boxheight = $boxheight = $boxbottom - $boxtop;
		}


		$bbw = $tbw = $lbw = $rbw = 0; // Border widths
		if (!empty($this->spanborddet)) {
			if (!isset($this->spanborddet['B'])) {
				$this->spanborddet['B'] = array('s' => 0, 'style' => '', 'w' => 0);
			}
			if (!isset($this->spanborddet['T'])) {
				$this->spanborddet['T'] = array('s' => 0, 'style' => '', 'w' => 0);
			}
			if (!isset($this->spanborddet['L'])) {
				$this->spanborddet['L'] = array('s' => 0, 'style' => '', 'w' => 0);
			}
			if (!isset($this->spanborddet['R'])) {
				$this->spanborddet['R'] = array('s' => 0, 'style' => '', 'w' => 0);
			}
			$bbw = $this->spanborddet['B']['w'];
			$tbw = $this->spanborddet['T']['w'];
			$lbw = $this->spanborddet['L']['w'];
			$rbw = $this->spanborddet['R']['w'];
		}
		if ($fill == 1 || $border == 1 || !empty($this->spanborddet)) {
			if (!empty($this->spanborddet)) {
				if ($fill == 1) {
					$s.=sprintf('%.3F %.3F %.3F %.3F re f ', ($this->x - $lbw) * _MPDFK, ($this->h - $bg_boxtop + $tbw) * _MPDFK, ($w + $lbw + $rbw) * _MPDFK, (-$bg_boxheight - $tbw - $bbw) * _MPDFK);
				}
				$s.= ' q ';
				$dashon = 3;
				$dashoff = 3.5;
				$dot = 2.5;
				if ($tbw) {
					$short = 0;
					if ($this->spanborddet['T']['style'] == 'dashed') {
						$s.=sprintf(' 0 j 0 J [%.3F %.3F] 0 d ', $tbw * $dashon * _MPDFK, $tbw * $dashoff * _MPDFK);
					} elseif ($this->spanborddet['T']['style'] == 'dotted') {
						$s.=sprintf(' 1 j 1 J [%.3F %.3F] %.3F d ', 0.001, $tbw * $dot * _MPDFK, -$tbw / 2 * _MPDFK);
						$short = $tbw / 2;
					} else {
						$s.=' 0 j 0 J [] 0 d ';
					}
					if ($this->spanborddet['T']['style'] != 'dotted') {
						$s .= 'q ';
						$s .= sprintf('%.3F %.3F m ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x + $w + $rbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x + $w) * _MPDFK, ($this->h - $bord_boxtop) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x) * _MPDFK, ($this->h - $bord_boxtop) * _MPDFK);
						$s .= ' h W n '; // Ends path no-op & Sets the clipping path
					}
					$c = $this->SetDColor($this->spanborddet['T']['c'], true);
					if ($this->spanborddet['T']['style'] == 'double') {
						$s.=sprintf(' %s %.3F w ', $c, $tbw / 3 * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw * 5 / 6) * _MPDFK, ($this->x + $w + $rbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw * 5 / 6) * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw / 6) * _MPDFK, ($this->x + $w + $rbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw / 6) * _MPDFK);
					} elseif ($this->spanborddet['T']['style'] == 'dotted') {
						$s.=sprintf(' %s %.3F w ', $c, $tbw * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw / 2) * _MPDFK, ($this->x + $w + $rbw - $short) * _MPDFK, ($this->h - $bord_boxtop + $tbw / 2) * _MPDFK);
					} else {
						$s.=sprintf(' %s %.3F w ', $c, $tbw * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw / 2) * _MPDFK, ($this->x + $w + $rbw - $short) * _MPDFK, ($this->h - $bord_boxtop + $tbw / 2) * _MPDFK);
					}
					if ($this->spanborddet['T']['style'] != 'dotted') {
						$s .= ' Q ';
					}
				}
				if ($bbw) {
					$short = 0;
					if ($this->spanborddet['B']['style'] == 'dashed') {
						$s.=sprintf(' 0 j 0 J [%.3F %.3F] 0 d ', $bbw * $dashon * _MPDFK, $bbw * $dashoff * _MPDFK);
					} elseif ($this->spanborddet['B']['style'] == 'dotted') {
						$s.=sprintf(' 1 j 1 J [%.3F %.3F] %.3F d ', 0.001, $bbw * $dot * _MPDFK, -$bbw / 2 * _MPDFK);
						$short = $bbw / 2;
					} else {
						$s.=' 0 j 0 J [] 0 d ';
					}
					if ($this->spanborddet['B']['style'] != 'dotted') {
						$s .= 'q ';
						$s .= sprintf('%.3F %.3F m ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxbottom - $bbw) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x + $w + $rbw) * _MPDFK, ($this->h - $bord_boxbottom - $bbw) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x + $w) * _MPDFK, ($this->h - $bord_boxbottom) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x) * _MPDFK, ($this->h - $bord_boxbottom) * _MPDFK);
						$s .= ' h W n '; // Ends path no-op & Sets the clipping path
					}
					$c = $this->SetDColor($this->spanborddet['B']['c'], true);
					if ($this->spanborddet['B']['style'] == 'double') {
						$s.=sprintf(' %s %.3F w ', $c, $bbw / 3 * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxbottom - $bbw / 6) * _MPDFK, ($this->x + $w + $rbw - $short) * _MPDFK, ($this->h - $bord_boxbottom - $bbw / 6) * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxbottom - $bbw * 5 / 6) * _MPDFK, ($this->x + $w + $rbw - $short) * _MPDFK, ($this->h - $bord_boxbottom - $bbw * 5 / 6) * _MPDFK);
					} elseif ($this->spanborddet['B']['style'] == 'dotted') {
						$s.=sprintf(' %s %.3F w ', $c, $bbw * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxbottom - $bbw / 2) * _MPDFK, ($this->x + $w + $rbw - $short) * _MPDFK, ($this->h - $bord_boxbottom - $bbw / 2) * _MPDFK);
					} else {
						$s.=sprintf(' %s %.3F w ', $c, $bbw * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxbottom - $bbw / 2) * _MPDFK, ($this->x + $w + $rbw - $short) * _MPDFK, ($this->h - $bord_boxbottom - $bbw / 2) * _MPDFK);
					}
					if ($this->spanborddet['B']['style'] != 'dotted') {
						$s .= ' Q ';
					}
				}
				if ($lbw) {
					$short = 0;
					if ($this->spanborddet['L']['style'] == 'dashed') {
						$s.=sprintf(' 0 j 0 J [%.3F %.3F] 0 d ', $lbw * $dashon * _MPDFK, $lbw * $dashoff * _MPDFK);
					} elseif ($this->spanborddet['L']['style'] == 'dotted') {
						$s.=sprintf(' 1 j 1 J [%.3F %.3F] %.3F d ', 0.001, $lbw * $dot * _MPDFK, -$lbw / 2 * _MPDFK);
						$short = $lbw / 2;
					} else {
						$s.=' 0 j 0 J [] 0 d ';
					}
					if ($this->spanborddet['L']['style'] != 'dotted') {
						$s .= 'q ';
						$s .= sprintf('%.3F %.3F m ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxbottom - $bbw) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x) * _MPDFK, ($this->h - $bord_boxbottom) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x) * _MPDFK, ($this->h - $bord_boxtop) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x - $lbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK);
						$s .= ' h W n '; // Ends path no-op & Sets the clipping path
					}
					$c = $this->SetDColor($this->spanborddet['L']['c'], true);
					if ($this->spanborddet['L']['style'] == 'double') {
						$s.=sprintf(' %s %.3F w ', $c, $lbw / 3 * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw / 6) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK, ($this->x - $lbw / 6) * _MPDFK, ($this->h - $bord_boxbottom - $bbw + $short) * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw * 5 / 6) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK, ($this->x - $lbw * 5 / 6) * _MPDFK, ($this->h - $bord_boxbottom - $bbw + $short) * _MPDFK);
					} elseif ($this->spanborddet['L']['style'] == 'dotted') {
						$s.=sprintf(' %s %.3F w ', $c, $lbw * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw / 2) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK, ($this->x - $lbw / 2) * _MPDFK, ($this->h - $bord_boxbottom - $bbw + $short) * _MPDFK);
					} else {
						$s.=sprintf(' %s %.3F w ', $c, $lbw * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x - $lbw / 2) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK, ($this->x - $lbw / 2) * _MPDFK, ($this->h - $bord_boxbottom - $bbw + $short) * _MPDFK);
					}
					if ($this->spanborddet['L']['style'] != 'dotted') {
						$s .= ' Q ';
					}
				}
				if ($rbw) {
					$short = 0;
					if ($this->spanborddet['R']['style'] == 'dashed') {
						$s.=sprintf(' 0 j 0 J [%.3F %.3F] 0 d ', $rbw * $dashon * _MPDFK, $rbw * $dashoff * _MPDFK);
					} elseif ($this->spanborddet['R']['style'] == 'dotted') {
						$s.=sprintf(' 1 j 1 J [%.3F %.3F] %.3F d ', 0.001, $rbw * $dot * _MPDFK, -$rbw / 2 * _MPDFK);
						$short = $rbw / 2;
					} else {
						$s.=' 0 j 0 J [] 0 d ';
					}
					if ($this->spanborddet['R']['style'] != 'dotted') {
						$s .= 'q ';
						$s .= sprintf('%.3F %.3F m ', ($this->x + $w + $rbw) * _MPDFK, ($this->h - $bord_boxbottom - $bbw) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x + $w) * _MPDFK, ($this->h - $bord_boxbottom) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x + $w) * _MPDFK, ($this->h - $bord_boxtop) * _MPDFK);
						$s .= sprintf('%.3F %.3F l ', ($this->x + $w + $rbw) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK);
						$s .= ' h W n '; // Ends path no-op & Sets the clipping path
					}
					$c = $this->SetDColor($this->spanborddet['R']['c'], true);
					if ($this->spanborddet['R']['style'] == 'double') {
						$s.=sprintf(' %s %.3F w ', $c, $rbw / 3 * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x + $w + $rbw / 6) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK, ($this->x + $w + $rbw / 6) * _MPDFK, ($this->h - $bord_boxbottom - $bbw + $short) * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x + $w + $rbw * 5 / 6) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK, ($this->x + $w + $rbw * 5 / 6) * _MPDFK, ($this->h - $bord_boxbottom - $bbw + $short) * _MPDFK);
					} elseif ($this->spanborddet['R']['style'] == 'dotted') {
						$s.=sprintf(' %s %.3F w ', $c, $rbw * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x + $w + $rbw / 2) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK, ($this->x + $w + $rbw / 2) * _MPDFK, ($this->h - $bord_boxbottom - $bbw + $short) * _MPDFK);
					} else {
						$s.=sprintf(' %s %.3F w ', $c, $rbw * _MPDFK);
						$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($this->x + $w + $rbw / 2) * _MPDFK, ($this->h - $bord_boxtop + $tbw) * _MPDFK, ($this->x + $w + $rbw / 2) * _MPDFK, ($this->h - $bord_boxbottom - $bbw + $short) * _MPDFK);
					}
					if ($this->spanborddet['R']['style'] != 'dotted') {
						$s .= ' Q ';
					}
				}
				$s.= ' Q ';
			} else { // If "border", does not come from WriteFlowingBlock or FinishFlowingBlock
				if ($fill == 1)
					$op = ($border == 1) ? 'B' : 'f';
				else
					$op = 'S';
				$s.=sprintf('%.3F %.3F %.3F %.3F re %s ', $this->x * _MPDFK, ($this->h - $bg_boxtop) * _MPDFK, $w * _MPDFK, -$bg_boxheight * _MPDFK, $op);
			}
		}

		if (is_string($border)) { // If "border", does not come from WriteFlowingBlock or FinishFlowingBlock
			$x = $this->x;
			$y = $this->y;
			if (is_int(strpos($border, 'L')))
				$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', $x * _MPDFK, ($this->h - $bord_boxtop) * _MPDFK, $x * _MPDFK, ($this->h - ($bord_boxbottom)) * _MPDFK);
			if (is_int(strpos($border, 'T')))
				$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', $x * _MPDFK, ($this->h - $bord_boxtop) * _MPDFK, ($x + $w) * _MPDFK, ($this->h - $bord_boxtop) * _MPDFK);
			if (is_int(strpos($border, 'R')))
				$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', ($x + $w) * _MPDFK, ($this->h - $bord_boxtop) * _MPDFK, ($x + $w) * _MPDFK, ($this->h - ($bord_boxbottom)) * _MPDFK);
			if (is_int(strpos($border, 'B')))
				$s.=sprintf('%.3F %.3F m %.3F %.3F l S ', $x * _MPDFK, ($this->h - ($bord_boxbottom)) * _MPDFK, ($x + $w) * _MPDFK, ($this->h - ($bord_boxbottom)) * _MPDFK);
		}

		if ($txt != '') {


			if ($exactWidth)
				$stringWidth = $w;
			else
				$stringWidth = $this->GetStringWidth($txt, true, $OTLdata, $textvar) + ( $this->charspacing * mb_strlen($txt, $this->mb_enc) / _MPDFK ) + ( $this->ws * mb_substr_count($txt, ' ', $this->mb_enc) / _MPDFK );

			// Set x OFFSET FOR PRINTING
			if ($align == 'R') {
				$dx = $w - $this->cMarginR - $stringWidth - $lcpaddingR;
			} elseif ($align == 'C') {
				$dx = (($w - $stringWidth ) / 2);
			} elseif ($align == 'L' or $align == 'J')
				$dx = $this->cMarginL + $lcpaddingL;
			else
				$dx = 0;

			if ($this->ColorFlag)
				$s .='q ' . $this->TextColor . ' ';

			// OUTLINE
			if (isset($this->textparam['outline-s']) && $this->textparam['outline-s'] && !($textvar & FC_SMALLCAPS)) { // mPDF 5.7.1
				$s .=' ' . sprintf('%.3F w', $this->LineWidth * _MPDFK) . ' ';
				$s .=" $this->DrawColor ";
				$s .=" 2 Tr ";
			} elseif ($this->falseBoldWeight && strpos($this->ReqFontStyle, "B") !== false && strpos($this->FontStyle, "B") === false && !($textvar & FC_SMALLCAPS)) { // can't use together with OUTLINE or Small Caps	// mPDF 5.7.1	??? why not with SmallCaps ???
				$s .= ' 2 Tr 1 J 1 j ';
				$s .= ' ' . sprintf('%.3F w', ($this->FontSize / 130) * _MPDFK * $this->falseBoldWeight) . ' ';
				$tc = strtoupper($this->TextColor); // change 0 0 0 rg to 0 0 0 RG
				if ($this->FillColor != $tc) {
					$s .= ' ' . $tc . ' ';
				}  // stroke (outline) = same colour as text(fill)
			} else {
				$s .=" 0 Tr ";
			}

			if (strpos($this->ReqFontStyle, "I") !== false && strpos($this->FontStyle, "I") === false) { // Artificial italic
				$aix = '1 0 0.261799 1 %.3F %.3F Tm ';
			} else {
				$aix = '%.3F %.3F Td ';
			}

			$px = ($this->x + $dx) * _MPDFK;
			$py = ($this->h - ($this->y + $glyphYorigin - $baseline_shift)) * _MPDFK;

			// THE TEXT
			$txt2 = $txt;
			$sub = '';
			$this->CurrentFont['used'] = true;

			/*             * ************** SIMILAR TO Text() ************************ */

			// IF corefonts AND NOT SmCaps AND NOT Kerning
			// Just output text; charspacing and wordspacing already set by charspacing (Tc) and ws (Tw)
			if ($this->usingCoreFont && !($textvar & FC_SMALLCAPS) && !($textvar & FC_KERNING)) {
				$txt2 = $this->_escape($txt2);
				$sub .=sprintf('BT ' . $aix . ' (%s) Tj ET', $px, $py, $txt2);
			}


			// IF NOT corefonts AND NO wordspacing AND NOT SIP/SMP AND NOT SmCaps AND NOT Kerning AND NOT OTL
			// Just output text
			elseif (!$this->usingCoreFont && !$this->ws && !($textvar & FC_SMALLCAPS) && !($textvar & FC_KERNING) && !(isset($this->CurrentFont['useOTL']) && ($this->CurrentFont['useOTL'] & 0xFF) && !empty($OTLdata['GPOSinfo']))) {
				// IF SIP/SMP
				if ((isset($this->CurrentFont['sip']) && $this->CurrentFont['sip']) || (isset($this->CurrentFont['smp']) && $this->CurrentFont['smp'])) {
					$txt2 = $this->UTF8toSubset($txt2);
					$sub .=sprintf('BT ' . $aix . ' %s Tj ET', $px, $py, $txt2);
				}
				// NOT SIP/SMP
				else {
					$txt2 = $this->UTF8ToUTF16BE($txt2, false);
					$txt2 = $this->_escape($txt2);
					$sub .=sprintf('BT ' . $aix . ' (%s) Tj ET', $px, $py, $txt2);
				}
			}


			// IF NOT corefonts AND IS wordspacing AND NOT SIP AND NOT SmCaps AND NOT Kerning AND NOT OTL
			// Output text word by word with an adjustment to the intercharacter spacing for SPACEs to form word spacing
			// IF multibyte - Tw has no effect - need to do word spacing using an adjustment before each space
			elseif (!$this->usingCoreFont && $this->ws && !((isset($this->CurrentFont['sip']) && $this->CurrentFont['sip']) || (isset($this->CurrentFont['smp']) && $this->CurrentFont['smp'])) && !($textvar & FC_SMALLCAPS) && !($textvar & FC_KERNING) && !(isset($this->CurrentFont['useOTL']) && ($this->CurrentFont['useOTL'] & 0xFF) && (!empty($OTLdata['GPOSinfo']) || (strpos($OTLdata['group'], 'M') !== false && $this->charspacing)) )) {
				$space = " ";
				$space = $this->UTF8ToUTF16BE($space, false);
				$space = $this->_escape($space);
				$sub .=sprintf('BT ' . $aix . ' %.3F Tc [', $px, $py, $this->charspacing);
				$t = explode(' ', $txt2);
				$numt = count($t);
				for ($i = 0; $i < $numt; $i++) {
					$tx = $t[$i];
					$tx = $this->UTF8ToUTF16BE($tx, false);
					$tx = $this->_escape($tx);
					$sub .=sprintf('(%s) ', $tx);
					if (($i + 1) < $numt) {
						$adj = -($this->ws) * 1000 / $this->FontSizePt;
						$sub .=sprintf('%d(%s) ', $adj, $space);
					}
				}
				$sub .='] TJ ';
				$sub .=' ET';
			}


			// ELSE (IF SmCaps || Kerning || OTL) [corefonts or not corefonts; SIP or SMP or BMP]
			else {
				$sub = $this->applyGPOSpdf($txt, $aix, $px, $py, $OTLdata, $textvar);
			}

			/*             * ************** END SIMILAR TO Text() ************************ */

			if ($this->shrin_k > 1) {
				$shrin_k = $this->shrin_k;
			} else {
				$shrin_k = 1;
			}
			// UNDERLINE
			if ($textvar & FD_UNDERLINE) { // mPDF 5.7.1	// mPDF 6
				// mPDF 5.7.3  inline text-decoration parameters
				$c = $this->textparam['u-decoration']['color'];
				if ($this->FillColor != $c) {
					$sub .= ' ' . $c . ' ';
				}
				// mPDF 5.7.3  inline text-decoration parameters
				$decorationfontkey = $this->textparam['u-decoration']['fontkey'];
				$decorationfontsize = $this->textparam['u-decoration']['fontsize'] / $shrin_k;
				if (isset($this->fonts[$decorationfontkey]['ut']) && $this->fonts[$decorationfontkey]['ut']) {
					$ut = $this->fonts[$decorationfontkey]['ut'] / 1000 * $decorationfontsize;
				} else {
					$ut = 60 / 1000 * $decorationfontsize;
				}
				if (isset($this->fonts[$decorationfontkey]['up']) && $this->fonts[$decorationfontkey]['up']) {
					$up = $this->fonts[$decorationfontkey]['up'];
				} else {
					$up = -100;
				}
				$adjusty = (-$up / 1000 * $decorationfontsize) + $ut / 2;
				$ubaseline = $glyphYorigin - $this->textparam['u-decoration']['baseline'] / $shrin_k;
				$olw = $this->LineWidth;
				$sub .=' ' . (sprintf(' %.3F w 0 j 0 J ', $ut * _MPDFK));
				$sub .=' ' . $this->_dounderline($this->x + $dx, $this->y + $ubaseline + $adjusty, $txt, $OTLdata, $textvar);
				$sub .=' ' . (sprintf(' %.3F w 2 j 2 J ', $olw * _MPDFK));
				if ($this->FillColor != $c) {
					$sub .= ' ' . $this->FillColor . ' ';
				}
			}

			// STRIKETHROUGH
			if ($textvar & FD_LINETHROUGH) { // mPDF 5.7.1	// mPDF 6
				// mPDF 5.7.3  inline text-decoration parameters
				$c = $this->textparam['s-decoration']['color'];
				if ($this->FillColor != $c) {
					$sub .= ' ' . $c . ' ';
				}
				// mPDF 5.7.3  inline text-decoration parameters
				$decorationfontkey = $this->textparam['s-decoration']['fontkey'];
				$decorationfontsize = $this->textparam['s-decoration']['fontsize'] / $shrin_k;
				// Use yStrikeoutSize from OS/2 if available
				if (isset($this->fonts[$decorationfontkey]['strs']) && $this->fonts[$decorationfontkey]['strs']) {
					$ut = $this->fonts[$decorationfontkey]['strs'] / 1000 * $decorationfontsize;
				}
				// else use underlineThickness from post if available
				elseif (isset($this->fonts[$decorationfontkey]['ut']) && $this->fonts[$decorationfontkey]['ut']) {
					$ut = $this->fonts[$decorationfontkey]['ut'] / 1000 * $decorationfontsize;
				} else {
					$ut = 50 / 1000 * $decorationfontsize;
				}
				// Use yStrikeoutPosition from OS/2 if available
				if (isset($this->fonts[$decorationfontkey]['strp']) && $this->fonts[$decorationfontkey]['strp']) {
					$up = $this->fonts[$decorationfontkey]['strp'];
					$adjusty = (-$up / 1000 * $decorationfontsize);
				}
				// else use a fraction ($this->baselineS) of CapHeight
				else {
					if (isset($this->fonts[$decorationfontkey]['desc']['CapHeight']) && $this->fonts[$decorationfontkey]['desc']['CapHeight']) {
						$ch = $this->fonts[$decorationfontkey]['desc']['CapHeight'];
					} else {
						$ch = 700;
					}
					$adjusty = (-$ch / 1000 * $decorationfontsize) * $this->baselineS;
				}

				$sbaseline = $glyphYorigin - $this->textparam['s-decoration']['baseline'] / $shrin_k;
				$olw = $this->LineWidth;
				$sub .=' ' . (sprintf(' %.3F w 0 j 0 J ', $ut * _MPDFK));
				$sub .=' ' . $this->_dounderline($this->x + $dx, $this->y + $sbaseline + $adjusty, $txt, $OTLdata, $textvar);
				$sub .=' ' . (sprintf(' %.3F w 2 j 2 J ', $olw * _MPDFK));
				if ($this->FillColor != $c) {
					$sub .= ' ' . $this->FillColor . ' ';
				}
			}

			// mPDF 5.7.3  inline text-decoration parameters
			// OVERLINE
			if ($textvar & FD_OVERLINE) { // mPDF 5.7.1	// mPDF 6
				// mPDF 5.7.3  inline text-decoration parameters
				$c = $this->textparam['o-decoration']['color'];
				if ($this->FillColor != $c) {
					$sub .= ' ' . $c . ' ';
				}
				// mPDF 5.7.3  inline text-decoration parameters
				$decorationfontkey = $this->textparam['o-decoration']['fontkey'] / $shrin_k;
				$decorationfontsize = $this->textparam['o-decoration']['fontsize'];
				if (isset($this->fonts[$decorationfontkey]['ut']) && $this->fonts[$decorationfontkey]['ut']) {
					$ut = $this->fonts[$decorationfontkey]['ut'] / 1000 * $decorationfontsize;
				} else {
					$ut = 60 / 1000 * $decorationfontsize;
				}
				if (isset($this->fonts[$decorationfontkey]['desc']['CapHeight']) && $this->fonts[$decorationfontkey]['desc']['CapHeight']) {
					$ch = $this->fonts[$decorationfontkey]['desc']['CapHeight'];
				} else {
					$ch = 700;
				}
				$adjusty = (-$ch / 1000 * $decorationfontsize) * $this->baselineO;
				$obaseline = $glyphYorigin - $this->textparam['o-decoration']['baseline'] / $shrin_k;
				$olw = $this->LineWidth;
				$sub .=' ' . (sprintf(' %.3F w 0 j 0 J ', $ut * _MPDFK));
				$sub .=' ' . $this->_dounderline($this->x + $dx, $this->y + $obaseline + $adjusty, $txt, $OTLdata, $textvar);
				$sub .=' ' . (sprintf(' %.3F w 2 j 2 J ', $olw * _MPDFK));
				if ($this->FillColor != $c) {
					$sub .= ' ' . $this->FillColor . ' ';
				}
			}

			// TEXT SHADOW
			if ($this->textshadow) {  // First to process is last in CSS comma separated shadows
				foreach ($this->textshadow AS $ts) {
					$s .= ' q ';
					$s .= $this->SetTColor($ts['col'], true) . "\n";
					if ($ts['col']{0} == 5 && ord($ts['col']{4}) < 100) { // RGBa
						$s .= $this->SetAlpha(ord($ts['col']{4}) / 100, 'Normal', true, 'F') . "\n";
					} elseif ($ts['col']{0} == 6 && ord($ts['col']{5}) < 100) { // CMYKa
						$s .= $this->SetAlpha(ord($ts['col']{5}) / 100, 'Normal', true, 'F') . "\n";
					} elseif ($ts['col']{0} == 1 && $ts['col']{2} == 1 && ord($ts['col']{3}) < 100) { // Gray
						$s .= $this->SetAlpha(ord($ts['col']{3}) / 100, 'Normal', true, 'F') . "\n";
					}
					$s .= sprintf(' 1 0 0 1 %.4F %.4F cm', $ts['x'] * _MPDFK, -$ts['y'] * _MPDFK) . "\n";
					$s .= $sub;
					$s .= ' Q ';
				}
			}

			$s .= $sub;

			// COLOR
			if ($this->ColorFlag)
				$s .=' Q';

			// LINK
			if ($link != '') {
				$this->Link($this->x, $boxtop, $w, $boxheight, $link);
			}
		}
		if ($s)
			$this->_out($s);

		// WORD SPACING
		if ($this->ws && !$this->usingCoreFont) {
			$this->_out(sprintf('BT %.3F Tc ET', $this->charspacing));
		}
		$this->lasth = $h;
		if (strpos($txt, "\n") !== false)
			$ln = 1; // cell recognizes \n from <BR> tag
		if ($ln > 0) {
			//Go to next line
			$this->y += $h;
			if ($ln == 1) {
				//Move to next line
				if ($currentx != 0) {
					$this->x = $currentx;
				} else {
					$this->x = $this->lMargin;
				}
			}
		} else
			$this->x+=$w;
	}

	function applyGPOSpdf($txt, $aix, $x, $y, $OTLdata, $textvar = 0)
	{
		// Generate PDF string
		//==============================
		if ((isset($this->CurrentFont['sip']) && $this->CurrentFont['sip']) || (isset($this->CurrentFont['smp']) && $this->CurrentFont['smp'])) {
			$sipset = true;
		} else {
			$sipset = false;
		}

		if ($textvar & FC_SMALLCAPS) {
			$smcaps = true;
		} // IF SmallCaps using transformation, NOT OTL
		else {
			$smcaps = false;
		}

		if ($sipset) {
			$fontid = $last_fontid = $original_fontid = $this->CurrentFont['subsetfontids'][0];
		} else {
			$fontid = $last_fontid = $original_fontid = $this->CurrentFont['i'];
		}
		$SmallCapsON = false;  // state: uppercase/not
		$lastSmallCapsON = false; // state: uppercase/not
		$last_fontsize = $fontsize = $this->FontSizePt;
		$last_fontstretch = $fontstretch = 100;
		$groupBreak = false;

		$unicode = $this->UTF8StringToArray($txt);

		$GPOSinfo = (isset($OTLdata['GPOSinfo']) ? $OTLdata['GPOSinfo'] : array());
		$charspacing = ($this->charspacing * 1000 / $this->FontSizePt);
		$wordspacing = ($this->ws * 1000 / $this->FontSizePt);

		$XshiftBefore = 0;
		$XshiftAfter = 0;
		$lastYPlacement = 0;

		if ($sipset) {
			// mPDF 6  DELETED ********
			//		$txt= preg_replace('/'.preg_quote($this->aliasNbPg,'/').'/', chr(7), $txt);	// ? Need to adjust OTL info
			//		$txt= preg_replace('/'.preg_quote($this->aliasNbPgGp,'/').'/', chr(8), $txt);	// ? Need to adjust OTL info
			$tj = '<';
		} else {
			$tj = '(';
		}

		for ($i = 0; $i < count($unicode); $i++) {
			$c = $unicode[$i];
			$tx = '';
			$XshiftBefore = $XshiftAfter;
			$XshiftAfter = 0;
			$YPlacement = 0;
			$groupBreak = false;
			$kashida = 0;
			if (!empty($OTLdata)) {
				// YPlacement from GPOS
				if (isset($GPOSinfo[$i]['YPlacement']) && $GPOSinfo[$i]['YPlacement']) {
					$YPlacement = $GPOSinfo[$i]['YPlacement'] * $this->FontSizePt / $this->CurrentFont['unitsPerEm'];
					$groupBreak = true;
				}
				// XPlacement from GPOS
				if (isset($GPOSinfo[$i]['XPlacement']) && $GPOSinfo[$i]['XPlacement']) {

					if (!isset($GPOSinfo[$i]['wDir']) || $GPOSinfo[$i]['wDir'] != 'RTL') {
						if (isset($GPOSinfo[$i]['BaseWidth'])) {
							$GPOSinfo[$i]['XPlacement'] -= $GPOSinfo[$i]['BaseWidth'];
						}
					}

					// Convert to PDF Text space (thousandths of a unit );
					$XshiftBefore += $GPOSinfo[$i]['XPlacement'] * 1000 / $this->CurrentFont['unitsPerEm'];
					$XshiftAfter += -$GPOSinfo[$i]['XPlacement'] * 1000 / $this->CurrentFont['unitsPerEm'];
				}

				// Kashida from GPOS
				// Kashida is set as an absolute length value, but to adjust text needs to be converted to
				// font-related size
				if (isset($GPOSinfo[$i]['kashida_space']) && $GPOSinfo[$i]['kashida_space']) {
					$kashida = $GPOSinfo[$i]['kashida_space'];
				}

				if ($c == 32) { // word spacing
					$XshiftAfter += $wordspacing;
				}

				if (substr($OTLdata['group'], ($i + 1), 1) != 'M') { // Don't add inter-character spacing before Marks
					$XshiftAfter += $charspacing;
				}

				// ...applyGPOSpdf...
				// XAdvance from GPOS - Convert to PDF Text space (thousandths of a unit );
				if (((isset($GPOSinfo[$i]['wDir']) && $GPOSinfo[$i]['wDir'] != 'RTL') || !isset($GPOSinfo[$i]['wDir'])) && isset($GPOSinfo[$i]['XAdvanceL']) && $GPOSinfo[$i]['XAdvanceL']) {
					$XshiftAfter += $GPOSinfo[$i]['XAdvanceL'] * 1000 / $this->CurrentFont['unitsPerEm'];
				} elseif (isset($GPOSinfo[$i]['wDir']) && $GPOSinfo[$i]['wDir'] == 'RTL' && isset($GPOSinfo[$i]['XAdvanceR']) && $GPOSinfo[$i]['XAdvanceR']) {
					$XshiftAfter += $GPOSinfo[$i]['XAdvanceR'] * 1000 / $this->CurrentFont['unitsPerEm'];
				}
			}
			// Character & Word spacing - if NOT OTL
			else {
				$XshiftAfter += $charspacing;
				if ($c == 32) {
					$XshiftAfter += $wordspacing;
				}
			}

			// IF Kerning done using pairs rather than OTL
			if ($textvar & FC_KERNING) {
				if ($i > 0 && isset($this->CurrentFont['kerninfo'][$unicode[($i - 1)]][$unicode[$i]])) {
					$XshiftBefore += $this->CurrentFont['kerninfo'][$unicode[($i - 1)]][$unicode[$i]];
				}
			}

			if ($YPlacement != $lastYPlacement) {
				$groupBreak = true;
			}

			if ($XshiftBefore) {  // +ve value in PDF moves to the left
				// If Fontstretch is ongoing, need to adjust X adjustments because these will be stretched out.
				$XshiftBefore *= 100 / $last_fontstretch;
				if ($sipset) {
					$tj .= sprintf('>%d<', (-$XshiftBefore));
				} else {
					$tj .= sprintf(')%d(', (-$XshiftBefore));
				}
			}

			// Small-Caps
			if ($smcaps) {
				if (isset($this->upperCase[$c])) {
					$c = $this->upperCase[$c];
					//$this->CurrentFont['subset'][$this->upperCase[$c]] = $this->upperCase[$c];	// add the CAP to subset
					$SmallCapsON = true;
					// For $sipset
					if (!$lastSmallCapsON) {   // Turn ON SmallCaps
						$groupBreak = true;
						$fontstretch = $this->smCapsStretch;
						$fontsize = $this->FontSizePt * $this->smCapsScale;
					}
				} else {
					$SmallCapsON = false;
					if ($lastSmallCapsON) {  // Turn OFF SmallCaps
						$groupBreak = true;
						$fontstretch = 100;
						$fontsize = $this->FontSizePt;
					}
				}
			}

			// Prepare Text and Select Font ID
			if ($sipset) {
				// mPDF 6  DELETED ********
				//if ($c == 7 || $c == 8) {
				//	if ($original_fontid != $last_fontid) {
				//		$groupBreak = true;
				//		$fontid = $original_fontid;
				//	}
				//	if ($c == 7) { $tj .= $this->aliasNbPgHex; }
				//	else { $tj .= $this->aliasNbPgGpHex; }
				//	continue;
				//}
				for ($j = 0; $j < 99; $j++) {
					$init = array_search($c, $this->CurrentFont['subsets'][$j]);
					if ($init !== false) {
						if ($this->CurrentFont['subsetfontids'][$j] != $last_fontid) {
							$groupBreak = true;
							$fontid = $this->CurrentFont['subsetfontids'][$j];
						}
						$tx = sprintf("%02s", strtoupper(dechex($init)));
						break;
					} elseif (count($this->CurrentFont['subsets'][$j]) < 255) {
						$n = count($this->CurrentFont['subsets'][$j]);
						$this->CurrentFont['subsets'][$j][$n] = $c;
						if ($this->CurrentFont['subsetfontids'][$j] != $last_fontid) {
							$groupBreak = true;
							$fontid = $this->CurrentFont['subsetfontids'][$j];
						}
						$tx = sprintf("%02s", strtoupper(dechex($n)));
						break;
					} elseif (!isset($this->CurrentFont['subsets'][($j + 1)])) {
						$this->CurrentFont['subsets'][($j + 1)] = array(0 => 0);
						$this->CurrentFont['subsetfontids'][($j + 1)] = count($this->fonts) + $this->extraFontSubsets + 1;
						$this->extraFontSubsets++;
					}
				}
			} else {
				$tx = code2utf($c);
				if ($this->usingCoreFont) {
					$tx = utf8_decode($tx);
				} else {
					$tx = $this->UTF8ToUTF16BE($tx, false);
				}
				$tx = $this->_escape($tx);
			}

			// If any settings require a new Text Group
			if ($groupBreak || $fontstretch != $last_fontstretch) {
				if ($sipset) {
					$tj .= '>] TJ ';
				} else {
					$tj .= ')] TJ ';
				}
				if ($fontid != $last_fontid || $fontsize != $last_fontsize) {
					$tj .= sprintf(' /F%d %.3F Tf ', $fontid, $fontsize);
				}
				if ($fontstretch != $last_fontstretch) {
					$tj .= sprintf('%d Tz ', $fontstretch);
				}
				if ($YPlacement != $lastYPlacement) {
					$tj .= sprintf('%.3F Ts ', $YPlacement);
				}
				if ($sipset) {
					$tj .= '[<';
				} else {
					$tj .= '[(';
				}
			}

			// Output the code for the txt character
			$tj .= $tx;
			$lastSmallCapsON = $SmallCapsON;
			$last_fontid = $fontid;
			$last_fontsize = $fontsize;
			$last_fontstretch = $fontstretch;

			// Kashida
			if ($kashida) {
				$c = 0x0640; // add the Tatweel U+0640
				if (isset($this->CurrentFont['subset'])) {
					$this->CurrentFont['subset'][$c] = $c;
				}
				$kashida *= 1000 / $this->FontSizePt;
				$tatw = $this->_getCharWidth($this->CurrentFont['cw'], 0x0640);

				// Get YPlacement from next Base character
				$nextbase = $i + 1;
				while ($OTLdata['group']{$nextbase} != 'C') {
					$nextbase++;
				}
				if (isset($GPOSinfo[$nextbase]) && isset($GPOSinfo[$nextbase]['YPlacement']) && $GPOSinfo[$nextbase]['YPlacement']) {
					$YPlacement = $GPOSinfo[$nextbase]['YPlacement'] * $this->FontSizePt / $this->CurrentFont['unitsPerEm'];
				}

				// Prepare Text and Select Font ID
				if ($sipset) {
					for ($j = 0; $j < 99; $j++) {
						$init = array_search($c, $this->CurrentFont['subsets'][$j]);
						if ($init !== false) {
							if ($this->CurrentFont['subsetfontids'][$j] != $last_fontid) {
								$fontid = $this->CurrentFont['subsetfontids'][$j];
							}
							$tx = sprintf("%02s", strtoupper(dechex($init)));
							break;
						} elseif (count($this->CurrentFont['subsets'][$j]) < 255) {
							$n = count($this->CurrentFont['subsets'][$j]);
							$this->CurrentFont['subsets'][$j][$n] = $c;
							if ($this->CurrentFont['subsetfontids'][$j] != $last_fontid) {
								$fontid = $this->CurrentFont['subsetfontids'][$j];
							}
							$tx = sprintf("%02s", strtoupper(dechex($n)));
							break;
						} elseif (!isset($this->CurrentFont['subsets'][($j + 1)])) {
							$this->CurrentFont['subsets'][($j + 1)] = array(0 => 0);
							$this->CurrentFont['subsetfontids'][($j + 1)] = count($this->fonts) + $this->extraFontSubsets + 1;
							$this->extraFontSubsets++;
						}
					}
				} else {
					$tx = code2utf($c);
					$tx = $this->UTF8ToUTF16BE($tx, false);
					$tx = $this->_escape($tx);
				}

				if ($kashida > $tatw) {
					// Insert multiple tatweel characters, repositioning the last one to give correct total length
					$fontstretch = 100;
					$nt = intval($kashida / $tatw);
					$nudgeback = (($nt + 1) * $tatw) - $kashida;
					$optx = str_repeat($tx, $nt);
					if ($sipset) {
						$optx .= sprintf('>%d<', ($nudgeback));
					} else {
						$optx .= sprintf(')%d(', ($nudgeback));
					}
					$optx .= $tx; // #last
				} else {
					// Insert single tatweel character and use fontstretch to get correct length
					$fontstretch = ($kashida / $tatw) * 100;
					$optx = $tx;
				}

				if ($sipset) {
					$tj .= '>] TJ ';
				} else {
					$tj .= ')] TJ ';
				}
				if ($fontid != $last_fontid || $fontsize != $last_fontsize) {
					$tj .= sprintf(' /F%d %.3F Tf ', $fontid, $fontsize);
				}
				if ($fontstretch != $last_fontstretch) {
					$tj .= sprintf('%d Tz ', $fontstretch);
				}
				$tj .= sprintf('%.3F Ts ', $YPlacement);
				if ($sipset) {
					$tj .= '[<';
				} else {
					$tj .= '[(';
				}

				// Output the code for the txt character(s)
				$tj .= $optx;
				$last_fontid = $fontid;
				$last_fontstretch = $fontstretch;
				$fontstretch = 100;
			}

			$lastYPlacement = $YPlacement;
		}


		// Finish up
		if ($sipset) {
			$tj .= '>';
			if ($XshiftAfter) {
				$tj .= sprintf('%d', (-$XshiftAfter));
			}
			if ($last_fontid != $original_fontid) {
				$tj .= '] TJ ';
				$tj .= sprintf(' /F%d %.3F Tf ', $original_fontid, $fontsize);
				$tj .= '[';
			}
			$tj = preg_replace('/([^\\\])<>/', '\\1 ', $tj);
		} else {
			$tj .= ')';
			if ($XshiftAfter) {
				$tj .= sprintf('%d', (-$XshiftAfter));
			}
			if ($last_fontid != $original_fontid) {
				$tj .= '] TJ ';
				$tj .= sprintf(' /F%d %.3F Tf ', $original_fontid, $fontsize);
				$tj .= '[';
			}
			$tj = preg_replace('/([^\\\])\(\)/', '\\1 ', $tj);
		}


		$s = sprintf(' BT ' . $aix . ' 0 Tc 0 Tw [%s] TJ ET ', $x, $y, $tj);

		//echo $s."\n\n"; // exit;

		return $s;
	}

	function _kern($txt, $mode, $aix, $x, $y)
	{
		if ($mode == 'MBTw') { // Multibyte requiring word spacing
			$space = ' ';
			//Convert string to UTF-16BE without BOM
			$space = $this->UTF8ToUTF16BE($space, false);
			$space = $this->_escape($space);
			$s = sprintf(' BT ' . $aix, $x * _MPDFK, ($this->h - $y) * _MPDFK);
			$t = explode(' ', $txt);
			for ($i = 0; $i < count($t); $i++) {
				$tx = $t[$i];

				$tj = '(';
				$unicode = $this->UTF8StringToArray($tx);
				for ($ti = 0; $ti < count($unicode); $ti++) {
					if ($ti > 0 && isset($this->CurrentFont['kerninfo'][$unicode[($ti - 1)]][$unicode[$ti]])) {
						$kern = -$this->CurrentFont['kerninfo'][$unicode[($ti - 1)]][$unicode[$ti]];
						$tj .= sprintf(')%d(', $kern);
					}
					$tc = code2utf($unicode[$ti]);
					$tc = $this->UTF8ToUTF16BE($tc, false);
					$tj .= $this->_escape($tc);
				}
				$tj .= ')';
				$s.=sprintf(' %.3F Tc [%s] TJ', $this->charspacing, $tj);


				if (($i + 1) < count($t)) {
					$s.=sprintf(' %.3F Tc (%s) Tj', $this->ws + $this->charspacing, $space);
				}
			}
			$s.=' ET ';
		} elseif (!$this->usingCoreFont) {
			$s = '';
			$tj = '(';
			$unicode = $this->UTF8StringToArray($txt);
			for ($i = 0; $i < count($unicode); $i++) {
				if ($i > 0 && isset($this->CurrentFont['kerninfo'][$unicode[($i - 1)]][$unicode[$i]])) {
					$kern = -$this->CurrentFont['kerninfo'][$unicode[($i - 1)]][$unicode[$i]];
					$tj .= sprintf(')%d(', $kern);
				}
				$tx = code2utf($unicode[$i]);
				$tx = $this->UTF8ToUTF16BE($tx, false);
				$tj .= $this->_escape($tx);
			}
			$tj .= ')';
			$s.=sprintf(' BT ' . $aix . ' [%s] TJ ET ', $x * _MPDFK, ($this->h - $y) * _MPDFK, $tj);
		} else { // CORE Font
			$s = '';
			$tj = '(';
			$l = strlen($txt);
			for ($i = 0; $i < $l; $i++) {
				if ($i > 0 && isset($this->CurrentFont['kerninfo'][$txt[($i - 1)]][$txt[$i]])) {
					$kern = -$this->CurrentFont['kerninfo'][$txt[($i - 1)]][$txt[$i]];
					$tj .= sprintf(')%d(', $kern);
				}
				$tj .= $this->_escape($txt[$i]);
			}
			$tj .= ')';
			$s.=sprintf(' BT ' . $aix . ' [%s] TJ ET ', $x * _MPDFK, ($this->h - $y) * _MPDFK, $tj);
		}

		return $s;
	}

	function MultiCell($w, $h, $txt, $border = 0, $align = '', $fill = 0, $link = '', $directionality = 'ltr', $encoded = false, $OTLdata = false, $maxrows = false)
	{
		// maxrows is called from mpdfform->TEXTAREA
		// Parameter (pre-)encoded - When called internally from form::textarea - mb_encoding already done and OTL - but not reverse RTL
		if (!$encoded) {
			$txt = $this->purify_utf8_text($txt);
			if ($this->text_input_as_HTML) {
				$txt = $this->all_entities_to_utf8($txt);
			}
			if ($this->usingCoreFont) {
				$txt = mb_convert_encoding($txt, $this->mb_enc, 'UTF-8');
			}
			if (preg_match("/([" . $this->pregRTLchars . "])/u", $txt)) {
				$this->biDirectional = true;
			} // *OTL*
			/* -- OTL -- */
			$OTLdata = array();
			// Use OTL OpenType Table Layout - GSUB & GPOS
			if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
				$txt = $this->otl->applyOTL($txt, $this->CurrentFont['useOTL']);
				$OTLdata = $this->otl->OTLdata;
			}
			if ($directionality == 'rtl' || $this->biDirectional) {
				if (!isset($OTLdata)) {
					$unicode = $this->UTF8StringToArray($txt, false);
					$is_strong = false;
					$this->getBasicOTLdata($OTLdata, $unicode, $is_strong);
				}
			}
			/* -- END OTL -- */
		}
		if (!$align) {
			$align = $this->defaultAlign;
		}

		//Output text with automatic or explicit line breaks
		$cw = &$this->CurrentFont['cw'];
		if ($w == 0)
			$w = $this->w - $this->rMargin - $this->x;

		$wmax = ($w - ($this->cMarginL + $this->cMarginR));
		if ($this->usingCoreFont) {
			$s = str_replace("\r", '', $txt);
			$nb = strlen($s);
			while ($nb > 0 and $s[$nb - 1] == "\n")
				$nb--;
		} else {
			$s = str_replace("\r", '', $txt);
			$nb = mb_strlen($s, $this->mb_enc);
			while ($nb > 0 and mb_substr($s, $nb - 1, 1, $this->mb_enc) == "\n")
				$nb--;
		}
		$b = 0;
		if ($border) {
			if ($border == 1) {
				$border = 'LTRB';
				$b = 'LRT';
				$b2 = 'LR';
			} else {
				$b2 = '';
				if (is_int(strpos($border, 'L')))
					$b2.='L';
				if (is_int(strpos($border, 'R')))
					$b2.='R';
				$b = is_int(strpos($border, 'T')) ? $b2 . 'T' : $b2;
			}
		}
		$sep = -1;
		$i = 0;
		$j = 0;
		$l = 0;
		$ns = 0;
		$nl = 1;

		$rows = 0;
		$start_y = $this->y;

		if (!$this->usingCoreFont) {
			$inclCursive = false;
			if (preg_match("/([" . $this->pregCURSchars . "])/u", $s)) {
				$inclCursive = true;
			}
			while ($i < $nb) {
				//Get next character
				$c = mb_substr($s, $i, 1, $this->mb_enc);
				if ($c == "\n") {
					//Explicit line break
					// WORD SPACING
					$this->ResetSpacing();
					$tmp = rtrim(mb_substr($s, $j, $i - $j, $this->mb_enc));
					$tmpOTLdata = false;
					/* -- OTL -- */
					if (isset($OTLdata)) {
						$tmpOTLdata = $this->otl->sliceOTLdata($OTLdata, $j, $i - $j);
						$this->otl->trimOTLdata($tmpOTLdata, false, true);
						$this->magic_reverse_dir($tmp, $directionality, $tmpOTLdata);
					}
					/* -- END OTL -- */
					$this->Cell($w, $h, $tmp, $b, 2, $align, $fill, $link, 0, 0, 0, 'M', 0, false, $tmpOTLdata);
					if ($maxrows != false && isset($this->mpdfform) && ($this->y - $start_y) / $h > $maxrows) {
						return false;
					}
					$i++;
					$sep = -1;
					$j = $i;
					$l = 0;
					$ns = 0;
					$nl++;
					if ($border and $nl == 2)
						$b = $b2;
					continue;
				}
				if ($c == " ") {
					$sep = $i;
					$ls = $l;
					$ns++;
				}

				$l += $this->GetCharWidthNonCore($c);

				if ($l > $wmax) {
					//Automatic line break
					if ($sep == -1) { // Only one word
						if ($i == $j)
							$i++;
						// WORD SPACING
						$this->ResetSpacing();
						$tmp = rtrim(mb_substr($s, $j, $i - $j, $this->mb_enc));
						$tmpOTLdata = false;
						/* -- OTL -- */
						if (isset($OTLdata)) {
							$tmpOTLdata = $this->otl->sliceOTLdata($OTLdata, $j, $i - $j);
							$this->otl->trimOTLdata($tmpOTLdata, false, true);
							$this->magic_reverse_dir($tmp, $directionality, $tmpOTLdata);
						}
						/* -- END OTL -- */
						$this->Cell($w, $h, $tmp, $b, 2, $align, $fill, $link, 0, 0, 0, 'M', 0, false, $tmpOTLdata);
					} else {
						$tmp = rtrim(mb_substr($s, $j, $sep - $j, $this->mb_enc));
						$tmpOTLdata = false;
						/* -- OTL -- */
						if (isset($OTLdata)) {
							$tmpOTLdata = $this->otl->sliceOTLdata($OTLdata, $j, $sep - $j);
							$this->otl->trimOTLdata($tmpOTLdata, false, true);
						}
						/* -- END OTL -- */
						if ($align == 'J') {
							//////////////////////////////////////////
							// JUSTIFY J using Unicode fonts (Word spacing doesn't work)
							// WORD SPACING UNICODE
							// Change NON_BREAKING SPACE to spaces so they are 'spaced' properly
							$tmp = str_replace(chr(194) . chr(160), chr(32), $tmp);
							$len_ligne = $this->GetStringWidth($tmp, false, $tmpOTLdata);
							$nb_carac = mb_strlen($tmp, $this->mb_enc);
							$nb_spaces = mb_substr_count($tmp, ' ', $this->mb_enc);
							// Take off number of Marks
							// Use GPOS OTL
							if (isset($this->CurrentFont['useOTL']) && ($this->CurrentFont['useOTL'])) {
								if (isset($tmpOTLdata['group']) && $tmpOTLdata['group']) {
									$nb_carac -= substr_count($tmpOTLdata['group'], 'M');
								}
							}

							list($charspacing, $ws, $kashida) = $this->GetJspacing($nb_carac, $nb_spaces, ((($wmax) - $len_ligne) * _MPDFK), $inclCursive, $tmpOTLdata);
							$this->SetSpacing($charspacing, $ws);
							//////////////////////////////////////////
						}
						if (isset($OTLdata)) {
							$this->magic_reverse_dir($tmp, $directionality, $tmpOTLdata);
						}
						$this->Cell($w, $h, $tmp, $b, 2, $align, $fill, $link, 0, 0, 0, 'M', 0, false, $tmpOTLdata);
						$i = $sep + 1;
					}
					if ($maxrows != false && isset($this->mpdfform) && ($this->y - $start_y) / $h > $maxrows) {
						return false;
					}
					$sep = -1;
					$j = $i;
					$l = 0;
					$ns = 0;
					$nl++;
					if ($border and $nl == 2)
						$b = $b2;
				} else
					$i++;
			}
			//Last chunk
			// WORD SPACING

			$this->ResetSpacing();
		}


		else {

			while ($i < $nb) {
				//Get next character
				$c = $s[$i];
				if ($c == "\n") {
					//Explicit line break
					// WORD SPACING
					$this->ResetSpacing();
					$this->Cell($w, $h, substr($s, $j, $i - $j), $b, 2, $align, $fill, $link);
					if ($maxrows != false && isset($this->mpdfform) && ($this->y - $start_y) / $h > $maxrows) {
						return false;
					}
					$i++;
					$sep = -1;
					$j = $i;
					$l = 0;
					$ns = 0;
					$nl++;
					if ($border and $nl == 2)
						$b = $b2;
					continue;
				}
				if ($c == " ") {
					$sep = $i;
					$ls = $l;
					$ns++;
				}

				$l += $this->GetCharWidthCore($c);
				if ($l > $wmax) {
					//Automatic line break
					if ($sep == -1) {
						if ($i == $j)
							$i++;
						// WORD SPACING
						$this->ResetSpacing();
						$this->Cell($w, $h, substr($s, $j, $i - $j), $b, 2, $align, $fill, $link);
					}
					else {
						if ($align == 'J') {
							$tmp = rtrim(substr($s, $j, $sep - $j));
							//////////////////////////////////////////
							// JUSTIFY J using Unicode fonts (Word spacing doesn't work)
							// WORD SPACING NON_UNICODE/CJK
							// Change NON_BREAKING SPACE to spaces so they are 'spaced' properly
							$tmp = str_replace(chr(160), chr(32), $tmp);
							$len_ligne = $this->GetStringWidth($tmp);
							$nb_carac = strlen($tmp);
							$nb_spaces = substr_count($tmp, ' ');
							$tmpOTLdata = array();
							list($charspacing, $ws, $kashida) = $this->GetJspacing($nb_carac, $nb_spaces, ((($wmax) - $len_ligne) * _MPDFK), false, $tmpOTLdata);
							$this->SetSpacing($charspacing, $ws);
							//////////////////////////////////////////
						}
						$this->Cell($w, $h, substr($s, $j, $sep - $j), $b, 2, $align, $fill, $link);
						$i = $sep + 1;
					}
					if ($maxrows != false && isset($this->mpdfform) && ($this->y - $start_y) / $h > $maxrows) {
						return false;
					}
					$sep = -1;
					$j = $i;
					$l = 0;
					$ns = 0;
					$nl++;
					if ($border and $nl == 2)
						$b = $b2;
				} else
					$i++;
			}
			//Last chunk
			// WORD SPACING

			$this->ResetSpacing();
		}
		//Last chunk
		if ($border and is_int(strpos($border, 'B')))
			$b.='B';
		if (!$this->usingCoreFont) {
			$tmp = rtrim(mb_substr($s, $j, $i - $j, $this->mb_enc));
			$tmpOTLdata = false;
			/* -- OTL -- */
			if (isset($OTLdata)) {
				$tmpOTLdata = $this->otl->sliceOTLdata($OTLdata, $j, $i - $j);
				$this->otl->trimOTLdata($tmpOTLdata, false, true);
				$this->magic_reverse_dir($tmp, $directionality, $tmpOTLdata);
			}
			/* -- END OTL -- */
			$this->Cell($w, $h, $tmp, $b, 2, $align, $fill, $link, 0, 0, 0, 'M', 0, false, $tmpOTLdata);
		} else {
			$this->Cell($w, $h, substr($s, $j, $i - $j), $b, 2, $align, $fill, $link);
		}
		$this->x = $this->lMargin;
	}

	/* -- DIRECTW -- */

	function Write($h, $txt, $currentx = 0, $link = '', $directionality = 'ltr', $align = '')
	{
		if (!class_exists('directw', false)) {
			include(_MPDF_PATH . 'classes/directw.php');
		}
		if (empty($this->directw)) {
			$this->directw = new directw($this);
		}
		$this->directw->Write($h, $txt, $currentx, $link, $directionality, $align);
	}

	/* -- END DIRECTW -- */


	/* -- HTML-CSS -- */

	function saveInlineProperties()
	{
		$saved = array();
		$saved['family'] = $this->FontFamily;
		$saved['style'] = $this->FontStyle;
		$saved['sizePt'] = $this->FontSizePt;
		$saved['size'] = $this->FontSize;
		$saved['HREF'] = $this->HREF;
		$saved['textvar'] = $this->textvar; // mPDF 5.7.1
		$saved['OTLtags'] = $this->OTLtags; // mPDF 5.7.1
		$saved['textshadow'] = $this->textshadow;
		$saved['linewidth'] = $this->LineWidth;
		$saved['drawcolor'] = $this->DrawColor;
		$saved['textparam'] = $this->textparam;
		$saved['lSpacingCSS'] = $this->lSpacingCSS;
		$saved['wSpacingCSS'] = $this->wSpacingCSS;
		$saved['I'] = $this->I;
		$saved['B'] = $this->B;
		$saved['colorarray'] = $this->colorarray;
		$saved['bgcolorarray'] = $this->spanbgcolorarray;
		$saved['border'] = $this->spanborddet;
		$saved['color'] = $this->TextColor;
		$saved['bgcolor'] = $this->FillColor;
		$saved['lang'] = $this->currentLang;
		$saved['fontLanguageOverride'] = $this->fontLanguageOverride; // mPDF 5.7.1
		$saved['display_off'] = $this->inlineDisplayOff;

		return $saved;
	}

	function restoreInlineProperties(&$saved)
	{
		$FontFamily = $saved['family'];
		$this->FontStyle = $saved['style'];
		$this->FontSizePt = $saved['sizePt'];
		$this->FontSize = $saved['size'];

		$this->currentLang = $saved['lang'];
		$this->fontLanguageOverride = $saved['fontLanguageOverride']; // mPDF 5.7.1

		$this->ColorFlag = ($this->FillColor != $this->TextColor); //Restore ColorFlag as well

		$this->HREF = $saved['HREF'];
		$this->textvar = $saved['textvar']; // mPDF 5.7.1
		$this->OTLtags = $saved['OTLtags']; // mPDF 5.7.1
		$this->textshadow = $saved['textshadow'];
		$this->LineWidth = $saved['linewidth'];
		$this->DrawColor = $saved['drawcolor'];
		$this->textparam = $saved['textparam'];
		$this->inlineDisplayOff = $saved['display_off'];

		$this->lSpacingCSS = $saved['lSpacingCSS'];
		if (($this->lSpacingCSS || $this->lSpacingCSS === '0') && strtoupper($this->lSpacingCSS) != 'NORMAL') {
			$this->fixedlSpacing = $this->ConvertSize($this->lSpacingCSS, $this->FontSize);
		} else {
			$this->fixedlSpacing = false;
		}
		$this->wSpacingCSS = $saved['wSpacingCSS'];
		if ($this->wSpacingCSS && strtoupper($this->wSpacingCSS) != 'NORMAL') {
			$this->minwSpacing = $this->ConvertSize($this->wSpacingCSS, $this->FontSize);
		} else {
			$this->minwSpacing = 0;
		}

		$this->SetFont($FontFamily, $saved['style'], $saved['sizePt'], false);

		$this->currentfontstyle = $saved['style'];
		$this->currentfontsize = $saved['sizePt'];
		$this->SetStylesArray(array('B' => $saved['B'], 'I' => $saved['I'])); // mPDF 5.7.1

		$this->TextColor = $saved['color'];
		$this->FillColor = $saved['bgcolor'];
		$this->colorarray = $saved['colorarray'];
		$cor = $saved['colorarray'];
		if ($cor)
			$this->SetTColor($cor);
		$this->spanbgcolorarray = $saved['bgcolorarray'];
		$cor = $saved['bgcolorarray'];
		if ($cor)
			$this->SetFColor($cor);
		$this->spanborddet = $saved['border'];
	}

	// Used when ColActive for tables - updated to return first block with background fill OR borders
	function GetFirstBlockFill()
	{
		// Returns the first blocklevel that uses a bgcolor fill
		$startfill = 0;
		for ($i = 1; $i <= $this->blklvl; $i++) {
			if ($this->blk[$i]['bgcolor'] || $this->blk[$i]['border_left']['w'] || $this->blk[$i]['border_right']['w'] || $this->blk[$i]['border_top']['w'] || $this->blk[$i]['border_bottom']['w']) {
				$startfill = $i;
				break;
			}
		}
		return $startfill;
	}

	//-------------------------FLOWING BLOCK------------------------------------//
	//The following functions were originally written by Damon Kohler           //
	//--------------------------------------------------------------------------//

	function saveFont()
	{
		$saved = array();
		$saved['family'] = $this->FontFamily;
		$saved['style'] = $this->FontStyle;
		$saved['sizePt'] = $this->FontSizePt;
		$saved['size'] = $this->FontSize;
		$saved['curr'] = &$this->CurrentFont;
		$saved['lang'] = $this->currentLang; // mPDF 6
		$saved['color'] = $this->TextColor;
		$saved['spanbgcolor'] = $this->spanbgcolor;
		$saved['spanbgcolorarray'] = $this->spanbgcolorarray;
		$saved['bord'] = $this->spanborder;
		$saved['border'] = $this->spanborddet;
		$saved['HREF'] = $this->HREF;
		$saved['textvar'] = $this->textvar; // mPDF 5.7.1
		$saved['textshadow'] = $this->textshadow;
		$saved['linewidth'] = $this->LineWidth;
		$saved['drawcolor'] = $this->DrawColor;
		$saved['textparam'] = $this->textparam;
		$saved['ReqFontStyle'] = $this->ReqFontStyle;
		$saved['fixedlSpacing'] = $this->fixedlSpacing;
		$saved['minwSpacing'] = $this->minwSpacing;
		return $saved;
	}

	function restoreFont(&$saved, $write = true)
	{
		if (!isset($saved) || empty($saved))
			return;

		$this->FontFamily = $saved['family'];
		$this->FontStyle = $saved['style'];
		$this->FontSizePt = $saved['sizePt'];
		$this->FontSize = $saved['size'];
		$this->CurrentFont = &$saved['curr'];
		$this->currentLang = $saved['lang']; // mPDF 6
		$this->TextColor = $saved['color'];
		$this->spanbgcolor = $saved['spanbgcolor'];
		$this->spanbgcolorarray = $saved['spanbgcolorarray'];
		$this->spanborder = $saved['bord'];
		$this->spanborddet = $saved['border'];
		$this->ColorFlag = ($this->FillColor != $this->TextColor); //Restore ColorFlag as well
		$this->HREF = $saved['HREF'];
		$this->fixedlSpacing = $saved['fixedlSpacing'];
		$this->minwSpacing = $saved['minwSpacing'];
		$this->textvar = $saved['textvar'];  // mPDF 5.7.1
		$this->textshadow = $saved['textshadow'];
		$this->LineWidth = $saved['linewidth'];
		$this->DrawColor = $saved['drawcolor'];
		$this->textparam = $saved['textparam'];
		if ($write) {
			$this->SetFont($saved['family'], $saved['style'], $saved['sizePt'], true, true); // force output
			$fontout = (sprintf('BT /F%d %.3F Tf ET', $this->CurrentFont['i'], $this->FontSizePt));
			if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['Font']) && $this->pageoutput[$this->page]['Font'] != $fontout) || !isset($this->pageoutput[$this->page]['Font']))) {
				$this->_out($fontout);
			}
			$this->pageoutput[$this->page]['Font'] = $fontout;
		} else
			$this->SetFont($saved['family'], $saved['style'], $saved['sizePt'], false);
		$this->ReqFontStyle = $saved['ReqFontStyle'];
	}

	function newFlowingBlock($w, $h, $a = '', $is_table = false, $blockstate = 0, $newblock = true, $blockdir = 'ltr', $table_draft = false)
	{
		if (!$a) {
			if ($blockdir == 'rtl') {
				$a = 'R';
			} else {
				$a = 'L';
			}
		}
		$this->flowingBlockAttr['width'] = ($w * _MPDFK);
		// line height in user units
		$this->flowingBlockAttr['is_table'] = $is_table;
		$this->flowingBlockAttr['table_draft'] = $table_draft;
		$this->flowingBlockAttr['height'] = $h;
		$this->flowingBlockAttr['lineCount'] = 0;
		$this->flowingBlockAttr['align'] = $a;
		$this->flowingBlockAttr['font'] = array();
		$this->flowingBlockAttr['content'] = array();
		$this->flowingBlockAttr['contentB'] = array();
		$this->flowingBlockAttr['contentWidth'] = 0;
		$this->flowingBlockAttr['blockstate'] = $blockstate;

		$this->flowingBlockAttr['newblock'] = $newblock;
		$this->flowingBlockAttr['valign'] = 'M';
		$this->flowingBlockAttr['blockdir'] = $blockdir;
		$this->flowingBlockAttr['cOTLdata'] = array(); // mPDF 5.7.1
		$this->flowingBlockAttr['lastBidiText'] = ''; // mPDF 5.7.1
		if (!empty($this->otl)) {
			$this->otl->lastBidiStrongType = '';
		} // *OTL*
	}

	function finishFlowingBlock($endofblock = false, $next = '')
	{
		$currentx = $this->x;
		//prints out the last chunk
		$is_table = $this->flowingBlockAttr['is_table'];
		$table_draft = $this->flowingBlockAttr['table_draft'];
		$maxWidth = & $this->flowingBlockAttr['width'];
		$stackHeight = & $this->flowingBlockAttr['height'];
		$align = & $this->flowingBlockAttr['align'];
		$content = & $this->flowingBlockAttr['content'];
		$contentB = & $this->flowingBlockAttr['contentB'];
		$font = & $this->flowingBlockAttr['font'];
		$contentWidth = & $this->flowingBlockAttr['contentWidth'];
		$lineCount = & $this->flowingBlockAttr['lineCount'];
		$valign = & $this->flowingBlockAttr['valign'];
		$blockstate = $this->flowingBlockAttr['blockstate'];

		$cOTLdata = & $this->flowingBlockAttr['cOTLdata']; // mPDF 5.7.1
		$newblock = $this->flowingBlockAttr['newblock'];
		$blockdir = $this->flowingBlockAttr['blockdir'];

		// *********** BLOCK BACKGROUND COLOR *****************//
		if ($this->blk[$this->blklvl]['bgcolor'] && !$is_table) {
			$fill = 0;
		} else {
			$this->SetFColor($this->ConvertColor(255));
			$fill = 0;
		}

		$hanger = '';
		// Always right trim!
		// Right trim last content and adjust width if needed to justify (later)
		if (isset($content[count($content) - 1]) && preg_match('/[ ]+$/', $content[count($content) - 1], $m)) {
			$strip = strlen($m[0]);
			$content[count($content) - 1] = substr($content[count($content) - 1], 0, (strlen($content[count($content) - 1]) - $strip));
			/* -- OTL -- */
			if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
				$this->otl->trimOTLdata($cOTLdata[count($cOTLdata) - 1], false, true);
			}
			/* -- END OTL -- */
		}

		// the amount of space taken up so far in user units
		$usedWidth = 0;

		// COLS
		$oldcolumn = $this->CurrCol;

		if ($this->ColActive && !$is_table) {
			$this->breakpoints[$this->CurrCol][] = $this->y;
		} // *COLUMNS*
		// Print out each chunk

		/* -- TABLES -- */
		if ($is_table) {
			$ipaddingL = 0;
			$ipaddingR = 0;
			$paddingL = 0;
			$paddingR = 0;
		} else {
			/* -- END TABLES -- */
			$ipaddingL = $this->blk[$this->blklvl]['padding_left'];
			$ipaddingR = $this->blk[$this->blklvl]['padding_right'];
			$paddingL = ($ipaddingL * _MPDFK);
			$paddingR = ($ipaddingR * _MPDFK);
			$this->cMarginL = $this->blk[$this->blklvl]['border_left']['w'];
			$this->cMarginR = $this->blk[$this->blklvl]['border_right']['w'];

			// Added mPDF 3.0 Float DIV
			$fpaddingR = 0;
			$fpaddingL = 0;
			/* -- CSS-FLOAT -- */
			if (count($this->floatDivs)) {
				list($l_exists, $r_exists, $l_max, $r_max, $l_width, $r_width) = $this->GetFloatDivInfo($this->blklvl);
				if ($r_exists) {
					$fpaddingR = $r_width;
				}
				if ($l_exists) {
					$fpaddingL = $l_width;
				}
			}
			/* -- END CSS-FLOAT -- */

			$usey = $this->y + 0.002;
			if (($newblock) && ($blockstate == 1 || $blockstate == 3) && ($lineCount == 0)) {
				$usey += $this->blk[$this->blklvl]['margin_top'] + $this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['border_top']['w'];
			}
			/* -- CSS-IMAGE-FLOAT -- */
			// If float exists at this level
			if (isset($this->floatmargins['R']) && $usey <= $this->floatmargins['R']['y1'] && $usey >= $this->floatmargins['R']['y0'] && !$this->floatmargins['R']['skipline']) {
				$fpaddingR += $this->floatmargins['R']['w'];
			}
			if (isset($this->floatmargins['L']) && $usey <= $this->floatmargins['L']['y1'] && $usey >= $this->floatmargins['L']['y0'] && !$this->floatmargins['L']['skipline']) {
				$fpaddingL += $this->floatmargins['L']['w'];
			}
			/* -- END CSS-IMAGE-FLOAT -- */
		} // *TABLES*


		$lineBox = array();

		$this->_setInlineBlockHeights($lineBox, $stackHeight, $content, $font, $is_table);

		if ($is_table && count($content) == 0) {
			$stackHeight = 0;
		}

		if ($table_draft) {
			$this->y += $stackHeight;
			$this->objectbuffer = array();
			return 0;
		}

		// While we're at it, check if contains cursive text
		// Change NBSP to SPACE.
		// Re-calculate contentWidth
		$contentWidth = 0;

		foreach ($content as $k => $chunk) {
			$this->restoreFont($font[$k], false);
			if (!isset($this->objectbuffer[$k]) || (isset($this->objectbuffer[$k]) && !$this->objectbuffer[$k])) {
				// Soft Hyphens chr(173)
				if (!$this->usingCoreFont) {
					/* -- OTL -- */
					// mPDF 5.7.1
					if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
						$this->otl->removeChar($chunk, $cOTLdata[$k], "\xc2\xad");
						$this->otl->replaceSpace($chunk, $cOTLdata[$k]);
						$content[$k] = $chunk;
					}
					/* -- END OTL -- */ else {  // *OTL*
						$content[$k] = $chunk = str_replace("\xc2\xad", '', $chunk);
						$content[$k] = $chunk = str_replace(chr(194) . chr(160), chr(32), $chunk);
					} // *OTL*
				} elseif ($this->FontFamily != 'csymbol' && $this->FontFamily != 'czapfdingbats') {
					$content[$k] = $chunk = str_replace(chr(173), '', $chunk);
					$content[$k] = $chunk = str_replace(chr(160), chr(32), $chunk);
				}
				$contentWidth += $this->GetStringWidth($chunk, true, (isset($cOTLdata[$k]) ? $cOTLdata[$k] : false), $this->textvar) * _MPDFK;
			} elseif (isset($this->objectbuffer[$k]) && $this->objectbuffer[$k]) {
				// LIST MARKERS	// mPDF 6  Lists
				if ($this->objectbuffer[$k]['type'] == 'image' && isset($this->objectbuffer[$k]['listmarker']) && $this->objectbuffer[$k]['listmarker'] && $this->objectbuffer[$k]['listmarkerposition'] == 'outside') {
					// do nothing
				} else {
					$contentWidth += $this->objectbuffer[$k]['OUTER-WIDTH'] * _MPDFK;
				}
			}
		}

		if (isset($font[count($font) - 1])) {
			$lastfontreqstyle = (isset($font[count($font) - 1]['ReqFontStyle']) ? $font[count($font) - 1]['ReqFontStyle'] : '');
			$lastfontstyle = (isset($font[count($font) - 1]['style']) ? $font[count($font) - 1]['style'] : '');
		} else {
			$lastfontreqstyle = null;
			$lastfontstyle = null;
		}
		if ($blockdir == 'ltr' && strpos($lastfontreqstyle, "I") !== false && strpos($lastfontstyle, "I") === false) { // Artificial italic
			$lastitalic = $this->FontSize * 0.15 * _MPDFK;
		} else {
			$lastitalic = 0;
		}

		// Get PAGEBREAK TO TEST for height including the bottom border/padding
		$check_h = max($this->divheight, $stackHeight);

		// This fixes a proven bug...
		if ($endofblock && $newblock && $blockstate == 0 && !$content) {
			$check_h = 0;
		}
		// but ? needs to fix potentially more widespread...
		//	if (!$content) {  $check_h = 0; }

		if ($this->blklvl > 0 && !$is_table) {
			if ($endofblock && $blockstate > 1) {
				if ($this->blk[$this->blklvl]['page_break_after_avoid']) {
					$check_h += $stackHeight;
				}
				$check_h += ($this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['border_bottom']['w']);
			}
			if (($newblock && ($blockstate == 1 || $blockstate == 3) && $lineCount == 0) || ($endofblock && $blockstate == 3 && $lineCount == 0)) {
				$check_h += ($this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['margin_top'] + $this->blk[$this->blklvl]['border_top']['w']);
			}
		}

		// Force PAGE break if column height cannot take check-height
		if ($this->ColActive && $check_h > ($this->PageBreakTrigger - $this->y0)) {
			$this->SetCol($this->NbCol - 1);
		}

		// Avoid just border/background-color moved on to next page
		if ($endofblock && $blockstate > 1 && !$content) {
			$buff = $this->margBuffer;
		} else {
			$buff = 0;
		}


		// PAGEBREAK
		if (!$is_table && ($this->y + $check_h) > ($this->PageBreakTrigger + $buff) and ! $this->InFooter and $this->AcceptPageBreak()) {
			$bak_x = $this->x; //Current X position
			// WORD SPACING
			$ws = $this->ws; //Word Spacing
			$charspacing = $this->charspacing; //Character Spacing
			$this->ResetSpacing();

			$this->AddPage($this->CurOrientation);

			$this->x = $bak_x;
			// Added to correct for OddEven Margins
			$currentx += $this->MarginCorrection;
			$this->x += $this->MarginCorrection;

			// WORD SPACING
			$this->SetSpacing($charspacing, $ws);
		}


		/* -- COLUMNS -- */
		// COLS
		// COLUMN CHANGE
		if ($this->CurrCol != $oldcolumn) {
			$currentx += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
			$this->x += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
			$oldcolumn = $this->CurrCol;
		}


		if ($this->ColActive && !$is_table) {
			$this->breakpoints[$this->CurrCol][] = $this->y;
		}
		/* -- END COLUMNS -- */

		// TOP MARGIN
		if ($newblock && ($blockstate == 1 || $blockstate == 3) && ($this->blk[$this->blklvl]['margin_top']) && $lineCount == 0 && !$is_table) {
			$this->DivLn($this->blk[$this->blklvl]['margin_top'], $this->blklvl - 1, true, $this->blk[$this->blklvl]['margin_collapse']);
			if ($this->ColActive) {
				$this->breakpoints[$this->CurrCol][] = $this->y;
			} // *COLUMNS*
		}

		if ($newblock && ($blockstate == 1 || $blockstate == 3) && $lineCount == 0 && !$is_table) {
			$this->blk[$this->blklvl]['y0'] = $this->y;
			$this->blk[$this->blklvl]['startpage'] = $this->page;
			if ($this->blk[$this->blklvl]['float']) {
				$this->blk[$this->blklvl]['float_start_y'] = $this->y;
			}
			if ($this->ColActive) {
				$this->breakpoints[$this->CurrCol][] = $this->y;
			} // *COLUMNS*
		}

		// Paragraph INDENT
		$WidthCorrection = 0;
		if (($newblock) && ($blockstate == 1 || $blockstate == 3) && isset($this->blk[$this->blklvl]['text_indent']) && ($lineCount == 0) && (!$is_table) && ($align != 'C')) {
			$ti = $this->ConvertSize($this->blk[$this->blklvl]['text_indent'], $this->blk[$this->blklvl]['inner_width'], $this->blk[$this->blklvl]['InlineProperties']['size'], false);  // mPDF 5.7.4
			$WidthCorrection = ($ti * _MPDFK);
		}


		// PADDING and BORDER spacing/fill
		if (($newblock) && ($blockstate == 1 || $blockstate == 3) && (($this->blk[$this->blklvl]['padding_top']) || ($this->blk[$this->blklvl]['border_top'])) && ($lineCount == 0) && (!$is_table)) {
			// $state = 0 normal; 1 top; 2 bottom; 3 top and bottom
			$this->DivLn($this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['border_top']['w'], -3, true, false, 1);
			if ($this->ColActive) {
				$this->breakpoints[$this->CurrCol][] = $this->y;
			} // *COLUMNS*
			$this->x = $currentx;
		}


		// Added mPDF 3.0 Float DIV
		$fpaddingR = 0;
		$fpaddingL = 0;
		/* -- CSS-FLOAT -- */
		if (count($this->floatDivs)) {
			list($l_exists, $r_exists, $l_max, $r_max, $l_width, $r_width) = $this->GetFloatDivInfo($this->blklvl);
			if ($r_exists) {
				$fpaddingR = $r_width;
			}
			if ($l_exists) {
				$fpaddingL = $l_width;
			}
		}
		/* -- END CSS-FLOAT -- */

		$usey = $this->y + 0.002;
		if (($newblock) && ($blockstate == 1 || $blockstate == 3) && ($lineCount == 0)) {
			$usey += $this->blk[$this->blklvl]['margin_top'] + $this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['border_top']['w'];
		}
		/* -- CSS-IMAGE-FLOAT -- */
		// If float exists at this level
		if (isset($this->floatmargins['R']) && $usey <= $this->floatmargins['R']['y1'] && $usey >= $this->floatmargins['R']['y0'] && !$this->floatmargins['R']['skipline']) {
			$fpaddingR += $this->floatmargins['R']['w'];
		}
		if (isset($this->floatmargins['L']) && $usey <= $this->floatmargins['L']['y1'] && $usey >= $this->floatmargins['L']['y0'] && !$this->floatmargins['L']['skipline']) {
			$fpaddingL += $this->floatmargins['L']['w'];
		}
		/* -- END CSS-IMAGE-FLOAT -- */


		if ($content) {

			// In FinishFlowing Block no lines are justified as it is always last line
			// but if CJKorphan has allowed content width to go over max width, use J charspacing to compress line
			// JUSTIFICATION J - NOT!
			$nb_carac = 0;
			$nb_spaces = 0;
			$jcharspacing = 0;
			$jkashida = 0;
			$jws = 0;
			$inclCursive = false;
			$dottab = false;
			foreach ($content as $k => $chunk) {
				if (!isset($this->objectbuffer[$k]) || (isset($this->objectbuffer[$k]) && !$this->objectbuffer[$k])) {
					$nb_carac += mb_strlen($chunk, $this->mb_enc);
					$nb_spaces += mb_substr_count($chunk, ' ', $this->mb_enc);
					// mPDF 6
					// Use GPOS OTL
					$this->restoreFont($font[$k], false);
					if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
						if (isset($cOTLdata[$k]['group']) && $cOTLdata[$k]['group']) {
							$nb_marks = substr_count($cOTLdata[$k]['group'], 'M');
							$nb_carac -= $nb_marks;
						}
						if (preg_match("/([" . $this->pregCURSchars . "])/u", $chunk)) {
							$inclCursive = true;
						}
					}
				} else {
					$nb_carac ++;  // mPDF 6 allow spacing for inline object
					if ($this->objectbuffer[$k]['type'] == 'dottab') {
						$dottab = $this->objectbuffer[$k]['outdent'];
					}
				}
			}

			// DIRECTIONALITY RTL
			$chunkorder = range(0, count($content) - 1); // mPDF 6
			/* -- OTL -- */
			// mPDF 6
			if ($blockdir == 'rtl' || $this->biDirectional) {
				$this->otl->_bidiReorder($chunkorder, $content, $cOTLdata, $blockdir);
				// From this point on, $content and $cOTLdata may contain more elements (and re-ordered) compared to
				// $this->objectbuffer and $font ($chunkorder contains the mapping)
			}
			/* -- END OTL -- */

			// Remove any XAdvance from OTL data at end of line
			// And correct for XPlacement on last character
			// BIDI is applied
			foreach ($chunkorder AS $aord => $k) {
				if (count($cOTLdata)) {
					$this->restoreFont($font[$k], false);
					// ...FinishFlowingBlock...
					if ($aord == count($chunkorder) - 1 && isset($cOTLdata[$aord]['group'])) { // Last chunk on line
						$nGPOS = strlen($cOTLdata[$aord]['group']) - 1; // Last character
						if (isset($cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL']) || isset($cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceR'])) {
							if (isset($cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL'])) {
								$w = $cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL'] * 1000 / $this->CurrentFont['unitsPerEm'];
							} else {
								$w = $cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceR'] * 1000 / $this->CurrentFont['unitsPerEm'];
							}
							$w *= ($this->FontSize / 1000);
							$contentWidth -= $w * _MPDFK;
							$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL'] = 0;
							$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceR'] = 0;
						}

						// If last character has an XPlacement set, adjust width calculation, and add to XAdvance to account for it
						if (isset($cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XPlacement'])) {
							$w = -$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XPlacement'] * 1000 / $this->CurrentFont['unitsPerEm'];
							$w *= ($this->FontSize / 1000);
							$contentWidth -= $w * _MPDFK;
							$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL'] = $cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XPlacement'];
							$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceR'] = $cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XPlacement'];
						}
					}
				}
			}

			// if it's justified, we need to find the char/word spacing (or if orphans have allowed length of line to go over the maxwidth)
			// If "orphans" in fact is just a final space - ignore this
			$lastchar = mb_substr($content[(count($chunkorder) - 1)], mb_strlen($content[(count($chunkorder) - 1)], $this->mb_enc) - 1, 1, $this->mb_enc);
			if (preg_match("/[" . $this->CJKoverflow . "]/u", $lastchar)) {
				$CJKoverflow = true;
			} else {
				$CJKoverflow = false;
			}
			if ((((($contentWidth + $lastitalic) > $maxWidth) && ($content[(count($chunkorder) - 1)] != ' ') ) ||
				(!$endofblock && $align == 'J' && ($next == 'image' || $next == 'select' || $next == 'input' || $next == 'textarea' || ($next == 'br' && $this->justifyB4br)))) && !($CJKoverflow && $this->allowCJKoverflow)) {
				// WORD SPACING
				list($jcharspacing, $jws, $jkashida) = $this->GetJspacing($nb_carac, $nb_spaces, ($maxWidth - $lastitalic - $contentWidth - $WidthCorrection - (($this->cMarginL + $this->cMarginR) * _MPDFK) - ($paddingL + $paddingR + (($fpaddingL + $fpaddingR) * _MPDFK) )), $inclCursive, $cOTLdata);
			}
			/* -- CJK-FONTS -- */ elseif ($this->checkCJK && $align == 'J' && $CJKoverflow && $this->allowCJKoverflow && $this->CJKforceend) {
				// force-end overhang
				$hanger = mb_substr($content[(count($chunkorder) - 1)], mb_strlen($content[(count($chunkorder) - 1)], $this->mb_enc) - 1, 1, $this->mb_enc);
				if (preg_match("/[" . $this->CJKoverflow . "]/u", $hanger)) {
					$content[(count($chunkorder) - 1)] = mb_substr($content[(count($chunkorder) - 1)], 0, mb_strlen($content[(count($chunkorder) - 1)], $this->mb_enc) - 1, $this->mb_enc);
					$this->restoreFont($font[$chunkorder[count($chunkorder) - 1]], false);
					$contentWidth -= $this->GetStringWidth($hanger) * _MPDFK;
					$nb_carac -= 1;
					list($jcharspacing, $jws, $jkashida) = $this->GetJspacing($nb_carac, $nb_spaces, ($maxWidth - $lastitalic - $contentWidth - $WidthCorrection - (($this->cMarginL + $this->cMarginR) * _MPDFK) - ($paddingL + $paddingR + (($fpaddingL + $fpaddingR) * _MPDFK) )), $inclCursive, $cOTLdata);
				}
			}
			/* -- END CJK-FONTS -- */

			// Check if will fit at word/char spacing of previous line - if so continue it
			// but only allow a maximum of $this->jSmaxWordLast and $this->jSmaxCharLast
			elseif ($contentWidth < ($maxWidth - $lastitalic - $WidthCorrection - (($this->cMarginL + $this->cMarginR) * _MPDFK) - ($paddingL + $paddingR + (($fpaddingL + $fpaddingR) * _MPDFK))) && !$this->fixedlSpacing) {
				if ($this->ws > $this->jSmaxWordLast) {
					$jws = $this->jSmaxWordLast;
				}
				if ($this->charspacing > $this->jSmaxCharLast) {
					$jcharspacing = $this->jSmaxCharLast;
				}
				$check = $maxWidth - $lastitalic - $WidthCorrection - $contentWidth - (($this->cMarginL + $this->cMarginR) * _MPDFK) - ($paddingL + $paddingR + (($fpaddingL + $fpaddingR) * _MPDFK) ) - ( $jcharspacing * $nb_carac) - ( $jws * $nb_spaces);
				if ($check <= 0) {
					$jcharspacing = 0;
					$jws = 0;
				}
			}

			$empty = $maxWidth - $lastitalic - $WidthCorrection - $contentWidth - (($this->cMarginL + $this->cMarginR) * _MPDFK) - ($paddingL + $paddingR + (($fpaddingL + $fpaddingR) * _MPDFK) );


			$empty -= ($jcharspacing * ($nb_carac - 1)); // mPDF 6 nb_carac MINUS 1
			$empty -= ($jws * $nb_spaces);
			$empty -= ($jkashida);

			$empty /= _MPDFK;

			if (!$is_table) {
				$this->maxPosR = max($this->maxPosR, ($this->w - $this->rMargin - $this->blk[$this->blklvl]['outer_right_margin'] - $empty));
				$this->maxPosL = min($this->maxPosL, ($this->lMargin + $this->blk[$this->blklvl]['outer_left_margin'] + $empty));
			}

			$arraysize = count($chunkorder);

			$margins = ($this->cMarginL + $this->cMarginR) + ($ipaddingL + $ipaddingR + $fpaddingR + $fpaddingR );

			if (!$is_table) {
				$this->DivLn($stackHeight, $this->blklvl, false);
			} // false -> don't advance y

			$this->x = $currentx + $this->cMarginL + $ipaddingL + $fpaddingL;
			if ($dottab !== false && $blockdir == 'rtl') {
				$this->x -= $dottab;
			} elseif ($align == 'R') {
				$this->x += $empty;
			} elseif ($align == 'J' && $blockdir == 'rtl') {
				$this->x += $empty;
			} elseif ($align == 'C') {
				$this->x += ($empty / 2);
			}

			// Paragraph INDENT
			$WidthCorrection = 0;
			if (($newblock) && ($blockstate == 1 || $blockstate == 3) && isset($this->blk[$this->blklvl]['text_indent']) && ($lineCount == 0) && (!$is_table) && ($align != 'C')) {
				$ti = $this->ConvertSize($this->blk[$this->blklvl]['text_indent'], $this->blk[$this->blklvl]['inner_width'], $this->blk[$this->blklvl]['InlineProperties']['size'], false);  // mPDF 5.7.4
				if ($blockdir != 'rtl') {
					$this->x += $ti;
				} // mPDF 6
			}

			foreach ($chunkorder AS $aord => $k) { // mPDF 5.7
				$chunk = $content[$aord];
				if (isset($this->objectbuffer[$k]) && $this->objectbuffer[$k]) {

					$xadj = $this->x - $this->objectbuffer[$k]['OUTER-X'];
					$this->objectbuffer[$k]['OUTER-X'] += $xadj;
					$this->objectbuffer[$k]['BORDER-X'] += $xadj;
					$this->objectbuffer[$k]['INNER-X'] += $xadj;

					if ($this->objectbuffer[$k]['type'] == 'listmarker') {
						$this->objectbuffer[$k]['lineBox'] = $lineBox[-1]; // Block element details for glyph-origin
					}
					$yadj = $this->y - $this->objectbuffer[$k]['OUTER-Y'];
					if ($this->objectbuffer[$k]['type'] == 'dottab') { // mPDF 6 DOTTAB
						$this->objectbuffer[$k]['lineBox'] = $lineBox[$k]; // element details for glyph-origin
					}
					if ($this->objectbuffer[$k]['type'] != 'dottab') { // mPDF 6 DOTTAB
						$yadj += $lineBox[$k]['top'];
					}
					$this->objectbuffer[$k]['OUTER-Y'] += $yadj;
					$this->objectbuffer[$k]['BORDER-Y'] += $yadj;
					$this->objectbuffer[$k]['INNER-Y'] += $yadj;
				}

				$this->restoreFont($font[$k]);  // mPDF 5.7

				if ($is_table && substr($align, 0, 1) == 'D' && $aord == 0) {
					$dp = $this->decimal_align[substr($align, 0, 2)];
					$s = preg_split('/' . preg_quote($dp, '/') . '/', $content[0], 2);  // ? needs to be /u if not core
					$s0 = $this->GetStringWidth($s[0], false);
					$this->x += ($this->decimal_offset - $s0);
				}

				$this->SetSpacing(($this->fixedlSpacing * _MPDFK) + $jcharspacing, ($this->fixedlSpacing + $this->minwSpacing) * _MPDFK + $jws);
				$this->fixedlSpacing = false;
				$this->minwSpacing = 0;

				$save_vis = $this->visibility;
				if (isset($this->textparam['visibility']) && $this->textparam['visibility'] && $this->textparam['visibility'] != $this->visibility) {
					$this->SetVisibility($this->textparam['visibility']);
				}

				// *********** SPAN BACKGROUND COLOR ***************** //
				if (isset($this->spanbgcolor) && $this->spanbgcolor) {
					$cor = $this->spanbgcolorarray;
					$this->SetFColor($cor);
					$save_fill = $fill;
					$spanfill = 1;
					$fill = 1;
				}
				if (!empty($this->spanborddet)) {
					if (strpos($contentB[$k], 'L') !== false && isset($this->spanborddet['L']))
						$this->x += $this->spanborddet['L']['w'];
					if (strpos($contentB[$k], 'L') === false)
						$this->spanborddet['L']['s'] = $this->spanborddet['L']['w'] = 0;
					if (strpos($contentB[$k], 'R') === false)
						$this->spanborddet['R']['s'] = $this->spanborddet['R']['w'] = 0;
				}
				// WORD SPACING
				// mPDF 5.7.1
				$stringWidth = $this->GetStringWidth($chunk, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar);
				$nch = mb_strlen($chunk, $this->mb_enc);
				// Use GPOS OTL
				if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
					if (isset($cOTLdata[$aord]['group']) && $cOTLdata[$aord]['group']) {
						$nch -= substr_count($cOTLdata[$aord]['group'], 'M');
					}
				}
				$stringWidth += ( $this->charspacing * $nch / _MPDFK );

				$stringWidth += ( $this->ws * mb_substr_count($chunk, ' ', $this->mb_enc) / _MPDFK );

				if (isset($this->objectbuffer[$k])) {
					if ($this->objectbuffer[$k]['type'] == 'dottab') {
						$this->objectbuffer[$k]['OUTER-WIDTH'] +=$empty;
						$this->objectbuffer[$k]['OUTER-WIDTH'] +=$this->objectbuffer[$k]['outdent'];
					}
					// LIST MARKERS	// mPDF 6  Lists
					if ($this->objectbuffer[$k]['type'] == 'image' && isset($this->objectbuffer[$k]['listmarker']) && $this->objectbuffer[$k]['listmarker'] && $this->objectbuffer[$k]['listmarkerposition'] == 'outside') {
						// do nothing
					} else {
						$stringWidth = $this->objectbuffer[$k]['OUTER-WIDTH'];
					}
				}

				if ($stringWidth == 0) {
					$stringWidth = 0.000001;
				}
				if ($aord == $arraysize - 1) { // mPDF 5.7
					// mPDF 5.7.1
					if ($this->checkCJK && $CJKoverflow && $align == 'J' && $this->allowCJKoverflow && $hanger && $this->CJKforceend) {
						// force-end overhang
						$this->Cell($stringWidth, $stackHeight, $chunk, '', 0, '', $fill, $this->HREF, $currentx, 0, 0, 'M', $fill, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar, (isset($lineBox[$k]) ? $lineBox[$k] : false));  // mPDF 5.7.1
						$this->Cell($this->GetStringWidth($hanger), $stackHeight, $hanger, '', 1, '', $fill, $this->HREF, $currentx, 0, 0, 'M', $fill, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar, (isset($lineBox[$k]) ? $lineBox[$k] : false)); // mPDF 5.7.1
					} else {
						$this->Cell($stringWidth, $stackHeight, $chunk, '', 1, '', $fill, $this->HREF, $currentx, 0, 0, 'M', $fill, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar, (isset($lineBox[$k]) ? $lineBox[$k] : false)); // mPDF 5.7.1
					}
				} else
					$this->Cell($stringWidth, $stackHeight, $chunk, '', 0, '', $fill, $this->HREF, 0, 0, 0, 'M', $fill, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar, (isset($lineBox[$k]) ? $lineBox[$k] : false)); //first or middle part	// mPDF 5.7.1


				if (!empty($this->spanborddet)) {
					if (strpos($contentB[$k], 'R') !== false && $aord != $arraysize - 1)
						$this->x += $this->spanborddet['R']['w'];
				}
				// *********** SPAN BACKGROUND COLOR OFF - RESET BLOCK BGCOLOR ***************** //
				if (isset($spanfill) && $spanfill) {
					$fill = $save_fill;
					$spanfill = 0;
					if ($fill) {
						$this->SetFColor($bcor);
					}
				}
				if (isset($this->textparam['visibility']) && $this->textparam['visibility'] && $this->visibility != $save_vis) {
					$this->SetVisibility($save_vis);
				}
			}

			$this->printobjectbuffer($is_table, $blockdir);
			$this->objectbuffer = array();
			$this->ResetSpacing();
		} // END IF CONTENT

		/* -- CSS-IMAGE-FLOAT -- */
		// Update values if set to skipline
		if ($this->floatmargins) {
			$this->_advanceFloatMargins();
		}


		if ($endofblock && $blockstate > 1) {
			// If float exists at this level
			if (isset($this->floatmargins['R']['y1'])) {
				$fry1 = $this->floatmargins['R']['y1'];
			} else {
				$fry1 = 0;
			}
			if (isset($this->floatmargins['L']['y1'])) {
				$fly1 = $this->floatmargins['L']['y1'];
			} else {
				$fly1 = 0;
			}
			if ($this->y < $fry1 || $this->y < $fly1) {
				$drop = max($fry1, $fly1) - $this->y;
				$this->DivLn($drop);
				$this->x = $currentx;
			}
		}
		/* -- END CSS-IMAGE-FLOAT -- */


		// PADDING and BORDER spacing/fill
		if ($endofblock && ($blockstate > 1) && ($this->blk[$this->blklvl]['padding_bottom'] || $this->blk[$this->blklvl]['border_bottom'] || $this->blk[$this->blklvl]['css_set_height']) && (!$is_table)) {
			// If CSS height set, extend bottom - if on same page as block started, and CSS HEIGHT > actual height,
			// and does not force pagebreak
			$extra = 0;
			if (isset($this->blk[$this->blklvl]['css_set_height']) && $this->blk[$this->blklvl]['css_set_height'] && $this->blk[$this->blklvl]['startpage'] == $this->page) {
				// predicted height
				$h1 = ($this->y - $this->blk[$this->blklvl]['y0']) + $this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['border_bottom']['w'];
				if ($h1 < ($this->blk[$this->blklvl]['css_set_height'] + $this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['padding_top'])) {
					$extra = ($this->blk[$this->blklvl]['css_set_height'] + $this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['padding_top']) - $h1;
				}
				if ($this->y + $this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['border_bottom']['w'] + $extra > $this->PageBreakTrigger) {
					$extra = $this->PageBreakTrigger - ($this->y + $this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['border_bottom']['w']);
				}
			}

			// $state = 0 normal; 1 top; 2 bottom; 3 top and bottom
			$this->DivLn($this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['border_bottom']['w'] + $extra, -3, true, false, 2);
			$this->x = $currentx;

			if ($this->ColActive) {
				$this->breakpoints[$this->CurrCol][] = $this->y;
			} // *COLUMNS*
		}

		// SET Bottom y1 of block (used for painting borders)
		if (($endofblock) && ($blockstate > 1) && (!$is_table)) {
			$this->blk[$this->blklvl]['y1'] = $this->y;
		}

		// BOTTOM MARGIN
		if (($endofblock) && ($blockstate > 1) && ($this->blk[$this->blklvl]['margin_bottom']) && (!$is_table)) {
			if ($this->y + $this->blk[$this->blklvl]['margin_bottom'] < $this->PageBreakTrigger and ! $this->InFooter) {
				$this->DivLn($this->blk[$this->blklvl]['margin_bottom'], $this->blklvl - 1, true, $this->blk[$this->blklvl]['margin_collapse']);
				if ($this->ColActive) {
					$this->breakpoints[$this->CurrCol][] = $this->y;
				} // *COLUMNS*
			}
		}

		// Reset lineheight
		$stackHeight = $this->divheight;
	}

	function printobjectbuffer($is_table = false, $blockdir = false)
	{
		if (!$blockdir) {
			$blockdir = $this->directionality;
		}
		if ($is_table && $this->shrin_k > 1) {
			$k = $this->shrin_k;
		} else {
			$k = 1;
		}
		$save_y = $this->y;
		$save_x = $this->x;
		$save_currentfontfamily = $this->FontFamily;
		$save_currentfontsize = $this->FontSizePt;
		$save_currentfontstyle = $this->FontStyle;
		if ($blockdir == 'rtl') {
			$rtlalign = 'R';
		} else {
			$rtlalign = 'L';
		}
		foreach ($this->objectbuffer AS $ib => $objattr) {
			if ($objattr['type'] == 'bookmark' || $objattr['type'] == 'indexentry' || $objattr['type'] == 'toc') {
				$x = $objattr['OUTER-X'];
				$y = $objattr['OUTER-Y'];
				$this->y = $y - $this->FontSize / 2;
				$this->x = $x;
				if ($objattr['type'] == 'bookmark') {
					$this->Bookmark($objattr['CONTENT'], $objattr['bklevel'], $y - $this->FontSize);
				} // *BOOKMARKS*
				if ($objattr['type'] == 'indexentry') {
					$this->IndexEntry($objattr['CONTENT']);
				} // *INDEX*
				if ($objattr['type'] == 'toc') {
					$this->TOC_Entry($objattr['CONTENT'], $objattr['toclevel'], (isset($objattr['toc_id']) ? $objattr['toc_id'] : ''));
				} // *TOC*
			}
			/* -- ANNOTATIONS -- */ elseif ($objattr['type'] == 'annot') {
				if ($objattr['POS-X']) {
					$x = $objattr['POS-X'];
				} elseif ($this->annotMargin <> 0) {
					$x = -$objattr['OUTER-X'];
				} else {
					$x = $objattr['OUTER-X'];
				}
				if ($objattr['POS-Y']) {
					$y = $objattr['POS-Y'];
				} else {
					$y = $objattr['OUTER-Y'] - $this->FontSize / 2;
				}
				// Create a dummy entry in the _out/columnBuffer with position sensitive data,
				// linking $y-1 in the Columnbuffer with entry in $this->columnAnnots
				// and when columns are split in length will not break annotation from current line
				$this->y = $y - 1;
				$this->x = $x - 1;
				$this->Line($x - 1, $y - 1, $x - 1, $y - 1);
				$this->Annotation($objattr['CONTENT'], $x, $y, $objattr['ICON'], $objattr['AUTHOR'], $objattr['SUBJECT'], $objattr['OPACITY'], $objattr['COLOR'], (isset($objattr['POPUP']) ? $objattr['POPUP'] : ''), (isset($objattr['FILE']) ? $objattr['FILE'] : ''));
			}
			/* -- END ANNOTATIONS -- */ else {
				$y = $objattr['OUTER-Y'];
				$x = $objattr['OUTER-X'];
				$w = $objattr['OUTER-WIDTH'];
				$h = $objattr['OUTER-HEIGHT'];
				if (isset($objattr['text'])) {
					$texto = $objattr['text'];
				}
				$this->y = $y;
				$this->x = $x;
				if (isset($objattr['fontfamily'])) {
					$this->SetFont($objattr['fontfamily'], '', $objattr['fontsize']);
				}
			}

			// HR
			if ($objattr['type'] == 'hr') {
				$this->SetDColor($objattr['color']);
				switch ($objattr['align']) {
					case 'C':
						$empty = $objattr['OUTER-WIDTH'] - $objattr['INNER-WIDTH'];
						$empty /= 2;
						$x += $empty;
						break;
					case 'R':
						$empty = $objattr['OUTER-WIDTH'] - $objattr['INNER-WIDTH'];
						$x += $empty;
						break;
				}
				$oldlinewidth = $this->LineWidth;
				$this->SetLineWidth($objattr['linewidth'] / $k);
				$this->y += ($objattr['linewidth'] / 2) + $objattr['margin_top'] / $k;
				$this->Line($x, $this->y, $x + $objattr['INNER-WIDTH'], $this->y);
				$this->SetLineWidth($oldlinewidth);
				$this->SetDColor($this->ConvertColor(0));
			}
			// IMAGE
			if ($objattr['type'] == 'image') {
				// mPDF 5.7.3 TRANSFORMS
				if (isset($objattr['transform'])) {
					$this->_out("\n" . '% BTR'); // Begin Transform
				}
				if (isset($objattr['z-index']) && $objattr['z-index'] > 0 && $this->current_layer == 0) {
					$this->BeginLayer($objattr['z-index']);
				}
				if (isset($objattr['visibility']) && $objattr['visibility'] != 'visible' && $objattr['visibility']) {
					$this->SetVisibility($objattr['visibility']);
				}
				if (isset($objattr['opacity'])) {
					$this->SetAlpha($objattr['opacity']);
				}

				$obiw = $objattr['INNER-WIDTH'];
				$obih = $objattr['INNER-HEIGHT'];
				$sx = $objattr['INNER-WIDTH'] * _MPDFK / $objattr['orig_w'];
				$sy = abs($objattr['INNER-HEIGHT']) * _MPDFK / abs($objattr['orig_h']);
				$sx = ($objattr['INNER-WIDTH'] * _MPDFK / $objattr['orig_w']);
				$sy = ($objattr['INNER-HEIGHT'] * _MPDFK / $objattr['orig_h']);

				$rotate = 0;
				if (isset($objattr['ROTATE'])) {
					$rotate = $objattr['ROTATE'];
				}
				if ($rotate == 90) {
					// Clockwise
					$obiw = $objattr['INNER-HEIGHT'];
					$obih = $objattr['INNER-WIDTH'];
					$tr = $this->transformTranslate(0, -$objattr['INNER-WIDTH'], true);
					$tr .= ' ' . $this->transformRotate(90, $objattr['INNER-X'], ($objattr['INNER-Y'] + $objattr['INNER-WIDTH']), true);
					$sx = $obiw * _MPDFK / $objattr['orig_h'];
					$sy = $obih * _MPDFK / $objattr['orig_w'];
				} elseif ($rotate == -90 || $rotate == 270) {
					// AntiClockwise
					$obiw = $objattr['INNER-HEIGHT'];
					$obih = $objattr['INNER-WIDTH'];
					$tr = $this->transformTranslate($objattr['INNER-WIDTH'], ($objattr['INNER-HEIGHT'] - $objattr['INNER-WIDTH']), true);
					$tr .= ' ' . $this->transformRotate(-90, $objattr['INNER-X'], ($objattr['INNER-Y'] + $objattr['INNER-WIDTH']), true);
					$sx = $obiw * _MPDFK / $objattr['orig_h'];
					$sy = $obih * _MPDFK / $objattr['orig_w'];
				} elseif ($rotate == 180) {
					// Mirror
					$tr = $this->transformTranslate($objattr['INNER-WIDTH'], -$objattr['INNER-HEIGHT'], true);
					$tr .= ' ' . $this->transformRotate(180, $objattr['INNER-X'], ($objattr['INNER-Y'] + $objattr['INNER-HEIGHT']), true);
				} else {
					$tr = '';
				}
				$tr = trim($tr);
				if ($tr) {
					$tr .= ' ';
				}
				$gradmask = '';

				// mPDF 5.7.3 TRANSFORMS
				$tr2 = '';
				if (isset($objattr['transform'])) {
					$maxsize_x = $w;
					$maxsize_y = $h;
					$cx = $x + $w / 2;
					$cy = $y + $h / 2;
					preg_match_all('/(translatex|translatey|translate|scalex|scaley|scale|rotate|skewX|skewY|skew)\((.*?)\)/is', $objattr['transform'], $m);
					if (count($m[0])) {
						for ($i = 0; $i < count($m[0]); $i++) {
							$c = strtolower($m[1][$i]);
							$v = trim($m[2][$i]);
							$vv = preg_split('/[ ,]+/', $v);
							if ($c == 'translate' && count($vv)) {
								$translate_x = $this->ConvertSize($vv[0], $maxsize_x, false, false);
								if (count($vv) == 2) {
									$translate_y = $this->ConvertSize($vv[1], $maxsize_y, false, false);
								} else {
									$translate_y = 0;
								}
								$tr2 .= $this->transformTranslate($translate_x, $translate_y, true) . ' ';
							} elseif ($c == 'translatex' && count($vv)) {
								$translate_x = $this->ConvertSize($vv[0], $maxsize_x, false, false);
								$tr2 .= $this->transformTranslate($translate_x, 0, true) . ' ';
							} elseif ($c == 'translatey' && count($vv)) {
								$translate_y = $this->ConvertSize($vv[1], $maxsize_y, false, false);
								$tr2 .= $this->transformTranslate(0, $translate_y, true) . ' ';
							} elseif ($c == 'scale' && count($vv)) {
								$scale_x = $vv[0] * 100;
								if (count($vv) == 2) {
									$scale_y = $vv[1] * 100;
								} else {
									$scale_y = $scale_x;
								}
								$tr2 .= $this->transformScale($scale_x, $scale_y, $cx, $cy, true) . ' ';
							} elseif ($c == 'scalex' && count($vv)) {
								$scale_x = $vv[0] * 100;
								$tr2 .= $this->transformScale($scale_x, 0, $cx, $cy, true) . ' ';
							} elseif ($c == 'scaley' && count($vv)) {
								$scale_y = $vv[1] * 100;
								$tr2 .= $this->transformScale(0, $scale_y, $cx, $cy, true) . ' ';
							} elseif ($c == 'skew' && count($vv)) {
								$angle_x = $this->ConvertAngle($vv[0], false);
								if (count($vv) == 2) {
									$angle_y = $this->ConvertAngle($vv[1], false);
								} else {
									$angle_y = 0;
								}
								$tr2 .= $this->transformSkew($angle_x, $angle_y, $cx, $cy, true) . ' ';
							} elseif ($c == 'skewx' && count($vv)) {
								$angle = $this->ConvertAngle($vv[0], false);
								$tr2 .= $this->transformSkew($angle, 0, $cx, $cy, true) . ' ';
							} elseif ($c == 'skewy' && count($vv)) {
								$angle = $this->ConvertAngle($vv[0], false);
								$tr2 .= $this->transformSkew(0, $angle, $cx, $cy, true) . ' ';
							} elseif ($c == 'rotate' && count($vv)) {
								$angle = $this->ConvertAngle($vv[0]);
								$tr2 .= $this->transformRotate($angle, $cx, $cy, true) . ' ';
							}
						}
					}
				}

				// LIST MARKERS (Images)	// mPDF 6  Lists
				if (isset($objattr['listmarker']) && $objattr['listmarker'] && $objattr['listmarkerposition'] == 'outside') {
					$mw = $objattr['OUTER-WIDTH'];
					//  NB If change marker-offset, also need to alter in function _getListMarkerWidth
					$adjx = $this->ConvertSize($this->list_marker_offset, $this->FontSize);
					if ($objattr['dir'] == 'rtl') {
						$objattr['INNER-X'] += $adjx;
					} else {
						$objattr['INNER-X'] -= $adjx;
						$objattr['INNER-X'] -= $mw;
					}
				}
				// mPDF 5.7.3 TRANSFORMS / BACKGROUND COLOR
				// Transform also affects image background
				if ($tr2) {
					$this->_out('q ' . $tr2 . ' ');
				}
				if (isset($objattr['bgcolor']) && $objattr['bgcolor']) {
					$bgcol = $objattr['bgcolor'];
					$this->SetFColor($bgcol);
					$this->Rect($x, $y, $w, $h, 'F');
					$this->SetFColor($this->ConvertColor(255));
				}
				if ($tr2) {
					$this->_out('Q');
				}

				/* -- BACKGROUNDS -- */
				if (isset($objattr['GRADIENT-MASK'])) {
					$g = $this->grad->parseMozGradient($objattr['GRADIENT-MASK']);
					if ($g) {
						$dummy = $this->grad->Gradient($objattr['INNER-X'], $objattr['INNER-Y'], $obiw, $obih, $g['type'], $g['stops'], $g['colorspace'], $g['coords'], $g['extend'], true, true);
						$gradmask = '/TGS' . count($this->gradients) . ' gs ';
					}
				}
				/* -- END BACKGROUNDS -- */
				/* -- IMAGES-WMF -- */
				if (isset($objattr['itype']) && $objattr['itype'] == 'wmf') {
					$outstring = sprintf('q ' . $tr . $tr2 . '%.3F 0 0 %.3F %.3F %.3F cm /FO%d Do Q', $sx, -$sy, $objattr['INNER-X'] * _MPDFK - $sx * $objattr['wmf_x'], (($this->h - $objattr['INNER-Y']) * _MPDFK) + $sy * $objattr['wmf_y'], $objattr['ID']); // mPDF 5.7.3 TRANSFORMS
				} else
				/* -- END IMAGES-WMF -- */
				if (isset($objattr['itype']) && $objattr['itype'] == 'svg') {
					$outstring = sprintf('q ' . $tr . $tr2 . '%.3F 0 0 %.3F %.3F %.3F cm /FO%d Do Q', $sx, -$sy, $objattr['INNER-X'] * _MPDFK - $sx * $objattr['wmf_x'], (($this->h - $objattr['INNER-Y']) * _MPDFK) + $sy * $objattr['wmf_y'], $objattr['ID']); // mPDF 5.7.3 TRANSFORMS
				} else {
					$outstring = sprintf("q " . $tr . $tr2 . "%.3F 0 0 %.3F %.3F %.3F cm " . $gradmask . "/I%d Do Q", $obiw * _MPDFK, $obih * _MPDFK, $objattr['INNER-X'] * _MPDFK, ($this->h - ($objattr['INNER-Y'] + $obih )) * _MPDFK, $objattr['ID']); // mPDF 5.7.3 TRANSFORMS
				}
				$this->_out($outstring);
				// LINK
				if (isset($objattr['link']))
					$this->Link($objattr['INNER-X'], $objattr['INNER-Y'], $objattr['INNER-WIDTH'], $objattr['INNER-HEIGHT'], $objattr['link']);
				if (isset($objattr['opacity'])) {
					$this->SetAlpha(1);
				}

				// mPDF 5.7.3 TRANSFORMS
				// Transform also affects image borders
				if ($tr2) {
					$this->_out('q ' . $tr2 . ' ');
				}
				if ((isset($objattr['border_top']) && $objattr['border_top'] > 0) || (isset($objattr['border_left']) && $objattr['border_left'] > 0) || (isset($objattr['border_right']) && $objattr['border_right'] > 0) || (isset($objattr['border_bottom']) && $objattr['border_bottom'] > 0)) {
					$this->PaintImgBorder($objattr, $is_table);
				}
				if ($tr2) {
					$this->_out('Q');
				}

				if (isset($objattr['visibility']) && $objattr['visibility'] != 'visible' && $objattr['visibility']) {
					$this->SetVisibility('visible');
				}
				if (isset($objattr['z-index']) && $objattr['z-index'] > 0 && $this->current_layer == 0) {
					$this->EndLayer();
				}
				// mPDF 5.7.3 TRANSFORMS
				if (isset($objattr['transform'])) {
					$this->_out("\n" . '% ETR'); // End Transform
				}
			}

			/* -- BARCODES -- */
			// BARCODE
			if ($objattr['type'] == 'barcode') {
				$bgcol = $this->ConvertColor(255);
				if (isset($objattr['bgcolor']) && $objattr['bgcolor']) {
					$bgcol = $objattr['bgcolor'];
				}
				$col = $this->ConvertColor(0);
				if (isset($objattr['color']) && $objattr['color']) {
					$col = $objattr['color'];
				}
				$this->SetFColor($bgcol);
				$this->Rect($objattr['BORDER-X'], $objattr['BORDER-Y'], $objattr['BORDER-WIDTH'], $objattr['BORDER-HEIGHT'], 'F');
				$this->SetFColor($this->ConvertColor(255));
				if (isset($objattr['BORDER-WIDTH'])) {
					$this->PaintImgBorder($objattr, $is_table);
				}
				if ($objattr['btype'] == 'EAN13' || $objattr['btype'] == 'ISBN' || $objattr['btype'] == 'ISSN' || $objattr['btype'] == 'UPCA' || $objattr['btype'] == 'UPCE' || $objattr['btype'] == 'EAN8') {
					$this->WriteBarcode($objattr['code'], $objattr['showtext'], $objattr['INNER-X'], $objattr['INNER-Y'], $objattr['bsize'], 0, 0, 0, 0, 0, $objattr['bheight'], $bgcol, $col, $objattr['btype'], $objattr['bsupp'], (isset($objattr['bsupp_code']) ? $objattr['bsupp_code'] : ''), $k);
				}
				// QR-code
				elseif ($objattr['btype'] == 'QR') {
					if (!class_exists('QRcode', false)) {
						include(_MPDF_PATH . 'qrcode/qrcode.class.php');
					}
					$this->qrcode = new QRcode($objattr['code'], $objattr['errorlevel']);
					$this->qrcode->displayFPDF($this, $objattr['INNER-X'], $objattr['INNER-Y'], $objattr['bsize'] * 25, array(255, 255, 255), array(0, 0, 0));
				} else {
					$this->WriteBarcode2($objattr['code'], $objattr['INNER-X'], $objattr['INNER-Y'], $objattr['bsize'], $objattr['bheight'], $bgcol, $col, $objattr['btype'], $objattr['pr_ratio'], $k);
				}
			}
			/* -- END BARCODES -- */

			// TEXT CIRCLE
			if ($objattr['type'] == 'textcircle') {
				$bgcol = '';
				if (isset($objattr['bgcolor']) && $objattr['bgcolor']) {
					$bgcol = $objattr['bgcolor'];
				}
				$col = $this->ConvertColor(0);
				if (isset($objattr['color']) && $objattr['color']) {
					$col = $objattr['color'];
				}
				$this->SetTColor($col);
				$this->SetFColor($bgcol);
				if ($bgcol)
					$this->Rect($objattr['BORDER-X'], $objattr['BORDER-Y'], $objattr['BORDER-WIDTH'], $objattr['BORDER-HEIGHT'], 'F');
				$this->SetFColor($this->ConvertColor(255));
				if (isset($objattr['BORDER-WIDTH'])) {
					$this->PaintImgBorder($objattr, $is_table);
				}
				if (!class_exists('directw', false)) {
					include(_MPDF_PATH . 'classes/directw.php');
				}
				if (empty($this->directw)) {
					$this->directw = new directw($this);
				}
				if (isset($objattr['top-text'])) {
					$this->directw->CircularText($objattr['INNER-X'] + $objattr['INNER-WIDTH'] / 2, $objattr['INNER-Y'] + $objattr['INNER-HEIGHT'] / 2, $objattr['r'] / $k, $objattr['top-text'], 'top', $objattr['fontfamily'], $objattr['fontsize'] / $k, $objattr['fontstyle'], $objattr['space-width'], $objattr['char-width'], (isset($objattr['divider']) ? $objattr['divider'] : ''));
				}
				if (isset($objattr['bottom-text'])) {
					$this->directw->CircularText($objattr['INNER-X'] + $objattr['INNER-WIDTH'] / 2, $objattr['INNER-Y'] + $objattr['INNER-HEIGHT'] / 2, $objattr['r'] / $k, $objattr['bottom-text'], 'bottom', $objattr['fontfamily'], $objattr['fontsize'] / $k, $objattr['fontstyle'], $objattr['space-width'], $objattr['char-width'], (isset($objattr['divider']) ? $objattr['divider'] : ''));
				}
			}

			$this->ResetSpacing();

			// LIST MARKERS (Text or bullets)	// mPDF 6  Lists
			if ($objattr['type'] == 'listmarker') {
				if (isset($objattr['fontfamily'])) {
					$this->SetFont($objattr['fontfamily'], $objattr['fontstyle'], $objattr['fontsizept']);
				}
				$col = $this->ConvertColor(0);
				if (isset($objattr['colorarray']) && ($objattr['colorarray'])) {
					$col = $objattr['colorarray'];
				}

				if (isset($objattr['bullet']) && $objattr['bullet']) { // Used for position "outside" only
					$type = $objattr['bullet'];
					$size = $objattr['size'];

					if ($objattr['listmarkerposition'] == 'inside') {
						$adjx = $size / 2;
						if ($objattr['dir'] == 'rtl') {
							$adjx += $objattr['offset'];
						}
						$this->x += $adjx;
					} else {
						$adjx = $objattr['offset'];
						$adjx += $size / 2;
						if ($objattr['dir'] == 'rtl') {
							$this->x += $adjx;
						} else {
							$this->x -= $adjx;
						}
					}

					$yadj = $objattr['lineBox']['glyphYorigin'];
					if (isset($this->CurrentFont['desc']['XHeight']) && $this->CurrentFont['desc']['XHeight']) {
						$xh = $this->CurrentFont['desc']['XHeight'];
					} else {
						$xh = 500;
					}
					$yadj -= ($this->FontSize * $xh / 1000) * 0.625; // Vertical height of bullet (centre) from baseline= XHeight * 0.625
					$this->y += $yadj;

					$this->_printListBullet($this->x, $this->y, $size, $type, $col);
				} else {
					$this->SetTColor($col);
					$w = $this->GetStringWidth($texto);
					//  NB If change marker-offset, also need to alter in function _getListMarkerWidth
					$adjx = $this->ConvertSize($this->list_marker_offset, $this->FontSize);
					if ($objattr['dir'] == 'rtl') {
						$align = 'L';
						$this->x += $adjx;
					} else {
						// Use these lines to set as marker-offset, right-aligned - default
						$align = 'R';
						$this->x -= $adjx;
						$this->x -= $w;
					}
					$this->Cell($w, $this->FontSize, $texto, 0, 0, $align, 0, '', 0, 0, 0, 'T', 0, false, false, 0, $objattr['lineBox']);
					$this->SetTColor($this->ConvertColor(0));
				}
			}

			// DOT-TAB
			if ($objattr['type'] == 'dottab') {
				if (isset($objattr['fontfamily'])) {
					$this->SetFont($objattr['fontfamily'], '', $objattr['fontsize']);
				}
				$sp = $this->GetStringWidth(' ');
				$nb = floor(($w - 2 * $sp) / $this->GetStringWidth('.'));
				if ($nb > 0) {
					$dots = ' ' . str_repeat('.', $nb) . ' ';
				} else {
					$dots = ' ';
				}
				$col = $this->ConvertColor(0);
				if (isset($objattr['colorarray']) && ($objattr['colorarray'])) {
					$col = $objattr['colorarray'];
				}
				$this->SetTColor($col);
				$save_dh = $this->divheight;
				$save_sbd = $this->spanborddet;
				$save_textvar = $this->textvar; // mPDF 5.7.1
				$this->spanborddet = '';
				$this->divheight = 0;
				$this->textvar = 0x00; // mPDF 5.7.1

				$this->Cell($w, $h, $dots, 0, 0, 'C', 0, '', 0, 0, 0, 'T', 0, false, false, 0, $objattr['lineBox']); // mPDF 6 DOTTAB
				$this->spanborddet = $save_sbd;
				$this->textvar = $save_textvar; // mPDF 5.7.1
				$this->divheight = $save_dh;
				$this->SetTColor($this->ConvertColor(0));
			}

			/* -- FORMS -- */
			// TEXT/PASSWORD INPUT
			if ($objattr['type'] == 'input' && ($objattr['subtype'] == 'TEXT' || $objattr['subtype'] == 'PASSWORD')) {
				$this->mpdfform->print_ob_text($objattr, $w, $h, $texto, $rtlalign, $k, $blockdir);
			}

			// TEXTAREA
			if ($objattr['type'] == 'textarea') {
				$this->mpdfform->print_ob_textarea($objattr, $w, $h, $texto, $rtlalign, $k, $blockdir);
			}

			// SELECT
			if ($objattr['type'] == 'select') {
				$this->mpdfform->print_ob_select($objattr, $w, $h, $texto, $rtlalign, $k, $blockdir);
			}


			// INPUT/BUTTON as IMAGE
			if ($objattr['type'] == 'input' && $objattr['subtype'] == 'IMAGE') {
				$this->mpdfform->print_ob_imageinput($objattr, $w, $h, $texto, $rtlalign, $k, $blockdir);
			}

			// BUTTON
			if ($objattr['type'] == 'input' && ($objattr['subtype'] == 'SUBMIT' || $objattr['subtype'] == 'RESET' || $objattr['subtype'] == 'BUTTON')) {
				$this->mpdfform->print_ob_button($objattr, $w, $h, $texto, $rtlalign, $k, $blockdir);
			}

			// CHECKBOX
			if ($objattr['type'] == 'input' && ($objattr['subtype'] == 'CHECKBOX')) {
				$this->mpdfform->print_ob_checkbox($objattr, $w, $h, $texto, $rtlalign, $k, $blockdir, $x, $y);
			}
			// RADIO
			if ($objattr['type'] == 'input' && ($objattr['subtype'] == 'RADIO')) {
				$this->mpdfform->print_ob_radio($objattr, $w, $h, $texto, $rtlalign, $k, $blockdir, $x, $y);
			}
			/* -- END FORMS -- */
		}
		$this->SetFont($save_currentfontfamily, $save_currentfontstyle, $save_currentfontsize);
		$this->y = $save_y;
		$this->x = $save_x;
		unset($content);
	}

	function _printListBullet($x, $y, $size, $type, $color)
	{
		// x and y are the centre of the bullet; size is the width and/or height in mm
		$fcol = $this->SetTColor($color, true);
		$lcol = strtoupper($fcol); // change 0 0 0 rg to 0 0 0 RG
		$this->_out(sprintf('q %s %s', $lcol, $fcol));
		$this->_out('0 j 0 J [] 0 d');
		if ($type == 'square') {
			$size *= 0.85; // Smaller to appear the same size as circle/disc
			$this->_out(sprintf('%.3F %.3F %.3F %.3F re f', ($x - $size / 2) * _MPDFK, ($this->h - $y + $size / 2) * _MPDFK, ($size) * _MPDFK, (-$size) * _MPDFK));
		} elseif ($type == 'disc') {
			$this->Circle($x, $y, $size / 2, 'F'); // Fill
		} elseif ($type == 'circle') {
			$lw = $size / 12; // Line width
			$this->_out(sprintf('%.3F w ', $lw * _MPDFK));
			$this->Circle($x, $y, $size / 2 - $lw / 2, 'S'); // Stroke
		}
		$this->_out('Q');
	}

	// mPDF 6
	// Get previous character and move pointers
	function _moveToPrevChar(&$contentctr, &$charctr, $content)
	{
		$lastchar = false;
		$charctr--;
		while ($charctr < 0) { // go back to previous $content[]
			$contentctr--;
			if ($contentctr < 0) {
				return false;
			}
			if ($this->usingCoreFont) {
				$charctr = strlen($content[$contentctr]) - 1;
			} else {
				$charctr = mb_strlen($content[$contentctr], $this->mb_enc) - 1;
			}
		}
		if ($this->usingCoreFont) {
			$lastchar = $content[$contentctr][$charctr];
		} else {
			$lastchar = mb_substr($content[$contentctr], $charctr, 1, $this->mb_enc);
		}
		return $lastchar;
	}

	// Get previous character
	function _getPrevChar($contentctr, $charctr, $content)
	{
		$lastchar = false;
		$charctr--;
		while ($charctr < 0) { // go back to previous $content[]
			$contentctr--;
			if ($contentctr < 0) {
				return false;
			}
			if ($this->usingCoreFont) {
				$charctr = strlen($content[$contentctr]) - 1;
			} else {
				$charctr = mb_strlen($content[$contentctr], $this->mb_enc) - 1;
			}
		}
		if ($this->usingCoreFont) {
			$lastchar = $content[$contentctr][$charctr];
		} else {
			$lastchar = mb_substr($content[$contentctr], $charctr, 1, $this->mb_enc);
		}
		return $lastchar;
	}

	function WriteFlowingBlock($s, $sOTLdata)
	{ // mPDF 5.7.1
		$currentx = $this->x;
		$is_table = $this->flowingBlockAttr['is_table'];
		$table_draft = $this->flowingBlockAttr['table_draft'];
		// width of all the content so far in points
		$contentWidth = & $this->flowingBlockAttr['contentWidth'];
		// cell width in points
		$maxWidth = & $this->flowingBlockAttr['width'];
		$lineCount = & $this->flowingBlockAttr['lineCount'];
		// line height in user units
		$stackHeight = & $this->flowingBlockAttr['height'];
		$align = & $this->flowingBlockAttr['align'];
		$content = & $this->flowingBlockAttr['content'];
		$contentB = & $this->flowingBlockAttr['contentB'];
		$font = & $this->flowingBlockAttr['font'];
		$valign = & $this->flowingBlockAttr['valign'];
		$blockstate = $this->flowingBlockAttr['blockstate'];
		$cOTLdata = & $this->flowingBlockAttr['cOTLdata']; // mPDF 5.7.1

		$newblock = $this->flowingBlockAttr['newblock'];
		$blockdir = $this->flowingBlockAttr['blockdir'];

		// *********** BLOCK BACKGROUND COLOR ***************** //
		if ($this->blk[$this->blklvl]['bgcolor'] && !$is_table) {
			$fill = 0;
		} else {
			$this->SetFColor($this->ConvertColor(255));
			$fill = 0;
		}
		$font[] = $this->saveFont();
		$content[] = '';
		$contentB[] = '';
		$cOTLdata[] = $sOTLdata; // mPDF 5.7.1
		$currContent = & $content[count($content) - 1];

		$CJKoverflow = false;
		$Oikomi = false; // mPDF 6
		$hanger = '';

		// COLS
		$oldcolumn = $this->CurrCol;
		if ($this->ColActive && !$is_table) {
			$this->breakpoints[$this->CurrCol][] = $this->y;
		} // *COLUMNS*

		/* -- TABLES -- */
		if ($is_table) {
			$ipaddingL = 0;
			$ipaddingR = 0;
			$paddingL = 0;
			$paddingR = 0;
			$cpaddingadjustL = 0;
			$cpaddingadjustR = 0;
			// Added mPDF 3.0
			$fpaddingR = 0;
			$fpaddingL = 0;
		} else {
			/* -- END TABLES -- */
			$ipaddingL = $this->blk[$this->blklvl]['padding_left'];
			$ipaddingR = $this->blk[$this->blklvl]['padding_right'];
			$paddingL = ($ipaddingL * _MPDFK);
			$paddingR = ($ipaddingR * _MPDFK);
			$this->cMarginL = $this->blk[$this->blklvl]['border_left']['w'];
			$cpaddingadjustL = -$this->cMarginL;
			$this->cMarginR = $this->blk[$this->blklvl]['border_right']['w'];
			$cpaddingadjustR = -$this->cMarginR;
			// Added mPDF 3.0 Float DIV
			$fpaddingR = 0;
			$fpaddingL = 0;
			/* -- CSS-FLOAT -- */
			if (count($this->floatDivs)) {
				list($l_exists, $r_exists, $l_max, $r_max, $l_width, $r_width) = $this->GetFloatDivInfo($this->blklvl);
				if ($r_exists) {
					$fpaddingR = $r_width;
				}
				if ($l_exists) {
					$fpaddingL = $l_width;
				}
			}
			/* -- END CSS-FLOAT -- */

			$usey = $this->y + 0.002;
			if (($newblock) && ($blockstate == 1 || $blockstate == 3) && ($lineCount == 0)) {
				$usey += $this->blk[$this->blklvl]['margin_top'] + $this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['border_top']['w'];
			}
			/* -- CSS-IMAGE-FLOAT -- */
			// If float exists at this level
			if (isset($this->floatmargins['R']) && $usey <= $this->floatmargins['R']['y1'] && $usey >= $this->floatmargins['R']['y0'] && !$this->floatmargins['R']['skipline']) {
				$fpaddingR += $this->floatmargins['R']['w'];
			}
			if (isset($this->floatmargins['L']) && $usey <= $this->floatmargins['L']['y1'] && $usey >= $this->floatmargins['L']['y0'] && !$this->floatmargins['L']['skipline']) {
				$fpaddingL += $this->floatmargins['L']['w'];
			}
			/* -- END CSS-IMAGE-FLOAT -- */
		} // *TABLES*
		//OBJECTS - IMAGES & FORM Elements (NB has already skipped line/page if required - in printbuffer)
		if (substr($s, 0, 3) == "\xbb\xa4\xac") { //identifier has been identified!
			$objattr = $this->_getObjAttr($s);
			$h_corr = 0;
			if ($is_table) { // *TABLES*
				$maximumW = ($maxWidth / _MPDFK) - ($this->cellPaddingL + $this->cMarginL + $this->cellPaddingR + $this->cMarginR);  // *TABLES*
			} // *TABLES*
			else { // *TABLES*
				if (($newblock) && ($blockstate == 1 || $blockstate == 3) && ($lineCount == 0) && (!$is_table)) {
					$h_corr = $this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['border_top']['w'];
				}
				$maximumW = ($maxWidth / _MPDFK) - ($this->blk[$this->blklvl]['padding_left'] + $this->blk[$this->blklvl]['border_left']['w'] + $this->blk[$this->blklvl]['padding_right'] + $this->blk[$this->blklvl]['border_right']['w'] + $fpaddingL + $fpaddingR );
			} // *TABLES*
			$objattr = $this->inlineObject($objattr['type'], $this->lMargin + $fpaddingL + ($contentWidth / _MPDFK), ($this->y + $h_corr), $objattr, $this->lMargin, ($contentWidth / _MPDFK), $maximumW, $stackHeight, true, $is_table);

			// SET LINEHEIGHT for this line ================ RESET AT END
			$stackHeight = MAX($stackHeight, $objattr['OUTER-HEIGHT']);
			$this->objectbuffer[count($content) - 1] = $objattr;
			// if (isset($objattr['vertical-align'])) { $valign = $objattr['vertical-align']; }
			// else { $valign = ''; }
			// LIST MARKERS	// mPDF 6  Lists
			if ($objattr['type'] == 'image' && isset($objattr['listmarker']) && $objattr['listmarker'] && $objattr['listmarkerposition'] == 'outside') {
				// do nothing
			} else {
				$contentWidth += ($objattr['OUTER-WIDTH'] * _MPDFK);
			}
			return;
		}

		$lbw = $rbw = 0; // Border widths
		if (!empty($this->spanborddet)) {
			if (isset($this->spanborddet['L']))
				$lbw = $this->spanborddet['L']['w'];
			if (isset($this->spanborddet['R']))
				$rbw = $this->spanborddet['R']['w'];
		}

		if ($this->usingCoreFont) {
			$clen = strlen($s);
		} else {
			$clen = mb_strlen($s, $this->mb_enc);
		}

		// for every character in the string
		for ($i = 0; $i < $clen; $i++) {

			// extract the current character
			// get the width of the character in points
			if ($this->usingCoreFont) {
				$c = $s[$i];
				// Soft Hyphens chr(173)
				$cw = ($this->GetCharWidthCore($c) * _MPDFK);
				if (($this->textvar & FC_KERNING) && $i > 0) { // mPDF 5.7.1
					if (isset($this->CurrentFont['kerninfo'][$s[($i - 1)]][$c])) {
						$cw += ($this->CurrentFont['kerninfo'][$s[($i - 1)]][$c] * $this->FontSizePt / 1000 );
					}
				}
			} else {
				$c = mb_substr($s, $i, 1, $this->mb_enc);
				$cw = ($this->GetCharWidthNonCore($c, false) * _MPDFK);
				// mPDF 5.7.1
				// Use OTL GPOS
				if (isset($this->CurrentFont['useOTL']) && ($this->CurrentFont['useOTL'] & 0xFF)) {
					// ...WriteFlowingBlock...
					// Only  add XAdvanceL (not sure at present whether RTL or LTR writing direction)
					// At this point, XAdvanceL and XAdvanceR will balance
					if (isset($sOTLdata['GPOSinfo'][$i]['XAdvanceL'])) {
						$cw += $sOTLdata['GPOSinfo'][$i]['XAdvanceL'] * (1000 / $this->CurrentFont['unitsPerEm']) * ($this->FontSize / 1000) * _MPDFK;
					}
				}
				if (($this->textvar & FC_KERNING) && $i > 0) { // mPDF 5.7.1
					$lastc = mb_substr($s, ($i - 1), 1, $this->mb_enc);
					$ulastc = $this->UTF8StringToArray($lastc, false);
					$uc = $this->UTF8StringToArray($c, false);
					if (isset($this->CurrentFont['kerninfo'][$ulastc[0]][$uc[0]])) {
						$cw += ($this->CurrentFont['kerninfo'][$ulastc[0]][$uc[0]] * $this->FontSizePt / 1000 );
					}
				}
			}

			if ($i == 0) {
				$cw += $lbw * _MPDFK;
				$contentB[(count($contentB) - 1)] .= 'L';
			}
			if ($i == ($clen - 1)) {
				$cw += $rbw * _MPDFK;
				$contentB[(count($contentB) - 1)] .= 'R';
			}
			if ($c == ' ') {
				$currContent .= $c;
				$contentWidth += $cw;
				continue;
			}

			// Paragraph INDENT
			$WidthCorrection = 0;
			if (($newblock) && ($blockstate == 1 || $blockstate == 3) && isset($this->blk[$this->blklvl]['text_indent']) && ($lineCount == 0) && (!$is_table) && ($align != 'C')) {
				$ti = $this->ConvertSize($this->blk[$this->blklvl]['text_indent'], $this->blk[$this->blklvl]['inner_width'], $this->blk[$this->blklvl]['InlineProperties']['size'], false);  // mPDF 5.7.4
				$WidthCorrection = ($ti * _MPDFK);
			}
			// OUTDENT
			foreach ($this->objectbuffer AS $k => $objattr) {   // mPDF 6 DOTTAB
				if ($objattr['type'] == 'dottab') {
					$WidthCorrection -= ($objattr['outdent'] * _MPDFK);
					break;
				}
			}


			// Added mPDF 3.0 Float DIV
			$fpaddingR = 0;
			$fpaddingL = 0;
			/* -- CSS-FLOAT -- */
			if (count($this->floatDivs)) {
				list($l_exists, $r_exists, $l_max, $r_max, $l_width, $r_width) = $this->GetFloatDivInfo($this->blklvl);
				if ($r_exists) {
					$fpaddingR = $r_width;
				}
				if ($l_exists) {
					$fpaddingL = $l_width;
				}
			}
			/* -- END CSS-FLOAT -- */

			$usey = $this->y + 0.002;
			if (($newblock) && ($blockstate == 1 || $blockstate == 3) && ($lineCount == 0)) {
				$usey += $this->blk[$this->blklvl]['margin_top'] + $this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['border_top']['w'];
			}

			/* -- CSS-IMAGE-FLOAT -- */
			// If float exists at this level
			if (isset($this->floatmargins['R']) && $usey <= $this->floatmargins['R']['y1'] && $usey >= $this->floatmargins['R']['y0'] && !$this->floatmargins['R']['skipline']) {
				$fpaddingR += $this->floatmargins['R']['w'];
			}
			if (isset($this->floatmargins['L']) && $usey <= $this->floatmargins['L']['y1'] && $usey >= $this->floatmargins['L']['y0'] && !$this->floatmargins['L']['skipline']) {
				$fpaddingL += $this->floatmargins['L']['w'];
			}
			/* -- END CSS-IMAGE-FLOAT -- */


			// try adding another char
			if (( $contentWidth + $cw > $maxWidth - $WidthCorrection - (($this->cMarginL + $this->cMarginR) * _MPDFK) - ($paddingL + $paddingR + (($fpaddingL + $fpaddingR) * _MPDFK) ) + 0.001)) {// 0.001 is to correct for deviations converting mm=>pts
				// it won't fit, output what we already have
				$lineCount++;

				// contains any content that didn't make it into this print
				$savedContent = '';
				$savedContentB = '';
				$savedOTLdata = array(); // mPDF 5.7.1
				$savedFont = array();
				$savedObj = array();
				$savedPreOTLdata = array(); // mPDF 5.7.1
				$savedPreContent = array();
				$savedPreContentB = array();
				$savedPreFont = array();

				// mPDF 6
				// New line-breaking algorithm
				/////////////////////
				// LINE BREAKING
				/////////////////////
				$breakfound = false;
				$contentctr = count($content) - 1;
				if ($this->usingCoreFont) {
					$charctr = strlen($currContent);
				} else {
					$charctr = mb_strlen($currContent, $this->mb_enc);
				}
				$checkchar = $c;
				$prevchar = $this->_getPrevChar($contentctr, $charctr, $content);

				/* -- CJK-FONTS -- */
				/////////////////////
				// 1) CJK Overflowing a) punctuation or b) Oikomi
				/////////////////////
				// Next character ($c) is suitable to add as overhanging or squeezed punctuation, or Oikomi
				if ($CJKoverflow || $Oikomi) { // If flag already set
					$CJKoverflow = false;
					$Oikomi = false;
					$breakfound = true;
				}
				if (!$this->usingCoreFont && !$breakfound && $this->checkCJK) {
					// Get next/following character (in this chunk)
					$followingchar = '';
					if ($i < ($clen - 1)) {
						if ($this->usingCoreFont) {
							$followingchar = $s[$i + 1];
						} else {
							$followingchar = mb_substr($s, $i + 1, 1, $this->mb_enc);
						}
					}
					/////////////////////
					// 1a) Overflow punctuation
					/////////////////////
					if (preg_match("/[" . $this->pregCJKchars . "]/u", $prevchar) && preg_match("/[" . $this->CJKoverflow . "]/u", $checkchar) && $this->allowCJKorphans) {
						// add character onto this line
						$currContent .= $c;
						$contentWidth += $cw;
						$CJKoverflow = true; // Set flag
						continue;
					}
					/////////////////////
					// 1b) Try squeezing another character(s) onto this line = Oikomi, if character cannot end line
					//  or next character cannot start line (and not splitting CJK numerals)
					/////////////////////
					// NB otherwise it move lastchar(s) to next line to keep $c company = Oidashi, which is done below in standard way
					elseif (preg_match("/[" . $this->pregCJKchars . "]/u", $checkchar) && $this->allowCJKorphans &&
						(preg_match("/[" . $this->CJKleading . "]/u", $followingchar) || preg_match("/[" . $this->CJKfollowing . "]/u", $checkchar)) &&
						!preg_match("/[" . $this->CJKleading . "]/u", $checkchar) && !preg_match("/[" . $this->CJKfollowing . "]/u", $followingchar) &&
						!(preg_match("/[0-9\x{ff10}-\x{ff19}]/u", $followingchar) && preg_match("/[0-9\x{ff10}-\x{ff19}]/u", $checkchar))) {
						// add character onto this line
						$currContent .= $c;
						$contentWidth += $cw;
						$Oikomi = true; // Set flag
						continue;
					}
				}
				/* -- END CJK-FONTS -- */
				/* -- HYPHENATION -- */
				/////////////////////
				// AUTOMATIC HYPHENATION
				// 2) Automatic hyphen in current word (does not cross tags)
				/////////////////////
				if (isset($this->textparam['hyphens']) && $this->textparam['hyphens'] == 1) {
					$currWord = '';
					// Look back and ahead to get current word
					for ($ac = $charctr - 1; $ac >= 0; $ac--) {
						if ($this->usingCoreFont) {
							$addc = substr($currContent, $ac, 1);
						} else {
							$addc = mb_substr($currContent, $ac, 1, $this->mb_enc);
						}
						if ($addc == ' ') {
							break;
						}
						$currWord = $addc . $currWord;
					}
					$start = $ac + 1;
					for ($ac = $i; $ac < ($clen - 1); $ac++) {
						if ($this->usingCoreFont) {
							$addc = substr($s, $ac, 1);
						} else {
							$addc = mb_substr($s, $ac, 1, $this->mb_enc);
						}
						if ($addc == ' ') {
							break;
						}
						$currWord .= $addc;
					}
					$ptr = $this->hyphenateWord($currWord, $charctr - $start);
					if ($ptr > -1) {
						$breakfound = array($contentctr, $start + $ptr, $contentctr, $start + $ptr, 'hyphen');
					}
				}
				/* -- END HYPHENATION -- */

				// Search backwards to find first line-break opportunity
				while ($breakfound == false && $prevchar !== false) {
					$cutcontentctr = $contentctr;
					$cutcharctr = $charctr;
					$prevchar = $this->_moveToPrevChar($contentctr, $charctr, $content);
					/////////////////////
					// 3) Break at SPACE
					/////////////////////
					if ($prevchar == ' ') {
						$breakfound = array($contentctr, $charctr, $cutcontentctr, $cutcharctr, 'discard');
					}
					/////////////////////
					// 4) Break at U+200B in current word (Khmer, Lao & Thai Invisible word boundary, and Tibetan)
					/////////////////////
					elseif ($prevchar == "\xe2\x80\x8b") { // U+200B Zero-width Word Break
						$breakfound = array($contentctr, $charctr, $cutcontentctr, $cutcharctr, 'discard');
					}
					/////////////////////
					// 5) Break at Hard HYPHEN '-' or U+2010
					/////////////////////
					elseif (isset($this->textparam['hyphens']) && $this->textparam['hyphens'] != 2 && ($prevchar == '-' || $prevchar == "\xe2\x80\x90")) {
						// Don't break a URL
						// Look back to get first part of current word
						$checkw = '';
						for ($ac = $charctr - 1; $ac >= 0; $ac--) {
							if ($this->usingCoreFont) {
								$addc = substr($currContent, $ac, 1);
							} else {
								$addc = mb_substr($currContent, $ac, 1, $this->mb_enc);
							}
							if ($addc == ' ') {
								break;
							}
							$checkw = $addc . $checkw;
						}
						// Don't break if HyphenMinus AND (a URL or before a numeral or before a >)
						if ((!preg_match('/(http:|ftp:|https:|www\.)/', $checkw) && $checkchar != '>' && !preg_match('/[0-9]/', $checkchar)) || $prevchar == "\xe2\x80\x90") {
							$breakfound = array($cutcontentctr, $cutcharctr, $cutcontentctr, $cutcharctr, 'cut');
						}
					}
					/////////////////////
					// 6) Break at Soft HYPHEN (replace with hard hyphen)
					/////////////////////
					elseif (isset($this->textparam['hyphens']) && $this->textparam['hyphens'] != 2 && !$this->usingCoreFont && $prevchar == "\xc2\xad") {
						$breakfound = array($cutcontentctr, $cutcharctr, $cutcontentctr, $cutcharctr, 'cut');
						$content[$contentctr] = mb_substr($content[$contentctr], 0, $charctr, $this->mb_enc) . '-' . mb_substr($content[$contentctr], $charctr + 1, mb_strlen($content[$contentctr]), $this->mb_enc);
						if (!empty($cOTLdata[$contentctr])) {
							$cOTLdata[$contentctr]['char_data'][$charctr] = array('bidi_class' => 9, 'uni' => 45);
							$cOTLdata[$contentctr]['group'][$charctr] = 'C';
						}
					} elseif (isset($this->textparam['hyphens']) && $this->textparam['hyphens'] != 2 && $this->FontFamily != 'csymbol' && $this->FontFamily != 'czapfdingbats' && $prevchar == chr(173)) {
						$breakfound = array($cutcontentctr, $cutcharctr, $cutcontentctr, $cutcharctr, 'cut');
						$content[$contentctr] = substr($content[$contentctr], 0, $charctr) . '-' . substr($content[$contentctr], $charctr + 1);
					}
					/* -- CJK-FONTS -- */
					/////////////////////
					// 7) Break at CJK characters (unless forbidden characters to end or start line)
					// CJK Avoiding line break in the middle of numerals
					/////////////////////
					elseif (!$this->usingCoreFont && $this->checkCJK && preg_match("/[" . $this->pregCJKchars . "]/u", $checkchar) &&
						!preg_match("/[" . $this->CJKfollowing . "]/u", $checkchar) && !preg_match("/[" . $this->CJKleading . "]/u", $prevchar) &&
						!(preg_match("/[0-9\x{ff10}-\x{ff19}]/u", $prevchar) && preg_match("/[0-9\x{ff10}-\x{ff19}]/u", $checkchar))) {
						$breakfound = array($cutcontentctr, $cutcharctr, $cutcontentctr, $cutcharctr, 'cut');
					}
					/* -- END CJK-FONTS -- */
					/////////////////////
					// 8) Break at OBJECT (Break before all objects here - selected objects are moved forward to next line below e.g. dottab)
					/////////////////////
					if (isset($this->objectbuffer[$contentctr])) {
						$breakfound = array($cutcontentctr, $cutcharctr, $cutcontentctr, $cutcharctr, 'cut');
					}


					$checkchar = $prevchar;
				}

				// If a line-break opportunity found:
				if (is_array($breakfound)) {
					$contentctr = $breakfound[0];
					$charctr = $breakfound[1];
					$cutcontentctr = $breakfound[2];
					$cutcharctr = $breakfound[3];
					$type = $breakfound[4];
					// Cache chunks which are already processed, but now need to be passed on to the new line
					for ($ix = count($content) - 1; $ix > $cutcontentctr; $ix--) {
						// save and crop off any subsequent chunks
						/* -- OTL -- */
						if (!empty($sOTLdata)) {
							$tmpOTL = array_pop($cOTLdata);
							$savedPreOTLdata[] = $tmpOTL;
						}
						/* -- END OTL -- */
						$savedPreContent[] = array_pop($content);
						$savedPreContentB[] = array_pop($contentB);
						$savedPreFont[] = array_pop($font);
					}

					// Next cache the part which will start the next line
					if ($this->usingCoreFont) {
						$savedPreContent[] = substr($content[$cutcontentctr], $cutcharctr);
					} else {
						$savedPreContent[] = mb_substr($content[$cutcontentctr], $cutcharctr, mb_strlen($content[$cutcontentctr]), $this->mb_enc);
					}
					$savedPreContentB[] = preg_replace('/L/', '', $contentB[$cutcontentctr]);
					$savedPreFont[] = $font[$cutcontentctr];
					/* -- OTL -- */
					if (!empty($sOTLdata)) {
						$savedPreOTLdata[] = $this->otl->splitOTLdata($cOTLdata[$cutcontentctr], $cutcharctr, $cutcharctr);
					}
					/* -- END OTL -- */


					// Finally adjust the Current content which ends this line
					if ($cutcharctr == 0 && $type == 'discard') {
						array_pop($content);
						array_pop($contentB);
						array_pop($font);
						array_pop($cOTLdata);
					}

					$currContent = & $content[count($content) - 1];
					if ($this->usingCoreFont) {
						$currContent = substr($currContent, 0, $charctr);
					} else {
						$currContent = mb_substr($currContent, 0, $charctr, $this->mb_enc);
					}

					if (!empty($sOTLdata)) {
						$savedPreOTLdata[] = $this->otl->splitOTLdata($cOTLdata[(count($cOTLdata) - 1)], mb_strlen($currContent, $this->mb_enc));
					}

					if (strpos($contentB[(count($contentB) - 1)], 'R') !== false) {   // ???
						$contentB[count($content) - 1] = preg_replace('/R/', '', $contentB[count($content) - 1]); // ???
					}

					if ($type == 'hyphen') {
						$currContent .= '-';
						if (!empty($cOTLdata[(count($cOTLdata) - 1)])) {
							$cOTLdata[(count($cOTLdata) - 1)]['char_data'][] = array('bidi_class' => 9, 'uni' => 45);
							$cOTLdata[(count($cOTLdata) - 1)]['group'] .= 'C';
						}
					}

					$savedContent = '';
					$savedContentB = '';
					$savedFont = array();
					$savedOTLdata = array();
				}
				// If no line-break opportunity found - split at current position
				// or - Next character ($c) is suitable to add as overhanging or squeezed punctuation, or Oikomi, as set above by:
				// 1) CJK Overflowing a) punctuation or b) Oikomi
				// in which case $breakfound==1 and NOT array

				if (!is_array($breakfound)) {
					$savedFont = $this->saveFont();
					if (!empty($sOTLdata)) {
						$savedOTLdata = $this->otl->splitOTLdata($cOTLdata[(count($cOTLdata) - 1)], mb_strlen($currContent, $this->mb_enc));
					}
				}

				if ($content[count($content) - 1] == '' && !isset($this->objectbuffer[count($content) - 1])) {
					array_pop($content);
					array_pop($contentB);
					array_pop($font);
					array_pop($cOTLdata);
					$currContent = & $content[count($content) - 1];
				}

				// Right Trim current content - including CJK space, and for OTLdata
				// incl. CJK - strip CJK space at end of line &#x3000; = \xe3\x80\x80 = CJK space
				$currContent = rtrim($currContent);
				if ($this->checkCJK) {
					$currContent = preg_replace("/\xe3\x80\x80$/", '', $currContent);
				} // *CJK-FONTS*
				/* -- OTL -- */
				if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
					$this->otl->trimOTLdata($cOTLdata[count($cOTLdata) - 1], false, true); // NB also does U+3000
				}
				/* -- END OTL -- */


				// Selected OBJECTS are moved forward to next line, unless they come before a space or U+200B (type='discard')
				if (isset($this->objectbuffer[(count($content) - 1)]) && (!isset($type) || $type != 'discard')) {
					$objtype = $this->objectbuffer[(count($content) - 1)]['type'];
					if ($objtype == 'dottab' || $objtype == 'bookmark' || $objtype == 'indexentry' || $objtype == 'toc' || $objtype == 'annot') {
						$savedObj = array_pop($this->objectbuffer);
					}
				}


				// Decimal alignment (cancel if wraps to > 1 line)
				if ($is_table && substr($align, 0, 1) == 'D') {
					$align = substr($align, 2, 1);
				}

				$lineBox = array();

				$this->_setInlineBlockHeights($lineBox, $stackHeight, $content, $font, $is_table);

				// update $contentWidth since it has changed with cropping
				$contentWidth = 0;

				$inclCursive = false;
				foreach ($content as $k => $chunk) {
					if (isset($this->objectbuffer[$k]) && $this->objectbuffer[$k]) {
						// LIST MARKERS
						if ($this->objectbuffer[$k]['type'] == 'image' && isset($this->objectbuffer[$k]['listmarker']) && $this->objectbuffer[$k]['listmarker']) {
							if ($this->objectbuffer[$k]['listmarkerposition'] != 'outside') {
								$contentWidth += $this->objectbuffer[$k]['OUTER-WIDTH'] * _MPDFK;
							}
						} else {
							$contentWidth += $this->objectbuffer[$k]['OUTER-WIDTH'] * _MPDFK;
						}
					} elseif (!isset($this->objectbuffer[$k]) || (isset($this->objectbuffer[$k]) && !$this->objectbuffer[$k])) {
						$this->restoreFont($font[$k], false);
						if ($this->checkCJK && $k == count($content) - 1 && $CJKoverflow && $align == 'J' && $this->allowCJKoverflow && $this->CJKforceend) {
							// force-end overhang
							$hanger = mb_substr($chunk, mb_strlen($chunk, $this->mb_enc) - 1, 1, $this->mb_enc);
							// Probably ought to do something with char_data and GPOS in cOTLdata...
							$content[$k] = $chunk = mb_substr($chunk, 0, mb_strlen($chunk, $this->mb_enc) - 1, $this->mb_enc);
						}

						// Soft Hyphens chr(173) + Replace NBSP with SPACE + Set inclcursive if includes CURSIVE TEXT
						if (!$this->usingCoreFont) {
							/* -- OTL -- */
							if ((isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) || !empty($sOTLdata)) {
								$this->otl->removeChar($chunk, $cOTLdata[$k], "\xc2\xad");
								$this->otl->replaceSpace($chunk, $cOTLdata[$k]); // NBSP -> space
								if (preg_match("/([" . $this->pregCURSchars . "])/u", $chunk)) {
									$inclCursive = true;
								}
								$content[$k] = $chunk;
							}
							/* -- END OTL -- */ else {  // *OTL*
								$content[$k] = $chunk = str_replace("\xc2\xad", '', $chunk);
								$content[$k] = $chunk = str_replace(chr(194) . chr(160), chr(32), $chunk);
							} // *OTL*
						} elseif ($this->FontFamily != 'csymbol' && $this->FontFamily != 'czapfdingbats') {
							$content[$k] = $chunk = str_replace(chr(173), '', $chunk);
							$content[$k] = $chunk = str_replace(chr(160), chr(32), $chunk);
						}

						$contentWidth += $this->GetStringWidth($chunk, true, (isset($cOTLdata[$k]) ? $cOTLdata[$k] : false), $this->textvar) * _MPDFK;  // mPDF 5.7.1
						if (!empty($this->spanborddet)) {
							if (isset($this->spanborddet['L']['w']) && strpos($contentB[$k], 'L') !== false)
								$contentWidth += $this->spanborddet['L']['w'] * _MPDFK;
							if (isset($this->spanborddet['R']['w']) && strpos($contentB[$k], 'R') !== false)
								$contentWidth += $this->spanborddet['R']['w'] * _MPDFK;
						}
					}
				}

				$lastfontreqstyle = (isset($font[count($font) - 1]['ReqFontStyle']) ? $font[count($font) - 1]['ReqFontStyle'] : '');
				$lastfontstyle = (isset($font[count($font) - 1]['style']) ? $font[count($font) - 1]['style'] : '');
				if ($blockdir == 'ltr' && strpos($lastfontreqstyle, "I") !== false && strpos($lastfontstyle, "I") === false) { // Artificial italic
					$lastitalic = $this->FontSize * 0.15 * _MPDFK;
				} else {
					$lastitalic = 0;
				}




				// NOW FORMAT THE LINE TO OUTPUT
				if (!$table_draft) {
					// DIRECTIONALITY RTL
					$chunkorder = range(0, count($content) - 1); // mPDF 5.7
					/* -- OTL -- */
					// mPDF 6
					if ($blockdir == 'rtl' || $this->biDirectional) {
						$this->otl->_bidiReorder($chunkorder, $content, $cOTLdata, $blockdir);
						// From this point on, $content and $cOTLdata may contain more elements (and re-ordered) compared to
						// $this->objectbuffer and $font ($chunkorder contains the mapping)
					}

					/* -- END OTL -- */
					// Remove any XAdvance from OTL data at end of line
					foreach ($chunkorder AS $aord => $k) {
						if (count($cOTLdata)) {
							$this->restoreFont($font[$k], false);
							// ...WriteFlowingBlock...
							if ($aord == count($chunkorder) - 1 && isset($cOTLdata[$aord]['group'])) { // Last chunk on line
								$nGPOS = strlen($cOTLdata[$aord]['group']) - 1; // Last character
								if (isset($cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL']) || isset($cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceR'])) {
									if (isset($cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL'])) {
										$w = $cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL'] * 1000 / $this->CurrentFont['unitsPerEm'];
									} else {
										$w = $cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceR'] * 1000 / $this->CurrentFont['unitsPerEm'];
									}
									$w *= ($this->FontSize / 1000);
									$contentWidth -= $w * _MPDFK;
									$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL'] = 0;
									$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceR'] = 0;
								}

								// If last character has an XPlacement set, adjust width calculation, and add to XAdvance to account for it
								if (isset($cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XPlacement'])) {
									$w = -$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XPlacement'] * 1000 / $this->CurrentFont['unitsPerEm'];
									$w *= ($this->FontSize / 1000);
									$contentWidth -= $w * _MPDFK;
									$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceL'] = $cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XPlacement'];
									$cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XAdvanceR'] = $cOTLdata[$aord]['GPOSinfo'][$nGPOS]['XPlacement'];
								}
							}
						}
					}

					// JUSTIFICATION J
					$jcharspacing = 0;
					$jws = 0;
					$nb_carac = 0;
					$nb_spaces = 0;
					$jkashida = 0;
					// if it's justified, we need to find the char/word spacing (or if hanger $this->CJKforceend)
					if (($align == 'J' && !$CJKoverflow) || (($contentWidth + $lastitalic > $maxWidth - $WidthCorrection - (($this->cMarginL + $this->cMarginR) * _MPDFK) - ($paddingL + $paddingR + (($fpaddingL + $fpaddingR) * _MPDFK) ) + 0.001) && (!$CJKoverflow || ($CJKoverflow && !$this->allowCJKoverflow))) || $CJKoverflow && $align == 'J' && $this->allowCJKoverflow && $hanger && $this->CJKforceend) {   // 0.001 is to correct for deviations converting mm=>pts
						// JUSTIFY J (Use character spacing)
						// WORD SPACING
						foreach ($chunkorder AS $aord => $k) { // mPDF 5.7
							$chunk = $content[$aord];
							if (!isset($this->objectbuffer[$k]) || (isset($this->objectbuffer[$k]) && !$this->objectbuffer[$k])) {
								$nb_carac += mb_strlen($chunk, $this->mb_enc);
								$nb_spaces += mb_substr_count($chunk, ' ', $this->mb_enc);
								// Use GPOS OTL
								if (isset($this->CurrentFont['useOTL']) && ($this->CurrentFont['useOTL'] & 0xFF)) {
									if (isset($cOTLdata[$aord]['group']) && $cOTLdata[$aord]['group']) {
										$nb_carac -= substr_count($cOTLdata[$aord]['group'], 'M');
									}
								}
							} else {
								$nb_carac ++;
							} // mPDF 6 allow spacing for inline object
						}
						// GetJSpacing adds kashida spacing to GPOSinfo if appropriate for Font
						list($jcharspacing, $jws, $jkashida) = $this->GetJspacing($nb_carac, $nb_spaces, ($maxWidth - $lastitalic - $contentWidth - $WidthCorrection - (($this->cMarginL + $this->cMarginR) * _MPDFK) - ($paddingL + $paddingR + (($fpaddingL + $fpaddingR) * _MPDFK) )), $inclCursive, $cOTLdata);
					}

					// WORD SPACING
					$empty = $maxWidth - $lastitalic - $WidthCorrection - $contentWidth - (($this->cMarginL + $this->cMarginR) * _MPDFK) - ($paddingL + $paddingR + (($fpaddingL + $fpaddingR) * _MPDFK) );

					$empty -= ($jcharspacing * ($nb_carac - 1)); // mPDF 6 nb_carac MINUS 1
					$empty -= ($jws * $nb_spaces);
					$empty -= ($jkashida);
					$empty /= _MPDFK;

					$b = ''; //do not use borders
					// Get PAGEBREAK TO TEST for height including the top border/padding
					$check_h = max($this->divheight, $stackHeight);
					if (($newblock) && ($blockstate == 1 || $blockstate == 3) && ($this->blklvl > 0) && ($lineCount == 1) && (!$is_table)) {
						$check_h += ($this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['margin_top'] + $this->blk[$this->blklvl]['border_top']['w']);
					}

					if ($this->ColActive && $check_h > ($this->PageBreakTrigger - $this->y0)) {
						$this->SetCol($this->NbCol - 1);
					}

					// PAGEBREAK
					// 'If' below used in order to fix "first-line of other page with justify on" bug
					if (!$is_table && ($this->y + $check_h) > $this->PageBreakTrigger and ! $this->InFooter and $this->AcceptPageBreak()) {
						$bak_x = $this->x; //Current X position
						// WORD SPACING
						$ws = $this->ws; //Word Spacing
						$charspacing = $this->charspacing; //Character Spacing
						$this->ResetSpacing();

						$this->AddPage($this->CurOrientation);

						$this->x = $bak_x;
						// Added to correct for OddEven Margins
						$currentx += $this->MarginCorrection;
						$this->x += $this->MarginCorrection;

						// WORD SPACING
						$this->SetSpacing($charspacing, $ws);
					}

					if ($this->kwt && !$is_table) { // mPDF 5.7+
						$this->printkwtbuffer();
						$this->kwt = false;
					}


					/* -- COLUMNS -- */
					// COLS
					// COLUMN CHANGE
					if ($this->CurrCol != $oldcolumn) {
						$currentx += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
						$this->x += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
						$oldcolumn = $this->CurrCol;
					}

					if ($this->ColActive && !$is_table) {
						$this->breakpoints[$this->CurrCol][] = $this->y;
					} // *COLUMNS*
					/* -- END COLUMNS -- */

					// TOP MARGIN
					if (($newblock) && ($blockstate == 1 || $blockstate == 3) && ($this->blk[$this->blklvl]['margin_top']) && ($lineCount == 1) && (!$is_table)) {
						$this->DivLn($this->blk[$this->blklvl]['margin_top'], $this->blklvl - 1, true, $this->blk[$this->blklvl]['margin_collapse']);
						if ($this->ColActive) {
							$this->breakpoints[$this->CurrCol][] = $this->y;
						} // *COLUMNS*
					}


					// Update y0 for top of block (used to paint border)
					if (($newblock) && ($blockstate == 1 || $blockstate == 3) && ($lineCount == 1) && (!$is_table)) {
						$this->blk[$this->blklvl]['y0'] = $this->y;
						$this->blk[$this->blklvl]['startpage'] = $this->page;
						if ($this->blk[$this->blklvl]['float']) {
							$this->blk[$this->blklvl]['float_start_y'] = $this->y;
						}
					}

					// TOP PADDING and BORDER spacing/fill
					if (($newblock) && ($blockstate == 1 || $blockstate == 3) && (($this->blk[$this->blklvl]['padding_top']) || ($this->blk[$this->blklvl]['border_top'])) && ($lineCount == 1) && (!$is_table)) {
						// $state = 0 normal; 1 top; 2 bottom; 3 top and bottom
						$this->DivLn($this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['border_top']['w'], -3, true, false, 1);
						if ($this->ColActive) {
							$this->breakpoints[$this->CurrCol][] = $this->y;
						} // *COLUMNS*
					}

					$arraysize = count($chunkorder);

					$margins = ($this->cMarginL + $this->cMarginR) + ($ipaddingL + $ipaddingR + $fpaddingR + $fpaddingR );

					// PAINT BACKGROUND FOR THIS LINE
					if (!$is_table) {
						$this->DivLn($stackHeight, $this->blklvl, false);
					} // false -> don't advance y

					$this->x = $currentx + $this->cMarginL + $ipaddingL + $fpaddingL;
					if ($align == 'R') {
						$this->x += $empty;
					} elseif ($align == 'C') {
						$this->x += ($empty / 2);
					}

					// Paragraph INDENT
					if (isset($this->blk[$this->blklvl]['text_indent']) && ($newblock) && ($blockstate == 1 || $blockstate == 3) && ($lineCount == 1) && (!$is_table) && ($blockdir != 'rtl') && ($align != 'C')) {
						$ti = $this->ConvertSize($this->blk[$this->blklvl]['text_indent'], $this->blk[$this->blklvl]['inner_width'], $this->blk[$this->blklvl]['InlineProperties']['size'], false);  // mPDF 5.7.4
						$this->x += $ti;
					}

					// BIDI magic_reverse moved upwards from here

					foreach ($chunkorder AS $aord => $k) { // mPDF 5.7
						$chunk = $content[$aord];

						if (isset($this->objectbuffer[$k]) && $this->objectbuffer[$k]) {
							$xadj = $this->x - $this->objectbuffer[$k]['OUTER-X'];
							$this->objectbuffer[$k]['OUTER-X'] += $xadj;
							$this->objectbuffer[$k]['BORDER-X'] += $xadj;
							$this->objectbuffer[$k]['INNER-X'] += $xadj;

							if ($this->objectbuffer[$k]['type'] == 'listmarker') {
								$this->objectbuffer[$k]['lineBox'] = $lineBox[-1]; // Block element details for glyph-origin
							}
							$yadj = $this->y - $this->objectbuffer[$k]['OUTER-Y'];
							if ($this->objectbuffer[$k]['type'] == 'dottab') { // mPDF 6 DOTTAB
								$this->objectbuffer[$k]['lineBox'] = $lineBox[$k]; // element details for glyph-origin
							}
							if ($this->objectbuffer[$k]['type'] != 'dottab') { // mPDF 6 DOTTAB
								$yadj += $lineBox[$k]['top'];
							}
							$this->objectbuffer[$k]['OUTER-Y'] += $yadj;
							$this->objectbuffer[$k]['BORDER-Y'] += $yadj;
							$this->objectbuffer[$k]['INNER-Y'] += $yadj;
						}

						$this->restoreFont($font[$k]);  // mPDF 5.7

						$this->SetSpacing(($this->fixedlSpacing * _MPDFK) + $jcharspacing, ($this->fixedlSpacing + $this->minwSpacing) * _MPDFK + $jws);
						// Now unset these values so they don't influence GetStringwidth below or in fn. Cell
						$this->fixedlSpacing = false;
						$this->minwSpacing = 0;

						$save_vis = $this->visibility;
						if (isset($this->textparam['visibility']) && $this->textparam['visibility'] && $this->textparam['visibility'] != $this->visibility) {
							$this->SetVisibility($this->textparam['visibility']);
						}
						// *********** SPAN BACKGROUND COLOR ***************** //
						if ($this->spanbgcolor) {
							$cor = $this->spanbgcolorarray;
							$this->SetFColor($cor);
							$save_fill = $fill;
							$spanfill = 1;
							$fill = 1;
						}
						if (!empty($this->spanborddet)) {
							if (strpos($contentB[$k], 'L') !== false)
								$this->x += (isset($this->spanborddet['L']['w']) ? $this->spanborddet['L']['w'] : 0);
							if (strpos($contentB[$k], 'L') === false)
								$this->spanborddet['L']['s'] = $this->spanborddet['L']['w'] = 0;
							if (strpos($contentB[$k], 'R') === false)
								$this->spanborddet['R']['s'] = $this->spanborddet['R']['w'] = 0;
						}

						// WORD SPACING
						// StringWidth this time includes any kashida spacing
						$stringWidth = $this->GetStringWidth($chunk, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar, true);

						$nch = mb_strlen($chunk, $this->mb_enc);
						// Use GPOS OTL
						if (isset($this->CurrentFont['useOTL']) && ($this->CurrentFont['useOTL'] & 0xFF)) {
							if (isset($cOTLdata[$aord]['group']) && $cOTLdata[$aord]['group']) {
								$nch -= substr_count($cOTLdata[$aord]['group'], 'M');
							}
						}
						$stringWidth += ( $this->charspacing * $nch / _MPDFK );

						$stringWidth += ( $this->ws * mb_substr_count($chunk, ' ', $this->mb_enc) / _MPDFK );

						if (isset($this->objectbuffer[$k])) {
							// LIST MARKERS	// mPDF 6  Lists
							if ($this->objectbuffer[$k]['type'] == 'image' && isset($this->objectbuffer[$k]['listmarker']) && $this->objectbuffer[$k]['listmarker'] && $this->objectbuffer[$k]['listmarkerposition'] == 'outside') {
								$stringWidth = 0;
							} else {
								$stringWidth = $this->objectbuffer[$k]['OUTER-WIDTH'];
							}
						}

						if ($stringWidth == 0) {
							$stringWidth = 0.000001;
						}

						if ($aord == $arraysize - 1) {
							$stringWidth -= ( $this->charspacing / _MPDFK );
							if ($this->checkCJK && $CJKoverflow && $align == 'J' && $this->allowCJKoverflow && $hanger && $this->CJKforceend) {
								// force-end overhang
								$this->Cell($stringWidth, $stackHeight, $chunk, '', 0, '', $fill, $this->HREF, $currentx, 0, 0, 'M', $fill, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar, (isset($lineBox[$k]) ? $lineBox[$k] : false));
								$this->Cell($this->GetStringWidth($hanger), $stackHeight, $hanger, '', 1, '', $fill, $this->HREF, $currentx, 0, 0, 'M', $fill, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar, (isset($lineBox[$k]) ? $lineBox[$k] : false));
							} else {
								$this->Cell($stringWidth, $stackHeight, $chunk, '', 1, '', $fill, $this->HREF, $currentx, 0, 0, 'M', $fill, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar, (isset($lineBox[$k]) ? $lineBox[$k] : false)); //mono-style line or last part (skips line)
							}
						} else
							$this->Cell($stringWidth, $stackHeight, $chunk, '', 0, '', $fill, $this->HREF, 0, 0, 0, 'M', $fill, true, (isset($cOTLdata[$aord]) ? $cOTLdata[$aord] : false), $this->textvar, (isset($lineBox[$k]) ? $lineBox[$k] : false)); //first or middle part

						if (!empty($this->spanborddet)) {
							if (strpos($contentB[$k], 'R') !== false && $aord != $arraysize - 1)
								$this->x += $this->spanborddet['R']['w'];
						}
						// *********** SPAN BACKGROUND COLOR OFF - RESET BLOCK BGCOLOR ***************** //
						if (isset($spanfill) && $spanfill) {
							$fill = $save_fill;
							$spanfill = 0;
							if ($fill) {
								$this->SetFColor($bcor);
							}
						}
						if (isset($this->textparam['visibility']) && $this->textparam['visibility'] && $this->visibility != $save_vis) {
							$this->SetVisibility($save_vis);
						}
					}
				} elseif ($table_draft) {
					$this->y += $stackHeight;
				}

				if (!$is_table) {
					$this->maxPosR = max($this->maxPosR, ($this->w - $this->rMargin - $this->blk[$this->blklvl]['outer_right_margin']));
					$this->maxPosL = min($this->maxPosL, ($this->lMargin + $this->blk[$this->blklvl]['outer_left_margin']));
				}

				// move on to the next line, reset variables, tack on saved content and current char

				if (!$table_draft)
					$this->printobjectbuffer($is_table, $blockdir);
				$this->objectbuffer = array();


				/* -- CSS-IMAGE-FLOAT -- */
				// Update values if set to skipline
				if ($this->floatmargins) {
					$this->_advanceFloatMargins();
				}
				/* -- END CSS-IMAGE-FLOAT -- */

				// Reset lineheight
				$stackHeight = $this->divheight;
				$valign = 'M';

				$font = array();
				$content = array();
				$contentB = array();
				$cOTLdata = array(); // mPDF 5.7.1
				$contentWidth = 0;
				if (!empty($savedObj)) {
					$this->objectbuffer[] = $savedObj;
					$font[] = $savedFont;
					$content[] = '';
					$contentB[] = '';
					$cOTLdata[] = array(); // mPDF 5.7.1
					$contentWidth += $savedObj['OUTER-WIDTH'] * _MPDFK;
				}
				if (count($savedPreContent) > 0) {
					for ($ix = count($savedPreContent) - 1; $ix >= 0; $ix--) {
						$font[] = $savedPreFont[$ix];
						$content[] = $savedPreContent[$ix];
						$contentB[] = $savedPreContentB[$ix];
						if (!empty($sOTLdata)) {
							$cOTLdata[] = $savedPreOTLdata[$ix];
						}
						$this->restoreFont($savedPreFont[$ix]);
						$lbw = $rbw = 0; // Border widths
						if (!empty($this->spanborddet)) {
							$lbw = (isset($this->spanborddet['L']['w']) ? $this->spanborddet['L']['w'] : 0);
							$rbw = (isset($this->spanborddet['R']['w']) ? $this->spanborddet['R']['w'] : 0);
						}
						if ($ix > 0) {
							$contentWidth += $this->GetStringWidth($savedPreContent[$ix], true, (isset($savedPreOTLdata[$ix]) ? $savedPreOTLdata[$ix] : false), $this->textvar) * _MPDFK; // mPDF 5.7.1
							if (strpos($savedPreContentB[$ix], 'L') !== false)
								$contentWidth += $lbw;
							if (strpos($savedPreContentB[$ix], 'R') !== false)
								$contentWidth += $rbw;
						}
					}
					$savedPreContent = array();
					$savedPreContentB = array();
					$savedPreOTLdata = array(); // mPDF 5.7.1
					$savedPreFont = array();
					$content[(count($content) - 1)] .= $c;
				}
				else {
					$font[] = $savedFont;
					$content[] = $savedContent . $c;
					$contentB[] = $savedContentB;
					$cOTLdata[] = $savedOTLdata; // mPDF 5.7.1
				}

				$currContent = & $content[(count($content) - 1)];
				$this->restoreFont($font[(count($font) - 1)]); // mPDF 6.0

				/* -- CJK-FONTS -- */
				// CJK - strip CJK space at start of line
				// &#x3000; = \xe3\x80\x80 = CJK space
				if ($this->checkCJK && $currContent == "\xe3\x80\x80") {
					$currContent = '';
					if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
						$this->otl->trimOTLdata($cOTLdata[count($cOTLdata) - 1], true, false); // left trim U+3000
					}
				}
				/* -- END CJK-FONTS -- */

				$lbw = $rbw = 0; // Border widths
				if (!empty($this->spanborddet)) {
					$lbw = (isset($this->spanborddet['L']['w']) ? $this->spanborddet['L']['w'] : 0);
					$rbw = (isset($this->spanborddet['R']['w']) ? $this->spanborddet['R']['w'] : 0);
				}

				$contentWidth += $this->GetStringWidth($currContent, false, (isset($cOTLdata[(count($cOTLdata) - 1)]) ? $cOTLdata[(count($cOTLdata) - 1)] : false), $this->textvar) * _MPDFK; // mPDF 5.7.1
				if (strpos($savedContentB, 'L') !== false)
					$contentWidth += $lbw;
				$CJKoverflow = false;
				$hanger = '';
			}
			// another character will fit, so add it on
			else {
				$contentWidth += $cw;
				$currContent .= $c;
			}
		}

		unset($content);
		unset($contentB);
	}

	//----------------------END OF FLOWING BLOCK------------------------------------//


	/* -- CSS-IMAGE-FLOAT -- */
	// Update values if set to skipline
	function _advanceFloatMargins()
	{
		// Update floatmargins - L
		if (isset($this->floatmargins['L']) && $this->floatmargins['L']['skipline'] && $this->floatmargins['L']['y0'] != $this->y) {
			$yadj = $this->y - $this->floatmargins['L']['y0'];
			$this->floatmargins['L']['y0'] = $this->y;
			$this->floatmargins['L']['y1'] += $yadj;

			// Update objattr in floatbuffer
			if ($this->floatbuffer[$this->floatmargins['L']['id']]['border_left']['w']) {
				$this->floatbuffer[$this->floatmargins['L']['id']]['BORDER-Y'] += $yadj;
			}
			$this->floatbuffer[$this->floatmargins['L']['id']]['INNER-Y'] += $yadj;
			$this->floatbuffer[$this->floatmargins['L']['id']]['OUTER-Y'] += $yadj;

			// Unset values
			$this->floatbuffer[$this->floatmargins['L']['id']]['skipline'] = false;
			$this->floatmargins['L']['skipline'] = false;
			$this->floatmargins['L']['id'] = '';
		}
		// Update floatmargins - R
		if (isset($this->floatmargins['R']) && $this->floatmargins['R']['skipline'] && $this->floatmargins['R']['y0'] != $this->y) {
			$yadj = $this->y - $this->floatmargins['R']['y0'];
			$this->floatmargins['R']['y0'] = $this->y;
			$this->floatmargins['R']['y1'] += $yadj;

			// Update objattr in floatbuffer
			if ($this->floatbuffer[$this->floatmargins['R']['id']]['border_left']['w']) {
				$this->floatbuffer[$this->floatmargins['R']['id']]['BORDER-Y'] += $yadj;
			}
			$this->floatbuffer[$this->floatmargins['R']['id']]['INNER-Y'] += $yadj;
			$this->floatbuffer[$this->floatmargins['R']['id']]['OUTER-Y'] += $yadj;

			// Unset values
			$this->floatbuffer[$this->floatmargins['R']['id']]['skipline'] = false;
			$this->floatmargins['R']['skipline'] = false;
			$this->floatmargins['R']['id'] = '';
		}
	}

	/* -- END CSS-IMAGE-FLOAT -- */



	/* -- END HTML-CSS -- */

	function _SetTextRendering($mode)
	{
		if (!(($mode == 0) || ($mode == 1) || ($mode == 2)))
			throw new MpdfException("Text rendering mode should be 0, 1 or 2 (value : $mode)");
		$tr = ($mode . ' Tr');
		if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['TextRendering']) && $this->pageoutput[$this->page]['TextRendering'] != $tr) || !isset($this->pageoutput[$this->page]['TextRendering']))) {
			$this->_out($tr);
		}
		$this->pageoutput[$this->page]['TextRendering'] = $tr;
	}

	function SetTextOutline($params = array())
	{
		if (isset($params['outline-s']) && $params['outline-s']) {
			$this->SetLineWidth($params['outline-WIDTH']);
			$this->SetDColor($params['outline-COLOR']);
			$tr = ('2 Tr');
			if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['TextRendering']) && $this->pageoutput[$this->page]['TextRendering'] != $tr) || !isset($this->pageoutput[$this->page]['TextRendering']))) {
				$this->_out($tr);
			}
			$this->pageoutput[$this->page]['TextRendering'] = $tr;
		} else { //Now resets all values
			$this->SetLineWidth(0.2);
			$this->SetDColor($this->ConvertColor(0));
			$this->_SetTextRendering(0);
			$tr = ('0 Tr');
			if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['TextRendering']) && $this->pageoutput[$this->page]['TextRendering'] != $tr) || !isset($this->pageoutput[$this->page]['TextRendering']))) {
				$this->_out($tr);
			}
			$this->pageoutput[$this->page]['TextRendering'] = $tr;
		}
	}

	function Image($file, $x, $y, $w = 0, $h = 0, $type = '', $link = '', $paint = true, $constrain = true, $watermark = false, $shownoimg = true, $allowvector = true)
	{
		$orig_srcpath = $file;
		$this->GetFullPath($file);

		$info = $this->_getImage($file, true, $allowvector, $orig_srcpath);
		if (!$info && $paint) {
			$info = $this->_getImage($this->noImageFile);
			if ($info) {
				$file = $this->noImageFile;
				$w = ($info['w'] * (25.4 / $this->dpi));  // 14 x 16px
				$h = ($info['h'] * (25.4 / $this->dpi));  // 14 x 16px
			}
		}
		if (!$info)
			return false;
		//Automatic width and height calculation if needed
		if ($w == 0 and $h == 0) {
			/* -- IMAGES-WMF -- */
			if ($info['type'] == 'wmf') {
				// WMF units are twips (1/20pt)
				// divide by 20 to get points
				// divide by k to get user units
				$w = abs($info['w']) / (20 * _MPDFK);
				$h = abs($info['h']) / (20 * _MPDFK);
			} else
			/* -- END IMAGES-WMF -- */
			if ($info['type'] == 'svg') {
				// returned SVG units are pts
				// divide by k to get user units (mm)
				$w = abs($info['w']) / _MPDFK;
				$h = abs($info['h']) / _MPDFK;
			} else {
				//Put image at default image dpi
				$w = ($info['w'] / _MPDFK) * (72 / $this->img_dpi);
				$h = ($info['h'] / _MPDFK) * (72 / $this->img_dpi);
			}
		}
		if ($w == 0)
			$w = abs($h * $info['w'] / $info['h']);
		if ($h == 0)
			$h = abs($w * $info['h'] / $info['w']);

		/* -- WATERMARK -- */
		if ($watermark) {
			$maxw = $this->w;
			$maxh = $this->h;
			// Size = D PF or array
			if (is_array($this->watermark_size)) {
				$w = $this->watermark_size[0];
				$h = $this->watermark_size[1];
			} elseif (!is_string($this->watermark_size)) {
				$maxw -= $this->watermark_size * 2;
				$maxh -= $this->watermark_size * 2;
				$w = $maxw;
				$h = abs($w * $info['h'] / $info['w']);
				if ($h > $maxh) {
					$h = $maxh;
					$w = abs($h * $info['w'] / $info['h']);
				}
			} elseif ($this->watermark_size == 'F') {
				if ($this->ColActive) {
					$maxw = $this->w - ($this->DeflMargin + $this->DefrMargin);
				} else {
					$maxw = $this->pgwidth;
				}
				$maxh = $this->h - ($this->tMargin + $this->bMargin);
				$w = $maxw;
				$h = abs($w * $info['h'] / $info['w']);
				if ($h > $maxh) {
					$h = $maxh;
					$w = abs($h * $info['w'] / $info['h']);
				}
			} elseif ($this->watermark_size == 'P') { // Default P
				$w = $maxw;
				$h = abs($w * $info['h'] / $info['w']);
				if ($h > $maxh) {
					$h = $maxh;
					$w = abs($h * $info['w'] / $info['h']);
				}
			}
			// Automatically resize to maximum dimensions of page if too large
			if ($w > $maxw) {
				$w = $maxw;
				$h = abs($w * $info['h'] / $info['w']);
			}
			if ($h > $maxh) {
				$h = $maxh;
				$w = abs($h * $info['w'] / $info['h']);
			}
			// Position
			if (is_array($this->watermark_pos)) {
				$x = $this->watermark_pos[0];
				$y = $this->watermark_pos[1];
			} elseif ($this->watermark_pos == 'F') { // centred on printable area
				if ($this->ColActive) { // *COLUMNS*
					if (($this->mirrorMargins) && (($this->page) % 2 == 0)) {
						$xadj = $this->DeflMargin - $this->DefrMargin;
					} // *COLUMNS*
					else {
						$xadj = 0;
					} // *COLUMNS*
					$x = ($this->DeflMargin - $xadj + ($this->w - ($this->DeflMargin + $this->DefrMargin)) / 2) - ($w / 2); // *COLUMNS*
				} // *COLUMNS*
				else {  // *COLUMNS*
					$x = ($this->lMargin + ($this->pgwidth) / 2) - ($w / 2);
				} // *COLUMNS*
				$y = ($this->tMargin + ($this->h - ($this->tMargin + $this->bMargin)) / 2) - ($h / 2);
			} else { // default P - centred on whole page
				$x = ($this->w / 2) - ($w / 2);
				$y = ($this->h / 2) - ($h / 2);
			}
			/* -- IMAGES-WMF -- */
			if ($info['type'] == 'wmf') {
				$sx = $w * _MPDFK / $info['w'];
				$sy = -$h * _MPDFK / $info['h'];
				$outstring = sprintf('q %.3F 0 0 %.3F %.3F %.3F cm /FO%d Do Q', $sx, $sy, $x * _MPDFK - $sx * $info['x'], (($this->h - $y) * _MPDFK) - $sy * $info['y'], $info['i']);
			} else
			/* -- END IMAGES-WMF -- */
			if ($info['type'] == 'svg') {
				$sx = $w * _MPDFK / $info['w'];
				$sy = -$h * _MPDFK / $info['h'];
				$outstring = sprintf('q %.3F 0 0 %.3F %.3F %.3F cm /FO%d Do Q', $sx, $sy, $x * _MPDFK - $sx * $info['x'], (($this->h - $y) * _MPDFK) - $sy * $info['y'], $info['i']);
			} else {
				$outstring = sprintf("q %.3F 0 0 %.3F %.3F %.3F cm /I%d Do Q", $w * _MPDFK, $h * _MPDFK, $x * _MPDFK, ($this->h - ($y + $h)) * _MPDFK, $info['i']);
			}

			if ($this->watermarkImgBehind) {
				$outstring = $this->watermarkImgAlpha . "\n" . $outstring . "\n" . $this->SetAlpha(1, 'Normal', true) . "\n";
				$this->pages[$this->page] = preg_replace('/(___BACKGROUND___PATTERNS' . $this->uniqstr . ')/', "\n" . $outstring . "\n" . '\\1', $this->pages[$this->page]);
			} else {
				$this->_out($outstring);
			}

			return 0;
		} // end of IF watermark
		/* -- END WATERMARK -- */

		if ($constrain) {
			// Automatically resize to maximum dimensions of page if too large
			if (isset($this->blk[$this->blklvl]['inner_width']) && $this->blk[$this->blklvl]['inner_width']) {
				$maxw = $this->blk[$this->blklvl]['inner_width'];
			} else {
				$maxw = $this->pgwidth;
			}
			if ($w > $maxw) {
				$w = $maxw;
				$h = abs($w * $info['h'] / $info['w']);
			}
			if ($h > $this->h - ($this->tMargin + $this->bMargin + 1)) {  // see below - +10 to avoid drawing too close to border of page
				$h = $this->h - ($this->tMargin + $this->bMargin + 1);
				if ($this->fullImageHeight) {
					$h = $this->fullImageHeight;
				}
				$w = abs($h * $info['w'] / $info['h']);
			}


			//Avoid drawing out of the paper(exceeding width limits).
			//if ( ($x + $w) > $this->fw ) {
			if (($x + $w) > $this->w) {
				$x = $this->lMargin;
				$y += 5;
			}

			$changedpage = false;
			$oldcolumn = $this->CurrCol;
			//Avoid drawing out of the page.
			if ($y + $h > $this->PageBreakTrigger and ! $this->InFooter and $this->AcceptPageBreak()) {
				$this->AddPage($this->CurOrientation);
				// Added to correct for OddEven Margins
				$x = $x + $this->MarginCorrection;
				$y = $this->tMargin; // mPDF 5.7.3
				$changedpage = true;
			}
			/* -- COLUMNS -- */
			// COLS
			// COLUMN CHANGE
			if ($this->CurrCol != $oldcolumn) {
				$y = $this->y0;
				$x += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
				$this->x += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
			}
			/* -- END COLUMNS -- */
		} // end of IF constrain

		/* -- IMAGES-WMF -- */
		if ($info['type'] == 'wmf') {
			$sx = $w * _MPDFK / $info['w'];
			$sy = -$h * _MPDFK / $info['h'];
			$outstring = sprintf('q %.3F 0 0 %.3F %.3F %.3F cm /FO%d Do Q', $sx, $sy, $x * _MPDFK - $sx * $info['x'], (($this->h - $y) * _MPDFK) - $sy * $info['y'], $info['i']);
		} else
		/* -- END IMAGES-WMF -- */
		if ($info['type'] == 'svg') {
			$sx = $w * _MPDFK / $info['w'];
			$sy = -$h * _MPDFK / $info['h'];
			$outstring = sprintf('q %.3F 0 0 %.3F %.3F %.3F cm /FO%d Do Q', $sx, $sy, $x * _MPDFK - $sx * $info['x'], (($this->h - $y) * _MPDFK) - $sy * $info['y'], $info['i']);
		} else {
			$outstring = sprintf("q %.3F 0 0 %.3F %.3F %.3F cm /I%d Do Q", $w * _MPDFK, $h * _MPDFK, $x * _MPDFK, ($this->h - ($y + $h)) * _MPDFK, $info['i']);
		}

		if ($paint) {
			$this->_out($outstring);
			if ($link)
				$this->Link($x, $y, $w, $h, $link);

			// Avoid writing text on top of the image. // THIS WAS OUTSIDE THE if ($paint) bit!!!!!!!!!!!!!!!!
			$this->y = $y + $h;
		}

		//Return width-height array
		$sizesarray['WIDTH'] = $w;
		$sizesarray['HEIGHT'] = $h;
		$sizesarray['X'] = $x; //Position before painting image
		$sizesarray['Y'] = $y; //Position before painting image
		$sizesarray['OUTPUT'] = $outstring;

		$sizesarray['IMAGE_ID'] = $info['i'];
		$sizesarray['itype'] = $info['type'];
		$sizesarray['set-dpi'] = (isset($info['set-dpi']) ? $info['set-dpi'] : 0);
		return $sizesarray;
	}

	//=============================================================
	//=============================================================
	//=============================================================
	//=============================================================
	//=============================================================
	/* -- HTML-CSS -- */

	function _getObjAttr($t)
	{
		$c = explode("\xbb\xa4\xac", $t, 2);
		$c = explode(",", $c[1], 2);
		foreach ($c as $v) {
			$v = explode("=", $v, 2);
			$sp[$v[0]] = $v[1];
		}
		return (unserialize($sp['objattr']));
	}

	function inlineObject($type, $x, $y, $objattr, $Lmargin, $widthUsed, $maxWidth, $lineHeight, $paint = false, $is_table = false)
	{
		if ($is_table) {
			$k = $this->shrin_k;
		} else {
			$k = 1;
		}

		// NB $x is only used when paint=true
		// Lmargin not used
		$w = 0;
		if (isset($objattr['width'])) {
			$w = $objattr['width'] / $k;
		}
		$h = 0;
		if (isset($objattr['height'])) {
			$h = abs($objattr['height'] / $k);
		}
		$widthLeft = $maxWidth - $widthUsed;
		$maxHeight = $this->h - ($this->tMargin + $this->bMargin + 10);
		if ($this->fullImageHeight) {
			$maxHeight = $this->fullImageHeight;
		}
		// For Images
		if (isset($objattr['border_left'])) {
			$extraWidth = ($objattr['border_left']['w'] + $objattr['border_right']['w'] + $objattr['margin_left'] + $objattr['margin_right']) / $k;
			$extraHeight = ($objattr['border_top']['w'] + $objattr['border_bottom']['w'] + $objattr['margin_top'] + $objattr['margin_bottom']) / $k;

			if ($type == 'image' || $type == 'barcode' || $type == 'textcircle') {
				$extraWidth += ($objattr['padding_left'] + $objattr['padding_right']) / $k;
				$extraHeight += ($objattr['padding_top'] + $objattr['padding_bottom']) / $k;
			}
		}

		if (!isset($objattr['vertical-align'])) {
			if ($objattr['type'] == 'select') {
				$objattr['vertical-align'] = 'M';
			} else {
				$objattr['vertical-align'] = 'BS';
			}
		} // mPDF 6

		if ($type == 'image' || (isset($objattr['subtype']) && $objattr['subtype'] == 'IMAGE')) {
			if (isset($objattr['itype']) && ($objattr['itype'] == 'wmf' || $objattr['itype'] == 'svg')) {
				$file = $objattr['file'];
				$info = $this->formobjects[$file];
			} elseif (isset($objattr['file'])) {
				$file = $objattr['file'];
				$info = $this->images[$file];
			}
		}
		if ($type == 'annot' || $type == 'bookmark' || $type == 'indexentry' || $type == 'toc') {
			$w = 0.00001;
			$h = 0.00001;
		}

		// TEST whether need to skipline
		if (!$paint) {
			if ($type == 'hr') { // always force new line
				if (($y + $h + $lineHeight > $this->PageBreakTrigger) && !$this->InFooter && !$is_table) {
					return array(-2, $w, $h);
				} // New page + new line
				else {
					return array(1, $w, $h);
				} // new line
			} else {
				// LIST MARKERS	// mPDF 6  Lists
				$displayheight = $h;
				$displaywidth = $w;
				if ($objattr['type'] == 'image' && isset($objattr['listmarker']) && $objattr['listmarker']) {
					$displayheight = 0;
					if ($objattr['listmarkerposition'] == 'outside') {
						$displaywidth = 0;
					}
				}

				if ($widthUsed > 0 && $displaywidth > $widthLeft && (!$is_table || $type != 'image')) {  // New line needed
					// mPDF 6  Lists
					if (($y + $displayheight + $lineHeight > $this->PageBreakTrigger) && !$this->InFooter) {
						return array(-2, $w, $h);
					} // New page + new line
					return array(1, $w, $h); // new line
				} elseif ($widthUsed > 0 && $displaywidth > $widthLeft && $is_table) {  // New line needed in TABLE
					return array(1, $w, $h); // new line
				}
				// Will fit on line but NEW PAGE REQUIRED
				elseif (($y + $displayheight > $this->PageBreakTrigger) && !$this->InFooter && !$is_table) {
					return array(-1, $w, $h);
				} // mPDF 6  Lists
				else {
					return array(0, $w, $h);
				}
			}
		}

		if ($type == 'annot' || $type == 'bookmark' || $type == 'indexentry' || $type == 'toc') {
			$w = 0.00001;
			$h = 0.00001;
			$objattr['BORDER-WIDTH'] = 0;
			$objattr['BORDER-HEIGHT'] = 0;
			$objattr['BORDER-X'] = $x;
			$objattr['BORDER-Y'] = $y;
			$objattr['INNER-WIDTH'] = 0;
			$objattr['INNER-HEIGHT'] = 0;
			$objattr['INNER-X'] = $x;
			$objattr['INNER-Y'] = $y;
		}

		if ($type == 'image') {
			// Automatically resize to width remaining
			if ($w > ($widthLeft + 0.0001) && !$is_table) { // mPDF 5.7.4  0.0001 to allow for rounding errors when w==maxWidth
				$w = $widthLeft;
				$h = abs($w * $info['h'] / $info['w']);
			}
			$img_w = $w - $extraWidth;
			$img_h = $h - $extraHeight;

			$objattr['BORDER-WIDTH'] = $img_w + $objattr['padding_left'] / $k + $objattr['padding_right'] / $k + (($objattr['border_left']['w'] / $k + $objattr['border_right']['w'] / $k) / 2);
			$objattr['BORDER-HEIGHT'] = $img_h + $objattr['padding_top'] / $k + $objattr['padding_bottom'] / $k + (($objattr['border_top']['w'] / $k + $objattr['border_bottom']['w'] / $k) / 2);
			$objattr['BORDER-X'] = $x + $objattr['margin_left'] / $k + (($objattr['border_left']['w'] / $k) / 2);
			$objattr['BORDER-Y'] = $y + $objattr['margin_top'] / $k + (($objattr['border_top']['w'] / $k) / 2);
			$objattr['INNER-WIDTH'] = $img_w;
			$objattr['INNER-HEIGHT'] = $img_h;
			$objattr['INNER-X'] = $x + $objattr['padding_left'] / $k + $objattr['margin_left'] / $k + ($objattr['border_left']['w'] / $k);
			$objattr['INNER-Y'] = $y + $objattr['padding_top'] / $k + $objattr['margin_top'] / $k + ($objattr['border_top']['w'] / $k);
			$objattr['ID'] = $info['i'];
		}

		if ($type == 'input' && $objattr['subtype'] == 'IMAGE') {
			$img_w = $w - $extraWidth;
			$img_h = $h - $extraHeight;
			$objattr['BORDER-WIDTH'] = $img_w + (($objattr['border_left']['w'] / $k + $objattr['border_right']['w'] / $k) / 2);
			$objattr['BORDER-HEIGHT'] = $img_h + (($objattr['border_top']['w'] / $k + $objattr['border_bottom']['w'] / $k) / 2);
			$objattr['BORDER-X'] = $x + $objattr['margin_left'] / $k + (($objattr['border_left']['w'] / $k) / 2);
			$objattr['BORDER-Y'] = $y + $objattr['margin_top'] / $k + (($objattr['border_top']['w'] / $k) / 2);
			$objattr['INNER-WIDTH'] = $img_w;
			$objattr['INNER-HEIGHT'] = $img_h;
			$objattr['INNER-X'] = $x + $objattr['margin_left'] / $k + ($objattr['border_left']['w'] / $k);
			$objattr['INNER-Y'] = $y + $objattr['margin_top'] / $k + ($objattr['border_top']['w'] / $k);
			$objattr['ID'] = $info['i'];
		}

		if ($type == 'barcode' || $type == 'textcircle') {
			$b_w = $w - $extraWidth;
			$b_h = $h - $extraHeight;
			$objattr['BORDER-WIDTH'] = $b_w + $objattr['padding_left'] / $k + $objattr['padding_right'] / $k + (($objattr['border_left']['w'] / $k + $objattr['border_right']['w'] / $k) / 2);
			$objattr['BORDER-HEIGHT'] = $b_h + $objattr['padding_top'] / $k + $objattr['padding_bottom'] / $k + (($objattr['border_top']['w'] / $k + $objattr['border_bottom']['w'] / $k) / 2);
			$objattr['BORDER-X'] = $x + $objattr['margin_left'] / $k + (($objattr['border_left']['w'] / $k) / 2);
			$objattr['BORDER-Y'] = $y + $objattr['margin_top'] / $k + (($objattr['border_top']['w'] / $k) / 2);
			$objattr['INNER-X'] = $x + $objattr['padding_left'] / $k + $objattr['margin_left'] / $k + ($objattr['border_left']['w'] / $k);
			$objattr['INNER-Y'] = $y + $objattr['padding_top'] / $k + $objattr['margin_top'] / $k + ($objattr['border_top']['w'] / $k);
			$objattr['INNER-WIDTH'] = $b_w;
			$objattr['INNER-HEIGHT'] = $b_h;
		}


		if ($type == 'textarea') {
			// Automatically resize to width remaining
			if ($w > $widthLeft && !$is_table) {
				$w = $widthLeft;
			}
			// This used to resize height to maximum remaining on page ? why. Causes problems when in table and causing a new column
			//	if (($y + $h > $this->PageBreakTrigger) && !$this->InFooter) {
			//		$h=$this->h - $y - $this->bMargin;
			//	}
		}

		if ($type == 'hr') {
			if ($is_table) {
				$objattr['INNER-WIDTH'] = $maxWidth * $objattr['W-PERCENT'] / 100;
				$objattr['width'] = $objattr['INNER-WIDTH'];
				$w = $maxWidth;
			} else {
				if ($w > $maxWidth) {
					$w = $maxWidth;
				}
				$objattr['INNER-WIDTH'] = $w;
				$w = $maxWidth;
			}
		}



		if (($type == 'select') || ($type == 'input' && ($objattr['subtype'] == 'TEXT' || $objattr['subtype'] == 'PASSWORD'))) {
			// Automatically resize to width remaining
			if ($w > $widthLeft && !$is_table) {
				$w = $widthLeft;
			}
		}

		if ($type == 'textarea' || $type == 'select' || $type == 'input') {
			if (isset($objattr['fontsize']))
				$objattr['fontsize'] /= $k;
			if (isset($objattr['linewidth']))
				$objattr['linewidth'] /= $k;
		}

		if (!isset($objattr['BORDER-Y'])) {
			$objattr['BORDER-Y'] = 0;
		}
		if (!isset($objattr['BORDER-X'])) {
			$objattr['BORDER-X'] = 0;
		}
		if (!isset($objattr['INNER-Y'])) {
			$objattr['INNER-Y'] = 0;
		}
		if (!isset($objattr['INNER-X'])) {
			$objattr['INNER-X'] = 0;
		}

		//Return width-height array
		$objattr['OUTER-WIDTH'] = $w;
		$objattr['OUTER-HEIGHT'] = $h;
		$objattr['OUTER-X'] = $x;
		$objattr['OUTER-Y'] = $y;
		return $objattr;
	}

	/* -- END HTML-CSS -- */

	//=============================================================
	//=============================================================
	//=============================================================
	//=============================================================
	//=============================================================

	function SetLineJoin($mode = 0)
	{
		$s = sprintf('%d j', $mode);
		if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['LineJoin']) && $this->pageoutput[$this->page]['LineJoin'] != $s) || !isset($this->pageoutput[$this->page]['LineJoin']))) {
			$this->_out($s);
		}
		$this->pageoutput[$this->page]['LineJoin'] = $s;
	}

	function SetLineCap($mode = 2)
	{
		$s = sprintf('%d J', $mode);
		if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['LineCap']) && $this->pageoutput[$this->page]['LineCap'] != $s) || !isset($this->pageoutput[$this->page]['LineCap']))) {
			$this->_out($s);
		}
		$this->pageoutput[$this->page]['LineCap'] = $s;
	}

	function SetDash($black = false, $white = false)
	{
		if ($black and $white)
			$s = sprintf('[%.3F %.3F] 0 d', $black * _MPDFK, $white * _MPDFK);
		else
			$s = '[] 0 d';
		if ($this->page > 0 && ((isset($this->pageoutput[$this->page]['Dash']) && $this->pageoutput[$this->page]['Dash'] != $s) || !isset($this->pageoutput[$this->page]['Dash']))) {
			$this->_out($s);
		}
		$this->pageoutput[$this->page]['Dash'] = $s;
	}

	function SetDisplayPreferences($preferences)
	{
		// String containing any or none of /HideMenubar/HideToolbar/HideWindowUI/DisplayDocTitle/CenterWindow/FitWindow
		$this->DisplayPreferences .= $preferences;
	}

	function Ln($h = '', $collapsible = 0)
	{
		// Added collapsible to allow collapsible top-margin on new page
		//Line feed; default value is last cell height
		$this->x = $this->lMargin + $this->blk[$this->blklvl]['outer_left_margin'];
		if ($collapsible && ($this->y == $this->tMargin) && (!$this->ColActive)) {
			$h = 0;
		}
		if (is_string($h))
			$this->y+=$this->lasth;
		else
			$this->y+=$h;
	}

	/* -- HTML-CSS -- */

	function DivLn($h, $level = -3, $move_y = true, $collapsible = false, $state = 0)
	{
		// $state = 0 normal; 1 top; 2 bottom; 3 top and bottom
		// Used in Columns and keep-with-table i.e. "kwt"
		// writes background block by block so it can be repositioned
		// and also used in writingFlowingBlock at top and bottom of blocks to move y (not to draw/paint anything)
		// adds lines (y) where DIV bgcolors are filled in
		// this->x is returned as it was
		// allows .00001 as nominal height used for bookmarks/annotations etc.
		if ($collapsible && (sprintf("%0.4f", $this->y) == sprintf("%0.4f", $this->tMargin)) && (!$this->ColActive)) {
			return;
		}

		// mPDF 6 Columns
		//   if ($collapsible && (sprintf("%0.4f", $this->y)==sprintf("%0.4f", $this->y0)) && ($this->ColActive) && $this->CurrCol == 0) { return; }	// *COLUMNS*
		if ($collapsible && (sprintf("%0.4f", $this->y) == sprintf("%0.4f", $this->y0)) && ($this->ColActive)) {
			return;
		} // *COLUMNS*
		// Still use this method if columns or keep-with-table, as it allows repositioning later
		// otherwise, now uses PaintDivBB()
		if (!$this->ColActive && !$this->kwt) {
			if ($move_y && !$this->ColActive) {
				$this->y += $h;
			}
			return;
		}

		if ($level == -3) {
			$level = $this->blklvl;
		}
		$firstblockfill = $this->GetFirstBlockFill();
		if ($firstblockfill && $this->blklvl > 0 && $this->blklvl >= $firstblockfill) {
			$last_x = 0;
			$last_w = 0;
			$last_fc = $this->FillColor;
			$bak_x = $this->x;
			$bak_h = $this->divheight;
			$this->divheight = 0; // Temporarily turn off divheight - as Cell() uses it to check for PageBreak
			for ($blvl = $firstblockfill; $blvl <= $level; $blvl++) {
				$this->x = $this->lMargin + $this->blk[$blvl]['outer_left_margin'];
				// mPDF 6
				if ($this->blk[$blvl]['bgcolor']) {
					$this->SetFColor($this->blk[$blvl]['bgcolorarray']);
				}
				if ($last_x != ($this->lMargin + $this->blk[$blvl]['outer_left_margin']) || ($last_w != $this->blk[$blvl]['width']) || $last_fc != $this->FillColor || (isset($this->blk[$blvl]['border_top']['s']) && $this->blk[$blvl]['border_top']['s']) || (isset($this->blk[$blvl]['border_bottom']['s']) && $this->blk[$blvl]['border_bottom']['s']) || (isset($this->blk[$blvl]['border_left']['s']) && $this->blk[$blvl]['border_left']['s']) || (isset($this->blk[$blvl]['border_right']['s']) && $this->blk[$blvl]['border_right']['s'])) {
					$x = $this->x;
					$this->Cell(($this->blk[$blvl]['width']), $h, '', '', 0, '', 1);
					$this->x = $x;
					if (!$this->keep_block_together && !$this->writingHTMLheader && !$this->writingHTMLfooter) {
						// $state = 0 normal; 1 top; 2 bottom; 3 top and bottom
						if ($blvl == $this->blklvl) {
							$this->PaintDivLnBorder($state, $blvl, $h);
						} else {
							$this->PaintDivLnBorder(0, $blvl, $h);
						}
					}
				}
				$last_x = $this->lMargin + $this->blk[$blvl]['outer_left_margin'];
				$last_w = $this->blk[$blvl]['width'];
				$last_fc = $this->FillColor;
			}
			// Reset current block fill
			if (isset($this->blk[$this->blklvl]['bgcolorarray'])) {
				$bcor = $this->blk[$this->blklvl]['bgcolorarray'];
				$this->SetFColor($bcor);
			}
			$this->x = $bak_x;
			$this->divheight = $bak_h;
		}
		if ($move_y) {
			$this->y += $h;
		}
	}

	/* -- END HTML-CSS -- */

	function SetX($x)
	{
		//Set x position
		if ($x >= 0)
			$this->x = $x;
		else
			$this->x = $this->w + $x;
	}

	function SetY($y)
	{
		//Set y position and reset x
		$this->x = $this->lMargin;
		if ($y >= 0)
			$this->y = $y;
		else
			$this->y = $this->h + $y;
	}

	function SetXY($x, $y)
	{
		//Set x and y positions
		$this->SetY($y);
		$this->SetX($x);
	}

	function Output($name = '', $dest = '')
	{
		//Output PDF to some destination
		if ($this->showStats) {
			echo '<div>Generated in ' . sprintf('%.2F', (microtime(true) - $this->time0)) . ' seconds</div>';
		}
		//Finish document if necessary
		if ($this->progressBar) {
			$this->UpdateProgressBar(1, '100', 'Finished');
		} // *PROGRESS-BAR*
		if ($this->state < 3)
			$this->Close();
		if ($this->progressBar) {
			$this->UpdateProgressBar(2, '100', 'Finished');
		} // *PROGRESS-BAR*
		// fn. error_get_last is only in PHP>=5.2
		if ($this->debug && function_exists('error_get_last') && error_get_last()) {
			$e = error_get_last();
			if (($e['type'] < 2048 && $e['type'] != 8) || (intval($e['type']) & intval(ini_get("error_reporting")))) {
				echo "<p>Error message detected - PDF file generation aborted.</p>";
				echo $e['message'] . '<br />';
				echo 'File: ' . $e['file'] . '<br />';
				echo 'Line: ' . $e['line'] . '<br />';
				exit;
			}
		}


		if (($this->PDFA || $this->PDFX) && $this->encrypted) {
			throw new MpdfException("PDFA1-b or PDFX/1-a does not permit encryption of documents.");
		}
		if (count($this->PDFAXwarnings) && (($this->PDFA && !$this->PDFAauto) || ($this->PDFX && !$this->PDFXauto))) {
			if ($this->PDFA) {
				echo '<div>WARNING - This file could not be generated as it stands as a PDFA1-b compliant file.</div>';
				echo '<div>These issues can be automatically fixed by mPDF using <i>$mpdf-&gt;PDFAauto=true;</i></div>';
				echo '<div>Action that mPDF will take to automatically force PDFA1-b compliance are shown in brackets.</div>';
			} else {
				echo '<div>WARNING - This file could not be generated as it stands as a PDFX/1-a compliant file.</div>';
				echo '<div>These issues can be automatically fixed by mPDF using <i>$mpdf-&gt;PDFXauto=true;</i></div>';
				echo '<div>Action that mPDF will take to automatically force PDFX/1-a compliance are shown in brackets.</div>';
			}
			echo '<div>Warning(s) generated:</div><ul>';
			$this->PDFAXwarnings = array_unique($this->PDFAXwarnings);
			foreach ($this->PDFAXwarnings AS $w) {
				echo '<li>' . $w . '</li>';
			}
			echo '</ul>';
			exit;
		}

		if ($this->showStats) {
			echo '<div>Compiled in ' . sprintf('%.2F', (microtime(true) - $this->time0)) . ' seconds (total)</div>';
			echo '<div>Peak Memory usage ' . number_format((memory_get_peak_usage(true) / (1024 * 1024)), 2) . ' MB</div>';
			echo '<div>PDF file size ' . number_format((strlen($this->buffer) / 1024)) . ' kB</div>';
			echo '<div>Number of fonts ' . count($this->fonts) . '</div>';
			exit;
		}


		if (is_bool($dest))
			$dest = $dest ? 'D' : 'F';
		$dest = strtoupper($dest);
		if ($dest == '') {
			if ($name == '') {
				$name = 'mpdf.pdf';
				$dest = 'I';
			} else {
				$dest = 'F';
			}
		}

		/* -- PROGRESS-BAR -- */
		if ($this->progressBar && ($dest == 'D' || $dest == 'I')) {
			if ($name == '') {
				$name = 'mpdf.pdf';
			}
			$tempfile = '_tempPDF' . uniqid(rand(1, 100000), true);
			//Save to local file
			$f = fopen(_MPDF_TEMP_PATH . $tempfile . '.pdf', 'wb');
			if (!$f)
				throw new MpdfException('Unable to create temporary output file: ' . $tempfile . '.pdf');
			fwrite($f, $this->buffer, strlen($this->buffer));
			fclose($f);
			$this->UpdateProgressBar(3, '', 'Finished');

			echo '<script type="text/javascript">

		var form = document.createElement("form");
		form.setAttribute("method", "post");
		form.setAttribute("action", "' . _MPDF_URI . 'includes/out.php");

		var hiddenField = document.createElement("input");
		hiddenField.setAttribute("type", "hidden");
		hiddenField.setAttribute("name", "filename");
		hiddenField.setAttribute("value", "' . $tempfile . '");
		form.appendChild(hiddenField);

		var hiddenField = document.createElement("input");
		hiddenField.setAttribute("type", "hidden");
		hiddenField.setAttribute("name", "dest");
		hiddenField.setAttribute("value", "' . $dest . '");
		form.appendChild(hiddenField);

		var hiddenField = document.createElement("input");
		hiddenField.setAttribute("type", "hidden");
		hiddenField.setAttribute("name", "opname");
		hiddenField.setAttribute("value", "' . $name . '");
		form.appendChild(hiddenField);

		var hiddenField = document.createElement("input");
		hiddenField.setAttribute("type", "hidden");
		hiddenField.setAttribute("name", "path");
		hiddenField.setAttribute("value", "' . urlencode(_MPDF_TEMP_PATH) . '");
		form.appendChild(hiddenField);

		document.body.appendChild(form);
		form.submit();

		</script>
		</div>
		</body>
		</html>';
			exit;
		}
		else {
			if ($this->progressBar) {
				$this->UpdateProgressBar(3, '', 'Finished');
			}
			/* -- END PROGRESS-BAR -- */

			switch ($dest) {
				case 'I':
					if ($this->debug && !$this->allow_output_buffering && ob_get_contents()) {
						echo "<p>Output has already been sent from the script - PDF file generation aborted.</p>";
						exit;
					}
					//Send to standard output
					if (PHP_SAPI != 'cli') {
						//We send to a browser
						header('Content-Type: application/pdf');
						if (headers_sent())
							throw new MpdfException('Some data has already been output to browser, can\'t send PDF file');
						if (!isset($_SERVER['HTTP_ACCEPT_ENCODING']) OR empty($_SERVER['HTTP_ACCEPT_ENCODING'])) {
							// don't use length if server using compression
							header('Content-Length: ' . strlen($this->buffer));
						}
						header('Content-disposition: inline; filename="' . $name . '"');
						header('Cache-Control: public, must-revalidate, max-age=0');
						header('Pragma: public');
						header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
						header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
					}
					echo $this->buffer;
					break;
				case 'D':
					//Download file
					header('Content-Description: File Transfer');
					if (headers_sent())
						throw new MpdfException('Some data has already been output to browser, can\'t send PDF file');
					header('Content-Transfer-Encoding: binary');
					header('Cache-Control: public, must-revalidate, max-age=0');
					header('Pragma: public');
					header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
					header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
					header('Content-Type: application/force-download');
					header('Content-Type: application/octet-stream', false);
					header('Content-Type: application/download', false);
					header('Content-Type: application/pdf', false);
					if (!isset($_SERVER['HTTP_ACCEPT_ENCODING']) OR empty($_SERVER['HTTP_ACCEPT_ENCODING'])) {
						// don't use length if server using compression
						header('Content-Length: ' . strlen($this->buffer));
					}
					header('Content-disposition: attachment; filename="' . $name . '"');
					echo $this->buffer;
					break;
				case 'F':
					//Save to local file
					$f = fopen($name, 'wb');
					if (!$f)
						throw new MpdfException('Unable to create output file: ' . $name);
					fwrite($f, $this->buffer, strlen($this->buffer));
					fclose($f);
					break;
				case 'S':
					//Return as a string
					return $this->buffer;
				default:
					throw new MpdfException('Incorrect output destination: ' . $dest);
			}
		} // *PROGRESS-BAR*
		//======================================================================================================
		// DELETE OLD TMP FILES - Housekeeping
		// Delete any files in tmp/ directory that are >1 hrs old
		$interval = 3600;
		if ($handle = @opendir(preg_replace('/\/$/', '', _MPDF_TEMP_PATH))) { // mPDF 5.7.3
			while (false !== ($file = readdir($handle))) {
				if (($file != "..") && ($file != ".") && !is_dir($file) && ((filemtime(_MPDF_TEMP_PATH . $file) + $interval) < time()) && (substr($file, 0, 1) !== '.') && ($file != 'dummy.txt')) { // mPDF 5.7.3
					unlink(_MPDF_TEMP_PATH . $file);
				}
			}
			closedir($handle);
		}
		//==============================================================================================================

		return '';
	}

	// *****************************************************************************
	//                                                                             *
	//                             Protected methods                               *
	//                                                                             *
	// *****************************************************************************
	function _dochecks()
	{
		//Check for locale-related bug
		if (1.1 == 1)
			throw new MpdfException('Don\'t alter the locale before including mPDF');
		//Check for decimal separator
		if (sprintf('%.1f', 1.0) != '1.0')
			setlocale(LC_NUMERIC, 'C');
		$mqr = ini_get("magic_quotes_runtime");
		if ($mqr) {
			throw new MpdfException('mPDF requires magic_quotes_runtime to be turned off e.g. by using ini_set("magic_quotes_runtime", 0);');
		}
	}

	function _puthtmlheaders()
	{
		$this->state = 2;
		$nb = $this->page;
		for ($n = 1; $n <= $nb; $n++) {
			if ($this->mirrorMargins && $n % 2 == 0) {
				$OE = 'E';
			} // EVEN
			else {
				$OE = 'O';
			}
			$this->page = $n;
			$pn = $this->docPageNum($n);
			if ($pn)
				$pnstr = $this->pagenumPrefix . $pn . $this->pagenumSuffix;
			else {
				$pnstr = '';
			}
			$pnt = $this->docPageNumTotal($n);
			if ($pnt)
				$pntstr = $this->nbpgPrefix . $pnt . $this->nbpgSuffix;
			else {
				$pntstr = '';
			}
			if (isset($this->saveHTMLHeader[$n][$OE])) {
				$html = $this->saveHTMLHeader[$n][$OE]['html'];
				$this->lMargin = $this->saveHTMLHeader[$n][$OE]['ml'];
				$this->rMargin = $this->saveHTMLHeader[$n][$OE]['mr'];
				$this->tMargin = $this->saveHTMLHeader[$n][$OE]['mh'];
				$this->bMargin = $this->saveHTMLHeader[$n][$OE]['mf'];
				$this->margin_header = $this->saveHTMLHeader[$n][$OE]['mh'];
				$this->margin_footer = $this->saveHTMLHeader[$n][$OE]['mf'];
				$this->w = $this->saveHTMLHeader[$n][$OE]['pw'];
				$this->h = $this->saveHTMLHeader[$n][$OE]['ph'];
				$rotate = (isset($this->saveHTMLHeader[$n][$OE]['rotate']) ? $this->saveHTMLHeader[$n][$OE]['rotate'] : null);
				$this->Reset();
				$this->pageoutput[$n] = array();
				$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
				$this->x = $this->lMargin;
				$this->y = $this->margin_header;
				$html = str_replace('{PAGENO}', $pnstr, $html);
				$html = str_replace($this->aliasNbPgGp, $pntstr, $html); // {nbpg}
				$html = str_replace($this->aliasNbPg, $nb, $html); // {nb}
				$html = preg_replace_callback('/\{DATE\s+(.*?)\}/', array($this, 'date_callback'), $html); // mPDF 5.7

				$this->HTMLheaderPageLinks = array();
				$this->HTMLheaderPageAnnots = array();
				$this->HTMLheaderPageForms = array();
				$this->pageBackgrounds = array();

				$this->writingHTMLheader = true;
				$this->WriteHTML($html, 4); // parameter 4 saves output to $this->headerbuffer
				$this->writingHTMLheader = false;
				$this->Reset();
				$this->pageoutput[$n] = array();

				$s = $this->PrintPageBackgrounds();
				$this->headerbuffer = $s . $this->headerbuffer;
				$os = '';
				if ($rotate) {
					$os .= sprintf('q 0 -1 1 0 0 %.3F cm ', ($this->w * _MPDFK));
					// To rotate the other way i.e. Header to left of page:
					//$os .= sprintf('q 0 1 -1 0 %.3F %.3F cm ',($this->h*_MPDFK), (($this->rMargin - $this->lMargin )*_MPDFK));
				}
				$os .= $this->headerbuffer;
				if ($rotate) {
					$os .= ' Q' . "\n";
				}

				// Writes over the page background but behind any other output on page
				$os = preg_replace('/\\\\/', '\\\\\\\\', $os);
				$this->pages[$n] = preg_replace('/(___HEADER___MARKER' . $this->uniqstr . ')/', "\n" . $os . "\n" . '\\1', $this->pages[$n]);

				$lks = $this->HTMLheaderPageLinks;
				foreach ($lks AS $lk) {
					if ($rotate) {
						$lw = $lk[2];
						$lh = $lk[3];
						$lk[2] = $lh;
						$lk[3] = $lw; // swap width and height
						$ax = $lk[0] / _MPDFK;
						$ay = $lk[1] / _MPDFK;
						$bx = $ay - ($lh / _MPDFK);
						$by = $this->w - $ax;
						$lk[0] = $bx * _MPDFK;
						$lk[1] = ($this->h - $by) * _MPDFK - $lw;
					}
					$this->PageLinks[$n][] = $lk;
				}
				/* -- FORMS -- */
				foreach ($this->HTMLheaderPageForms AS $f) {
					$this->mpdfform->forms[$f['n']] = $f;
				}
				/* -- END FORMS -- */
			}
			if (isset($this->saveHTMLFooter[$n][$OE])) {
				$html = $this->saveHTMLFooter[$this->page][$OE]['html'];
				$this->lMargin = $this->saveHTMLFooter[$n][$OE]['ml'];
				$this->rMargin = $this->saveHTMLFooter[$n][$OE]['mr'];
				$this->tMargin = $this->saveHTMLFooter[$n][$OE]['mh'];
				$this->bMargin = $this->saveHTMLFooter[$n][$OE]['mf'];
				$this->margin_header = $this->saveHTMLFooter[$n][$OE]['mh'];
				$this->margin_footer = $this->saveHTMLFooter[$n][$OE]['mf'];
				$this->w = $this->saveHTMLFooter[$n][$OE]['pw'];
				$this->h = $this->saveHTMLFooter[$n][$OE]['ph'];
				$rotate = (isset($this->saveHTMLFooter[$n][$OE]['rotate']) ? $this->saveHTMLFooter[$n][$OE]['rotate'] : null);
				$this->Reset();
				$this->pageoutput[$n] = array();
				$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
				$this->x = $this->lMargin;
				$top_y = $this->y = $this->h - $this->margin_footer;

				// if bottom-margin==0, corrects to avoid division by zero
				if ($this->y == $this->h) {
					$top_y = $this->y = ($this->h - 0.1);
				}
				$html = str_replace('{PAGENO}', $pnstr, $html);
				$html = str_replace($this->aliasNbPgGp, $pntstr, $html); // {nbpg}
				$html = str_replace($this->aliasNbPg, $nb, $html); // {nb}
				$html = preg_replace_callback('/\{DATE\s+(.*?)\}/', array($this, 'date_callback'), $html); // mPDF 5.7


				$this->HTMLheaderPageLinks = array();
				$this->HTMLheaderPageAnnots = array();
				$this->HTMLheaderPageForms = array();
				$this->pageBackgrounds = array();

				$this->writingHTMLfooter = true;
				$this->InFooter = true;
				$this->WriteHTML($html, 4); // parameter 4 saves output to $this->headerbuffer
				$this->InFooter = false;
				$this->Reset();
				$this->pageoutput[$n] = array();

				$fheight = $this->y - $top_y;
				$adj = -$fheight;

				$s = $this->PrintPageBackgrounds(-$adj);
				$this->headerbuffer = $s . $this->headerbuffer;
				$this->writingHTMLfooter = false; // mPDF 5.7.3  (moved after PrintPageBackgrounds so can adjust position of images in footer)

				$os = '';
				$os .= $this->StartTransform(true) . "\n";
				if ($rotate) {
					$os .= sprintf('q 0 -1 1 0 0 %.3F cm ', ($this->w * _MPDFK));
					// To rotate the other way i.e. Header to left of page:
					//$os .= sprintf('q 0 1 -1 0 %.3F %.3F cm ',($this->h*_MPDFK), (($this->rMargin - $this->lMargin )*_MPDFK));
				}
				$os .= $this->transformTranslate(0, $adj, true) . "\n";
				$os .= $this->headerbuffer;
				if ($rotate) {
					$os .= ' Q' . "\n";
				}
				$os .= $this->StopTransform(true) . "\n";
				// Writes over the page background but behind any other output on page
				$os = preg_replace('/\\\\/', '\\\\\\\\', $os);
				$this->pages[$n] = preg_replace('/(___HEADER___MARKER' . $this->uniqstr . ')/', "\n" . $os . "\n" . '\\1', $this->pages[$n]);

				$lks = $this->HTMLheaderPageLinks;
				foreach ($lks AS $lk) {
					$lk[1] -= $adj * _MPDFK;
					if ($rotate) {
						$lw = $lk[2];
						$lh = $lk[3];
						$lk[2] = $lh;
						$lk[3] = $lw; // swap width and height

						$ax = $lk[0] / _MPDFK;
						$ay = $lk[1] / _MPDFK;
						$bx = $ay - ($lh / _MPDFK);
						$by = $this->w - $ax;
						$lk[0] = $bx * _MPDFK;
						$lk[1] = ($this->h - $by) * _MPDFK - $lw;
					}
					$this->PageLinks[$n][] = $lk;
				}
				/* -- FORMS -- */
				foreach ($this->HTMLheaderPageForms AS $f) {
					$f['y'] += $adj;
					$this->mpdfform->forms[$f['n']] = $f;
				}
				/* -- END FORMS -- */
			}
		}
		$this->page = $nb;
		$this->state = 1;
	}

	function _putpages()
	{
		$nb = $this->page;
		$filter = ($this->compress) ? '/Filter /FlateDecode ' : '';

		if ($this->DefOrientation == 'P') {
			$defwPt = $this->fwPt;
			$defhPt = $this->fhPt;
		} else {
			$defwPt = $this->fhPt;
			$defhPt = $this->fwPt;
		}
		$annotid = (3 + 2 * $nb);

		// Active Forms
		$totaladdnum = 0;
		for ($n = 1; $n <= $nb; $n++) {
			if (isset($this->PageLinks[$n])) {
				$totaladdnum += count($this->PageLinks[$n]);
			}
			/* -- ANNOTATIONS -- */
			if (isset($this->PageAnnots[$n])) {
				foreach ($this->PageAnnots[$n] as $k => $pl) {
					if (!empty($pl['opt']['popup']) || !empty($pl['opt']['file'])) {
						$totaladdnum += 2;
					} else {
						$totaladdnum++;
					}
				}
			}
			/* -- END ANNOTATIONS -- */

			/* -- FORMS -- */
			if (count($this->mpdfform->forms) > 0) {
				$this->mpdfform->countPageForms($n, $totaladdnum);
			}
			/* -- END FORMS -- */
		}
		/* -- FORMS -- */
		// Make a note in the radio button group of the obj_id it will have
		$ctr = 0;
		if (count($this->mpdfform->form_radio_groups)) {
			foreach ($this->mpdfform->form_radio_groups AS $name => $frg) {
				$this->mpdfform->form_radio_groups[$name]['obj_id'] = $annotid + $totaladdnum + $ctr;
				$ctr++;
			}
		}
		/* -- END FORMS -- */

		// Select unused fonts (usually default font)
		$unused = array();
		foreach ($this->fonts as $fk => $font) {
			if (isset($font['type']) && $font['type'] == 'TTF' && !$font['used']) {
				$unused[] = $fk;
			}
		}


		for ($n = 1; $n <= $nb; $n++) {
			$thispage = $this->pages[$n];
			if (isset($this->OrientationChanges[$n])) {
				$hPt = $this->pageDim[$n]['w'] * _MPDFK;
				$wPt = $this->pageDim[$n]['h'] * _MPDFK;
				$owidthPt_LR = $this->pageDim[$n]['outer_width_TB'] * _MPDFK;
				$owidthPt_TB = $this->pageDim[$n]['outer_width_LR'] * _MPDFK;
			} else {
				$wPt = $this->pageDim[$n]['w'] * _MPDFK;
				$hPt = $this->pageDim[$n]['h'] * _MPDFK;
				$owidthPt_LR = $this->pageDim[$n]['outer_width_LR'] * _MPDFK;
				$owidthPt_TB = $this->pageDim[$n]['outer_width_TB'] * _MPDFK;
			}
			// Remove references to unused fonts (usually default font)
			foreach ($unused as $fk) {
				if ($this->fonts[$fk]['sip'] || $this->fonts[$fk]['smp']) {
					foreach ($this->fonts[$fk]['subsetfontids'] AS $k => $fid) {
						$thispage = preg_replace('/\s\/F' . $fid . ' \d[\d.]* Tf\s/is', ' ', $thispage);
					}
				} else {
					$thispage = preg_replace('/\s\/F' . $this->fonts[$fk]['i'] . ' \d[\d.]* Tf\s/is', ' ', $thispage);
				}
			}
			// Clean up repeated /GS1 gs statements
			// For some reason using + for repetition instead of {2,20} crashes PHP Script Interpreter ???
			$thispage = preg_replace('/(\/GS1 gs\n){2,20}/', "/GS1 gs\n", $thispage);

			$thispage = preg_replace('/(\s*___BACKGROUND___PATTERNS' . $this->uniqstr . '\s*)/', " ", $thispage);
			$thispage = preg_replace('/(\s*___HEADER___MARKER' . $this->uniqstr . '\s*)/', " ", $thispage);
			$thispage = preg_replace('/(\s*___PAGE___START' . $this->uniqstr . '\s*)/', " ", $thispage);
			$thispage = preg_replace('/(\s*___TABLE___BACKGROUNDS' . $this->uniqstr . '\s*)/', " ", $thispage);
			// mPDF 5.7.3 TRANSFORMS
			while (preg_match('/(\% BTR(.*?)\% ETR)/is', $thispage, $m)) {
				$thispage = preg_replace('/(\% BTR.*?\% ETR)/is', '', $thispage, 1) . "\n" . $m[2];
			}

			//Page
			$this->_newobj();
			$this->_out('<</Type /Page');
			$this->_out('/Parent 1 0 R');
			if (isset($this->OrientationChanges[$n])) {
				$this->_out(sprintf('/MediaBox [0 0 %.3F %.3F]', $hPt, $wPt));
				//If BleedBox is defined, it must be larger than the TrimBox, but smaller than the MediaBox
				$bleedMargin = $this->pageDim[$n]['bleedMargin'] * _MPDFK;
				if ($bleedMargin && ($owidthPt_TB || $owidthPt_LR)) {
					$x0 = $owidthPt_TB - $bleedMargin;
					$y0 = $owidthPt_LR - $bleedMargin;
					$x1 = $hPt - $owidthPt_TB + $bleedMargin;
					$y1 = $wPt - $owidthPt_LR + $bleedMargin;
					$this->_out(sprintf('/BleedBox [%.3F %.3F %.3F %.3F]', $x0, $y0, $x1, $y1));
				}
				$this->_out(sprintf('/TrimBox [%.3F %.3F %.3F %.3F]', $owidthPt_TB, $owidthPt_LR, ($hPt - $owidthPt_TB), ($wPt - $owidthPt_LR)));
				if (isset($this->OrientationChanges[$n]) && $this->displayDefaultOrientation) {
					if ($this->DefOrientation == 'P') {
						$this->_out('/Rotate 270');
					} else {
						$this->_out('/Rotate 90');
					}
				}
			}
			//elseif($wPt != $defwPt || $hPt != $defhPt) {
			else {
				$this->_out(sprintf('/MediaBox [0 0 %.3F %.3F]', $wPt, $hPt));
				$bleedMargin = $this->pageDim[$n]['bleedMargin'] * _MPDFK;
				if ($bleedMargin && ($owidthPt_TB || $owidthPt_LR)) {
					$x0 = $owidthPt_LR - $bleedMargin;
					$y0 = $owidthPt_TB - $bleedMargin;
					$x1 = $wPt - $owidthPt_LR + $bleedMargin;
					$y1 = $hPt - $owidthPt_TB + $bleedMargin;
					$this->_out(sprintf('/BleedBox [%.3F %.3F %.3F %.3F]', $x0, $y0, $x1, $y1));
				}
				$this->_out(sprintf('/TrimBox [%.3F %.3F %.3F %.3F]', $owidthPt_LR, $owidthPt_TB, ($wPt - $owidthPt_LR), ($hPt - $owidthPt_TB)));
			}
			$this->_out('/Resources 2 0 R');

			// Important to keep in RGB colorSpace when using transparency
			if (!$this->PDFA && !$this->PDFX) {
				if ($this->restrictColorSpace == 3)
					$this->_out('/Group << /Type /Group /S /Transparency /CS /DeviceCMYK >> ');
				elseif ($this->restrictColorSpace == 1)
					$this->_out('/Group << /Type /Group /S /Transparency /CS /DeviceGray >> ');
				else
					$this->_out('/Group << /Type /Group /S /Transparency /CS /DeviceRGB >> ');
			}

			$annotsnum = 0;
			$embeddedfiles = array(); // mPDF 5.7.2 /EmbeddedFiles

			if (isset($this->PageLinks[$n])) {
				$annotsnum += count($this->PageLinks[$n]);
			}
			/* -- ANNOTATIONS -- */
			if (isset($this->PageAnnots[$n])) {
				foreach ($this->PageAnnots[$n] as $k => $pl) {
					if (!empty($pl['opt']['file'])) {
						$embeddedfiles[$annotsnum + 1] = true;
					} // mPDF 5.7.2 /EmbeddedFiles
					if (!empty($pl['opt']['popup']) || !empty($pl['opt']['file'])) {
						$annotsnum += 2;
					} else {
						$annotsnum++;
					}
					$this->PageAnnots[$n][$k]['pageobj'] = $this->n;
				}
			}
			/* -- END ANNOTATIONS -- */

			/* -- FORMS -- */
			// Active Forms
			$formsnum = 0;
			if (count($this->mpdfform->forms) > 0) {
				foreach ($this->mpdfform->forms as $val) {
					if ($val['page'] == $n)
						$formsnum++;
				}
			}
			/* -- END FORMS -- */
			if ($annotsnum || $formsnum) {
				$s = '/Annots [ ';
				for ($i = 0; $i < $annotsnum; $i++) {
					if (!isset($embeddedfiles[$i])) {
						$s .= ($annotid + $i) . ' 0 R ';
					} // mPDF 5.7.2 /EmbeddedFiles
				}
				$annotid += $annotsnum;
				/* -- FORMS -- */
				if (count($this->mpdfform->forms) > 0) {
					$this->mpdfform->addFormIds($n, $s, $annotid);
				}
				/* -- END FORMS -- */
				$s .= '] ';
				$this->_out($s);
			}

			$this->_out('/Contents ' . ($this->n + 1) . ' 0 R>>');
			$this->_out('endobj');

			//Page content
			$this->_newobj();
			$p = ($this->compress) ? gzcompress($thispage) : $thispage;
			$this->_out('<<' . $filter . '/Length ' . strlen($p) . '>>');
			$this->_putstream($p);
			$this->_out('endobj');
		}
		$this->_putannots(); // mPDF 5.7.2
		//Pages root
		$this->offsets[1] = strlen($this->buffer);
		$this->_out('1 0 obj');
		$this->_out('<</Type /Pages');
		$kids = '/Kids [';
		for ($i = 0; $i < $nb; $i++)
			$kids.=(3 + 2 * $i) . ' 0 R ';
		$this->_out($kids . ']');
		$this->_out('/Count ' . $nb);
		$this->_out(sprintf('/MediaBox [0 0 %.3F %.3F]', $defwPt, $defhPt));
		$this->_out('>>');
		$this->_out('endobj');
	}

	function _putannots()
	{ // mPDF 5.7.2
		$filter = ($this->compress) ? '/Filter /FlateDecode ' : '';
		$nb = $this->page;
		for ($n = 1; $n <= $nb; $n++) {
			$annotobjs = array();
			if (isset($this->PageLinks[$n]) || isset($this->PageAnnots[$n]) || count($this->mpdfform->forms) > 0) {
				$wPt = $this->pageDim[$n]['w'] * _MPDFK;
				$hPt = $this->pageDim[$n]['h'] * _MPDFK;

				//Links
				if (isset($this->PageLinks[$n])) {
					foreach ($this->PageLinks[$n] as $key => $pl) {
						$this->_newobj();
						$annot = '';
						$rect = sprintf('%.3F %.3F %.3F %.3F', $pl[0], $pl[1], $pl[0] + $pl[2], $pl[1] - $pl[3]);
						$annot .= '<</Type /Annot /Subtype /Link /Rect [' . $rect . ']';
						$annot .= ' /Contents ' . $this->_UTF16BEtextstring($pl[4]);
						$annot .= ' /NM ' . $this->_textstring(sprintf('%04u-%04u', $n, $key));
						$annot .= ' /M ' . $this->_textstring('D:' . date('YmdHis'));
						$annot .= ' /Border [0 0 0]';
						// Use this (instead of /Border) to specify border around link
						//		$annot .= ' /BS <</W 1';	// Width on points; 0 = no line
						//		$annot .= ' /S /D';		// style - [S]olid, [D]ashed, [B]eveled, [I]nset, [U]nderline
						//		$annot .= ' /D [3 2]';		// Dash array - if dashed
						//		$annot .= ' >>';
						//		$annot .= ' /C [1 0 0]';	// Color RGB

						if ($this->PDFA || $this->PDFX) {
							$annot .= ' /F 28';
						}
						if (strpos($pl[4], '@') === 0) {
							$p = substr($pl[4], 1);
							//	$h=isset($this->OrientationChanges[$p]) ? $wPt : $hPt;
							$htarg = $this->pageDim[$p]['h'] * _MPDFK;
							$annot.=sprintf(' /Dest [%d 0 R /XYZ 0 %.3F null]>>', 1 + 2 * $p, $htarg);
						} elseif (is_string($pl[4])) {
							$annot .= ' /A <</S /URI /URI ' . $this->_textstring($pl[4]) . '>> >>';
						} else {
							$l = $this->links[$pl[4]];
							// may not be set if #link points to non-existent target
							if (isset($this->pageDim[$l[0]]['h'])) {
								$htarg = $this->pageDim[$l[0]]['h'] * _MPDFK;
							} else {
								$htarg = $this->h * _MPDFK;
							} // doesn't really matter
							$annot.=sprintf(' /Dest [%d 0 R /XYZ 0 %.3F null]>>', 1 + 2 * $l[0], $htarg - $l[1] * _MPDFK);
						}
						$this->_out($annot);
						$this->_out('endobj');
					}
				}


				/* -- ANNOTATIONS -- */
				if (isset($this->PageAnnots[$n])) {
					foreach ($this->PageAnnots[$n] as $key => $pl) {
						if ($pl['opt']['file']) {
							$FileAttachment = true;
						} else {
							$FileAttachment = false;
						}
						$this->_newobj();
						$annot = '';
						$pl['opt'] = array_change_key_case($pl['opt'], CASE_LOWER);
						$x = $pl['x'];
						if ($this->annotMargin <> 0 || $x == 0 || $x < 0) { // Odd page
							$x = ($wPt / _MPDFK) - $this->annotMargin;
						}
						$w = $h = 0;
						$a = $x * _MPDFK;
						$b = $hPt - ($pl['y'] * _MPDFK);
						$annot .= '<</Type /Annot ';
						if ($FileAttachment) {
							$annot .= '/Subtype /FileAttachment ';
							// Need to set a size for FileAttachment icons
							if ($pl['opt']['icon'] == 'Paperclip') {
								$w = 8.235;
								$h = 20;
							} // 7,17
							elseif ($pl['opt']['icon'] == 'Tag') {
								$w = 20;
								$h = 16;
							} elseif ($pl['opt']['icon'] == 'Graph') {
								$w = 20;
								$h = 20;
							} else {
								$w = 14;
								$h = 20;
							}  // PushPin
							$f = $pl['opt']['file'];
							$f = preg_replace('/^.*\//', '', $f);
							$f = preg_replace('/[^a-zA-Z0-9._]/', '', $f);
							$annot .= '/FS <</Type /Filespec /F (' . $f . ')';
							$annot .= '/EF <</F ' . ($this->n + 1) . ' 0 R>>';
							$annot .= '>>';
						} else {
							$annot .= '/Subtype /Text';
							$w = 20;
							$h = 20;  // mPDF 6
						}
						$rect = sprintf('%.3F %.3F %.3F %.3F', $a, $b - $h, $a + $w, $b);
						$annot .= ' /Rect [' . $rect . ']';

						// contents = description of file in free text
						$annot .= ' /Contents ' . $this->_UTF16BEtextstring($pl['txt']);

						$annot .= ' /NM ' . $this->_textstring(sprintf('%04u-%04u', $n, (2000 + $key)));
						$annot .= ' /M ' . $this->_textstring('D:' . date('YmdHis'));
						$annot .= ' /CreationDate ' . $this->_textstring('D:' . date('YmdHis'));
						$annot .= ' /Border [0 0 0]';
						if ($this->PDFA || $this->PDFX) {
							$annot .= ' /F 28';
							$annot .= ' /CA 1';
						} elseif ($pl['opt']['ca'] > 0) {
							$annot .= ' /CA ' . $pl['opt']['ca'];
						}

						$annotcolor = ' /C [';
						if (isset($pl['opt']['c']) AND $pl['opt']['c']) {
							$col = $pl['opt']['c'];
							if ($col{0} == 3 || $col{0} == 5) {
								$annotcolor .= sprintf("%.3F %.3F %.3F", ord($col{1}) / 255, ord($col{2}) / 255, ord($col{3}) / 255);
							} elseif ($col{0} == 1) {
								$annotcolor .= sprintf("%.3F", ord($col{1}) / 255);
							} elseif ($col{0} == 4 || $col{0} == 6) {
								$annotcolor .= sprintf("%.3F %.3F %.3F %.3F", ord($col{1}) / 100, ord($col{2}) / 100, ord($col{3}) / 100, ord($col{4}) / 100);
							} else {
								$annotcolor .= '1 1 0';
							}
						} else {
							$annotcolor .= '1 1 0';
						}
						$annotcolor .= ']';
						$annot .= $annotcolor;
						// Usually Author
						// Use as Title for fileattachment
						if (isset($pl['opt']['t']) AND is_string($pl['opt']['t'])) {
							$annot .= ' /T ' . $this->_UTF16BEtextstring($pl['opt']['t']);
						}
						if ($FileAttachment) {
							$iconsapp = array('Paperclip', 'Graph', 'PushPin', 'Tag');
						} else {
							$iconsapp = array('Comment', 'Help', 'Insert', 'Key', 'NewParagraph', 'Note', 'Paragraph');
						}
						if (isset($pl['opt']['icon']) AND in_array($pl['opt']['icon'], $iconsapp)) {
							$annot .= ' /Name /' . $pl['opt']['icon'];
						} elseif ($FileAttachment) {
							$annot .= ' /Name /PushPin';
						} else {
							$annot .= ' /Name /Note';
						}
						if (!$FileAttachment) {
							// /Subj is PDF 1.5 spec.
							if (isset($pl['opt']['subj']) && !$this->PDFA && !$this->PDFX) {
								$annot .= ' /Subj ' . $this->_UTF16BEtextstring($pl['opt']['subj']);
							}
							if (!empty($pl['opt']['popup'])) {
								$annot .= ' /Open true';
								$annot .= ' /Popup ' . ($this->n + 1) . ' 0 R';
							} else {
								$annot .= ' /Open false';
							}
						}
						$annot .= ' /P ' . $pl['pageobj'] . ' 0 R';
						$annot .= '>>';
						$this->_out($annot);
						$this->_out('endobj');

						if ($FileAttachment) {
							$file = @file_get_contents($pl['opt']['file']);
							if (!$file) {
								throw new MpdfException('mPDF Error: Cannot access file attachment - ' . $pl['opt']['file']);
							}
							$filestream = gzcompress($file);
							$this->_newobj();
							$this->_out('<</Type /EmbeddedFile');
							$this->_out('/Length ' . strlen($filestream));
							$this->_out('/Filter /FlateDecode');
							$this->_out('>>');
							$this->_putstream($filestream);
							$this->_out('endobj');
						} elseif (!empty($pl['opt']['popup'])) {
							$this->_newobj();
							$annot = '';
							if (is_array($pl['opt']['popup']) && isset($pl['opt']['popup'][0])) {
								$x = $pl['opt']['popup'][0] * _MPDFK;
							} else {
								$x = $pl['x'] * _MPDFK;
							}
							if (is_array($pl['opt']['popup']) && isset($pl['opt']['popup'][1])) {
								$y = $hPt - ($pl['opt']['popup'][1] * _MPDFK);
							} else {
								$y = $hPt - ($pl['y'] * _MPDFK);
							}
							if (is_array($pl['opt']['popup']) && isset($pl['opt']['popup'][2])) {
								$w = $pl['opt']['popup'][2] * _MPDFK;
							} else {
								$w = 180;
							}
							if (is_array($pl['opt']['popup']) && isset($pl['opt']['popup'][3])) {
								$h = $pl['opt']['popup'][3] * _MPDFK;
							} else {
								$h = 120;
							}
							$rect = sprintf('%.3F %.3F %.3F %.3F', $x, $y - $h, $x + $w, $y);
							$annot .= '<</Type /Annot /Subtype /Popup /Rect [' . $rect . ']';
							$annot .= ' /M ' . $this->_textstring('D:' . date('YmdHis'));
							if ($this->PDFA || $this->PDFX) {
								$annot .= ' /F 28';
							}
							$annot .= ' /Parent ' . ($this->n - 1) . ' 0 R';
							$annot .= '>>';
							$this->_out($annot);
							$this->_out('endobj');
						}
					}
				}
				/* -- END ANNOTATIONS -- */

				/* -- FORMS -- */
				// Active Forms
				if (count($this->mpdfform->forms) > 0) {
					$this->mpdfform->_putFormItems($n, $hPt);
				}
				/* -- END FORMS -- */
			}
		}
		/* -- FORMS -- */
		// Active Forms - Radio Button Group entries
		// Output Radio Button Group form entries (radio_on_obj_id already determined)
		if (count($this->mpdfform->form_radio_groups)) {
			$this->mpdfform->_putRadioItems($n);
		}
		/* -- END FORMS -- */
	}

	/* -- ANNOTATIONS -- */

	function Annotation($text, $x = 0, $y = 0, $icon = 'Note', $author = '', $subject = '', $opacity = 0, $colarray = false, $popup = '', $file = '')
	{
		if (is_array($colarray) && count($colarray) == 3) {
			$colarray = $this->ConvertColor('rgb(' . $colarray[0] . ',' . $colarray[1] . ',' . $colarray[2] . ')');
		}
		if ($colarray === false) {
			$colarray = $this->ConvertColor('yellow');
		}
		if ($x == 0) {
			$x = $this->x;
		}
		if ($y == 0) {
			$y = $this->y;
		}
		$page = $this->page;
		if ($page < 1) { // Document has not been started - assume it's for first page
			$page = 1;
			if ($x == 0) {
				$x = $this->lMargin;
			}
			if ($y == 0) {
				$y = $this->tMargin;
			}
		}

		if ($this->PDFA || $this->PDFX) {
			if (($this->PDFA && !$this->PDFAauto) || ($this->PDFX && !$this->PDFXauto)) {
				$this->PDFAXwarnings[] = "Annotation markers cannot be semi-transparent in PDFA1-b or PDFX/1-a, so they may make underlying text unreadable. (Annotation markers moved to right margin)";
			}
			$x = ($this->w) - $this->rMargin * 0.66;
		}
		if (!$this->annotMargin) {
			$y -= $this->FontSize / 2;
		}

		if (!$opacity && $this->annotMargin) {
			$opacity = 1;
		} elseif (!$opacity) {
			$opacity = $this->annotOpacity;
		}

		$an = array('txt' => $text, 'x' => $x, 'y' => $y, 'opt' => array('Icon' => $icon, 'T' => $author, 'Subj' => $subject, 'C' => $colarray, 'CA' => $opacity, 'popup' => $popup, 'file' => $file));

		if ($this->keep_block_together) { // don't write yet
			return;
		} elseif ($this->table_rotate) {
			$this->tbrot_Annots[$this->page][] = $an;
			return;
		} elseif ($this->kwt) {
			$this->kwt_Annots[$this->page][] = $an;
			return;
		}
		if ($this->writingHTMLheader || $this->writingHTMLfooter) {
			$this->HTMLheaderPageAnnots[] = $an;
			return;
		}
		//Put an Annotation on the page
		$this->PageAnnots[$page][] = $an;
		/* -- COLUMNS -- */
		// Save cross-reference to Column buffer
		$ref = count($this->PageAnnots[$this->page]) - 1;
		$this->columnAnnots[$this->CurrCol][INTVAL($this->x)][INTVAL($this->y)] = $ref;
		/* -- END COLUMNS -- */
	}

	/* -- END ANNOTATIONS -- */

	function _putfonts()
	{
		$nf = $this->n;
		foreach ($this->FontFiles as $fontkey => $info) {
			// TrueType embedded
			if (isset($info['type']) && $info['type'] == 'TTF' && !$info['sip'] && !$info['smp']) {
				$used = true;
				$asSubset = false;
				foreach ($this->fonts AS $k => $f) {
					if (isset($f['fontkey']) && $f['fontkey'] == $fontkey && $f['type'] == 'TTF') {
						$used = $f['used'];
						if ($used) {
							$nChars = (ord($f['cw'][0]) << 8) + ord($f['cw'][1]);
							$usage = intval(count($f['subset']) * 100 / $nChars);
							$fsize = $info['length1'];
							// Always subset the very large TTF files
							if ($fsize > ($this->maxTTFFilesize * 1024)) {
								$asSubset = true;
							} elseif ($usage < $this->percentSubset) {
								$asSubset = true;
							}
						}
						if ($this->PDFA || $this->PDFX)
							$asSubset = false;
						$this->fonts[$k]['asSubset'] = $asSubset;
						break;
					}
				}
				if ($used && !$asSubset) {
					//Font file embedding
					$this->_newobj();
					$this->FontFiles[$fontkey]['n'] = $this->n;
					$font = '';
					$originalsize = $info['length1'];
					if ($this->repackageTTF || $this->fonts[$fontkey]['TTCfontID'] > 0 || $this->fonts[$fontkey]['useOTL'] > 0) { // mPDF 5.7.1
						// First see if there is a cached compressed file
						if (file_exists(_MPDF_TTFONTDATAPATH . $fontkey . '.ps.z')) {
							$f = fopen(_MPDF_TTFONTDATAPATH . $fontkey . '.ps.z', 'rb');
							if (!$f) {
								throw new MpdfException('Font file .ps.z not found');
							}
							while (!feof($f)) {
								$font .= fread($f, 2048);
							}
							fclose($f);
							include(_MPDF_TTFONTDATAPATH . $fontkey . '.ps.php'); // sets $originalsize (of repackaged font)
						} else {
							if (!class_exists('TTFontFile', false)) {
								include(_MPDF_PATH . 'classes/ttfontsuni.php');
							}
							$ttf = new TTFontFile();
							$font = $ttf->repackageTTF($this->FontFiles[$fontkey]['ttffile'], $this->fonts[$fontkey]['TTCfontID'], $this->debugfonts, $this->fonts[$fontkey]['useOTL']); // mPDF 5.7.1

							$originalsize = strlen($font);
							$font = gzcompress($font);
							unset($ttf);
							if (is_writable(dirname(_MPDF_TTFONTDATAPATH . 'x'))) {
								$fh = fopen(_MPDF_TTFONTDATAPATH . $fontkey . '.ps.z', "wb");
								fwrite($fh, $font, strlen($font));
								fclose($fh);
								$fh = fopen(_MPDF_TTFONTDATAPATH . $fontkey . '.ps.php', "wb");
								$len = "<?php \n";
								$len.='$originalsize=' . $originalsize . ";\n";
								$len.="?>";
								fwrite($fh, $len, strlen($len));
								fclose($fh);
							}
						}
					} else {
						// First see if there is a cached compressed file
						if (file_exists(_MPDF_TTFONTDATAPATH . $fontkey . '.z')) {
							$f = fopen(_MPDF_TTFONTDATAPATH . $fontkey . '.z', 'rb');
							if (!$f) {
								throw new MpdfException('Font file not found');
							}
							while (!feof($f)) {
								$font .= fread($f, 2048);
							}
							fclose($f);
						} else {
							$f = fopen($this->FontFiles[$fontkey]['ttffile'], 'rb');
							if (!$f) {
								throw new MpdfException('Font file not found');
							}
							while (!feof($f)) {
								$font .= fread($f, 2048);
							}
							fclose($f);
							$font = gzcompress($font);
							if (is_writable(dirname(_MPDF_TTFONTDATAPATH . 'x'))) {
								$fh = fopen(_MPDF_TTFONTDATAPATH . $fontkey . '.z', "wb");
								fwrite($fh, $font, strlen($font));
								fclose($fh);
							}
						}
					}

					$this->_out('<</Length ' . strlen($font));
					$this->_out('/Filter /FlateDecode');
					$this->_out('/Length1 ' . $originalsize);
					$this->_out('>>');
					$this->_putstream($font);
					$this->_out('endobj');
				}
			}
		}

		$nfonts = count($this->fonts);
		$fctr = 1;
		foreach ($this->fonts as $k => $font) {
			//Font objects
			$type = $font['type'];
			$name = $font['name'];
			if ((!isset($font['used']) || !$font['used']) && $type == 'TTF') {
				continue;
			}
			if ($this->progressBar) {
				$this->UpdateProgressBar(2, intval($fctr * 100 / $nfonts), 'Writing Fonts');
				$fctr++;
			} // *PROGRESS-BAR*
			if (isset($font['asSubset'])) {
				$asSubset = $font['asSubset'];
			} else {
				$asSubset = '';
			}
			/* -- CJK-FONTS -- */
			if ($type == 'Type0') {  // = Adobe CJK Fonts
				$this->fonts[$k]['n'] = $this->n + 1;
				$this->_newobj();
				$this->_out('<</Type /Font');
				$this->_putType0($font);
			} else
			/* -- END CJK-FONTS -- */
			if ($type == 'core') {
				//Standard font
				$this->fonts[$k]['n'] = $this->n + 1;
				if ($this->PDFA || $this->PDFX) {
					throw new MpdfException('Core fonts are not allowed in PDF/A1-b or PDFX/1-a files (Times, Helvetica, Courier etc.)');
				}
				$this->_newobj();
				$this->_out('<</Type /Font');
				$this->_out('/BaseFont /' . $name);
				$this->_out('/Subtype /Type1');
				if ($name != 'Symbol' && $name != 'ZapfDingbats') {
					$this->_out('/Encoding /WinAnsiEncoding');
				}
				$this->_out('>>');
				$this->_out('endobj');
			}
			// TrueType embedded SUBSETS for SIP (CJK extB containing Supplementary Ideographic Plane 2)
			// Or Unicode Plane 1 - Supplementary Multilingual Plane
			elseif ($type == 'TTF' && ($font['sip'] || $font['smp'])) {
				if (!$font['used']) {
					continue;
				}
				$ssfaid = "AA";
				if (!class_exists('TTFontFile', false)) {
					include(_MPDF_PATH . 'classes/ttfontsuni.php');
				}
				$ttf = new TTFontFile();
				for ($sfid = 0; $sfid < count($font['subsetfontids']); $sfid++) {
					$this->fonts[$k]['n'][$sfid] = $this->n + 1;  // NB an array for subset
					$subsetname = 'MPDF' . $ssfaid . '+' . $font['name'];
					$ssfaid++;

					/* For some strange reason a subset ($sfid > 0) containing less than 97 characters causes an error
					  so fill up the array */
					for ($j = count($font['subsets'][$sfid]); $j < 98; $j++) {
						$font['subsets'][$sfid][$j] = 0;
					}

					$subset = $font['subsets'][$sfid];
					unset($subset[0]);
					$ttfontstream = $ttf->makeSubsetSIP($font['ttffile'], $subset, $font['TTCfontID'], $this->debugfonts, $font['useOTL']); // mPDF 5.7.1
					$ttfontsize = strlen($ttfontstream);
					$fontstream = gzcompress($ttfontstream);
					$widthstring = '';
					$toUnistring = '';


					foreach ($font['subsets'][$sfid] AS $cp => $u) {
						$w = $this->_getCharWidth($font['cw'], $u);
						if ($w !== false) {
							$widthstring .= $w . ' ';
						} else {
							$widthstring .= round($ttf->defaultWidth) . ' ';
						}
						if ($u > 65535) {
							$utf8 = chr(($u >> 18) + 240) . chr((($u >> 12) & 63) + 128) . chr((($u >> 6) & 63) + 128) . chr(($u & 63) + 128);
							$utf16 = mb_convert_encoding($utf8, 'UTF-16BE', 'UTF-8');
							$l1 = ord($utf16[0]);
							$h1 = ord($utf16[1]);
							$l2 = ord($utf16[2]);
							$h2 = ord($utf16[3]);
							$toUnistring .= sprintf("<%02s> <%02s%02s%02s%02s>\n", strtoupper(dechex($cp)), strtoupper(dechex($l1)), strtoupper(dechex($h1)), strtoupper(dechex($l2)), strtoupper(dechex($h2)));
						} else {
							$toUnistring .= sprintf("<%02s> <%04s>\n", strtoupper(dechex($cp)), strtoupper(dechex($u)));
						}
					}

					//Additional Type1 or TrueType font
					$this->_newobj();
					$this->_out('<</Type /Font');
					$this->_out('/BaseFont /' . $subsetname);
					$this->_out('/Subtype /TrueType');
					$this->_out('/FirstChar 0 /LastChar ' . (count($font['subsets'][$sfid]) - 1));
					$this->_out('/Widths ' . ($this->n + 1) . ' 0 R');
					$this->_out('/FontDescriptor ' . ($this->n + 2) . ' 0 R');
					$this->_out('/ToUnicode ' . ($this->n + 3) . ' 0 R');
					$this->_out('>>');
					$this->_out('endobj');

					//Widths
					$this->_newobj();
					$this->_out('[' . $widthstring . ']');
					$this->_out('endobj');

					//Descriptor
					$this->_newobj();
					$s = '<</Type /FontDescriptor /FontName /' . $subsetname . "\n";
					foreach ($font['desc'] as $kd => $v) {
						if ($kd == 'Flags') {
							$v = $v | 4;
							$v = $v & ~32;
						} // SYMBOLIC font flag
						$s.=' /' . $kd . ' ' . $v . "\n";
					}
					$s.='/FontFile2 ' . ($this->n + 2) . ' 0 R';
					$this->_out($s . '>>');
					$this->_out('endobj');

					// ToUnicode
					$this->_newobj();
					$toUni = "/CIDInit /ProcSet findresource begin\n";
					$toUni .= "12 dict begin\n";
					$toUni .= "begincmap\n";
					$toUni .= "/CIDSystemInfo\n";
					$toUni .= "<</Registry (Adobe)\n";
					$toUni .= "/Ordering (UCS)\n";
					$toUni .= "/Supplement 0\n";
					$toUni .= ">> def\n";
					$toUni .= "/CMapName /Adobe-Identity-UCS def\n";
					$toUni .= "/CMapType 2 def\n";
					$toUni .= "1 begincodespacerange\n";
					$toUni .= "<00> <FF>\n";
					//$toUni .= sprintf("<00> <%02s>\n", strtoupper(dechex(count($font['subsets'][$sfid])-1)));
					$toUni .= "endcodespacerange\n";
					$toUni .= count($font['subsets'][$sfid]) . " beginbfchar\n";
					$toUni .= $toUnistring;
					$toUni .= "endbfchar\n";
					$toUni .= "endcmap\n";
					$toUni .= "CMapName currentdict /CMap defineresource pop\n";
					$toUni .= "end\n";
					$toUni .= "end\n";
					$this->_out('<</Length ' . (strlen($toUni)) . '>>');
					$this->_putstream($toUni);
					$this->_out('endobj');

					//Font file
					$this->_newobj();
					$this->_out('<</Length ' . strlen($fontstream));
					$this->_out('/Filter /FlateDecode');
					$this->_out('/Length1 ' . $ttfontsize);
					$this->_out('>>');
					$this->_putstream($fontstream);
					$this->_out('endobj');
				} // foreach subset
				unset($ttf);
			}
			// TrueType embedded SUBSETS or FULL
			elseif ($type == 'TTF') {
				$this->fonts[$k]['n'] = $this->n + 1;
				if ($asSubset) {
					$ssfaid = "A";
					if (!class_exists('TTFontFile', false)) {
						include(_MPDF_PATH . 'classes/ttfontsuni.php');
					}
					$ttf = new TTFontFile();
					$fontname = 'MPDFA' . $ssfaid . '+' . $font['name'];
					$subset = $font['subset'];
					unset($subset[0]);
					$ttfontstream = $ttf->makeSubset($font['ttffile'], $subset, $font['TTCfontID'], $this->debugfonts, $font['useOTL']);
					$ttfontsize = strlen($ttfontstream);
					$fontstream = gzcompress($ttfontstream);
					$codeToGlyph = $ttf->codeToGlyph;
					unset($codeToGlyph[0]);
				} else {
					$fontname = $font['name'];
				}
				// Type0 Font
				// A composite font - a font composed of other fonts, organized hierarchically
				$this->_newobj();
				$this->_out('<</Type /Font');
				$this->_out('/Subtype /Type0');
				$this->_out('/BaseFont /' . $fontname . '');
				$this->_out('/Encoding /Identity-H');
				$this->_out('/DescendantFonts [' . ($this->n + 1) . ' 0 R]');
				$this->_out('/ToUnicode ' . ($this->n + 2) . ' 0 R');
				$this->_out('>>');
				$this->_out('endobj');

				// CIDFontType2
				// A CIDFont whose glyph descriptions are based on TrueType font technology
				$this->_newobj();
				$this->_out('<</Type /Font');
				$this->_out('/Subtype /CIDFontType2');
				$this->_out('/BaseFont /' . $fontname . '');
				$this->_out('/CIDSystemInfo ' . ($this->n + 2) . ' 0 R');
				$this->_out('/FontDescriptor ' . ($this->n + 3) . ' 0 R');
				if (isset($font['desc']['MissingWidth'])) {
					$this->_out('/DW ' . $font['desc']['MissingWidth'] . '');
				}

				if (!$asSubset && file_exists(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cw')) {
					$w = '';
					$w = file_get_contents(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cw');
					$this->_out($w);
				} else {
					$this->_putTTfontwidths($font, $asSubset, ($asSubset ? $ttf->maxUni : 0));
				}

				$this->_out('/CIDToGIDMap ' . ($this->n + 4) . ' 0 R');
				$this->_out('>>');
				$this->_out('endobj');

				// ToUnicode
				$this->_newobj();
				$toUni = "/CIDInit /ProcSet findresource begin\n";
				$toUni .= "12 dict begin\n";
				$toUni .= "begincmap\n";
				$toUni .= "/CIDSystemInfo\n";
				$toUni .= "<</Registry (Adobe)\n";
				$toUni .= "/Ordering (UCS)\n";
				$toUni .= "/Supplement 0\n";
				$toUni .= ">> def\n";
				$toUni .= "/CMapName /Adobe-Identity-UCS def\n";
				$toUni .= "/CMapType 2 def\n";
				$toUni .= "1 begincodespacerange\n";
				$toUni .= "<0000> <FFFF>\n";
				$toUni .= "endcodespacerange\n";
				$toUni .= "1 beginbfrange\n";
				$toUni .= "<0000> <FFFF> <0000>\n";
				$toUni .= "endbfrange\n";
				$toUni .= "endcmap\n";
				$toUni .= "CMapName currentdict /CMap defineresource pop\n";
				$toUni .= "end\n";
				$toUni .= "end\n";
				$this->_out('<</Length ' . (strlen($toUni)) . '>>');
				$this->_putstream($toUni);
				$this->_out('endobj');


				// CIDSystemInfo dictionary
				$this->_newobj();
				$this->_out('<</Registry (Adobe)');
				$this->_out('/Ordering (UCS)');
				$this->_out('/Supplement 0');
				$this->_out('>>');
				$this->_out('endobj');

				// Font descriptor
				$this->_newobj();
				$this->_out('<</Type /FontDescriptor');
				$this->_out('/FontName /' . $fontname);
				foreach ($font['desc'] as $kd => $v) {
					if ($asSubset && $kd == 'Flags') {
						$v = $v | 4;
						$v = $v & ~32;
					} // SYMBOLIC font flag
					$this->_out(' /' . $kd . ' ' . $v);
				}
				if ($font['panose']) {
					$this->_out(' /Style << /Panose <' . $font['panose'] . '> >>');
				}
				if ($asSubset) {
					$this->_out('/FontFile2 ' . ($this->n + 2) . ' 0 R');
				} elseif ($font['fontkey']) {
					// obj ID of a stream containing a TrueType font program
					$this->_out('/FontFile2 ' . $this->FontFiles[$font['fontkey']]['n'] . ' 0 R');
				}
				$this->_out('>>');
				$this->_out('endobj');

				// Embed CIDToGIDMap
				// A specification of the mapping from CIDs to glyph indices
				if ($asSubset) {
					$cidtogidmap = '';
					$cidtogidmap = str_pad('', 256 * 256 * 2, "\x00");
					foreach ($codeToGlyph as $cc => $glyph) {
						$cidtogidmap[$cc * 2] = chr($glyph >> 8);
						$cidtogidmap[$cc * 2 + 1] = chr($glyph & 0xFF);
					}
					$cidtogidmap = gzcompress($cidtogidmap);
				} else {
					// First see if there is a cached CIDToGIDMapfile
					$cidtogidmap = '';
					if (file_exists(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cgm')) {
						$f = fopen(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cgm', 'rb');
						while (!feof($f)) {
							$cidtogidmap .= fread($f, 2048);
						}
						fclose($f);
					} else {
						if (!class_exists('TTFontFile', false)) {
							include(_MPDF_PATH . 'classes/ttfontsuni.php');
						}
						$ttf = new TTFontFile();
						$charToGlyph = $ttf->getCTG($font['ttffile'], $font['TTCfontID'], $this->debugfonts, $font['useOTL']);
						$cidtogidmap = str_pad('', 256 * 256 * 2, "\x00");
						foreach ($charToGlyph as $cc => $glyph) {
							$cidtogidmap[$cc * 2] = chr($glyph >> 8);
							$cidtogidmap[$cc * 2 + 1] = chr($glyph & 0xFF);
						}
						unset($ttf);
						$cidtogidmap = gzcompress($cidtogidmap);
						if (is_writable(dirname(_MPDF_TTFONTDATAPATH . 'x'))) {
							$fh = fopen(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cgm', "wb");
							fwrite($fh, $cidtogidmap, strlen($cidtogidmap));
							fclose($fh);
						}
					}
				}
				$this->_newobj();
				$this->_out('<</Length ' . strlen($cidtogidmap) . '');
				$this->_out('/Filter /FlateDecode');
				$this->_out('>>');
				$this->_putstream($cidtogidmap);
				$this->_out('endobj');

				//Font file
				if ($asSubset) {
					$this->_newobj();
					$this->_out('<</Length ' . strlen($fontstream));
					$this->_out('/Filter /FlateDecode');
					$this->_out('/Length1 ' . $ttfontsize);
					$this->_out('>>');
					$this->_putstream($fontstream);
					$this->_out('endobj');
					unset($ttf);
				}
			} else {
				throw new MpdfException('Unsupported font type: ' . $type . ' (' . $name . ')');
			}
		}
	}

	function _putTTfontwidths(&$font, $asSubset, $maxUni)
	{
		if ($asSubset && file_exists(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cw127.php')) {
			include(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cw127.php');
			$startcid = 128;
		} else {
			$rangeid = 0;
			$range = array();
			$prevcid = -2;
			$prevwidth = -1;
			$interval = false;
			$startcid = 1;
		}
		if ($asSubset) {
			$cwlen = $maxUni + 1;
		} else {
			$cwlen = (strlen($font['cw']) / 2);
		}

		// for each character
		for ($cid = $startcid; $cid < $cwlen; $cid++) {
			if ($cid == 128 && $asSubset && (!file_exists(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cw127.php'))) {
				if (is_writable(dirname(_MPDF_TTFONTDATAPATH . 'x'))) {
					$fh = fopen(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cw127.php', "wb");
					$cw127 = '<?php' . "\n";
					$cw127.='$rangeid=' . $rangeid . ";\n";
					$cw127.='$prevcid=' . $prevcid . ";\n";
					$cw127.='$prevwidth=' . $prevwidth . ";\n";
					if ($interval) {
						$cw127.='$interval=true' . ";\n";
					} else {
						$cw127.='$interval=false' . ";\n";
					}
					$cw127.='$range=' . var_export($range, true) . ";\n";
					$cw127.="?>";
					fwrite($fh, $cw127, strlen($cw127));
					fclose($fh);
				}
			}
			if ($font['cw'][$cid * 2] == "\00" && $font['cw'][$cid * 2 + 1] == "\00") {
				continue;
			}
			$width = (ord($font['cw'][$cid * 2]) << 8) + ord($font['cw'][$cid * 2 + 1]);
			if ($width == 65535) {
				$width = 0;
			}
			if ($asSubset && $cid > 255 && (!isset($font['subset'][$cid]) || !$font['subset'][$cid])) {
				continue;
			}
			if ($asSubset && $cid > 0xFFFF) {
				continue;
			} // mPDF 6
			if (!isset($font['dw']) || (isset($font['dw']) && $width != $font['dw'])) {
				if ($cid == ($prevcid + 1)) {
					// consecutive CID
					if ($width == $prevwidth) {
						if ($width == $range[$rangeid][0]) {
							$range[$rangeid][] = $width;
						} else {
							array_pop($range[$rangeid]);
							// new range
							$rangeid = $prevcid;
							$range[$rangeid] = array();
							$range[$rangeid][] = $prevwidth;
							$range[$rangeid][] = $width;
						}
						$interval = true;
						$range[$rangeid]['interval'] = true;
					} else {
						if ($interval) {
							// new range
							$rangeid = $cid;
							$range[$rangeid] = array();
							$range[$rangeid][] = $width;
						} else {
							$range[$rangeid][] = $width;
						}
						$interval = false;
					}
				} else {
					// new range
					$rangeid = $cid;
					$range[$rangeid] = array();
					$range[$rangeid][] = $width;
					$interval = false;
				}
				$prevcid = $cid;
				$prevwidth = $width;
			}
		}
		$w = $this->_putfontranges($range);
		$this->_out($w);
		if (!$asSubset) {
			if (is_writable(dirname(_MPDF_TTFONTDATAPATH . 'x'))) {
				$fh = fopen(_MPDF_TTFONTDATAPATH . $font['fontkey'] . '.cw', "wb");
				fwrite($fh, $w, strlen($w));
				fclose($fh);
			}
		}
	}

	function _putfontranges(&$range)
	{
		// optimize ranges
		$prevk = -1;
		$nextk = -1;
		$prevint = false;
		foreach ($range as $k => $ws) {
			$cws = count($ws);
			if (($k == $nextk) AND ( !$prevint) AND ( (!isset($ws['interval'])) OR ( $cws < 4))) {
				if (isset($range[$k]['interval'])) {
					unset($range[$k]['interval']);
				}
				$range[$prevk] = array_merge($range[$prevk], $range[$k]);
				unset($range[$k]);
			} else {
				$prevk = $k;
			}
			$nextk = $k + $cws;
			if (isset($ws['interval'])) {
				if ($cws > 3) {
					$prevint = true;
				} else {
					$prevint = false;
				}
				unset($range[$k]['interval']);
				--$nextk;
			} else {
				$prevint = false;
			}
		}
		// output data
		$w = '';
		foreach ($range as $k => $ws) {
			if (count(array_count_values($ws)) == 1) {
				// interval mode is more compact
				$w .= ' ' . $k . ' ' . ($k + count($ws) - 1) . ' ' . $ws[0];
			} else {
				// range mode
				$w .= ' ' . $k . ' [ ' . implode(' ', $ws) . ' ]' . "\n";
			}
		}
		return '/W [' . $w . ' ]';
	}

	function _putfontwidths(&$font, $cidoffset = 0)
	{
		ksort($font['cw']);
		unset($font['cw'][65535]);
		$rangeid = 0;
		$range = array();
		$prevcid = -2;
		$prevwidth = -1;
		$interval = false;
		// for each character
		foreach ($font['cw'] as $cid => $width) {
			$cid -= $cidoffset;
			if (!isset($font['dw']) || (isset($font['dw']) && $width != $font['dw'])) {
				if ($cid == ($prevcid + 1)) {
					// consecutive CID
					if ($width == $prevwidth) {
						if ($width == $range[$rangeid][0]) {
							$range[$rangeid][] = $width;
						} else {
							array_pop($range[$rangeid]);
							// new range
							$rangeid = $prevcid;
							$range[$rangeid] = array();
							$range[$rangeid][] = $prevwidth;
							$range[$rangeid][] = $width;
						}
						$interval = true;
						$range[$rangeid]['interval'] = true;
					} else {
						if ($interval) {
							// new range
							$rangeid = $cid;
							$range[$rangeid] = array();
							$range[$rangeid][] = $width;
						} else {
							$range[$rangeid][] = $width;
						}
						$interval = false;
					}
				} else {
					// new range
					$rangeid = $cid;
					$range[$rangeid] = array();
					$range[$rangeid][] = $width;
					$interval = false;
				}
				$prevcid = $cid;
				$prevwidth = $width;
			}
		}
		$this->_out($this->_putfontranges($range));
	}

	/* -- CJK-FONTS -- */

	// from class PDF_Chinese CJK EXTENSIONS
	function _putType0(&$font)
	{
		//Type0
		$this->_out('/Subtype /Type0');
		$this->_out('/BaseFont /' . $font['name'] . '-' . $font['CMap']);
		$this->_out('/Encoding /' . $font['CMap']);
		$this->_out('/DescendantFonts [' . ($this->n + 1) . ' 0 R]');
		$this->_out('>>');
		$this->_out('endobj');
		//CIDFont
		$this->_newobj();
		$this->_out('<</Type /Font');
		$this->_out('/Subtype /CIDFontType0');
		$this->_out('/BaseFont /' . $font['name']);

		$cidinfo = '/Registry ' . $this->_textstring('Adobe');
		$cidinfo .= ' /Ordering ' . $this->_textstring($font['registry']['ordering']);
		$cidinfo .= ' /Supplement ' . $font['registry']['supplement'];
		$this->_out('/CIDSystemInfo <<' . $cidinfo . '>>');

		$this->_out('/FontDescriptor ' . ($this->n + 1) . ' 0 R');
		if (isset($font['MissingWidth'])) {
			$this->_out('/DW ' . $font['MissingWidth'] . '');
		}
		$this->_putfontwidths($font, 31);
		$this->_out('>>');
		$this->_out('endobj');

		//Font descriptor
		$this->_newobj();
		$s = '<</Type /FontDescriptor /FontName /' . $font['name'];
		foreach ($font['desc'] as $k => $v) {
			if ($k != 'Style') {
				$s .= ' /' . $k . ' ' . $v . '';
			}
		}
		$this->_out($s . '>>');
		$this->_out('endobj');
	}

	/* -- END CJK-FONTS -- */

	function _putimages()
	{
		$filter = ($this->compress) ? '/Filter /FlateDecode ' : '';
		reset($this->images);
		while (list($file, $info) = each($this->images)) {
			$this->_newobj();
			$this->images[$file]['n'] = $this->n;
			$this->_out('<</Type /XObject');
			$this->_out('/Subtype /Image');
			$this->_out('/Width ' . $info['w']);
			$this->_out('/Height ' . $info['h']);
			if (isset($info['interpolation']) && $info['interpolation']) {
				$this->_out('/Interpolate true'); // mPDF 6 - image interpolation shall be performed by a conforming reader
			}
			if (isset($info['masked'])) {
				$this->_out('/SMask ' . ($this->n - 1) . ' 0 R');
			}
			// set color space
			$icc = false;
			if (isset($info['icc']) AND ( $info['icc'] !== false)) {
				// ICC Colour Space
				$icc = true;
				$this->_out('/ColorSpace [/ICCBased ' . ($this->n + 1) . ' 0 R]');
			} elseif ($info['cs'] == 'Indexed') {
				if ($this->PDFX || ($this->PDFA && $this->restrictColorSpace == 3)) {
					throw new MpdfException("PDFA1-b and PDFX/1-a files do not permit using mixed colour space (" . $file . ").");
				}
				$this->_out('/ColorSpace [/Indexed /DeviceRGB ' . (strlen($info['pal']) / 3 - 1) . ' ' . ($this->n + 1) . ' 0 R]');
			} else {
				$this->_out('/ColorSpace /' . $info['cs']);
				if ($info['cs'] == 'DeviceCMYK') {
					if ($this->PDFA && $this->restrictColorSpace != 3) {
						throw new MpdfException("PDFA1-b does not permit Images using mixed colour space (" . $file . ").");
					}
					if ($info['type'] == 'jpg') {
						$this->_out('/Decode [1 0 1 0 1 0 1 0]');
					}
				} elseif ($info['cs'] == 'DeviceRGB' && ($this->PDFX || ($this->PDFA && $this->restrictColorSpace == 3))) {
					throw new MpdfException("PDFA1-b and PDFX/1-a files do not permit using mixed colour space (" . $file . ").");
				}
			}
			$this->_out('/BitsPerComponent ' . $info['bpc']);
			if (isset($info['f']) && $info['f']) {
				$this->_out('/Filter /' . $info['f']);
			}
			if (isset($info['parms'])) {
				$this->_out($info['parms']);
			}
			if (isset($info['trns']) and is_array($info['trns'])) {
				$trns = '';
				for ($i = 0; $i < count($info['trns']); $i++)
					$trns.=$info['trns'][$i] . ' ' . $info['trns'][$i] . ' ';
				$this->_out('/Mask [' . $trns . ']');
			}
			$this->_out('/Length ' . strlen($info['data']) . '>>');
			$this->_putstream($info['data']);
			unset($this->images[$file]['data']);
			$this->_out('endobj');

			// ICC colour profile
			if ($icc) {
				$this->_newobj();
				$icc = ($this->compress) ? gzcompress($info['icc']) : $info['icc'];
				$this->_out('<</N ' . $info['ch'] . ' ' . $filter . '/Length ' . strlen($icc) . '>>');
				$this->_putstream($icc);
				$this->_out('endobj');
			}
			//Palette
			elseif ($info['cs'] == 'Indexed') {
				$this->_newobj();
				$pal = ($this->compress) ? gzcompress($info['pal']) : $info['pal'];
				$this->_out('<<' . $filter . '/Length ' . strlen($pal) . '>>');
				$this->_putstream($pal);
				$this->_out('endobj');
			}
		}
	}

	function _putinfo()
	{
		$this->_out('/Producer ' . $this->_UTF16BEtextstring('mPDF ' . mPDF_VERSION));
		if (!empty($this->title))
			$this->_out('/Title ' . $this->_UTF16BEtextstring($this->title));
		if (!empty($this->subject))
			$this->_out('/Subject ' . $this->_UTF16BEtextstring($this->subject));
		if (!empty($this->author))
			$this->_out('/Author ' . $this->_UTF16BEtextstring($this->author));
		if (!empty($this->keywords))
			$this->_out('/Keywords ' . $this->_UTF16BEtextstring($this->keywords));
		if (!empty($this->creator))
			$this->_out('/Creator ' . $this->_UTF16BEtextstring($this->creator));

		$z = date('O'); // +0200
		$offset = substr($z, 0, 3) . "'" . substr($z, 3, 2) . "'";
		$this->_out('/CreationDate ' . $this->_textstring(date('YmdHis') . $offset));
		$this->_out('/ModDate ' . $this->_textstring(date('YmdHis') . $offset));
		if ($this->PDFX) {
			$this->_out('/Trapped/False');
			$this->_out('/GTS_PDFXVersion(PDF/X-1a:2003)');
		}
	}

	function _putmetadata()
	{
		$this->_newobj();
		$this->MetadataRoot = $this->n;
		$Producer = 'mPDF ' . mPDF_VERSION;
		$z = date('O'); // +0200
		$offset = substr($z, 0, 3) . ':' . substr($z, 3, 2);
		$CreationDate = date('Y-m-d\TH:i:s') . $offset; // 2006-03-10T10:47:26-05:00 2006-06-19T09:05:17Z
		$uuid = sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x', mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0x0fff) | 0x4000, mt_rand(0, 0x3fff) | 0x8000, mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff));


		$m = '<?xpacket begin="' . chr(239) . chr(187) . chr(191) . '" id="W5M0MpCehiHzreSzNTczkc9d"?>' . "\n"; // begin = FEFF BOM
		$m .= ' <x:xmpmeta xmlns:x="adobe:ns:meta/" x:xmptk="3.1-701">' . "\n";
		$m .= '  <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">' . "\n";
		$m .= '   <rdf:Description rdf:about="uuid:' . $uuid . '" xmlns:pdf="http://ns.adobe.com/pdf/1.3/">' . "\n";
		$m .= '    <pdf:Producer>' . $Producer . '</pdf:Producer>' . "\n";
		if (!empty($this->keywords)) {
			$m .= '    <pdf:Keywords>' . $this->keywords . '</pdf:Keywords>' . "\n";
		}
		$m .= '   </rdf:Description>' . "\n";

		$m .= '   <rdf:Description rdf:about="uuid:' . $uuid . '" xmlns:xmp="http://ns.adobe.com/xap/1.0/">' . "\n";
		$m .= '    <xmp:CreateDate>' . $CreationDate . '</xmp:CreateDate>' . "\n";
		$m .= '    <xmp:ModifyDate>' . $CreationDate . '</xmp:ModifyDate>' . "\n";
		$m .= '    <xmp:MetadataDate>' . $CreationDate . '</xmp:MetadataDate>' . "\n";
		if (!empty($this->creator)) {
			$m .= '    <xmp:CreatorTool>' . $this->creator . '</xmp:CreatorTool>' . "\n";
		}
		$m .= '   </rdf:Description>' . "\n";

		// DC elements
		$m .= '   <rdf:Description rdf:about="uuid:' . $uuid . '" xmlns:dc="http://purl.org/dc/elements/1.1/">' . "\n";
		$m .= '    <dc:format>application/pdf</dc:format>' . "\n";
		if (!empty($this->title)) {
			$m .= '    <dc:title>
	 <rdf:Alt>
	  <rdf:li xml:lang="x-default">' . $this->title . '</rdf:li>
	 </rdf:Alt>
	</dc:title>' . "\n";
		}
		if (!empty($this->keywords)) {
			$m .= '    <dc:subject>
	 <rdf:Bag>
	  <rdf:li>' . $this->keywords . '</rdf:li>
	 </rdf:Bag>
	</dc:subject>' . "\n";
		}
		if (!empty($this->subject)) {
			$m .= '    <dc:description>
	 <rdf:Alt>
	  <rdf:li xml:lang="x-default">' . $this->subject . '</rdf:li>
	 </rdf:Alt>
	</dc:description>' . "\n";
		}
		if (!empty($this->author)) {
			$m .= '    <dc:creator>
	 <rdf:Seq>
	  <rdf:li>' . $this->author . '</rdf:li>
	 </rdf:Seq>
	</dc:creator>' . "\n";
		}
		$m .= '   </rdf:Description>' . "\n";


		// This bit is specific to PDFX-1a
		if ($this->PDFX) {
			$m .= '   <rdf:Description rdf:about="uuid:' . $uuid . '" xmlns:pdfx="http://ns.adobe.com/pdfx/1.3/" pdfx:Apag_PDFX_Checkup="1.3" pdfx:GTS_PDFXConformance="PDF/X-1a:2003" pdfx:GTS_PDFXVersion="PDF/X-1:2003"/>' . "\n";
		}

		// This bit is specific to PDFA-1b
		elseif ($this->PDFA) {
			$m .= '   <rdf:Description rdf:about="uuid:' . $uuid . '" xmlns:pdfaid="http://www.aiim.org/pdfa/ns/id/" >' . "\n";
			$m .= '    <pdfaid:part>1</pdfaid:part>' . "\n";
			$m .= '    <pdfaid:conformance>B</pdfaid:conformance>' . "\n";
			$m .= '    <pdfaid:amd>2005</pdfaid:amd>' . "\n";
			$m .= '   </rdf:Description>' . "\n";
		}

		$m .= '   <rdf:Description rdf:about="uuid:' . $uuid . '" xmlns:xmpMM="http://ns.adobe.com/xap/1.0/mm/">' . "\n";
		$m .= '    <xmpMM:DocumentID>uuid:' . $uuid . '</xmpMM:DocumentID>' . "\n";
		$m .= '   </rdf:Description>' . "\n";
		$m .= '  </rdf:RDF>' . "\n";
		$m .= ' </x:xmpmeta>' . "\n";
		$m .= str_repeat(str_repeat(' ', 100) . "\n", 20); // 2-4kB whitespace padding required
		$m .= '<?xpacket end="w"?>'; // "r" read only
		$this->_out('<</Type/Metadata/Subtype/XML/Length ' . strlen($m) . '>>');
		$this->_putstream($m);
		$this->_out('endobj');
	}

	function _putoutputintent()
	{
		$this->_newobj();
		$this->OutputIntentRoot = $this->n;
		$this->_out('<</Type /OutputIntent');

		if ($this->PDFA) {
			$this->_out('/S /GTS_PDFA1');
			if ($this->ICCProfile) {
				$this->_out('/Info (' . preg_replace('/_/', ' ', $this->ICCProfile) . ')');
				$this->_out('/OutputConditionIdentifier (Custom)');
				$this->_out('/OutputCondition ()');
			} else {
				$this->_out('/Info (sRGB IEC61966-2.1)');
				$this->_out('/OutputConditionIdentifier (sRGB IEC61966-2.1)');
				$this->_out('/OutputCondition ()');
			}
			$this->_out('/DestOutputProfile ' . ($this->n + 1) . ' 0 R');
		} elseif ($this->PDFX) { // always a CMYK profile
			$this->_out('/S /GTS_PDFX');
			if ($this->ICCProfile) {
				$this->_out('/Info (' . preg_replace('/_/', ' ', $this->ICCProfile) . ')');
				$this->_out('/OutputConditionIdentifier (Custom)');
				$this->_out('/OutputCondition ()');
				$this->_out('/DestOutputProfile ' . ($this->n + 1) . ' 0 R');
			} else {
				$this->_out('/Info (CGATS TR 001)');
				$this->_out('/OutputConditionIdentifier (CGATS TR 001)');
				$this->_out('/OutputCondition (CGATS TR 001 (SWOP))');
				$this->_out('/RegistryName (http://www.color.org)');
			}
		}
		$this->_out('>>');
		$this->_out('endobj');

		if ($this->PDFX && !$this->ICCProfile) {
			return;
		} // no ICCProfile embedded

		$this->_newobj();
		if ($this->ICCProfile)
			$s = file_get_contents(_MPDF_PATH . 'iccprofiles/' . $this->ICCProfile . '.icc');
		else
			$s = file_get_contents(_MPDF_PATH . 'iccprofiles/sRGB_IEC61966-2-1.icc');
		if ($this->compress) {
			$s = gzcompress($s);
		}
		$this->_out('<<');
		if ($this->PDFX || ($this->PDFA && $this->restrictColorSpace == 3)) {
			$this->_out('/N 4');
		} else {
			$this->_out('/N 3');
		}
		if ($this->compress)
			$this->_out('/Filter /FlateDecode ');
		$this->_out('/Length ' . strlen($s) . '>>');
		$this->_putstream($s);
		$this->_out('endobj');
	}

	function _putcatalog()
	{
		$this->_out('/Type /Catalog');
		$this->_out('/Pages 1 0 R');
		if ($this->ZoomMode == 'fullpage')
			$this->_out('/OpenAction [3 0 R /Fit]');
		elseif ($this->ZoomMode == 'fullwidth')
			$this->_out('/OpenAction [3 0 R /FitH null]');
		elseif ($this->ZoomMode == 'real')
			$this->_out('/OpenAction [3 0 R /XYZ null null 1]');
		elseif (!is_string($this->ZoomMode))
			$this->_out('/OpenAction [3 0 R /XYZ null null ' . ($this->ZoomMode / 100) . ']');
		else
			$this->_out('/OpenAction [3 0 R /XYZ null null null]');
		if ($this->LayoutMode == 'single')
			$this->_out('/PageLayout /SinglePage');
		elseif ($this->LayoutMode == 'continuous')
			$this->_out('/PageLayout /OneColumn');
		elseif ($this->LayoutMode == 'twoleft')
			$this->_out('/PageLayout /TwoColumnLeft');
		elseif ($this->LayoutMode == 'tworight')
			$this->_out('/PageLayout /TwoColumnRight');
		elseif ($this->LayoutMode == 'two') {
			if ($this->mirrorMargins) {
				$this->_out('/PageLayout /TwoColumnRight');
			} else {
				$this->_out('/PageLayout /TwoColumnLeft');
			}
		}

		/* -- BOOKMARKS -- */
		if (count($this->BMoutlines) > 0) {
			$this->_out('/Outlines ' . $this->OutlineRoot . ' 0 R');
			$this->_out('/PageMode /UseOutlines');
		}
		/* -- END BOOKMARKS -- */
		if (is_int(strpos($this->DisplayPreferences, 'FullScreen')))
			$this->_out('/PageMode /FullScreen');

		// Metadata
		if ($this->PDFA || $this->PDFX) {
			$this->_out('/Metadata ' . $this->MetadataRoot . ' 0 R');
		}
		// OutputIntents
		if ($this->PDFA || $this->PDFX || $this->ICCProfile) {
			$this->_out('/OutputIntents [' . $this->OutputIntentRoot . ' 0 R]');
		}

		/* -- FORMS -- */
		if (count($this->mpdfform->forms) > 0) {
			$this->mpdfform->_putFormsCatalog();
		}
		/* -- END FORMS -- */
		if (isset($this->js)) {
			$this->_out('/Names << /JavaScript ' . ($this->n_js) . ' 0 R >> ');
		}

		if ($this->DisplayPreferences || $this->directionality == 'rtl' || $this->mirrorMargins) {
			$this->_out('/ViewerPreferences<<');
			if (is_int(strpos($this->DisplayPreferences, 'HideMenubar')))
				$this->_out('/HideMenubar true');
			if (is_int(strpos($this->DisplayPreferences, 'HideToolbar')))
				$this->_out('/HideToolbar true');
			if (is_int(strpos($this->DisplayPreferences, 'HideWindowUI')))
				$this->_out('/HideWindowUI true');
			if (is_int(strpos($this->DisplayPreferences, 'DisplayDocTitle')))
				$this->_out('/DisplayDocTitle true');
			if (is_int(strpos($this->DisplayPreferences, 'CenterWindow')))
				$this->_out('/CenterWindow true');
			if (is_int(strpos($this->DisplayPreferences, 'FitWindow')))
				$this->_out('/FitWindow true');
			// /PrintScaling is PDF 1.6 spec.
			if (is_int(strpos($this->DisplayPreferences, 'NoPrintScaling')) && !$this->PDFA && !$this->PDFX)
				$this->_out('/PrintScaling /None');
			if ($this->directionality == 'rtl')
				$this->_out('/Direction /R2L');
			// /Duplex is PDF 1.7 spec.
			if ($this->mirrorMargins && !$this->PDFA && !$this->PDFX) {
				// if ($this->DefOrientation=='P') $this->_out('/Duplex /DuplexFlipShortEdge');
				$this->_out('/Duplex /DuplexFlipLongEdge'); // PDF v1.7+
			}
			$this->_out('>>');
		}
		if ($this->open_layer_pane && ($this->hasOC || count($this->layers)))
			$this->_out('/PageMode /UseOC');

		if ($this->hasOC || count($this->layers)) {
			$p = $v = $h = $l = $loff = $lall = $as = '';
			if ($this->hasOC) {
				if (($this->hasOC & 1) == 1)
					$p = $this->n_ocg_print . ' 0 R';
				if (($this->hasOC & 2) == 2)
					$v = $this->n_ocg_view . ' 0 R';
				if (($this->hasOC & 4) == 4)
					$h = $this->n_ocg_hidden . ' 0 R';
				$as = "<</Event /Print /OCGs [$p $v $h] /Category [/Print]>> <</Event /View /OCGs [$p $v $h] /Category [/View]>>";
			}

			if (count($this->layers)) {
				foreach ($this->layers as $k => $layer) {
					if (strtolower($this->layerDetails[$k]['state']) == 'hidden') {
						$loff .= $layer['n'] . ' 0 R ';
					} else {
						$l .= $layer['n'] . ' 0 R ';
					}
					$lall .= $layer['n'] . ' 0 R ';
				}
			}
			$this->_out("/OCProperties <</OCGs [$p $v $h $lall] /D <</ON [$p $l] /OFF [$v $h $loff] ");
			$this->_out("/Order [$v $p $h $lall] ");
			if ($as)
				$this->_out("/AS [$as] ");
			$this->_out(">>>>");
		}
	}

	// Inactive function left for backwards compatability
	function SetUserRights($enable = true, $annots = "", $form = "", $signature = "")
	{
		// Does nothing
	}

	function _enddoc()
	{
		if ($this->progressBar) {
			$this->UpdateProgressBar(2, '10', 'Writing Headers & Footers');
		} // *PROGRESS-BAR*
		$this->_puthtmlheaders();
		if ($this->progressBar) {
			$this->UpdateProgressBar(2, '20', 'Writing Pages');
		} // *PROGRESS-BAR*
		// Remove references to unused fonts (usually default font)
		foreach ($this->fonts as $fk => $font) {
			if (isset($font['type']) && $font['type'] == 'TTF' && !$font['used']) {
				if ($font['sip'] || $font['smp']) {
					foreach ($font['subsetfontids'] AS $k => $fid) {
						foreach ($this->pages AS $pn => $page) {
							$this->pages[$pn] = preg_replace('/\s\/F' . $fid . ' \d[\d.]* Tf\s/is', ' ', $this->pages[$pn]);
						}
					}
				} else {
					foreach ($this->pages AS $pn => $page) {
						$this->pages[$pn] = preg_replace('/\s\/F' . $font['i'] . ' \d[\d.]* Tf\s/is', ' ', $this->pages[$pn]);
					}
				}
			}
		}

		if (count($this->layers)) {
			foreach ($this->pages AS $pn => $page) {
				preg_match_all('/\/OCZ-index \/ZI(\d+) BDC(.*?)(EMCZ)-index/is', $this->pages[$pn], $m1);
				preg_match_all('/\/OCBZ-index \/ZI(\d+) BDC(.*?)(EMCBZ)-index/is', $this->pages[$pn], $m2);
				preg_match_all('/\/OCGZ-index \/ZI(\d+) BDC(.*?)(EMCGZ)-index/is', $this->pages[$pn], $m3);
				$m = array();
				for ($i = 0; $i < 4; $i++) {
					$m[$i] = array_merge($m1[$i], $m2[$i], $m3[$i]);
				}
				if (count($m[0])) {
					$sortarr = array();
					for ($i = 0; $i < count($m[0]); $i++) {
						$key = $m[1][$i] * 2;
						if ($m[3][$i] == 'EMCZ')
							$key +=2; // background first then gradient then normal
						elseif ($m[3][$i] == 'EMCGZ')
							$key +=1;
						$sortarr[$i] = $key;
					}
					asort($sortarr);
					foreach ($sortarr AS $i => $k) {
						$this->pages[$pn] = str_replace($m[0][$i], '', $this->pages[$pn]);
						$this->pages[$pn] .= "\n" . $m[0][$i] . "\n";
					}
					$this->pages[$pn] = preg_replace('/\/OC[BG]{0,1}Z-index \/ZI(\d+) BDC/is', '/OC /ZI\\1 BDC ', $this->pages[$pn]);
					$this->pages[$pn] = preg_replace('/EMC[BG]{0,1}Z-index/is', 'EMC', $this->pages[$pn]);
				}
			}
		}

		$this->_putpages();
		if ($this->progressBar) {
			$this->UpdateProgressBar(2, '30', 'Writing document resources');
		} // *PROGRESS-BAR*

		$this->_putresources();
		//Info
		$this->_newobj();
		$this->InfoRoot = $this->n;
		$this->_out('<<');
		if ($this->progressBar) {
			$this->UpdateProgressBar(2, '80', 'Writing document info');
		} // *PROGRESS-BAR*
		$this->_putinfo();
		$this->_out('>>');
		$this->_out('endobj');

		// METADATA
		if ($this->PDFA || $this->PDFX) {
			$this->_putmetadata();
		}
		// OUTPUTINTENT
		if ($this->PDFA || $this->PDFX || $this->ICCProfile) {
			$this->_putoutputintent();
		}

		//Catalog
		$this->_newobj();
		$this->_out('<<');
		if ($this->progressBar) {
			$this->UpdateProgressBar(2, '90', 'Writing document catalog');
		} // *PROGRESS-BAR*
		$this->_putcatalog();
		$this->_out('>>');
		$this->_out('endobj');
		//Cross-ref
		$o = strlen($this->buffer);
		$this->_out('xref');
		$this->_out('0 ' . ($this->n + 1));
		$this->_out('0000000000 65535 f ');
		for ($i = 1; $i <= $this->n; $i++)
			$this->_out(sprintf('%010d 00000 n ', $this->offsets[$i]));
		//Trailer
		$this->_out('trailer');
		$this->_out('<<');
		$this->_puttrailer();
		$this->_out('>>');
		$this->_out('startxref');
		$this->_out($o);

		$this->buffer .= '%%EOF';
		$this->state = 3;
		/* -- IMPORTS -- */

		if ($this->enableImports && count($this->parsers) > 0) {
			foreach ($this->parsers as $k => $_) {
				$this->parsers[$k]->closeFile();
				$this->parsers[$k] = null;
				unset($this->parsers[$k]);
			}
		}
		/* -- END IMPORTS -- */
	}

	function _beginpage($orientation, $mgl = '', $mgr = '', $mgt = '', $mgb = '', $mgh = '', $mgf = '', $ohname = '', $ehname = '', $ofname = '', $efname = '', $ohvalue = 0, $ehvalue = 0, $ofvalue = 0, $efvalue = 0, $pagesel = '', $newformat = '')
	{
		if (!($pagesel && $this->page == 1 && (sprintf("%0.4f", $this->y) == sprintf("%0.4f", $this->tMargin)))) {
			$this->page++;
			$this->pages[$this->page] = '';
		}
		$this->state = 2;
		$resetHTMLHeadersrequired = false;

		if ($newformat) {
			$this->_setPageSize($newformat, $orientation);
		}
		/* -- CSS-PAGE -- */
		// Paged media (page-box)
		if ($pagesel || (isset($this->page_box['using']) && $this->page_box['using'])) {
			if ($pagesel || $this->page == 1) {
				$first = true;
			} else {
				$first = false;
			}
			if ($this->mirrorMargins && ($this->page % 2 == 0)) {
				$oddEven = 'E';
			} else {
				$oddEven = 'O';
			}
			if ($pagesel) {
				$psel = $pagesel;
			} elseif ($this->page_box['current']) {
				$psel = $this->page_box['current'];
			} else {
				$psel = '';
			}
			list($orientation, $mgl, $mgr, $mgt, $mgb, $mgh, $mgf, $hname, $fname, $bg, $resetpagenum, $pagenumstyle, $suppress, $marks, $newformat) = $this->SetPagedMediaCSS($psel, $first, $oddEven);
			if ($this->mirrorMargins && ($this->page % 2 == 0)) {
				if ($hname) {
					$ehvalue = 1;
					$ehname = $hname;
				} else {
					$ehvalue = -1;
				}
				if ($fname) {
					$efvalue = 1;
					$efname = $fname;
				} else {
					$efvalue = -1;
				}
			} else {
				if ($hname) {
					$ohvalue = 1;
					$ohname = $hname;
				} else {
					$ohvalue = -1;
				}
				if ($fname) {
					$ofvalue = 1;
					$ofname = $fname;
				} else {
					$ofvalue = -1;
				}
			}
			if ($resetpagenum || $pagenumstyle || $suppress) {
				$this->PageNumSubstitutions[] = array('from' => ($this->page), 'reset' => $resetpagenum, 'type' => $pagenumstyle, 'suppress' => $suppress);
			}
			// PAGED MEDIA - CROP / CROSS MARKS from @PAGE
			$this->show_marks = $marks;

			// Background color
			if (isset($bg['BACKGROUND-COLOR'])) {
				$cor = $this->ConvertColor($bg['BACKGROUND-COLOR']);
				if ($cor) {
					$this->bodyBackgroundColor = $cor;
				}
			} else {
				$this->bodyBackgroundColor = false;
			}

			/* -- BACKGROUNDS -- */
			if (isset($bg['BACKGROUND-GRADIENT'])) {
				$this->bodyBackgroundGradient = $bg['BACKGROUND-GRADIENT'];
			} else {
				$this->bodyBackgroundGradient = false;
			}

			// Tiling Patterns
			if (isset($bg['BACKGROUND-IMAGE']) && $bg['BACKGROUND-IMAGE']) {
				$ret = $this->SetBackground($bg, $this->pgwidth);
				if ($ret) {
					$this->bodyBackgroundImage = $ret;
				}
			} else {
				$this->bodyBackgroundImage = false;
			}
			/* -- END BACKGROUNDS -- */

			$this->page_box['current'] = $psel;
			$this->page_box['using'] = true;
		}
		/* -- END CSS-PAGE -- */

		//Page orientation
		if (!$orientation)
			$orientation = $this->DefOrientation;
		else {
			$orientation = strtoupper(substr($orientation, 0, 1));
			if ($orientation != $this->DefOrientation)
				$this->OrientationChanges[$this->page] = true;
		}
		if ($orientation != $this->CurOrientation || $newformat) {

			//Change orientation
			if ($orientation == 'P') {
				$this->wPt = $this->fwPt;
				$this->hPt = $this->fhPt;
				$this->w = $this->fw;
				$this->h = $this->fh;
				if (($this->forcePortraitHeaders || $this->forcePortraitMargins) && $this->DefOrientation == 'P') {
					$this->tMargin = $this->orig_tMargin;
					$this->bMargin = $this->orig_bMargin;
					$this->DeflMargin = $this->orig_lMargin;
					$this->DefrMargin = $this->orig_rMargin;
					$this->margin_header = $this->orig_hMargin;
					$this->margin_footer = $this->orig_fMargin;
				} else {
					$resetHTMLHeadersrequired = true;
				}
			} else {
				$this->wPt = $this->fhPt;
				$this->hPt = $this->fwPt;
				$this->w = $this->fh;
				$this->h = $this->fw;
				if (($this->forcePortraitHeaders || $this->forcePortraitMargins) && $this->DefOrientation == 'P') {
					$this->tMargin = $this->orig_lMargin;
					$this->bMargin = $this->orig_rMargin;
					$this->DeflMargin = $this->orig_bMargin;
					$this->DefrMargin = $this->orig_tMargin;
					$this->margin_header = $this->orig_hMargin;
					$this->margin_footer = $this->orig_fMargin;
				} else {
					$resetHTMLHeadersrequired = true;
				}
			}
			$this->CurOrientation = $orientation;
			$this->ResetMargins();
			$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
			$this->PageBreakTrigger = $this->h - $this->bMargin;
		}

		$this->pageDim[$this->page]['w'] = $this->w;
		$this->pageDim[$this->page]['h'] = $this->h;

		$this->pageDim[$this->page]['outer_width_LR'] = isset($this->page_box['outer_width_LR']) ? $this->page_box['outer_width_LR'] : 0;
		$this->pageDim[$this->page]['outer_width_TB'] = isset($this->page_box['outer_width_TB']) ? $this->page_box['outer_width_TB'] : 0;
		if (!isset($this->page_box['outer_width_LR']) && !isset($this->page_box['outer_width_TB'])) {
			$this->pageDim[$this->page]['bleedMargin'] = 0;
		} elseif ($this->bleedMargin <= $this->page_box['outer_width_LR'] && $this->bleedMargin <= $this->page_box['outer_width_TB']) {
			$this->pageDim[$this->page]['bleedMargin'] = $this->bleedMargin;
		} else {
			$this->pageDim[$this->page]['bleedMargin'] = min($this->page_box['outer_width_LR'], $this->page_box['outer_width_TB']) - 0.01;
		}

		// If Page Margins are re-defined
		// strlen()>0 is used to pick up (integer) 0, (string) '0', or set value
		if ((strlen($mgl) > 0 && $this->DeflMargin != $mgl) || (strlen($mgr) > 0 && $this->DefrMargin != $mgr) || (strlen($mgt) > 0 && $this->tMargin != $mgt) || (strlen($mgb) > 0 && $this->bMargin != $mgb) || (strlen($mgh) > 0 && $this->margin_header != $mgh) || (strlen($mgf) > 0 && $this->margin_footer != $mgf)) {
			if (strlen($mgl) > 0)
				$this->DeflMargin = $mgl;
			if (strlen($mgr) > 0)
				$this->DefrMargin = $mgr;
			if (strlen($mgt) > 0)
				$this->tMargin = $mgt;
			if (strlen($mgb) > 0)
				$this->bMargin = $mgb;
			if (strlen($mgh) > 0)
				$this->margin_header = $mgh;
			if (strlen($mgf) > 0)
				$this->margin_footer = $mgf;
			$this->ResetMargins();
			$this->SetAutoPageBreak($this->autoPageBreak, $this->bMargin);
			$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
			$resetHTMLHeadersrequired = true;
		}

		$this->ResetMargins();
		$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
		$this->SetAutoPageBreak($this->autoPageBreak, $this->bMargin);

		// Reset column top margin
		$this->y0 = $this->tMargin;

		$this->x = $this->lMargin;
		$this->y = $this->tMargin;
		$this->FontFamily = '';

		// HEADERS AND FOOTERS	// mPDF 6
		if ($ohvalue < 0 || strtoupper($ohvalue) == 'OFF') {
			$this->HTMLHeader = '';
			$resetHTMLHeadersrequired = true;
		} elseif ($ohname && $ohvalue > 0) {
			if (preg_match('/^html_(.*)$/i', $ohname, $n)) {
				$name = $n[1];
			} else {
				$name = $ohname;
			}
			if (isset($this->pageHTMLheaders[$name])) {
				$this->HTMLHeader = $this->pageHTMLheaders[$name];
			} else {
				$this->HTMLHeader = '';
			}
			$resetHTMLHeadersrequired = true;
		}

		if ($ehvalue < 0 || strtoupper($ehvalue) == 'OFF') {
			$this->HTMLHeaderE = '';
			$resetHTMLHeadersrequired = true;
		} elseif ($ehname && $ehvalue > 0) {
			if (preg_match('/^html_(.*)$/i', $ehname, $n)) {
				$name = $n[1];
			} else {
				$name = $ehname;
			}
			if (isset($this->pageHTMLheaders[$name])) {
				$this->HTMLHeaderE = $this->pageHTMLheaders[$name];
			} else {
				$this->HTMLHeaderE = '';
			}
			$resetHTMLHeadersrequired = true;
		}

		if ($ofvalue < 0 || strtoupper($ofvalue) == 'OFF') {
			$this->HTMLFooter = '';
			$resetHTMLHeadersrequired = true;
		} elseif ($ofname && $ofvalue > 0) {
			if (preg_match('/^html_(.*)$/i', $ofname, $n)) {
				$name = $n[1];
			} else {
				$name = $ofname;
			}
			if (isset($this->pageHTMLfooters[$name])) {
				$this->HTMLFooter = $this->pageHTMLfooters[$name];
			} else {
				$this->HTMLFooter = '';
			}
			$resetHTMLHeadersrequired = true;
		}

		if ($efvalue < 0 || strtoupper($efvalue) == 'OFF') {
			$this->HTMLFooterE = '';
			$resetHTMLHeadersrequired = true;
		} elseif ($efname && $efvalue > 0) {
			if (preg_match('/^html_(.*)$/i', $efname, $n)) {
				$name = $n[1];
			} else {
				$name = $efname;
			}
			if (isset($this->pageHTMLfooters[$name])) {
				$this->HTMLFooterE = $this->pageHTMLfooters[$name];
			} else {
				$this->HTMLFooterE = '';
			}
			$resetHTMLHeadersrequired = true;
		}
		if ($resetHTMLHeadersrequired) {
			$this->SetHTMLHeader($this->HTMLHeader);
			$this->SetHTMLHeader($this->HTMLHeaderE, 'E');
			$this->SetHTMLFooter($this->HTMLFooter);
			$this->SetHTMLFooter($this->HTMLFooterE, 'E');
		}


		if (($this->mirrorMargins) && (($this->page) % 2 == 0)) { // EVEN
			$this->_setAutoHeaderHeight($this->HTMLHeaderE);
			$this->_setAutoFooterHeight($this->HTMLFooterE);
		} else { // ODD or DEFAULT
			$this->_setAutoHeaderHeight($this->HTMLHeader);
			$this->_setAutoFooterHeight($this->HTMLFooter);
		}
		// Reset column top margin
		$this->y0 = $this->tMargin;

		$this->x = $this->lMargin;
		$this->y = $this->tMargin;
	}

	// mPDF 6
	function _setAutoHeaderHeight(&$htmlh)
	{
		if ($this->setAutoTopMargin == 'pad') {
			if (isset($htmlh['h']) && $htmlh['h']) {
				$h = $htmlh['h'];
			} // 5.7.3
			else {
				$h = 0;
			}
			
           if($this->page == 1) {
                if($this->PDFMakerDispHeader["dh_first"] !== false) {
                    $this->tMargin = $this->margin_header + $h + $this->orig_tMargin;
                } else {
                    $this->tMargin = $this->margin_header;  
                }  
	       } else {
                if($this->PDFMakerDispHeader["dh_other"] !== false) {
                   $this->tMargin = $this->margin_header + $h + $this->orig_tMargin;
                } else {
                    $this->tMargin = $this->margin_header;  
                } 
           }
        } elseif ($this->setAutoTopMargin == 'stretch') {
			if (isset($htmlh['h']) && $htmlh['h']) {
				$h = $htmlh['h'];
			} // 5.7.3
			else {
				$h = 0;
			}
            
            if($this->page == 1) {
                if($this->PDFMakerDispHeader["dh_first"] !== false)
                    $this->tMargin = max($this->orig_tMargin, $this->margin_header + $h + $this->autoMarginPadding);
                else
                    $this->tMargin = max($this->orig_tMargin, $this->margin_header + $h + $this->autoMarginPadding);
            } else {
                if($this->PDFMakerDispHeader["dh_other"] !== false)
                    $this->tMargin = max($this->orig_tMargin, $h + $this->autoMarginPadding);
                else
                    $this->tMargin = max($this->orig_tMargin, $h + $this->autoMarginPadding);
            }
            
			
		}
	}

	// mPDF 6
	function _setAutoFooterHeight(&$htmlf)
	{
		if ($this->setAutoBottomMargin == 'pad') {
			if (isset($htmlf['h']) && $htmlf['h']) {
				$h = $htmlf['h'];
			} // 5.7.3
			else {
				$h = 0;
			}
			// ITS4YOU VlZa
            if($this->page == 1) {
                if($this->PDFMakerDispFooter["df_first"] !== false)
                    $this->bMargin = $this->margin_footer + $h + $this->orig_bMargin;
                else
                    $this->bMargin = $this->margin_footer;
            } else {
                if($this->PDFMakerDispFooter["df_other"] !== false)
                    $this->bMargin = $this->margin_footer + $h + $this->orig_bMargin;
                else
                    $this->bMargin = $this->margin_footer;
            }            
            // ITS4YOU-END
			$this->PageBreakTrigger = $this->h - $this->bMargin;
		} elseif ($this->setAutoBottomMargin == 'stretch') {
			if (isset($htmlf['h']) && $htmlf['h']) {
				$h = $htmlf['h'];
			} // 5.7.3
			else {
				$h = 0;
			}
			
             // ITS4YOU VlZa
            if($this->page == 1)
            {
                if($this->PDFMakerDispFooter["df_first"] !== false)
                    $this->bMargin = max($this->orig_bMargin, $this->margin_footer + $h + $this->autoMarginPadding);
                else
                    $this->bMargin = $this->margin_footer;
            }
            else
            {
                if($this->PDFMakerDispFooter["df_other"] !== false)
                    $this->bMargin = max($this->orig_bMargin, $this->margin_footer + $h + $this->autoMarginPadding);
                else
                    $this->bMargin = $this->margin_footer;
            }
            // ITS4YOU-END
			$this->PageBreakTrigger = $this->h - $this->bMargin;
		}
	}

	function _endpage()
	{
		/* -- CSS-IMAGE-FLOAT -- */
		$this->printfloatbuffer();
		/* -- END CSS-IMAGE-FLOAT -- */

		if ($this->visibility != 'visible')
			$this->SetVisibility('visible');
		$this->EndLayer();
		//End of page contents
		$this->state = 1;
	}

	function _newobj($obj_id = false, $onlynewobj = false)
	{
		if (!$obj_id) {
			$obj_id = ++$this->n;
		}
		//Begin a new object
		if (!$onlynewobj) {
			$this->offsets[$obj_id] = strlen($this->buffer);
			$this->_out($obj_id . ' 0 obj');
			$this->_current_obj_id = $obj_id; // for later use with encryption
		}
	}

	function _dounderline($x, $y, $txt, $OTLdata = false, $textvar = 0)
	{
		// Now print line exactly where $y secifies - called from Text() and Cell() - adjust  position there
		// WORD SPACING
		$w = ($this->GetStringWidth($txt, false, $OTLdata, $textvar) * _MPDFK) + ($this->charspacing * mb_strlen($txt, $this->mb_enc)) + ( $this->ws * mb_substr_count($txt, ' ', $this->mb_enc));
		//Draw a line
		return sprintf('%.3F %.3F m %.3F %.3F l S', $x * _MPDFK, ($this->h - $y) * _MPDFK, ($x * _MPDFK) + $w, ($this->h - $y) * _MPDFK);
	}

	function _imageError($file, $firsttime, $msg)
	{
		// Save re-trying image URL's which have already failed
		$this->failedimages[$file] = true;
		if ($firsttime && ($this->showImageErrors || $this->debug)) {
			throw new MpdfException("IMAGE Error (" . $file . "): " . $msg);
		}
		return false;
	}

	function _getImage(&$file, $firsttime = true, $allowvector = true, $orig_srcpath = false, $interpolation = false)
	{  // mPDF 6
		// firsttime i.e. whether to add to this->images - use false when calling iteratively
		// Image Data passed directly as var:varname
		if (preg_match('/var:\s*(.*)/', $file, $v)) {
			$data = $this->{$v[1]};
			$file = md5($data);
		}
		if (preg_match('/data:image\/(gif|jpeg|png);base64,(.*)/', $file, $v)) {
			$type = $v[1];
			$data = base64_decode($v[2]);
			$file = md5($data);
		}

		// mPDF 5.7.4 URLs
		if ($firsttime && $file && substr($file, 0, 5) != 'data:') {
			$file = str_replace(" ", "%20", $file);
		}
		if ($firsttime && $orig_srcpath) {
			// If orig_srcpath is a relative file path (and not a URL), then it needs to be URL decoded
			if (substr($orig_srcpath, 0, 5) != 'data:') {
				$orig_srcpath = str_replace(" ", "%20", $orig_srcpath);
			}
			if (!preg_match('/^(http|ftp)/', $orig_srcpath)) {
				$orig_srcpath = urldecode_parts($orig_srcpath);
			}
		}

		$ppUx = 0;
		if ($orig_srcpath && isset($this->images[$orig_srcpath])) {
			$file = $orig_srcpath;
			return $this->images[$orig_srcpath];
		}
		if (isset($this->images[$file])) {
			return $this->images[$file];
		} elseif ($orig_srcpath && isset($this->formobjects[$orig_srcpath])) {
			$file = $orig_srcpath;
			return $this->formobjects[$file];
		} elseif (isset($this->formobjects[$file])) {
			return $this->formobjects[$file];
		}
		// Save re-trying image URL's which have already failed
		elseif ($firsttime && isset($this->failedimages[$file])) {
			return $this->_imageError($file, $firsttime, '');
		}
		if (empty($data)) {
			$type = '';
			$data = '';

			if ($orig_srcpath && $this->basepathIsLocal && $check = @fopen($orig_srcpath, "rb")) {
				fclose($check);
				$file = $orig_srcpath;
				$data = file_get_contents($file);
				$type = $this->_imageTypeFromString($data);
			}
			if (!$data && $check = @fopen($file, "rb")) {
				fclose($check);
				$data = file_get_contents($file);
				$type = $this->_imageTypeFromString($data);
			}
			if ((!$data || !$type) && !ini_get('allow_url_fopen')) { // only worth trying if remote file and !ini_get('allow_url_fopen')
				$this->file_get_contents_by_socket($file, $data); // needs full url?? even on local (never needed for local)
				if ($data) {
					$type = $this->_imageTypeFromString($data);
				}
			}
			if ((!$data || !$type) && function_exists("curl_init")) { // mPDF 5.7.4
				$this->file_get_contents_by_curl($file, $data);  // needs full url?? even on local (never needed for local)
				if ($data) {
					$type = $this->_imageTypeFromString($data);
				}
			}
		}
		if (!$data) {
			return $this->_imageError($file, $firsttime, 'Could not find image file');
		}
		if (empty($type)) {
			$type = $this->_imageTypeFromString($data);
		}
		if (($type == 'wmf' || $type == 'svg') && !$allowvector) {
			return $this->_imageError($file, $firsttime, 'WMF or SVG image file not supported in this context');
		}

		// SVG
		if ($type == 'svg') {
			if (!class_exists('SVG', false)) {
				include(_MPDF_PATH . 'classes/svg.php');
			}
			$svg = new SVG($this);
			$family = $this->FontFamily;
			$style = $this->FontStyle;
			$size = $this->FontSizePt;
			$info = $svg->ImageSVG($data);
			//Restore font
			if ($family)
				$this->SetFont($family, $style, $size, false);
			if (!$info) {
				return $this->_imageError($file, $firsttime, 'Error parsing SVG file');
			}
			$info['type'] = 'svg';
			$info['i'] = count($this->formobjects) + 1;
			$this->formobjects[$file] = $info;
			return $info;
		}

		// JPEG
		if ($type == 'jpeg' || $type == 'jpg') {
			$hdr = $this->_jpgHeaderFromString($data);
			if (!$hdr) {
				return $this->_imageError($file, $firsttime, 'Error parsing JPG header');
			}
			$a = $this->_jpgDataFromHeader($hdr);
			$channels = intval($a[4]);
			$j = strpos($data, 'JFIF');
			if ($j) {
				//Read resolution
				$unitSp = ord(substr($data, ($j + 7), 1));
				if ($unitSp > 0) {
					$ppUx = $this->_twobytes2int(substr($data, ($j + 8), 2)); // horizontal pixels per meter, usually set to zero
					if ($unitSp == 2) { // = dots per cm (if == 1 set as dpi)
						$ppUx = round($ppUx / 10 * 25.4);
					}
				}
			}
			if ($a[2] == 'DeviceCMYK' && (($this->PDFA && $this->restrictColorSpace != 3) || $this->restrictColorSpace == 2)) {
				// convert to RGB image
				if (!function_exists("gd_info")) {
					throw new MpdfException("JPG image may not use CMYK color space (" . $file . ").");
				}
				if ($this->PDFA && !$this->PDFAauto) {
					$this->PDFAXwarnings[] = "JPG image may not use CMYK color space - " . $file . " - (Image converted to RGB. NB This will alter the colour profile of the image.)";
				}
				$im = @imagecreatefromstring($data);
				if ($im) {
					$tempfile = _MPDF_TEMP_PATH . '_tempImgPNG' . md5($file) . RAND(1, 10000) . '.png';
					imageinterlace($im, false);
					$check = @imagepng($im, $tempfile);
					if (!$check) {
						return $this->_imageError($file, $firsttime, 'Error creating temporary file (' . $tempfile . ') whilst using GD library to parse JPG(CMYK) image');
					}
					$info = $this->_getImage($tempfile, false);
					if (!$info) {
						return $this->_imageError($file, $firsttime, 'Error parsing temporary file (' . $tempfile . ') created with GD library to parse JPG(CMYK) image');
					}
					imagedestroy($im);
					unlink($tempfile);
					$info['type'] = 'jpg';
					if ($firsttime) {
						$info['i'] = count($this->images) + 1;
						$info['interpolation'] = $interpolation; // mPDF 6
						$this->images[$file] = $info;
					}
					return $info;
				} else {
					return $this->_imageError($file, $firsttime, 'Error creating GD image file from JPG(CMYK) image');
				}
			} elseif ($a[2] == 'DeviceRGB' && ($this->PDFX || $this->restrictColorSpace == 3)) {
				// Convert to CMYK image stream - nominally returned as type='png'
				$info = $this->_convImage($data, $a[2], 'DeviceCMYK', $a[0], $a[1], $ppUx, false);
				if (($this->PDFA && !$this->PDFAauto) || ($this->PDFX && !$this->PDFXauto)) {
					$this->PDFAXwarnings[] = "JPG image may not use RGB color space - " . $file . " - (Image converted to CMYK. NB This will alter the colour profile of the image.)";
				}
			} elseif (($a[2] == 'DeviceRGB' || $a[2] == 'DeviceCMYK') && $this->restrictColorSpace == 1) {
				// Convert to Grayscale image stream - nominally returned as type='png'
				$info = $this->_convImage($data, $a[2], 'DeviceGray', $a[0], $a[1], $ppUx, false);
			} else {

				// mPDF 6 Detect Adobe APP14 Tag
				//$pos = strpos($data, "\xFF\xEE\x00\x0EAdobe\0");
				//if ($pos !== false) {
				//}
				// mPDF 6 ICC profile
				$offset = 0;
				$icc = array();
				while (($pos = strpos($data, "ICC_PROFILE\0", $offset)) !== false) {
					// get ICC sequence length
					$length = $this->_twobytes2int(substr($data, ($pos - 2), 2)) - 16;
					$sn = max(1, ord($data[($pos + 12)]));
					$nom = max(1, ord($data[($pos + 13)]));
					$icc[($sn - 1)] = substr($data, ($pos + 14), $length);
					$offset = ($pos + 14 + $length);
				}
				// order and compact ICC segments
				if (count($icc) > 0) {
					ksort($icc);
					$icc = implode('', $icc);
					if (substr($icc, 36, 4) != 'acsp') {
						// invalid ICC profile
						$icc = false;
					}
					$input = substr($icc, 16, 4);
					$output = substr($icc, 20, 4);
					// Ignore Color profiles for conversion to other colorspaces e.g. CMYK/Lab
					if ($input != 'RGB ' || $output != 'XYZ ') {
						$icc = false;
					}
				} else {
					$icc = false;
				}

				$info = array('w' => $a[0], 'h' => $a[1], 'cs' => $a[2], 'bpc' => $a[3], 'f' => 'DCTDecode', 'data' => $data, 'type' => 'jpg', 'ch' => $channels, 'icc' => $icc);
				if ($ppUx) {
					$info['set-dpi'] = $ppUx;
				}
			}
			if (!$info) {
				return $this->_imageError($file, $firsttime, 'Error parsing or converting JPG image');
			}
			if ($firsttime) {
				$info['i'] = count($this->images) + 1;
				$info['interpolation'] = $interpolation; // mPDF 6
				$this->images[$file] = $info;
			}
			return $info;
		}

		// PNG
		elseif ($type == 'png') {
			//Check signature
			if (substr($data, 0, 8) != chr(137) . 'PNG' . chr(13) . chr(10) . chr(26) . chr(10)) {
				return $this->_imageError($file, $firsttime, 'Error parsing PNG identifier');
			}
			//Read header chunk
			if (substr($data, 12, 4) != 'IHDR') {
				return $this->_imageError($file, $firsttime, 'Incorrect PNG file (no IHDR block found)');
			}

			$w = $this->_fourbytes2int(substr($data, 16, 4));
			$h = $this->_fourbytes2int(substr($data, 20, 4));
			$bpc = ord(substr($data, 24, 1));
			$errpng = false;
			$pngalpha = false;
			$channels = 0;

			//	if($bpc>8) { $errpng = 'not 8-bit depth'; }	// mPDF 6 Allow through to be handled as native PNG

			$ct = ord(substr($data, 25, 1));
			if ($ct == 0) {
				$colspace = 'DeviceGray';
				$channels = 1;
			} elseif ($ct == 2) {
				$colspace = 'DeviceRGB';
				$channels = 3;
			} elseif ($ct == 3) {
				$colspace = 'Indexed';
				$channels = 1;
			} elseif ($ct == 4) {
				$colspace = 'DeviceGray';
				$channels = 1;
				$errpng = 'alpha channel';
				$pngalpha = true;
			} else {
				$colspace = 'DeviceRGB';
				$channels = 3;
				$errpng = 'alpha channel';
				$pngalpha = true;
			}

			if ($ct < 4 && strpos($data, 'tRNS') !== false) {
				$errpng = 'transparency';
				$pngalpha = true;
			} // mPDF 6

			if ($ct == 3 && strpos($data, 'iCCP') !== false) {
				$errpng = 'indexed plus ICC';
			} // mPDF 6
			// $pngalpha is used as a FLAG of any kind of transparency which COULD be tranferred to an alpha channel
			// incl. single-color tarnsparency, depending which type of handling occurs later

			if (ord(substr($data, 26, 1)) != 0) {
				$errpng = 'compression method';
			} // only 0 should be specified
			if (ord(substr($data, 27, 1)) != 0) {
				$errpng = 'filter method';
			}  // only 0 should be specified
			if (ord(substr($data, 28, 1)) != 0) {
				$errpng = 'interlaced file';
			}

			$j = strpos($data, 'pHYs');
			if ($j) {
				//Read resolution
				$unitSp = ord(substr($data, ($j + 12), 1));
				if ($unitSp == 1) {
					$ppUx = $this->_fourbytes2int(substr($data, ($j + 4), 4)); // horizontal pixels per meter, usually set to zero
					$ppUx = round($ppUx / 1000 * 25.4);
				}
			}

			// mPDF 6 Gamma correction
			$gamma_correction = 0;
			$gAMA = 0;
			$j = strpos($data, 'gAMA');
			if ($j && strpos($data, 'sRGB') === false) { // sRGB colorspace - overrides gAMA
				$gAMA = $this->_fourbytes2int(substr($data, ($j + 4), 4)); // Gamma value times 100000
				$gAMA /= 100000;

				// http://www.libpng.org/pub/png/spec/1.2/PNG-Encoders.html
				// "If the source file's gamma value is greater than 1.0, it is probably a display system exponent,..."
				// ("..and you should use its reciprocal for the PNG gamma.")
				//if ($gAMA > 1) { $gAMA = 1/$gAMA; }
				// (Some) Applications seem to ignore it... appearing how it was probably intended
				// Test Case - image(s) on http://www.w3.org/TR/CSS21/intro.html  - PNG has gAMA set as 1.45454
				// Probably unintentional as mentioned above and should be 0.45454 which is 1 / 2.2
				// Tested on Windows PC
				// Firefox and Opera display gray as 234 (correct, but looks wrong)
				// IE9 and Safari display gray as 193 (incorrect but looks right)
				// See test different gamma chunks at http://www.libpng.org/pub/png/pngsuite-all-good.html
			}

			if ($gAMA) {
				$gamma_correction = 1 / $gAMA;
			}

			// Don't need to apply gamma correction if == default i.e. 2.2
			if ($gamma_correction > 2.15 && $gamma_correction < 2.25) {
				$gamma_correction = 0;
			}

			// NOT supported at present
			//$j = strpos($data,'sRGB');	// sRGB colorspace - overrides gAMA
			//$j = strpos($data,'cHRM');	// Chromaticity and Whitepoint
			// $firsttime added mPDF 6 so when PNG Grayscale with alpha using resrtictcolorspace to CMYK
			// the alpha channel is sent through as secondtime as Indexed and should not be converted to CMYK
			if ($firsttime && ($colspace == 'DeviceRGB' || $colspace == 'Indexed') && ($this->PDFX || $this->restrictColorSpace == 3)) {
				// Convert to CMYK image stream - nominally returned as type='png'
				$info = $this->_convImage($data, $colspace, 'DeviceCMYK', $w, $h, $ppUx, $pngalpha, $gamma_correction, $ct); // mPDF 5.7.2 Gamma correction
				if (($this->PDFA && !$this->PDFAauto) || ($this->PDFX && !$this->PDFXauto)) {
					$this->PDFAXwarnings[] = "PNG image may not use RGB color space - " . $file . " - (Image converted to CMYK. NB This will alter the colour profile of the image.)";
				}
			}
			// $firsttime added mPDF 6 so when PNG Grayscale with alpha using resrtictcolorspace to CMYK
			// the alpha channel is sent through as secondtime as Indexed and should not be converted to CMYK
			elseif ($firsttime && ($colspace == 'DeviceRGB' || $colspace == 'Indexed') && $this->restrictColorSpace == 1) {
				// Convert to Grayscale image stream - nominally returned as type='png'
				$info = $this->_convImage($data, $colspace, 'DeviceGray', $w, $h, $ppUx, $pngalpha, $gamma_correction, $ct); // mPDF 5.7.2 Gamma correction
			} elseif (($this->PDFA || $this->PDFX) && $pngalpha) {

				// Remove alpha channel
				if ($this->restrictColorSpace == 1) { // Grayscale
					$info = $this->_convImage($data, $colspace, 'DeviceGray', $w, $h, $ppUx, $pngalpha, $gamma_correction, $ct); // mPDF 5.7.2 Gamma correction
				} elseif ($this->restrictColorSpace == 3) { // CMYK
					$info = $this->_convImage($data, $colspace, 'DeviceCMYK', $w, $h, $ppUx, $pngalpha, $gamma_correction, $ct); // mPDF 5.7.2 Gamma correction
				} elseif ($this->PDFA) { // RGB
					$info = $this->_convImage($data, $colspace, 'DeviceRGB', $w, $h, $ppUx, $pngalpha, $gamma_correction, $ct); // mPDF 5.7.2 Gamma correction
				}
				if (($this->PDFA && !$this->PDFAauto) || ($this->PDFX && !$this->PDFXauto)) {
					$this->PDFAXwarnings[] = "Transparency (alpha channel) not permitted in PDFA or PDFX files - " . $file . " - (Image converted to one without transparency.)";
				}
			} elseif ($firsttime && ($errpng || $pngalpha || $gamma_correction)) { // mPDF 5.7.2 Gamma correction
				if (function_exists('gd_info')) {
					$gd = gd_info();
				} else {
					$gd = array();
				}
				if (!isset($gd['PNG Support'])) {
					return $this->_imageError($file, $firsttime, 'GD library required for PNG image (' . $errpng . ')');
				}
				$im = imagecreatefromstring($data);

				if (!$im) {
					return $this->_imageError($file, $firsttime, 'Error creating GD image from PNG file (' . $errpng . ')');
				}
				$w = imagesx($im);
				$h = imagesy($im);
				if ($im) {
					$tempfile = _MPDF_TEMP_PATH . '_tempImgPNG' . md5($file) . RAND(1, 10000) . '.png';

					// Alpha channel set (including using tRNS for Paletted images)
					if ($pngalpha) {
						if ($this->PDFA) {
							throw new MpdfException("PDFA1-b does not permit images with alpha channel transparency (" . $file . ").");
						}

						$imgalpha = imagecreate($w, $h);
						// generate gray scale pallete
						for ($c = 0; $c < 256; ++$c) {
							imagecolorallocate($imgalpha, $c, $c, $c);
						}

						// mPDF 6
						if ($colspace == 'Indexed') { // generate Alpha channel values from tRNS
							//Read transparency info
							$transparency = '';
							$p = strpos($data, 'tRNS');
							if ($p) {
								$n = $this->_fourbytes2int(substr($data, ($p - 4), 4));
								$transparency = substr($data, ($p + 4), $n);
								// ord($transparency{$index}) = the alpha value for that index
								// generate alpha channel
								for ($ypx = 0; $ypx < $h; ++$ypx) {
									for ($xpx = 0; $xpx < $w; ++$xpx) {
										$colorindex = imagecolorat($im, $xpx, $ypx);
										if ($colorindex >= $n) {
											$alpha = 255;
										} else {
											$alpha = ord($transparency{$colorindex});
										} // 0-255
										if ($alpha > 0) {
											imagesetpixel($imgalpha, $xpx, $ypx, $alpha);
										}
									}
								}
							}
						} elseif ($ct === 0 || $ct == 2) { // generate Alpha channel values from tRNS
							// Get transparency as array of RGB
							$p = strpos($data, 'tRNS');
							if ($p) {
								$trns = '';
								$n = $this->_fourbytes2int(substr($data, ($p - 4), 4));
								$t = substr($data, ($p + 4), $n);
								if ($colspace == 'DeviceGray') {  // ct===0
									$trns = array($this->_trnsvalue(substr($t, 0, 2), $bpc));
								} else /* $colspace=='DeviceRGB' */ {  // ct==2
									$trns = array();
									$trns[0] = $this->_trnsvalue(substr($t, 0, 2), $bpc);
									$trns[1] = $this->_trnsvalue(substr($t, 2, 2), $bpc);
									$trns[2] = $this->_trnsvalue(substr($t, 4, 2), $bpc);
								}

								// generate alpha channel
								for ($ypx = 0; $ypx < $h; ++$ypx) {
									for ($xpx = 0; $xpx < $w; ++$xpx) {
										$rgb = imagecolorat($im, $xpx, $ypx);
										$r = ($rgb >> 16) & 0xFF;
										$g = ($rgb >> 8) & 0xFF;
										$b = $rgb & 0xFF;
										if ($colspace == 'DeviceGray' && $b == $trns[0]) {
											$alpha = 0;
										} elseif ($r == $trns[0] && $g == $trns[1] && $b == $trns[2]) {
											$alpha = 0;
										}  // ct==2
										else {
											$alpha = 255;
										}
										if ($alpha > 0) {
											imagesetpixel($imgalpha, $xpx, $ypx, $alpha);
										}
									}
								}
							}
						} else {
							// extract alpha channel
							for ($ypx = 0; $ypx < $h; ++$ypx) {
								for ($xpx = 0; $xpx < $w; ++$xpx) {
									$alpha = (imagecolorat($im, $xpx, $ypx) & 0x7F000000) >> 24;
									if ($alpha < 127) {
										imagesetpixel($imgalpha, $xpx, $ypx, (255 - ($alpha * 2)));
									}
								}
							}
						}


						// NB This must happen after the Alpha channel is extracted
						// imagegammacorrect() removes the alpha channel data in $im - (I think this is a bug in PHP)
						if ($gamma_correction) {
							imagegammacorrect($im, $gamma_correction, 2.2);
						} // mPDF 6 Gamma correction
						// create temp alpha file
						$tempfile_alpha = _MPDF_TEMP_PATH . '_tempMskPNG' . md5($file) . RAND(1, 10000) . '.png';
						if (!is_writable(_MPDF_TEMP_PATH)) {  // mPDF 5.7.2
							ob_start();
							$check = @imagepng($imgalpha);
							if (!$check) {
								return $this->_imageError($file, $firsttime, 'Error creating temporary image object whilst using GD library to parse PNG image');
							}
							imagedestroy($imgalpha);
							$this->_tempimg = ob_get_contents();
							$this->_tempimglnk = 'var:_tempimg';
							ob_end_clean();
							// extract image without alpha channel
							$imgplain = imagecreatetruecolor($w, $h);
							imagealphablending($imgplain, false); // mPDF 5.7.2
							imagecopy($imgplain, $im, 0, 0, 0, 0, $w, $h);
							// create temp image file
							$minfo = $this->_getImage($this->_tempimglnk, false);
							if (!$minfo) {
								return $this->_imageError($file, $firsttime, 'Error parsing temporary file image object created with GD library to parse PNG image');
							}
							ob_start();
							$check = @imagepng($imgplain);
							if (!$check) {
								return $this->_imageError($file, $firsttime, 'Error creating temporary image object whilst using GD library to parse PNG image');
							}
							$this->_tempimg = ob_get_contents();
							$this->_tempimglnk = 'var:_tempimg';
							ob_end_clean();
							$info = $this->_getImage($this->_tempimglnk, false);
							if (!$info) {
								return $this->_imageError($file, $firsttime, 'Error parsing temporary file image object created with GD library to parse PNG image');
							}
							imagedestroy($imgplain);
							$imgmask = count($this->images) + 1;
							$minfo['cs'] = 'DeviceGray';
							$minfo['i'] = $imgmask;
							$this->images[$tempfile_alpha] = $minfo;
						} else {
							$check = @imagepng($imgalpha, $tempfile_alpha);
							if (!$check) {
								return $this->_imageError($file, $firsttime, 'Failed to create temporary image file (' . $tempfile_alpha . ') parsing PNG image with alpha channel (' . $errpng . ')');
							}
							imagedestroy($imgalpha);
							// extract image without alpha channel
							$imgplain = imagecreatetruecolor($w, $h);
							imagealphablending($imgplain, false); // mPDF 5.7.2
							imagecopy($imgplain, $im, 0, 0, 0, 0, $w, $h);

							// create temp image file
							$check = @imagepng($imgplain, $tempfile);
							if (!$check) {
								return $this->_imageError($file, $firsttime, 'Failed to create temporary image file (' . $tempfile . ') parsing PNG image with alpha channel (' . $errpng . ')');
							}
							imagedestroy($imgplain);
							// embed mask image
							$minfo = $this->_getImage($tempfile_alpha, false);
							unlink($tempfile_alpha);
							if (!$minfo) {
								return $this->_imageError($file, $firsttime, 'Error parsing temporary file (' . $tempfile_alpha . ') created with GD library to parse PNG image');
							}
							$imgmask = count($this->images) + 1;
							$minfo['cs'] = 'DeviceGray';
							$minfo['i'] = $imgmask;
							$this->images[$tempfile_alpha] = $minfo;
							// embed image, masked with previously embedded mask
							$info = $this->_getImage($tempfile, false);
							unlink($tempfile);
							if (!$info) {
								return $this->_imageError($file, $firsttime, 'Error parsing temporary file (' . $tempfile . ') created with GD library to parse PNG image');
							}
						}
						$info['masked'] = $imgmask;
						if ($ppUx) {
							$info['set-dpi'] = $ppUx;
						}
						$info['type'] = 'png';
						if ($firsttime) {
							$info['i'] = count($this->images) + 1;
							$info['interpolation'] = $interpolation; // mPDF 6
							$this->images[$file] = $info;
						}

						return $info;
					} else {  // No alpha/transparency set (but cannot read directly because e.g. bit-depth != 8, interlaced etc)
						// ICC profile
						$icc = false;
						$p = strpos($data, 'iCCP');
						if ($p && $colspace == "Indexed") { // Cannot have ICC profile and Indexed together
							$p += 4;
							$n = $this->_fourbytes2int(substr($data, ($p - 8), 4));
							$nullsep = strpos(substr($data, $p, 80), chr(0));
							$icc = substr($data, ($p + $nullsep + 2), ($n - ($nullsep + 2)));
							$icc = @gzuncompress($icc); // Ignored if fails
							if ($icc) {
								if (substr($icc, 36, 4) != 'acsp') {
									$icc = false;
								} // invalid ICC profile
								else {
									$input = substr($icc, 16, 4);
									$output = substr($icc, 20, 4);
									// Ignore Color profiles for conversion to other colorspaces e.g. CMYK/Lab
									if ($input != 'RGB ' || $output != 'XYZ ') {
										$icc = false;
									}
								}
							}
							// Convert to RGB colorspace so can use ICC Profile
							if ($icc) {
								imagepalettetotruecolor($im);
								$colspace = 'DeviceRGB';
								$channels = 3;
							}
						}

						if ($gamma_correction) {
							imagegammacorrect($im, $gamma_correction, 2.2);
						} // mPDF 6 Gamma correction
						imagealphablending($im, false);
						imagesavealpha($im, false);
						imageinterlace($im, false);
						if (!is_writable(_MPDF_TEMP_PATH)) {  // mPDF 5.7.2
							ob_start();
							$check = @imagepng($im);
							if (!$check) {
								return $this->_imageError($file, $firsttime, 'Error creating temporary image object whilst using GD library to parse PNG image');
							}
							$this->_tempimg = ob_get_contents();
							$this->_tempimglnk = 'var:_tempimg';
							ob_end_clean();
							$info = $this->_getImage($this->_tempimglnk, false);
							if (!$info) {
								return $this->_imageError($file, $firsttime, 'Error parsing temporary file image object created with GD library to parse PNG image');
							}
							imagedestroy($im);
						} else {
							$check = @imagepng($im, $tempfile);
							if (!$check) {
								return $this->_imageError($file, $firsttime, 'Failed to create temporary image file (' . $tempfile . ') parsing PNG image (' . $errpng . ')');
							}
							imagedestroy($im);
							$info = $this->_getImage($tempfile, false);
							unlink($tempfile);
							if (!$info) {
								return $this->_imageError($file, $firsttime, 'Error parsing temporary file (' . $tempfile . ') created with GD library to parse PNG image');
							}
						}
						if ($ppUx) {
							$info['set-dpi'] = $ppUx;
						}
						$info['type'] = 'png';
						if ($firsttime) {
							$info['i'] = count($this->images) + 1;
							$info['interpolation'] = $interpolation; // mPDF 6
							if ($icc) {
								$info['ch'] = $channels;
								$info['icc'] = $icc;
							}
							$this->images[$file] = $info;
						}
						return $info;
					}
				}
			} else { // PNG image with no need to convert alph channels, bpc <> 8 etc.
				$parms = '/DecodeParms <</Predictor 15 /Colors ' . $channels . ' /BitsPerComponent ' . $bpc . ' /Columns ' . $w . '>>';
				//Scan chunks looking for palette, transparency and image data
				$pal = '';
				$trns = '';
				$pngdata = '';
				$icc = false;
				$p = 33;
				do {
					$n = $this->_fourbytes2int(substr($data, $p, 4));
					$p += 4;
					$type = substr($data, $p, 4);
					$p += 4;
					if ($type == 'PLTE') {
						//Read palette
						$pal = substr($data, $p, $n);
						$p += $n;
						$p += 4;
					} elseif ($type == 'tRNS') {
						//Read transparency info
						$t = substr($data, $p, $n);
						$p += $n;
						if ($ct == 0)
							$trns = array(ord(substr($t, 1, 1)));
						elseif ($ct == 2)
							$trns = array(ord(substr($t, 1, 1)), ord(substr($t, 3, 1)), ord(substr($t, 5, 1)));
						else {
							$pos = strpos($t, chr(0));
							if (is_int($pos))
								$trns = array($pos);
						}
						$p += 4;
					}
					elseif ($type == 'IDAT') {
						$pngdata.=substr($data, $p, $n);
						$p += $n;
						$p += 4;
					} elseif ($type == 'iCCP') {
						$nullsep = strpos(substr($data, $p, 80), chr(0));
						$icc = substr($data, ($p + $nullsep + 2), ($n - ($nullsep + 2)));
						$icc = @gzuncompress($icc); // Ignored if fails
						if ($icc) {
							if (substr($icc, 36, 4) != 'acsp') {
								$icc = false;
							} // invalid ICC profile
							else {
								$input = substr($icc, 16, 4);
								$output = substr($icc, 20, 4);
								// Ignore Color profiles for conversion to other colorspaces e.g. CMYK/Lab
								if ($input != 'RGB ' || $output != 'XYZ ') {
									$icc = false;
								}
							}
						}
						$p += $n;
						$p += 4;
					} elseif ($type == 'IEND') {
						break;
					} elseif (preg_match('/[a-zA-Z]{4}/', $type)) {
						$p += $n + 4;
					} else {
						return $this->_imageError($file, $firsttime, 'Error parsing PNG image data');
					}
				} while ($n);
				if (!$pngdata) {
					return $this->_imageError($file, $firsttime, 'Error parsing PNG image data - no IDAT data found');
				}
				if ($colspace == 'Indexed' && empty($pal)) {
					return $this->_imageError($file, $firsttime, 'Error parsing PNG image data - missing colour palette');
				}

				if ($colspace == 'Indexed' && $icc) {
					$icc = false;
				} // mPDF 6 cannot have ICC profile and Indexed in a PDF document as both use the colorspace tag.

				$info = array('w' => $w, 'h' => $h, 'cs' => $colspace, 'bpc' => $bpc, 'f' => 'FlateDecode', 'parms' => $parms, 'pal' => $pal, 'trns' => $trns, 'data' => $pngdata, 'ch' => $channels, 'icc' => $icc);
				$info['type'] = 'png';
				if ($ppUx) {
					$info['set-dpi'] = $ppUx;
				}
			}

			if (!$info) {
				return $this->_imageError($file, $firsttime, 'Error parsing or converting PNG image');
			}

			if ($firsttime) {
				$info['i'] = count($this->images) + 1;
				$info['interpolation'] = $interpolation; // mPDF 6
				$this->images[$file] = $info;
			}
			return $info;
		}

		// GIF
		elseif ($type == 'gif') {
			if (function_exists('gd_info')) {
				$gd = gd_info();
			} else {
				$gd = array();
			}
			if (isset($gd['GIF Read Support']) && $gd['GIF Read Support']) {
				$im = @imagecreatefromstring($data);
				if ($im) {
					$tempfile = _MPDF_TEMP_PATH . '_tempImgPNG' . md5($file) . RAND(1, 10000) . '.png';
					imagealphablending($im, false);
					imagesavealpha($im, false);
					imageinterlace($im, false);
					if (!is_writable($tempfile)) {
						ob_start();
						$check = @imagepng($im);
						if (!$check) {
							return $this->_imageError($file, $firsttime, 'Error creating temporary image object whilst using GD library to parse GIF image');
						}
						$this->_tempimg = ob_get_contents();
						$this->_tempimglnk = 'var:_tempimg';
						ob_end_clean();
						$info = $this->_getImage($this->_tempimglnk, false);
						if (!$info) {
							return $this->_imageError($file, $firsttime, 'Error parsing temporary file image object created with GD library to parse GIF image');
						}
						imagedestroy($im);
					} else {
						$check = @imagepng($im, $tempfile);
						if (!$check) {
							return $this->_imageError($file, $firsttime, 'Error creating temporary file (' . $tempfile . ') whilst using GD library to parse GIF image');
						}
						$info = $this->_getImage($tempfile, false);
						if (!$info) {
							return $this->_imageError($file, $firsttime, 'Error parsing temporary file (' . $tempfile . ') created with GD library to parse GIF image');
						}
						imagedestroy($im);
						unlink($tempfile);
					}
					$info['type'] = 'gif';
					if ($firsttime) {
						$info['i'] = count($this->images) + 1;
						$info['interpolation'] = $interpolation; // mPDF 6
						$this->images[$file] = $info;
					}
					return $info;
				} else {
					return $this->_imageError($file, $firsttime, 'Error creating GD image file from GIF image');
				}
			}

			if (!class_exists('gif', false)) {
				include_once(_MPDF_PATH . 'classes/gif.php');
			}
			$gif = new CGIF();

			$h = 0;
			$w = 0;
			$gif->loadFile($data, 0);

			if (isset($gif->m_img->m_gih->m_bLocalClr) && $gif->m_img->m_gih->m_bLocalClr) {
				$nColors = $gif->m_img->m_gih->m_nTableSize;
				$pal = $gif->m_img->m_gih->m_colorTable->toString();
				if ((isset($bgColor)) and $bgColor != -1) { // mPDF 5.7.3
					$bgColor = $gif->m_img->m_gih->m_colorTable->colorIndex($bgColor);
				}
				$colspace = 'Indexed';
			} elseif (isset($gif->m_gfh->m_bGlobalClr) && $gif->m_gfh->m_bGlobalClr) {
				$nColors = $gif->m_gfh->m_nTableSize;
				$pal = $gif->m_gfh->m_colorTable->toString();
				if ((isset($bgColor)) and $bgColor != -1) {
					$bgColor = $gif->m_gfh->m_colorTable->colorIndex($bgColor);
				}
				$colspace = 'Indexed';
			} else {
				$nColors = 0;
				$bgColor = -1;
				$colspace = 'DeviceGray';
				$pal = '';
			}

			$trns = '';
			if (isset($gif->m_img->m_bTrans) && $gif->m_img->m_bTrans && ($nColors > 0)) {
				$trns = array($gif->m_img->m_nTrans);
			}
			$gifdata = $gif->m_img->m_data;
			$w = $gif->m_gfh->m_nWidth;
			$h = $gif->m_gfh->m_nHeight;
			$gif->ClearData();

			if ($colspace == 'Indexed' and empty($pal)) {
				return $this->_imageError($file, $firsttime, 'Error parsing GIF image - missing colour palette');
			}
			if ($this->compress) {
				$gifdata = gzcompress($gifdata);
				$info = array('w' => $w, 'h' => $h, 'cs' => $colspace, 'bpc' => 8, 'f' => 'FlateDecode', 'pal' => $pal, 'trns' => $trns, 'data' => $gifdata);
			} else {
				$info = array('w' => $w, 'h' => $h, 'cs' => $colspace, 'bpc' => 8, 'pal' => $pal, 'trns' => $trns, 'data' => $gifdata);
			}
			$info['type'] = 'gif';
			if ($firsttime) {
				$info['i'] = count($this->images) + 1;
				$info['interpolation'] = $interpolation; // mPDF 6
				$this->images[$file] = $info;
			}
			return $info;
		}

		/* -- IMAGES-BMP -- */
		// BMP (Windows Bitmap)
		elseif ($type == 'bmp') {
			if (!class_exists('bmp', false)) {
				include(_MPDF_PATH . 'classes/bmp.php');
			}
			if (empty($this->bmp)) {
				$this->bmp = new bmp($this);
			}
			$info = $this->bmp->_getBMPimage($data, $file);
			if (isset($info['error'])) {
				return $this->_imageError($file, $firsttime, $info['error']);
			}
			if ($firsttime) {
				$info['i'] = count($this->images) + 1;
				$info['interpolation'] = $interpolation; // mPDF 6
				$this->images[$file] = $info;
			}
			return $info;
		}
		/* -- END IMAGES-BMP -- */
		/* -- IMAGES-WMF -- */
		// WMF
		elseif ($type == 'wmf') {
			if (!class_exists('wmf', false)) {
				include(_MPDF_PATH . 'classes/wmf.php');
			}
			if (empty($this->wmf)) {
				$this->wmf = new wmf($this);
			}
			$wmfres = $this->wmf->_getWMFimage($data);
			if ($wmfres[0] == 0) {
				if ($wmfres[1]) {
					return $this->_imageError($file, $firsttime, $wmfres[1]);
				}
				return $this->_imageError($file, $firsttime, 'Error parsing WMF image');
			}
			$info = array('x' => $wmfres[2][0], 'y' => $wmfres[2][1], 'w' => $wmfres[3][0], 'h' => $wmfres[3][1], 'data' => $wmfres[1]);
			$info['i'] = count($this->formobjects) + 1;
			$info['type'] = 'wmf';
			$this->formobjects[$file] = $info;
			return $info;
		}
		/* -- END IMAGES-WMF -- */

		// UNKNOWN TYPE - try GD imagecreatefromstring
		else {
			if (function_exists('gd_info')) {
				$gd = gd_info();
			} else {
				$gd = array();
			}
			if (isset($gd['PNG Support']) && $gd['PNG Support']) {
				$im = @imagecreatefromstring($data);
				if (!$im) {
					return $this->_imageError($file, $firsttime, 'Error parsing image file - image type not recognised, and not supported by GD imagecreate');
				}
				$tempfile = _MPDF_TEMP_PATH . '_tempImgPNG' . md5($file) . RAND(1, 10000) . '.png';
				imagealphablending($im, false);
				imagesavealpha($im, false);
				imageinterlace($im, false);
				$check = @imagepng($im, $tempfile);
				if (!$check) {
					return $this->_imageError($file, $firsttime, 'Error creating temporary file (' . $tempfile . ') whilst using GD library to parse unknown image type');
				}
				$info = $this->_getImage($tempfile, false);
				imagedestroy($im);
				unlink($tempfile);
				if (!$info) {
					return $this->_imageError($file, $firsttime, 'Error parsing temporary file (' . $tempfile . ') created with GD library to parse unknown image type');
				}
				$info['type'] = 'png';
				if ($firsttime) {
					$info['i'] = count($this->images) + 1;
					$info['interpolation'] = $interpolation; // mPDF 6
					$this->images[$file] = $info;
				}
				return $info;
			}
		}

		return $this->_imageError($file, $firsttime, 'Error parsing image file - image type not recognised');
	}

	//==============================================================
	function _convImage(&$data, $colspace, $targetcs, $w, $h, $dpi, $mask, $gamma_correction = false, $pngcolortype = false)
	{ // mPDF 5.7.2 Gamma correction
		if ($this->PDFA || $this->PDFX) {
			$mask = false;
		}
		$im = @imagecreatefromstring($data);
		$info = array();
		$bpc = ord(substr($data, 24, 1));
		if ($im) {

			$imgdata = '';
			$mimgdata = '';
			$minfo = array();

			// mPDF 6 Gamma correction
			// Need to extract alpha channel info before imagegammacorrect (which loses the data)
			if ($mask) { // i.e. $pngalpha for PNG
				// mPDF 6
				if ($colspace == 'Indexed') { // generate Alpha channel values from tRNS - only from PNG
					//Read transparency info
					$transparency = '';
					$p = strpos($data, 'tRNS');
					if ($p) {
						$n = $this->_fourbytes2int(substr($data, ($p - 4), 4));
						$transparency = substr($data, ($p + 4), $n);
						// ord($transparency{$index}) = the alpha value for that index
						// generate alpha channel
						for ($ypx = 0; $ypx < $h; ++$ypx) {
							for ($xpx = 0; $xpx < $w; ++$xpx) {
								$colorindex = imagecolorat($im, $xpx, $ypx);
								if ($colorindex >= $n) {
									$alpha = 255;
								} else {
									$alpha = ord($transparency{$colorindex});
								} // 0-255
								$mimgdata .= chr($alpha);
							}
						}
					}
				} elseif ($pngcolortype === 0 || $pngcolortype == 2) { // generate Alpha channel values from tRNS
					// Get transparency as array of RGB
					$p = strpos($data, 'tRNS');
					if ($p) {
						$trns = '';
						$n = $this->_fourbytes2int(substr($data, ($p - 4), 4));
						$t = substr($data, ($p + 4), $n);
						if ($colspace == 'DeviceGray') {  // ct===0
							$trns = array($this->_trnsvalue(substr($t, 0, 2), $bpc));
						} else /* $colspace=='DeviceRGB' */ {  // ct==2
							$trns = array();
							$trns[0] = $this->_trnsvalue(substr($t, 0, 2), $bpc);
							$trns[1] = $this->_trnsvalue(substr($t, 2, 2), $bpc);
							$trns[2] = $this->_trnsvalue(substr($t, 4, 2), $bpc);
						}

						// generate alpha channel
						for ($ypx = 0; $ypx < $h; ++$ypx) {
							for ($xpx = 0; $xpx < $w; ++$xpx) {
								$rgb = imagecolorat($im, $xpx, $ypx);
								$r = ($rgb >> 16) & 0xFF;
								$g = ($rgb >> 8) & 0xFF;
								$b = $rgb & 0xFF;
								if ($colspace == 'DeviceGray' && $b == $trns[0]) {
									$alpha = 0;
								} elseif ($r == $trns[0] && $g == $trns[1] && $b == $trns[2]) {
									$alpha = 0;
								}  // ct==2
								else {
									$alpha = 255;
								}
								$mimgdata .= chr($alpha);
							}
						}
					}
				} else {
					for ($i = 0; $i < $h; $i++) {
						for ($j = 0; $j < $w; $j++) {
							$rgb = imagecolorat($im, $j, $i);
							$alpha = ($rgb & 0x7F000000) >> 24;
							if ($alpha < 127) {
								$mimgdata .= chr(255 - ($alpha * 2));
							} else {
								$mimgdata .= chr(0);
							}
						}
					}
				}
			}

			if ($gamma_correction) {
				imagegammacorrect($im, $gamma_correction, 2.2);
			} // mPDF 6 Gamma correction
			//Read transparency info
			$trns = array();
			$trnsrgb = false;
			if (!$this->PDFA && !$this->PDFX && !$mask) {  // mPDF 6 added NOT mask
				$p = strpos($data, 'tRNS');
				if ($p) {
					$n = $this->_fourbytes2int(substr($data, ($p - 4), 4));
					$t = substr($data, ($p + 4), $n);
					if ($colspace == 'DeviceGray') {  // ct===0
						$trns = array($this->_trnsvalue(substr($t, 0, 2), $bpc));
					} elseif ($colspace == 'DeviceRGB') {  // ct==2
						$trns[0] = $this->_trnsvalue(substr($t, 0, 2), $bpc);
						$trns[1] = $this->_trnsvalue(substr($t, 2, 2), $bpc);
						$trns[2] = $this->_trnsvalue(substr($t, 4, 2), $bpc);
						$trnsrgb = $trns;
						if ($targetcs == 'DeviceCMYK') {
							$col = $this->rgb2cmyk(array(3, $trns[0], $trns[1], $trns[2]));
							$c1 = intval($col[1] * 2.55);
							$c2 = intval($col[2] * 2.55);
							$c3 = intval($col[3] * 2.55);
							$c4 = intval($col[4] * 2.55);
							$trns = array($c1, $c2, $c3, $c4);
						} elseif ($targetcs == 'DeviceGray') {
							$c = intval(($trns[0] * .21) + ($trns[1] * .71) + ($trns[2] * .07));
							$trns = array($c);
						}
					} else { // Indexed
						$pos = strpos($t, chr(0));
						if (is_int($pos)) {
							$pal = imagecolorsforindex($im, $pos);
							$r = $pal['red'];
							$g = $pal['green'];
							$b = $pal['blue'];
							$trns = array($r, $g, $b); // ****
							$trnsrgb = $trns;
							if ($targetcs == 'DeviceCMYK') {
								$col = $this->rgb2cmyk(array(3, $r, $g, $b));
								$c1 = intval($col[1] * 2.55);
								$c2 = intval($col[2] * 2.55);
								$c3 = intval($col[3] * 2.55);
								$c4 = intval($col[4] * 2.55);
								$trns = array($c1, $c2, $c3, $c4);
							} elseif ($targetcs == 'DeviceGray') {
								$c = intval(($r * .21) + ($g * .71) + ($b * .07));
								$trns = array($c);
							}
						}
					}
				}
			}
			for ($i = 0; $i < $h; $i++) {
				for ($j = 0; $j < $w; $j++) {
					$rgb = imagecolorat($im, $j, $i);
					$r = ($rgb >> 16) & 0xFF;
					$g = ($rgb >> 8) & 0xFF;
					$b = $rgb & 0xFF;
					if ($colspace == 'Indexed') {
						$pal = imagecolorsforindex($im, $rgb);
						$r = $pal['red'];
						$g = $pal['green'];
						$b = $pal['blue'];
					}

					if ($targetcs == 'DeviceCMYK') {
						$col = $this->rgb2cmyk(array(3, $r, $g, $b));
						$c1 = intval($col[1] * 2.55);
						$c2 = intval($col[2] * 2.55);
						$c3 = intval($col[3] * 2.55);
						$c4 = intval($col[4] * 2.55);
						if ($trnsrgb) {
							// original pixel was not set as transparent but processed color does match
							if ($trnsrgb != array($r, $g, $b) && $trns == array($c1, $c2, $c3, $c4)) {
								if ($c4 == 0) {
									$c4 = 1;
								} else {
									$c4--;
								}
							}
						}
						$imgdata .= chr($c1) . chr($c2) . chr($c3) . chr($c4);
					} elseif ($targetcs == 'DeviceGray') {
						$c = intval(($r * .21) + ($g * .71) + ($b * .07));
						if ($trnsrgb) {
							// original pixel was not set as transparent but processed color does match
							if ($trnsrgb != array($r, $g, $b) && $trns == array($c)) {
								if ($c == 0) {
									$c = 1;
								} else {
									$c--;
								}
							}
						}
						$imgdata .= chr($c);
					} elseif ($targetcs == 'DeviceRGB') {
						$imgdata .= chr($r) . chr($g) . chr($b);
					}
				}
			}

			if ($targetcs == 'DeviceGray') {
				$ncols = 1;
			} elseif ($targetcs == 'DeviceRGB') {
				$ncols = 3;
			} elseif ($targetcs == 'DeviceCMYK') {
				$ncols = 4;
			}

			$imgdata = gzcompress($imgdata);
			$info = array('w' => $w, 'h' => $h, 'cs' => $targetcs, 'bpc' => 8, 'f' => 'FlateDecode', 'data' => $imgdata, 'type' => 'png',
				'parms' => '/DecodeParms <</Colors ' . $ncols . ' /BitsPerComponent 8 /Columns ' . $w . '>>');
			if ($dpi) {
				$info['set-dpi'] = $dpi;
			}
			if ($mask) {
				$mimgdata = gzcompress($mimgdata);
				$minfo = array('w' => $w, 'h' => $h, 'cs' => 'DeviceGray', 'bpc' => 8, 'f' => 'FlateDecode', 'data' => $mimgdata, 'type' => 'png',
					'parms' => '/DecodeParms <</Colors ' . $ncols . ' /BitsPerComponent 8 /Columns ' . $w . '>>');
				if ($dpi) {
					$minfo['set-dpi'] = $dpi;
				}
				$tempfile = '_tempImgPNG' . md5($data) . RAND(1, 10000) . '.png';
				$imgmask = count($this->images) + 1;
				$minfo['i'] = $imgmask;
				$this->images[$tempfile] = $minfo;
				$info['masked'] = $imgmask;
			} elseif ($trns) {
				$info['trns'] = $trns;
			}
			imagedestroy($im);
		}
		return $info;
	}

	function _trnsvalue($s, $bpc)
	{
		// Corrects 2-byte integer to 8-bit depth value
		// If original image is bpc != 8, tRNS will be in this bpc
		// $im from imagecreatefromstring will always be in bpc=8
		// So why do we only need to correct 16-bit tRNS and NOT 2 or 4-bit???
		$n = $this->_twobytes2int($s);
		if ($bpc == 16) {
			$n = ($n >> 8);
		}
		//elseif ($bpc==4) { $n = ($n << 2); }
		//elseif ($bpc==2) { $n = ($n << 4); }
		return $n;
	}

	function _fourbytes2int($s)
	{
		//Read a 4-byte integer from string
		return (ord($s[0]) << 24) + (ord($s[1]) << 16) + (ord($s[2]) << 8) + ord($s[3]);
	}

	function _twobytes2int($s)
	{ // equivalent to _get_ushort
		//Read a 2-byte integer from string
		return (ord(substr($s, 0, 1)) << 8) + ord(substr($s, 1, 1));
	}

	function _jpgHeaderFromString(&$data)
	{
		$p = 4;
		$p += $this->_twobytes2int(substr($data, $p, 2)); // Length of initial marker block
		$marker = substr($data, $p, 2);
		while ($marker != chr(255) . chr(192) && $marker != chr(255) . chr(194) && $p < strlen($data)) {
			// Start of frame marker (FFC0) or (FFC2) mPDF 4.4.004
			$p += ($this->_twobytes2int(substr($data, $p + 2, 2))) + 2; // Length of marker block
			$marker = substr($data, $p, 2);
		}
		if ($marker != chr(255) . chr(192) && $marker != chr(255) . chr(194)) {
			return false;
		}
		return substr($data, $p + 2, 10);
	}

	function _jpgDataFromHeader($hdr)
	{
		$bpc = ord(substr($hdr, 2, 1));
		if (!$bpc) {
			$bpc = 8;
		}
		$h = $this->_twobytes2int(substr($hdr, 3, 2));
		$w = $this->_twobytes2int(substr($hdr, 5, 2));
		$channels = ord(substr($hdr, 7, 1));
		if ($channels == 3) {
			$colspace = 'DeviceRGB';
		} elseif ($channels == 4) {
			$colspace = 'DeviceCMYK';
		} else {
			$colspace = 'DeviceGray';
		}
		return array($w, $h, $colspace, $bpc, $channels);
	}

	function file_get_contents_by_curl($url, &$data)
	{
		$timeout = 5;
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:13.0) Gecko/20100101 Firefox/13.0.1'); // mPDF 5.7.4
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_NOBODY, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
		$data = curl_exec($ch);
		curl_close($ch);
	}

	function file_get_contents_by_socket($url, &$data)
	{
		// mPDF 5.7.3
		$timeout = 1;
		$p = parse_url($url);
		$file = $p['path'];
		if ($p['scheme'] == 'https') {
			$prefix = 'ssl://';
			$port = ($p['port'] ? $p['port'] : 443);
		} else {
			$prefix = '';
			$port = ($p['port'] ? $p['port'] : 80);
		}
		if ($p['query']) {
			$file .= '?' . $p['query'];
		}
		if (!($fh = @fsockopen($prefix . $p['host'], $port, $errno, $errstr, $timeout))) {
			return false;
		}

		$getstring = "GET " . $file . " HTTP/1.0 \r\n" .
			"Host: " . $p['host'] . " \r\n" .
			"Connection: close\r\n\r\n";
		fwrite($fh, $getstring);
		// Get rid of HTTP header
		$s = fgets($fh, 1024);
		if (!$s) {
			return false;
		}
		$httpheader .= $s;
		while (!feof($fh)) {
			$s = fgets($fh, 1024);
			if ($s == "\r\n") {
				break;
			}
		}
		$data = '';
		while (!feof($fh)) {
			$data .= fgets($fh, 1024);
		}
		fclose($fh);
	}

	//==============================================================

	function _imageTypeFromString(&$data)
	{
		$type = '';
		if (substr($data, 6, 4) == 'JFIF' || substr($data, 6, 4) == 'Exif' || substr($data, 0, 2) == chr(255) . chr(216)) { // 0xFF 0xD8	// mpDF 5.7.2
			$type = 'jpeg';
		} elseif (substr($data, 0, 6) == "GIF87a" || substr($data, 0, 6) == "GIF89a") {
			$type = 'gif';
		} elseif (substr($data, 0, 8) == chr(137) . 'PNG' . chr(13) . chr(10) . chr(26) . chr(10)) {
			$type = 'png';
		}
		/* -- IMAGES-WMF -- */ elseif (substr($data, 0, 4) == chr(215) . chr(205) . chr(198) . chr(154)) {
			$type = 'wmf';
		}
		/* -- END IMAGES-WMF -- */ elseif (preg_match('/<svg.*<\/svg>/is', $data)) {
			$type = 'svg';
		}
		// BMP images
		elseif (substr($data, 0, 2) == "BM") {
			$type = 'bmp';
		}
		return $type;
	}

	//==============================================================
	// Moved outside WMF as also needed for SVG
	function _putformobjects()
	{
		reset($this->formobjects);
		while (list($file, $info) = each($this->formobjects)) {
			$this->_newobj();
			$this->formobjects[$file]['n'] = $this->n;
			$this->_out('<</Type /XObject');
			$this->_out('/Subtype /Form');
			$this->_out('/Group ' . ($this->n + 1) . ' 0 R');
			$this->_out('/BBox [' . $info['x'] . ' ' . $info['y'] . ' ' . ($info['w'] + $info['x']) . ' ' . ($info['h'] + $info['y']) . ']');
			if ($this->compress)
				$this->_out('/Filter /FlateDecode');
			$data = ($this->compress) ? gzcompress($info['data']) : $info['data'];
			$this->_out('/Length ' . strlen($data) . '>>');
			$this->_putstream($data);
			unset($this->formobjects[$file]['data']);
			$this->_out('endobj');
			// Required for SVG transparency (opacity) to work
			$this->_newobj();
			$this->_out('<</Type /Group');
			$this->_out('/S /Transparency');
			$this->_out('>>');
			$this->_out('endobj');
		}
	}

	function _freadint($f)
	{
		//Read a 4-byte integer from file
		$i = ord(fread($f, 1)) << 24;
		$i+=ord(fread($f, 1)) << 16;
		$i+=ord(fread($f, 1)) << 8;
		$i+=ord(fread($f, 1));
		return $i;
	}

	function _UTF16BEtextstring($s)
	{
		$s = $this->UTF8ToUTF16BE($s, true);
		/* -- ENCRYPTION -- */
		if ($this->encrypted) {
			$s = $this->_RC4($this->_objectkey($this->_current_obj_id), $s);
		}
		/* -- END ENCRYPTION -- */
		return '(' . $this->_escape($s) . ')';
	}

	function _textstring($s)
	{
		/* -- ENCRYPTION -- */
		if ($this->encrypted) {
			$s = $this->_RC4($this->_objectkey($this->_current_obj_id), $s);
		}
		/* -- END ENCRYPTION -- */
		return '(' . $this->_escape($s) . ')';
	}

	function _escape($s)
	{
		// the chr(13) substitution fixes the Bugs item #1421290.
		return strtr($s, array(')' => '\\)', '(' => '\\(', '\\' => '\\\\', chr(13) => '\r'));
	}

	function _putstream($s)
	{
		/* -- ENCRYPTION -- */
		if ($this->encrypted) {
			$s = $this->_RC4($this->_objectkey($this->_current_obj_id), $s);
		}
		/* -- END ENCRYPTION -- */
		$this->_out('stream');
		$this->_out($s);
		$this->_out('endstream');
	}

	function _out($s, $ln = true)
	{
		if ($this->state == 2) {
			if ($this->bufferoutput) {
				$this->headerbuffer.= $s . "\n";
			}
			/* -- COLUMNS -- */ elseif (($this->ColActive) && !$this->processingHeader && !$this->processingFooter) {
				// Captures everything in buffer for columns; Almost everything is sent from fn. Cell() except:
				// Images sent from Image() or
				// later sent as _out($textto) in printbuffer
				// Line()
				if (preg_match('/q \d+\.\d\d+ 0 0 (\d+\.\d\d+) \d+\.\d\d+ \d+\.\d\d+ cm \/(I|FO)\d+ Do Q/', $s, $m)) { // Image data
					$h = ($m[1] / _MPDFK);
					// Update/overwrite the lowest bottom of printing y value for a column
					$this->ColDetails[$this->CurrCol]['bottom_margin'] = $this->y + $h;
				}
				/* -- TABLES -- */ elseif (preg_match('/\d+\.\d\d+ \d+\.\d\d+ \d+\.\d\d+ ([\-]{0,1}\d+\.\d\d+) re/', $s, $m) && $this->tableLevel > 0) { // Rect in table
					$h = ($m[1] / _MPDFK);
					// Update/overwrite the lowest bottom of printing y value for a column
					$this->ColDetails[$this->CurrCol]['bottom_margin'] = max($this->ColDetails[$this->CurrCol]['bottom_margin'], ($this->y + $h));
				}
				/* -- END TABLES -- */ else {  // Td Text Set in Cell()
					if (isset($this->ColDetails[$this->CurrCol]['bottom_margin'])) {
						$h = $this->ColDetails[$this->CurrCol]['bottom_margin'] - $this->y;
					} else {
						$h = 0;
					}
				}
				if ($h < 0) {
					$h = -$h;
				}
				$this->columnbuffer[] = array(
					's' => $s, // Text string to output
					'col' => $this->CurrCol, // Column when printed
					'x' => $this->x, // x when printed
					'y' => $this->y, // this->y when printed (after column break)
					'h' => $h        // actual y at bottom when printed = y+h
				);
			}
			/* -- END COLUMNS -- */
			/* -- TABLES -- */ elseif ($this->table_rotate && !$this->processingHeader && !$this->processingFooter) {
				// Captures eveything in buffer for rotated tables;
				$this->tablebuffer .= $s . "\n";
			}
			/* -- END TABLES -- */ elseif ($this->kwt && !$this->processingHeader && !$this->processingFooter) {
				// Captures eveything in buffer for keep-with-table (h1-6);
				$this->kwt_buffer[] = array(
					's' => $s, // Text string to output
					'x' => $this->x, // x when printed
					'y' => $this->y, // y when printed
				);
			} elseif (($this->keep_block_together) && !$this->processingHeader && !$this->processingFooter) {
				// do nothing
			} else {
				$this->pages[$this->page] .= $s . ($ln == true ? "\n" : '');
			}
		} else {
			$this->buffer .= $s . ($ln == true ? "\n" : '');
		}
	}

	/* -- WATERMARK -- */

	// add a watermark
	function watermark($texte, $angle = 45, $fontsize = 96, $alpha = 0.2)
	{
		if ($this->PDFA || $this->PDFX) {
			throw new MpdfException('PDFA and PDFX do not permit transparency, so mPDF does not allow Watermarks!');
		}
		if (!$this->watermark_font) {
			$this->watermark_font = $this->default_font;
		}
		$this->SetFont($this->watermark_font, "B", $fontsize, false); // Don't output
		$texte = $this->purify_utf8_text($texte);
		if ($this->text_input_as_HTML) {
			$texte = $this->all_entities_to_utf8($texte);
		}
		if ($this->usingCoreFont) {
			$texte = mb_convert_encoding($texte, $this->mb_enc, 'UTF-8');
		}

		// DIRECTIONALITY
		if (preg_match("/([" . $this->pregRTLchars . "])/u", $texte)) {
			$this->biDirectional = true;
		} // *OTL*

		$textvar = 0;
		$save_OTLtags = $this->OTLtags;
		$this->OTLtags = array();
		if ($this->useKerning) {
			if ($this->CurrentFont['haskernGPOS']) {
				$this->OTLtags['Plus'] .= ' kern';
			} else {
				$textvar = ($textvar | FC_KERNING);
			}
		}

		/* -- OTL -- */
		// Use OTL OpenType Table Layout - GSUB & GPOS
		if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL']) {
			$texte = $this->otl->applyOTL($texte, $this->CurrentFont['useOTL']);
			$OTLdata = $this->otl->OTLdata;
		}
		/* -- END OTL -- */
		$this->OTLtags = $save_OTLtags;

		$this->magic_reverse_dir($texte, $this->directionality, $OTLdata);

		$this->SetAlpha($alpha);

		$this->SetTColor($this->ConvertColor(0));
		$szfont = $fontsize;
		$loop = 0;
		$maxlen = (min($this->w, $this->h) ); // sets max length of text as 7/8 width/height of page
		while ($loop == 0) {
			$this->SetFont($this->watermark_font, "B", $szfont, false); // Don't output
			$offset = ((sin(deg2rad($angle))) * ($szfont / _MPDFK));

			$strlen = $this->GetStringWidth($texte, true, $OTLdata, $textvar);
			if ($strlen > $maxlen - $offset)
				$szfont --;
			else
				$loop ++;
		}

		$this->SetFont($this->watermark_font, "B", $szfont - 0.1, true, true); // Output The -0.1 is because SetFont above is not written to PDF
		// Repeating it will not output anything as mPDF thinks it is set
		$adj = ((cos(deg2rad($angle))) * ($strlen / 2));
		$opp = ((sin(deg2rad($angle))) * ($strlen / 2));
		$wx = ($this->w / 2) - $adj + $offset / 3;
		$wy = ($this->h / 2) + $opp;
		$this->Rotate($angle, $wx, $wy);
		$this->Text($wx, $wy, $texte, $OTLdata, $textvar);
		$this->Rotate(0);
		$this->SetTColor($this->ConvertColor(0));

		$this->SetAlpha(1);
	}

	function watermarkImg($src, $alpha = 0.2)
	{
		if ($this->PDFA || $this->PDFX) {
			throw new MpdfException('PDFA and PDFX do not permit transparency, so mPDF does not allow Watermarks!');
		}
		if ($this->watermarkImgBehind) {
			$this->watermarkImgAlpha = $this->SetAlpha($alpha, 'Normal', true);
		} else {
			$this->SetAlpha($alpha, $this->watermarkImgAlphaBlend);
		}
		$this->Image($src, 0, 0, 0, 0, '', '', true, true, true);
		if (!$this->watermarkImgBehind) {
			$this->SetAlpha(1);
		}
	}

	/* -- END WATERMARK -- */

	function Rotate($angle, $x = -1, $y = -1)
	{
		if ($x == -1)
			$x = $this->x;
		if ($y == -1)
			$y = $this->y;
		if ($this->angle != 0)
			$this->_out('Q');
		$this->angle = $angle;
		if ($angle != 0) {
			$angle*=M_PI / 180;
			$c = cos($angle);
			$s = sin($angle);
			$cx = $x * _MPDFK;
			$cy = ($this->h - $y) * _MPDFK;
			$this->_out(sprintf('q %.5F %.5F %.5F %.5F %.3F %.3F cm 1 0 0 1 %.3F %.3F cm', $c, $s, -$s, $c, $cx, $cy, -$cx, -$cy));
		}
	}

	function CircularText($x, $y, $r, $text, $align = 'top', $fontfamily = '', $fontsize = 0, $fontstyle = '', $kerning = 120, $fontwidth = 100, $divider)
	{
		if (!class_exists('directw', false)) {
			include(_MPDF_PATH . 'classes/directw.php');
		}
		if (empty($this->directw)) {
			$this->directw = new directw($this);
		}
		$this->directw->CircularText($x, $y, $r, $text, $align, $fontfamily, $fontsize, $fontstyle, $kerning, $fontwidth, $divider);
	}

	// From Invoice
	function RoundedRect($x, $y, $w, $h, $r, $style = '')
	{
		$hp = $this->h;
		if ($style == 'F')
			$op = 'f';
		elseif ($style == 'FD' or $style == 'DF')
			$op = 'B';
		else
			$op = 'S';
		$MyArc = 4 / 3 * (sqrt(2) - 1);
		$this->_out(sprintf('%.3F %.3F m', ($x + $r) * _MPDFK, ($hp - $y) * _MPDFK));
		$xc = $x + $w - $r;
		$yc = $y + $r;
		$this->_out(sprintf('%.3F %.3F l', $xc * _MPDFK, ($hp - $y) * _MPDFK));

		$this->_Arc($xc + $r * $MyArc, $yc - $r, $xc + $r, $yc - $r * $MyArc, $xc + $r, $yc);
		$xc = $x + $w - $r;
		$yc = $y + $h - $r;
		$this->_out(sprintf('%.3F %.3F l', ($x + $w) * _MPDFK, ($hp - $yc) * _MPDFK));
		$this->_Arc($xc + $r, $yc + $r * $MyArc, $xc + $r * $MyArc, $yc + $r, $xc, $yc + $r);
		$xc = $x + $r;
		$yc = $y + $h - $r;
		$this->_out(sprintf('%.3F %.3F l', $xc * _MPDFK, ($hp - ($y + $h)) * _MPDFK));
		$this->_Arc($xc - $r * $MyArc, $yc + $r, $xc - $r, $yc + $r * $MyArc, $xc - $r, $yc);
		$xc = $x + $r;
		$yc = $y + $r;
		$this->_out(sprintf('%.3F %.3F l', ($x) * _MPDFK, ($hp - $yc) * _MPDFK));
		$this->_Arc($xc - $r, $yc - $r * $MyArc, $xc - $r * $MyArc, $yc - $r, $xc, $yc - $r);
		$this->_out($op);
	}

	function _Arc($x1, $y1, $x2, $y2, $x3, $y3)
	{
		$h = $this->h;
		$this->_out(sprintf('%.3F %.3F %.3F %.3F %.3F %.3F c ', $x1 * _MPDFK, ($h - $y1) * _MPDFK, $x2 * _MPDFK, ($h - $y2) * _MPDFK, $x3 * _MPDFK, ($h - $y3) * _MPDFK));
	}

	//====================================================



	/* -- DIRECTW -- */
	function Shaded_box($text, $font = '', $fontstyle = 'B', $szfont = '', $width = '70%', $style = 'DF', $radius = 2.5, $fill = '#FFFFFF', $color = '#000000', $pad = 2)
	{
		// F (shading - no line),S (line, no shading),DF (both)
		if (!class_exists('directw', false)) {
			include(_MPDF_PATH . 'classes/directw.php');
		}
		if (empty($this->directw)) {
			$this->directw = new directw($this);
		}
		$this->directw->Shaded_box($text, $font, $fontstyle, $szfont, $width, $style, $radius, $fill, $color, $pad);
	}

	/* -- END DIRECTW -- */

	function UTF8StringToArray($str, $addSubset = true)
	{
		$out = array();
		$len = strlen($str);
		for ($i = 0; $i < $len; $i++) {
			$uni = -1;
			$h = ord($str[$i]);
			if ($h <= 0x7F)
				$uni = $h;
			elseif ($h >= 0xC2) {
				if (($h <= 0xDF) && ($i < $len - 1))
					$uni = ($h & 0x1F) << 6 | (ord($str[++$i]) & 0x3F);
				elseif (($h <= 0xEF) && ($i < $len - 2))
					$uni = ($h & 0x0F) << 12 | (ord($str[++$i]) & 0x3F) << 6 | (ord($str[++$i]) & 0x3F);
				elseif (($h <= 0xF4) && ($i < $len - 3))
					$uni = ($h & 0x0F) << 18 | (ord($str[++$i]) & 0x3F) << 12 | (ord($str[++$i]) & 0x3F) << 6 | (ord($str[++$i]) & 0x3F);
			}
			if ($uni >= 0) {
				$out[] = $uni;
				if ($addSubset && isset($this->CurrentFont['subset'])) {
					$this->CurrentFont['subset'][$uni] = $uni;
				}
			}
		}
		return $out;
	}

	//Convert utf-8 string to <HHHHHH> for Font Subsets
	function UTF8toSubset($str)
	{
		$ret = '<';
		//$str = preg_replace('/'.preg_quote($this->aliasNbPg,'/').'/', chr(7), $str );	// mPDF 6 deleted
		//$str = preg_replace('/'.preg_quote($this->aliasNbPgGp,'/').'/', chr(8), $str );	// mPDF 6 deleted
		$unicode = $this->UTF8StringToArray($str);
		$orig_fid = $this->CurrentFont['subsetfontids'][0];
		$last_fid = $this->CurrentFont['subsetfontids'][0];
		foreach ($unicode as $c) {
			/* 	// mPDF 6 deleted
			  if ($c == 7 || $c == 8) {
			  if ($orig_fid != $last_fid) {
			  $ret .= '> Tj /F'.$orig_fid.' '.$this->FontSizePt.' Tf <';
			  $last_fid = $orig_fid;
			  }
			  if ($c == 7) { $ret .= $this->aliasNbPgHex; }
			  else { $ret .= $this->aliasNbPgGpHex; }
			  continue;
			  }
			 */
			if (!$this->_charDefined($this->CurrentFont['cw'], $c)) {
				$c = 0;
			} // mPDF 6
			for ($i = 0; $i < 99; $i++) {
				// return c as decimal char
				$init = array_search($c, $this->CurrentFont['subsets'][$i]);
				if ($init !== false) {
					if ($this->CurrentFont['subsetfontids'][$i] != $last_fid) {
						$ret .= '> Tj /F' . $this->CurrentFont['subsetfontids'][$i] . ' ' . $this->FontSizePt . ' Tf <';
						$last_fid = $this->CurrentFont['subsetfontids'][$i];
					}
					$ret .= sprintf("%02s", strtoupper(dechex($init)));
					break;
				}
				// TrueType embedded SUBSETS
				elseif (count($this->CurrentFont['subsets'][$i]) < 255) {
					$n = count($this->CurrentFont['subsets'][$i]);
					$this->CurrentFont['subsets'][$i][$n] = $c;
					if ($this->CurrentFont['subsetfontids'][$i] != $last_fid) {
						$ret .= '> Tj /F' . $this->CurrentFont['subsetfontids'][$i] . ' ' . $this->FontSizePt . ' Tf <';
						$last_fid = $this->CurrentFont['subsetfontids'][$i];
					}
					$ret .= sprintf("%02s", strtoupper(dechex($n)));
					break;
				} elseif (!isset($this->CurrentFont['subsets'][($i + 1)])) {
					// TrueType embedded SUBSETS
					$this->CurrentFont['subsets'][($i + 1)] = array(0 => 0);
					$new_fid = count($this->fonts) + $this->extraFontSubsets + 1;
					$this->CurrentFont['subsetfontids'][($i + 1)] = $new_fid;
					$this->extraFontSubsets++;
				}
			}
		}
		$ret .= '>';
		if ($last_fid != $orig_fid) {
			$ret .= ' Tj /F' . $orig_fid . ' ' . $this->FontSizePt . ' Tf <> ';
		}
		return $ret;
	}

	// Converts UTF-8 strings to UTF16-BE.
	function UTF8ToUTF16BE($str, $setbom = true)
	{
		if ($this->checkSIP && preg_match("/([\x{20000}-\x{2FFFF}])/u", $str)) {
			if (!in_array($this->currentfontfamily, array('gb', 'big5', 'sjis', 'uhc', 'gbB', 'big5B', 'sjisB', 'uhcB', 'gbI', 'big5I', 'sjisI', 'uhcI',
					'gbBI', 'big5BI', 'sjisBI', 'uhcBI'))) {
				$str = preg_replace("/[\x{20000}-\x{2FFFF}]/u", chr(0), $str);
			}
		}
		if ($this->checkSMP && preg_match("/([\x{10000}-\x{1FFFF}])/u", $str)) {
			$str = preg_replace("/[\x{10000}-\x{1FFFF}]/u", chr(0), $str);
		}
		$outstr = ""; // string to be returned
		if ($setbom) {
			$outstr .= "\xFE\xFF"; // Byte Order Mark (BOM)
		}
		$outstr .= mb_convert_encoding($str, 'UTF-16BE', 'UTF-8');
		return $outstr;
	}

	// ====================================================
	// ====================================================
		/* -- CJK-FONTS -- */

	// from class PDF_Chinese CJK EXTENSIONS
	function AddCIDFont($family, $style, $name, &$cw, $CMap, $registry, $desc)
	{
		$fontkey = strtolower($family) . strtoupper($style);
		if (isset($this->fonts[$fontkey]))
			throw new MpdfException("Font already added: $family $style");
		$i = count($this->fonts) + $this->extraFontSubsets + 1;
		$name = str_replace(' ', '', $name);
		if ($family == 'sjis') {
			$up = -120;
		} else {
			$up = -130;
		}
		// ? 'up' and 'ut' do not seem to be referenced anywhere
		$this->fonts[$fontkey] = array('i' => $i, 'type' => 'Type0', 'name' => $name, 'up' => $up, 'ut' => 40, 'cw' => $cw, 'CMap' => $CMap, 'registry' => $registry, 'MissingWidth' => 1000, 'desc' => $desc);
	}

	function AddCJKFont($family)
	{

		if ($this->PDFA || $this->PDFX) {
			throw new MpdfException("Adobe CJK fonts cannot be embedded in mPDF (required for PDFA1-b and PDFX/1-a).");
		}
		if ($family == 'big5') {
			$this->AddBig5Font();
		} elseif ($family == 'gb') {
			$this->AddGBFont();
		} elseif ($family == 'sjis') {
			$this->AddSJISFont();
		} elseif ($family == 'uhc') {
			$this->AddUHCFont();
		}
	}

	function AddBig5Font()
	{
		//Add Big5 font with proportional Latin
		$family = 'big5';
		$name = 'MSungStd-Light-Acro';
		$cw = $this->Big5_widths;
		$CMap = 'UniCNS-UTF16-H';
		$registry = array('ordering' => 'CNS1', 'supplement' => 4);
		$desc = array(
			'Ascent' => 880,
			'Descent' => -120,
			'CapHeight' => 880,
			'Flags' => 6,
			'FontBBox' => '[-160 -249 1015 1071]',
			'ItalicAngle' => 0,
			'StemV' => 93,
		);
		$this->AddCIDFont($family, '', $name, $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'B', $name . ',Bold', $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'I', $name . ',Italic', $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'BI', $name . ',BoldItalic', $cw, $CMap, $registry, $desc);
	}

	function AddGBFont()
	{
		//Add GB font with proportional Latin
		$family = 'gb';
		$name = 'STSongStd-Light-Acro';
		$cw = $this->GB_widths;
		$CMap = 'UniGB-UTF16-H';
		$registry = array('ordering' => 'GB1', 'supplement' => 4);
		$desc = array(
			'Ascent' => 880,
			'Descent' => -120,
			'CapHeight' => 737,
			'Flags' => 6,
			'FontBBox' => '[-25 -254 1000 880]',
			'ItalicAngle' => 0,
			'StemV' => 58,
			'Style' => '<< /Panose <000000000400000000000000> >>',
		);
		$this->AddCIDFont($family, '', $name, $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'B', $name . ',Bold', $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'I', $name . ',Italic', $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'BI', $name . ',BoldItalic', $cw, $CMap, $registry, $desc);
	}

	function AddSJISFont()
	{
		//Add SJIS font with proportional Latin
		$family = 'sjis';
		$name = 'KozMinPro-Regular-Acro';
		$cw = $this->SJIS_widths;
		$CMap = 'UniJIS-UTF16-H';
		$registry = array('ordering' => 'Japan1', 'supplement' => 5);
		$desc = array(
			'Ascent' => 880,
			'Descent' => -120,
			'CapHeight' => 740,
			'Flags' => 6,
			'FontBBox' => '[-195 -272 1110 1075]',
			'ItalicAngle' => 0,
			'StemV' => 86,
			'XHeight' => 502,
		);
		$this->AddCIDFont($family, '', $name, $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'B', $name . ',Bold', $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'I', $name . ',Italic', $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'BI', $name . ',BoldItalic', $cw, $CMap, $registry, $desc);
	}

	function AddUHCFont()
	{
		//Add UHC font with proportional Latin
		$family = 'uhc';
		$name = 'HYSMyeongJoStd-Medium-Acro';
		$cw = $this->UHC_widths;
		$CMap = 'UniKS-UTF16-H';
		$registry = array('ordering' => 'Korea1', 'supplement' => 2);
		$desc = array(
			'Ascent' => 880,
			'Descent' => -120,
			'CapHeight' => 720,
			'Flags' => 6,
			'FontBBox' => '[-28 -148 1001 880]',
			'ItalicAngle' => 0,
			'StemV' => 60,
			'Style' => '<< /Panose <000000000600000000000000> >>',
		);
		$this->AddCIDFont($family, '', $name, $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'B', $name . ',Bold', $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'I', $name . ',Italic', $cw, $CMap, $registry, $desc);
		$this->AddCIDFont($family, 'BI', $name . ',BoldItalic', $cw, $CMap, $registry, $desc);
	}

	/* -- END CJK-FONTS -- */

	//////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////

	function SetDefaultFont($font)
	{
		// Disallow embedded fonts to be used as defaults in PDFA
		if ($this->PDFA || $this->PDFX) {
			if (strtolower($font) == 'ctimes') {
				$font = 'serif';
			}
			if (strtolower($font) == 'ccourier') {
				$font = 'monospace';
			}
			if (strtolower($font) == 'chelvetica') {
				$font = 'sans-serif';
			}
		}
		$font = $this->SetFont($font); // returns substituted font if necessary
		$this->default_font = $font;
		$this->original_default_font = $font;
		if (!$this->watermark_font) {
			$this->watermark_font = $font;
		} // *WATERMARK*
		$this->defaultCSS['BODY']['FONT-FAMILY'] = $font;
		$this->cssmgr->CSS['BODY']['FONT-FAMILY'] = $font;
	}

	function SetDefaultFontSize($fontsize)
	{
		$this->default_font_size = $fontsize;
		$this->original_default_font_size = $fontsize;
		$this->SetFontSize($fontsize);
		$this->defaultCSS['BODY']['FONT-SIZE'] = $fontsize . 'pt';
		$this->cssmgr->CSS['BODY']['FONT-SIZE'] = $fontsize . 'pt';
	}

	function SetDefaultBodyCSS($prop, $val)
	{
		if ($prop) {
			$this->defaultCSS['BODY'][strtoupper($prop)] = $val;
			$this->cssmgr->CSS['BODY'][strtoupper($prop)] = $val;
		}
	}

	function SetDirectionality($dir = 'ltr')
	{
		/* -- OTL -- */
		if (strtolower($dir) == 'rtl') {
			if ($this->directionality != 'rtl') {
				// Swop L/R Margins so page 1 RTL is an 'even' page
				$tmp = $this->DeflMargin;
				$this->DeflMargin = $this->DefrMargin;
				$this->DefrMargin = $tmp;
				$this->orig_lMargin = $this->DeflMargin;
				$this->orig_rMargin = $this->DefrMargin;

				$this->SetMargins($this->DeflMargin, $this->DefrMargin, $this->tMargin);
			}
			$this->directionality = 'rtl';
			$this->defaultAlign = 'R';
			$this->defaultTableAlign = 'R';
		} else {
			/* -- END OTL -- */
			$this->directionality = 'ltr';
			$this->defaultAlign = 'L';
			$this->defaultTableAlign = 'L';
		} // *OTL*
		$this->cssmgr->CSS['BODY']['DIRECTION'] = $this->directionality;
	}

	// Return either a number (factor) - based on current set fontsize (if % or em) - or exact lineheight (with 'mm' after it)
	function fixLineheight($v)
	{
		$lh = false;
		if (preg_match('/^[0-9\.,]*$/', $v) && $v >= 0) {
			return ($v + 0);
		} elseif (strtoupper($v) == 'NORMAL' || $v == 'N') {
			return 'N';  // mPDF 6
		} else {
			$tlh = $this->ConvertSize($v, $this->FontSize, $this->FontSize, true);
			if ($tlh) {
				return ($tlh . 'mm');
			}
		}
		return $this->normalLineheight;
	}

	function _getNormalLineheight($desc = false)
	{
		if (!$desc) {
			$desc = $this->CurrentFont['desc'];
		}
		if (!isset($desc['Leading'])) {
			$desc['Leading'] = 0;
		}
		if ($this->useFixedNormalLineHeight) {
			$lh = $this->normalLineheight;
		} elseif (isset($desc['Ascent']) && $desc['Ascent']) {
			$lh = ($this->adjustFontDescLineheight * ($desc['Ascent'] - $desc['Descent'] + $desc['Leading']) / 1000);
		} else {
			$lh = $this->normalLineheight;
		}
		return $lh;
	}

	// Set a (fixed) lineheight to an actual value - either to named fontsize(pts) or default
	function SetLineHeight($FontPt = '', $lh = '')
	{
		if (!$FontPt) {
			$FontPt = $this->FontSizePt;
		}
		$fs = $FontPt / _MPDFK;
		$this->lineheight = $this->_computeLineheight($lh, $fs);
	}

	function _computeLineheight($lh, $fs = '')
	{
		if ($this->shrin_k > 1) {
			$k = $this->shrin_k;
		} else {
			$k = 1;
		}
		if (!$fs) {
			$fs = $this->FontSize;
		}
		if ($lh == 'N') {
			$lh = $this->_getNormalLineheight();
		}
		if (preg_match('/mm/', $lh)) {
			return (($lh + 0.0) / $k); // convert to number
		} elseif ($lh > 0) {
			return ($fs * $lh);
		}
		return ($fs * $this->normalLineheight);
	}

	function _setLineYpos(&$fontsize, &$fontdesc, &$CSSlineheight, $blockYpos = false)
	{
		$ypos['glyphYorigin'] = 0;
		$ypos['baseline-shift'] = 0;
		$linegap = 0;
		$leading = 0;

		if (isset($fontdesc['Ascent']) && $fontdesc['Ascent'] && !$this->useFixedTextBaseline) {
			// Fontsize uses font metrics - this method seems to produce results compatible with browsers (except IE9)
			$ypos['boxtop'] = $fontdesc['Ascent'] / 1000 * $fontsize;
			$ypos['boxbottom'] = $fontdesc['Descent'] / 1000 * $fontsize;
			if (isset($fontdesc['Leading'])) {
				$linegap = $fontdesc['Leading'] / 1000 * $fontsize;
			}
		}
		// Default if not set - uses baselineC
		else {
			$ypos['boxtop'] = (0.5 + $this->baselineC) * $fontsize;
			$ypos['boxbottom'] = -(0.5 - $this->baselineC) * $fontsize;
		}
		$fontheight = $ypos['boxtop'] - $ypos['boxbottom'];

		if ($this->shrin_k > 1) {
			$shrin_k = $this->shrin_k;
		} else {
			$shrin_k = 1;
		}

		$leading = 0;
		if ($CSSlineheight == 'N') {
			$lh = $this->_getNormalLineheight($fontdesc);
			$lineheight = ($fontsize * $lh);
			$leading += $linegap; // specified in hhea or sTypo in OpenType tables	****************************************
		} elseif (preg_match('/mm/', $CSSlineheight)) {
			$lineheight = (($CSSlineheight + 0.0) / $shrin_k);
		} // convert to number
		// ??? If lineheight is a factor e.g. 1.3  ?? use factor x 1em or ? use 'normal' lineheight * factor ******************************
		// Could depend on value for $text_height - a draft CSS value as set above for now
		elseif ($CSSlineheight > 0) {
			$lineheight = ($fontsize * $CSSlineheight);
		} else {
			$lineheight = ($fontsize * $this->normalLineheight);
		}

		// In general, calculate the "leading" - the difference between the fontheight and the lineheight
		// and add half to the top and half to the bottom. BUT
		// If an inline element has a font-size less than the block element, and the line-height is set as an em or % value
		// it will add too much leading below the font and expand the height of the line - so just use the block element exttop/extbottom:
		if (preg_match('/mm/', $CSSlineheight) && $ypos['boxtop'] < $blockYpos['boxtop'] && $ypos['boxbottom'] > $blockYpos['boxbottom']) {
			$ypos['exttop'] = $blockYpos['exttop'];
			$ypos['extbottom'] = $blockYpos['extbottom'];
		} else {
			$leading += ($lineheight - $fontheight);

			$ypos['exttop'] = $ypos['boxtop'] + $leading / 2;
			$ypos['extbottom'] = $ypos['boxbottom'] - $leading / 2;
		}


		// TEMP ONLY FOR DEBUGGING *********************************
		//$ypos['lineheight'] = $lineheight;
		//$ypos['fontheight'] = $fontheight;
		//$ypos['leading'] = $leading;

		return $ypos;
	}

	/* Called from WriteFlowingBlock() and finishFlowingBlock()
	  Determines the line hieght and glyph/writing position
	  for each element in the line to be written */

	function _setInlineBlockHeights(&$lineBox, &$stackHeight, &$content, &$font, $is_table)
	{
		if ($this->shrin_k > 1) {
			$shrin_k = $this->shrin_k;
		} else {
			$shrin_k = 1;
		}

		$ypos = array();
		$bordypos = array();
		$bgypos = array();

		if ($is_table) {
			// FOR TABLE
			$fontsize = $this->FontSize;
			$fontkey = $this->FontFamily . $this->FontStyle;
			$fontdesc = $this->fonts[$fontkey]['desc'];
			$CSSlineheight = $this->cellLineHeight;
			$line_stacking_strategy = $this->cellLineStackingStrategy; // inline-line-height [default] | block-line-height | max-height | grid-height
			$line_stacking_shift = $this->cellLineStackingShift;  // consider-shifts [default] | disregard-shifts
		} else {
			// FOR BLOCK FONT
			$fontsize = $this->blk[$this->blklvl]['InlineProperties']['size'];
			$fontkey = $this->blk[$this->blklvl]['InlineProperties']['family'] . $this->blk[$this->blklvl]['InlineProperties']['style'];
			$fontdesc = $this->fonts[$fontkey]['desc'];
			$CSSlineheight = $this->blk[$this->blklvl]['line_height'];
			// inline-line-height | block-line-height | max-height | grid-height
			$line_stacking_strategy = (isset($this->blk[$this->blklvl]['line_stacking_strategy']) ? $this->blk[$this->blklvl]['line_stacking_strategy'] : 'inline-line-height');
			// consider-shifts | disregard-shifts
			$line_stacking_shift = (isset($this->blk[$this->blklvl]['line_stacking_shift']) ? $this->blk[$this->blklvl]['line_stacking_shift'] : 'consider-shifts');
		}
		$boxLineHeight = $this->_computeLineheight($CSSlineheight, $fontsize);


		// First, set a "strut" using block font at index $lineBox[-1]
		$ypos[-1] = $this->_setLineYpos($fontsize, $fontdesc, $CSSlineheight);

		// for the block element - always taking the block EXTENDED progression including leading - which may be negative
		if ($line_stacking_strategy == 'block-line-height') {
			$topy = $ypos[-1]['exttop'];
			$bottomy = $ypos[-1]['extbottom'];
		} else {
			$topy = 0;
			$bottomy = 0;
		}

		// Get text-middle for aligning images/objects
		$midpoint = $ypos[-1]['boxtop'] - (($ypos[-1]['boxtop'] - $ypos[-1]['boxbottom']) / 2);

		// for images / inline objects / replaced elements
		$mta = 0; // Maximum top-aligned
		$mba = 0; // Maximum bottom-aligned
		foreach ($content as $k => $chunk) {
			if (isset($this->objectbuffer[$k]) && $this->objectbuffer[$k]['type'] == 'listmarker') {
				$ypos[$k] = $ypos[-1];
				// UPDATE Maximums
				if ($line_stacking_strategy == 'block-line-height' || $line_stacking_strategy == 'grid-height' || $line_stacking_strategy == 'max-height') { // don't include extended block progression of all inline elements
					if ($ypos[$k]['boxtop'] > $topy)
						$topy = $ypos[$k]['boxtop'];
					if ($ypos[$k]['boxbottom'] < $bottomy)
						$bottomy = $ypos[$k]['boxbottom'];
				}
				else {
					if ($ypos[$k]['exttop'] > $topy)
						$topy = $ypos[$k]['exttop'];
					if ($ypos[$k]['extbottom'] < $bottomy)
						$bottomy = $ypos[$k]['extbottom'];
				}
			}
			elseif (isset($this->objectbuffer[$k]) && $this->objectbuffer[$k]['type'] == 'dottab') { // mPDF 6 DOTTAB
				$fontsize = $font[$k]['size'];
				$fontdesc = $font[$k]['curr']['desc'];
				$lh = 1;
				$ypos[$k] = $this->_setLineYpos($fontsize, $fontdesc, $lh, $ypos[-1]); // Lineheight=1 fixed
			} elseif (isset($this->objectbuffer[$k])) {
				$oh = $this->objectbuffer[$k]['OUTER-HEIGHT'];
				$va = $this->objectbuffer[$k]['vertical-align'];

				if ($va == 'BS') { //  (BASELINE default)
					if ($oh > $topy)
						$topy = $oh;
				}
				elseif ($va == 'M') {
					if (($midpoint + $oh / 2) > $topy)
						$topy = $midpoint + $oh / 2;
					if (($midpoint - $oh / 2) < $bottomy)
						$bottomy = $midpoint - $oh / 2;
				}
				elseif ($va == 'TT') {
					if (($ypos[-1]['boxtop'] - $oh) < $bottomy) {
						$bottomy = $ypos[-1]['boxtop'] - $oh;
						$topy = max($topy, $ypos[-1]['boxtop']);
					}
				} elseif ($va == 'TB') {
					if (($ypos[-1]['boxbottom'] + $oh) > $topy) {
						$topy = $ypos[-1]['boxbottom'] + $oh;
						$bottomy = min($bottomy, $ypos[-1]['boxbottom']);
					}
				} elseif ($va == 'T') {
					if ($oh > $mta)
						$mta = $oh;
				}
				elseif ($va == 'B') {
					if ($oh > $mba)
						$mba = $oh;
				}
			}
			elseif ($content[$k] || $content[$k] === '0') {
				// FOR FLOWING BLOCK
				$fontsize = $font[$k]['size'];
				$fontdesc = $font[$k]['curr']['desc'];
				// In future could set CSS line-height from inline elements; for now, use block level:
				$ypos[$k] = $this->_setLineYpos($fontsize, $fontdesc, $CSSlineheight, $ypos[-1]);

				if (isset($font[$k]['textparam']['text-baseline']) && $font[$k]['textparam']['text-baseline'] != 0) {
					$ypos[$k]['baseline-shift'] = $font[$k]['textparam']['text-baseline'];
				}

				// DO ALIGNMENT FOR BASELINES *******************
				// Until most fonts have OpenType BASE tables, this won't work
				// $ypos[$k] compared to $ypos[-1] or $ypos[$k-1] using $dominant_baseline and $baseline_table
				// UPDATE Maximums
				if ($line_stacking_strategy == 'block-line-height' || $line_stacking_strategy == 'grid-height' || $line_stacking_strategy == 'max-height') { // don't include extended block progression of all inline elements
					if ($line_stacking_shift == 'disregard-shifts') {
						if ($ypos[$k]['boxtop'] > $topy)
							$topy = $ypos[$k]['boxtop'];
						if ($ypos[$k]['boxbottom'] < $bottomy)
							$bottomy = $ypos[$k]['boxbottom'];
					}
					else {
						if (($ypos[$k]['boxtop'] + $ypos[$k]['baseline-shift']) > $topy)
							$topy = $ypos[$k]['boxtop'] + $ypos[$k]['baseline-shift'];
						if (($ypos[$k]['boxbottom'] + $ypos[$k]['baseline-shift']) < $bottomy)
							$bottomy = $ypos[$k]['boxbottom'] + $ypos[$k]['baseline-shift'];
					}
				}
				else {
					if ($line_stacking_shift == 'disregard-shifts') {
						if ($ypos[$k]['exttop'] > $topy)
							$topy = $ypos[$k]['exttop'];
						if ($ypos[$k]['extbottom'] < $bottomy)
							$bottomy = $ypos[$k]['extbottom'];
					}
					else {
						if (($ypos[$k]['exttop'] + $ypos[$k]['baseline-shift']) > $topy)
							$topy = $ypos[$k]['exttop'] + $ypos[$k]['baseline-shift'];
						if (($ypos[$k]['extbottom'] + $ypos[$k]['baseline-shift']) < $bottomy)
							$bottomy = $ypos[$k]['extbottom'] + $ypos[$k]['baseline-shift'];
					}
				}

				// If BORDER set on inline element
				if (isset($font[$k]['bord']) && $font[$k]['bord']) {
					$bordfontsize = $font[$k]['textparam']['bord-decoration']['fontsize'] / $shrin_k;
					$bordfontkey = $font[$k]['textparam']['bord-decoration']['fontkey'];
					if ($bordfontkey != $fontkey || $bordfontsize != $fontsize || isset($font[$k]['textparam']['bord-decoration']['baseline'])) {
						$bordfontdesc = $this->fonts[$bordfontkey]['desc'];
						$bordypos[$k] = $this->_setLineYpos($bordfontsize, $bordfontdesc, $CSSlineheight, $ypos[-1]);
						if (isset($font[$k]['textparam']['bord-decoration']['baseline']) && $font[$k]['textparam']['bord-decoration']['baseline'] != 0) {
							$bordypos[$k]['baseline-shift'] = $font[$k]['textparam']['bord-decoration']['baseline'] / $shrin_k;
						}
					}
				}
				// If BACKGROUND set on inline element
				if (isset($font[$k]['spanbgcolor']) && $font[$k]['spanbgcolor']) {
					$bgfontsize = $font[$k]['textparam']['bg-decoration']['fontsize'] / $shrin_k;
					$bgfontkey = $font[$k]['textparam']['bg-decoration']['fontkey'];
					if ($bgfontkey != $fontkey || $bgfontsize != $fontsize || isset($font[$k]['textparam']['bg-decoration']['baseline'])) {
						$bgfontdesc = $this->fonts[$bgfontkey]['desc'];
						$bgypos[$k] = $this->_setLineYpos($bgfontsize, $bgfontdesc, $CSSlineheight, $ypos[-1]);
						if (isset($font[$k]['textparam']['bg-decoration']['baseline']) && $font[$k]['textparam']['bg-decoration']['baseline'] != 0) {
							$bgypos[$k]['baseline-shift'] = $font[$k]['textparam']['bg-decoration']['baseline'] / $shrin_k;
						}
					}
				}
			}
		}


		// TOP or BOTTOM aligned images
		if ($mta > ($topy - $bottomy)) {
			if (($topy - $mta) < $bottomy)
				$bottomy = $topy - $mta;
		}
		if ($mba > ($topy - $bottomy)) {
			if (($bottomy + $mba) > $topy)
				$topy = $bottomy + $mba;
		}

		if ($line_stacking_strategy == 'block-line-height') { // fixed height set by block element (whether present or not)
			$topy = $ypos[-1]['exttop'];
			$bottomy = $ypos[-1]['extbottom'];
		}

		$inclusiveHeight = $topy - $bottomy;

		// SET $stackHeight taking note of line_stacking_strategy
		// NB inclusive height already takes account of need to consider block progression height (excludes leading set by lineheight)
		// or extended block progression height (includes leading set by lineheight)
		if ($line_stacking_strategy == 'block-line-height') { // fixed = extended block progression height of block element
			$stackHeight = $boxLineHeight;
		} elseif ($line_stacking_strategy == 'max-height') { // smallest height which includes extended block progression height of block element
			// and block progression heights of inline elements (NOT extended)
			$stackHeight = $inclusiveHeight;
		} elseif ($line_stacking_strategy == 'grid-height') { // smallest multiple of block element lineheight to include
			// block progression heights of inline elements (NOT extended)
			$stackHeight = $boxLineHeight;
			while ($stackHeight < $inclusiveHeight) {
				$stackHeight += $boxLineHeight;
			}
		} else { // 'inline-line-height' = default		// smallest height which includes extended block progression height of block element
			// AND extended block progression heights of inline elements
			$stackHeight = $inclusiveHeight;
		}

		$diff = $stackHeight - $inclusiveHeight;
		$topy += $diff / 2;
		$bottomy -= $diff / 2;

		// ADJUST $ypos => lineBox using $stackHeight; lineBox are all offsets from the top of stackHeight in mm
		// and SET IMAGE OFFSETS
		$lineBox[-1]['boxtop'] = $topy - $ypos[-1]['boxtop'];
		$lineBox[-1]['boxbottom'] = $topy - $ypos[-1]['boxbottom'];
		//	$lineBox[-1]['exttop'] = $topy - $ypos[-1]['exttop'];
		//	$lineBox[-1]['extbottom'] = $topy - $ypos[-1]['extbottom'];
		$lineBox[-1]['glyphYorigin'] = $topy - $ypos[-1]['glyphYorigin'];
		$lineBox[-1]['baseline-shift'] = $ypos[-1]['baseline-shift'];

		$midpoint = $lineBox[-1]['boxbottom'] - (($lineBox[-1]['boxbottom'] - $lineBox[-1]['boxtop']) / 2);

		foreach ($content as $k => $chunk) {
			if (isset($this->objectbuffer[$k])) {
				$oh = $this->objectbuffer[$k]['OUTER-HEIGHT'];
				// LIST MARKERS
				if ($this->objectbuffer[$k]['type'] == 'listmarker') {
					$oh = $fontsize;
				} elseif ($this->objectbuffer[$k]['type'] == 'dottab') { // mPDF 6 DOTTAB
					$oh = $font[$k]['size']; // == $this->objectbuffer[$k]['fontsize']/_MPDFK;
					$lineBox[$k]['boxtop'] = $topy - $ypos[$k]['boxtop'];
					$lineBox[$k]['boxbottom'] = $topy - $ypos[$k]['boxbottom'];
					$lineBox[$k]['glyphYorigin'] = $topy - $ypos[$k]['glyphYorigin'];
					$lineBox[$k]['baseline-shift'] = 0;
					// continue;
				}
				$va = $this->objectbuffer[$k]['vertical-align']; // = $objattr['vertical-align'] = set as M,T,B,S

				if ($va == 'BS') { //  (BASELINE default)
					$lineBox[$k]['top'] = $lineBox[-1]['glyphYorigin'] - $oh;
				} elseif ($va == 'M') {
					$lineBox[$k]['top'] = $midpoint - $oh / 2;
				} elseif ($va == 'TT') {
					$lineBox[$k]['top'] = $lineBox[-1]['boxtop'];
				} elseif ($va == 'TB') {
					$lineBox[$k]['top'] = $lineBox[-1]['boxbottom'] - $oh;
				} elseif ($va == 'T') {
					$lineBox[$k]['top'] = 0;
				} elseif ($va == 'B') {
					$lineBox[$k]['top'] = $stackHeight - $oh;
				}
			} elseif ($content[$k] || $content[$k] === '0') {
				$lineBox[$k]['boxtop'] = $topy - $ypos[$k]['boxtop'];
				$lineBox[$k]['boxbottom'] = $topy - $ypos[$k]['boxbottom'];
				// $lineBox[$k]['exttop'] = $topy - $ypos[$k]['exttop'];
				// $lineBox[$k]['extbottom'] = $topy - $ypos[$k]['extbottom'];
				$lineBox[$k]['glyphYorigin'] = $topy - $ypos[$k]['glyphYorigin'];
				$lineBox[$k]['baseline-shift'] = $ypos[$k]['baseline-shift'];
				if (isset($bordypos[$k]['boxtop'])) {
					$lineBox[$k]['border-boxtop'] = $topy - $bordypos[$k]['boxtop'];
					$lineBox[$k]['border-boxbottom'] = $topy - $bordypos[$k]['boxbottom'];
					$lineBox[$k]['border-baseline-shift'] = $bordypos[$k]['baseline-shift'];
				}
				if (isset($bgypos[$k]['boxtop'])) {
					$lineBox[$k]['background-boxtop'] = $topy - $bgypos[$k]['boxtop'];
					$lineBox[$k]['background-boxbottom'] = $topy - $bgypos[$k]['boxbottom'];
					$lineBox[$k]['background-baseline-shift'] = $bgypos[$k]['baseline-shift'];
				}
			}
		}
	}

	function SetBasePath($str = '')
	{
		if (isset($_SERVER['HTTP_HOST'])) {
			$host = $_SERVER['HTTP_HOST'];
		} elseif (isset($_SERVER['SERVER_NAME'])) {
			$host = $_SERVER['SERVER_NAME'];
		} else {
			$host = '';
		}
		if (!$str) {
			if ($_SERVER['SCRIPT_NAME']) {
				$currentPath = dirname($_SERVER['SCRIPT_NAME']);
			} else {
				$currentPath = dirname($_SERVER['PHP_SELF']);
			}
			$currentPath = str_replace("\\", "/", $currentPath);
			if ($currentPath == '/') {
				$currentPath = '';
			}
			if ($host) {  // mPDF 6
				if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']) {
					$currpath = 'https://' . $host . $currentPath . '/';
				} else {
					$currpath = 'http://' . $host . $currentPath . '/';
				}
			} else {
				$currpath = '';
			}
			$this->basepath = $currpath;
			$this->basepathIsLocal = true;
			return;
		}
		$str = preg_replace('/\?.*/', '', $str);
		if (!preg_match('/(http|https|ftp):\/\/.*\//i', $str)) {
			$str .= '/';
		}
		$str .= 'xxx'; // in case $str ends in / e.g. http://www.bbc.co.uk/
		$this->basepath = dirname($str) . "/"; // returns e.g. e.g. http://www.google.com/dir1/dir2/dir3/
		$this->basepath = str_replace("\\", "/", $this->basepath); //If on Windows
		$tr = parse_url($this->basepath);
		if (isset($tr['host']) && ($tr['host'] == $host)) {
			$this->basepathIsLocal = true;
		} else {
			$this->basepathIsLocal = false;
		}
	}

	function GetFullPath(&$path, $basepath = '')
	{
		// When parsing CSS need to pass temporary basepath - so links are relative to current stylesheet
		if (!$basepath) {
			$basepath = $this->basepath;
		}
		//Fix path value
		$path = str_replace("\\", "/", $path); //If on Windows
		// mPDF 5.7.2
		if (substr($path, 0, 2) == "//") {
			$tr = parse_url($basepath);
			$path = $tr['scheme'] . ':' . $path; // mPDF 6
		}

		$regexp = '|^./|'; // Inadvertently corrects "./path/etc" and "//www.domain.com/etc"
		$path = preg_replace($regexp, '', $path);

		if (substr($path, 0, 1) == '#') {
			return;
		}
		if (preg_match('@^(mailto|tel|fax):.*@i', $path)) {
			return;
		}
		if (substr($path, 0, 3) == "../") { //It is a Relative Link
			$backtrackamount = substr_count($path, "../");
			$maxbacktrack = substr_count($basepath, "/") - 3;
			$filepath = str_replace("../", '', $path);
			$path = $basepath;
			//If it is an invalid relative link, then make it go to directory root
			if ($backtrackamount > $maxbacktrack)
				$backtrackamount = $maxbacktrack;
			//Backtrack some directories
			for ($i = 0; $i < $backtrackamount + 1; $i++)
				$path = substr($path, 0, strrpos($path, "/"));
			$path = $path . "/" . $filepath; //Make it an absolute path
		}
		elseif (strpos($path, ":/") === false || strpos($path, ":/") > 10) { //It is a Local Link
			if (substr($path, 0, 1) == "/") {
				$tr = parse_url($basepath);
				// mPDF 5.7.2
				$root = '';
				if (!empty($tr['scheme'])) {
					$root .= $tr['scheme'] . '://';
				}
				$root .= isset($tr['host']) ? $tr['host'] : '';
				$root .= ((isset($tr['port']) && $tr['port']) ? (':' . $tr['port']) : ''); // mPDF 5.7.3
				$path = $root . $path;
			} else {
				$path = $basepath . $path;
			}
		}
		//Do nothing if it is an Absolute Link
	}

	// Used for external CSS files
	function _get_file($path)
	{
		// If local file try using local path (? quicker, but also allowed even if allow_url_fopen false)
		$contents = '';
		// mPDF 5.7.3
		if (strpos($path, "//") === false) {
			$path = preg_replace('/\.css\?.*$/', '.css', $path);
		}
		$contents = @file_get_contents($path);
		if ($contents) {
			return $contents;
		}
		if ($this->basepathIsLocal) {
			$tr = parse_url($path);
			$lp = getenv("SCRIPT_NAME");
			$ap = realpath($lp);
			$ap = str_replace("\\", "/", $ap);
			$docroot = substr($ap, 0, strpos($ap, $lp));
			// WriteHTML parses all paths to full URLs; may be local file name
			if ($tr['scheme'] && $tr['host'] && $_SERVER["DOCUMENT_ROOT"]) {
				$localpath = $_SERVER["DOCUMENT_ROOT"] . $tr['path'];
			}
			// DOCUMENT_ROOT is not returned on IIS
			elseif ($docroot) {
				$localpath = $docroot . $tr['path'];
			} else {
				$localpath = $path;
			}
			$contents = @file_get_contents($localpath);
		}
		// if not use full URL
		elseif (!$contents && !ini_get('allow_url_fopen') && function_exists("curl_init")) {
			$ch = curl_init($path);
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			$contents = curl_exec($ch);
			curl_close($ch);
		}
		return $contents;
	}

	function docPageNum($num = 0, $extras = false)
	{
		if ($num < 1) {
			$num = $this->page;
		}
		$type = $this->defaultPageNumStyle; // set default Page Number Style
		$ppgno = $num;
		$suppress = 0;
		$offset = 0;
		$lastreset = 0;
		foreach ($this->PageNumSubstitutions AS $psarr) {
			if ($num >= $psarr['from']) {
				if ($psarr['reset']) {
					if ($psarr['reset'] > 1) {
						$offset = $psarr['reset'] - 1;
					}
					$ppgno = $num - $psarr['from'] + 1 + $offset;
					$lastreset = $psarr['from'];
				}
				if ($psarr['type']) {
					$type = $psarr['type'];
				}
				if (strtoupper($psarr['suppress']) == 'ON' || $psarr['suppress'] == 1) {
					$suppress = 1;
				} elseif (strtoupper($psarr['suppress']) == 'OFF') {
					$suppress = 0;
				}
			}
		}
		if ($suppress) {
			return '';
		}

		$ppgno = $this->_getStyledNumber($ppgno, $type);
		if ($extras) {
			$ppgno = $this->pagenumPrefix . $ppgno . $this->pagenumSuffix;
		}
		return $ppgno;
	}

	function docPageNumTotal($num = 0, $extras = false)
	{
		if ($num < 1) {
			$num = $this->page;
		}
		$type = $this->defaultPageNumStyle; // set default Page Number Style
		$ppgstart = 1;
		$ppgend = count($this->pages) + 1;
		$suppress = 0;
		$offset = 0;
		foreach ($this->PageNumSubstitutions AS $psarr) {
			if ($num >= $psarr['from']) {
				if ($psarr['reset']) {
					if ($psarr['reset'] > 1) {
						$offset = $psarr['reset'] - 1;
					}
					$ppgstart = $psarr['from'] + $offset;
					$ppgend = count($this->pages) + 1 + $offset;
				}
				if ($psarr['type']) {
					$type = $psarr['type'];
				}
				if (strtoupper($psarr['suppress']) == 'ON' || $psarr['suppress'] == 1) {
					$suppress = 1;
				} elseif (strtoupper($psarr['suppress']) == 'OFF') {
					$suppress = 0;
				}
			}
			if ($num < $psarr['from']) {
				if ($psarr['reset']) {
					$ppgend = $psarr['from'] + $offset;
					break;
				}
			}
		}
		if ($suppress) {
			return '';
		}
		$ppgno = $ppgend - $ppgstart + $offset;

		$ppgno = $this->_getStyledNumber($ppgno, $type);
		if ($extras) {
			$ppgno = $this->pagenumPrefix . $ppgno . $this->pagenumSuffix;
		}
		return $ppgno;
	}

	// mPDF 6
	function _getStyledNumber($ppgno, $type, $listmarker = false)
	{
		if ($listmarker) {
			$reverse = true;   // Reverse RTL numerals (Hebrew) when using for list
			$checkfont = true; // Using list - font is set, so check if character is available
		} else {
			$reverse = false;  // For pagenumbers, RTL numerals (Hebrew) will get reversed later by bidi
			$checkfont = false; // For pagenumbers - font is not set, so no check
		}
		$lowertype = strtolower($type);
		if ($lowertype == 'upper-latin' || $lowertype == 'upper-alpha' || $type == 'A') {
			$ppgno = $this->dec2alpha($ppgno, true);
		} elseif ($lowertype == 'lower-latin' || $lowertype == 'lower-alpha' || $type == 'a') {
			$ppgno = $this->dec2alpha($ppgno, false);
		} elseif ($lowertype == 'upper-roman' || $type == 'I') {
			$ppgno = $this->dec2roman($ppgno, true);
		} elseif ($lowertype == 'lower-roman' || $type == 'i') {
			$ppgno = $this->dec2roman($ppgno, false);
		} elseif ($lowertype == 'hebrew') {
			$ppgno = $this->dec2hebrew($ppgno, $reverse);
		} elseif (preg_match('/(arabic-indic|bengali|devanagari|gujarati|gurmukhi|kannada|malayalam|oriya|persian|tamil|telugu|thai|urdu|cambodian|khmer|lao)/i', $lowertype, $m)) {
			switch ($m[1]) { //Format type
				case 'arabic-indic': $cp = 0x0660;
					break;
				case 'persian':
				case 'urdu': $cp = 0x06F0;
					break;
				case 'bengali': $cp = 0x09E6;
					break;
				case 'devanagari': $cp = 0x0966;
					break;
				case 'gujarati': $cp = 0x0AE6;
					break;
				case 'gurmukhi': $cp = 0x0A66;
					break;
				case 'kannada': $cp = 0x0CE6;
					break;
				case 'malayalam': $cp = 0x0D66;
					break;
				case 'oriya': $cp = 0x0B66;
					break;
				case 'telugu': $cp = 0x0C66;
					break;
				case 'tamil': $cp = 0x0BE6;
					break;
				case 'thai': $cp = 0x0E50;
					break;
				case 'khmer':
				case 'cambodian': $cp = 0x17E0;
					break;
				case 'lao': $cp = 0x0ED0;
					break;
			}
			$ppgno = $this->dec2other($ppgno, $cp, $checkfont);
		} elseif ($lowertype == 'cjk-decimal') {
			$ppgno = $this->dec2cjk($ppgno);
		}
		return $ppgno;
	}

	function docPageSettings($num = 0)
	{
		// Returns current type (numberstyle), suppression state for this page number;
		// reset is only returned if set for this page number
		if ($num < 1) {
			$num = $this->page;
		}
		$type = $this->defaultPageNumStyle; // set default Page Number Style
		$ppgno = $num;
		$suppress = 0;
		$offset = 0;
		$reset = '';
		foreach ($this->PageNumSubstitutions AS $psarr) {
			if ($num >= $psarr['from']) {
				if ($psarr['reset']) {
					if ($psarr['reset'] > 1) {
						$offset = $psarr['reset'] - 1;
					}
					$ppgno = $num - $psarr['from'] + 1 + $offset;
				}
				if ($psarr['type']) {
					$type = $psarr['type'];
				}
				if (strtoupper($psarr['suppress']) == 'ON' || $psarr['suppress'] == 1) {
					$suppress = 1;
				} elseif (strtoupper($psarr['suppress']) == 'OFF') {
					$suppress = 0;
				}
			}
			if ($num == $psarr['from']) {
				$reset = $psarr['reset'];
			}
		}
		if ($suppress) {
			$suppress = 'on';
		} else {
			$suppress = 'off';
		}
		return array($type, $suppress, $reset);
	}

	function RestartDocTemplate()
	{
		$this->docTemplateStart = $this->page;
	}

	//Page header
	function Header($content = '')
	{

		$this->cMarginL = 0;
		$this->cMarginR = 0;


		if (($this->mirrorMargins && ($this->page % 2 == 0) && $this->HTMLHeaderE) || ($this->mirrorMargins && ($this->page % 2 == 1) && $this->HTMLHeader) || (!$this->mirrorMargins && $this->HTMLHeader)) {
			$this->writeHTMLHeaders();
			return;
		}
	}

	/* -- TABLES -- */

	function TableHeaderFooter($content = '', $tablestartpage = '', $tablestartcolumn = '', $horf = 'H', $level, $firstSpread = true, $finalSpread = true)
	{
		if (($horf == 'H' || $horf == 'F') && !empty($content)) { // mPDF 5.7.2
			$table = &$this->table[1][1];

			// mPDF 5.7.2
			if ($horf == 'F') { // Table Footer
				$firstrow = count($table['cells']) - $table['footernrows'];
				$lastrow = count($table['cells']) - 1;
			} else {  // Table Header
				$firstrow = 0;
				$lastrow = $table['headernrows'] - 1;
			}
			if (empty($content[$firstrow])) {
				if ($this->debug) {
					throw new MpdfException("&lt;tfoot&gt; must precede &lt;tbody&gt; in a table");
				} else {
					return;
				}
			}


			// Advance down page by half width of top border
			if ($horf == 'H') { // Only if header
				if ($table['borders_separate']) {
					$adv = $table['border_spacing_V'] / 2 + $table['border_details']['T']['w'] + $table['padding']['T'];
				} else {
					$adv = $table['max_cell_border_width']['T'] / 2;
				}
				if ($adv) {
					if ($this->table_rotate) {
						$this->y += ($adv);
					} else {
						$this->DivLn($adv, $this->blklvl, true);
					}
				}
			}

			$topy = $content[$firstrow][0]['y'] - $this->y;

			for ($i = $firstrow; $i <= $lastrow; $i++) {

				$y = $this->y;

				/* -- COLUMNS -- */
				// If outside columns, this is done in PaintDivBB
				if ($this->ColActive) {
					//OUTER FILL BGCOLOR of DIVS
					if ($this->blklvl > 0) {
						$firstblockfill = $this->GetFirstBlockFill();
						if ($firstblockfill && $this->blklvl >= $firstblockfill) {
							$divh = $content[$i][0]['h'];
							$bak_x = $this->x;
							$this->DivLn($divh, -3, false);
							// Reset current block fill
							$bcor = $this->blk[$this->blklvl]['bgcolorarray'];
							$this->SetFColor($bcor);
							$this->x = $bak_x;
						}
					}
				}
				/* -- END COLUMNS -- */

				$colctr = 0;
				foreach ($content[$i] as $tablehf) {
					$colctr++;
					$y = $tablehf['y'] - $topy;
					$this->y = $y;
					//Set some cell values
					$x = $tablehf['x'];
					if (($this->mirrorMargins) && ($tablestartpage == 'ODD') && (($this->page) % 2 == 0)) { // EVEN
						$x = $x + $this->MarginCorrection;
					} elseif (($this->mirrorMargins) && ($tablestartpage == 'EVEN') && (($this->page) % 2 == 1)) { // ODD
						$x = $x + $this->MarginCorrection;
					}
					/* -- COLUMNS -- */
					// Added to correct for Columns
					if ($this->ColActive) {
						if ($this->directionality == 'rtl') { // *OTL*
							$x -= ($this->CurrCol - $tablestartcolumn) * ($this->ColWidth + $this->ColGap); // *OTL*
						} // *OTL*
						else { // *OTL*
							$x += ($this->CurrCol - $tablestartcolumn) * ($this->ColWidth + $this->ColGap);
						} // *OTL*
					}
					/* -- END COLUMNS -- */

					if ($colctr == 1) {
						$x0 = $x;
					}

					// mPDF ITERATION
					if ($this->iterationCounter) {
						foreach ($tablehf['textbuffer'] AS $k => $t) {
							if (!is_array($t[0]) && preg_match('/{iteration ([a-zA-Z0-9_]+)}/', $t[0], $m)) {
								$vname = '__' . $m[1] . '_';
								if (!isset($this->$vname)) {
									$this->$vname = 1;
								} else {
									$this->$vname++;
								}
								$tablehf['textbuffer'][$k][0] = preg_replace('/{iteration ' . $m[1] . '}/', $this->$vname, $tablehf['textbuffer'][$k][0]);
							}
						}
					}

					$w = $tablehf['w'];
					$h = $tablehf['h'];
					$va = $tablehf['va'];
					$R = $tablehf['R'];
					$direction = $tablehf['direction'];
					$mih = $tablehf['mih'];
					$border = $tablehf['border'];
					$border_details = $tablehf['border_details'];
					$padding = $tablehf['padding'];
					$this->tabletheadjustfinished = true;

					$textbuffer = $tablehf['textbuffer'];

					//Align
					$align = $tablehf['a'];
					$this->cellTextAlign = $align;

					$this->cellLineHeight = $tablehf['cellLineHeight'];
					$this->cellLineStackingStrategy = $tablehf['cellLineStackingStrategy'];
					$this->cellLineStackingShift = $tablehf['cellLineStackingShift'];

					$this->x = $x;

					if ($this->ColActive) {
						if ($table['borders_separate']) {
							$tablefill = isset($table['bgcolor'][-1]) ? $table['bgcolor'][-1] : 0;
							if ($tablefill) {
								$color = $this->ConvertColor($tablefill);
								if ($color) {
									$xadj = ($table['border_spacing_H'] / 2);
									$yadj = ($table['border_spacing_V'] / 2);
									$wadj = $table['border_spacing_H'];
									$hadj = $table['border_spacing_V'];
									if ($i == $firstrow && $horf == 'H') {  // Top
										$yadj += $table['padding']['T'] + $table['border_details']['T']['w'];
										$hadj += $table['padding']['T'] + $table['border_details']['T']['w'];
									}
									if (($i == ($lastrow) || (isset($tablehf['rowspan']) && ($i + $tablehf['rowspan']) == ($lastrow + 1)) || (!isset($tablehf['rowspan']) && ($i + 1) == ($lastrow + 1))) && $horf == 'F') { // Bottom
										$hadj += $table['padding']['B'] + $table['border_details']['B']['w'];
									}
									if ($colctr == 1) {  // Left
										$xadj += $table['padding']['L'] + $table['border_details']['L']['w'];
										$wadj += $table['padding']['L'] + $table['border_details']['L']['w'];
									}
									if ($colctr == count($content[$i])) { // Right
										$wadj += $table['padding']['R'] + $table['border_details']['R']['w'];
									}
									$this->SetFColor($color);
									$this->Rect($x - $xadj, $y - $yadj, $w + $wadj, $h + $hadj, 'F');
								}
							}
						}
					}

					if ($table['empty_cells'] != 'hide' || !empty($textbuffer) || !$table['borders_separate']) {
						$paintcell = true;
					} else {
						$paintcell = false;
					}

					//Vertical align
					if ($R && INTVAL($R) > 0 && isset($va) && $va != 'B') {
						$va = 'B';
					}

					if (!isset($va) || empty($va) || $va == 'M')
						$this->y += ($h - $mih) / 2;
					elseif (isset($va) && $va == 'B')
						$this->y += $h - $mih;


					//TABLE ROW OR CELL FILL BGCOLOR
					$fill = 0;
					if (isset($tablehf['bgcolor']) && $tablehf['bgcolor'] && $tablehf['bgcolor'] != 'transparent') {
						$fill = $tablehf['bgcolor'];
						$leveladj = 6;
					} elseif (isset($content[$i][0]['trbgcolor']) && $content[$i][0]['trbgcolor'] && $content[$i][0]['trbgcolor'] != 'transparent') { // Row color
						$fill = $content[$i][0]['trbgcolor'];
						$leveladj = 3;
					}
					if ($fill && $paintcell) {
						$color = $this->ConvertColor($fill);
						if ($color) {
							if ($table['borders_separate']) {
								if ($this->ColActive) {
									$this->SetFColor($color);
									$this->Rect($x + ($table['border_spacing_H'] / 2), $y + ($table['border_spacing_V'] / 2), $w - $table['border_spacing_H'], $h - $table['border_spacing_V'], 'F');
								} else {
									$this->tableBackgrounds[$level * 9 + $leveladj][] = array('gradient' => false, 'x' => ($x + ($table['border_spacing_H'] / 2)), 'y' => ($y + ($table['border_spacing_V'] / 2)), 'w' => ($w - $table['border_spacing_H']), 'h' => ($h - $table['border_spacing_V']), 'col' => $color);
								}
							} else {
								if ($this->ColActive) {
									$this->SetFColor($color);
									$this->Rect($x, $y, $w, $h, 'F');
								} else {
									$this->tableBackgrounds[$level * 9 + $leveladj][] = array('gradient' => false, 'x' => $x, 'y' => $y, 'w' => $w, 'h' => $h, 'col' => $color);
								}
							}
						}
					}


					/* -- BACKGROUNDS -- */
					if (isset($tablehf['gradient']) && $tablehf['gradient'] && $paintcell) {
						$g = $this->grad->parseBackgroundGradient($tablehf['gradient']);
						if ($g) {
							if ($table['borders_separate']) {
								$px = $x + ($table['border_spacing_H'] / 2);
								$py = $y + ($table['border_spacing_V'] / 2);
								$pw = $w - $table['border_spacing_H'];
								$ph = $h - $table['border_spacing_V'];
							} else {
								$px = $x;
								$py = $y;
								$pw = $w;
								$ph = $h;
							}
							if ($this->ColActive) {
								$this->grad->Gradient($px, $py, $pw, $ph, $g['type'], $g['stops'], $g['colorspace'], $g['coords'], $g['extend']);
							} else {
								$this->tableBackgrounds[$level * 9 + 7][] = array('gradient' => true, 'x' => $px, 'y' => $py, 'w' => $pw, 'h' => $ph, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
							}
						}
					}

					if (isset($tablehf['background-image']) && $paintcell) {
						if ($tablehf['background-image']['gradient'] && preg_match('/(-moz-)*(repeating-)*(linear|radial)-gradient/', $tablehf['background-image']['gradient'])) {
							$g = $this->grad->parseMozGradient($tablehf['background-image']['gradient']);
							if ($g) {
								if ($table['borders_separate']) {
									$px = $x + ($table['border_spacing_H'] / 2);
									$py = $y + ($table['border_spacing_V'] / 2);
									$pw = $w - $table['border_spacing_H'];
									$ph = $h - $table['border_spacing_V'];
								} else {
									$px = $x;
									$py = $y;
									$pw = $w;
									$ph = $h;
								}
								if ($this->ColActive) {
									$this->grad->Gradient($px, $py, $pw, $ph, $g['type'], $g['stops'], $g['colorspace'], $g['coords'], $g['extend']);
								} else {
									$this->tableBackgrounds[$level * 9 + 7][] = array('gradient' => true, 'x' => $px, 'y' => $py, 'w' => $pw, 'h' => $ph, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
								}
							}
						} elseif ($tablehf['background-image']['image_id']) { // Background pattern
							$n = count($this->patterns) + 1;
							if ($table['borders_separate']) {
								$px = $x + ($table['border_spacing_H'] / 2);
								$py = $y + ($table['border_spacing_V'] / 2);
								$pw = $w - $table['border_spacing_H'];
								$ph = $h - $table['border_spacing_V'];
							} else {
								$px = $x;
								$py = $y;
								$pw = $w;
								$ph = $h;
							}
							if ($this->ColActive) {
								list($orig_w, $orig_h, $x_repeat, $y_repeat) = $this->_resizeBackgroundImage($tablehf['background-image']['orig_w'], $tablehf['background-image']['orig_h'], $pw, $ph, $tablehf['background-image']['resize'], $tablehf['background-image']['x_repeat'], $tablehf['background-image']['y_repeat']);
								$this->patterns[$n] = array('x' => $px, 'y' => $py, 'w' => $pw, 'h' => $ph, 'pgh' => $this->h, 'image_id' => $tablehf['background-image']['image_id'], 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $tablehf['background-image']['x_pos'], 'y_pos' => $tablehf['background-image']['y_pos'], 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'itype' => $tablehf['background-image']['itype']);
								if ($tablehf['background-image']['opacity'] > 0 && $tablehf['background-image']['opacity'] < 1) {
									$opac = $this->SetAlpha($tablehf['background-image']['opacity'], 'Normal', true);
								} else {
									$opac = '';
								}
								$this->_out(sprintf('q /Pattern cs /P%d scn %s %.3F %.3F %.3F %.3F re f Q', $n, $opac, $px * _MPDFK, ($this->h - $py) * _MPDFK, $pw * _MPDFK, -$ph * _MPDFK));
							} else {
								$this->tableBackgrounds[$level * 9 + 8][] = array('x' => $px, 'y' => $py, 'w' => $pw, 'h' => $ph, 'image_id' => $tablehf['background-image']['image_id'], 'orig_w' => $tablehf['background-image']['orig_w'], 'orig_h' => $tablehf['background-image']['orig_h'], 'x_pos' => $tablehf['background-image']['x_pos'], 'y_pos' => $tablehf['background-image']['y_pos'], 'x_repeat' => $tablehf['background-image']['x_repeat'], 'y_repeat' => $tablehf['background-image']['y_repeat'], 'clippath' => '', 'resize' => $tablehf['background-image']['resize'], 'opacity' => $tablehf['background-image']['opacity'], 'itype' => $tablehf['background-image']['itype']);
							}
						}
					}
					/* -- END BACKGROUNDS -- */

					//Cell Border
					if ($table['borders_separate'] && $paintcell && $border) {
						$this->_tableRect($x + ($table['border_spacing_H'] / 2) + ($border_details['L']['w'] / 2), $y + ($table['border_spacing_V'] / 2) + ($border_details['T']['w'] / 2), $w - $table['border_spacing_H'] - ($border_details['L']['w'] / 2) - ($border_details['R']['w'] / 2), $h - $table['border_spacing_V'] - ($border_details['T']['w'] / 2) - ($border_details['B']['w'] / 2), $border, $border_details, false, $table['borders_separate']);
					} elseif ($paintcell && $border) {
						$this->_tableRect($x, $y, $w, $h, $border, $border_details, true, $table['borders_separate']);   // true causes buffer
					}

					//Print cell content
					if (!empty($textbuffer)) {
						if ($horf == 'F' && preg_match('/{colsum([0-9]*)[_]*}/', $textbuffer[0][0], $m)) {
							$rep = sprintf("%01." . intval($m[1]) . "f", $this->colsums[$colctr - 1]);
							$textbuffer[0][0] = preg_replace('/{colsum[0-9_]*}/', $rep, $textbuffer[0][0]);
						}

						if ($R) {
							$cellPtSize = $textbuffer[0][11] / $this->shrin_k;
							if (!$cellPtSize) {
								$cellPtSize = $this->default_font_size;
							}
							$cellFontHeight = ($cellPtSize / _MPDFK);
							$opx = $this->x;
							$opy = $this->y;
							$angle = INTVAL($R);
							// Only allow 45 - 90 degrees (when bottom-aligned) or -90
							if ($angle > 90) {
								$angle = 90;
							} elseif ($angle > 0 && (isset($va) && $va != 'B')) {
								$angle = 90;
							} elseif ($angle > 0 && $angle < 45) {
								$angle = 45;
							} elseif ($angle < 0) {
								$angle = -90;
							}
							$offset = ((sin(deg2rad($angle))) * 0.37 * $cellFontHeight);
							if (isset($align) && $align == 'R') {
								$this->x += ($w) + ($offset) - ($cellFontHeight / 3) - ($padding['R'] + $border_details['R']['w']);
							} elseif (!isset($align) || $align == 'C') {
								$this->x += ($w / 2) + ($offset);
							} else {
								$this->x += ($offset) + ($cellFontHeight / 3) + ($padding['L'] + $border_details['L']['w']);
							}
							$str = '';
							foreach ($tablehf['textbuffer'] AS $t) {
								$str .= $t[0] . ' ';
							}
							$str = rtrim($str);

							if (!isset($va) || $va == 'M') {
								$this->y -= ($h - $mih) / 2; //Undo what was added earlier VERTICAL ALIGN
								if ($angle > 0) {
									$this->y += (($h - $mih) / 2) + ($padding['T'] + $border_details['T']['w']) + ($mih - ($padding['T'] + $border_details['T']['w'] + $border_details['B']['w'] + $padding['B']));
								} elseif ($angle < 0) {
									$this->y += (($h - $mih) / 2) + ($padding['T'] + $border_details['T']['w']);
								}
							} elseif (isset($va) && $va == 'B') {
								$this->y -= $h - $mih; //Undo what was added earlier VERTICAL ALIGN
								if ($angle > 0) {
									$this->y += $h - ($border_details['B']['w'] + $padding['B']);
								} elseif ($angle < 0) {
									$this->y += $h - $mih + ($padding['T'] + $border_details['T']['w']);
								}
							} elseif (isset($va) && $va == 'T') {
								if ($angle > 0) {
									$this->y += $mih - ($border_details['B']['w'] + $padding['B']);
								} elseif ($angle < 0) {
									$this->y += ($padding['T'] + $border_details['T']['w']);
								}
							}

							$this->Rotate($angle, $this->x, $this->y);
							$s_fs = $this->FontSizePt;
							$s_f = $this->FontFamily;
							$s_st = $this->FontStyle;
							if (!empty($textbuffer[0][3])) { //Font Color
								$cor = $textbuffer[0][3];
								$this->SetTColor($cor);
							}
							$this->SetFont($textbuffer[0][4], $textbuffer[0][2], $cellPtSize, true, true);

							$this->magic_reverse_dir($str, $this->directionality, $textbuffer[0][18]);
							$this->Text($this->x, $this->y, $str, $textbuffer[0][18], $textbuffer[0][8]); // textvar
							$this->Rotate(0);
							$this->SetFont($s_f, $s_st, $s_fs, true, true);
							$this->SetTColor(0);
							$this->x = $opx;
							$this->y = $opy;
						} else {
							if ($table['borders_separate']) { // NB twice border width
								$xadj = $border_details['L']['w'] + $padding['L'] + ($table['border_spacing_H'] / 2);
								$wadj = $border_details['L']['w'] + $border_details['R']['w'] + $padding['L'] + $padding['R'] + $table['border_spacing_H'];
								$yadj = $border_details['T']['w'] + $padding['T'] + ($table['border_spacing_H'] / 2);
							} else {
								$xadj = $border_details['L']['w'] / 2 + $padding['L'];
								$wadj = ($border_details['L']['w'] + $border_details['R']['w']) / 2 + $padding['L'] + $padding['R'];
								$yadj = $border_details['T']['w'] / 2 + $padding['T'];
							}

							$this->divwidth = $w - ($wadj);
							$this->x += $xadj;
							$this->y += $yadj;
							$this->printbuffer($textbuffer, '', true, false, $direction);
						}
					}
					$textbuffer = array();

					/* -- BACKGROUNDS -- */
					if (!$this->ColActive) {
						if (isset($content[$i][0]['trgradients']) && ($colctr == 1 || $table['borders_separate'])) {
							$g = $this->grad->parseBackgroundGradient($content[$i][0]['trgradients']);
							if ($g) {
								$gx = $x0;
								$gy = $y;
								$gh = $h;
								$gw = $table['w'] - ($table['max_cell_border_width']['L'] / 2) - ($table['max_cell_border_width']['R'] / 2) - $table['margin']['L'] - $table['margin']['R'];
								if ($table['borders_separate']) {
									$gw -= ($table['padding']['L'] + $table['border_details']['L']['w'] + $table['padding']['R'] + $table['border_details']['R']['w'] + $table['border_spacing_H']);
									$clx = $x + ($table['border_spacing_H'] / 2);
									$cly = $y + ($table['border_spacing_V'] / 2);
									$clw = $w - $table['border_spacing_H'];
									$clh = $h - $table['border_spacing_V'];
									// Set clipping path
									$s = $this->_setClippingPath($clx, $cly, $clw, $clh); // mPDF 6
									$this->tableBackgrounds[$level * 9 + 4][] = array('gradient' => true, 'x' => $gx + ($table['border_spacing_H'] / 2), 'y' => $gy + ($table['border_spacing_V'] / 2), 'w' => $gw - $table['border_spacing_V'], 'h' => $gh - $table['border_spacing_H'], 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => $s);
								} else {
									$this->tableBackgrounds[$level * 9 + 4][] = array('gradient' => true, 'x' => $gx, 'y' => $gy, 'w' => $gw, 'h' => $gh, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
								}
							}
						}

						if (isset($content[$i][0]['trbackground-images']) && ($colctr == 1 || $table['borders_separate'])) {
							if ($content[$i][0]['trbackground-images']['gradient'] && preg_match('/(-moz-)*(repeating-)*(linear|radial)-gradient/', $content[$i][0]['trbackground-images']['gradient'])) {
								$g = $this->grad->parseMozGradient($content[$i][0]['trbackground-images']['gradient']);
								if ($g) {
									$gx = $x0;
									$gy = $y;
									$gh = $h;
									$gw = $table['w'] - ($table['max_cell_border_width']['L'] / 2) - ($table['max_cell_border_width']['R'] / 2) - $table['margin']['L'] - $table['margin']['R'];
									if ($table['borders_separate']) {
										$gw -= ($table['padding']['L'] + $table['border_details']['L']['w'] + $table['padding']['R'] + $table['border_details']['R']['w'] + $table['border_spacing_H']);
										$clx = $x + ($table['border_spacing_H'] / 2);
										$cly = $y + ($table['border_spacing_V'] / 2);
										$clw = $w - $table['border_spacing_H'];
										$clh = $h - $table['border_spacing_V'];
										// Set clipping path
										$s = $this->_setClippingPath($clx, $cly, $clw, $clh); // mPDF 6
										$this->tableBackgrounds[$level * 9 + 4][] = array('gradient' => true, 'x' => $gx + ($table['border_spacing_H'] / 2), 'y' => $gy + ($table['border_spacing_V'] / 2), 'w' => $gw - $table['border_spacing_V'], 'h' => $gh - $table['border_spacing_H'], 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => $s);
									} else {
										$this->tableBackgrounds[$level * 9 + 4][] = array('gradient' => true, 'x' => $gx, 'y' => $gy, 'w' => $gw, 'h' => $gh, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
									}
								}
							} else {
								$image_id = $content[$i][0]['trbackground-images']['image_id'];
								$orig_w = $content[$i][0]['trbackground-images']['orig_w'];
								$orig_h = $content[$i][0]['trbackground-images']['orig_h'];
								$x_pos = $content[$i][0]['trbackground-images']['x_pos'];
								$y_pos = $content[$i][0]['trbackground-images']['y_pos'];
								$x_repeat = $content[$i][0]['trbackground-images']['x_repeat'];
								$y_repeat = $content[$i][0]['trbackground-images']['y_repeat'];
								$resize = $content[$i][0]['trbackground-images']['resize'];
								$opacity = $content[$i][0]['trbackground-images']['opacity'];
								$itype = $content[$i][0]['trbackground-images']['itype'];

								$clippath = '';
								$gx = $x0;
								$gy = $y;
								$gh = $h;
								$gw = $table['w'] - ($table['max_cell_border_width']['L'] / 2) - ($table['max_cell_border_width']['R'] / 2) - $table['margin']['L'] - $table['margin']['R'];
								if ($table['borders_separate']) {
									$gw -= ($table['padding']['L'] + $table['border_details']['L']['w'] + $table['padding']['R'] + $table['border_details']['R']['w'] + $table['border_spacing_H']);
									$clx = $x + ($table['border_spacing_H'] / 2);
									$cly = $y + ($table['border_spacing_V'] / 2);
									$clw = $w - $table['border_spacing_H'];
									$clh = $h - $table['border_spacing_V'];
									// Set clipping path
									$s = $this->_setClippingPath($clx, $cly, $clw, $clh); // mPDF 6
									$this->tableBackgrounds[$level * 9 + 5][] = array('x' => $gx + ($table['border_spacing_H'] / 2), 'y' => $gy + ($table['border_spacing_V'] / 2), 'w' => $gw - $table['border_spacing_V'], 'h' => $gh - $table['border_spacing_H'], 'image_id' => $image_id, 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $x_pos, 'y_pos' => $y_pos, 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'clippath' => $s, 'resize' => $resize, 'opacity' => $opacity, 'itype' => $itype);
								} else {
									$this->tableBackgrounds[$level * 9 + 5][] = array('x' => $gx, 'y' => $gy, 'w' => $gw, 'h' => $gh, 'image_id' => $image_id, 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $x_pos, 'y_pos' => $y_pos, 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'clippath' => '', 'resize' => $resize, 'opacity' => $opacity, 'itype' => $itype);
								}
							}
						}
					}
					/* -- END BACKGROUNDS -- */

					// TABLE BORDER - if separate OR collapsed and only table border
					if (($table['borders_separate'] || ($this->simpleTables && !$table['simple']['border'])) && $table['border']) {
						$halfspaceL = $table['padding']['L'] + ($table['border_spacing_H'] / 2);
						$halfspaceR = $table['padding']['R'] + ($table['border_spacing_H'] / 2);
						$halfspaceT = $table['padding']['T'] + ($table['border_spacing_V'] / 2);
						$halfspaceB = $table['padding']['B'] + ($table['border_spacing_V'] / 2);
						$tbx = $x;
						$tby = $y;
						$tbw = $w;
						$tbh = $h;
						$tab_bord = 0;
						$corner = '';
						if ($i == $firstrow && $horf == 'H') {  // Top
							$tby -= $halfspaceT + ($table['border_details']['T']['w'] / 2);
							$tbh += $halfspaceT + ($table['border_details']['T']['w'] / 2);
							$this->setBorder($tab_bord, _BORDER_TOP);
							$corner .= 'T';
						}
						if (($i == ($lastrow) || (isset($tablehf['rowspan']) && ($i + $tablehf['rowspan']) == ($lastrow + 1))) && $horf == 'F') { // Bottom
							$tbh += $halfspaceB + ($table['border_details']['B']['w'] / 2);
							$this->setBorder($tab_bord, _BORDER_BOTTOM);
							$corner .= 'B';
						}
						if ($colctr == 1 && $firstSpread) { // Left
							$tbx -= $halfspaceL + ($table['border_details']['L']['w'] / 2);
							$tbw += $halfspaceL + ($table['border_details']['L']['w'] / 2);
							$this->setBorder($tab_bord, _BORDER_LEFT);
							$corner .= 'L';
						}
						if ($colctr == count($content[$i]) && $finalSpread) { // Right
							$tbw += $halfspaceR + ($table['border_details']['R']['w'] / 2);
							$this->setBorder($tab_bord, _BORDER_RIGHT);
							$corner .= 'R';
						}
						$this->_tableRect($tbx, $tby, $tbw, $tbh, $tab_bord, $table['border_details'], false, $table['borders_separate'], 'table', $corner, $table['border_spacing_V'], $table['border_spacing_H']);
					}
				}// end column $content
				$this->y = $y + $h; //Update y coordinate
			}// end row $i
			unset($table);
			$this->colsums = array();
		}
	}

	/* -- END TABLES -- */

	function SetHTMLHeader($header = '', $OE = '', $write = false)
	{

		$height = 0;
		if (is_array($header) && isset($header['html']) && $header['html']) {
			$Hhtml = $header['html'];
			if ($this->setAutoTopMargin) {
				if (isset($header['h'])) {
					$height = $header['h'];
				} else {
					$height = $this->_gethtmlheight($Hhtml);
				}
			}
		} elseif (!is_array($header) && $header) {
			$Hhtml = $header;
			if ($this->setAutoTopMargin) {
				$height = $this->_gethtmlheight($Hhtml);
			}
		} else {
			$Hhtml = '';
		}

		if ($OE != 'E') {
			$OE = 'O';
		}
		if ($OE == 'E') {

			if ($Hhtml) {
				$this->HTMLHeaderE['html'] = $Hhtml;
				$this->HTMLHeaderE['h'] = $height;
			} else {
				$this->HTMLHeaderE = '';
			}
		} else {

			if ($Hhtml) {
				$this->HTMLHeader['html'] = $Hhtml;
				$this->HTMLHeader['h'] = $height;
			} else {
				$this->HTMLHeader = '';
			}
		}
		if (!$this->mirrorMargins && $OE == 'E') {
			return;
		}
		if ($Hhtml == '') {
			return;
		}

		if ($this->setAutoTopMargin == 'pad') {
			$this->tMargin = $this->margin_header + $height + $this->orig_tMargin;
			if (isset($this->saveHTMLHeader[$this->page][$OE]['mt'])) {
				$this->saveHTMLHeader[$this->page][$OE]['mt'] = $this->tMargin;
			}
		} elseif ($this->setAutoTopMargin == 'stretch') {
			$this->tMargin = max($this->orig_tMargin, $this->margin_header + $height + $this->autoMarginPadding);
			if (isset($this->saveHTMLHeader[$this->page][$OE]['mt'])) {
				$this->saveHTMLHeader[$this->page][$OE]['mt'] = $this->tMargin;
			}
		}
		if ($write && $this->state != 0 && (($this->mirrorMargins && $OE == 'E' && ($this->page) % 2 == 0) || ($this->mirrorMargins && $OE != 'E' && ($this->page) % 2 == 1) || !$this->mirrorMargins)) {
			$this->writeHTMLHeaders();
		}
	}

	function SetHTMLFooter($footer = '', $OE = '')
	{
		$height = 0;
		if (is_array($footer) && isset($footer['html']) && $footer['html']) {
			$Fhtml = $footer['html'];
			if ($this->setAutoBottomMargin) {
				if (isset($footer['h'])) {
					$height = $footer['h'];
				} else {
					$height = $this->_gethtmlheight($Fhtml);
				}
			}
		} elseif (!is_array($footer) && $footer) {
			$Fhtml = $footer;
			if ($this->setAutoBottomMargin) {
				$height = $this->_gethtmlheight($Fhtml);
			}
		} else {
			$Fhtml = '';
		}

		if ($OE != 'E') {
			$OE = 'O';
		}
		if ($OE == 'E') {

			if ($Fhtml) {
				$this->HTMLFooterE['html'] = $Fhtml;
				$this->HTMLFooterE['h'] = $height;
			} else {
				$this->HTMLFooterE = '';
			}
		} else {

			if ($Fhtml) {
				$this->HTMLFooter['html'] = $Fhtml;
				$this->HTMLFooter['h'] = $height;
			} else {
				$this->HTMLFooter = '';
			}
		}
		if (!$this->mirrorMargins && $OE == 'E') {
			return;
		}
		if ($Fhtml == '') {
			return false;
		}

		if ($this->setAutoBottomMargin == 'pad') {
			$this->bMargin = $this->margin_footer + $height + $this->orig_bMargin;
			$this->PageBreakTrigger = $this->h - $this->bMargin;
			if (isset($this->saveHTMLHeader[$this->page][$OE]['mb'])) {
				$this->saveHTMLHeader[$this->page][$OE]['mb'] = $this->bMargin;
			}
		} elseif ($this->setAutoBottomMargin == 'stretch') {
			$this->bMargin = max($this->orig_bMargin, $this->margin_footer + $height + $this->autoMarginPadding);
			$this->PageBreakTrigger = $this->h - $this->bMargin;
			if (isset($this->saveHTMLHeader[$this->page][$OE]['mb'])) {
				$this->saveHTMLHeader[$this->page][$OE]['mb'] = $this->bMargin;
			}
		}
	}

	function _getHtmlHeight($html)
	{
		$save_state = $this->state;
		if ($this->state == 0) {
			$this->AddPage($this->CurOrientation);
		}
		$this->state = 2;
		$this->Reset();
		$this->pageoutput[$this->page] = array();
		$save_x = $this->x;
		$save_y = $this->y;
		$this->x = $this->lMargin;
		$this->y = $this->margin_header;
		$html = str_replace('{PAGENO}', $this->pagenumPrefix . $this->docPageNum($this->page) . $this->pagenumSuffix, $html);
		$html = str_replace($this->aliasNbPgGp, $this->nbpgPrefix . $this->docPageNumTotal($this->page) . $this->nbpgSuffix, $html);
		$html = str_replace($this->aliasNbPg, $this->page, $html);
		$html = preg_replace_callback('/\{DATE\s+(.*?)\}/', array($this, 'date_callback'), $html); // mPDF 5.7
		$this->HTMLheaderPageLinks = array();
		$this->HTMLheaderPageAnnots = array();
		$this->HTMLheaderPageForms = array();
		$savepb = $this->pageBackgrounds;
		$this->writingHTMLheader = true;
		$this->WriteHTML($html, 4); // parameter 4 saves output to $this->headerbuffer
		$this->writingHTMLheader = false;
		$h = ($this->y - $this->margin_header);
		$this->Reset();
		// mPDF 5.7.2 - Clear in case Float used in Header/Footer
		$this->blk[0]['blockContext'] = 0;
		$this->blk[0]['float_endpos'] = 0;

		$this->pageoutput[$this->page] = array();
		$this->headerbuffer = '';
		$this->pageBackgrounds = $savepb;
		$this->x = $save_x;
		$this->y = $save_y;
		$this->state = $save_state;
		if ($save_state == 0) {
			unset($this->pages[1]);
			$this->page = 0;
		}
		return $h;
	}

	// Called internally from Header
	function writeHTMLHeaders()
	{

		if ($this->mirrorMargins && ($this->page) % 2 == 0) {
			$OE = 'E';
		} // EVEN
		else {
			$OE = 'O';
		}
		if ($OE == 'E') {
			$this->saveHTMLHeader[$this->page][$OE]['html'] = $this->HTMLHeaderE['html'];
		} else {
			$this->saveHTMLHeader[$this->page][$OE]['html'] = $this->HTMLHeader['html'];
		}
		if ($this->forcePortraitHeaders && $this->CurOrientation == 'L' && $this->CurOrientation != $this->DefOrientation) {
			$this->saveHTMLHeader[$this->page][$OE]['rotate'] = true;
			$this->saveHTMLHeader[$this->page][$OE]['ml'] = $this->tMargin;
			$this->saveHTMLHeader[$this->page][$OE]['mr'] = $this->bMargin;
			$this->saveHTMLHeader[$this->page][$OE]['mh'] = $this->margin_header;
			$this->saveHTMLHeader[$this->page][$OE]['mf'] = $this->margin_footer;
			$this->saveHTMLHeader[$this->page][$OE]['pw'] = $this->h;
			$this->saveHTMLHeader[$this->page][$OE]['ph'] = $this->w;
		} else {
			$this->saveHTMLHeader[$this->page][$OE]['ml'] = $this->lMargin;
			$this->saveHTMLHeader[$this->page][$OE]['mr'] = $this->rMargin;
			$this->saveHTMLHeader[$this->page][$OE]['mh'] = $this->margin_header;
			$this->saveHTMLHeader[$this->page][$OE]['mf'] = $this->margin_footer;
			$this->saveHTMLHeader[$this->page][$OE]['pw'] = $this->w;
			$this->saveHTMLHeader[$this->page][$OE]['ph'] = $this->h;
		}
	}

	function writeHTMLFooters()
	{

		if ($this->mirrorMargins && ($this->page) % 2 == 0) {
			$OE = 'E';
		} // EVEN
		else {
			$OE = 'O';
		}
		if ($OE == 'E') {
			$this->saveHTMLFooter[$this->page][$OE]['html'] = $this->HTMLFooterE['html'];
		} else {
			$this->saveHTMLFooter[$this->page][$OE]['html'] = $this->HTMLFooter['html'];
		}
		if ($this->forcePortraitHeaders && $this->CurOrientation == 'L' && $this->CurOrientation != $this->DefOrientation) {
			$this->saveHTMLFooter[$this->page][$OE]['rotate'] = true;
			$this->saveHTMLFooter[$this->page][$OE]['ml'] = $this->tMargin;
			$this->saveHTMLFooter[$this->page][$OE]['mr'] = $this->bMargin;
			$this->saveHTMLFooter[$this->page][$OE]['mt'] = $this->rMargin;
			$this->saveHTMLFooter[$this->page][$OE]['mb'] = $this->lMargin;
			$this->saveHTMLFooter[$this->page][$OE]['mh'] = $this->margin_header;
			$this->saveHTMLFooter[$this->page][$OE]['mf'] = $this->margin_footer;
			$this->saveHTMLFooter[$this->page][$OE]['pw'] = $this->h;
			$this->saveHTMLFooter[$this->page][$OE]['ph'] = $this->w;
		} else {
			$this->saveHTMLFooter[$this->page][$OE]['ml'] = $this->lMargin;
			$this->saveHTMLFooter[$this->page][$OE]['mr'] = $this->rMargin;
			$this->saveHTMLFooter[$this->page][$OE]['mt'] = $this->tMargin;
			$this->saveHTMLFooter[$this->page][$OE]['mb'] = $this->bMargin;
			$this->saveHTMLFooter[$this->page][$OE]['mh'] = $this->margin_header;
			$this->saveHTMLFooter[$this->page][$OE]['mf'] = $this->margin_footer;
			$this->saveHTMLFooter[$this->page][$OE]['pw'] = $this->w;
			$this->saveHTMLFooter[$this->page][$OE]['ph'] = $this->h;
		}
	}

	// mPDF 6
	function _shareHeaderFooterWidth($cl, $cc, $cr)
	{ // mPDF 6
		$l = mb_strlen($cl, 'UTF-8');
		$c = mb_strlen($cc, 'UTF-8');
		$r = mb_strlen($cr, 'UTF-8');
		$s = max($l, $r);
		$tw = $c + 2 * $s;
		if ($tw > 0) {
			return array(intval($s * 100 / $tw), intval($c * 100 / $tw), intval($s * 100 / $tw));
		} else {
			return array(33, 33, 33);
		}
	}

	// mPDF 6
	// Create an HTML header/footer from array (non-HTML header/footer)
	function _createHTMLheaderFooter($arr, $hf)
	{
		$lContent = (isset($arr['L']['content']) ? $arr['L']['content'] : '');
		$cContent = (isset($arr['C']['content']) ? $arr['C']['content'] : '');
		$rContent = (isset($arr['R']['content']) ? $arr['R']['content'] : '');
		list($lw, $cw, $rw) = $this->_shareHeaderFooterWidth($lContent, $cContent, $rContent);
		if ($hf == 'H') {
			$valign = 'bottom';
			$vpadding = '0 0 ' . $this->header_line_spacing . 'em 0';
		} else {
			$valign = 'top';
			$vpadding = '' . $this->footer_line_spacing . 'em 0 0 0';
		}
		if ($this->directionality == 'rtl') { // table columns get reversed so need different text-alignment
			$talignL = 'right';
			$talignR = 'left';
		} else {
			$talignL = 'left';
			$talignR = 'right';
		}
		$html = '<table width="100%" style="border-collapse: collapse; margin: 0; vertical-align: ' . $valign . '; color: #000000; ';
		if (isset($arr['line']) && $arr['line']) {
			$html .= ' border-' . $valign . ': 0.1mm solid #000000;';
		}
		$html .= '">';
		$html .= '<tr>';
		$html .= '<td width="' . $lw . '%" style="padding: ' . $vpadding . '; text-align: ' . $talignL . '; ';
		if (isset($arr['L']['font-family'])) {
			$html .= ' font-family: ' . $arr['L']['font-family'] . ';';
		}
		if (isset($arr['L']['color'])) {
			$html .= ' color: ' . $arr['L']['color'] . ';';
		}
		if (isset($arr['L']['font-size'])) {
			$html .= ' font-size: ' . $arr['L']['font-size'] . 'pt;';
		}
		if (isset($arr['L']['font-style'])) {
			if ($arr['L']['font-style'] == 'B' || $arr['L']['font-style'] == 'BI') {
				$html .= ' font-weight: bold;';
			}
			if ($arr['L']['font-style'] == 'I' || $arr['L']['font-style'] == 'BI') {
				$html .= ' font-style: italic;';
			}
		}
		$html .= '">' . $lContent . '</td>';
		$html .= '<td width="' . $cw . '%" style="padding: ' . $vpadding . '; text-align: center; ';
		if (isset($arr['C']['font-family'])) {
			$html .= ' font-family: ' . $arr['C']['font-family'] . ';';
		}
		if (isset($arr['C']['color'])) {
			$html .= ' color: ' . $arr['C']['color'] . ';';
		}
		if (isset($arr['C']['font-size'])) {
			$html .= ' font-size: ' . $arr['L']['font-size'] . 'pt;';
		}
		if (isset($arr['C']['font-style'])) {
			if ($arr['C']['font-style'] == 'B' || $arr['C']['font-style'] == 'BI') {
				$html .= ' font-weight: bold;';
			}
			if ($arr['C']['font-style'] == 'I' || $arr['C']['font-style'] == 'BI') {
				$html .= ' font-style: italic;';
			}
		}
		$html .= '">' . $cContent . '</td>';
		$html .= '<td width="' . $rw . '%" style="padding: ' . $vpadding . '; text-align: ' . $talignR . '; ';
		if (isset($arr['R']['font-family'])) {
			$html .= ' font-family: ' . $arr['R']['font-family'] . ';';
		}
		if (isset($arr['R']['color'])) {
			$html .= ' color: ' . $arr['R']['color'] . ';';
		}
		if (isset($arr['R']['font-size'])) {
			$html .= ' font-size: ' . $arr['R']['font-size'] . 'pt;';
		}
		if (isset($arr['R']['font-style'])) {
			if ($arr['R']['font-style'] == 'B' || $arr['R']['font-style'] == 'BI') {
				$html .= ' font-weight: bold;';
			}
			if ($arr['R']['font-style'] == 'I' || $arr['R']['font-style'] == 'BI') {
				$html .= ' font-style: italic;';
			}
		}
		$html .= '">' . $rContent . '</td>';
		$html .= '</tr></table>';
		return $html;
	}

	function DefHeaderByName($name, $arr)
	{
		if (!$name) {
			$name = '_nonhtmldefault';
		}
		$html = $this->_createHTMLheaderFooter($arr, 'H');

		$this->pageHTMLheaders[$name]['html'] = $html;
		$this->pageHTMLheaders[$name]['h'] = $this->_gethtmlheight($html);
	}

	function DefFooterByName($name, $arr)
	{
		if (!$name) {
			$name = '_nonhtmldefault';
		}
		$html = $this->_createHTMLheaderFooter($arr, 'F');

		$this->pageHTMLfooters[$name]['html'] = $html;
		$this->pageHTMLfooters[$name]['h'] = $this->_gethtmlheight($html);
	}

	function SetHeaderByName($name, $side = 'O', $write = false)
	{
		if (!$name) {
			$name = '_nonhtmldefault';
		}
		$this->SetHTMLHeader($this->pageHTMLheaders[$name], $side, $write);
	}

	function SetFooterByName($name, $side = 'O')
	{
		if (!$name) {
			$name = '_nonhtmldefault';
		}
		$this->SetHTMLFooter($this->pageHTMLfooters[$name], $side);
	}

	function DefHTMLHeaderByName($name, $html)
	{
		if (!$name) {
			$name = '_default';
		}

		$this->pageHTMLheaders[$name]['html'] = $html;
		$this->pageHTMLheaders[$name]['h'] = $this->_gethtmlheight($html);
	}

	function DefHTMLFooterByName($name, $html)
	{
		if (!$name) {
			$name = '_default';
		}

		$this->pageHTMLfooters[$name]['html'] = $html;
		$this->pageHTMLfooters[$name]['h'] = $this->_gethtmlheight($html);
	}

	function SetHTMLHeaderByName($name, $side = 'O', $write = false)
	{
		if (!$name) {
			$name = '_default';
		}
		$this->SetHTMLHeader($this->pageHTMLheaders[$name], $side, $write);
	}

	function SetHTMLFooterByName($name, $side = 'O')
	{
		if (!$name) {
			$name = '_default';
		}
		$this->SetHTMLFooter($this->pageHTMLfooters[$name], $side);
	}

	function SetHeader($Harray = array(), $side = '', $write = false)
	{
		$oddhtml = '';
		$evenhtml = '';
		if (is_string($Harray)) {
			if (strlen($Harray) == 0) {
				$oddhtml = '';
				$evenhtml = '';
			} elseif (strpos($Harray, '|') !== false) {
				$hdet = explode('|', $Harray);
				list($lw, $cw, $rw) = $this->_shareHeaderFooterWidth($hdet[0], $hdet[1], $hdet[2]);
				$oddhtml = '<table width="100%" style="border-collapse: collapse; margin: 0; vertical-align: bottom; color: #000000; ';
				if ($this->defaultheaderfontsize) {
					$oddhtml .= ' font-size: ' . $this->defaultheaderfontsize . 'pt;';
				}
				if ($this->defaultheaderfontstyle) {
					if ($this->defaultheaderfontstyle == 'B' || $this->defaultheaderfontstyle == 'BI') {
						$oddhtml .= ' font-weight: bold;';
					}
					if ($this->defaultheaderfontstyle == 'I' || $this->defaultheaderfontstyle == 'BI') {
						$oddhtml .= ' font-style: italic;';
					}
				}
				if ($this->defaultheaderline) {
					$oddhtml .= ' border-bottom: 0.1mm solid #000000;';
				}
				$oddhtml .= '">';
				$oddhtml .= '<tr>';
				$oddhtml .= '<td width="' . $lw . '%" style="padding: 0 0 ' . $this->header_line_spacing . 'em 0; text-align: left; ">' . $hdet[0] . '</td>';
				$oddhtml .= '<td width="' . $cw . '%" style="padding: 0 0 ' . $this->header_line_spacing . 'em 0; text-align: center; ">' . $hdet[1] . '</td>';
				$oddhtml .= '<td width="' . $rw . '%" style="padding: 0 0 ' . $this->header_line_spacing . 'em 0; text-align: right; ">' . $hdet[2] . '</td>';
				$oddhtml .= '</tr></table>';

				$evenhtml = '<table width="100%" style="border-collapse: collapse; margin: 0; vertical-align: bottom; color: #000000; ';
				if ($this->defaultheaderfontsize) {
					$evenhtml .= ' font-size: ' . $this->defaultheaderfontsize . 'pt;';
				}
				if ($this->defaultheaderfontstyle) {
					if ($this->defaultheaderfontstyle == 'B' || $this->defaultheaderfontstyle == 'BI') {
						$evenhtml .= ' font-weight: bold;';
					}
					if ($this->defaultheaderfontstyle == 'I' || $this->defaultheaderfontstyle == 'BI') {
						$evenhtml .= ' font-style: italic;';
					}
				}
				if ($this->defaultheaderline) {
					$evenhtml .= ' border-bottom: 0.1mm solid #000000;';
				}
				$evenhtml .= '">';
				$evenhtml .= '<tr>';
				$evenhtml .= '<td width="' . $rw . '%" style="padding: 0 0 ' . $this->header_line_spacing . 'em 0; text-align: left; ">' . $hdet[2] . '</td>';
				$evenhtml .= '<td width="' . $cw . '%" style="padding: 0 0 ' . $this->header_line_spacing . 'em 0; text-align: center; ">' . $hdet[1] . '</td>';
				$evenhtml .= '<td width="' . $lw . '%" style="padding: 0 0 ' . $this->header_line_spacing . 'em 0; text-align: right; ">' . $hdet[0] . '</td>';
				$evenhtml .= '</tr></table>';
			} else {
				$oddhtml = '<div style="margin: 0; color: #000000; ';
				if ($this->defaultheaderfontsize) {
					$oddhtml .= ' font-size: ' . $this->defaultheaderfontsize . 'pt;';
				}
				if ($this->defaultheaderfontstyle) {
					if ($this->defaultheaderfontstyle == 'B' || $this->defaultheaderfontstyle == 'BI') {
						$oddhtml .= ' font-weight: bold;';
					}
					if ($this->defaultheaderfontstyle == 'I' || $this->defaultheaderfontstyle == 'BI') {
						$oddhtml .= ' font-style: italic;';
					}
				}
				if ($this->defaultheaderline) {
					$oddhtml .= ' border-bottom: 0.1mm solid #000000;';
				}
				$oddhtml .= 'text-align: right; ">' . $Harray . '</div>';

				$evenhtml = '<div style="margin: 0; color: #000000; ';
				if ($this->defaultheaderfontsize) {
					$evenhtml .= ' font-size: ' . $this->defaultheaderfontsize . 'pt;';
				}
				if ($this->defaultheaderfontstyle) {
					if ($this->defaultheaderfontstyle == 'B' || $this->defaultheaderfontstyle == 'BI') {
						$evenhtml .= ' font-weight: bold;';
					}
					if ($this->defaultheaderfontstyle == 'I' || $this->defaultheaderfontstyle == 'BI') {
						$evenhtml .= ' font-style: italic;';
					}
				}
				if ($this->defaultheaderline) {
					$evenhtml .= ' border-bottom: 0.1mm solid #000000;';
				}
				$evenhtml .= 'text-align: left; ">' . $Harray . '</div>';
			}
		} elseif (is_array($Harray) && !empty($Harray)) {
			if ($side == 'O') {
				$odd = $Harray;
			} elseif ($side == 'E') {
				$even = $Harray;
			} else {
				$odd = $Harray['odd'];
				$even = $Harray['even'];
			}
			$oddhtml = $this->_createHTMLheaderFooter($odd, 'H');

			$evenhtml = $this->_createHTMLheaderFooter($even, 'H');
		}

		if ($side == 'E') {
			$this->SetHTMLHeader($evenhtml, 'E', $write);
		} elseif ($side == 'O') {
			$this->SetHTMLHeader($oddhtml, 'O', $write);
		} else {
			$this->SetHTMLHeader($oddhtml, 'O', $write);
			$this->SetHTMLHeader($evenhtml, 'E', $write);
		}
	}

	function SetFooter($Farray = array(), $side = '')
	{
		$oddhtml = '';
		$evenhtml = '';
		if (is_string($Farray)) {
			if (strlen($Farray) == 0) {
				$oddhtml = '';
				$evenhtml = '';
			} elseif (strpos($Farray, '|') !== false) {
				$hdet = explode('|', $Farray);
				$oddhtml = '<table width="100%" style="border-collapse: collapse; margin: 0; vertical-align: top; color: #000000; ';
				if ($this->defaultfooterfontsize) {
					$oddhtml .= ' font-size: ' . $this->defaultfooterfontsize . 'pt;';
				}
				if ($this->defaultfooterfontstyle) {
					if ($this->defaultfooterfontstyle == 'B' || $this->defaultfooterfontstyle == 'BI') {
						$oddhtml .= ' font-weight: bold;';
					}
					if ($this->defaultfooterfontstyle == 'I' || $this->defaultfooterfontstyle == 'BI') {
						$oddhtml .= ' font-style: italic;';
					}
				}
				if ($this->defaultfooterline) {
					$oddhtml .= ' border-top: 0.1mm solid #000000;';
				}
				$oddhtml .= '">';
				$oddhtml .= '<tr>';
				$oddhtml .= '<td width="33%" style="padding: ' . $this->footer_line_spacing . 'em 0 0 0; text-align: left; ">' . $hdet[0] . '</td>';
				$oddhtml .= '<td width="33%" style="padding: ' . $this->footer_line_spacing . 'em 0 0 0; text-align: center; ">' . $hdet[1] . '</td>';
				$oddhtml .= '<td width="33%" style="padding: ' . $this->footer_line_spacing . 'em 0 0 0; text-align: right; ">' . $hdet[2] . '</td>';
				$oddhtml .= '</tr></table>';

				$evenhtml = '<table width="100%" style="border-collapse: collapse; margin: 0; vertical-align: top; color: #000000; ';
				if ($this->defaultfooterfontsize) {
					$evenhtml .= ' font-size: ' . $this->defaultfooterfontsize . 'pt;';
				}
				if ($this->defaultfooterfontstyle) {
					if ($this->defaultfooterfontstyle == 'B' || $this->defaultfooterfontstyle == 'BI') {
						$evenhtml .= ' font-weight: bold;';
					}
					if ($this->defaultfooterfontstyle == 'I' || $this->defaultfooterfontstyle == 'BI') {
						$evenhtml .= ' font-style: italic;';
					}
				}
				if ($this->defaultfooterline) {
					$evenhtml .= ' border-top: 0.1mm solid #000000;';
				}
				$evenhtml .= '">';
				$evenhtml .= '<tr>';
				$evenhtml .= '<td width="33%" style="padding: ' . $this->footer_line_spacing . 'em 0 0 0; text-align: left; ">' . $hdet[2] . '</td>';
				$evenhtml .= '<td width="33%" style="padding: ' . $this->footer_line_spacing . 'em 0 0 0; text-align: center; ">' . $hdet[1] . '</td>';
				$evenhtml .= '<td width="33%" style="padding: ' . $this->footer_line_spacing . 'em 0 0 0; text-align: right; ">' . $hdet[0] . '</td>';
				$evenhtml .= '</tr></table>';
			} else {
				$oddhtml = '<div style="margin: 0; color: #000000; ';
				if ($this->defaultfooterfontsize) {
					$oddhtml .= ' font-size: ' . $this->defaultfooterfontsize . 'pt;';
				}
				if ($this->defaultfooterfontstyle) {
					if ($this->defaultfooterfontstyle == 'B' || $this->defaultfooterfontstyle == 'BI') {
						$oddhtml .= ' font-weight: bold;';
					}
					if ($this->defaultfooterfontstyle == 'I' || $this->defaultfooterfontstyle == 'BI') {
						$oddhtml .= ' font-style: italic;';
					}
				}
				if ($this->defaultfooterline) {
					$oddhtml .= ' border-top: 0.1mm solid #000000;';
				}
				$oddhtml .= 'text-align: right; ">' . $Farray . '</div>';

				$evenhtml = '<div style="margin: 0; color: #000000; ';
				if ($this->defaultfooterfontsize) {
					$evenhtml .= ' font-size: ' . $this->defaultfooterfontsize . 'pt;';
				}
				if ($this->defaultfooterfontstyle) {
					if ($this->defaultfooterfontstyle == 'B' || $this->defaultfooterfontstyle == 'BI') {
						$evenhtml .= ' font-weight: bold;';
					}
					if ($this->defaultfooterfontstyle == 'I' || $this->defaultfooterfontstyle == 'BI') {
						$evenhtml .= ' font-style: italic;';
					}
				}
				if ($this->defaultfooterline) {
					$evenhtml .= ' border-top: 0.1mm solid #000000;';
				}
				$evenhtml .= 'text-align: left; ">' . $Farray . '</div>';
			}
		} elseif (is_array($Farray)) {
			if ($side == 'O') {
				$odd = $Farray;
			} elseif ($side == 'E') {
				$even = $Farray;
			} else {
				if (isset($Farray['odd']))
					$odd = $Farray['odd'];
				if (isset($Farray['even']))
					$even = $Farray['even'];
			}

			if (isset($odd))
				$oddhtml = $this->_createHTMLheaderFooter($odd, 'F');

			if (isset($even))
				$evenhtml = $this->_createHTMLheaderFooter($even, 'F');
		}
		/* -- HTMLfooterS-FOOTERS -- */
		if ($side == 'E') {
			$this->SetHTMLfooter($evenhtml, 'E');
		} elseif ($side == 'O') {
			$this->SetHTMLfooter($oddhtml, 'O');
		} else {
			$this->SetHTMLfooter($oddhtml, 'O');
			$this->SetHTMLfooter($evenhtml, 'E');
		}
		/* -- END HTMLfooterS-FOOTERS -- */
	}

	/* -- WATERMARK -- */

	function SetWatermarkText($txt = '', $alpha = -1)
	{
		if ($alpha >= 0)
			$this->watermarkTextAlpha = $alpha;
		$this->watermarkText = $txt;
	}

	function SetWatermarkImage($src, $alpha = -1, $size = 'D', $pos = 'F')
	{
		if ($alpha >= 0)
			$this->watermarkImageAlpha = $alpha;
		$this->watermarkImage = $src;
		$this->watermark_size = $size;
		$this->watermark_pos = $pos;
	}

	/* -- END WATERMARK -- */

	//Page footer
	function Footer()
	{
		/* -- CSS-PAGE -- */
		// PAGED MEDIA - CROP / CROSS MARKS from @PAGE
		if ($this->show_marks == 'CROP' || $this->show_marks == 'CROPCROSS') {
			// Show TICK MARKS
			$this->SetLineWidth(0.1); // = 0.1 mm
			$this->SetDColor($this->ConvertColor(0));
			$l = $this->cropMarkLength;
			$m = $this->cropMarkMargin; // Distance of crop mark from margin
			$b = $this->nonPrintMargin; // Non-printable border at edge of paper sheet
			$ax1 = $b;
			$bx = $this->page_box['outer_width_LR'] - $m;
			$ax = max($ax1, $bx - $l);
			$cx1 = $this->w - $b;
			$dx = $this->w - $this->page_box['outer_width_LR'] + $m;
			$cx = min($cx1, $dx + $l);
			$ay1 = $b;
			$by = $this->page_box['outer_width_TB'] - $m;
			$ay = max($ay1, $by - $l);
			$cy1 = $this->h - $b;
			$dy = $this->h - $this->page_box['outer_width_TB'] + $m;
			$cy = min($cy1, $dy + $l);

			$this->Line($ax, $this->page_box['outer_width_TB'], $bx, $this->page_box['outer_width_TB']);
			$this->Line($cx, $this->page_box['outer_width_TB'], $dx, $this->page_box['outer_width_TB']);
			$this->Line($ax, $this->h - $this->page_box['outer_width_TB'], $bx, $this->h - $this->page_box['outer_width_TB']);
			$this->Line($cx, $this->h - $this->page_box['outer_width_TB'], $dx, $this->h - $this->page_box['outer_width_TB']);
			$this->Line($this->page_box['outer_width_LR'], $ay, $this->page_box['outer_width_LR'], $by);
			$this->Line($this->page_box['outer_width_LR'], $cy, $this->page_box['outer_width_LR'], $dy);
			$this->Line($this->w - $this->page_box['outer_width_LR'], $ay, $this->w - $this->page_box['outer_width_LR'], $by);
			$this->Line($this->w - $this->page_box['outer_width_LR'], $cy, $this->w - $this->page_box['outer_width_LR'], $dy);

			if ($this->printers_info) {
				$hd = date('Y-m-d H:i') . '  Page ' . $this->page . ' of {nb}';
				$this->SetTColor($this->ConvertColor(0));
				$this->SetFont('arial', '', 7.5, true, true);
				$this->x = $this->page_box['outer_width_LR'] + 1.5;
				$this->y = 1;
				$this->Cell($headerpgwidth, $this->FontSize, $hd, 0, 0, 'L', 0, '', 0, 0, 0, 'M');
				$this->SetFont($this->default_font, '', $this->original_default_font_size);
			}
		}
		if ($this->show_marks == 'CROSS' || $this->show_marks == 'CROPCROSS') {
			$this->SetLineWidth(0.1); // = 0.1 mm
			$this->SetDColor($this->ConvertColor(0));
			$l = 14 / 2; // longer length of the cross line (half)
			$w = 6 / 2; // shorter width of the cross line (half)
			$r = 1.2; // radius of circle
			$m = $this->crossMarkMargin; // Distance of cross mark from margin
			$x1 = $this->page_box['outer_width_LR'] - $m;
			$x2 = $this->w - $this->page_box['outer_width_LR'] + $m;
			$y1 = $this->page_box['outer_width_TB'] - $m;
			$y2 = $this->h - $this->page_box['outer_width_TB'] + $m;
			// Left
			$this->Circle($x1, $this->h / 2, $r, 'S');
			$this->Line($x1 - $w, $this->h / 2, $x1 + $w, $this->h / 2);
			$this->Line($x1, $this->h / 2 - $l, $x1, $this->h / 2 + $l);
			// Right
			$this->Circle($x2, $this->h / 2, $r, 'S');
			$this->Line($x2 - $w, $this->h / 2, $x2 + $w, $this->h / 2);
			$this->Line($x2, $this->h / 2 - $l, $x2, $this->h / 2 + $l);
			// Top
			$this->Circle($this->w / 2, $y1, $r, 'S');
			$this->Line($this->w / 2, $y1 - $w, $this->w / 2, $y1 + $w);
			$this->Line($this->w / 2 - $l, $y1, $this->w / 2 + $l, $y1);
			// Bottom
			$this->Circle($this->w / 2, $y2, $r, 'S');
			$this->Line($this->w / 2, $y2 - $w, $this->w / 2, $y2 + $w);
			$this->Line($this->w / 2 - $l, $y2, $this->w / 2 + $l, $y2);
		}

		/* -- END CSS-PAGE -- */

		// mPDF 6
		// If @page set non-HTML headers/footers named, they were not read until later in the HTML code - so now set them
		if ($this->page == 1) {
			if ($this->firstPageBoxHeader) {
				if (isset($this->pageHTMLheaders[$this->firstPageBoxHeader])) {
					$this->HTMLHeader = $this->pageHTMLheaders[$this->firstPageBoxHeader];
				}
				$this->Header();
			}
			if ($this->firstPageBoxFooter) {
				if (isset($this->pageHTMLfooters[$this->firstPageBoxFooter])) {
					$this->HTMLFooter = $this->pageHTMLfooters[$this->firstPageBoxFooter];
				}
			}
			$this->firstPageBoxHeader = '';
			$this->firstPageBoxFooter = '';
		}


		if (($this->mirrorMargins && ($this->page % 2 == 0) && $this->HTMLFooterE) || ($this->mirrorMargins && ($this->page % 2 == 1) && $this->HTMLFooter) || (!$this->mirrorMargins && $this->HTMLFooter)) {
			$this->writeHTMLFooters();
		}

		/* -- WATERMARK -- */
		if (($this->watermarkText) && ($this->showWatermarkText)) {
			$this->watermark($this->watermarkText, 45, 120, $this->watermarkTextAlpha); // Watermark text
		}
		if (($this->watermarkImage) && ($this->showWatermarkImage)) {
			$this->watermarkImg($this->watermarkImage, $this->watermarkImageAlpha); // Watermark image
		}
		/* -- END WATERMARK -- */
	}

	/* -- HYPHENATION -- */

	///////////////////
	///////////////////
	// HYPHENATION
	///////////////////
	///////////////////
	// Word hyphenation
	// mPDF 6
	function hyphenateWord($word, $currptr)
	{
		// Do everything inside this function in utf-8
		// Don't hyphenate web addresses
		if (preg_match('/^(http:|www\.)/', $word)) {
			return -1;
		}

		$ptr = -1;

		// Get dictionary
		if (!$this->loadedSHYdictionary) {
			if (file_exists(_MPDF_PATH . 'patterns/dictionary.txt')) {
				$this->SHYdictionary = file(_MPDF_PATH . 'patterns/dictionary.txt', FILE_SKIP_EMPTY_LINES);
				foreach ($this->SHYdictionary as $entry) {
					$entry = trim($entry);
					$poss = array();
					$offset = 0;
					$p = true;
					$wl = mb_strlen($entry, 'UTF-8');
					while ($offset < $wl) {
						$p = mb_strpos($entry, '/', $offset, 'UTF-8');
						if ($p !== false) {
							$poss[] = $p - count($poss);
						} else {
							break;
						}
						$offset = $p + 1;
					}
					if (count($poss)) {
						$this->SHYdictionaryWords[str_replace('/', '', mb_strtolower($entry))] = $poss;
					}
				}
			}
			$this->loadedSHYdictionary = true;
		}

		if (!in_array($this->SHYlang, $this->SHYlanguages)) {
			return -1;
		}
		// If no pattern loaded or not the best one
		if (count($this->SHYpatterns) < 1 || ($this->loadedSHYpatterns && $this->loadedSHYpatterns != $this->SHYlang)) {
			include(_MPDF_PATH . "patterns/" . $this->SHYlang . ".php");
			$patterns = explode(' ', $patterns);
			$new_patterns = array();
			for ($i = 0; $i < count($patterns); $i++) {
				$value = $patterns[$i];
				$new_patterns[preg_replace('/[0-9]/', '', $value)] = $value;
			}
			$this->SHYpatterns = $new_patterns;
			$this->loadedSHYpatterns = $this->SHYlang;
		}

		if ($this->usingCoreFont) {
			$word = mb_convert_encoding($word, 'UTF-8', $this->mb_enc);
		}

		$prepre = '';
		$postpost = '';
		$startpunctuation = "\xc2\xab\xc2\xbf\xe2\x80\x98\xe2\x80\x9b\xe2\x80\x9c\xe2\x80\x9f";
		$endpunctuation = "\xe2\x80\x9e\xe2\x80\x9d\xe2\x80\x9a\xe2\x80\x99\xc2\xbb";


		if (preg_match('/^(["\'' . $startpunctuation . '])+(.{' . $this->SHYcharmin . ',})$/u', $word, $m)) {
			$prepre = $m[1];
			$word = $m[2];
		}
		if (preg_match('/^(.{' . $this->SHYcharmin . ',})([\'\.,;:!?"' . $endpunctuation . ']+)$/u', $word, $m)) {
			$word = $m[1];
			$postpost = $m[2];
		}
		if (mb_strlen($word, 'UTF-8') < $this->SHYcharmin) {
			return -1;
		}
		$success = false;

		$preprelen = mb_strlen($prepre);

		if (isset($this->SHYdictionaryWords[mb_strtolower($word)])) {
			foreach ($this->SHYdictionaryWords[mb_strtolower($word)] AS $i) {
				if (($i + $preprelen) >= $currptr) {
					break;
				}
				$ptr = $i + $preprelen;
				$success = true;
			}
		}

		if (!$success) {
			$text_word = '_' . $word . '_';
			$word_length = mb_strlen($text_word, 'UTF-8');
			$text_word = mb_strtolower($text_word, 'UTF-8');
			$hyphenated_word = array();
			$numb3rs = array('0' => true, '1' => true, '2' => true, '3' => true, '4' => true, '5' => true, '6' => true, '7' => true, '8' => true, '9' => true);
			for ($position = 0; $position <= ($word_length - $this->SHYcharmin); $position++) {
				$maxwins = min(($word_length - $position), $this->SHYcharmax);
				for ($win = $this->SHYcharmin; $win <= $maxwins; $win++) {
					if (isset($this->SHYpatterns[mb_substr($text_word, $position, $win, 'UTF-8')])) {
						$pattern = $this->SHYpatterns[mb_substr($text_word, $position, $win, 'UTF-8')];
						$digits = 1;
						$pattern_length = mb_strlen($pattern, 'UTF-8');
						for ($i = 0; $i < $pattern_length; $i++) {
							$char = $pattern[$i];
							if (isset($numb3rs[$char])) {
								$zero = ($i == 0) ? $position - 1 : $position + $i - $digits;
								if (!isset($hyphenated_word[$zero]) || $hyphenated_word[$zero] != $char)
									$hyphenated_word[$zero] = $char;
								$digits++;
							}
						}
					}
				}
			}
			for ($i = $this->SHYleftmin; $i <= (mb_strlen($word, 'UTF-8') - $this->SHYrightmin); $i++) {
				if (isset($hyphenated_word[$i]) && $hyphenated_word[$i] % 2 != 0) {
					if (($i + $preprelen) > $currptr) {
						break;
					}
					$ptr = $i + $preprelen;
				}
			}
		}
		return $ptr;
	}

	/* -- END HYPHENATION -- */


	/* -- HTML-CSS -- */

	///////////////////
	/// HTML parser ///
	///////////////////
	function WriteHTML($html, $sub = 0, $init = true, $close = true)
	{
		// $sub - 0 = default; 1=headerCSS only; 2=HTML body (parts) only; 3 - HTML parses only
		// 4 - writes HTML headers/Fixed pos DIVs - stores in buffer - for single page only
		// $close - if false Leaves buffers etc. in current state, so that it can continue a block etc.
		// $init - Clears and sets buffers to Top level block etc.

		/* Check $html is an integer, float, string, boolean or class with __toString(), otherwise throw exception */
		if (is_scalar($html) === false) {
			if(!is_object($html) || ! method_exists($html, '__toString')) {
				throw new MpdfException('WriteHTML() requires $html be an integer, float, string, boolean or an object with the __toString() magic method.');
			}
		}

		/* Cast $html as a string */
		$html = (string) $html;

		if ($this->progressBar) {
			$this->UpdateProgressBar(1, 0, 'Parsing CSS & Headers');
		} // *PROGRESS-BAR*

		if ($init) {
			$this->headerbuffer = '';
			$this->textbuffer = array();
			$this->fixedPosBlockSave = array();
		}
		if ($sub == 1) {
			$html = '<style> ' . $html . ' </style>';
		} // stylesheet only

		if ($this->allow_charset_conversion) {
			if ($sub < 1) {
				$this->ReadCharset($html);
			}
			if ($this->charset_in && $sub != 4) {
				$success = iconv($this->charset_in, 'UTF-8//TRANSLIT', $html);
				if ($success) {
					$html = $success;
				}
			}
		}
		$html = $this->purify_utf8($html, false);
		if ($init) {
			$this->blklvl = 0;
			$this->lastblocklevelchange = 0;
			$this->blk = array();
			$this->initialiseBlock($this->blk[0]);
			$this->blk[0]['width'] = & $this->pgwidth;
			$this->blk[0]['inner_width'] = & $this->pgwidth;
			$this->blk[0]['blockContext'] = $this->blockContext;
		}

		$zproperties = array();
		if ($sub < 2) {
			$this->ReadMetaTags($html);

			if (preg_match('/<base[^>]*href=["\']([^"\'>]*)["\']/i', $html, $m)) {
				$this->SetBasePath($m[1]);
			}
			$html = $this->cssmgr->ReadCSS($html);

			if ($this->autoLangToFont && !$this->usingCoreFont && preg_match('/<html [^>]*lang=[\'\"](.*?)[\'\"]/ism', $html, $m)) {
				$html_lang = $m[1];
			}

			if (preg_match('/<html [^>]*dir=[\'\"]\s*rtl\s*[\'\"]/ism', $html)) {
				$zproperties['DIRECTION'] = 'rtl';
			}

			// allow in-line CSS for body tag to be parsed // Get <body> tag inline CSS
			if (preg_match('/<body([^>]*)>(.*?)<\/body>/ism', $html, $m) || preg_match('/<body([^>]*)>(.*)$/ism', $html, $m)) {
				$html = $m[2];
				// Changed to allow style="background: url('bg.jpg')"
				if (preg_match('/style=[\"](.*?)[\"]/ism', $m[1], $mm) || preg_match('/style=[\'](.*?)[\']/ism', $m[1], $mm)) {
					$zproperties = $this->cssmgr->readInlineCSS($mm[1]);
				}
				if (preg_match('/dir=[\'\"]\s*rtl\s*[\'\"]/ism', $m[1])) {
					$zproperties['DIRECTION'] = 'rtl';
				}
				if (isset($html_lang) && $html_lang) {
					$zproperties['LANG'] = $html_lang;
				}
				if ($this->autoLangToFont && !$this->onlyCoreFonts && preg_match('/lang=[\'\"](.*?)[\'\"]/ism', $m[1], $mm)) {
					$zproperties['LANG'] = $mm[1];
				}
			}
		}
		$properties = $this->cssmgr->MergeCSS('BLOCK', 'BODY', '');
		if ($zproperties) {
			$properties = $this->cssmgr->array_merge_recursive_unique($properties, $zproperties);
		}

		if (isset($properties['DIRECTION']) && $properties['DIRECTION']) {
			$this->cssmgr->CSS['BODY']['DIRECTION'] = $properties['DIRECTION'];
		}
		if (!isset($this->cssmgr->CSS['BODY']['DIRECTION'])) {
			$this->cssmgr->CSS['BODY']['DIRECTION'] = $this->directionality;
		} else {
			$this->SetDirectionality($this->cssmgr->CSS['BODY']['DIRECTION']);
		}

		$this->setCSS($properties, '', 'BODY');

		$this->blk[0]['InlineProperties'] = $this->saveInlineProperties();

		if ($sub == 1) {
			return '';
		}
		if (!isset($this->cssmgr->CSS['BODY'])) {
			$this->cssmgr->CSS['BODY'] = array();
		}

		/* -- BACKGROUNDS -- */
		if (isset($properties['BACKGROUND-GRADIENT'])) {
			$this->bodyBackgroundGradient = $properties['BACKGROUND-GRADIENT'];
		}

		if (isset($properties['BACKGROUND-IMAGE']) && $properties['BACKGROUND-IMAGE']) {
			$ret = $this->SetBackground($properties, $this->pgwidth);
			if ($ret) {
				$this->bodyBackgroundImage = $ret;
			}
		}
		/* -- END BACKGROUNDS -- */

		/* -- CSS-PAGE -- */
		// If page-box is set
		if ($this->state == 0 && ((isset($this->cssmgr->CSS['@PAGE']) && $this->cssmgr->CSS['@PAGE']) || (isset($this->cssmgr->CSS['@PAGE>>PSEUDO>>FIRST']) && $this->cssmgr->CSS['@PAGE>>PSEUDO>>FIRST']))) { // mPDF 5.7.3
			$this->page_box['current'] = '';
			$this->page_box['using'] = true;
			list($pborientation, $pbmgl, $pbmgr, $pbmgt, $pbmgb, $pbmgh, $pbmgf, $hname, $fname, $bg, $resetpagenum, $pagenumstyle, $suppress, $marks, $newformat) = $this->SetPagedMediaCSS('', false, 'O');
			$this->DefOrientation = $this->CurOrientation = $pborientation;
			$this->orig_lMargin = $this->DeflMargin = $pbmgl;
			$this->orig_rMargin = $this->DefrMargin = $pbmgr;
			$this->orig_tMargin = $this->tMargin = $pbmgt;
			$this->orig_bMargin = $this->bMargin = $pbmgb;
			$this->orig_hMargin = $this->margin_header = $pbmgh;
			$this->orig_fMargin = $this->margin_footer = $pbmgf;
			list($pborientation, $pbmgl, $pbmgr, $pbmgt, $pbmgb, $pbmgh, $pbmgf, $hname, $fname, $bg, $resetpagenum, $pagenumstyle, $suppress, $marks, $newformat) = $this->SetPagedMediaCSS('', true, 'O'); // first page
			$this->show_marks = $marks;
			if ($hname)
				$this->firstPageBoxHeader = $hname;
			if ($fname)
				$this->firstPageBoxFooter = $fname;
		}
		/* -- END CSS-PAGE -- */

		$parseonly = false;
		$this->bufferoutput = false;
		if ($sub == 3) {
			$parseonly = true;
			// Close any open block tags
			$arr = array();
			$ai = 0;
			for ($b = $this->blklvl; $b > 0; $b--) {
				$this->tag->CloseTag($this->blk[$b]['tag'], $arr, $ai);
			}
			// Output any text left in buffer
			if (count($this->textbuffer)) {
				$this->printbuffer($this->textbuffer);
			}
			$this->textbuffer = array();
		} elseif ($sub == 4) {
			// Close any open block tags
			$arr = array();
			$ai = 0;
			for ($b = $this->blklvl; $b > 0; $b--) {
				$this->tag->CloseTag($this->blk[$b]['tag'], $arr, $ai);
			}
			// Output any text left in buffer
			if (count($this->textbuffer)) {
				$this->printbuffer($this->textbuffer);
			}
			$this->bufferoutput = true;
			$this->textbuffer = array();
			$this->headerbuffer = '';
			$properties = $this->cssmgr->MergeCSS('BLOCK', 'BODY', '');
			$this->setCSS($properties, '', 'BODY');
		}

		mb_internal_encoding('UTF-8');

		$html = $this->AdjustHTML($html, $this->tabSpaces); //Try to make HTML look more like XHTML

		if ($this->autoScriptToLang) {
			$html = $this->markScriptToLang($html);
		}

		preg_match_all('/<htmlpageheader([^>]*)>(.*?)<\/htmlpageheader>/si', $html, $h);
		for ($i = 0; $i < count($h[1]); $i++) {
			if (preg_match('/name=[\'|\"](.*?)[\'|\"]/', $h[1][$i], $n)) {
				$this->pageHTMLheaders[$n[1]]['html'] = $h[2][$i];
				$this->pageHTMLheaders[$n[1]]['h'] = $this->_gethtmlheight($h[2][$i]);
			}
		}
		preg_match_all('/<htmlpagefooter([^>]*)>(.*?)<\/htmlpagefooter>/si', $html, $f);
		for ($i = 0; $i < count($f[1]); $i++) {
			if (preg_match('/name=[\'|\"](.*?)[\'|\"]/', $f[1][$i], $n)) {
				$this->pageHTMLfooters[$n[1]]['html'] = $f[2][$i];
				$this->pageHTMLfooters[$n[1]]['h'] = $this->_gethtmlheight($f[2][$i]);
			}
		}

		$html = preg_replace('/<htmlpageheader.*?<\/htmlpageheader>/si', '', $html);
		$html = preg_replace('/<htmlpagefooter.*?<\/htmlpagefooter>/si', '', $html);

		if ($this->state == 0 && $sub != 1 && $sub != 3 && $sub != 4) {
			$this->AddPage($this->CurOrientation);
		}


		if (isset($hname) && preg_match('/^html_(.*)$/i', $hname, $n))
			$this->SetHTMLHeader($this->pageHTMLheaders[$n[1]], 'O', true);
		if (isset($fname) && preg_match('/^html_(.*)$/i', $fname, $n))
			$this->SetHTMLFooter($this->pageHTMLfooters[$n[1]], 'O');



		$html = str_replace('<?', '< ', $html); //Fix '<?XML' bug from HTML code generated by MS Word

		$this->checkSIP = false;
		$this->checkSMP = false;
		$this->checkCJK = false;
		if ($this->onlyCoreFonts) {
			$html = $this->SubstituteChars($html);
		} else {
			if (preg_match("/([" . $this->pregRTLchars . "])/u", $html)) {
				$this->biDirectional = true;
			} // *OTL*
			if (preg_match("/([\x{20000}-\x{2FFFF}])/u", $html)) {
				$this->checkSIP = true;
			}
			if (preg_match("/([\x{10000}-\x{1FFFF}])/u", $html)) {
				$this->checkSMP = true;
			}
			/* -- CJK-FONTS -- */
			if (preg_match("/([" . $this->pregCJKchars . "])/u", $html)) {
				$this->checkCJK = true;
			}
			/* -- END CJK-FONTS -- */
		}

		// Don't allow non-breaking spaces that are converted to substituted chars or will break anyway and mess up table width calc.
		$html = str_replace('<tta>160</tta>', chr(32), $html);
		$html = str_replace('</tta><tta>', '|', $html);
		$html = str_replace('</tts><tts>', '|', $html);
		$html = str_replace('</ttz><ttz>', '|', $html);

		//Add new supported tags in the DisableTags function
		$html = strip_tags($html, $this->enabledtags); //remove all unsupported tags, but the ones inside the 'enabledtags' string
		//Explode the string in order to parse the HTML code
		$a = preg_split('/<(.*?)>/ms', $html, -1, PREG_SPLIT_DELIM_CAPTURE);
		// ? more accurate regexp that allows e.g. <a name="Silly <name>">
		// if changing - also change in fn.SubstituteChars()
		// $a = preg_split ('/<((?:[^<>]+(?:"[^"]*"|\'[^\']*\')?)+)>/ms', $html, -1, PREG_SPLIT_DELIM_CAPTURE);

		if ($this->mb_enc) {
			mb_internal_encoding($this->mb_enc);
		}
		$pbc = 0;
		if ($this->progressBar) {
			$this->UpdateProgressBar(1, 0);
		} // *PROGRESS-BAR*
		$this->subPos = -1;
		$cnt = count($a);
		for ($i = 0; $i < $cnt; $i++) {
			$e = $a[$i];
			if ($i % 2 == 0) {
				//TEXT
				if ($this->blk[$this->blklvl]['hide']) {
					continue;
				}
				if ($this->inlineDisplayOff) {
					continue;
				}
				if ($this->inMeter) {
					continue;
				}

				if ($this->inFixedPosBlock) {
					$this->fixedPosBlock .= $e;
					continue;
				} // *CSS-POSITION*
				if (strlen($e) == 0) {
					continue;
				}

				if ($this->ignorefollowingspaces && !$this->ispre) {
					if (strlen(ltrim($e)) == 0) {
						continue;
					}
					if ($this->FontFamily != 'csymbol' && $this->FontFamily != 'czapfdingbats' && substr($e, 0, 1) == ' ') {
						$this->ignorefollowingspaces = false;
						$e = ltrim($e);
					}
				}

				$this->OTLdata = NULL;  // mPDF 5.7.1

				$e = strcode2utf($e);
				$e = $this->lesser_entity_decode($e);

				if ($this->usingCoreFont) {
					// If core font is selected in document which is not onlyCoreFonts - substitute with non-core font
					if ($this->useSubstitutions && !$this->onlyCoreFonts && $this->subPos < $i && !$this->specialcontent) {
						$cnt += $this->SubstituteCharsNonCore($a, $i, $e);
					}
					// CONVERT ENCODING
					$e = mb_convert_encoding($e, $this->mb_enc, 'UTF-8');
					if ($this->textvar & FT_UPPERCASE) {
						$e = mb_strtoupper($e, $this->mb_enc);
					} // mPDF 5.7.1
					elseif ($this->textvar & FT_LOWERCASE) {
						$e = mb_strtolower($e, $this->mb_enc);
					} // mPDF 5.7.1
					elseif ($this->textvar & FT_CAPITALIZE) {
						$e = mb_convert_case($e, MB_CASE_TITLE, "UTF-8");
					} // mPDF 5.7.1
				} else {
					if ($this->checkSIP && $this->CurrentFont['sipext'] && $this->subPos < $i && (!$this->specialcontent || !$this->useActiveForms)) {
						$cnt += $this->SubstituteCharsSIP($a, $i, $e);
					}

					if ($this->useSubstitutions && !$this->onlyCoreFonts && $this->CurrentFont['type'] != 'Type0' && $this->subPos < $i && (!$this->specialcontent || !$this->useActiveForms)) {
						$cnt += $this->SubstituteCharsMB($a, $i, $e);
					}

					if ($this->textvar & FT_UPPERCASE) {
						$e = mb_strtoupper($e, $this->mb_enc);
					} elseif ($this->textvar & FT_LOWERCASE) {
						$e = mb_strtolower($e, $this->mb_enc);
					} elseif ($this->textvar & FT_CAPITALIZE) {
						$e = mb_convert_case($e, MB_CASE_TITLE, "UTF-8");
					}

					/* -- OTL -- */
					// Use OTL OpenType Table Layout - GSUB & GPOS
					if (isset($this->CurrentFont['useOTL']) && $this->CurrentFont['useOTL'] && (!$this->specialcontent || !$this->useActiveForms)) {
						$e = $this->otl->applyOTL($e, $this->CurrentFont['useOTL']);
						$this->OTLdata = $this->otl->OTLdata;
						$this->otl->removeChar($e, $this->OTLdata, "\xef\xbb\xbf"); // Remove ZWNBSP (also Byte order mark FEFF)
					}
					/* -- END OTL -- */ else { // *OTL*
						// removes U+200E/U+200F LTR and RTL mark and U+200C/U+200D Zero-width Joiner and Non-joiner
						$e = preg_replace("/[\xe2\x80\x8c\xe2\x80\x8d\xe2\x80\x8e\xe2\x80\x8f]/u", '', $e);
						$e = preg_replace("/[\xef\xbb\xbf]/u", '', $e); // Remove ZWNBSP (also Byte order mark FEFF)
					} // *OTL*
				}
				if (($this->tts) || ($this->ttz) || ($this->tta)) {
					$es = explode('|', $e);
					$e = '';
					foreach ($es AS $val) {
						$e .= chr($val);
					}
				}

				//  FORM ELEMENTS
				if ($this->specialcontent) {
					/* -- FORMS -- */
					//SELECT tag (form element)
					if ($this->specialcontent == "type=select") {
						$e = ltrim($e);
						if (!empty($this->OTLdata)) {
							$this->otl->trimOTLdata($this->OTLdata, true, false);
						} // *OTL*
						$stringwidth = $this->GetStringWidth($e);
						if (!isset($this->selectoption['MAXWIDTH']) || $stringwidth > $this->selectoption['MAXWIDTH']) {
							$this->selectoption['MAXWIDTH'] = $stringwidth;
						}
						if (!isset($this->selectoption['SELECTED']) || $this->selectoption['SELECTED'] == '') {
							$this->selectoption['SELECTED'] = $e;
							if (!empty($this->OTLdata)) {
								$this->selectoption['SELECTED-OTLDATA'] = $this->OTLdata;
							} // *OTL*
						}
						// Active Forms
						if (isset($this->selectoption['ACTIVE']) && $this->selectoption['ACTIVE']) {
							$this->selectoption['ITEMS'][] = array('exportValue' => $this->selectoption['currentVAL'], 'content' => $e, 'selected' => $this->selectoption['currentSEL']);
						}
						$this->OTLdata = array();
					}
					// TEXTAREA
					else {
						$objattr = unserialize($this->specialcontent);
						$objattr['text'] = $e;
						$objattr['OTLdata'] = $this->OTLdata;
						$this->OTLdata = array();
						$te = "\xbb\xa4\xactype=textarea,objattr=" . serialize($objattr) . "\xbb\xa4\xac";
						if ($this->tdbegin) {
							$this->_saveCellTextBuffer($te, $this->HREF);
						} else {
							$this->_saveTextBuffer($te, $this->HREF);
						}
					}
					/* -- END FORMS -- */
				}

				// TABLE
				elseif ($this->tableLevel) {
					/* -- TABLES -- */
					if ($this->tdbegin) {
						if (($this->ignorefollowingspaces) && !$this->ispre) {
							$e = ltrim($e);
							if (!empty($this->OTLdata)) {
								$this->otl->trimOTLdata($this->OTLdata, true, false);
							} // *OTL*
						}
						if ($e || $e === '0') {
							if ($this->blockjustfinished && $this->cell[$this->row][$this->col]['s'] > 0) {
								$this->_saveCellTextBuffer("\n");
								if (!isset($this->cell[$this->row][$this->col]['maxs'])) {
									$this->cell[$this->row][$this->col]['maxs'] = $this->cell[$this->row][$this->col]['s'];
								} elseif ($this->cell[$this->row][$this->col]['maxs'] < $this->cell[$this->row][$this->col]['s']) {
									$this->cell[$this->row][$this->col]['maxs'] = $this->cell[$this->row][$this->col]['s'];
								}
								$this->cell[$this->row][$this->col]['s'] = 0; // reset
							}
							$this->blockjustfinished = false;

							if (!isset($this->cell[$this->row][$this->col]['R']) || !$this->cell[$this->row][$this->col]['R']) {
								if (isset($this->cell[$this->row][$this->col]['s'])) {
									$this->cell[$this->row][$this->col]['s'] += $this->GetStringWidth($e, false, $this->OTLdata, $this->textvar);
								} else {
									$this->cell[$this->row][$this->col]['s'] = $this->GetStringWidth($e, false, $this->OTLdata, $this->textvar);
								}
								if (!empty($this->spanborddet)) {
									$this->cell[$this->row][$this->col]['s'] += (isset($this->spanborddet['L']['w']) ? $this->spanborddet['L']['w'] : 0) + (isset($this->spanborddet['R']['w']) ? $this->spanborddet['R']['w'] : 0);
								}
							}
							$this->_saveCellTextBuffer($e, $this->HREF);
							if (substr($this->cell[$this->row][$this->col]['a'], 0, 1) == 'D') {
								$dp = $this->decimal_align[substr($this->cell[$this->row][$this->col]['a'], 0, 2)];
								$s = preg_split('/' . preg_quote($dp, '/') . '/', $e, 2);  // ? needs to be /u if not core
								$s0 = $this->GetStringWidth($s[0], false);
								if (isset($s[1]) && $s[1]) {
									$s1 = $this->GetStringWidth(($s[1] . $dp), false);
								} else
									$s1 = 0;
								if (!isset($this->table[$this->tableLevel][$this->tbctr[$this->tableLevel]]['decimal_align'][$this->col]['maxs0'])) {
									$this->table[$this->tableLevel][$this->tbctr[$this->tableLevel]]['decimal_align'][$this->col]['maxs0'] = $s0;
								} else {
									$this->table[$this->tableLevel][$this->tbctr[$this->tableLevel]]['decimal_align'][$this->col]['maxs0'] = max($s0, $this->table[$this->tableLevel][$this->tbctr[$this->tableLevel]]['decimal_align'][$this->col]['maxs0']);
								}
								if (!isset($this->table[$this->tableLevel][$this->tbctr[$this->tableLevel]]['decimal_align'][$this->col]['maxs1'])) {
									$this->table[$this->tableLevel][$this->tbctr[$this->tableLevel]]['decimal_align'][$this->col]['maxs1'] = $s1;
								} else {
									$this->table[$this->tableLevel][$this->tbctr[$this->tableLevel]]['decimal_align'][$this->col]['maxs1'] = max($s1, $this->table[$this->tableLevel][$this->tbctr[$this->tableLevel]]['decimal_align'][$this->col]['maxs1']);
								}
							}

							if ($this->tableLevel == 1 && $this->useGraphs) {
								$this->graphs[$this->currentGraphId]['data'][$this->row][$this->col] = $e;
							}
							$this->nestedtablejustfinished = false;
							$this->linebreakjustfinished = false;
						}
					}
					/* -- END TABLES -- */
				}
				// ALL ELSE
				else {
					if ($this->ignorefollowingspaces && !$this->ispre) {
						$e = ltrim($e);
						if (!empty($this->OTLdata)) {
							$this->otl->trimOTLdata($this->OTLdata, true, false);
						} // *OTL*
					}
					if ($e || $e === '0')
						$this->_saveTextBuffer($e, $this->HREF);
				}
				if ($e || $e === '0')
					$this->ignorefollowingspaces = false; // mPDF 6
				if (substr($e, -1, 1) == ' ' && !$this->ispre && $this->FontFamily != 'csymbol' && $this->FontFamily != 'czapfdingbats') {
					$this->ignorefollowingspaces = true;
				}
			} else { // TAG **
				if (isset($e[0]) && $e[0] == '/') {
					/* -- PROGRESS-BAR -- */
					if ($this->progressBar) {  // 10% increments
						if (intval($i * 10 / $cnt) != $pbc) {
							$pbc = intval($i * 10 / $cnt);
							$this->UpdateProgressBar(1, $pbc * 10, $tag);
						}
					}
					/* -- END PROGRESS-BAR -- */

					$endtag = trim(strtoupper(substr($e, 1)));


					/* -- CSS-POSITION -- */
					// mPDF 6
					if ($this->inFixedPosBlock) {
						if (in_array($endtag, $this->outerblocktags) || in_array($endtag, $this->innerblocktags)) {
							$this->fixedPosBlockDepth--;
						}
						if ($this->fixedPosBlockDepth == 0) {
							$this->fixedPosBlockSave[] = array($this->fixedPosBlock, $this->fixedPosBlockBBox, $this->page);
							$this->fixedPosBlock = '';
							$this->inFixedPosBlock = false;
							continue;
						}
						$this->fixedPosBlock .= '<' . $e . '>';
						continue;
					}
					/* -- END CSS-POSITION -- */

					// mPDF 6
					// Correct for tags where HTML5 specifies optional end tags (see also OpenTag() )
					if ($this->allow_html_optional_endtags && !$parseonly) {
						if (isset($this->blk[$this->blklvl]['tag'])) {
							$closed = false;
							// li end tag may be omitted if there is no more content in the parent element
							if (!$closed && $this->blk[$this->blklvl]['tag'] == 'LI' && $endtag != 'LI' && (in_array($endtag, $this->outerblocktags) || in_array($endtag, $this->innerblocktags))) {
								$this->tag->CloseTag('LI', $a, $i);
								$closed = true;
							}
							// dd end tag may be omitted if there is no more content in the parent element
							if (!$closed && $this->blk[$this->blklvl]['tag'] == 'DD' && $endtag != 'DD' && (in_array($endtag, $this->outerblocktags) || in_array($endtag, $this->innerblocktags))) {
								$this->tag->CloseTag('DD', $a, $i);
								$closed = true;
							}
							// p end tag may be omitted if there is no more content in the parent element and the parent element is not an A element [??????]
							if (!$closed && $this->blk[$this->blklvl]['tag'] == 'P' && $endtag != 'P' && (in_array($endtag, $this->outerblocktags) || in_array($endtag, $this->innerblocktags))) {
								$this->tag->CloseTag('P', $a, $i);
								$closed = true;
							}
							// option end tag may be omitted if there is no more content in the parent element
							if (!$closed && $this->blk[$this->blklvl]['tag'] == 'OPTION' && $endtag != 'OPTION' && (in_array($endtag, $this->outerblocktags) || in_array($endtag, $this->innerblocktags))) {
								$this->tag->CloseTag('OPTION', $a, $i);
								$closed = true;
							}
						}
						/* -- TABLES -- */
						// Check for Table tags where HTML specifies optional end tags,
						if ($endtag == 'TABLE') {
							if ($this->lastoptionaltag == 'THEAD' || $this->lastoptionaltag == 'TBODY' || $this->lastoptionaltag == 'TFOOT') {
								$this->tag->CloseTag($this->lastoptionaltag, $a, $i);
							}
							if ($this->lastoptionaltag == 'TR') {
								$this->tag->CloseTag('TR', $a, $i);
							}
							if ($this->lastoptionaltag == 'TD' || $this->lastoptionaltag == 'TH') {
								$this->tag->CloseTag($this->lastoptionaltag, $a, $i);
								$this->tag->CloseTag('TR', $a, $i);
							}
						}
						if ($endtag == 'THEAD' || $endtag == 'TBODY' || $endtag == 'TFOOT') {
							if ($this->lastoptionaltag == 'TR') {
								$this->tag->CloseTag('TR', $a, $i);
							}
							if ($this->lastoptionaltag == 'TD' || $this->lastoptionaltag == 'TH') {
								$this->tag->CloseTag($this->lastoptionaltag, $a, $i);
								$this->tag->CloseTag('TR', $a, $i);
							}
						}
						if ($endtag == 'TR') {
							if ($this->lastoptionaltag == 'TD' || $this->lastoptionaltag == 'TH') {
								$this->tag->CloseTag($this->lastoptionaltag, $a, $i);
							}
						}
						/* -- END TABLES -- */
					}


					// mPDF 6
					if ($this->blk[$this->blklvl]['hide']) {
						if (in_array($endtag, $this->outerblocktags) || in_array($endtag, $this->innerblocktags)) {
							unset($this->blk[$this->blklvl]);
							$this->blklvl--;
						}
						continue;
					}

					// mPDF 6
					$this->tag->CloseTag($endtag, $a, $i); // mPDF 6
				} else { // OPENING TAG
					if ($this->blk[$this->blklvl]['hide']) {
						if (strpos($e, ' ')) {
							$te = strtoupper(substr($e, 0, strpos($e, ' ')));
						} else {
							$te = strtoupper($e);
						}
						// mPDF 6
						if ($te == 'THEAD' || $te == 'TBODY' || $te == 'TFOOT' || $te == 'TR' || $te == 'TD' || $te == 'TH') {
							$this->lastoptionaltag = $te;
						}
						if (in_array($te, $this->outerblocktags) || in_array($te, $this->innerblocktags)) {
							$this->blklvl++;
							$this->blk[$this->blklvl]['hide'] = true;
							$this->blk[$this->blklvl]['tag'] = $te; // mPDF 6
						}
						continue;
					}

					/* -- CSS-POSITION -- */
					if ($this->inFixedPosBlock) {
						if (strpos($e, ' ')) {
							$te = strtoupper(substr($e, 0, strpos($e, ' ')));
						} else {
							$te = strtoupper($e);
						}
						$this->fixedPosBlock .= '<' . $e . '>';
						if (in_array($te, $this->outerblocktags) || in_array($te, $this->innerblocktags)) {
							$this->fixedPosBlockDepth++;
						}
						continue;
					}
					/* -- END CSS-POSITION -- */
					$regexp = '|=\'(.*?)\'|s'; // eliminate single quotes, if any
					$e = preg_replace($regexp, "=\"\$1\"", $e);
					// changes anykey=anyvalue to anykey="anyvalue" (only do this inside [some] tags)
					if (substr($e, 0, 10) != 'pageheader' && substr($e, 0, 10) != 'pagefooter' && substr($e, 0, 12) != 'tocpagebreak' && substr($e, 0, 10) != 'indexentry' && substr($e, 0, 8) != 'tocentry') { // mPDF 6  (ZZZ99H)
						$regexp = '| (\\w+?)=([^\\s>"]+)|si';
						$e = preg_replace($regexp, " \$1=\"\$2\"", $e);
					}

					$e = preg_replace('/ (\\S+?)\s*=\s*"/i', " \\1=\"", $e);

					//Fix path values, if needed
					$orig_srcpath = '';
					if ((stristr($e, "href=") !== false) or ( stristr($e, "src=") !== false)) {
						$regexp = '/ (href|src)\s*=\s*"(.*?)"/i';
						preg_match($regexp, $e, $auxiliararray);
						if (isset($auxiliararray[2])) {
							$path = $auxiliararray[2];
						} else {
							$path = '';
						}
						if (trim($path) != '' && !(stristr($e, "src=") !== false && substr($path, 0, 4) == 'var:') && substr($path, 0, 1) != '@') {
							$path = htmlspecialchars_decode($path); // mPDF 5.7.4 URLs
							$orig_srcpath = $path;
							$this->GetFullPath($path);
							$regexp = '/ (href|src)="(.*?)"/i';
							$e = preg_replace($regexp, ' \\1="' . $path . '"', $e);
						}
					}//END of Fix path values
					//Extract attributes
					$contents = array();
					$contents1 = array();
					$contents2 = array();
					// Changed to allow style="background: url('bg.jpg')"
					// Changed to improve performance; maximum length of \S (attribute) = 16
					// Increase allowed attribute name to 32 - cutting off "toc-even-header-name" etc.
					preg_match_all('/\\S{1,32}=["][^"]*["]/', $e, $contents1);
					preg_match_all('/\\S{1,32}=[\'][^\']*[\']/i', $e, $contents2);

					$contents = array_merge($contents1, $contents2);
					preg_match('/\\S+/', $e, $a2);
					$tag = (isset($a2[0]) ? strtoupper($a2[0]) : '');
					$attr = array();
					if ($orig_srcpath) {
						$attr['ORIG_SRC'] = $orig_srcpath;
					}
					if (!empty($contents)) {
						foreach ($contents[0] as $v) {
							// Changed to allow style="background: url('bg.jpg')"
							if (preg_match('/^([^=]*)=["]?([^"]*)["]?$/', $v, $a3) || preg_match('/^([^=]*)=[\']?([^\']*)[\']?$/', $v, $a3)) {
								if (strtoupper($a3[1]) == 'ID' || strtoupper($a3[1]) == 'CLASS') { // 4.2.013 Omits STYLE
									$attr[strtoupper($a3[1])] = trim(strtoupper($a3[2]));
								}
								// includes header-style-right etc. used for <pageheader>
								elseif (preg_match('/^(HEADER|FOOTER)-STYLE/i', $a3[1])) {
									$attr[strtoupper($a3[1])] = trim(strtoupper($a3[2]));
								} else {
									$attr[strtoupper($a3[1])] = trim($a3[2]);
								}
							}
						}
					}
					$this->tag->OpenTag($tag, $attr, $a, $i); // mPDF 6
					/* -- CSS-POSITION -- */
					if ($this->inFixedPosBlock) {
						$this->fixedPosBlockBBox = array($tag, $attr, $this->x, $this->y);
						$this->fixedPosBlock = '';
						$this->fixedPosBlockDepth = 1;
					}
					/* -- END CSS-POSITION -- */
					if (preg_match('/\/$/', $e)) {
						$this->tag->CloseTag($tag, $a, $i);
					}
				}
			} // end TAG
		} //end of	foreach($a as $i=>$e)

		if ($close) {

			// Close any open block tags
			for ($b = $this->blklvl; $b > 0; $b--) {
				$this->tag->CloseTag($this->blk[$b]['tag'], $a, $i);
			}

			// Output any text left in buffer
			if (count($this->textbuffer) && !$parseonly) {
				$this->printbuffer($this->textbuffer);
			}
			if (!$parseonly)
				$this->textbuffer = array();

			/* -- CSS-FLOAT -- */
			// If ended with a float, need to move to end page
			$currpos = $this->page * 1000 + $this->y;
			if (isset($this->blk[$this->blklvl]['float_endpos']) && $this->blk[$this->blklvl]['float_endpos'] > $currpos) {
				$old_page = $this->page;
				$new_page = intval($this->blk[$this->blklvl]['float_endpos'] / 1000);
				if ($old_page != $new_page) {
					$s = $this->PrintPageBackgrounds();
					// Writes after the marker so not overwritten later by page background etc.
					$this->pages[$this->page] = preg_replace('/(___BACKGROUND___PATTERNS' . $this->uniqstr . ')/', '\\1' . "\n" . $s . "\n", $this->pages[$this->page]);
					$this->pageBackgrounds = array();
					$this->page = $new_page;
					$this->ResetMargins();
					$this->Reset();
					$this->pageoutput[$this->page] = array();
				}
				$this->y = (($this->blk[$this->blklvl]['float_endpos'] * 1000) % 1000000) / 1000; // mod changes operands to integers before processing
			}
			/* -- END CSS-FLOAT -- */

			/* -- CSS-IMAGE-FLOAT -- */
			$this->printfloatbuffer();
			/* -- END CSS-IMAGE-FLOAT -- */

			//Create Internal Links, if needed
			if (!empty($this->internallink)) {
				foreach ($this->internallink as $k => $v) {
					if (strpos($k, "#") !== false) {
						continue;
					} //ignore
					$ypos = $v['Y'];
					$pagenum = $v['PAGE'];
					$sharp = "#";
					while (array_key_exists($sharp . $k, $this->internallink)) {
						$internallink = $this->internallink[$sharp . $k];
						$this->SetLink($internallink, $ypos, $pagenum);
						$sharp .= "#";
					}
				}
			}

			$this->bufferoutput = false;

			/* -- CSS-POSITION -- */
			if (count($this->fixedPosBlockSave) && $sub != 4) {
				foreach ($this->fixedPosBlockSave AS $fpbs) {
					$old_page = $this->page;
					$this->page = $fpbs[2];
					$this->WriteFixedPosHTML($fpbs[0], 0, 0, 100, 100, 'auto', $fpbs[1]);  // 0,0,10,10 are overwritten by bbox
					$this->page = $old_page;
				}
				$this->fixedPosBlockSave = array();
			}
			/* -- END CSS-POSITION -- */
		}
	}

	/* -- CSS-POSITION -- */

	function WriteFixedPosHTML($html = '', $x, $y, $w, $h, $overflow = 'visible', $bounding = array())
	{
		// $overflow can be 'hidden', 'visible' or 'auto' - 'auto' causes autofit to size
		// Annotations disabled - enabled in mPDF 5.0
		// Links do work
		// Will always go on current page (or start Page 1 if required)
		// Probably INCOMPATIBLE WITH keep with table, columns etc.
		// Called externally or interally via <div style="position: [fixed|absolute]">
		// When used internally, $x $y $w $h and $overflow are all overridden by $bounding

		$overflow = strtolower($overflow);
		if ($this->state == 0) {
			$this->AddPage($this->CurOrientation);
		}
		$save_y = $this->y;
		$save_x = $this->x;
		$this->fullImageHeight = $this->h;
		$save_cols = false;
		/* -- COLUMNS -- */
		if ($this->ColActive) {
			$save_cols = true;
			$save_nbcol = $this->NbCol; // other values of gap and vAlign will not change by setting Columns off
			$this->SetColumns(0);
		}
		/* -- END COLUMNS -- */
		$save_annots = $this->title2annots; // *ANNOTATIONS*
		$this->writingHTMLheader = true; // a FIX to stop pagebreaks etc.
		$this->writingHTMLfooter = true;
		$this->InFooter = true; // suppresses autopagebreaks
		$save_bgs = $this->pageBackgrounds;
		$checkinnerhtml = preg_replace('/\s/', '', $html);

		if ($w > $this->w) {
			$x = 0;
			$w = $this->w;
		}
		if ($h > $this->h) {
			$y = 0;
			$h = $this->h;
		}
		if ($x > $this->w) {
			$x = $this->w - $w;
		}
		if ($y > $this->h) {
			$y = $this->h - $h;
		}

		if (!empty($bounding)) {
			// $cont_ containing block = full physical page (position: absolute) or page inside margins (position: fixed)
			// $bbox_ Bounding box is the <div> which is positioned absolutely/fixed
			// top/left/right/bottom/width/height/background*/border*/padding*/margin* are taken from bounding
			// font*[family/size/style/weight]/line-height/text*[align/decoration/transform/indent]/color are transferred to $inner
			// as an enclosing <div> (after having checked ID/CLASS)
			// $x, $y, $w, $h are inside of $bbox_ = containing box for $inner_
			// $inner_ InnerHTML is the contents of that block to be output
			$tag = $bounding[0];
			$attr = $bounding[1];
			$orig_x0 = $bounding[2];
			$orig_y0 = $bounding[3];

			// As in WriteHTML() initialising
			$this->blklvl = 0;
			$this->lastblocklevelchange = 0;
			$this->blk = array();
			$this->initialiseBlock($this->blk[0]);

			$this->blk[0]['width'] = & $this->pgwidth;
			$this->blk[0]['inner_width'] = & $this->pgwidth;

			$this->blk[0]['blockContext'] = $this->blockContext;

			$properties = $this->cssmgr->MergeCSS('BLOCK', 'BODY', '');
			$this->setCSS($properties, '', 'BODY');
			$this->blklvl = 1;
			$this->initialiseBlock($this->blk[1]);
			$this->blk[1]['tag'] = $tag;
			$this->blk[1]['attr'] = $attr;
			$this->Reset();
			$p = $this->cssmgr->MergeCSS('BLOCK', $tag, $attr);
			if (isset($p['ROTATE']) && ($p['ROTATE'] == 90 || $p['ROTATE'] == -90 || $p['ROTATE'] == 180)) {
				$rotate = $p['ROTATE'];
			} // mPDF 6
			else {
				$rotate = 0;
			}
			if (isset($p['OVERFLOW'])) {
				$overflow = strtolower($p['OVERFLOW']);
			}
			if (strtolower($p['POSITION']) == 'fixed') {
				$cont_w = $this->pgwidth; // $this->blk[0]['inner_width'];
				$cont_h = $this->h - $this->tMargin - $this->bMargin;
				$cont_x = $this->lMargin;
				$cont_y = $this->tMargin;
			} else {
				$cont_w = $this->w; // ABSOLUTE;
				$cont_h = $this->h;
				$cont_x = 0;
				$cont_y = 0;
			}

			// Pass on in-line properties to the innerhtml
			$css = '';
			if (isset($p['TEXT-ALIGN'])) {
				$css .= 'text-align: ' . strtolower($p['TEXT-ALIGN']) . '; ';
			}
			if (isset($p['TEXT-TRANSFORM'])) {
				$css .= 'text-transform: ' . strtolower($p['TEXT-TRANSFORM']) . '; ';
			}
			if (isset($p['TEXT-INDENT'])) {
				$css .= 'text-indent: ' . strtolower($p['TEXT-INDENT']) . '; ';
			}
			if (isset($p['TEXT-DECORATION'])) {
				$css .= 'text-decoration: ' . strtolower($p['TEXT-DECORATION']) . '; ';
			}
			if (isset($p['FONT-FAMILY'])) {
				$css .= 'font-family: ' . strtolower($p['FONT-FAMILY']) . '; ';
			}
			if (isset($p['FONT-STYLE'])) {
				$css .= 'font-style: ' . strtolower($p['FONT-STYLE']) . '; ';
			}
			if (isset($p['FONT-WEIGHT'])) {
				$css .= 'font-weight: ' . strtolower($p['FONT-WEIGHT']) . '; ';
			}
			if (isset($p['FONT-SIZE'])) {
				$css .= 'font-size: ' . strtolower($p['FONT-SIZE']) . '; ';
			}
			if (isset($p['LINE-HEIGHT'])) {
				$css .= 'line-height: ' . strtolower($p['LINE-HEIGHT']) . '; ';
			}
			if (isset($p['TEXT-SHADOW'])) {
				$css .= 'text-shadow: ' . strtolower($p['TEXT-SHADOW']) . '; ';
			}
			if (isset($p['LETTER-SPACING'])) {
				$css .= 'letter-spacing: ' . strtolower($p['LETTER-SPACING']) . '; ';
			}
			// mPDF 6
			if (isset($p['FONT-VARIANT-POSITION'])) {
				$css .= 'font-variant-position: ' . strtolower($p['FONT-VARIANT-POSITION']) . '; ';
			}
			if (isset($p['FONT-VARIANT-CAPS'])) {
				$css .= 'font-variant-caps: ' . strtolower($p['FONT-VARIANT-CAPS']) . '; ';
			}
			if (isset($p['FONT-VARIANT-LIGATURES'])) {
				$css .= 'font-variant-ligatures: ' . strtolower($p['FONT-VARIANT-LIGATURES']) . '; ';
			}
			if (isset($p['FONT-VARIANT-NUMERIC'])) {
				$css .= 'font-variant-numeric: ' . strtolower($p['FONT-VARIANT-NUMERIC']) . '; ';
			}
			if (isset($p['FONT-VARIANT-ALTERNATES'])) {
				$css .= 'font-variant-alternates: ' . strtolower($p['FONT-VARIANT-ALTERNATES']) . '; ';
			}
			if (isset($p['FONT-FEATURE-SETTINGS'])) {
				$css .= 'font-feature-settings: ' . strtolower($p['FONT-FEATURE-SETTINGS']) . '; ';
			}
			if (isset($p['FONT-LANGUAGE-OVERRIDE'])) {
				$css .= 'font-language-override: ' . strtolower($p['FONT-LANGUAGE-OVERRIDE']) . '; ';
			}
			if (isset($p['FONT-KERNING'])) {
				$css .= 'font-kerning: ' . strtolower($p['FONT-KERNING']) . '; ';
			}

			if (isset($p['COLOR'])) {
				$css .= 'color: ' . strtolower($p['COLOR']) . '; ';
			}
			if (isset($p['Z-INDEX'])) {
				$css .= 'z-index: ' . $p['Z-INDEX'] . '; ';
			}
			if ($css) {
				$html = '<div style="' . $css . '">' . $html . '</div>';
			}
			// Copy over (only) the properties to set for border and background
			$pb = array();
			$pb['MARGIN-TOP'] = (isset($p['MARGIN-TOP']) ? $p['MARGIN-TOP'] : '');
			$pb['MARGIN-RIGHT'] = (isset($p['MARGIN-RIGHT']) ? $p['MARGIN-RIGHT'] : '');
			$pb['MARGIN-BOTTOM'] = (isset($p['MARGIN-BOTTOM']) ? $p['MARGIN-BOTTOM'] : '');
			$pb['MARGIN-LEFT'] = (isset($p['MARGIN-LEFT']) ? $p['MARGIN-LEFT'] : '');
			$pb['PADDING-TOP'] = (isset($p['PADDING-TOP']) ? $p['PADDING-TOP'] : '');
			$pb['PADDING-RIGHT'] = (isset($p['PADDING-RIGHT']) ? $p['PADDING-RIGHT'] : '');
			$pb['PADDING-BOTTOM'] = (isset($p['PADDING-BOTTOM']) ? $p['PADDING-BOTTOM'] : '');
			$pb['PADDING-LEFT'] = (isset($p['PADDING-LEFT']) ? $p['PADDING-LEFT'] : '');
			$pb['BORDER-TOP'] = (isset($p['BORDER-TOP']) ? $p['BORDER-TOP'] : '');
			$pb['BORDER-RIGHT'] = (isset($p['BORDER-RIGHT']) ? $p['BORDER-RIGHT'] : '');
			$pb['BORDER-BOTTOM'] = (isset($p['BORDER-BOTTOM']) ? $p['BORDER-BOTTOM'] : '');
			$pb['BORDER-LEFT'] = (isset($p['BORDER-LEFT']) ? $p['BORDER-LEFT'] : '');
			if (isset($p['BORDER-TOP-LEFT-RADIUS-H'])) {
				$pb['BORDER-TOP-LEFT-RADIUS-H'] = $p['BORDER-TOP-LEFT-RADIUS-H'];
			}
			if (isset($p['BORDER-TOP-LEFT-RADIUS-V'])) {
				$pb['BORDER-TOP-LEFT-RADIUS-V'] = $p['BORDER-TOP-LEFT-RADIUS-V'];
			}
			if (isset($p['BORDER-TOP-RIGHT-RADIUS-H'])) {
				$pb['BORDER-TOP-RIGHT-RADIUS-H'] = $p['BORDER-TOP-RIGHT-RADIUS-H'];
			}
			if (isset($p['BORDER-TOP-RIGHT-RADIUS-V'])) {
				$pb['BORDER-TOP-RIGHT-RADIUS-V'] = $p['BORDER-TOP-RIGHT-RADIUS-V'];
			}
			if (isset($p['BORDER-BOTTOM-LEFT-RADIUS-H'])) {
				$pb['BORDER-BOTTOM-LEFT-RADIUS-H'] = $p['BORDER-BOTTOM-LEFT-RADIUS-H'];
			}
			if (isset($p['BORDER-BOTTOM-LEFT-RADIUS-V'])) {
				$pb['BORDER-BOTTOM-LEFT-RADIUS-V'] = $p['BORDER-BOTTOM-LEFT-RADIUS-V'];
			}
			if (isset($p['BORDER-BOTTOM-RIGHT-RADIUS-H'])) {
				$pb['BORDER-BOTTOM-RIGHT-RADIUS-H'] = $p['BORDER-BOTTOM-RIGHT-RADIUS-H'];
			}
			if (isset($p['BORDER-BOTTOM-RIGHT-RADIUS-V'])) {
				$pb['BORDER-BOTTOM-RIGHT-RADIUS-V'] = $p['BORDER-BOTTOM-RIGHT-RADIUS-V'];
			}
			if (isset($p['BACKGROUND-COLOR'])) {
				$pb['BACKGROUND-COLOR'] = $p['BACKGROUND-COLOR'];
			}
			if (isset($p['BOX-SHADOW'])) {
				$pb['BOX-SHADOW'] = $p['BOX-SHADOW'];
			}
			/* -- BACKGROUNDS -- */
			if (isset($p['BACKGROUND-IMAGE'])) {
				$pb['BACKGROUND-IMAGE'] = $p['BACKGROUND-IMAGE'];
			}
			if (isset($p['BACKGROUND-IMAGE-RESIZE'])) {
				$pb['BACKGROUND-IMAGE-RESIZE'] = $p['BACKGROUND-IMAGE-RESIZE'];
			}
			if (isset($p['BACKGROUND-IMAGE-OPACITY'])) {
				$pb['BACKGROUND-IMAGE-OPACITY'] = $p['BACKGROUND-IMAGE-OPACITY'];
			}
			if (isset($p['BACKGROUND-REPEAT'])) {
				$pb['BACKGROUND-REPEAT'] = $p['BACKGROUND-REPEAT'];
			}
			if (isset($p['BACKGROUND-POSITION'])) {
				$pb['BACKGROUND-POSITION'] = $p['BACKGROUND-POSITION'];
			}
			if (isset($p['BACKGROUND-GRADIENT'])) {
				$pb['BACKGROUND-GRADIENT'] = $p['BACKGROUND-GRADIENT'];
			}
			if (isset($p['BACKGROUND-SIZE'])) {
				$pb['BACKGROUND-SIZE'] = $p['BACKGROUND-SIZE'];
			}
			if (isset($p['BACKGROUND-ORIGIN'])) {
				$pb['BACKGROUND-ORIGIN'] = $p['BACKGROUND-ORIGIN'];
			}
			if (isset($p['BACKGROUND-CLIP'])) {
				$pb['BACKGROUND-CLIP'] = $p['BACKGROUND-CLIP'];
			}

			/* -- END BACKGROUNDS -- */

			$this->setCSS($pb, 'BLOCK', $tag);

			//================================================================
			$bbox_br = $this->blk[1]['border_right']['w'];
			$bbox_bl = $this->blk[1]['border_left']['w'];
			$bbox_bt = $this->blk[1]['border_top']['w'];
			$bbox_bb = $this->blk[1]['border_bottom']['w'];
			$bbox_pr = $this->blk[1]['padding_right'];
			$bbox_pl = $this->blk[1]['padding_left'];
			$bbox_pt = $this->blk[1]['padding_top'];
			$bbox_pb = $this->blk[1]['padding_bottom'];
			$bbox_mr = $this->blk[1]['margin_right'];
			if (isset($p['MARGIN-RIGHT']) && strtolower($p['MARGIN-RIGHT']) == 'auto') {
				$bbox_mr = 'auto';
			}
			$bbox_ml = $this->blk[1]['margin_left'];
			if (isset($p['MARGIN-LEFT']) && strtolower($p['MARGIN-LEFT']) == 'auto') {
				$bbox_ml = 'auto';
			}
			$bbox_mt = $this->blk[1]['margin_top'];
			if (isset($p['MARGIN-TOP']) && strtolower($p['MARGIN-TOP']) == 'auto') {
				$bbox_mt = 'auto';
			}
			$bbox_mb = $this->blk[1]['margin_bottom'];
			if (isset($p['MARGIN-BOTTOM']) && strtolower($p['MARGIN-BOTTOM']) == 'auto') {
				$bbox_mb = 'auto';
			}
			if (isset($p['LEFT']) && strtolower($p['LEFT']) != 'auto') {
				$bbox_left = $this->ConvertSize($p['LEFT'], $cont_w, $this->FontSize, false);
			} else {
				$bbox_left = 'auto';
			}
			if (isset($p['TOP']) && strtolower($p['TOP']) != 'auto') {
				$bbox_top = $this->ConvertSize($p['TOP'], $cont_h, $this->FontSize, false);
			} else {
				$bbox_top = 'auto';
			}
			if (isset($p['RIGHT']) && strtolower($p['RIGHT']) != 'auto') {
				$bbox_right = $this->ConvertSize($p['RIGHT'], $cont_w, $this->FontSize, false);
			} else {
				$bbox_right = 'auto';
			}
			if (isset($p['BOTTOM']) && strtolower($p['BOTTOM']) != 'auto') {
				$bbox_bottom = $this->ConvertSize($p['BOTTOM'], $cont_h, $this->FontSize, false);
			} else {
				$bbox_bottom = 'auto';
			}
			if (isset($p['WIDTH']) && strtolower($p['WIDTH']) != 'auto') {
				$inner_w = $this->ConvertSize($p['WIDTH'], $cont_w, $this->FontSize, false);
			} else {
				$inner_w = 'auto';
			}
			if (isset($p['HEIGHT']) && strtolower($p['HEIGHT']) != 'auto') {
				$inner_h = $this->ConvertSize($p['HEIGHT'], $cont_h, $this->FontSize, false);
			} else {
				$inner_h = 'auto';
			}

			// If bottom or right pos are set and not left / top - save this to adjust rotated block later
			if ($rotate == 90 || $rotate == -90) { // mPDF 6
				if ($bbox_left === 'auto' && $bbox_right !== 'auto') {
					$rot_rpos = $bbox_right;
				} else {
					$rot_rpos = false;
				}
				if ($bbox_top === 'auto' && $bbox_bottom !== 'auto') {
					$rot_bpos = $bbox_bottom;
				} else {
					$rot_bpos = false;
				}
			}

			//================================================================
			if ($checkinnerhtml == '' && $inner_h === 'auto') {
				$inner_h = 0.0001;
			}
			if ($checkinnerhtml == '' && $inner_w === 'auto') {
				$inner_w = 2 * $this->GetCharWidth('W', false);
			}
			//================================================================
			// Algorithm from CSS2.1  See http://www.w3.org/TR/CSS21/visudet.html#abs-non-replaced-height
			// mPD 5.3.14
			// Special case (not CSS) if all not specified, centre vertically on page
			$bbox_top_orig = '';
			if ($bbox_top === 'auto' && $inner_h === 'auto' && $bbox_bottom === 'auto' && $bbox_mt === 'auto' && $bbox_mb === 'auto') {
				$bbox_top_orig = $bbox_top;
				if ($bbox_mt === 'auto') {
					$bbox_mt = 0;
				}
				if ($bbox_mb === 'auto') {
					$bbox_mb = 0;
				}
				$bbox_top = $orig_y0 - $bbox_mt - $cont_y;
				// solve for $bbox_bottom when content_h known - $inner_h=='auto' && $bbox_bottom=='auto'
			}
			// mPD 5.3.14
			elseif ($bbox_top === 'auto' && $inner_h === 'auto' && $bbox_bottom === 'auto') {
				$bbox_top_orig = $bbox_top = $orig_y0 - $cont_y;
				if ($bbox_mt === 'auto') {
					$bbox_mt = 0;
				}
				if ($bbox_mb === 'auto') {
					$bbox_mb = 0;
				}
				// solve for $bbox_bottom when content_h known - $inner_h=='auto' && $bbox_bottom=='auto'
			} elseif ($bbox_top !== 'auto' && $inner_h !== 'auto' && $bbox_bottom !== 'auto') {
				if ($bbox_mt === 'auto' && $bbox_mb === 'auto') {
					$x = $cont_h - $bbox_top - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_bottom;
					$bbox_mt = $bbox_mb = ($x / 2);
				} elseif ($bbox_mt === 'auto') {
					$bbox_mt = $cont_h - $bbox_top - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_mb - $bbox_bottom;
				} elseif ($bbox_mb === 'auto') {
					$bbox_mb = $cont_h - $bbox_top - $bbox_mt - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_bottom;
				} else {
					$bbox_bottom = $cont_h - $bbox_top - $bbox_mt - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_mt;
				}
			} else {
				if ($bbox_mt === 'auto') {
					$bbox_mt = 0;
				}
				if ($bbox_mb === 'auto') {
					$bbox_mb = 0;
				}
				if ($bbox_top === 'auto' && $inner_h === 'auto' && $bbox_bottom !== 'auto') {
					// solve for $bbox_top when content_h known - $inner_h=='auto' && $bbox_top =='auto'
				} elseif ($bbox_top === 'auto' && $bbox_bottom === 'auto' && $inner_h !== 'auto') {
					$bbox_top = $orig_y0 - $bbox_mt - $cont_y;
					$bbox_bottom = $cont_h - $bbox_top - $bbox_mt - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_mt;
				} elseif ($inner_h === 'auto' && $bbox_bottom === 'auto' && $bbox_top !== 'auto') {
					// solve for $bbox_bottom when content_h known - $inner_h=='auto' && $bbox_bottom=='auto'
				} elseif ($bbox_top === 'auto' && $inner_h !== 'auto' && $bbox_bottom !== 'auto') {
					$bbox_top = $cont_h - $bbox_mt - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_mt - $bbox_bottom;
				} elseif ($inner_h === 'auto' && $bbox_top !== 'auto' && $bbox_bottom !== 'auto') {
					$inner_h = $cont_h - $bbox_top - $bbox_mt - $bbox_bt - $bbox_pt - $bbox_pb - $bbox_bb - $bbox_mt - $bbox_bottom;
				} elseif ($bbox_bottom === 'auto' && $bbox_top !== 'auto' && $inner_h !== 'auto') {
					$bbox_bottom = $cont_h - $bbox_top - $bbox_mt - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_mt;
				}
			}

			// THEN DO SAME FOR WIDTH
			// http://www.w3.org/TR/CSS21/visudet.html#abs-non-replaced-width
			if ($bbox_left === 'auto' && $inner_w === 'auto' && $bbox_right === 'auto') {
				if ($bbox_ml === 'auto') {
					$bbox_ml = 0;
				}
				if ($bbox_mr === 'auto') {
					$bbox_mr = 0;
				}
				// IF containing element RTL, should set $bbox_right
				$bbox_left = $orig_x0 - $bbox_ml - $cont_x;
				// solve for $bbox_right when content_w known - $inner_w=='auto' && $bbox_right=='auto'
			} elseif ($bbox_left !== 'auto' && $inner_w !== 'auto' && $bbox_right !== 'auto') {
				if ($bbox_ml === 'auto' && $bbox_mr === 'auto') {
					$x = $cont_w - $bbox_left - $bbox_bl - $bbox_pl - $inner_w - $bbox_pr - $bbox_br - $bbox_right;
					$bbox_ml = $bbox_mr = ($x / 2);
				} elseif ($bbox_ml === 'auto') {
					$bbox_ml = $cont_w - $bbox_left - $bbox_bl - $bbox_pl - $inner_w - $bbox_pr - $bbox_br - $bbox_mr - $bbox_right;
				} elseif ($bbox_mr === 'auto') {
					$bbox_mr = $cont_w - $bbox_left - $bbox_ml - $bbox_bl - $bbox_pl - $inner_w - $bbox_pr - $bbox_br - $bbox_right;
				} else {
					$bbox_right = $cont_w - $bbox_left - $bbox_ml - $bbox_bl - $bbox_pl - $inner_w - $bbox_pr - $bbox_br - $bbox_ml;
				}
			} else {
				if ($bbox_ml === 'auto') {
					$bbox_ml = 0;
				}
				if ($bbox_mr === 'auto') {
					$bbox_mr = 0;
				}
				if ($bbox_left === 'auto' && $inner_w === 'auto' && $bbox_right !== 'auto') {
					// solve for $bbox_left when content_w known - $inner_w=='auto' && $bbox_left =='auto'
				} elseif ($bbox_left === 'auto' && $bbox_right === 'auto' && $inner_w !== 'auto') {
					// IF containing element RTL, should set $bbox_right
					$bbox_left = $orig_x0 - $bbox_ml - $cont_x;
					$bbox_right = $cont_w - $bbox_left - $bbox_ml - $bbox_bl - $bbox_pl - $inner_w - $bbox_pr - $bbox_br - $bbox_ml;
				} elseif ($inner_w === 'auto' && $bbox_right === 'auto' && $bbox_left !== 'auto') {
					// solve for $bbox_right when content_w known - $inner_w=='auto' && $bbox_right=='auto'
				} elseif ($bbox_left === 'auto' && $inner_w !== 'auto' && $bbox_right !== 'auto') {
					$bbox_left = $cont_w - $bbox_ml - $bbox_bl - $bbox_pl - $inner_w - $bbox_pr - $bbox_br - $bbox_ml - $bbox_right;
				} elseif ($inner_w === 'auto' && $bbox_left !== 'auto' && $bbox_right !== 'auto') {
					$inner_w = $cont_w - $bbox_left - $bbox_ml - $bbox_bl - $bbox_pl - $bbox_pr - $bbox_br - $bbox_ml - $bbox_right;
				} elseif ($bbox_right === 'auto' && $bbox_left !== 'auto' && $inner_w !== 'auto') {
					$bbox_right = $cont_w - $bbox_left - $bbox_ml - $bbox_bl - $bbox_pl - $inner_w - $bbox_pr - $bbox_br - $bbox_ml;
				}
			}

			//================================================================
			//================================================================
			/* -- BACKGROUNDS -- */
			if (isset($pb['BACKGROUND-IMAGE']) && $pb['BACKGROUND-IMAGE']) {
				$ret = $this->SetBackground($pb, $this->blk[1]['inner_width']);
				if ($ret) {
					$this->blk[1]['background-image'] = $ret;
				}
			}
			/* -- END BACKGROUNDS -- */

			//================================================================
			$y = $cont_y + $bbox_top + $bbox_mt + $bbox_bt + $bbox_pt;
			$h = $cont_h - $bbox_top - $bbox_mt - $bbox_bt - $bbox_pt - $bbox_pb - $bbox_bb - $bbox_mb - $bbox_bottom;
			$x = $cont_x + $bbox_left + $bbox_ml + $bbox_bl + $bbox_pl;
			$w = $cont_w - $bbox_left - $bbox_ml - $bbox_bl - $bbox_pl - $bbox_pr - $bbox_br - $bbox_mr - $bbox_right;
			// Set (temporary) values for x y w h to do first paint, if values are auto
			if ($inner_h === 'auto' && $bbox_top === 'auto') {
				$y = $cont_y + $bbox_mt + $bbox_bt + $bbox_pt;
				$h = $cont_h - ($bbox_bottom + $bbox_mt + $bbox_mb + $bbox_bt + $bbox_bb + $bbox_pt + $bbox_pb);
			} elseif ($inner_h === 'auto' && $bbox_bottom === 'auto') {
				$y = $cont_y + $bbox_top + $bbox_mt + $bbox_bt + $bbox_pt;
				$h = $cont_h - ($bbox_top + $bbox_mt + $bbox_mb + $bbox_bt + $bbox_bb + $bbox_pt + $bbox_pb);
			}
			if ($inner_w === 'auto' && $bbox_left === 'auto') {
				$x = $cont_x + $bbox_ml + $bbox_bl + $bbox_pl;
				$w = $cont_w - ($bbox_right + $bbox_ml + $bbox_mr + $bbox_bl + $bbox_br + $bbox_pl + $bbox_pr);
			} elseif ($inner_w === 'auto' && $bbox_right === 'auto') {
				$x = $cont_x + $bbox_left + $bbox_ml + $bbox_bl + $bbox_pl;
				$w = $cont_w - ($bbox_left + $bbox_ml + $bbox_mr + $bbox_bl + $bbox_br + $bbox_pl + $bbox_pr);
			}
			$bbox_y = $cont_y + $bbox_top + $bbox_mt;
			$bbox_x = $cont_x + $bbox_left + $bbox_ml;
			$saved_block1 = $this->blk[1];
			unset($p);
			unset($pb);
			//================================================================
			if ($inner_w === 'auto') { // do a first write
				$this->lMargin = $x;
				$this->rMargin = $this->w - $w - $x;
				// SET POSITION & FONT VALUES
				$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
				$this->pageoutput[$this->page] = array();
				$this->x = $x;
				$this->y = $y;
				$this->HTMLheaderPageLinks = array();
				$this->HTMLheaderPageAnnots = array();
				$this->HTMLheaderPageForms = array();
				$this->pageBackgrounds = array();
				$this->maxPosR = 0;
				$this->maxPosL = $this->w; // For RTL
				$this->WriteHTML($html, 4);
				$inner_w = $this->maxPosR - $this->lMargin;
				if ($bbox_right === 'auto') {
					$bbox_right = $cont_w - $bbox_left - $bbox_ml - $bbox_bl - $bbox_pl - $inner_w - $bbox_pr - $bbox_br - $bbox_ml;
				} elseif ($bbox_left === 'auto') {
					$bbox_left = $cont_w - $bbox_ml - $bbox_bl - $bbox_pl - $inner_w - $bbox_pr - $bbox_br - $bbox_ml - $bbox_right;
					$bbox_x = $cont_x + $bbox_left + $bbox_ml;
					$inner_x = $bbox_x + $bbox_bl + $bbox_pl;
					$x = $inner_x;
				}
				$w = $inner_w;
				$bbox_y = $cont_y + $bbox_top + $bbox_mt;
				$bbox_x = $cont_x + $bbox_left + $bbox_ml;
			}

			if ($inner_h === 'auto') { // do a first write
				$this->lMargin = $x;
				$this->rMargin = $this->w - $w - $x;
				// SET POSITION & FONT VALUES
				$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
				$this->pageoutput[$this->page] = array();
				$this->x = $x;
				$this->y = $y;
				$this->HTMLheaderPageLinks = array();
				$this->HTMLheaderPageAnnots = array();
				$this->HTMLheaderPageForms = array();
				$this->pageBackgrounds = array();
				$this->WriteHTML($html, 4);
				$inner_h = $this->y - $y;
				if ($overflow != 'hidden' && $overflow != 'visible') { // constrained
					if (($this->y + $bbox_pb + $bbox_bb) > ($cont_y + $cont_h)) {
						$adj = ($this->y + $bbox_pb + $bbox_bb) - ($cont_y + $cont_h);
						$inner_h -= $adj;
					}
				}
				if ($bbox_bottom === 'auto' && $bbox_top_orig === 'auto') {
					$bbox_bottom = $bbox_top = ($cont_h - $bbox_mt - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_mb) / 2;
					if ($overflow != 'hidden' && $overflow != 'visible') { // constrained
						if ($bbox_top < 0) {
							$bbox_top = 0;
							$inner_h = $cont_h - $bbox_top - $bbox_mt - $bbox_bt - $bbox_pt - $bbox_pb - $bbox_bb - $bbox_mb - $bbox_bottom;
						}
					}
					$bbox_y = $cont_y + $bbox_top + $bbox_mt;
					$inner_y = $bbox_y + $bbox_bt + $bbox_pt;
					$y = $inner_y;
				} elseif ($bbox_bottom === 'auto') {
					$bbox_bottom = $cont_h - $bbox_top - $bbox_mt - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_mb;
				} elseif ($bbox_top === 'auto') {
					$bbox_top = $cont_h - $bbox_mt - $bbox_bt - $bbox_pt - $inner_h - $bbox_pb - $bbox_bb - $bbox_mb - $bbox_bottom;
					if ($overflow != 'hidden' && $overflow != 'visible') { // constrained
						if ($bbox_top < 0) {
							$bbox_top = 0;
							$inner_h = $cont_h - $bbox_top - $bbox_mt - $bbox_bt - $bbox_pt - $bbox_pb - $bbox_bb - $bbox_mb - $bbox_bottom;
						}
					}
					$bbox_y = $cont_y + $bbox_top + $bbox_mt;
					$inner_y = $bbox_y + $bbox_bt + $bbox_pt;
					$y = $inner_y;
				}
				$h = $inner_h;
				$bbox_y = $cont_y + $bbox_top + $bbox_mt;
				$bbox_x = $cont_x + $bbox_left + $bbox_ml;
			}
			$inner_w = $w;
			$inner_h = $h;
		}
		$this->lMargin = $x;
		$this->rMargin = $this->w - $w - $x;
		// SET POSITION & FONT VALUES
		$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
		$this->pageoutput[$this->page] = array();
		$this->x = $x;
		$this->y = $y;
		$this->HTMLheaderPageLinks = array();
		$this->HTMLheaderPageAnnots = array();
		$this->HTMLheaderPageForms = array();
		$this->pageBackgrounds = array();
		$this->WriteHTML($html, 4); // parameter 4 saves output to $this->headerbuffer
		$actual_h = $this->y - $y;
		$use_w = $w;
		$use_h = $h;
		$ratio = $actual_h / $use_w;

		if ($overflow != 'hidden' && $overflow != 'visible') {
			$target = $h / $w;
			if (($ratio / $target ) > 1) {
				$nl = CEIL($actual_h / $this->lineheight);
				$l = $use_w * $nl;
				$est_w = sqrt(($l * $this->lineheight) / $target) * 0.8;
				$use_w += ($est_w - $use_w) - ($w / 100);
			}
			$bpcstart = ($ratio / $target);
			$bpcctr = 1;
			while (($ratio / $target ) > 1) {

				if ($this->progressBar) {
					$this->UpdateProgressBar(4, intval(100 / ($ratio / $target)), ('Auto-sizing fixed-position block: ' . $bpcctr++));
				} // *PROGRESS-BAR*

				$this->x = $x;
				$this->y = $y;

				if (($ratio / $target) > 1.5 || ($ratio / $target) < 0.6) {
					$use_w += ($w / $this->incrementFPR1);
				} elseif (($ratio / $target) > 1.2 || ($ratio / $target) < 0.85) {
					$use_w += ($w / $this->incrementFPR2);
				} elseif (($ratio / $target) > 1.1 || ($ratio / $target) < 0.91) {
					$use_w += ($w / $this->incrementFPR3);
				} else {
					$use_w += ($w / $this->incrementFPR4);
				}

				$use_h = $use_w * $target;
				$this->rMargin = $this->w - $use_w - $x;
				$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
				$this->HTMLheaderPageLinks = array();
				$this->HTMLheaderPageAnnots = array();
				$this->HTMLheaderPageForms = array();
				$this->pageBackgrounds = array();
				$this->WriteHTML($html, 4); // parameter 4 saves output to $this->headerbuffer
				$actual_h = $this->y - $y;
				$ratio = $actual_h / $use_w;
			}
			if ($this->progressBar) {
				$this->UpdateProgressBar(4, '100', ' ');
			} // *PROGRESS-BAR*
		}
		$shrink_f = $w / $use_w;

		//================================================================

		$this->pages[$this->page] .= '___BEFORE_BORDERS___';
		$block_s = $this->PrintPageBackgrounds(); // Save to print later inside clipping path
		$this->pageBackgrounds = array();

		//================================================================

		if ($rotate == 90 || $rotate == -90) { // mPDF 6
			$prerotw = $bbox_bl + $bbox_pl + $inner_w + $bbox_pr + $bbox_br;
			$preroth = $bbox_bt + $bbox_pt + $inner_h + $bbox_pb + $bbox_bb;
			$rot_start = " q\n";
			if ($rotate == 90) {
				if ($rot_rpos !== false) {
					$adjw = $prerotw;
				} // width before rotation
				else {
					$adjw = $preroth;
				} // height before rotation
				if ($rot_bpos !== false) {
					$adjh = -$prerotw + $preroth;
				} else {
					$adjh = 0;
				}
			} else {
				if ($rot_rpos !== false) {
					$adjw = $prerotw - $preroth;
				} else {
					$adjw = 0;
				}
				if ($rot_bpos !== false) {
					$adjh = $preroth;
				} // height before rotation
				else {
					$adjh = $prerotw;
				} // width before rotation
			}
			$rot_start .= $this->transformTranslate($adjw, $adjh, true) . "\n";
			$rot_start .= $this->transformRotate($rotate, $bbox_x, $bbox_y, true) . "\n";
			$rot_end = " Q\n";
		} elseif ($rotate == 180) { // mPDF 6
			$rot_start = " q\n";
			$rot_start .= $this->transformTranslate($bbox_bl + $bbox_pl + $inner_w + $bbox_pr + $bbox_br, $bbox_bt + $bbox_pt + $inner_h + $bbox_pb + $bbox_bb, true) . "\n";
			$rot_start .= $this->transformRotate(180, $bbox_x, $bbox_y, true) . "\n";
			$rot_end = " Q\n";
		} else {
			$rot_start = '';
			$rot_end = '';
		}

		//================================================================
		if (!empty($bounding)) {
			// WHEN HEIGHT // BOTTOM EDGE IS KNOWN and $this->y is set to the bottom
			// Re-instate saved $this->blk[1]
			$this->blk[1] = $saved_block1;

			// These are only needed when painting border/background
			$this->blk[1]['width'] = $bbox_w = $cont_w - $bbox_left - $bbox_ml - $bbox_mr - $bbox_right;
			$this->blk[1]['x0'] = $bbox_x;
			$this->blk[1]['y0'] = $bbox_y;
			$this->blk[1]['startpage'] = $this->page;
			$this->blk[1]['y1'] = $bbox_y + $bbox_bt + $bbox_pt + $inner_h + $bbox_pb + $bbox_bb;
			$this->_out($rot_start);
			$this->PaintDivBB('', 0, 1); // Prints borders and sets backgrounds in $this->pageBackgrounds
			$this->_out($rot_end);
		}

		$s = $this->PrintPageBackgrounds();
		$s = $rot_start . $s . $rot_end;
		$this->pages[$this->page] = preg_replace('/___BEFORE_BORDERS___/', "\n" . $s . "\n", $this->pages[$this->page]);
		$this->pageBackgrounds = array();

		$this->_out($rot_start);

		// Clipping Output
		if ($overflow == 'hidden') {
			//Bounding rectangle to clip
			$clip_y1 = $this->y;
			if (!empty($bounding) && ($this->y + $bbox_pb + $bbox_bb) > ($bbox_y + $bbox_bt + $bbox_pt + $inner_h + $bbox_pb + $bbox_bb )) {
				$clip_y1 = ($bbox_y + $bbox_bt + $bbox_pt + $inner_h + $bbox_pb + $bbox_bb ) - ($bbox_pb + $bbox_bb);
			}
			//$op = 'W* n';	// Clipping
			$op = 'W n'; // Clipping alternative mode
			$this->_out("q");
			$ch = $clip_y1 - $y;
			$this->_out(sprintf('%.3F %.3F %.3F %.3F re %s', $x * _MPDFK, ($this->h - $y) * _MPDFK, $w * _MPDFK, -$ch * _MPDFK, $op));
			if (!empty($block_s)) {
				$tmp = "q\n" . sprintf('%.3F %.3F %.3F %.3F re %s', $x * _MPDFK, ($this->h - $y) * _MPDFK, $w * _MPDFK, -$ch * _MPDFK, $op);
				$tmp .= "\n" . $block_s . "\nQ";
				$block_s = $tmp;
			}
		}


		if (!empty($block_s)) {
			if ($shrink_f != 1) { // i.e. autofit has resized the box
				$tmp = "q\n" . $this->transformScale(($shrink_f * 100), ($shrink_f * 100), $x, $y, true);
				$tmp .= "\n" . $block_s . "\nQ";
				$block_s = $tmp;
			}
			$this->_out($block_s);
		}



		if ($shrink_f != 1) { // i.e. autofit has resized the box
			$this->StartTransform();
			$this->transformScale(($shrink_f * 100), ($shrink_f * 100), $x, $y);
		}

		$this->_out($this->headerbuffer);

		if ($shrink_f != 1) { // i.e. autofit has resized the box
			$this->StopTransform();
		}

		if ($overflow == 'hidden') {
			//End clipping
			$this->_out("Q");
		}

		$this->_out($rot_end);


		// Page Links
		foreach ($this->HTMLheaderPageLinks AS $lk) {
			if ($rotate) {
				$tmp = $lk[2]; // Switch h - w
				$lk[2] = $lk[3];
				$lk[3] = $tmp;

				$lx1 = (($lk[0] / _MPDFK));
				$ly1 = (($this->h - ($lk[1] / _MPDFK)));
				if ($rotate == 90) {
					$adjx = -($lx1 - $bbox_x) + ($preroth - ($ly1 - $bbox_y));
					$adjy = -($ly1 - $bbox_y) + ($lx1 - $bbox_x);
					$lk[2] = -$lk[2];
				} elseif ($rotate == -90) {
					$adjx = -($lx1 - $bbox_x) + ($ly1 - $bbox_y);
					$adjy = -($ly1 - $bbox_y) - ($lx1 - $bbox_x) + $prerotw;
					$lk[3] = -$lk[3];
				}
				if ($rot_rpos !== false) {
					$adjx += $prerotw - $preroth;
				}
				if ($rot_bpos !== false) {
					$adjy += $preroth - $prerotw;
				}
				$lx1 += $adjx;
				$ly1 += $adjy;

				$lk[0] = $lx1 * _MPDFK;
				$lk[1] = ($this->h - $ly1) * _MPDFK;
			}
			if ($shrink_f != 1) {  // i.e. autofit has resized the box
				$lx1 = (($lk[0] / _MPDFK) - $x);
				$lx2 = $x + ($lx1 * $shrink_f);
				$lk[0] = $lx2 * _MPDFK;
				$ly1 = (($this->h - ($lk[1] / _MPDFK)) - $y);
				$ly2 = $y + ($ly1 * $shrink_f);
				$lk[1] = ($this->h - $ly2) * _MPDFK;
				$lk[2] *= $shrink_f; // width
				$lk[3] *= $shrink_f; // height
			}
			$this->PageLinks[$this->page][] = $lk;
		}

		foreach ($this->HTMLheaderPageForms AS $n => $f) {
			if ($shrink_f != 1) {  // i.e. autofit has resized the box
				$f['x'] = $x + (($f['x'] - $x) * $shrink_f);
				$f['y'] = $y + (($f['y'] - $y) * $shrink_f);
				$f['w'] *= $shrink_f;
				$f['h'] *= $shrink_f;
				$f['style']['fontsize'] *= $shrink_f;
			}
			$this->mpdfform->forms[$f['n']] = $f;
		}
		// Page Annotations
		foreach ($this->HTMLheaderPageAnnots AS $lk) {
			if ($rotate) {
				if ($rotate == 90) {
					$adjx = -($lk['x'] - $bbox_x) + ($preroth - ($lk['y'] - $bbox_y));
					$adjy = -($lk['y'] - $bbox_y) + ($lk['x'] - $bbox_x);
				} elseif ($rotate == -90) {
					$adjx = -($lk['x'] - $bbox_x) + ($lk['y'] - $bbox_y);
					$adjy = -($lk['y'] - $bbox_y) - ($lk['x'] - $bbox_x) + $prerotw;
				}
				if ($rot_rpos !== false) {
					$adjx += $prerotw - $preroth;
				}
				if ($rot_bpos !== false) {
					$adjy += $preroth - $prerotw;
				}
				$lk['x'] += $adjx;
				$lk['y'] += $adjy;
			}
			if ($shrink_f != 1) {  // i.e. autofit has resized the box
				$lk['x'] = $x + (($lk['x'] - $x) * $shrink_f);
				$lk['y'] = $y + (($lk['y'] - $y) * $shrink_f);
			}
			$this->PageAnnots[$this->page][] = $lk;
		}

		// Restore
		$this->headerbuffer = '';
		$this->HTMLheaderPageLinks = array();
		$this->HTMLheaderPageAnnots = array();
		$this->HTMLheaderPageForms = array();
		$this->pageBackgrounds = $save_bgs;
		$this->writingHTMLheader = false;

		$this->writingHTMLfooter = false;
		$this->fullImageHeight = false;
		$this->ResetMargins();
		$this->pgwidth = $this->w - $this->lMargin - $this->rMargin;
		$this->SetXY($save_x, $save_y);
		$this->title2annots = $save_annots; // *ANNOTATIONS*
		$this->InFooter = false; // turns back on autopagebreaks
		$this->pageoutput[$this->page] = array();
		$this->pageoutput[$this->page]['Font'] = '';
		/* -- COLUMNS -- */
		if ($save_cols) {
			$this->SetColumns($save_nbcol, $this->colvAlign, $this->ColGap);
		}
		/* -- END COLUMNS -- */
	}

	/* -- END CSS-POSITION -- */

	function initialiseBlock(&$blk)
	{
		$blk['margin_top'] = 0;
		$blk['margin_left'] = 0;
		$blk['margin_bottom'] = 0;
		$blk['margin_right'] = 0;
		$blk['padding_top'] = 0;
		$blk['padding_left'] = 0;
		$blk['padding_bottom'] = 0;
		$blk['padding_right'] = 0;
		$blk['border_top']['w'] = 0;
		$blk['border_left']['w'] = 0;
		$blk['border_bottom']['w'] = 0;
		$blk['border_right']['w'] = 0;
		$blk['direction'] = 'ltr';
		$blk['hide'] = false;
		$blk['outer_left_margin'] = 0;
		$blk['outer_right_margin'] = 0;
		$blk['cascadeCSS'] = array();
		$blk['block-align'] = false;
		$blk['bgcolor'] = false;
		$blk['page_break_after_avoid'] = false;
		$blk['keep_block_together'] = false;
		$blk['float'] = false;
		$blk['line_height'] = '';
		$blk['margin_collapse'] = false;
	}

	function border_details($bd)
	{
		$prop = preg_split('/\s+/', trim($bd));

		if (isset($this->blk[$this->blklvl]['inner_width'])) {
			$refw = $this->blk[$this->blklvl]['inner_width'];
		} elseif (isset($this->blk[$this->blklvl - 1]['inner_width'])) {
			$refw = $this->blk[$this->blklvl - 1]['inner_width'];
		} else {
			$refw = $this->w;
		}
		if (count($prop) == 1) {
			$bsize = $this->ConvertSize($prop[0], $refw, $this->FontSize, false);
			if ($bsize > 0) {
				return array('s' => 1, 'w' => $bsize, 'c' => $this->ConvertColor(0), 'style' => 'solid');
			} else {
				return array('w' => 0, 's' => 0);
			}
		} elseif (count($prop) == 2) {
			// 1px solid
			if (in_array($prop[1], $this->borderstyles) || $prop[1] == 'none' || $prop[1] == 'hidden') {
				$prop[2] = '';
			}
			// solid #000000
			elseif (in_array($prop[0], $this->borderstyles) || $prop[0] == 'none' || $prop[0] == 'hidden') {
				$prop[0] = '';
				$prop[1] = $prop[0];
				$prop[2] = $prop[1];
			}
			// 1px #000000
			else {
				$prop[1] = '';
				$prop[2] = $prop[1];
			}
		} elseif (count($prop) == 3) {
			// Change #000000 1px solid to 1px solid #000000 (proper)
			if (substr($prop[0], 0, 1) == '#') {
				$tmp = $prop[0];
				$prop[0] = $prop[1];
				$prop[1] = $prop[2];
				$prop[2] = $tmp;
			}
			// Change solid #000000 1px to 1px solid #000000 (proper)
			elseif (substr($prop[0], 1, 1) == '#') {
				$tmp = $prop[1];
				$prop[0] = $prop[2];
				$prop[1] = $prop[0];
				$prop[2] = $tmp;
			}
			// Change solid 1px #000000 to 1px solid #000000 (proper)
			elseif (in_array($prop[0], $this->borderstyles) || $prop[0] == 'none' || $prop[0] == 'hidden') {
				$tmp = $prop[0];
				$prop[0] = $prop[1];
				$prop[1] = $tmp;
			}
		} else {
			return array();
		}
		// Size
		$bsize = $this->ConvertSize($prop[0], $refw, $this->FontSize, false);
		//color
		$coul = $this->ConvertColor($prop[2]); // returns array
		// Style
		$prop[1] = strtolower($prop[1]);
		if (in_array($prop[1], $this->borderstyles) && $bsize > 0) {
			$on = 1;
		} elseif ($prop[1] == 'hidden') {
			$on = 1;
			$bsize = 0;
			$coul = '';
		} elseif ($prop[1] == 'none') {
			$on = 0;
			$bsize = 0;
			$coul = '';
		} else {
			$on = 0;
			$bsize = 0;
			$coul = '';
			$prop[1] = '';
		}
		return array('s' => $on, 'w' => $bsize, 'c' => $coul, 'style' => $prop[1]);
	}

	/* -- END HTML-CSS -- */


	/* -- BORDER-RADIUS -- */

	function _borderPadding($a, $b, &$px, &$py)
	{
		// $px and py are padding long axis (x) and short axis (y)
		$added = 0; // extra padding

		$x = $a - $px;
		$y = $b - $py;
		// Check if Falls within ellipse of border radius
		if (( (($x + $added) * ($x + $added)) / ($a * $a) + (($y + $added) * ($y + $added)) / ($b * $b) ) <= 1) {
			return false;
		}

		$t = atan2($y, $x);

		$newx = $b / sqrt((($b * $b) / ($a * $a)) + ( tan($t) * tan($t) ));
		$newy = $a / sqrt((($a * $a) / ($b * $b)) + ( (1 / tan($t)) * (1 / tan($t)) ));
		$px = max($px, $a - $newx + $added);
		$py = max($py, $b - $newy + $added);
	}

	/* -- END BORDER-RADIUS -- */



	/* -- HTML-CSS -- */


	/* -- CSS-PAGE -- */

	function SetPagedMediaCSS($name = '', $first, $oddEven)
	{
		if ($oddEven == 'E') {
			if ($this->directionality == 'rtl') {
				$side = 'R';
			} else {
				$side = 'L';
			}
		} else {
			if ($this->directionality == 'rtl') {
				$side = 'L';
			} else {
				$side = 'R';
			}
		}
		$name = strtoupper($name);
		$p = array();
		$p['SIZE'] = 'AUTO';

		// Uses mPDF original margins as default
		$p['MARGIN-RIGHT'] = strval($this->orig_rMargin) . 'mm';
		$p['MARGIN-LEFT'] = strval($this->orig_lMargin) . 'mm';
		$p['MARGIN-TOP'] = strval($this->orig_tMargin) . 'mm';
		$p['MARGIN-BOTTOM'] = strval($this->orig_bMargin) . 'mm';
		$p['MARGIN-HEADER'] = strval($this->orig_hMargin) . 'mm';
		$p['MARGIN-FOOTER'] = strval($this->orig_fMargin) . 'mm';

		// Basic page + selector
		if (isset($this->cssmgr->CSS['@PAGE'])) {
			$zp = $this->cssmgr->CSS['@PAGE'];
		} else {
			$zp = array();
		}
		if (is_array($zp) && !empty($zp)) {
			$p = array_merge($p, $zp);
		}

		if (isset($p['EVEN-HEADER-NAME']) && $oddEven == 'E') {
			$p['HEADER'] = $p['EVEN-HEADER-NAME'];
			unset($p['EVEN-HEADER-NAME']);
		}
		if (isset($p['ODD-HEADER-NAME']) && $oddEven != 'E') {
			$p['HEADER'] = $p['ODD-HEADER-NAME'];
			unset($p['ODD-HEADER-NAME']);
		}
		if (isset($p['EVEN-FOOTER-NAME']) && $oddEven == 'E') {
			$p['FOOTER'] = $p['EVEN-FOOTER-NAME'];
			unset($p['EVEN-FOOTER-NAME']);
		}
		if (isset($p['ODD-FOOTER-NAME']) && $oddEven != 'E') {
			$p['FOOTER'] = $p['ODD-FOOTER-NAME'];
			unset($p['ODD-FOOTER-NAME']);
		}

		// If right/Odd page
		if (isset($this->cssmgr->CSS['@PAGE>>PSEUDO>>RIGHT']) && $side == 'R') {
			$zp = $this->cssmgr->CSS['@PAGE>>PSEUDO>>RIGHT'];
		} else {
			$zp = array();
		}
		if (isset($zp['SIZE'])) {
			unset($zp['SIZE']);
		}
		if (isset($zp['SHEET-SIZE'])) {
			unset($zp['SHEET-SIZE']);
		}
		// Disallow margin-left or -right on :LEFT or :RIGHT
		if (isset($zp['MARGIN-LEFT'])) {
			unset($zp['MARGIN-LEFT']);
		}
		if (isset($zp['MARGIN-RIGHT'])) {
			unset($zp['MARGIN-RIGHT']);
		}
		if (is_array($zp) && !empty($zp)) {
			$p = array_merge($p, $zp);
		}

		// If left/Even page
		if (isset($this->cssmgr->CSS['@PAGE>>PSEUDO>>LEFT']) && $side == 'L') {
			$zp = $this->cssmgr->CSS['@PAGE>>PSEUDO>>LEFT'];
		} else {
			$zp = array();
		}
		if (isset($zp['SIZE'])) {
			unset($zp['SIZE']);
		}
		if (isset($zp['SHEET-SIZE'])) {
			unset($zp['SHEET-SIZE']);
		}
		// Disallow margin-left or -right on :LEFT or :RIGHT
		if (isset($zp['MARGIN-LEFT'])) {
			unset($zp['MARGIN-LEFT']);
		}
		if (isset($zp['MARGIN-RIGHT'])) {
			unset($zp['MARGIN-RIGHT']);
		}
		if (is_array($zp) && !empty($zp)) {
			$p = array_merge($p, $zp);
		}

		// If first page
		if (isset($this->cssmgr->CSS['@PAGE>>PSEUDO>>FIRST']) && $first) {
			$zp = $this->cssmgr->CSS['@PAGE>>PSEUDO>>FIRST'];
		} else {
			$zp = array();
		}
		if (isset($zp['SIZE'])) {
			unset($zp['SIZE']);
		}
		if (isset($zp['SHEET-SIZE'])) {
			unset($zp['SHEET-SIZE']);
		}
		// Disallow margin-left or -right on :FIRST	// mPDF 5.7.3
		if (isset($zp['MARGIN-LEFT'])) {
			unset($zp['MARGIN-LEFT']);
		}
		if (isset($zp['MARGIN-RIGHT'])) {
			unset($zp['MARGIN-RIGHT']);
		}
		if (is_array($zp) && !empty($zp)) {
			$p = array_merge($p, $zp);
		}

		// If named page
		if ($name) {
			if (isset($this->cssmgr->CSS['@PAGE>>NAMED>>' . $name])) {
				$zp = $this->cssmgr->CSS['@PAGE>>NAMED>>' . $name];
			} else {
				$zp = array();
			}
			if (is_array($zp) && !empty($zp)) {
				$p = array_merge($p, $zp);
			}

			if (isset($p['EVEN-HEADER-NAME']) && $oddEven == 'E') {
				$p['HEADER'] = $p['EVEN-HEADER-NAME'];
				unset($p['EVEN-HEADER-NAME']);
			}
			if (isset($p['ODD-HEADER-NAME']) && $oddEven != 'E') {
				$p['HEADER'] = $p['ODD-HEADER-NAME'];
				unset($p['ODD-HEADER-NAME']);
			}
			if (isset($p['EVEN-FOOTER-NAME']) && $oddEven == 'E') {
				$p['FOOTER'] = $p['EVEN-FOOTER-NAME'];
				unset($p['EVEN-FOOTER-NAME']);
			}
			if (isset($p['ODD-FOOTER-NAME']) && $oddEven != 'E') {
				$p['FOOTER'] = $p['ODD-FOOTER-NAME'];
				unset($p['ODD-FOOTER-NAME']);
			}

			// If named right/Odd page
			if (isset($this->cssmgr->CSS['@PAGE>>NAMED>>' . $name . '>>PSEUDO>>RIGHT']) && $side == 'R') {
				$zp = $this->cssmgr->CSS['@PAGE>>NAMED>>' . $name . '>>PSEUDO>>RIGHT'];
			} else {
				$zp = array();
			}
			if (isset($zp['SIZE'])) {
				unset($zp['SIZE']);
			}
			if (isset($zp['SHEET-SIZE'])) {
				unset($zp['SHEET-SIZE']);
			}
			// Disallow margin-left or -right on :LEFT or :RIGHT
			if (isset($zp['MARGIN-LEFT'])) {
				unset($zp['MARGIN-LEFT']);
			}
			if (isset($zp['MARGIN-RIGHT'])) {
				unset($zp['MARGIN-RIGHT']);
			}
			if (is_array($zp) && !empty($zp)) {
				$p = array_merge($p, $zp);
			}

			// If named left/Even page
			if (isset($this->cssmgr->CSS['@PAGE>>NAMED>>' . $name . '>>PSEUDO>>LEFT']) && $side == 'L') {
				$zp = $this->cssmgr->CSS['@PAGE>>NAMED>>' . $name . '>>PSEUDO>>LEFT'];
			} else {
				$zp = array();
			}
			if (isset($zp['SIZE'])) {
				unset($zp['SIZE']);
			}
			if (isset($zp['SHEET-SIZE'])) {
				unset($zp['SHEET-SIZE']);
			}
			// Disallow margin-left or -right on :LEFT or :RIGHT
			if (isset($zp['MARGIN-LEFT'])) {
				unset($zp['MARGIN-LEFT']);
			}
			if (isset($zp['MARGIN-RIGHT'])) {
				unset($zp['MARGIN-RIGHT']);
			}
			if (is_array($zp) && !empty($zp)) {
				$p = array_merge($p, $zp);
			}

			// If named first page
			if (isset($this->cssmgr->CSS['@PAGE>>NAMED>>' . $name . '>>PSEUDO>>FIRST']) && $first) {
				$zp = $this->cssmgr->CSS['@PAGE>>NAMED>>' . $name . '>>PSEUDO>>FIRST'];
			} else {
				$zp = array();
			}
			if (isset($zp['SIZE'])) {
				unset($zp['SIZE']);
			}
			if (isset($zp['SHEET-SIZE'])) {
				unset($zp['SHEET-SIZE']);
			}
			// Disallow margin-left or -right on :FIRST	// mPDF 5.7.3
			if (isset($zp['MARGIN-LEFT'])) {
				unset($zp['MARGIN-LEFT']);
			}
			if (isset($zp['MARGIN-RIGHT'])) {
				unset($zp['MARGIN-RIGHT']);
			}
			if (is_array($zp) && !empty($zp)) {
				$p = array_merge($p, $zp);
			}
		}

		$orientation = $mgl = $mgr = $mgt = $mgb = $mgh = $mgf = '';
		$header = $footer = '';
		$resetpagenum = $pagenumstyle = $suppress = '';
		$marks = '';
		$bg = array();

		$newformat = '';


		if (isset($p['SHEET-SIZE']) && is_array($p['SHEET-SIZE'])) {
			$newformat = $p['SHEET-SIZE'];
			if ($newformat[0] > $newformat[1]) { // landscape
				$newformat = array_reverse($newformat);
				$p['ORIENTATION'] = 'L';
			} else {
				$p['ORIENTATION'] = 'P';
			}
			$this->_setPageSize($newformat, $p['ORIENTATION']);
		}

		if (isset($p['SIZE']) && is_array($p['SIZE']) && !$newformat) {
			if ($p['SIZE']['W'] > $p['SIZE']['H']) {
				$p['ORIENTATION'] = 'L';
			} else {
				$p['ORIENTATION'] = 'P';
			}
		}
		if (is_array($p['SIZE'])) {
			if ($p['SIZE']['W'] > $this->fw) {
				$p['SIZE']['W'] = $this->fw;
			} // mPD 4.2 use fw not fPt
			if ($p['SIZE']['H'] > $this->fh) {
				$p['SIZE']['H'] = $this->fh;
			}
			if (($p['ORIENTATION'] == $this->DefOrientation && !$newformat) || ($newformat && $p['ORIENTATION'] == 'P')) {
				$outer_width_LR = ($this->fw - $p['SIZE']['W']) / 2;
				$outer_width_TB = ($this->fh - $p['SIZE']['H']) / 2;
			} else {
				$outer_width_LR = ($this->fh - $p['SIZE']['W']) / 2;
				$outer_width_TB = ($this->fw - $p['SIZE']['H']) / 2;
			}
			$pgw = $p['SIZE']['W'];
			$pgh = $p['SIZE']['H'];
		} else { // AUTO LANDSCAPE PORTRAIT
			$outer_width_LR = 0;
			$outer_width_TB = 0;
			if (!$newformat) {
				if (strtoupper($p['SIZE']) == 'AUTO') {
					$p['ORIENTATION'] = $this->DefOrientation;
				} elseif (strtoupper($p['SIZE']) == 'LANDSCAPE') {
					$p['ORIENTATION'] = 'L';
				} else {
					$p['ORIENTATION'] = 'P';
				}
			}
			if (($p['ORIENTATION'] == $this->DefOrientation && !$newformat) || ($newformat && $p['ORIENTATION'] == 'P')) {
				$pgw = $this->fw;
				$pgh = $this->fh;
			} else {
				$pgw = $this->fh;
				$pgh = $this->fw;
			}
		}

		if (isset($p['HEADER']) && $p['HEADER']) {
			$header = $p['HEADER'];
		}
		if (isset($p['FOOTER']) && $p['FOOTER']) {
			$footer = $p['FOOTER'];
		}
		if (isset($p['RESETPAGENUM']) && $p['RESETPAGENUM']) {
			$resetpagenum = $p['RESETPAGENUM'];
		}
		if (isset($p['PAGENUMSTYLE']) && $p['PAGENUMSTYLE']) {
			$pagenumstyle = $p['PAGENUMSTYLE'];
		}
		if (isset($p['SUPPRESS']) && $p['SUPPRESS']) {
			$suppress = $p['SUPPRESS'];
		}

		if (isset($p['MARKS'])) {
			if (preg_match('/cross/i', $p['MARKS']) && preg_match('/crop/i', $p['MARKS'])) {
				$marks = 'CROPCROSS';
			} elseif (strtoupper($p['MARKS']) == 'CROP') {
				$marks = 'CROP';
			} elseif (strtoupper($p['MARKS']) == 'CROSS') {
				$marks = 'CROSS';
			}
		}

		if (isset($p['BACKGROUND-COLOR']) && $p['BACKGROUND-COLOR']) {
			$bg['BACKGROUND-COLOR'] = $p['BACKGROUND-COLOR'];
		}
		/* -- BACKGROUNDS -- */
		if (isset($p['BACKGROUND-GRADIENT']) && $p['BACKGROUND-GRADIENT']) {
			$bg['BACKGROUND-GRADIENT'] = $p['BACKGROUND-GRADIENT'];
		}
		if (isset($p['BACKGROUND-IMAGE']) && $p['BACKGROUND-IMAGE']) {
			$bg['BACKGROUND-IMAGE'] = $p['BACKGROUND-IMAGE'];
		}
		if (isset($p['BACKGROUND-REPEAT']) && $p['BACKGROUND-REPEAT']) {
			$bg['BACKGROUND-REPEAT'] = $p['BACKGROUND-REPEAT'];
		}
		if (isset($p['BACKGROUND-POSITION']) && $p['BACKGROUND-POSITION']) {
			$bg['BACKGROUND-POSITION'] = $p['BACKGROUND-POSITION'];
		}
		if (isset($p['BACKGROUND-IMAGE-RESIZE']) && $p['BACKGROUND-IMAGE-RESIZE']) {
			$bg['BACKGROUND-IMAGE-RESIZE'] = $p['BACKGROUND-IMAGE-RESIZE'];
		}
		if (isset($p['BACKGROUND-IMAGE-OPACITY'])) {
			$bg['BACKGROUND-IMAGE-OPACITY'] = $p['BACKGROUND-IMAGE-OPACITY'];
		}
		/* -- END BACKGROUNDS -- */

		if (isset($p['MARGIN-LEFT'])) {
			$mgl = $this->ConvertSize($p['MARGIN-LEFT'], $pgw) + $outer_width_LR;
		}
		if (isset($p['MARGIN-RIGHT'])) {
			$mgr = $this->ConvertSize($p['MARGIN-RIGHT'], $pgw) + $outer_width_LR;
		}
		if (isset($p['MARGIN-BOTTOM'])) {
			$mgb = $this->ConvertSize($p['MARGIN-BOTTOM'], $pgh) + $outer_width_TB;
		}
		if (isset($p['MARGIN-TOP'])) {
			$mgt = $this->ConvertSize($p['MARGIN-TOP'], $pgh) + $outer_width_TB;
		}
		if (isset($p['MARGIN-HEADER'])) {
			$mgh = $this->ConvertSize($p['MARGIN-HEADER'], $pgh) + $outer_width_TB;
		}
		if (isset($p['MARGIN-FOOTER'])) {
			$mgf = $this->ConvertSize($p['MARGIN-FOOTER'], $pgh) + $outer_width_TB;
		}

		if (isset($p['ORIENTATION']) && $p['ORIENTATION']) {
			$orientation = $p['ORIENTATION'];
		}
		$this->page_box['outer_width_LR'] = $outer_width_LR; // Used in MARKS:crop etc.
		$this->page_box['outer_width_TB'] = $outer_width_TB;

		return array($orientation, $mgl, $mgr, $mgt, $mgb, $mgh, $mgf, $header, $footer, $bg, $resetpagenum, $pagenumstyle, $suppress, $marks, $newformat);
	}

	/* -- END CSS-PAGE -- */



	/* -- CSS-FLOAT -- */

	// Added mPDF 3.0 Float DIV - CLEAR
	function ClearFloats($clear, $blklvl = 0)
	{
		list($l_exists, $r_exists, $l_max, $r_max, $l_width, $r_width) = $this->GetFloatDivInfo($blklvl, true);
		$end = $currpos = ($this->page * 1000 + $this->y);
		if ($clear == 'BOTH' && ($l_exists || $r_exists)) {
			$this->pageoutput[$this->page] = array();
			$end = max($l_max, $r_max, $currpos);
		} elseif ($clear == 'RIGHT' && $r_exists) {
			$this->pageoutput[$this->page] = array();
			$end = max($r_max, $currpos);
		} elseif ($clear == 'LEFT' && $l_exists) {
			$this->pageoutput[$this->page] = array();
			$end = max($l_max, $currpos);
		} else {
			return;
		}
		$old_page = $this->page;
		$new_page = intval($end / 1000);
		if ($old_page != $new_page) {
			$s = $this->PrintPageBackgrounds();
			// Writes after the marker so not overwritten later by page background etc.
			$this->pages[$this->page] = preg_replace('/(___BACKGROUND___PATTERNS' . $this->uniqstr . ')/', '\\1' . "\n" . $s . "\n", $this->pages[$this->page]);
			$this->pageBackgrounds = array();
			$this->page = $new_page;
		}
		$this->ResetMargins();
		$this->pageoutput[$this->page] = array();
		$this->y = (($end * 1000) % 1000000) / 1000; // mod changes operands to integers before processing
	}

	// Added mPDF 3.0 Float DIV
	function GetFloatDivInfo($blklvl = 0, $clear = false)
	{
		// If blklvl specified, only returns floats at that level - for ClearFloats
		$l_exists = false;
		$r_exists = false;
		$l_max = 0;
		$r_max = 0;
		$l_width = 0;
		$r_width = 0;
		if (count($this->floatDivs)) {
			$currpos = ($this->page * 1000 + $this->y);
			foreach ($this->floatDivs AS $f) {
				if (($clear && $f['blockContext'] == $this->blk[$blklvl]['blockContext']) || (!$clear && $currpos >= $f['startpos'] && $currpos < ($f['endpos'] - 0.001) && $f['blklvl'] > $blklvl && $f['blockContext'] == $this->blk[$blklvl]['blockContext'])) {
					if ($f['side'] == 'L') {
						$l_exists = true;
						$l_max = max($l_max, $f['endpos']);
						$l_width = max($l_width, $f['w']);
					}
					if ($f['side'] == 'R') {
						$r_exists = true;
						$r_max = max($r_max, $f['endpos']);
						$r_width = max($r_width, $f['w']);
					}
				}
			}
		}
		return array($l_exists, $r_exists, $l_max, $r_max, $l_width, $r_width);
	}

	/* -- END CSS-FLOAT -- */

	// LIST MARKERS	// mPDF 6  Lists
	function _setListMarker($listitemtype, $listitemimage, $listitemposition)
	{
		// if position:inside (and NOT table) - output now as a textbuffer; (so if next is block, will move to new line)
		// elseif position:outside (and NOT table) - output in front of first textbuffer output by setting listitem (cf. _saveTextBuffer)
		$e = '';
		$this->listitem = '';
		$spacer = ' ';
		// IMAGE
		if ($listitemimage && $listitemimage != 'none') {
			$listitemimage = trim(preg_replace('/url\(["\']*(.*?)["\']*\)/', '\\1', $listitemimage));

			// ? Restrict maximum height/width of list marker??
			$maxWidth = 100;
			$maxHeight = 100;

			$objattr = array();
			$objattr['margin_top'] = 0;
			$objattr['margin_bottom'] = 0;
			$objattr['margin_left'] = 0;
			$objattr['margin_right'] = 0;
			$objattr['padding_top'] = 0;
			$objattr['padding_bottom'] = 0;
			$objattr['padding_left'] = 0;
			$objattr['padding_right'] = 0;
			$objattr['width'] = 0;
			$objattr['height'] = 0;
			$objattr['border_top']['w'] = 0;
			$objattr['border_bottom']['w'] = 0;
			$objattr['border_left']['w'] = 0;
			$objattr['border_right']['w'] = 0;
			$objattr['visibility'] = 'visible';
			$srcpath = $listitemimage;
			$orig_srcpath = $listitemimage;

			$objattr['vertical-align'] = 'BS'; // vertical alignment of marker (baseline)
			$w = 0;
			$h = 0;

			// Image file
			$info = $this->_getImage($srcpath, true, true, $orig_srcpath);
			if (!$info)
				return;
			if ($info['w'] == 0 && $info['h'] == 0) {
				$info['h'] = $this->ConvertSize('1em', $this->blk[$this->blklvl]['inner_width'], $this->FontSize, false);
			}
			$objattr['file'] = $srcpath;
			//Default width and height calculation if needed
			if ($w == 0 and $h == 0) {
				/* -- IMAGES-WMF -- */
				if ($info['type'] == 'wmf') {
					// WMF units are twips (1/20pt)
					// divide by 20 to get points
					// divide by k to get user units
					$w = abs($info['w']) / (20 * _MPDFK);
					$h = abs($info['h']) / (20 * _MPDFK);
				} else
				/* -- END IMAGES-WMF -- */
				if ($info['type'] == 'svg') {
					// SVG units are pixels
					$w = abs($info['w']) / _MPDFK;
					$h = abs($info['h']) / _MPDFK;
				} else {
					//Put image at default image dpi
					$w = ($info['w'] / _MPDFK) * (72 / $this->img_dpi);
					$h = ($info['h'] / _MPDFK) * (72 / $this->img_dpi);
				}
			}
			// IF WIDTH OR HEIGHT SPECIFIED
			if ($w == 0)
				$w = abs($h * $info['w'] / $info['h']);
			if ($h == 0)
				$h = abs($w * $info['h'] / $info['w']);

			if ($w > $maxWidth) {
				$w = $maxWidth;
				$h = abs($w * $info['h'] / $info['w']);
			}

			if ($h > $maxHeight) {
				$h = $maxHeight;
				$w = abs($h * $info['w'] / $info['h']);
			}
			$objattr['type'] = 'image';
			$objattr['itype'] = $info['type'];

			$objattr['orig_h'] = $info['h'];
			$objattr['orig_w'] = $info['w'];
			/* -- IMAGES-WMF -- */
			if ($info['type'] == 'wmf') {
				$objattr['wmf_x'] = $info['x'];
				$objattr['wmf_y'] = $info['y'];
			} else
			/* -- END IMAGES-WMF -- */
			if ($info['type'] == 'svg') {
				$objattr['wmf_x'] = $info['x'];
				$objattr['wmf_y'] = $info['y'];
			}
			$objattr['height'] = $h;
			$objattr['width'] = $w;
			$objattr['image_height'] = $h;
			$objattr['image_width'] = $w;

			$objattr['dir'] = (isset($this->blk[$this->blklvl]['direction']) ? $this->blk[$this->blklvl]['direction'] : 'ltr');
			$objattr['listmarker'] = true;

			$objattr['listmarkerposition'] = $listitemposition;

			$e = "\xbb\xa4\xactype=image,objattr=" . serialize($objattr) . "\xbb\xa4\xac";
			$this->_saveTextBuffer($e);

			if ($listitemposition == 'inside') {
				$e = $spacer;
				$this->_saveTextBuffer($e);
			}
		}
		// SYMBOL (needs new font)
		elseif ($listitemtype == 'disc' || $listitemtype == 'circle' || $listitemtype == 'square') {
			$objattr = array();
			$objattr['type'] = 'listmarker';
			$objattr['listmarkerposition'] = $listitemposition;
			$objattr['width'] = 0;
			$size = $this->ConvertSize($this->list_symbol_size, $this->FontSize);
			$objattr['size'] = $size;
			$objattr['offset'] = $this->ConvertSize($this->list_marker_offset, $this->FontSize);

			if ($listitemposition == 'inside') {
				$objattr['width'] = $size + $objattr['offset'];
			}

			$objattr['height'] = $this->FontSize;
			$objattr['vertical-align'] = 'T';
			$objattr['text'] = '';
			$objattr['dir'] = (isset($this->blk[$this->blklvl]['direction']) ? $this->blk[$this->blklvl]['direction'] : 'ltr');
			$objattr['bullet'] = $listitemtype;
			$objattr['colorarray'] = $this->colorarray;
			$objattr['fontfamily'] = $this->FontFamily;
			$objattr['fontsize'] = $this->FontSize;
			$objattr['fontsizept'] = $this->FontSizePt;
			$objattr['fontstyle'] = $this->FontStyle;

			$e = "\xbb\xa4\xactype=listmarker,objattr=" . serialize($objattr) . "\xbb\xa4\xac";
			$this->listitem = $this->_saveTextBuffer($e, '', '', true); // true returns array
			//	if ($listitemposition == 'inside') {
			//		$e = $spacer;
			//		$this->_saveTextBuffer($e);
			//	}
		}
		// SYMBOL 2 (needs new font)
		elseif (preg_match('/U\+([a-fA-F0-9]+)/i', $listitemtype, $m)) {
			if ($this->_charDefined($this->CurrentFont['cw'], hexdec($m[1]))) {
				$list_item_marker = codeHex2utf($m[1]);
			} else {
				$list_item_marker = '-';
			}
			if (preg_match('/rgb\(.*?\)/', $listitemtype, $m)) {
				$list_item_color = $this->ConvertColor($m[0]);
			} else {
				$list_item_color = '';
			}

			// SAVE then SET COLR
			$save_colorarray = $this->colorarray;
			if ($list_item_color) {
				$this->colorarray = $list_item_color;
			}

			if ($listitemposition == 'inside') {
				$e = $list_item_marker . $spacer;
				$this->_saveTextBuffer($e);
			} else {
				$objattr = array();
				$objattr['type'] = 'listmarker';
				$objattr['width'] = 0;
				$objattr['height'] = $this->FontSize;
				$objattr['vertical-align'] = 'T';
				$objattr['text'] = $list_item_marker;
				$objattr['dir'] = (isset($this->blk[$this->blklvl]['direction']) ? $this->blk[$this->blklvl]['direction'] : 'ltr');
				$objattr['colorarray'] = $this->colorarray;
				$objattr['fontfamily'] = $this->FontFamily;
				$objattr['fontsize'] = $this->FontSize;
				$objattr['fontsizept'] = $this->FontSizePt;
				$objattr['fontstyle'] = $this->FontStyle;
				$e = "\xbb\xa4\xactype=listmarker,objattr=" . serialize($objattr) . "\xbb\xa4\xac";
				$this->listitem = $this->_saveTextBuffer($e, '', '', true); // true returns array
			}
			// RESET COLOR
			$this->colorarray = $save_colorarray;
		}
		// TEXT
		else {
			$counter = $this->listcounter[$this->listlvl];
			if ($listitemtype == 'none') {
				return;
			}
			$num = $this->_getStyledNumber($counter, $listitemtype, true);

			if ($listitemposition == 'inside') {
				$e = $num . $this->list_number_suffix . $spacer;
				$this->_saveTextBuffer($e);
			} else {
				if (isset($this->blk[$this->blklvl]['direction']) && $this->blk[$this->blklvl]['direction'] == 'rtl') {
					// REPLACE MIRRORED RTL $this->list_number_suffix  e.g. ) -> (  (NB could use UCDN::$mirror_pairs)
					$m = strtr($this->list_number_suffix, ")]}", "([{") . $num;
				} else {
					$m = $num . $this->list_number_suffix;
				}

				$objattr = array();
				$objattr['type'] = 'listmarker';
				$objattr['width'] = 0;
				$objattr['height'] = $this->FontSize;
				$objattr['vertical-align'] = 'T';
				$objattr['text'] = $m;
				$objattr['dir'] = (isset($this->blk[$this->blklvl]['direction']) ? $this->blk[$this->blklvl]['direction'] : 'ltr');
				$objattr['colorarray'] = $this->colorarray;
				$objattr['fontfamily'] = $this->FontFamily;
				$objattr['fontsize'] = $this->FontSize;
				$objattr['fontsizept'] = $this->FontSizePt;
				$objattr['fontstyle'] = $this->FontStyle;
				$e = "\xbb\xa4\xactype=listmarker,objattr=" . serialize($objattr) . "\xbb\xa4\xac";

				$this->listitem = $this->_saveTextBuffer($e, '', '', true); // true returns array
			}
		}
	}

	// mPDF Lists
	function _getListMarkerWidth(&$currblk, &$a, &$i)
	{
		$blt_width = 0;

		$markeroffset = $this->ConvertSize($this->list_marker_offset, $this->FontSize);

		// Get Maximum number in the list
		$maxnum = $this->listcounter[$this->listlvl];
		if ($currblk['list_style_type'] != 'disc' && $currblk['list_style_type'] != 'circle' && $currblk['list_style_type'] != 'square') {
			$lvl = 1;
			for ($j = $i + 2; $j < count($a); $j+=2) {
				$e = $a[$j];
				if (!$e) {
					continue;
				}
				if ($e[0] == '/') { // end tag
					$e = strtoupper(substr($e, 1));
					if ($e == 'OL' || $e == 'UL') {
						if ($lvl == 1) {
							break;
						}
						$lvl--;
					}
				} else { // opening tag
					if (strpos($e, ' ')) {
						$e = substr($e, 0, strpos($e, ' '));
					}
					$e = strtoupper($e);
					if ($e == 'LI') {
						if ($lvl == 1) {
							$maxnum++;
						}
					} elseif ($e == 'OL' || $e == 'UL') {
						$lvl++;
					}
				}
			}
		}

		switch ($currblk['list_style_type']) {
			case 'decimal':
			case '1':
				$blt_width = $this->GetStringWidth(str_repeat('5', strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'none':
				$blt_width = 0;
				break;
			case 'upper-alpha':
			case 'upper-latin':
			case 'A':
				$maxnumA = $this->dec2alpha($maxnum, true);
				if ($maxnum < 13) {
					$blt_width = $this->GetStringWidth('D' . $this->list_number_suffix);
				} else {
					$blt_width = $this->GetStringWidth(str_repeat('W', strlen($maxnumA)) . $this->list_number_suffix);
				}
				break;
			case 'lower-alpha':
			case 'lower-latin':
			case 'a':
				$maxnuma = $this->dec2alpha($maxnum, false);
				if ($maxnum < 13) {
					$blt_width = $this->GetStringWidth('b' . $this->list_number_suffix);
				} else {
					$blt_width = $this->GetStringWidth(str_repeat('m', strlen($maxnuma)) . $this->list_number_suffix);
				}
				break;
			case 'upper-roman':
			case 'I':
				if ($maxnum > 87) {
					$bbit = 87;
				} elseif ($maxnum > 86) {
					$bbit = 86;
				} elseif ($maxnum > 37) {
					$bbit = 38;
				} elseif ($maxnum > 36) {
					$bbit = 37;
				} elseif ($maxnum > 27) {
					$bbit = 28;
				} elseif ($maxnum > 26) {
					$bbit = 27;
				} elseif ($maxnum > 17) {
					$bbit = 18;
				} elseif ($maxnum > 16) {
					$bbit = 17;
				} elseif ($maxnum > 7) {
					$bbit = 8;
				} elseif ($maxnum > 6) {
					$bbit = 7;
				} elseif ($maxnum > 3) {
					$bbit = 4;
				} else {
					$bbit = $maxnum;
				}
				$maxlnum = $this->dec2roman($bbit, true);
				$blt_width = $this->GetStringWidth($maxlnum . $this->list_number_suffix);
				break;
			case 'lower-roman':
			case 'i':
				if ($maxnum > 87) {
					$bbit = 87;
				} elseif ($maxnum > 86) {
					$bbit = 86;
				} elseif ($maxnum > 37) {
					$bbit = 38;
				} elseif ($maxnum > 36) {
					$bbit = 37;
				} elseif ($maxnum > 27) {
					$bbit = 28;
				} elseif ($maxnum > 26) {
					$bbit = 27;
				} elseif ($maxnum > 17) {
					$bbit = 18;
				} elseif ($maxnum > 16) {
					$bbit = 17;
				} elseif ($maxnum > 7) {
					$bbit = 8;
				} elseif ($maxnum > 6) {
					$bbit = 7;
				} elseif ($maxnum > 3) {
					$bbit = 4;
				} else {
					$bbit = $maxnum;
				}
				$maxlnum = $this->dec2roman($bbit, false);
				$blt_width = $this->GetStringWidth($maxlnum . $this->list_number_suffix);
				break;

			case 'disc':
			case 'circle':
			case 'square':
				$size = $this->ConvertSize($this->list_symbol_size, $this->FontSize);
				$offset = $this->ConvertSize($this->list_marker_offset, $this->FontSize);
				$blt_width = $size + $offset;
				break;

			case 'arabic-indic':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(3, 0x0660), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'persian':
			case 'urdu':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(3, 0x06F0), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'bengali':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(3, 0x09E6), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'devanagari':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(3, 0x0966), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'gujarati':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(3, 0x0AE6), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'gurmukhi':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(3, 0x0A66), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'kannada':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(3, 0x0CE6), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'malayalam':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(6, 0x0D66), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'oriya':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(3, 0x0B66), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'telugu':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(3, 0x0C66), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'tamil':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(9, 0x0BE6), strlen($maxnum)) . $this->list_number_suffix);
				break;
			case 'thai':
				$blt_width = $this->GetStringWidth(str_repeat($this->dec2other(5, 0x0E50), strlen($maxnum)) . $this->list_number_suffix);
				break;
			default:
				$blt_width = $this->GetStringWidth(str_repeat('5', strlen($maxnum)) . $this->list_number_suffix);
				break;
		}

		return ($blt_width + $markeroffset);
	}

	/* -- TABLES -- */

	// This function determines the shrink factor when resizing tables
	// val is the table_height / page_height_available
	// returns a scaling factor used as $shrin_k to resize the table
	// Overcompensating will be quicker but may unnecessarily shrink table too much
	// Undercompensating means it will reiterate more times (taking more processing time)
	function tbsqrt($val, $iteration = 3)
	{
		$k = 4; // Alters number of iterations until it returns $val itself - Must be > 2
		// Probably best guess and most accurate
		if ($iteration == 1)
			return sqrt($val);
		// Faster than using sqrt (because it won't undercompensate), and gives reasonable results
		//return 1+(($val-1)/2);
		$x = 2 - (($iteration - 2) / ($k - 2));
		if ($x == 0) {
			$ret = $val + 0.00001;
		} elseif ($x < 0) {
			$ret = 1 + ( pow(2, ($iteration - 2 - $k)) / 1000 );
		} else {
			$ret = 1 + (($val - 1) / $x);
		}
		return $ret;
	}

	/* -- END TABLES -- */

	function _saveTextBuffer($t, $link = '', $intlink = '', $return = false)
	{ // mPDF 6  Lists
		$arr = array();
		$arr[0] = $t;
		if (isset($link) && $link)
			$arr[1] = $link;
		$arr[2] = $this->currentfontstyle;
		if (isset($this->colorarray) && $this->colorarray)
			$arr[3] = $this->colorarray;
		$arr[4] = $this->currentfontfamily;
		$arr[5] = $this->currentLang; // mPDF 6
		if (isset($intlink) && $intlink)
			$arr[7] = $intlink;
		// mPDF 6
		// If Kerning set for OTL, and useOTL has positive value, but has not set for this particular script,
		// set for kerning via kern table
		// e.g. Latin script when useOTL set as 0x80
		if (isset($this->OTLtags['Plus']) && strpos($this->OTLtags['Plus'], 'kern') !== false && empty($this->OTLdata['GPOSinfo'])) {
			$this->textvar = ($this->textvar | FC_KERNING);
		}
		$arr[8] = $this->textvar; // mPDF 5.7.1
		if (isset($this->textparam) && $this->textparam)
			$arr[9] = $this->textparam;
		if (isset($this->spanbgcolorarray) && $this->spanbgcolorarray)
			$arr[10] = $this->spanbgcolorarray;
		$arr[11] = $this->currentfontsize;
		if (isset($this->ReqFontStyle) && $this->ReqFontStyle)
			$arr[12] = $this->ReqFontStyle;
		if (isset($this->lSpacingCSS) && $this->lSpacingCSS)
			$arr[14] = $this->lSpacingCSS;
		if (isset($this->wSpacingCSS) && $this->wSpacingCSS)
			$arr[15] = $this->wSpacingCSS;
		if (isset($this->spanborddet) && $this->spanborddet)
			$arr[16] = $this->spanborddet;
		if (isset($this->textshadow) && $this->textshadow)
			$arr[17] = $this->textshadow;
		if (isset($this->OTLdata) && $this->OTLdata) {
			$arr[18] = $this->OTLdata;
			$this->OTLdata = array();
		} // mPDF 5.7.1
		else {
			$arr[18] = NULL;
		}
		// mPDF 6  Lists
		if ($return) {
			return ($arr);
		}
		if ($this->listitem) {
			$this->textbuffer[] = $this->listitem;
			$this->listitem = array();
		}
		$this->textbuffer[] = $arr;
	}

	function _saveCellTextBuffer($t, $link = '', $intlink = '')
	{
		$arr = array();
		$arr[0] = $t;
		if (isset($link) && $link)
			$arr[1] = $link;
		$arr[2] = $this->currentfontstyle;
		if (isset($this->colorarray) && $this->colorarray)
			$arr[3] = $this->colorarray;
		$arr[4] = $this->currentfontfamily;
		if (isset($intlink) && $intlink)
			$arr[7] = $intlink;
		// mPDF 6
		// If Kerning set for OTL, and useOTL has positive value, but has not set for this particular script,
		// set for kerning via kern table
		// e.g. Latin script when useOTL set as 0x80
		if (isset($this->OTLtags['Plus']) && strpos($this->OTLtags['Plus'], 'kern') !== false && empty($this->OTLdata['GPOSinfo'])) {
			$this->textvar = ($this->textvar | FC_KERNING);
		}
		$arr[8] = $this->textvar; // mPDF 5.7.1
		if (isset($this->textparam) && $this->textparam)
			$arr[9] = $this->textparam;
		if (isset($this->spanbgcolorarray) && $this->spanbgcolorarray)
			$arr[10] = $this->spanbgcolorarray;
		$arr[11] = $this->currentfontsize;
		if (isset($this->ReqFontStyle) && $this->ReqFontStyle)
			$arr[12] = $this->ReqFontStyle;
		if (isset($this->lSpacingCSS) && $this->lSpacingCSS)
			$arr[14] = $this->lSpacingCSS;
		if (isset($this->wSpacingCSS) && $this->wSpacingCSS)
			$arr[15] = $this->wSpacingCSS;
		if (isset($this->spanborddet) && $this->spanborddet)
			$arr[16] = $this->spanborddet;
		if (isset($this->textshadow) && $this->textshadow)
			$arr[17] = $this->textshadow;
		if (isset($this->OTLdata) && $this->OTLdata) {
			$arr[18] = $this->OTLdata;
			$this->OTLdata = array();
		} // mPDF 5.7.1
		else {
			$arr[18] = NULL;
		}
		$this->cell[$this->row][$this->col]['textbuffer'][] = $arr;
	}

	function printbuffer($arrayaux, $blockstate = 0, $is_table = false, $table_draft = false, $cell_dir = '')
	{
		// $blockstate = 0;	// NO margins/padding
		// $blockstate = 1;	// Top margins/padding only
		// $blockstate = 2;	// Bottom margins/padding only
		// $blockstate = 3;	// Top & bottom margins/padding
		$this->spanbgcolorarray = '';
		$this->spanbgcolor = false;
		$this->spanborder = false;
		$this->spanborddet = array();
		$paint_ht_corr = 0;
		/* -- CSS-FLOAT -- */
		if (count($this->floatDivs)) {
			list($l_exists, $r_exists, $l_max, $r_max, $l_width, $r_width) = $this->GetFloatDivInfo($this->blklvl);
			if (($this->blk[$this->blklvl]['inner_width'] - $l_width - $r_width) < (2 * $this->GetCharWidth('W', false))) {
				// Too narrow to fit - try to move down past L or R float
				if ($l_max < $r_max && ($this->blk[$this->blklvl]['inner_width'] - $r_width) > (2 * $this->GetCharWidth('W', false))) {
					$this->ClearFloats('LEFT', $this->blklvl);
				} elseif ($r_max < $l_max && ($this->blk[$this->blklvl]['inner_width'] - $l_width) > (2 * $this->GetCharWidth('W', false))) {
					$this->ClearFloats('RIGHT', $this->blklvl);
				} else {
					$this->ClearFloats('BOTH', $this->blklvl);
				}
			}
		}
		/* -- END CSS-FLOAT -- */
		$bak_y = $this->y;
		$bak_x = $this->x;
		$align = '';
		if (!$is_table) {
			if (isset($this->blk[$this->blklvl]['align']) && $this->blk[$this->blklvl]['align']) {
				$align = $this->blk[$this->blklvl]['align'];
			}
			// Block-align is set by e.g. <.. align="center"> Takes priority for this block but not inherited
			if (isset($this->blk[$this->blklvl]['block-align']) && $this->blk[$this->blklvl]['block-align']) {
				$align = $this->blk[$this->blklvl]['block-align'];
			}
			if (isset($this->blk[$this->blklvl]['direction']))
				$blockdir = $this->blk[$this->blklvl]['direction'];
			else
				$blockdir = "";
			$this->divwidth = $this->blk[$this->blklvl]['width'];
		}
		else {
			$align = $this->cellTextAlign;
			$blockdir = $cell_dir;
		}
		$oldpage = $this->page;

		// ADDED for Out of Block now done as Flowing Block
		if ($this->divwidth == 0) {
			$this->divwidth = $this->pgwidth;
		}

		if (!$is_table) {
			$this->SetLineHeight($this->FontSizePt, $this->blk[$this->blklvl]['line_height']);
		}
		$this->divheight = $this->lineheight;
		$old_height = $this->divheight;

		// As a failsafe - if font has been set but not output to page
		if (!$table_draft)
			$this->SetFont($this->default_font, '', $this->default_font_size, true, true); // force output to page

		$this->newFlowingBlock($this->divwidth, $this->divheight, $align, $is_table, $blockstate, true, $blockdir, $table_draft);

		$array_size = count($arrayaux);

		// Added - Otherwise <div><div><p> did not output top margins/padding for 1st/2nd div
		if ($array_size == 0) {
			$this->finishFlowingBlock(true);
		} // true = END of flowing block
		// mPDF 6
		// ALL the chunks of textbuffer need to have at least basic OTLdata set
		// First make sure each element/chunk has the OTLdata for Bidi set.
		for ($i = 0; $i < $array_size; $i++) {
			if (empty($arrayaux[$i][18])) {
				if (substr($arrayaux[$i][0], 0, 3) == "\xbb\xa4\xac") { // object identifier has been identified!
					$unicode = array(0xFFFC); // Object replacement character
				} else {
					$unicode = $this->UTF8StringToArray($arrayaux[$i][0], false);
				}
				$is_strong = false;
				$this->getBasicOTLdata($arrayaux[$i][18], $unicode, $is_strong);
			}
			// Gets messed up if try and use core fonts inside a paragraph of text which needs to be BiDi re-ordered or OTLdata set
			if (($blockdir == 'rtl' || $this->biDirectional) && isset($arrayaux[$i][4]) && in_array($arrayaux[$i][4], array('ccourier', 'ctimes', 'chelvetica', 'csymbol', 'czapfdingbats'))) {
				throw new MpdfException("You cannot use core fonts in a document which contains RTL text.");
			}
		}
		// mPDF 6
		// Process bidirectional text ready for bidi-re-ordering (which is done after line-breaks are established in WriteFlowingBlock etc.)
		if (($blockdir == 'rtl' || $this->biDirectional) && !$table_draft) {
			if (!class_exists('otl', false)) {
				include(_MPDF_PATH . 'classes/otl.php');
			}
			if (empty($this->otl)) {
				$this->otl = new otl($this);
			}
			$this->otl->_bidiPrepare($arrayaux, $blockdir);
			$array_size = count($arrayaux);
		}


		// Remove empty items // mPDF 6
		for ($i = $array_size - 1; $i > 0; $i--) {
			if (empty($arrayaux[$i][0]) && (isset($arrayaux[$i][16]) && $arrayaux[$i][16] !== '0') && empty($arrayaux[$i][7])) {
				unset($arrayaux[$i]);
			}
		}

		// Correct adjoining borders for inline elements
		if (isset($arrayaux[0][16])) {
			$lastspanborder = $arrayaux[0][16];
		} else {
			$lastspanborder = false;
		}
		for ($i = 1; $i < $array_size; $i++) {
			if (isset($arrayaux[$i][16]) && $arrayaux[$i][16] == $lastspanborder &&
				((!isset($arrayaux[$i][9]['bord-decoration']) && !isset($arrayaux[$i - 1][9]['bord-decoration'])) ||
				(isset($arrayaux[$i][9]['bord-decoration']) && isset($arrayaux[$i - 1][9]['bord-decoration']) && $arrayaux[$i][9]['bord-decoration'] == $arrayaux[$i - 1][9]['bord-decoration'])
				)
			) {
				if (isset($arrayaux[$i][16]['R'])) {
					$lastspanborder = $arrayaux[$i][16];
				} else {
					$lastspanborder = false;
				}
				$arrayaux[$i][16]['L']['s'] = 0;
				$arrayaux[$i][16]['L']['w'] = 0;
				$arrayaux[$i - 1][16]['R']['s'] = 0;
				$arrayaux[$i - 1][16]['R']['w'] = 0;
			} else {
				if (isset($arrayaux[$i][16]['R'])) {
					$lastspanborder = $arrayaux[$i][16];
				} else {
					$lastspanborder = false;
				}
			}
		}

		for ($i = 0; $i < $array_size; $i++) {
			// COLS
			$oldcolumn = $this->CurrCol;
			$vetor = isset($arrayaux[$i]) ? $arrayaux[$i] : NULL;
			if ($i == 0 && $vetor[0] != "\n" && ! $this->ispre) {
				$vetor[0] = ltrim($vetor[0]);
				if (!empty($vetor[18])) {
					$this->otl->trimOTLdata($vetor[18], true, false);
				} // *OTL*
			}

			// FIXED TO ALLOW IT TO SHOW '0'
			if (empty($vetor[0]) && !($vetor[0] === '0') && empty($vetor[7])) { //Ignore empty text and not carrying an internal link
				//Check if it is the last element. If so then finish printing the block
				if ($i == ($array_size - 1)) {
					$this->finishFlowingBlock(true);
				} // true = END of flowing block
				continue;
			}


			//Activating buffer properties
			if (isset($vetor[11]) && $vetor[11] != '') {   // Font Size
				if ($is_table && $this->shrin_k) {
					$this->SetFontSize($vetor[11] / $this->shrin_k, false);
				} else {
					$this->SetFontSize($vetor[11], false);
				}
			}

			if (isset($vetor[17]) && !empty($vetor[17])) { //TextShadow
				$this->textshadow = $vetor[17];
			}
			if (isset($vetor[16]) && !empty($vetor[16])) { //Border
				$this->spanborddet = $vetor[16];
				$this->spanborder = true;
			}

			if (isset($vetor[15])) {   // Word spacing
				$this->wSpacingCSS = $vetor[15];
				if ($this->wSpacingCSS && strtoupper($this->wSpacingCSS) != 'NORMAL') {
					$this->minwSpacing = $this->ConvertSize($this->wSpacingCSS, $this->FontSize) / $this->shrin_k; // mPDF 5.7.3
				}
			}
			if (isset($vetor[14])) {   // Letter spacing
				$this->lSpacingCSS = $vetor[14];
				if (($this->lSpacingCSS || $this->lSpacingCSS === '0') && strtoupper($this->lSpacingCSS) != 'NORMAL') {
					$this->fixedlSpacing = $this->ConvertSize($this->lSpacingCSS, $this->FontSize) / $this->shrin_k; // mPDF 5.7.3
				}
			}


			if (isset($vetor[10]) and ! empty($vetor[10])) { //Background color
				$this->spanbgcolorarray = $vetor[10];
				$this->spanbgcolor = true;
			}
			if (isset($vetor[9]) and ! empty($vetor[9])) { // Text parameters - Outline + hyphens
				$this->textparam = $vetor[9];
				$this->SetTextOutline($this->textparam);
				// mPDF 5.7.3  inline text-decoration parameters
				if ($is_table && $this->shrin_k) {
					if (isset($this->textparam['text-baseline'])) {
						$this->textparam['text-baseline'] /= $this->shrin_k;
					}
					if (isset($this->textparam['decoration-baseline'])) {
						$this->textparam['decoration-baseline'] /= $this->shrin_k;
					}
					if (isset($this->textparam['decoration-fontsize'])) {
						$this->textparam['decoration-fontsize'] /= $this->shrin_k;
					}
				}
			}
			if (isset($vetor[8])) {  // mPDF 5.7.1
				$this->textvar = $vetor[8];
			}
			if (isset($vetor[7]) and $vetor[7] != '') { // internal target: <a name="anyvalue">
				$ily = $this->y;
				if ($this->table_rotate) {
					$this->internallink[$vetor[7]] = array("Y" => $ily, "PAGE" => $this->page, "tbrot" => true);
				} elseif ($this->kwt) {
					$this->internallink[$vetor[7]] = array("Y" => $ily, "PAGE" => $this->page, "kwt" => true);
				} elseif ($this->ColActive) {
					$this->internallink[$vetor[7]] = array("Y" => $ily, "PAGE" => $this->page, "col" => $this->CurrCol);
				} elseif (!$this->keep_block_together) {
					$this->internallink[$vetor[7]] = array("Y" => $ily, "PAGE" => $this->page);
				}
				if (empty($vetor[0])) { //Ignore empty text
					//Check if it is the last element. If so then finish printing the block
					if ($i == ($array_size - 1)) {
						$this->finishFlowingBlock(true);
					} // true = END of flowing block
					continue;
				}
			}
			if (isset($vetor[5]) and $vetor[5] != '') {  // Language	// mPDF 6
				$this->currentLang = $vetor[5];
			}
			if (isset($vetor[4]) and $vetor[4] != '') {  // Font Family
				$font = $this->SetFont($vetor[4], $this->FontStyle, 0, false);
			}
			if (!empty($vetor[3])) { //Font Color
				$cor = $vetor[3];
				$this->SetTColor($cor);
			}
			if (isset($vetor[2]) and $vetor[2] != '') { //Bold,Italic styles
				$this->SetStyles($vetor[2]);
			}

			if (isset($vetor[12]) and $vetor[12] != '') { //Requested Bold,Italic
				$this->ReqFontStyle = $vetor[12];
			}
			if (isset($vetor[1]) and $vetor[1] != '') { //LINK
				if (strpos($vetor[1], ".") === false && strpos($vetor[1], "@") !== 0) { //assuming every external link has a dot indicating extension (e.g: .html .txt .zip www.somewhere.com etc.)
					//Repeated reference to same anchor?
					while (array_key_exists($vetor[1], $this->internallink))
						$vetor[1] = "#" . $vetor[1];
					$this->internallink[$vetor[1]] = $this->AddLink();
					$vetor[1] = $this->internallink[$vetor[1]];
				}
				$this->HREF = $vetor[1];     // HREF link style set here ******
			}

			// SPECIAL CONTENT - IMAGES & FORM OBJECTS
			//Print-out special content

			if (substr($vetor[0], 0, 3) == "\xbb\xa4\xac") { //identifier has been identified!
				$objattr = $this->_getObjAttr($vetor[0]);

				/* -- TABLES -- */
				if ($objattr['type'] == 'nestedtable') {
					if ($objattr['nestedcontent']) {
						$level = $objattr['level'];
						$table = &$this->table[$level][$objattr['table']];

						if ($table_draft) {
							$this->y += $this->table[($level + 1)][$objattr['nestedcontent']]['h']; // nested table height
							$this->finishFlowingBlock(false, 'nestedtable');
						} else {

							$cell = &$table['cells'][$objattr['row']][$objattr['col']];
							$this->finishFlowingBlock(false, 'nestedtable');
							$save_dw = $this->divwidth;
							$save_buffer = $this->cellBorderBuffer;
							$this->cellBorderBuffer = array();
							$ncx = $this->x;
							list($dummyx, $w) = $this->_tableGetWidth($table, $objattr['row'], $objattr['col']);
							$ntw = $this->table[($level + 1)][$objattr['nestedcontent']]['w']; // nested table width
							if (!$this->simpleTables) {
								if ($this->packTableData) {
									list($bt, $br, $bb, $bl) = $this->_getBorderWidths($cell['borderbin']);
								} else {
									$br = $cell['border_details']['R']['w'];
									$bl = $cell['border_details']['L']['w'];
								}
								if ($table['borders_separate']) {
									$innerw = $w - $bl - $br - $cell['padding']['L'] - $cell['padding']['R'] - $table['border_spacing_H'];
								} else {
									$innerw = $w - $bl / 2 - $br / 2 - $cell['padding']['L'] - $cell['padding']['R'];
								}
							} elseif ($this->simpleTables) {
								if ($table['borders_separate']) {
									$innerw = $w - $table['simple']['border_details']['L']['w'] - $table['simple']['border_details']['R']['w'] - $cell['padding']['L'] - $cell['padding']['R'] - $table['border_spacing_H'];
								} else {
									$innerw = $w - $table['simple']['border_details']['L']['w'] / 2 - $table['simple']['border_details']['R']['w'] / 2 - $cell['padding']['L'] - $cell['padding']['R'];
								}
							}
							if ($cell['a'] == 'C' || $this->table[($level + 1)][$objattr['nestedcontent']]['a'] == 'C') {
								$ncx += ($innerw - $ntw) / 2;
							} elseif ($cell['a'] == 'R' || $this->table[($level + 1)][$objattr['nestedcontent']]['a'] == 'R') {
								$ncx += $innerw - $ntw;
							}
							$this->x = $ncx;

							$this->_tableWrite($this->table[($level + 1)][$objattr['nestedcontent']]);
							$this->cellBorderBuffer = $save_buffer;
							$this->x = $bak_x;
							$this->divwidth = $save_dw;
						}

						$this->newFlowingBlock($this->divwidth, $this->divheight, $align, $is_table, $blockstate, false, $blockdir, $table_draft);
					}
				} else {
					/* -- END TABLES -- */
					if ($is_table) { // *TABLES*
						$maxWidth = $this->divwidth;  // *TABLES*
					} // *TABLES*
					else { // *TABLES*
						$maxWidth = $this->divwidth - ($this->blk[$this->blklvl]['padding_left'] + $this->blk[$this->blklvl]['border_left']['w'] + $this->blk[$this->blklvl]['padding_right'] + $this->blk[$this->blklvl]['border_right']['w']);
					} // *TABLES*

					/* -- CSS-IMAGE-FLOAT -- */
					// If float (already) exists at this level
					if (isset($this->floatmargins['R']) && $this->y <= $this->floatmargins['R']['y1'] && $this->y >= $this->floatmargins['R']['y0']) {
						$maxWidth -= $this->floatmargins['R']['w'];
					}
					if (isset($this->floatmargins['L']) && $this->y <= $this->floatmargins['L']['y1'] && $this->y >= $this->floatmargins['L']['y0']) {
						$maxWidth -= $this->floatmargins['L']['w'];
					}
					/* -- END CSS-IMAGE-FLOAT -- */

					list($skipln) = $this->inlineObject($objattr['type'], '', $this->y, $objattr, $this->lMargin, ($this->flowingBlockAttr['contentWidth'] / _MPDFK), $maxWidth, $this->flowingBlockAttr['height'], false, $is_table);
					//  1 -> New line needed because of width
					// -1 -> Will fit width on line but NEW PAGE REQUIRED because of height
					// -2 -> Will not fit on line therefore needs new line but thus NEW PAGE REQUIRED
					$iby = $this->y;
					$oldpage = $this->page;
					$oldcol = $this->CurrCol;
					if (($skipln == 1 || $skipln == -2) && !isset($objattr['float'])) {
						$this->finishFlowingBlock(false, $objattr['type']);
						$this->newFlowingBlock($this->divwidth, $this->divheight, $align, $is_table, $blockstate, false, $blockdir, $table_draft);
					}

					if (!$table_draft) {
						$thispage = $this->page;
						if ($this->CurrCol != $oldcol) {
							$changedcol = true;
						} else {
							$changedcol = false;
						}

						// the previous lines can already have triggered page break or column change
						if (!$changedcol && $skipln < 0 && $this->AcceptPageBreak() && $thispage == $oldpage) {

							$this->AddPage($this->CurOrientation);

							// Added to correct Images already set on line before page advanced
							// i.e. if second inline image on line is higher than first and forces new page
							if (count($this->objectbuffer)) {
								$yadj = $iby - $this->y;
								foreach ($this->objectbuffer AS $ib => $val) {
									if ($this->objectbuffer[$ib]['OUTER-Y'])
										$this->objectbuffer[$ib]['OUTER-Y'] -= $yadj;
									if ($this->objectbuffer[$ib]['BORDER-Y'])
										$this->objectbuffer[$ib]['BORDER-Y'] -= $yadj;
									if ($this->objectbuffer[$ib]['INNER-Y'])
										$this->objectbuffer[$ib]['INNER-Y'] -= $yadj;
								}
							}
						}

						// Added to correct for OddEven Margins
						if ($this->page != $oldpage) {
							if (($this->page - $oldpage) % 2 == 1) {
								$bak_x += $this->MarginCorrection;
							}
							$oldpage = $this->page;
							$y = $this->tMargin - $paint_ht_corr;
							$this->oldy = $this->tMargin - $paint_ht_corr;
							$old_height = 0;
						}
						$this->x = $bak_x;
						/* -- COLUMNS -- */
						// COLS
						// OR COLUMN CHANGE
						if ($this->CurrCol != $oldcolumn) {
							if ($this->directionality == 'rtl') { // *OTL*
								$bak_x -= ($this->CurrCol - $oldcolumn) * ($this->ColWidth + $this->ColGap); // *OTL*
							} // *OTL*
							else { // *OTL*
								$bak_x += ($this->CurrCol - $oldcolumn) * ($this->ColWidth + $this->ColGap);
							} // *OTL*
							$this->x = $bak_x;
							$oldcolumn = $this->CurrCol;
							$y = $this->y0 - $paint_ht_corr;
							$this->oldy = $this->y0 - $paint_ht_corr;
							$old_height = 0;
						}
						/* -- END COLUMNS -- */
					}

					/* -- CSS-IMAGE-FLOAT -- */
					if ($objattr['type'] == 'image' && isset($objattr['float'])) {
						$fy = $this->y;

						// DIV TOP MARGIN/BORDER/PADDING
						if ($this->flowingBlockAttr['newblock'] && ($this->flowingBlockAttr['blockstate'] == 1 || $this->flowingBlockAttr['blockstate'] == 3) && $this->flowingBlockAttr['lineCount'] == 0) {
							$fy += $this->blk[$this->blklvl]['margin_top'] + $this->blk[$this->blklvl]['padding_top'] + $this->blk[$this->blklvl]['border_top']['w'];
						}

						if ($objattr['float'] == 'R') {
							$fx = $this->w - $this->rMargin - $objattr['width'] - ($this->blk[$this->blklvl]['outer_right_margin'] + $this->blk[$this->blklvl]['border_right']['w'] + $this->blk[$this->blklvl]['padding_right']);
						} elseif ($objattr['float'] == 'L') {
							$fx = $this->lMargin + ($this->blk[$this->blklvl]['outer_left_margin'] + $this->blk[$this->blklvl]['border_left']['w'] + $this->blk[$this->blklvl]['padding_left']);
						}
						$w = $objattr['width'];
						$h = abs($objattr['height']);

						$widthLeft = $maxWidth - ($this->flowingBlockAttr['contentWidth'] / _MPDFK);
						$maxHeight = $this->h - ($this->tMargin + $this->margin_header + $this->bMargin + 10);
						// For Images
						$extraWidth = ($objattr['border_left']['w'] + $objattr['border_right']['w'] + $objattr['margin_left'] + $objattr['margin_right']);
						$extraHeight = ($objattr['border_top']['w'] + $objattr['border_bottom']['w'] + $objattr['margin_top'] + $objattr['margin_bottom']);

						if ($objattr['itype'] == 'wmf' || $objattr['itype'] == 'svg') {
							$file = $objattr['file'];
							$info = $this->formobjects[$file];
						} else {
							$file = $objattr['file'];
							$info = $this->images[$file];
						}
						$img_w = $w - $extraWidth;
						$img_h = $h - $extraHeight;
						if ($objattr['border_left']['w']) {
							$objattr['BORDER-WIDTH'] = $img_w + (($objattr['border_left']['w'] + $objattr['border_right']['w']) / 2);
							$objattr['BORDER-HEIGHT'] = $img_h + (($objattr['border_top']['w'] + $objattr['border_bottom']['w']) / 2);
							$objattr['BORDER-X'] = $fx + $objattr['margin_left'] + (($objattr['border_left']['w']) / 2);
							$objattr['BORDER-Y'] = $fy + $objattr['margin_top'] + (($objattr['border_top']['w']) / 2);
						}
						$objattr['INNER-WIDTH'] = $img_w;
						$objattr['INNER-HEIGHT'] = $img_h;
						$objattr['INNER-X'] = $fx + $objattr['margin_left'] + ($objattr['border_left']['w']);
						$objattr['INNER-Y'] = $fy + $objattr['margin_top'] + ($objattr['border_top']['w']);
						$objattr['ID'] = $info['i'];
						$objattr['OUTER-WIDTH'] = $w;
						$objattr['OUTER-HEIGHT'] = $h;
						$objattr['OUTER-X'] = $fx;
						$objattr['OUTER-Y'] = $fy;
						if ($objattr['float'] == 'R') {
							// If R float already exists at this level
							$this->floatmargins['R']['skipline'] = false;
							if (isset($this->floatmargins['R']['y1']) && $this->floatmargins['R']['y1'] > 0 && $fy < $this->floatmargins['R']['y1']) {
								$this->WriteFlowingBlock($vetor[0], $vetor[18]);  // mPDF 5.7.1
							}
							// If L float already exists at this level
							elseif (isset($this->floatmargins['L']['y1']) && $this->floatmargins['L']['y1'] > 0 && $fy < $this->floatmargins['L']['y1']) {
								// Final check distance between floats is not now too narrow to fit text
								$mw = 2 * $this->GetCharWidth('W', false);
								if (($this->blk[$this->blklvl]['inner_width'] - $w - $this->floatmargins['L']['w']) < $mw) {
									$this->WriteFlowingBlock($vetor[0], $vetor[18]);  // mPDF 5.7.1
								} else {
									$this->floatmargins['R']['x'] = $fx;
									$this->floatmargins['R']['w'] = $w;
									$this->floatmargins['R']['y0'] = $fy;
									$this->floatmargins['R']['y1'] = $fy + $h;
									if ($skipln == 1) {
										$this->floatmargins['R']['skipline'] = true;
										$this->floatmargins['R']['id'] = count($this->floatbuffer) + 0;
										$objattr['skipline'] = true;
									}
									$this->floatbuffer[] = $objattr;
								}
							} else {
								$this->floatmargins['R']['x'] = $fx;
								$this->floatmargins['R']['w'] = $w;
								$this->floatmargins['R']['y0'] = $fy;
								$this->floatmargins['R']['y1'] = $fy + $h;
								if ($skipln == 1) {
									$this->floatmargins['R']['skipline'] = true;
									$this->floatmargins['R']['id'] = count($this->floatbuffer) + 0;
									$objattr['skipline'] = true;
								}
								$this->floatbuffer[] = $objattr;
							}
						} elseif ($objattr['float'] == 'L') {
							// If L float already exists at this level
							$this->floatmargins['L']['skipline'] = false;
							if (isset($this->floatmargins['L']['y1']) && $this->floatmargins['L']['y1'] > 0 && $fy < $this->floatmargins['L']['y1']) {
								$this->floatmargins['L']['skipline'] = false;
								$this->WriteFlowingBlock($vetor[0], $vetor[18]);  // mPDF 5.7.1
							}
							// If R float already exists at this level
							elseif (isset($this->floatmargins['R']['y1']) && $this->floatmargins['R']['y1'] > 0 && $fy < $this->floatmargins['R']['y1']) {
								// Final check distance between floats is not now too narrow to fit text
								$mw = 2 * $this->GetCharWidth('W', false);
								if (($this->blk[$this->blklvl]['inner_width'] - $w - $this->floatmargins['R']['w']) < $mw) {
									$this->WriteFlowingBlock($vetor[0], $vetor[18]);  // mPDF 5.7.1
								} else {
									$this->floatmargins['L']['x'] = $fx + $w;
									$this->floatmargins['L']['w'] = $w;
									$this->floatmargins['L']['y0'] = $fy;
									$this->floatmargins['L']['y1'] = $fy + $h;
									if ($skipln == 1) {
										$this->floatmargins['L']['skipline'] = true;
										$this->floatmargins['L']['id'] = count($this->floatbuffer) + 0;
										$objattr['skipline'] = true;
									}
									$this->floatbuffer[] = $objattr;
								}
							} else {
								$this->floatmargins['L']['x'] = $fx + $w;
								$this->floatmargins['L']['w'] = $w;
								$this->floatmargins['L']['y0'] = $fy;
								$this->floatmargins['L']['y1'] = $fy + $h;
								if ($skipln == 1) {
									$this->floatmargins['L']['skipline'] = true;
									$this->floatmargins['L']['id'] = count($this->floatbuffer) + 0;
									$objattr['skipline'] = true;
								}
								$this->floatbuffer[] = $objattr;
							}
						}
					} else {
						/* -- END CSS-IMAGE-FLOAT -- */
						$this->WriteFlowingBlock($vetor[0], (isset($vetor[18]) ? $vetor[18] : NULL));  // mPDF 5.7.1
						/* -- CSS-IMAGE-FLOAT -- */
					}
					/* -- END CSS-IMAGE-FLOAT -- */
				} // *TABLES*
			} // END If special content
			else { //THE text
				if ($this->tableLevel) {
					$paint_ht_corr = 0;
				} // To move the y up when new column/page started if div border needed
				else {
					$paint_ht_corr = $this->blk[$this->blklvl]['border_top']['w'];
				}

				if ($vetor[0] == "\n") { //We are reading a <BR> now turned into newline ("\n")
					if ($this->flowingBlockAttr['content']) {
						$this->finishFlowingBlock(false, 'br');
					} elseif ($is_table) {
						$this->y+= $this->_computeLineheight($this->cellLineHeight);
					} elseif (!$is_table) {
						$this->DivLn($this->lineheight);
						if ($this->ColActive) {
							$this->breakpoints[$this->CurrCol][] = $this->y;
						} // *COLUMNS*
					}
					// Added to correct for OddEven Margins
					if ($this->page != $oldpage) {
						if (($this->page - $oldpage) % 2 == 1) {
							$bak_x += $this->MarginCorrection;
						}
						$oldpage = $this->page;
						$y = $this->tMargin - $paint_ht_corr;
						$this->oldy = $this->tMargin - $paint_ht_corr;
						$old_height = 0;
					}
					$this->x = $bak_x;
					/* -- COLUMNS -- */
					// COLS
					// OR COLUMN CHANGE
					if ($this->CurrCol != $oldcolumn) {
						if ($this->directionality == 'rtl') { // *OTL*
							$bak_x -= ($this->CurrCol - $oldcolumn) * ($this->ColWidth + $this->ColGap); // *OTL*
						} // *OTL*
						else { // *OTL*
							$bak_x += ($this->CurrCol - $oldcolumn) * ($this->ColWidth + $this->ColGap);
						} // *OTL*
						$this->x = $bak_x;
						$oldcolumn = $this->CurrCol;
						$y = $this->y0 - $paint_ht_corr;
						$this->oldy = $this->y0 - $paint_ht_corr;
						$old_height = 0;
					}
					/* -- END COLUMNS -- */
					$this->newFlowingBlock($this->divwidth, $this->divheight, $align, $is_table, $blockstate, false, $blockdir, $table_draft);
				} else {
					$this->WriteFlowingBlock($vetor[0], $vetor[18]);  // mPDF 5.7.1
					// Added to correct for OddEven Margins
					if ($this->page != $oldpage) {
						if (($this->page - $oldpage) % 2 == 1) {
							$bak_x += $this->MarginCorrection;
							$this->x = $bak_x;
						}
						$oldpage = $this->page;
						$y = $this->tMargin - $paint_ht_corr;
						$this->oldy = $this->tMargin - $paint_ht_corr;
						$old_height = 0;
					}
					/* -- COLUMNS -- */
					// COLS
					// OR COLUMN CHANGE
					if ($this->CurrCol != $oldcolumn) {
						if ($this->directionality == 'rtl') { // *OTL*
							$bak_x -= ($this->CurrCol - $oldcolumn) * ($this->ColWidth + $this->ColGap); // *OTL*
						} // *OTL*
						else { // *OTL*
							$bak_x += ($this->CurrCol - $oldcolumn) * ($this->ColWidth + $this->ColGap);
						} // *OTL*
						$this->x = $bak_x;
						$oldcolumn = $this->CurrCol;
						$y = $this->y0 - $paint_ht_corr;
						$this->oldy = $this->y0 - $paint_ht_corr;
						$old_height = 0;
					}
					/* -- END COLUMNS -- */
				}
			}

			//Check if it is the last element. If so then finish printing the block
			if ($i == ($array_size - 1)) {
				$this->finishFlowingBlock(true); // true = END of flowing block
				// Added to correct for OddEven Margins
				if ($this->page != $oldpage) {
					if (($this->page - $oldpage) % 2 == 1) {
						$bak_x += $this->MarginCorrection;
						$this->x = $bak_x;
					}
					$oldpage = $this->page;
					$y = $this->tMargin - $paint_ht_corr;
					$this->oldy = $this->tMargin - $paint_ht_corr;
					$old_height = 0;
				}

				/* -- COLUMNS -- */
				// COLS
				// OR COLUMN CHANGE
				if ($this->CurrCol != $oldcolumn) {
					if ($this->directionality == 'rtl') { // *OTL*
						$bak_x -= ($this->CurrCol - $oldcolumn) * ($this->ColWidth + $this->ColGap); // *OTL*
					} // *OTL*
					else { // *OTL*
						$bak_x += ($this->CurrCol - $oldcolumn) * ($this->ColWidth + $this->ColGap);
					} // *OTL*
					$this->x = $bak_x;
					$oldcolumn = $this->CurrCol;
					$y = $this->y0 - $paint_ht_corr;
					$this->oldy = $this->y0 - $paint_ht_corr;
					$old_height = 0;
				}
				/* -- END COLUMNS -- */
			}

			// RESETTING VALUES
			$this->SetTColor($this->ConvertColor(0));
			$this->SetDColor($this->ConvertColor(0));
			$this->SetFColor($this->ConvertColor(255));
			$this->colorarray = '';
			$this->spanbgcolorarray = '';
			$this->spanbgcolor = false;
			$this->spanborder = false;
			$this->spanborddet = array();
			$this->HREF = '';
			$this->textparam = array();
			$this->SetTextOutline();

			$this->textvar = 0x00; // mPDF 5.7.1
			$this->OTLtags = array();
			$this->textshadow = '';

			$this->currentfontfamily = '';
			$this->currentfontsize = '';
			$this->currentfontstyle = '';
			$this->currentLang = $this->default_lang;  // mPDF 6
			$this->RestrictUnicodeFonts($this->default_available_fonts); // mPDF 6
			/* -- TABLES -- */
			if ($this->tableLevel) {
				$this->SetLineHeight('', $this->table[1][1]['cellLineHeight']); // *TABLES*
			} else
			/* -- END TABLES -- */
			if (isset($this->blk[$this->blklvl]['line_height']) && $this->blk[$this->blklvl]['line_height']) {
				$this->SetLineHeight('', $this->blk[$this->blklvl]['line_height']); // sets default line height
			}
			$this->ResetStyles();
			$this->lSpacingCSS = '';
			$this->wSpacingCSS = '';
			$this->fixedlSpacing = false;
			$this->minwSpacing = 0;
			$this->SetDash();
			$this->dash_on = false;
			$this->dotted_on = false;
		}//end of for(i=0;i<arraysize;i++)

		$this->Reset(); // mPDF 6
		// PAINT DIV BORDER	// DISABLED IN COLUMNS AS DOESN'T WORK WHEN BROKEN ACROSS COLS??
		if ((isset($this->blk[$this->blklvl]['border']) || isset($this->blk[$this->blklvl]['bgcolor']) || isset($this->blk[$this->blklvl]['box_shadow'])) && $blockstate && ($this->y != $this->oldy)) {
			$bottom_y = $this->y; // Does not include Bottom Margin
			if (isset($this->blk[$this->blklvl]['startpage']) && $this->blk[$this->blklvl]['startpage'] != $this->page && $blockstate != 1) {
				$this->PaintDivBB('pagetop', $blockstate);
			} elseif ($blockstate != 1) {
				$this->PaintDivBB('', $blockstate);
			}
			$this->y = $bottom_y;
			$this->x = $bak_x;
		}

		// Reset Font
		$this->SetFontSize($this->default_font_size, false);
		if ($table_draft) {
			$ch = $this->y - $bak_y;
			$this->y = $bak_y;
			$this->x = $bak_x;
			return $ch;
		}
	}

	function _setDashBorder($style, $div, $cp, $side)
	{
		if ($style == 'dashed' && (($side == 'L' || $side == 'R') || ($side == 'T' && $div != 'pagetop' && !$cp) || ($side == 'B' && $div != 'pagebottom') )) {
			$dashsize = 2; // final dash will be this + 1*linewidth
			$dashsizek = 1.5; // ratio of Dash/Blank
			$this->SetDash($dashsize, ($dashsize / $dashsizek) + ($this->LineWidth * 2));
		} elseif ($style == 'dotted' || ($side == 'T' && ($div == 'pagetop' || $cp)) || ($side == 'B' && $div == 'pagebottom')) {
			//Round join and cap
			$this->SetLineJoin(1);
			$this->SetLineCap(1);
			$this->SetDash(0.001, ($this->LineWidth * 3));
		}
	}

	function _setBorderLine($b, $k = 1)
	{
		$this->SetLineWidth($b['w'] / $k);
		$this->SetDColor($b['c']);
		if ($b['c'][0] == 5) { // RGBa
			$this->SetAlpha(ord($b['c'][4]) / 100, 'Normal', false, 'S') . "\n"; // mPDF 5.7.2
		} elseif ($b['c'][0] == 6) { // CMYKa
			$this->SetAlpha(ord($b['c'][5]) / 100, 'Normal', false, 'S') . "\n"; // mPDF 5.7.2
		}
	}

	function PaintDivBB($divider = '', $blockstate = 0, $blvl = 0)
	{
		// Borders & backgrounds are done elsewhere for columns - messes up the repositioning in printcolumnbuffer
		if ($this->ColActive) {
			return;
		} // *COLUMNS*
		if ($this->keep_block_together) {
			return;
		} // mPDF 6
		$save_y = $this->y;
		if (!$blvl) {
			$blvl = $this->blklvl;
		}
		$x0 = $x1 = $y0 = $y1 = 0;

		// Added mPDF 3.0 Float DIV
		if (isset($this->blk[$blvl]['bb_painted'][$this->page]) && $this->blk[$blvl]['bb_painted'][$this->page]) {
			return;
		} // *CSS-FLOAT*

		if (isset($this->blk[$blvl]['x0'])) {
			$x0 = $this->blk[$blvl]['x0'];
		} // left
		if (isset($this->blk[$blvl]['y1'])) {
			$y1 = $this->blk[$blvl]['y1'];
		} // bottom
		// Added mPDF 3.0 Float DIV - ensures backgrounds/borders are drawn to bottom of page
		if ($y1 == 0) {
			if ($divider == 'pagebottom') {
				$y1 = $this->h - $this->bMargin;
			} else {
				$y1 = $this->y;
			}
		}

		if (isset($this->blk[$blvl]['startpage']) && $this->blk[$blvl]['startpage'] != $this->page) {
			$continuingpage = true;
		} else {
			$continuingpage = false;
		}

		if (isset($this->blk[$blvl]['y0'])) {
			$y0 = $this->blk[$blvl]['y0'];
		}
		$h = $y1 - $y0;
		$w = $this->blk[$blvl]['width'];
		$x1 = $x0 + $w;

		// Set border-widths as used here
		$border_top = $this->blk[$blvl]['border_top']['w'];
		$border_bottom = $this->blk[$blvl]['border_bottom']['w'];
		$border_left = $this->blk[$blvl]['border_left']['w'];
		$border_right = $this->blk[$blvl]['border_right']['w'];
		if (!$this->blk[$blvl]['border_top'] || $divider == 'pagetop' || $continuingpage) {
			$border_top = 0;
		}
		if (!$this->blk[$blvl]['border_bottom'] || $blockstate == 1 || $divider == 'pagebottom') {
			$border_bottom = 0;
		}

		$brTL_H = 0;
		$brTL_V = 0;
		$brTR_H = 0;
		$brTR_V = 0;
		$brBL_H = 0;
		$brBL_V = 0;
		$brBR_H = 0;
		$brBR_V = 0;

		$brset = false;
		/* -- BORDER-RADIUS -- */
		if (isset($this->blk[$blvl]['border_radius_TL_H'])) {
			$brTL_H = $this->blk[$blvl]['border_radius_TL_H'];
			$brset = true;
		}
		if (isset($this->blk[$blvl]['border_radius_TL_V'])) {
			$brTL_V = $this->blk[$blvl]['border_radius_TL_V'];
			$brset = true;
		}
		if (isset($this->blk[$blvl]['border_radius_TR_H'])) {
			$brTR_H = $this->blk[$blvl]['border_radius_TR_H'];
			$brset = true;
		}
		if (isset($this->blk[$blvl]['border_radius_TR_V'])) {
			$brTR_V = $this->blk[$blvl]['border_radius_TR_V'];
			$brset = true;
		}
		if (isset($this->blk[$blvl]['border_radius_BR_H'])) {
			$brBR_H = $this->blk[$blvl]['border_radius_BR_H'];
			$brset = true;
		}
		if (isset($this->blk[$blvl]['border_radius_BR_V'])) {
			$brBR_V = $this->blk[$blvl]['border_radius_BR_V'];
			$brset = true;
		}
		if (isset($this->blk[$blvl]['border_radius_BL_H'])) {
			$brBL_H = $this->blk[$blvl]['border_radius_BL_H'];
			$brset = true;
		}
		if (isset($this->blk[$blvl]['border_radius_BL_V'])) {
			$brBL_V = $this->blk[$blvl]['border_radius_BL_V'];
			$brset = true;
		}

		if (!$this->blk[$blvl]['border_top'] || $divider == 'pagetop' || $continuingpage) {
			$brTL_H = 0;
			$brTL_V = 0;
			$brTR_H = 0;
			$brTR_V = 0;
		}
		if (!$this->blk[$blvl]['border_bottom'] || $blockstate == 1 || $divider == 'pagebottom') {
			$brBL_H = 0;
			$brBL_V = 0;
			$brBR_H = 0;
			$brBR_V = 0;
		}

		// Disallow border-radius if it is smaller than the border width.
		if ($brTL_H < min($border_left, $border_top)) {
			$brTL_H = $brTL_V = 0;
		}
		if ($brTL_V < min($border_left, $border_top)) {
			$brTL_V = $brTL_H = 0;
		}
		if ($brTR_H < min($border_right, $border_top)) {
			$brTR_H = $brTR_V = 0;
		}
		if ($brTR_V < min($border_right, $border_top)) {
			$brTR_V = $brTR_H = 0;
		}
		if ($brBL_H < min($border_left, $border_bottom)) {
			$brBL_H = $brBL_V = 0;
		}
		if ($brBL_V < min($border_left, $border_bottom)) {
			$brBL_V = $brBL_H = 0;
		}
		if ($brBR_H < min($border_right, $border_bottom)) {
			$brBR_H = $brBR_V = 0;
		}
		if ($brBR_V < min($border_right, $border_bottom)) {
			$brBR_V = $brBR_H = 0;
		}

		// CHECK FOR radii that sum to > width or height of div ********
		$f = min($h / ($brTL_V + $brBL_V + 0.001), $h / ($brTR_V + $brBR_V + 0.001), $w / ($brTL_H + $brTR_H + 0.001), $w / ($brBL_H + $brBR_H + 0.001));
		if ($f < 1) {
			$brTL_H *= $f;
			$brTL_V *= $f;
			$brTR_H *= $f;
			$brTR_V *= $f;
			$brBL_H *= $f;
			$brBL_V *= $f;
			$brBR_H *= $f;
			$brBR_V *= $f;
		}
		/* -- END BORDER-RADIUS -- */

		$tbcol = $this->ConvertColor(255);
		for ($l = 0; $l <= $blvl; $l++) {
			if ($this->blk[$l]['bgcolor']) {
				$tbcol = $this->blk[$l]['bgcolorarray'];
			}
		}

		// BORDERS
		if (isset($this->blk[$blvl]['y0']) && $this->blk[$blvl]['y0']) {
			$y0 = $this->blk[$blvl]['y0'];
		}
		$h = $y1 - $y0;
		$w = $this->blk[$blvl]['width'];

		if ($this->blk[$blvl]['border_top'] && $divider != 'pagetop' && !$continuingpage) {
			$tbd = $this->blk[$blvl]['border_top'];

			$legend = '';
			$legbreakL = 0;
			$legbreakR = 0;
			// BORDER LEGEND
			if (isset($this->blk[$blvl]['border_legend']) && $this->blk[$blvl]['border_legend']) {
				$legend = $this->blk[$blvl]['border_legend']; // Same structure array as textbuffer
				$txt = $legend[0] = ltrim($legend[0]);
				if (!empty($legend[18])) {
					$this->otl->trimOTLdata($legend[18], true, false);
				} // *OTL*
				//Set font, size, style, color
				$this->SetFont($legend[4], $legend[2], $legend[11]);
				if (isset($legend[3]) && $legend[3]) {
					$cor = $legend[3];
					$this->SetTColor($cor);
				}
				$stringWidth = $this->GetStringWidth($txt, true, $legend[18], $legend[8]);
				$save_x = $this->x;
				$save_y = $this->y;
				$save_currentfontfamily = $this->FontFamily;
				$save_currentfontsize = $this->FontSizePt;
				$save_currentfontstyle = $this->FontStyle;
				$this->y = $y0 - $this->FontSize / 2 + $this->blk[$blvl]['border_top']['w'] / 2;
				$this->x = $x0 + $this->blk[$blvl]['padding_left'] + $this->blk[$blvl]['border_left']['w'];

				// Set the distance from the border line to the text ? make configurable variable
				$gap = 0.2 * $this->FontSize;
				$legbreakL = $this->x - $gap;
				$legbreakR = $this->x + $stringWidth + $gap;
				$this->magic_reverse_dir($txt, $this->blk[$blvl]['direction'], $legend[18]);
				$fill = '';
				$this->Cell($stringWidth, $this->FontSize, $txt, '', 0, 'C', $fill, '', 0, 0, 0, 'M', $fill, false, $legend[18], $legend[8]);
				// Reset
				$this->x = $save_x;
				$this->y = $save_y;
				$this->SetFont($save_currentfontfamily, $save_currentfontstyle, $save_currentfontsize);
				$this->SetTColor($this->ConvertColor(0));
			}

			if (isset($tbd['s']) && $tbd['s']) {
				if (!$brset && $tbd['style'] != 'dotted' && $tbd['style'] != 'dashed') {
					$this->_out('q');
					$this->SetLineWidth(0);
					$this->_out(sprintf('%.3F %.3F m ', ($x0) * _MPDFK, ($this->h - ($y0)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $border_left) * _MPDFK, ($this->h - ($y0 + $border_top)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $w - $border_right) * _MPDFK, ($this->h - ($y0 + $border_top)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $w) * _MPDFK, ($this->h - ($y0)) * _MPDFK));
					$this->_out(' h W n '); // Ends path no-op & Sets the clipping path
				}

				$this->_setBorderLine($tbd);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$legbreakL -= $border_top / 2; // because line cap different
					$legbreakR += $border_top / 2;
					$this->_setDashBorder($tbd['style'], $divider, $continuingpage, 'T');
				}
				/* -- BORDER-RADIUS -- */ elseif (($brTL_V && $brTL_H) || ($brTR_V && $brTR_H) || $tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$this->SetLineJoin(0);
					$this->SetLineCap(0);
				}
				$s = '';
				if ($brTR_H && $brTR_V) {
					$s .= ($this->_EllipseArc($x0 + $w - $brTR_H, $y0 + $brTR_V, $brTR_H - $border_top / 2, $brTR_V - $border_top / 2, 1, 2, true)) . "\n";
				} else
				/* -- END BORDER-RADIUS -- */
				if ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$s .= (sprintf('%.3F %.3F m ', ($x0 + $w) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
				} else {
					$s .= (sprintf('%.3F %.3F m ', ($x0 + $w - ($border_top / 2)) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
				}
				/* -- BORDER-RADIUS -- */
				if ($brTL_H && $brTL_V) {
					if ($legend) {
						if ($legbreakR < ($x0 + $w - $brTR_H)) {
							$s .= (sprintf('%.3F %.3F l ', $legbreakR * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
						}
						if ($legbreakL > ($x0 + $brTL_H )) {
							$s .= (sprintf('%.3F %.3F m ', $legbreakL * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
							$s .= (sprintf('%.3F %.3F l ', ($x0 + $brTL_H ) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK) . "\n");
						} else {
							$s .= (sprintf('%.3F %.3F m ', ($x0 + $brTL_H ) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
						}
					} else {
						$s .= (sprintf('%.3F %.3F l ', ($x0 + $brTL_H ) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
					}
					$s .= ($this->_EllipseArc($x0 + $brTL_H, $y0 + $brTL_V, $brTL_H - $border_top / 2, $brTL_V - $border_top / 2, 2, 1)) . "\n";
				} else {
					/* -- END BORDER-RADIUS -- */
					if ($legend) {
						if ($legbreakR < ($x0 + $w)) {
							$s .= (sprintf('%.3F %.3F l ', $legbreakR * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
						}
						if ($legbreakL > ($x0)) {
							$s .= (sprintf('%.3F %.3F m ', $legbreakL * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
							if ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
								$s .= (sprintf('%.3F %.3F l ', ($x0) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
							} else {
								$s .= (sprintf('%.3F %.3F l ', ($x0 + ($border_top / 2)) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
							}
						} elseif ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
							$s .= (sprintf('%.3F %.3F m ', ($x0) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
						} else {
							$s .= (sprintf('%.3F %.3F m ', ($x0 + $border_top / 2) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
						}
					} elseif ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
						$s .= (sprintf('%.3F %.3F l ', ($x0) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
					} else {
						$s .= (sprintf('%.3F %.3F l ', ($x0 + ($border_top / 2)) * _MPDFK, ($this->h - ($y0 + ($border_top / 2))) * _MPDFK)) . "\n";
					}
					/* -- BORDER-RADIUS -- */
				}
				/* -- END BORDER-RADIUS -- */
				$s .= 'S' . "\n";
				$this->_out($s);

				if ($tbd['style'] == 'double') {
					$this->SetLineWidth($tbd['w'] / 3);
					$this->SetDColor($tbcol);
					$this->_out($s);
				}
				if (!$brset && $tbd['style'] != 'dotted' && $tbd['style'] != 'dashed') {
					$this->_out('Q');
				}

				// Reset Corners and Dash off
				$this->SetLineWidth(0.1);
				$this->SetDColor($this->ConvertColor(0));
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		// Reinstate line above for dotted line divider when block border crosses a page
		//elseif ($divider == 'pagetop' || $continuingpage) {

		if ($this->blk[$blvl]['border_bottom'] && $blockstate != 1 && $divider != 'pagebottom') {
			$tbd = $this->blk[$blvl]['border_bottom'];
			if (isset($tbd['s']) && $tbd['s']) {
				if (!$brset && $tbd['style'] != 'dotted' && $tbd['style'] != 'dashed') {
					$this->_out('q');
					$this->SetLineWidth(0);
					$this->_out(sprintf('%.3F %.3F m ', ($x0) * _MPDFK, ($this->h - ($y0 + $h)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $border_left) * _MPDFK, ($this->h - ($y0 + $h - $border_bottom)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $w - $border_right) * _MPDFK, ($this->h - ($y0 + $h - $border_bottom)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $w) * _MPDFK, ($this->h - ($y0 + $h)) * _MPDFK));
					$this->_out(' h W n '); // Ends path no-op & Sets the clipping path
				}

				$this->_setBorderLine($tbd);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->_setDashBorder($tbd['style'], $divider, $continuingpage, 'B');
				}
				/* -- BORDER-RADIUS -- */ elseif (($brBL_V && $brBL_H) || ($brBR_V && $brBR_H) || $tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$this->SetLineJoin(0);
					$this->SetLineCap(0);
				}
				$s = '';
				if ($brBL_H && $brBL_V) {
					$s .= ($this->_EllipseArc($x0 + $brBL_H, $y0 + $h - $brBL_V, $brBL_H - $border_bottom / 2, $brBL_V - $border_bottom / 2, 3, 2, true)) . "\n";
				} else
				/* -- END BORDER-RADIUS -- */
				if ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$s .= (sprintf('%.3F %.3F m ', ($x0) * _MPDFK, ($this->h - ($y0 + $h - ($border_bottom / 2))) * _MPDFK)) . "\n";
				} else {
					$s .= (sprintf('%.3F %.3F m ', ($x0 + ($border_bottom / 2)) * _MPDFK, ($this->h - ($y0 + $h - ($border_bottom / 2))) * _MPDFK)) . "\n";
				}
				/* -- BORDER-RADIUS -- */
				if ($brBR_H && $brBR_V) {
					$s .= (sprintf('%.3F %.3F l ', ($x0 + $w - ($border_bottom / 2) - $brBR_H ) * _MPDFK, ($this->h - ($y0 + $h - ($border_bottom / 2))) * _MPDFK)) . "\n";
					$s .= ($this->_EllipseArc($x0 + $w - $brBR_H, $y0 + $h - $brBR_V, $brBR_H - $border_bottom / 2, $brBR_V - $border_bottom / 2, 4, 1)) . "\n";
				} else
				/* -- END BORDER-RADIUS -- */
				if ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$s .= (sprintf('%.3F %.3F l ', ($x0 + $w) * _MPDFK, ($this->h - ($y0 + $h - ($border_bottom / 2))) * _MPDFK)) . "\n";
				} else {
					$s .= (sprintf('%.3F %.3F l ', ($x0 + $w - ($border_bottom / 2)) * _MPDFK, ($this->h - ($y0 + $h - ($border_bottom / 2))) * _MPDFK)) . "\n";
				}
				$s .= 'S' . "\n";
				$this->_out($s);

				if ($tbd['style'] == 'double') {
					$this->SetLineWidth($tbd['w'] / 3);
					$this->SetDColor($tbcol);
					$this->_out($s);
				}
				if (!$brset && $tbd['style'] != 'dotted' && $tbd['style'] != 'dashed') {
					$this->_out('Q');
				}


				// Reset Corners and Dash off
				$this->SetLineWidth(0.1);
				$this->SetDColor($this->ConvertColor(0));
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		// Reinstate line below for dotted line divider when block border crosses a page
		//elseif ($blockstate == 1 || $divider == 'pagebottom') {

		if ($this->blk[$blvl]['border_left']) {
			$tbd = $this->blk[$blvl]['border_left'];
			if (isset($tbd['s']) && $tbd['s']) {
				if (!$brset && $tbd['style'] != 'dotted' && $tbd['style'] != 'dashed') {
					$this->_out('q');
					$this->SetLineWidth(0);
					$this->_out(sprintf('%.3F %.3F m ', ($x0) * _MPDFK, ($this->h - ($y0)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $border_left) * _MPDFK, ($this->h - ($y0 + $border_top)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $border_left) * _MPDFK, ($this->h - ($y0 + $h - $border_bottom)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0) * _MPDFK, ($this->h - ($y0 + $h)) * _MPDFK));
					$this->_out(' h W n '); // Ends path no-op & Sets the clipping path
				}

				$this->_setBorderLine($tbd);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->_setDashBorder($tbd['style'], $divider, $continuingpage, 'L');
				}
				/* -- BORDER-RADIUS -- */ elseif (($brTL_V && $brTL_H) || ($brBL_V && $brBL_H) || $tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$this->SetLineJoin(0);
					$this->SetLineCap(0);
				}
				$s = '';
				if ($brTL_V && $brTL_H) {
					$s .= ($this->_EllipseArc($x0 + $brTL_H, $y0 + $brTL_V, $brTL_H - $border_left / 2, $brTL_V - $border_left / 2, 2, 2, true)) . "\n";
				} else
				/* -- END BORDER-RADIUS -- */
				if ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$s .= (sprintf('%.3F %.3F m ', ($x0 + ($border_left / 2)) * _MPDFK, ($this->h - ($y0)) * _MPDFK)) . "\n";
				} else {
					$s .= (sprintf('%.3F %.3F m ', ($x0 + ($border_left / 2)) * _MPDFK, ($this->h - ($y0 + ($border_left / 2))) * _MPDFK)) . "\n";
				}
				/* -- BORDER-RADIUS -- */
				if ($brBL_V && $brBL_H) {
					$s .= (sprintf('%.3F %.3F l ', ($x0 + ($border_left / 2)) * _MPDFK, ($this->h - ($y0 + $h - ($border_left / 2) - $brBL_V) ) * _MPDFK)) . "\n";
					$s .= ($this->_EllipseArc($x0 + $brBL_H, $y0 + $h - $brBL_V, $brBL_H - $border_left / 2, $brBL_V - $border_left / 2, 3, 1)) . "\n";
				} else
				/* -- END BORDER-RADIUS -- */
				if ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$s .= (sprintf('%.3F %.3F l ', ($x0 + ($border_left / 2)) * _MPDFK, ($this->h - ($y0 + $h) ) * _MPDFK)) . "\n";
				} else {
					$s .= (sprintf('%.3F %.3F l ', ($x0 + ($border_left / 2)) * _MPDFK, ($this->h - ($y0 + $h - ($border_left / 2)) ) * _MPDFK)) . "\n";
				}
				$s .= 'S' . "\n";
				$this->_out($s);

				if ($tbd['style'] == 'double') {
					$this->SetLineWidth($tbd['w'] / 3);
					$this->SetDColor($tbcol);
					$this->_out($s);
				}
				if (!$brset && $tbd['style'] != 'dotted' && $tbd['style'] != 'dashed') {
					$this->_out('Q');
				}

				// Reset Corners and Dash off
				$this->SetLineWidth(0.1);
				$this->SetDColor($this->ConvertColor(0));
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		if ($this->blk[$blvl]['border_right']) {
			$tbd = $this->blk[$blvl]['border_right'];
			if (isset($tbd['s']) && $tbd['s']) {
				if (!$brset && $tbd['style'] != 'dotted' && $tbd['style'] != 'dashed') {
					$this->_out('q');
					$this->SetLineWidth(0);
					$this->_out(sprintf('%.3F %.3F m ', ($x0 + $w) * _MPDFK, ($this->h - ($y0)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $w - $border_right) * _MPDFK, ($this->h - ($y0 + $border_top)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $w - $border_right) * _MPDFK, ($this->h - ($y0 + $h - $border_bottom)) * _MPDFK));
					$this->_out(sprintf('%.3F %.3F l ', ($x0 + $w) * _MPDFK, ($this->h - ($y0 + $h)) * _MPDFK));
					$this->_out(' h W n '); // Ends path no-op & Sets the clipping path
				}

				$this->_setBorderLine($tbd);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->_setDashBorder($tbd['style'], $divider, $continuingpage, 'R');
				}
				/* -- BORDER-RADIUS -- */ elseif (($brTR_V && $brTR_H) || ($brBR_V && $brBR_H) || $tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$this->SetLineJoin(0);
					$this->SetLineCap(0);
				}
				$s = '';
				if ($brBR_V && $brBR_H) {
					$s .= ($this->_EllipseArc($x0 + $w - $brBR_H, $y0 + $h - $brBR_V, $brBR_H - $border_right / 2, $brBR_V - $border_right / 2, 4, 2, true)) . "\n";
				} else
				/* -- END BORDER-RADIUS -- */
				if ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$s .= (sprintf('%.3F %.3F m ', ($x0 + $w - ($border_right / 2)) * _MPDFK, ($this->h - ($y0 + $h)) * _MPDFK)) . "\n";
				} else {
					$s .= (sprintf('%.3F %.3F m ', ($x0 + $w - ($border_right / 2)) * _MPDFK, ($this->h - ($y0 + $h - ($border_right / 2))) * _MPDFK)) . "\n";
				}
				/* -- BORDER-RADIUS -- */
				if ($brTR_V && $brTR_H) {
					$s .= (sprintf('%.3F %.3F l ', ($x0 + $w - ($border_right / 2)) * _MPDFK, ($this->h - ($y0 + ($border_right / 2) + $brTR_V) ) * _MPDFK)) . "\n";
					$s .= ($this->_EllipseArc($x0 + $w - $brTR_H, $y0 + $brTR_V, $brTR_H - $border_right / 2, $brTR_V - $border_right / 2, 1, 1)) . "\n";
				} else
				/* -- END BORDER-RADIUS -- */
				if ($tbd['style'] == 'solid' || $tbd['style'] == 'double') {
					$s .= (sprintf('%.3F %.3F l ', ($x0 + $w - ($border_right / 2)) * _MPDFK, ($this->h - ($y0) ) * _MPDFK)) . "\n";
				} else {
					$s .= (sprintf('%.3F %.3F l ', ($x0 + $w - ($border_right / 2)) * _MPDFK, ($this->h - ($y0 + ($border_right / 2)) ) * _MPDFK)) . "\n";
				}
				$s .= 'S' . "\n";
				$this->_out($s);

				if ($tbd['style'] == 'double') {
					$this->SetLineWidth($tbd['w'] / 3);
					$this->SetDColor($tbcol);
					$this->_out($s);
				}
				if (!$brset && $tbd['style'] != 'dotted' && $tbd['style'] != 'dashed') {
					$this->_out('Q');
				}

				// Reset Corners and Dash off
				$this->SetLineWidth(0.1);
				$this->SetDColor($this->ConvertColor(0));
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}


		$this->SetDash();
		$this->y = $save_y;


		// BACKGROUNDS are disabled in columns/kbt/headers - messes up the repositioning in printcolumnbuffer
		if ($this->ColActive || $this->kwt || $this->keep_block_together) {
			return;
		}


		$bgx0 = $x0;
		$bgx1 = $x1;
		$bgy0 = $y0;
		$bgy1 = $y1;

		// Defined br values represent the radius of the outer curve - need to take border-width/2 from each radius for drawing the borders
		if (isset($this->blk[$blvl]['background_clip']) && $this->blk[$blvl]['background_clip'] == 'padding-box') {
			$brbgTL_H = max(0, $brTL_H - $this->blk[$blvl]['border_left']['w']);
			$brbgTL_V = max(0, $brTL_V - $this->blk[$blvl]['border_top']['w']);
			$brbgTR_H = max(0, $brTR_H - $this->blk[$blvl]['border_right']['w']);
			$brbgTR_V = max(0, $brTR_V - $this->blk[$blvl]['border_top']['w']);
			$brbgBL_H = max(0, $brBL_H - $this->blk[$blvl]['border_left']['w']);
			$brbgBL_V = max(0, $brBL_V - $this->blk[$blvl]['border_bottom']['w']);
			$brbgBR_H = max(0, $brBR_H - $this->blk[$blvl]['border_right']['w']);
			$brbgBR_V = max(0, $brBR_V - $this->blk[$blvl]['border_bottom']['w']);
			$bgx0 += $this->blk[$blvl]['border_left']['w'];
			$bgx1 -= $this->blk[$blvl]['border_right']['w'];
			if ($this->blk[$blvl]['border_top'] && $divider != 'pagetop' && !$continuingpage) {
				$bgy0 += $this->blk[$blvl]['border_top']['w'];
			}
			if ($this->blk[$blvl]['border_bottom'] && $blockstate != 1 && $divider != 'pagebottom') {
				$bgy1 -= $this->blk[$blvl]['border_bottom']['w'];
			}
		} elseif (isset($this->blk[$blvl]['background_clip']) && $this->blk[$blvl]['background_clip'] == 'content-box') {
			$brbgTL_H = max(0, $brTL_H - $this->blk[$blvl]['border_left']['w'] - $this->blk[$blvl]['padding_left']);
			$brbgTL_V = max(0, $brTL_V - $this->blk[$blvl]['border_top']['w'] - $this->blk[$blvl]['padding_top']);
			$brbgTR_H = max(0, $brTR_H - $this->blk[$blvl]['border_right']['w'] - $this->blk[$blvl]['padding_right']);
			$brbgTR_V = max(0, $brTR_V - $this->blk[$blvl]['border_top']['w'] - $this->blk[$blvl]['padding_top']);
			$brbgBL_H = max(0, $brBL_H - $this->blk[$blvl]['border_left']['w'] - $this->blk[$blvl]['padding_left']);
			$brbgBL_V = max(0, $brBL_V - $this->blk[$blvl]['border_bottom']['w'] - $this->blk[$blvl]['padding_bottom']);
			$brbgBR_H = max(0, $brBR_H - $this->blk[$blvl]['border_right']['w'] - $this->blk[$blvl]['padding_right']);
			$brbgBR_V = max(0, $brBR_V - $this->blk[$blvl]['border_bottom']['w'] - $this->blk[$blvl]['padding_bottom']);
			$bgx0 += $this->blk[$blvl]['border_left']['w'] + $this->blk[$blvl]['padding_left'];
			$bgx1 -= $this->blk[$blvl]['border_right']['w'] + $this->blk[$blvl]['padding_right'];
			if (($this->blk[$blvl]['border_top']['w'] || $this->blk[$blvl]['padding_top']) && $divider != 'pagetop' && !$continuingpage) {
				$bgy0 += $this->blk[$blvl]['border_top']['w'] + $this->blk[$blvl]['padding_top'];
			}
			if (($this->blk[$blvl]['border_bottom']['w'] || $this->blk[$blvl]['padding_bottom']) && $blockstate != 1 && $divider != 'pagebottom') {
				$bgy1 -= $this->blk[$blvl]['border_bottom']['w'] + $this->blk[$blvl]['padding_bottom'];
			}
		} else {
			$brbgTL_H = $brTL_H;
			$brbgTL_V = $brTL_V;
			$brbgTR_H = $brTR_H;
			$brbgTR_V = $brTR_V;
			$brbgBL_H = $brBL_H;
			$brbgBL_V = $brBL_V;
			$brbgBR_H = $brBR_H;
			$brbgBR_V = $brBR_V;
		}

		// Set clipping path
		$s = ' q 0 w '; // Line width=0
		$s .= sprintf('%.3F %.3F m ', ($bgx0 + $brbgTL_H ) * _MPDFK, ($this->h - $bgy0) * _MPDFK); // start point TL before the arc
		/* -- BORDER-RADIUS -- */
		if ($brbgTL_H || $brbgTL_V) {
			$s .= $this->_EllipseArc($bgx0 + $brbgTL_H, $bgy0 + $brbgTL_V, $brbgTL_H, $brbgTL_V, 2); // segment 2 TL
		}
		/* -- END BORDER-RADIUS -- */
		$s .= sprintf('%.3F %.3F l ', ($bgx0) * _MPDFK, ($this->h - ($bgy1 - $brbgBL_V )) * _MPDFK); // line to BL
		/* -- BORDER-RADIUS -- */
		if ($brbgBL_H || $brbgBL_V) {
			$s .= $this->_EllipseArc($bgx0 + $brbgBL_H, $bgy1 - $brbgBL_V, $brbgBL_H, $brbgBL_V, 3); // segment 3 BL
		}
		/* -- END BORDER-RADIUS -- */
		$s .= sprintf('%.3F %.3F l ', ($bgx1 - $brbgBR_H ) * _MPDFK, ($this->h - ($bgy1)) * _MPDFK); // line to BR
		/* -- BORDER-RADIUS -- */
		if ($brbgBR_H || $brbgBR_V) {
			$s .= $this->_EllipseArc($bgx1 - $brbgBR_H, $bgy1 - $brbgBR_V, $brbgBR_H, $brbgBR_V, 4); // segment 4 BR
		}
		/* -- END BORDER-RADIUS -- */
		$s .= sprintf('%.3F %.3F l ', ($bgx1) * _MPDFK, ($this->h - ($bgy0 + $brbgTR_V)) * _MPDFK); // line to TR
		/* -- BORDER-RADIUS -- */
		if ($brbgTR_H || $brbgTR_V) {
			$s .= $this->_EllipseArc($bgx1 - $brbgTR_H, $bgy0 + $brbgTR_V, $brbgTR_H, $brbgTR_V, 1); // segment 1 TR
		}
		/* -- END BORDER-RADIUS -- */
		$s .= sprintf('%.3F %.3F l ', ($bgx0 + $brbgTL_H ) * _MPDFK, ($this->h - $bgy0) * _MPDFK); // line to TL
		// Box Shadow
		$shadow = '';
		if (isset($this->blk[$blvl]['box_shadow']) && $this->blk[$blvl]['box_shadow'] && $h > 0) {
			foreach ($this->blk[$blvl]['box_shadow'] AS $sh) {
				// Colors
				if ($sh['col']{0} == 1) {
					$colspace = 'Gray';
					if ($sh['col']{2} == 1) {
						$col1 = '1' . $sh['col'][1] . '1' . $sh['col'][3];
					} else {
						$col1 = '1' . $sh['col'][1] . '1' . chr(100);
					}
					$col2 = '1' . $sh['col'][1] . '1' . chr(0);
				} elseif ($sh['col']{0} == 4) { // CMYK
					$colspace = 'CMYK';
					$col1 = '6' . $sh['col'][1] . $sh['col'][2] . $sh['col'][3] . $sh['col'][4] . chr(100);
					$col2 = '6' . $sh['col'][1] . $sh['col'][2] . $sh['col'][3] . $sh['col'][4] . chr(0);
				} elseif ($sh['col']{0} == 5) { // RGBa
					$colspace = 'RGB';
					$col1 = '5' . $sh['col'][1] . $sh['col'][2] . $sh['col'][3] . $sh['col'][4];
					$col2 = '5' . $sh['col'][1] . $sh['col'][2] . $sh['col'][3] . chr(0);
				} elseif ($sh['col']{0} == 6) { // CMYKa
					$colspace = 'CMYK';
					$col1 = '6' . $sh['col'][1] . $sh['col'][2] . $sh['col'][3] . $sh['col'][4] . $sh['col'][5];
					$col2 = '6' . $sh['col'][1] . $sh['col'][2] . $sh['col'][3] . $sh['col'][4] . chr(0);
				} else {
					$colspace = 'RGB';
					$col1 = '5' . $sh['col'][1] . $sh['col'][2] . $sh['col'][3] . chr(100);
					$col2 = '5' . $sh['col'][1] . $sh['col'][2] . $sh['col'][3] . chr(0);
				}

				// Use clipping path as set above (and rectangle around page) to clip area outside box
				$shadow .= $s; // Use the clipping path with W*
				$shadow .= sprintf('0 %.3F m %.3F %.3F l ', $this->h * _MPDFK, $this->w * _MPDFK, $this->h * _MPDFK);
				$shadow .= sprintf('%.3F 0 l 0 0 l 0 %.3F l ', $this->w * _MPDFK, $this->h * _MPDFK);
				$shadow .= 'W n' . "\n";

				$sh['blur'] = abs($sh['blur']); // cannot have negative blur value
				// Ensure spread/blur do not make effective shadow width/height < 0
				// Could do more complex things but this just adjusts spread value
				if (-$sh['spread'] + $sh['blur'] / 2 > min($w / 2, $h / 2)) {
					$sh['spread'] = $sh['blur'] / 2 - min($w / 2, $h / 2) + 0.01;
				}
				// Shadow Offset
				if ($sh['x'] || $sh['y'])
					$shadow .= sprintf(' q 1 0 0 1 %.4F %.4F cm', $sh['x'] * _MPDFK, -$sh['y'] * _MPDFK) . "\n";

				// Set path for INNER shadow
				$shadow .= ' q 0 w ';
				$shadow .= $this->SetFColor($col1, true) . "\n";
				if ($col1{0} == 5 && ord($col1{4}) < 100) { // RGBa
					$shadow .= $this->SetAlpha(ord($col1{4}) / 100, 'Normal', true, 'F') . "\n";
				} elseif ($col1{0} == 6 && ord($col1{5}) < 100) { // CMYKa
					$shadow .= $this->SetAlpha(ord($col1{5}) / 100, 'Normal', true, 'F') . "\n";
				} elseif ($col1{0} == 1 && $col1{2} == 1 && ord($col1{3}) < 100) { // Gray
					$shadow .= $this->SetAlpha(ord($col1{3}) / 100, 'Normal', true, 'F') . "\n";
				}

				// Blur edges
				$mag = 0.551784; // Bezier Control magic number for 4-part spline for circle/ellipse
				$mag2 = 0.551784; // Bezier Control magic number to fill in edge of blurred rectangle
				$d1 = $sh['spread'] + $sh['blur'] / 2;
				$d2 = $sh['spread'] - $sh['blur'] / 2;
				$bl = $sh['blur'];
				$x00 = $x0 - $d1;
				$y00 = $y0 - $d1;
				$w00 = $w + $d1 * 2;
				$h00 = $h + $d1 * 2;

				// If any border-radius is greater width-negative spread(inner edge), ignore radii for shadow or screws up
				$flatten = false;
				if (max($brbgTR_H, $brbgTL_H, $brbgBR_H, $brbgBL_H) >= $w + $d2) {
					$flatten = true;
				}
				if (max($brbgTR_V, $brbgTL_V, $brbgBR_V, $brbgBL_V) >= $h + $d2) {
					$flatten = true;
				}


				// TOP RIGHT corner
				$p1x = $x00 + $w00 - $d1 - $brbgTR_H;
				$p1c2x = $p1x + ($d2 + $brbgTR_H) * $mag;
				$p1y = $y00 + $bl;
				$p2x = $x00 + $w00 - $d1 - $brbgTR_H;
				$p2c2x = $p2x + ($d1 + $brbgTR_H) * $mag;
				$p2y = $y00;
				$p2c1y = $p2y + $bl / 2;
				$p3x = $x00 + $w00;
				$p3c2x = $p3x - $bl / 2;
				$p3y = $y00 + $d1 + $brbgTR_V;
				$p3c1y = $p3y - ($d1 + $brbgTR_V) * $mag;
				$p4x = $x00 + $w00 - $bl;
				$p4y = $y00 + $d1 + $brbgTR_V;
				$p4c2y = $p4y - ($d2 + $brbgTR_V) * $mag;
				if (-$d2 > min($brbgTR_H, $brbgTR_V) || $flatten) {
					$p1x = $x00 + $w00 - $bl;
					$p1c2x = $p1x;
					$p2x = $x00 + $w00 - $bl;
					$p2c2x = $p2x + $bl * $mag2;
					$p3y = $y00 + $bl;
					$p3c1y = $p3y - $bl * $mag2;
					$p4y = $y00 + $bl;
					$p4c2y = $p4y;
				}

				$shadow .= sprintf('%.3F %.3F m ', ($p1x ) * _MPDFK, ($this->h - ($p1y )) * _MPDFK);
				$shadow .= sprintf('%.3F %.3F %.3F %.3F %.3F %.3F c ', ($p1c2x) * _MPDFK, ($this->h - ($p1y)) * _MPDFK, ($p4x) * _MPDFK, ($this->h - ($p4c2y)) * _MPDFK, ($p4x) * _MPDFK, ($this->h - ($p4y)) * _MPDFK);
				$patch_array[0]['f'] = 0;
				$patch_array[0]['points'] = array($p1x, $p1y, $p1x, $p1y,
					$p2x, $p2c1y, $p2x, $p2y, $p2c2x, $p2y,
					$p3x, $p3c1y, $p3x, $p3y, $p3c2x, $p3y,
					$p4x, $p4y, $p4x, $p4y, $p4x, $p4c2y,
					$p1c2x, $p1y);
				$patch_array[0]['colors'] = array($col1, $col2, $col2, $col1);


				// RIGHT
				$p1x = $x00 + $w00; // control point only matches p3 preceding
				$p1y = $y00 + $d1 + $brbgTR_V;
				$p2x = $x00 + $w00 - $bl; // control point only matches p4 preceding
				$p2y = $y00 + $d1 + $brbgTR_V;
				$p3x = $x00 + $w00 - $bl;
				$p3y = $y00 + $h00 - $d1 - $brbgBR_V;
				$p4x = $x00 + $w00;
				$p4c1x = $p4x - $bl / 2;
				$p4y = $y00 + $h00 - $d1 - $brbgBR_V;
				if (-$d2 > min($brbgTR_H, $brbgTR_V) || $flatten) {
					$p1y = $y00 + $bl;
					$p2y = $y00 + $bl;
				}
				if (-$d2 > min($brbgBR_H, $brbgBR_V) || $flatten) {
					$p3y = $y00 + $h00 - $bl;
					$p4y = $y00 + $h00 - $bl;
				}

				$shadow .= sprintf('%.3F %.3F l ', ($p3x ) * _MPDFK, ($this->h - ($p3y )) * _MPDFK);
				$patch_array[1]['f'] = 2;
				$patch_array[1]['points'] = array($p2x, $p2y,
					$p3x, $p3y, $p3x, $p3y, $p3x, $p3y,
					$p4c1x, $p4y, $p4x, $p4y, $p4x, $p4y,
					$p1x, $p1y);
				$patch_array[1]['colors'] = array($col1, $col2);


				// BOTTOM RIGHT corner
				$p1x = $x00 + $w00 - $bl;  // control points only matches p3 preceding
				$p1y = $y00 + $h00 - $d1 - $brbgBR_V;
				$p1c2y = $p1y + ($d2 + $brbgBR_V) * $mag;
				$p2x = $x00 + $w00;     // control point only matches p4 preceding
				$p2y = $y00 + $h00 - $d1 - $brbgBR_V;
				$p2c2y = $p2y + ($d1 + $brbgBR_V) * $mag;
				$p3x = $x00 + $w00 - $d1 - $brbgBR_H;
				$p3c1x = $p3x + ($d1 + $brbgBR_H) * $mag;
				$p3y = $y00 + $h00;
				$p3c2y = $p3y - $bl / 2;
				$p4x = $x00 + $w00 - $d1 - $brbgBR_H;
				$p4c2x = $p4x + ($d2 + $brbgBR_H) * $mag;
				$p4y = $y00 + $h00 - $bl;

				if (-$d2 > min($brbgBR_H, $brbgBR_V) || $flatten) {
					$p1y = $y00 + $h00 - $bl;
					$p1c2y = $p1y;
					$p2y = $y00 + $h00 - $bl;
					$p2c2y = $p2y + $bl * $mag2;
					$p3x = $x00 + $w00 - $bl;
					$p3c1x = $p3x + $bl * $mag2;
					$p4x = $x00 + $w00 - $bl;
					$p4c2x = $p4x;
				}

				$shadow .= sprintf('%.3F %.3F %.3F %.3F %.3F %.3F c ', ($p1x) * _MPDFK, ($this->h - ($p1c2y)) * _MPDFK, ($p4c2x) * _MPDFK, ($this->h - ($p4y)) * _MPDFK, ($p4x) * _MPDFK, ($this->h - ($p4y)) * _MPDFK);
				$patch_array[2]['f'] = 2;
				$patch_array[2]['points'] = array($p2x, $p2c2y,
					$p3c1x, $p3y, $p3x, $p3y, $p3x, $p3c2y,
					$p4x, $p4y, $p4x, $p4y, $p4c2x, $p4y,
					$p1x, $p1c2y);
				$patch_array[2]['colors'] = array($col2, $col1);



				// BOTTOM
				$p1x = $x00 + $w00 - $d1 - $brbgBR_H; // control point only matches p3 preceding
				$p1y = $y00 + $h00;
				$p2x = $x00 + $w00 - $d1 - $brbgBR_H; // control point only matches p4 preceding
				$p2y = $y00 + $h00 - $bl;
				$p3x = $x00 + $d1 + $brbgBL_H;
				$p3y = $y00 + $h00 - $bl;
				$p4x = $x00 + $d1 + $brbgBL_H;
				$p4y = $y00 + $h00;
				$p4c1y = $p4y - $bl / 2;

				if (-$d2 > min($brbgBR_H, $brbgBR_V) || $flatten) {
					$p1x = $x00 + $w00 - $bl;
					$p2x = $x00 + $w00 - $bl;
				}
				if (-$d2 > min($brbgBL_H, $brbgBL_V) || $flatten) {
					$p3x = $x00 + $bl;
					$p4x = $x00 + $bl;
				}

				$shadow .= sprintf('%.3F %.3F l ', ($p3x ) * _MPDFK, ($this->h - ($p3y )) * _MPDFK);
				$patch_array[3]['f'] = 2;
				$patch_array[3]['points'] = array($p2x, $p2y,
					$p3x, $p3y, $p3x, $p3y, $p3x, $p3y,
					$p4x, $p4c1y, $p4x, $p4y, $p4x, $p4y,
					$p1x, $p1y);
				$patch_array[3]['colors'] = array($col1, $col2);

				// BOTTOM LEFT corner
				$p1x = $x00 + $d1 + $brbgBL_H;
				$p1c2x = $p1x - ($d2 + $brbgBL_H) * $mag; // control points only matches p3 preceding
				$p1y = $y00 + $h00 - $bl;
				$p2x = $x00 + $d1 + $brbgBL_H;
				$p2c2x = $p2x - ($d1 + $brbgBL_H) * $mag; // control point only matches p4 preceding
				$p2y = $y00 + $h00;
				$p3x = $x00;
				$p3c2x = $p3x + $bl / 2;
				$p3y = $y00 + $h00 - $d1 - $brbgBL_V;
				$p3c1y = $p3y + ($d1 + $brbgBL_V) * $mag;
				$p4x = $x00 + $bl;
				$p4y = $y00 + $h00 - $d1 - $brbgBL_V;
				$p4c2y = $p4y + ($d2 + $brbgBL_V) * $mag;
				if (-$d2 > min($brbgBL_H, $brbgBL_V) || $flatten) {
					$p1x = $x00 + $bl;
					$p1c2x = $p1x;
					$p2x = $x00 + $bl;
					$p2c2x = $p2x - $bl * $mag2;
					$p3y = $y00 + $h00 - $bl;
					$p3c1y = $p3y + $bl * $mag2;
					$p4y = $y00 + $h00 - $bl;
					$p4c2y = $p4y;
				}

				$shadow .= sprintf('%.3F %.3F %.3F %.3F %.3F %.3F c ', ($p1c2x) * _MPDFK, ($this->h - ($p1y)) * _MPDFK, ($p4x) * _MPDFK, ($this->h - ($p4c2y)) * _MPDFK, ($p4x) * _MPDFK, ($this->h - ($p4y)) * _MPDFK);
				$patch_array[4]['f'] = 2;
				$patch_array[4]['points'] = array($p2c2x, $p2y,
					$p3x, $p3c1y, $p3x, $p3y, $p3c2x, $p3y,
					$p4x, $p4y, $p4x, $p4y, $p4x, $p4c2y,
					$p1c2x, $p1y);
				$patch_array[4]['colors'] = array($col2, $col1);


				// LEFT - joins on the right (C3-C4 of previous): f = 2
				$p1x = $x00; // control point only matches p3 preceding
				$p1y = $y00 + $h00 - $d1 - $brbgBL_V;
				$p2x = $x00 + $bl; // control point only matches p4 preceding
				$p2y = $y00 + $h00 - $d1 - $brbgBL_V;
				$p3x = $x00 + $bl;
				$p3y = $y00 + $d1 + $brbgTL_V;
				$p4x = $x00;
				$p4c1x = $p4x + $bl / 2;
				$p4y = $y00 + $d1 + $brbgTL_V;
				if (-$d2 > min($brbgBL_H, $brbgBL_V) || $flatten) {
					$p1y = $y00 + $h00 - $bl;
					$p2y = $y00 + $h00 - $bl;
				}
				if (-$d2 > min($brbgTL_H, $brbgTL_V) || $flatten) {
					$p3y = $y00 + $bl;
					$p4y = $y00 + $bl;
				}

				$shadow .= sprintf('%.3F %.3F l ', ($p3x ) * _MPDFK, ($this->h - ($p3y )) * _MPDFK);
				$patch_array[5]['f'] = 2;
				$patch_array[5]['points'] = array($p2x, $p2y,
					$p3x, $p3y, $p3x, $p3y, $p3x, $p3y,
					$p4c1x, $p4y, $p4x, $p4y, $p4x, $p4y,
					$p1x, $p1y);
				$patch_array[5]['colors'] = array($col1, $col2);

				// TOP LEFT corner
				$p1x = $x00 + $bl;  // control points only matches p3 preceding
				$p1y = $y00 + $d1 + $brbgTL_V;
				$p1c2y = $p1y - ($d2 + $brbgTL_V) * $mag;
				$p2x = $x00;   // control point only matches p4 preceding
				$p2y = $y00 + $d1 + $brbgTL_V;
				$p2c2y = $p2y - ($d1 + $brbgTL_V) * $mag;
				$p3x = $x00 + $d1 + $brbgTL_H;
				$p3c1x = $p3x - ($d1 + $brbgTL_H) * $mag;
				$p3y = $y00;
				$p3c2y = $p3y + $bl / 2;
				$p4x = $x00 + $d1 + $brbgTL_H;
				$p4c2x = $p4x - ($d2 + $brbgTL_H) * $mag;
				$p4y = $y00 + $bl;

				if (-$d2 > min($brbgTL_H, $brbgTL_V) || $flatten) {
					$p1y = $y00 + $bl;
					$p1c2y = $p1y;
					$p2y = $y00 + $bl;
					$p2c2y = $p2y - $bl * $mag2;
					$p3x = $x00 + $bl;
					$p3c1x = $p3x - $bl * $mag2;
					$p4x = $x00 + $bl;
					$p4c2x = $p4x;
				}

				$shadow .= sprintf('%.3F %.3F %.3F %.3F %.3F %.3F c ', ($p1x) * _MPDFK, ($this->h - ($p1c2y)) * _MPDFK, ($p4c2x) * _MPDFK, ($this->h - ($p4y)) * _MPDFK, ($p4x) * _MPDFK, ($this->h - ($p4y)) * _MPDFK);
				$patch_array[6]['f'] = 2;
				$patch_array[6]['points'] = array($p2x, $p2c2y,
					$p3c1x, $p3y, $p3x, $p3y, $p3x, $p3c2y,
					$p4x, $p4y, $p4x, $p4y, $p4c2x, $p4y,
					$p1x, $p1c2y);
				$patch_array[6]['colors'] = array($col2, $col1);


				// TOP - joins on the right (C3-C4 of previous): f = 2
				$p1x = $x00 + $d1 + $brbgTL_H; // control point only matches p3 preceding
				$p1y = $y00;
				$p2x = $x00 + $d1 + $brbgTL_H; // control point only matches p4 preceding
				$p2y = $y00 + $bl;
				$p3x = $x00 + $w00 - $d1 - $brbgTR_H;
				$p3y = $y00 + $bl;
				$p4x = $x00 + $w00 - $d1 - $brbgTR_H;
				$p4y = $y00;
				$p4c1y = $p4y + $bl / 2;
				if (-$d2 > min($brbgTL_H, $brbgTL_V) || $flatten) {
					$p1x = $x00 + $bl;
					$p2x = $x00 + $bl;
				}
				if (-$d2 > min($brbgTR_H, $brbgTR_V) || $flatten) {
					$p3x = $x00 + $w00 - $bl;
					$p4x = $x00 + $w00 - $bl;
				}

				$shadow .= sprintf('%.3F %.3F l ', ($p3x ) * _MPDFK, ($this->h - ($p3y )) * _MPDFK);
				$patch_array[7]['f'] = 2;
				$patch_array[7]['points'] = array($p2x, $p2y,
					$p3x, $p3y, $p3x, $p3y, $p3x, $p3y,
					$p4x, $p4c1y, $p4x, $p4y, $p4x, $p4y,
					$p1x, $p1y);
				$patch_array[7]['colors'] = array($col1, $col2);

				$shadow .= ' h f Q ' . "\n"; // Close path and Fill the inner solid shadow

				if ($bl)
					$shadow .= $this->grad->CoonsPatchMesh($x00, $y00, $w00, $h00, $patch_array, $x00, $x00 + $w00, $y00, $y00 + $h00, $colspace, true);

				if ($sh['x'] || $sh['y'])
					$shadow .= ' Q' . "\n";  // Shadow Offset
				$shadow .= ' Q' . "\n"; // Ends path no-op & Sets the clipping path
			}
		}

		$s .= ' W n '; // Ends path no-op & Sets the clipping path

		if ($this->blk[$blvl]['bgcolor']) {
			$this->pageBackgrounds[$blvl][] = array('x' => $x0, 'y' => $y0, 'w' => $w, 'h' => $h, 'col' => $this->blk[$blvl]['bgcolorarray'], 'clippath' => $s, 'visibility' => $this->visibility, 'shadow' => $shadow, 'z-index' => $this->current_layer);
		} elseif ($shadow) {
			$this->pageBackgrounds[$blvl][] = array('shadowonly' => true, 'col' => '', 'clippath' => '', 'visibility' => $this->visibility, 'shadow' => $shadow, 'z-index' => $this->current_layer);
		}

		/* -- BACKGROUNDS -- */
		if (isset($this->blk[$blvl]['gradient'])) {
			$g = $this->grad->parseBackgroundGradient($this->blk[$blvl]['gradient']);
			if ($g) {
				$gx = $x0;
				$gy = $y0;
				$this->pageBackgrounds[$blvl][] = array('gradient' => true, 'x' => $gx, 'y' => $gy, 'w' => $w, 'h' => $h, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => $s, 'visibility' => $this->visibility, 'z-index' => $this->current_layer);
			}
		}
		if (isset($this->blk[$blvl]['background-image'])) {
			if (isset($this->blk[$blvl]['background-image']['gradient']) && $this->blk[$blvl]['background-image']['gradient'] && preg_match('/(-moz-)*(repeating-)*(linear|radial)-gradient/', $this->blk[$blvl]['background-image']['gradient'])) {
				$g = $this->grad->parseMozGradient($this->blk[$blvl]['background-image']['gradient']);
				if ($g) {
					$gx = $x0;
					$gy = $y0;
					// origin specifies the background-positioning-area (bpa)
					if ($this->blk[$blvl]['background-image']['origin'] == 'padding-box') {
						$gx += $this->blk[$blvl]['border_left']['w'];
						$w -= ($this->blk[$blvl]['border_left']['w'] + $this->blk[$blvl]['border_right']['w']);
						if ($this->blk[$blvl]['border_top'] && $divider != 'pagetop' && !$continuingpage) {
							$gy += $this->blk[$blvl]['border_top']['w'];
						}
						if ($this->blk[$blvl]['border_bottom'] && $blockstate != 1 && $divider != 'pagebottom') {
							$gy1 = $y1 - $this->blk[$blvl]['border_bottom']['w'];
						} else {
							$gy1 = $y1;
						}
						$h = $gy1 - $gy;
					} elseif ($this->blk[$blvl]['background-image']['origin'] == 'content-box') {
						$gx += $this->blk[$blvl]['border_left']['w'] + $this->blk[$blvl]['padding_left'];
						$w -= ($this->blk[$blvl]['border_left']['w'] + $this->blk[$blvl]['padding_left'] + $this->blk[$blvl]['border_right']['w'] + $this->blk[$blvl]['padding_right']);
						if ($this->blk[$blvl]['border_top'] && $divider != 'pagetop' && !$continuingpage) {
							$gy += $this->blk[$blvl]['border_top']['w'] + $this->blk[$blvl]['padding_top'];
						}
						if ($this->blk[$blvl]['border_bottom'] && $blockstate != 1 && $divider != 'pagebottom') {
							$gy1 = $y1 - ($this->blk[$blvl]['border_bottom']['w'] + $this->blk[$blvl]['padding_bottom']);
						} else {
							$gy1 = $y1 - $this->blk[$blvl]['padding_bottom'];
						}
						$h = $gy1 - $gy;
					}

					if (isset($this->blk[$blvl]['background-image']['size']['w']) && $this->blk[$blvl]['background-image']['size']['w']) {
						$size = $this->blk[$blvl]['background-image']['size'];
						if ($size['w'] != 'contain' && $size['w'] != 'cover') {
							if (stristr($size['w'], '%')) {
								$size['w'] += 0;
								$size['w'] /= 100;
								$w *= $size['w'];
							} elseif ($size['w'] != 'auto') {
								$w = $size['w'];
							}
							if (stristr($size['h'], '%')) {
								$size['h'] += 0;
								$size['h'] /= 100;
								$h *= $size['h'];
							} elseif ($size['h'] != 'auto') {
								$h = $size['h'];
							}
						}
					}
					$this->pageBackgrounds[$blvl][] = array('gradient' => true, 'x' => $gx, 'y' => $gy, 'w' => $w, 'h' => $h, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => $s, 'visibility' => $this->visibility, 'z-index' => $this->current_layer);
				}
			} else {
				$image_id = $this->blk[$blvl]['background-image']['image_id'];
				$orig_w = $this->blk[$blvl]['background-image']['orig_w'];
				$orig_h = $this->blk[$blvl]['background-image']['orig_h'];
				$x_pos = $this->blk[$blvl]['background-image']['x_pos'];
				$y_pos = $this->blk[$blvl]['background-image']['y_pos'];
				$x_repeat = $this->blk[$blvl]['background-image']['x_repeat'];
				$y_repeat = $this->blk[$blvl]['background-image']['y_repeat'];
				$resize = $this->blk[$blvl]['background-image']['resize'];
				$opacity = $this->blk[$blvl]['background-image']['opacity'];
				$itype = $this->blk[$blvl]['background-image']['itype'];
				$size = $this->blk[$blvl]['background-image']['size'];
				// origin specifies the background-positioning-area (bpa)
				$bpa = array('x' => $x0, 'y' => $y0, 'w' => $w, 'h' => $h);
				if ($this->blk[$blvl]['background-image']['origin'] == 'padding-box') {
					$bpa['x'] = $x0 + $this->blk[$blvl]['border_left']['w'];
					$bpa['w'] = $w - ($this->blk[$blvl]['border_left']['w'] + $this->blk[$blvl]['border_right']['w']);
					if ($this->blk[$blvl]['border_top'] && $divider != 'pagetop' && !$continuingpage) {
						$bpa['y'] = $y0 + $this->blk[$blvl]['border_top']['w'];
					} else {
						$bpa['y'] = $y0;
					}
					if ($this->blk[$blvl]['border_bottom'] && $blockstate != 1 && $divider != 'pagebottom') {
						$bpay = $y1 - $this->blk[$blvl]['border_bottom']['w'];
					} else {
						$bpay = $y1;
					}
					$bpa['h'] = $bpay - $bpa['y'];
				} elseif ($this->blk[$blvl]['background-image']['origin'] == 'content-box') {
					$bpa['x'] = $x0 + $this->blk[$blvl]['border_left']['w'] + $this->blk[$blvl]['padding_left'];
					$bpa['w'] = $w - ($this->blk[$blvl]['border_left']['w'] + $this->blk[$blvl]['padding_left'] + $this->blk[$blvl]['border_right']['w'] + $this->blk[$blvl]['padding_right']);
					if ($this->blk[$blvl]['border_top'] && $divider != 'pagetop' && !$continuingpage) {
						$bpa['y'] = $y0 + $this->blk[$blvl]['border_top']['w'] + $this->blk[$blvl]['padding_top'];
					} else {
						$bpa['y'] = $y0 + $this->blk[$blvl]['padding_top'];
					}
					if ($this->blk[$blvl]['border_bottom'] && $blockstate != 1 && $divider != 'pagebottom') {
						$bpay = $y1 - ($this->blk[$blvl]['border_bottom']['w'] + $this->blk[$blvl]['padding_bottom']);
					} else {
						$bpay = $y1 - $this->blk[$blvl]['padding_bottom'];
					}
					$bpa['h'] = $bpay - $bpa['y'];
				}
				$this->pageBackgrounds[$blvl][] = array('x' => $x0, 'y' => $y0, 'w' => $w, 'h' => $h, 'image_id' => $image_id, 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $x_pos, 'y_pos' => $y_pos, 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'clippath' => $s, 'resize' => $resize, 'opacity' => $opacity, 'itype' => $itype, 'visibility' => $this->visibility, 'z-index' => $this->current_layer, 'size' => $size, 'bpa' => $bpa);
			}
		}
		/* -- END BACKGROUNDS -- */

		// Float DIV
		$this->blk[$blvl]['bb_painted'][$this->page] = true;
	}

	/* -- BORDER-RADIUS -- */

	function _EllipseArc($x0, $y0, $rx, $ry, $seg = 1, $part = false, $start = false)
	{ // Anticlockwise segment 1-4 TR-TL-BL-BR (part=1 or 2)
		$s = '';
		if ($rx < 0) {
			$rx = 0;
		}
		if ($ry < 0) {
			$ry = 0;
		}
		$rx *= _MPDFK;
		$ry *= _MPDFK;
		$astart = 0;
		if ($seg == 1) { // Top Right
			$afinish = 90;
			$nSeg = 4;
		} elseif ($seg == 2) { // Top Left
			$afinish = 180;
			$nSeg = 8;
		} elseif ($seg == 3) { // Bottom Left
			$afinish = 270;
			$nSeg = 12;
		} else {   // Bottom Right
			$afinish = 360;
			$nSeg = 16;
		}
		$astart = deg2rad((float) $astart);
		$afinish = deg2rad((float) $afinish);
		$totalAngle = $afinish - $astart;
		$dt = $totalAngle / $nSeg; // segment angle
		$dtm = $dt / 3;
		$x0 *= _MPDFK;
		$y0 = ($this->h - $y0) * _MPDFK;
		$t1 = $astart;
		$a0 = $x0 + ($rx * cos($t1));
		$b0 = $y0 + ($ry * sin($t1));
		$c0 = -$rx * sin($t1);
		$d0 = $ry * cos($t1);
		$op = false;
		for ($i = 1; $i <= $nSeg; $i++) {
			// Draw this bit of the total curve
			$t1 = ($i * $dt) + $astart;
			$a1 = $x0 + ($rx * cos($t1));
			$b1 = $y0 + ($ry * sin($t1));
			$c1 = -$rx * sin($t1);
			$d1 = $ry * cos($t1);
			if ($i > ($nSeg - 4) && (!$part || ($part == 1 && $i <= $nSeg - 2) || ($part == 2 && $i > $nSeg - 2))) {
				if ($start && !$op) {
					$s .= sprintf('%.3F %.3F m ', $a0, $b0);
				}
				$s .= sprintf('%.3F %.3F %.3F %.3F %.3F %.3F c ', ($a0 + ($c0 * $dtm)), ($b0 + ($d0 * $dtm)), ($a1 - ($c1 * $dtm)), ($b1 - ($d1 * $dtm)), $a1, $b1);
				$op = true;
			}
			$a0 = $a1;
			$b0 = $b1;
			$c0 = $c1;
			$d0 = $d1;
		}
		return $s;
	}

	/* -- END BORDER-RADIUS -- */

	function PaintDivLnBorder($state = 0, $blvl = 0, $h)
	{
		// $state = 0 normal; 1 top; 2 bottom; 3 top and bottom
		$this->ColDetails[$this->CurrCol]['bottom_margin'] = $this->y + $h;

		$save_y = $this->y;

		$w = $this->blk[$blvl]['width'];
		$x0 = $this->x;    // left
		$y0 = $this->y;    // top
		$x1 = $this->x + $w;   // bottom
		$y1 = $this->y + $h;   // bottom

		if ($this->blk[$blvl]['border_top'] && ($state == 1 || $state == 3)) {
			$tbd = $this->blk[$blvl]['border_top'];
			if (isset($tbd['s']) && $tbd['s']) {
				$this->_setBorderLine($tbd);
				$this->y = $y0 + ($tbd['w'] / 2);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->_setDashBorder($tbd['style'], '', $continuingpage, 'T');
					$this->Line($x0 + ($tbd['w'] / 2), $this->y, $x0 + $w - ($tbd['w'] / 2), $this->y);
				} else {
					$this->SetLineJoin(0);
					$this->SetLineCap(0);
					$this->Line($x0, $this->y, $x0 + $w, $this->y);
				}
				$this->y += $tbd['w'];
				// Reset Corners and Dash off
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		if ($this->blk[$blvl]['border_left']) {
			$tbd = $this->blk[$blvl]['border_left'];
			if (isset($tbd['s']) && $tbd['s']) {
				$this->_setBorderLine($tbd);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->y = $y0 + ($tbd['w'] / 2);
					$this->_setDashBorder($tbd['style'], '', $continuingpage, 'L');
					$this->Line($x0 + ($tbd['w'] / 2), $this->y, $x0 + ($tbd['w'] / 2), $y0 + $h - ($tbd['w'] / 2));
				} else {
					$this->y = $y0;
					$this->SetLineJoin(0);
					$this->SetLineCap(0);
					$this->Line($x0 + ($tbd['w'] / 2), $this->y, $x0 + ($tbd['w'] / 2), $y0 + $h);
				}
				$this->y += $tbd['w'];
				// Reset Corners and Dash off
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		if ($this->blk[$blvl]['border_right']) {
			$tbd = $this->blk[$blvl]['border_right'];
			if (isset($tbd['s']) && $tbd['s']) {
				$this->_setBorderLine($tbd);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->y = $y0 + ($tbd['w'] / 2);
					$this->_setDashBorder($tbd['style'], '', $continuingpage, 'R');
					$this->Line($x0 + $w - ($tbd['w'] / 2), $this->y, $x0 + $w - ($tbd['w'] / 2), $y0 + $h - ($tbd['w'] / 2));
				} else {
					$this->y = $y0;
					$this->SetLineJoin(0);
					$this->SetLineCap(0);
					$this->Line($x0 + $w - ($tbd['w'] / 2), $this->y, $x0 + $w - ($tbd['w'] / 2), $y0 + $h);
				}
				$this->y += $tbd['w'];
				// Reset Corners and Dash off
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		if ($this->blk[$blvl]['border_bottom'] && $state > 1) {
			$tbd = $this->blk[$blvl]['border_bottom'];
			if (isset($tbd['s']) && $tbd['s']) {
				$this->_setBorderLine($tbd);
				$this->y = $y0 + $h - ($tbd['w'] / 2);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->_setDashBorder($tbd['style'], '', $continuingpage, 'B');
					$this->Line($x0 + ($tbd['w'] / 2), $this->y, $x0 + $w - ($tbd['w'] / 2), $this->y);
				} else {
					$this->SetLineJoin(0);
					$this->SetLineCap(0);
					$this->Line($x0, $this->y, $x0 + $w, $this->y);
				}
				$this->y += $tbd['w'];
				// Reset Corners and Dash off
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		$this->SetDash();
		$this->y = $save_y;
	}

	function PaintImgBorder($objattr, $is_table)
	{
		// Borders are disabled in columns - messes up the repositioning in printcolumnbuffer
		if ($this->ColActive) {
			return;
		} // *COLUMNS*
		if ($is_table) {
			$k = $this->shrin_k;
		} else {
			$k = 1;
		}
		$h = (isset($objattr['BORDER-HEIGHT']) ? $objattr['BORDER-HEIGHT'] : 0);
		$w = (isset($objattr['BORDER-WIDTH']) ? $objattr['BORDER-WIDTH'] : 0);
		$x0 = (isset($objattr['BORDER-X']) ? $objattr['BORDER-X'] : 0);
		$y0 = (isset($objattr['BORDER-Y']) ? $objattr['BORDER-Y'] : 0);

		// BORDERS
		if ($objattr['border_top']) {
			$tbd = $objattr['border_top'];
			if (!empty($tbd['s'])) {
				$this->_setBorderLine($tbd, $k);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->_setDashBorder($tbd['style'], '', '', 'T');
				}
				$this->Line($x0, $y0, $x0 + $w, $y0);
				// Reset Corners and Dash off
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		if ($objattr['border_left']) {
			$tbd = $objattr['border_left'];
			if (!empty($tbd['s'])) {
				$this->_setBorderLine($tbd, $k);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->_setDashBorder($tbd['style'], '', '', 'L');
				}
				$this->Line($x0, $y0, $x0, $y0 + $h);
				// Reset Corners and Dash off
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		if ($objattr['border_right']) {
			$tbd = $objattr['border_right'];
			if (!empty($tbd['s'])) {
				$this->_setBorderLine($tbd, $k);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->_setDashBorder($tbd['style'], '', '', 'R');
				}
				$this->Line($x0 + $w, $y0, $x0 + $w, $y0 + $h);
				// Reset Corners and Dash off
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		if ($objattr['border_bottom']) {
			$tbd = $objattr['border_bottom'];
			if (!empty($tbd['s'])) {
				$this->_setBorderLine($tbd, $k);
				if ($tbd['style'] == 'dotted' || $tbd['style'] == 'dashed') {
					$this->_setDashBorder($tbd['style'], '', '', 'B');
				}
				$this->Line($x0, $y0 + $h, $x0 + $w, $y0 + $h);
				// Reset Corners and Dash off
				$this->SetLineJoin(2);
				$this->SetLineCap(2);
				$this->SetDash();
			}
		}
		$this->SetDash();
		$this->SetAlpha(1);
	}

	/* -- END HTML-CSS -- */

	function Reset()
	{
		$this->SetTColor($this->ConvertColor(0));
		$this->SetDColor($this->ConvertColor(0));
		$this->SetFColor($this->ConvertColor(255));
		$this->SetAlpha(1);
		$this->colorarray = '';

		$this->spanbgcolorarray = '';
		$this->spanbgcolor = false;
		$this->spanborder = false;
		$this->spanborddet = array();

		$this->ResetStyles();

		$this->HREF = '';
		$this->textparam = array();
		$this->SetTextOutline();

		$this->textvar = 0x00; // mPDF 5.7.1
		$this->OTLtags = array();
		$this->textshadow = '';

		$this->currentLang = $this->default_lang;  // mPDF 6
		$this->RestrictUnicodeFonts($this->default_available_fonts); // mPDF 6
		$this->SetFont($this->default_font, '', 0, false);
		$this->SetFontSize($this->default_font_size, false);

		$this->currentfontfamily = '';
		$this->currentfontsize = '';
		$this->currentfontstyle = '';

		/* -- TABLES -- */
		if ($this->tableLevel && isset($this->table[1][1]['cellLineHeight'])) {
			$this->SetLineHeight('', $this->table[1][1]['cellLineHeight']); // *TABLES*
		} else
		/* -- END TABLES -- */
		if (isset($this->blk[$this->blklvl]['line_height']) && $this->blk[$this->blklvl]['line_height']) {
			$this->SetLineHeight('', $this->blk[$this->blklvl]['line_height']); // sets default line height
		}

		$this->lSpacingCSS = '';
		$this->wSpacingCSS = '';
		$this->fixedlSpacing = false;
		$this->minwSpacing = 0;
		$this->SetDash(); //restore to no dash
		$this->dash_on = false;
		$this->dotted_on = false;
		$this->divwidth = 0;
		$this->divheight = 0;
		$this->cellTextAlign = '';
		$this->cellLineHeight = '';
		$this->cellLineStackingStrategy = '';
		$this->cellLineStackingShift = '';
		$this->oldy = -1;

		$bodystyle = array();
		if (isset($this->cssmgr->CSS['BODY']['FONT-STYLE'])) {
			$bodystyle['FONT-STYLE'] = $this->cssmgr->CSS['BODY']['FONT-STYLE'];
		}
		if (isset($this->cssmgr->CSS['BODY']['FONT-WEIGHT'])) {
			$bodystyle['FONT-WEIGHT'] = $this->cssmgr->CSS['BODY']['FONT-WEIGHT'];
		}
		if (isset($this->cssmgr->CSS['BODY']['COLOR'])) {
			$bodystyle['COLOR'] = $this->cssmgr->CSS['BODY']['COLOR'];
		}
		if (isset($bodystyle)) {
			$this->setCSS($bodystyle, 'BLOCK', 'BODY');
		}
	}

	/* -- HTML-CSS -- */

	function ReadMetaTags($html)
	{
		// changes anykey=anyvalue to anykey="anyvalue" (only do this when this happens inside tags)
		$regexp = '/ (\\w+?)=([^\\s>"]+)/si';
		$html = preg_replace($regexp, " \$1=\"\$2\"", $html);
		if (preg_match('/<title>(.*?)<\/title>/si', $html, $m)) {
			$this->SetTitle($m[1]);
		}
		preg_match_all('/<meta [^>]*?(name|content)="([^>]*?)" [^>]*?(name|content)="([^>]*?)".*?>/si', $html, $aux);
		$firstattr = $aux[1];
		$secondattr = $aux[3];
		for ($i = 0; $i < count($aux[0]); $i++) {

			$name = ( strtoupper($firstattr[$i]) == "NAME" ) ? strtoupper($aux[2][$i]) : strtoupper($aux[4][$i]);
			$content = ( strtoupper($firstattr[$i]) == "CONTENT" ) ? $aux[2][$i] : $aux[4][$i];
			switch ($name) {
				case "KEYWORDS": $this->SetKeywords($content);
					break;
				case "AUTHOR": $this->SetAuthor($content);
					break;
				case "DESCRIPTION": $this->SetSubject($content);
					break;
			}
		}
	}

	function ReadCharset($html)
	{
		// Charset conversion
		if ($this->allow_charset_conversion) {
			if (preg_match('/<head.*charset=([^\'\"\s]*).*<\/head>/si', $html, $m)) {
				if (strtoupper($m[1]) != 'UTF-8') {
					$this->charset_in = strtoupper($m[1]);
				}
			}
		}
	}

	function setCSS($arrayaux, $type = '', $tag = '')
	{ // type= INLINE | BLOCK | TABLECELL // tag= BODY
		if (!is_array($arrayaux))
			return; //Removes PHP Warning

		// mPDF 5.7.3  inline text-decoration parameters
		$preceeding_fontkey = $this->FontFamily . $this->FontStyle;
		$preceeding_fontsize = $this->FontSize;
		$spanbordset = false;
		$spanbgset = false;
		// mPDF 6
		$prevlevel = (($this->blklvl == 0) ? 0 : $this->blklvl - 1);

		// Set font size first so that e.g. MARGIN 0.83em works on font size for this element
		if (isset($arrayaux['FONT-SIZE'])) {
			$v = $arrayaux['FONT-SIZE'];
			if (is_numeric($v[0])) {
				if ($type == 'BLOCK' && $this->blklvl > 0 && isset($this->blk[$this->blklvl - 1]['InlineProperties']) && isset($this->blk[$this->blklvl - 1]['InlineProperties']['size'])) {
					$mmsize = $this->ConvertSize($v, $this->blk[$this->blklvl - 1]['InlineProperties']['size']);
				} elseif ($type == 'TABLECELL') {
					$mmsize = $this->ConvertSize($v, $this->default_font_size / _MPDFK);
				} else {
					$mmsize = $this->ConvertSize($v, $this->FontSize);
				}
				$this->SetFontSize($mmsize * (_MPDFK), false); //Get size in points (pt)
			} else {
				$v = strtoupper($v);
				if (isset($this->fontsizes[$v])) {
					$this->SetFontSize($this->fontsizes[$v] * $this->default_font_size, false);
				}
			}
			if ($tag == 'BODY') {
				$this->SetDefaultFontSize($this->FontSizePt);
			}
		}

		// mPDF 6
		if (isset($arrayaux['LANG']) && $arrayaux['LANG']) {
			if ($this->autoLangToFont && !$this->usingCoreFont) {
				if ($arrayaux['LANG'] != $this->default_lang && $arrayaux['LANG'] != 'UTF-8') {
					list ($coreSuitable, $mpdf_pdf_unifont) = GetLangOpts($arrayaux['LANG'], $this->useAdobeCJK, $this->fontdata);
					if ($mpdf_pdf_unifont) {
						$arrayaux['FONT-FAMILY'] = $mpdf_pdf_unifont;
					}
					if ($tag == 'BODY') {
						$this->default_lang = $arrayaux['LANG'];
					}
				}
			}
			$this->currentLang = $arrayaux['LANG'];
		}

		// FOR INLINE and BLOCK OR 'BODY'
		if (isset($arrayaux['FONT-FAMILY'])) {
			$v = $arrayaux['FONT-FAMILY'];
			//If it is a font list, get all font types
			$aux_fontlist = explode(",", $v);
			$found = 0;
			foreach ($aux_fontlist AS $f) {
				$fonttype = trim($f);
				$fonttype = preg_replace('/["\']*(.*?)["\']*/', '\\1', $fonttype);
				$fonttype = preg_replace('/ /', '', $fonttype);
				$v = strtolower(trim($fonttype));
				if (isset($this->fonttrans[$v]) && $this->fonttrans[$v]) {
					$v = $this->fonttrans[$v];
				}
				if ((!$this->onlyCoreFonts && in_array($v, $this->available_unifonts)) ||
					in_array($v, array('ccourier', 'ctimes', 'chelvetica')) ||
					($this->onlyCoreFonts && in_array($v, array('courier', 'times', 'helvetica', 'arial'))) ||
					in_array($v, array('sjis', 'uhc', 'big5', 'gb'))) {
					$fonttype = $v;
					$found = 1;
					break;
				}
			}
			if (!$found) {
				foreach ($aux_fontlist AS $f) {
					$fonttype = trim($f);
					$fonttype = preg_replace('/["\']*(.*?)["\']*/', '\\1', $fonttype);
					$fonttype = preg_replace('/ /', '', $fonttype);
					$v = strtolower(trim($fonttype));
					if (isset($this->fonttrans[$v]) && $this->fonttrans[$v]) {
						$v = $this->fonttrans[$v];
					}
					if (in_array($v, $this->sans_fonts) || in_array($v, $this->serif_fonts) || in_array($v, $this->mono_fonts)) {
						$fonttype = $v;
						break;
					}
				}
			}

			if ($tag == 'BODY') {
				$this->SetDefaultFont($fonttype);
			}
			$this->SetFont($fonttype, $this->currentfontstyle, 0, false);
		} else {
			$this->SetFont($this->currentfontfamily, $this->currentfontstyle, 0, false);
		}

		foreach ($arrayaux as $k => $v) {
			if ($type != 'INLINE' && $tag != 'BODY' && $type != 'TABLECELL') {
				switch ($k) {
					// BORDERS
					case 'BORDER-TOP':
						$this->blk[$this->blklvl]['border_top'] = $this->border_details($v);
						if ($this->blk[$this->blklvl]['border_top']['s']) {
							$this->blk[$this->blklvl]['border'] = 1;
						}
						break;
					case 'BORDER-BOTTOM':
						$this->blk[$this->blklvl]['border_bottom'] = $this->border_details($v);
						if ($this->blk[$this->blklvl]['border_bottom']['s']) {
							$this->blk[$this->blklvl]['border'] = 1;
						}
						break;
					case 'BORDER-LEFT':
						$this->blk[$this->blklvl]['border_left'] = $this->border_details($v);
						if ($this->blk[$this->blklvl]['border_left']['s']) {
							$this->blk[$this->blklvl]['border'] = 1;
						}
						break;
					case 'BORDER-RIGHT':
						$this->blk[$this->blklvl]['border_right'] = $this->border_details($v);
						if ($this->blk[$this->blklvl]['border_right']['s']) {
							$this->blk[$this->blklvl]['border'] = 1;
						}
						break;

					// PADDING
					case 'PADDING-TOP':
						$this->blk[$this->blklvl]['padding_top'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'PADDING-BOTTOM':
						$this->blk[$this->blklvl]['padding_bottom'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'PADDING-LEFT':
						if (($tag == 'UL' || $tag == 'OL') && $v == 'auto') {
							$this->blk[$this->blklvl]['padding_left'] = 'auto';
							break;
						}
						$this->blk[$this->blklvl]['padding_left'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'PADDING-RIGHT':
						if (($tag == 'UL' || $tag == 'OL') && $v == 'auto') {
							$this->blk[$this->blklvl]['padding_right'] = 'auto';
							break;
						}
						$this->blk[$this->blklvl]['padding_right'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;

					// MARGINS
					case 'MARGIN-TOP':
						$tmp = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						if (isset($this->blk[$this->blklvl]['lastbottommargin'])) {
							if ($tmp > $this->blk[$this->blklvl]['lastbottommargin']) {
								$tmp -= $this->blk[$this->blklvl]['lastbottommargin'];
							} else {
								$tmp = 0;
							}
						}
						$this->blk[$this->blklvl]['margin_top'] = $tmp;
						break;
					case 'MARGIN-BOTTOM':
						$this->blk[$this->blklvl]['margin_bottom'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'MARGIN-LEFT':
						$this->blk[$this->blklvl]['margin_left'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'MARGIN-RIGHT':
						$this->blk[$this->blklvl]['margin_right'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;

					/* -- BORDER-RADIUS -- */
					case 'BORDER-TOP-LEFT-RADIUS-H':
						$this->blk[$this->blklvl]['border_radius_TL_H'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'BORDER-TOP-LEFT-RADIUS-V':
						$this->blk[$this->blklvl]['border_radius_TL_V'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'BORDER-TOP-RIGHT-RADIUS-H':
						$this->blk[$this->blklvl]['border_radius_TR_H'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'BORDER-TOP-RIGHT-RADIUS-V':
						$this->blk[$this->blklvl]['border_radius_TR_V'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'BORDER-BOTTOM-LEFT-RADIUS-H':
						$this->blk[$this->blklvl]['border_radius_BL_H'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'BORDER-BOTTOM-LEFT-RADIUS-V':
						$this->blk[$this->blklvl]['border_radius_BL_V'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'BORDER-BOTTOM-RIGHT-RADIUS-H':
						$this->blk[$this->blklvl]['border_radius_BR_H'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					case 'BORDER-BOTTOM-RIGHT-RADIUS-V':
						$this->blk[$this->blklvl]['border_radius_BR_V'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						break;
					/* -- END BORDER-RADIUS -- */

					case 'BOX-SHADOW':
						$bs = $this->cssmgr->setCSSboxshadow($v);
						if ($bs) {
							$this->blk[$this->blklvl]['box_shadow'] = $bs;
						}
						break;

					case 'BACKGROUND-CLIP':
						if (strtoupper($v) == 'PADDING-BOX') {
							$this->blk[$this->blklvl]['background_clip'] = 'padding-box';
						} elseif (strtoupper($v) == 'CONTENT-BOX') {
							$this->blk[$this->blklvl]['background_clip'] = 'content-box';
						}
						break;

					case 'PAGE-BREAK-AFTER':
						if (strtoupper($v) == 'AVOID') {
							$this->blk[$this->blklvl]['page_break_after_avoid'] = true;
						} elseif (strtoupper($v) == 'ALWAYS' || strtoupper($v) == 'LEFT' || strtoupper($v) == 'RIGHT') {
							$this->blk[$this->blklvl]['page_break_after'] = strtoupper($v);
						}
						break;

					// mPDF 6 pagebreaktype
					case 'BOX-DECORATION-BREAK':
						if (strtoupper($v) == 'CLONE') {
							$this->blk[$this->blklvl]['box_decoration_break'] = 'clone';
						} elseif (strtoupper($v) == 'SLICE') {
							$this->blk[$this->blklvl]['box_decoration_break'] = 'slice';
						}
						break;

					case 'WIDTH':
						if (strtoupper($v) != 'AUTO') {
							$this->blk[$this->blklvl]['css_set_width'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false);
						}
						break;

					// mPDF 6  Lists
					// LISTS
					case 'LIST-STYLE-TYPE':
						$this->blk[$this->blklvl]['list_style_type'] = strtolower($v);
						break;
					case 'LIST-STYLE-IMAGE':
						$this->blk[$this->blklvl]['list_style_image'] = strtolower($v);
						break;
					case 'LIST-STYLE-POSITION':
						$this->blk[$this->blklvl]['list_style_position'] = strtolower($v);
						break;
				}//end of switch($k)
			}


			if ($type != 'INLINE' && $type != 'TABLECELL') { // All block-level, including BODY tag
				switch ($k) {

					case 'TEXT-INDENT':
						// Computed value - to inherit
						$this->blk[$this->blklvl]['text_indent'] = $this->ConvertSize($v, $this->blk[$prevlevel]['inner_width'], $this->FontSize, false) . 'mm';
						break;

					case 'MARGIN-COLLAPSE': // Custom tag to collapse margins at top and bottom of page
						if (strtoupper($v) == 'COLLAPSE') {
							$this->blk[$this->blklvl]['margin_collapse'] = true;
						}
						break;

					case 'LINE-HEIGHT':
						$this->blk[$this->blklvl]['line_height'] = $this->fixLineheight($v);
						if (!$this->blk[$this->blklvl]['line_height']) {
							$this->blk[$this->blklvl]['line_height'] = 'N';
						} // mPDF 6
						break;

					// mPDF 6
					case 'LINE-STACKING-STRATEGY':
						$this->blk[$this->blklvl]['line_stacking_strategy'] = strtolower($v);
						break;

					case 'LINE-STACKING-SHIFT':
						$this->blk[$this->blklvl]['line_stacking_shift'] = strtolower($v);
						break;

					case 'TEXT-ALIGN': //left right center justify
						switch (strtoupper($v)) {
							case 'LEFT':
								$this->blk[$this->blklvl]['align'] = "L";
								break;
							case 'CENTER':
								$this->blk[$this->blklvl]['align'] = "C";
								break;
							case 'RIGHT':
								$this->blk[$this->blklvl]['align'] = "R";
								break;
							case 'JUSTIFY':
								$this->blk[$this->blklvl]['align'] = "J";
								break;
						}
						break;

					/* -- BACKGROUNDS -- */
					case 'BACKGROUND-GRADIENT':
						if ($type == 'BLOCK') {
							$this->blk[$this->blklvl]['gradient'] = $v;
						}
						break;
					/* -- END BACKGROUNDS -- */

					case 'DIRECTION':
						if ($v) {
							$this->blk[$this->blklvl]['direction'] = strtolower($v);
						}
						break;
				}//end of switch($k)
			}

			// FOR INLINE ONLY
			if ($type == 'INLINE') {
				switch ($k) {
					case 'DISPLAY':
						if (strtoupper($v) == 'NONE') {
							$this->inlineDisplayOff = true;
						}
						break;
					case 'DIRECTION':
						break;
				}//end of switch($k)
			}
			// FOR INLINE ONLY
			if ($type == 'INLINE') {
				switch ($k) {
					// BORDERS
					case 'BORDER-TOP':
						$this->spanborddet['T'] = $this->border_details($v);
						$this->spanborder = true;
						$spanbordset = true;
						break;
					case 'BORDER-BOTTOM':
						$this->spanborddet['B'] = $this->border_details($v);
						$this->spanborder = true;
						$spanbordset = true;
						break;
					case 'BORDER-LEFT':
						$this->spanborddet['L'] = $this->border_details($v);
						$this->spanborder = true;
						$spanbordset = true;
						break;
					case 'BORDER-RIGHT':
						$this->spanborddet['R'] = $this->border_details($v);
						$this->spanborder = true;
						$spanbordset = true;
						break;
					case 'VISIBILITY': // block is set in OpenTag
						$v = strtolower($v);
						if ($v == 'visible' || $v == 'hidden' || $v == 'printonly' || $v == 'screenonly') {
							$this->textparam['visibility'] = $v;
						}
						break;
				}//end of switch($k)
			}

			if ($type != 'TABLECELL') {
				// FOR INLINE and BLOCK
				switch ($k) {
					case 'TEXT-ALIGN': //left right center justify
						if (strtoupper($v) == 'NOJUSTIFY' && $this->blk[$this->blklvl]['align'] == "J") {
							$this->blk[$this->blklvl]['align'] = "";
						}
						break;
					// bgcolor only - to stay consistent with original html2fpdf
					case 'BACKGROUND':
					case 'BACKGROUND-COLOR':
						$cor = $this->ConvertColor($v);
						if ($cor) {
							if ($tag == 'BODY') {
								$this->bodyBackgroundColor = $cor;
							} elseif ($type == 'INLINE') {
								$this->spanbgcolorarray = $cor;
								$this->spanbgcolor = true;
								$spanbgset = true;
							} else {
								$this->blk[$this->blklvl]['bgcolorarray'] = $cor;
								$this->blk[$this->blklvl]['bgcolor'] = true;
							}
						} elseif ($type != 'INLINE') {
							if ($this->ColActive) {
								$this->blk[$this->blklvl]['bgcolorarray'] = $this->blk[$prevlevel]['bgcolorarray'];
								$this->blk[$this->blklvl]['bgcolor'] = $this->blk[$prevlevel]['bgcolor'];
							}
						}
						break;

					case 'VERTICAL-ALIGN': //super and sub only dealt with here e.g. <SUB> and <SUP>
						switch (strtoupper($v)) {
							case 'SUPER':
								$this->textvar = ($this->textvar | FA_SUPERSCRIPT); // mPDF 5.7.1
								$this->textvar = ($this->textvar & ~FA_SUBSCRIPT);
								// mPDF 5.7.3  inline text-decoration parameters
								if (isset($this->textparam['text-baseline'])) {
									$this->textparam['text-baseline'] += ($this->baselineSup) * $preceeding_fontsize;
								} else {
									$this->textparam['text-baseline'] = ($this->baselineSup) * $preceeding_fontsize;
								}
								break;
							case 'SUB':
								$this->textvar = ($this->textvar | FA_SUBSCRIPT);
								$this->textvar = ($this->textvar & ~FA_SUPERSCRIPT);
								// mPDF 5.7.3  inline text-decoration parameters
								if (isset($this->textparam['text-baseline'])) {
									$this->textparam['text-baseline'] += ($this->baselineSub) * $preceeding_fontsize;
								} else {
									$this->textparam['text-baseline'] = ($this->baselineSub) * $preceeding_fontsize;
								}
								break;
							case 'BASELINE':
								$this->textvar = ($this->textvar & ~FA_SUBSCRIPT);
								$this->textvar = ($this->textvar & ~FA_SUPERSCRIPT);
								// mPDF 5.7.3  inline text-decoration parameters
								if (isset($this->textparam['text-baseline'])) {
									unset($this->textparam['text-baseline']);
								}
								break;
							// mPDF 5.7.3  inline text-decoration parameters
							default:
								$lh = $this->_computeLineheight($this->blk[$this->blklvl]['line_height']);
								$sz = $this->ConvertSize($v, $lh, $this->FontSize, false);
								$this->textvar = ($this->textvar & ~FA_SUBSCRIPT);
								$this->textvar = ($this->textvar & ~FA_SUPERSCRIPT);
								if ($sz) {
									if ($sz > 0) {
										$this->textvar = ($this->textvar | FA_SUPERSCRIPT);
									} else {
										$this->textvar = ($this->textvar | FA_SUBSCRIPT);
									}
									if (isset($this->textparam['text-baseline'])) {
										$this->textparam['text-baseline'] += $sz;
									} else {
										$this->textparam['text-baseline'] = $sz;
									}
								}
						}
						break;
				}//end of switch($k)
			}


			// FOR ALL
			switch ($k) {
				case 'LETTER-SPACING':
					$this->lSpacingCSS = $v;
					if (($this->lSpacingCSS || $this->lSpacingCSS === '0') && strtoupper($this->lSpacingCSS) != 'NORMAL') {
						$this->fixedlSpacing = $this->ConvertSize($this->lSpacingCSS, $this->FontSize);
					}
					break;

				case 'WORD-SPACING':
					$this->wSpacingCSS = $v;
					if ($this->wSpacingCSS && strtoupper($this->wSpacingCSS) != 'NORMAL') {
						$this->minwSpacing = $this->ConvertSize($this->wSpacingCSS, $this->FontSize);
					}
					break;

				case 'FONT-STYLE': // italic normal oblique
					switch (strtoupper($v)) {
						case 'ITALIC':
						case 'OBLIQUE':
							$this->SetStyle('I', true);
							break;
						case 'NORMAL':
							$this->SetStyle('I', false);
							break;
					}
					break;

				case 'FONT-WEIGHT': // normal bold //Does not support: bolder, lighter, 100..900(step value=100)
					switch (strtoupper($v)) {
						case 'BOLD':
							$this->SetStyle('B', true);
							break;
						case 'NORMAL':
							$this->SetStyle('B', false);
							break;
					}
					break;

				case 'FONT-KERNING':
					if (strtoupper($v) == 'NORMAL' || (strtoupper($v) == 'AUTO' && $this->useKerning)) {
						/* -- OTL -- */
						if ($this->CurrentFont['haskernGPOS']) {
							if (isset($this->OTLtags['Plus'])) {
								$this->OTLtags['Plus'] .= ' kern';
							} else {
								$this->OTLtags['Plus'] = ' kern';
							}
						}
						/* -- END OTL -- */ else {  // *OTL*
							$this->textvar = ($this->textvar | FC_KERNING);
						} // *OTL*
					} elseif (strtoupper($v) == 'NONE' || (strtoupper($v) == 'AUTO' && !$this->useKerning)) {
						if (isset($this->OTLtags['Plus']))
							$this->OTLtags['Plus'] = str_replace('kern', '', $this->OTLtags['Plus']); // *OTL*
						if (isset($this->OTLtags['FFPlus']))
							$this->OTLtags['FFPlus'] = preg_replace('/kern[\d]*/', '', $this->OTLtags['FFPlus']);
						$this->textvar = ($this->textvar & ~FC_KERNING);
					}
					break;

				/* -- OTL -- */
				case 'FONT-LANGUAGE-OVERRIDE':
					$v = strtoupper($v);
					if (strpos($v, 'NORMAL') !== false) {
						$this->fontLanguageOverride = '';
					} else {
						$this->fontLanguageOverride = trim($v);
					}
					break;


				case 'FONT-VARIANT-POSITION':
					if (isset($this->OTLtags['Plus']))
						$this->OTLtags['Plus'] = str_replace(array('sups', 'subs'), '', $this->OTLtags['Plus']);
					switch (strtoupper($v)) {
						case 'SUPER':
							$this->OTLtags['Plus'] .= ' sups';
							break;
						case 'SUB':
							$this->OTLtags['Plus'] .= ' subs';
							break;
						case 'NORMAL':
							break;
					}
					break;

				case 'FONT-VARIANT-CAPS':
					$v = strtoupper($v);
					if (!isset($this->OTLtags['Plus'])) {
						$this->OTLtags['Plus'] = '';
					}
					$this->OTLtags['Plus'] = str_replace(array('c2sc', 'smcp', 'c2pc', 'pcap', 'unic', 'titl'), '', $this->OTLtags['Plus']);
					$this->textvar = ($this->textvar & ~FC_SMALLCAPS);   // ?????????????? <small-caps>
					if (strpos($v, 'ALL-SMALL-CAPS') !== false) {
						$this->OTLtags['Plus'] .= ' c2sc smcp';
					} elseif (strpos($v, 'SMALL-CAPS') !== false) {
						if (isset($this->CurrentFont['hassmallcapsGSUB']) && $this->CurrentFont['hassmallcapsGSUB']) {
							$this->OTLtags['Plus'] .= ' smcp';
						} else {
							$this->textvar = ($this->textvar | FC_SMALLCAPS);
						}
					} elseif (strpos($v, 'ALL-PETITE-CAPS') !== false) {
						$this->OTLtags['Plus'] .= ' c2pc pcap';
					} elseif (strpos($v, 'PETITE-CAPS') !== false) {
						$this->OTLtags['Plus'] .= ' pcap';
					} elseif (strpos($v, 'UNICASE') !== false) {
						$this->OTLtags['Plus'] .= ' unic';
					} elseif (strpos($v, 'TITLING-CAPS') !== false) {
						$this->OTLtags['Plus'] .= ' titl';
					}
					break;

				case 'FONT-VARIANT-LIGATURES':
					$v = strtoupper($v);
					if (!isset($this->OTLtags['Plus'])) {
						$this->OTLtags['Plus'] = '';
					}
					if (!isset($this->OTLtags['Minus'])) {
						$this->OTLtags['Minus'] = '';
					}
					if (strpos($v, 'NORMAL') !== false) {
						$this->OTLtags['Minus'] = str_replace(array('liga', 'clig', 'calt'), '', $this->OTLtags['Minus']);
						$this->OTLtags['Plus'] = str_replace(array('dlig', 'hlig'), '', $this->OTLtags['Plus']);
					} elseif (strpos($v, 'NONE') !== false) {
						$this->OTLtags['Minus'] .= ' liga clig calt';
						$this->OTLtags['Plus'] = str_replace(array('dlig', 'hlig'), '', $this->OTLtags['Plus']);
					}
					if (strpos($v, 'NO-COMMON-LIGATURES') !== false) {
						$this->OTLtags['Minus'] .= ' liga clig';
					} elseif (strpos($v, 'COMMON-LIGATURES') !== false) {
						$this->OTLtags['Minus'] = str_replace(array('liga', 'clig'), '', $this->OTLtags['Minus']);
					}
					if (strpos($v, 'NO-CONTEXTUAL') !== false) {
						$this->OTLtags['Minus'] .= ' calt';
					} elseif (strpos($v, 'CONTEXTUAL') !== false) {
						$this->OTLtags['Minus'] = str_replace('calt', '', $this->OTLtags['Minus']);
					}
					if (strpos($v, 'NO-DISCRETIONARY-LIGATURES') !== false) {
						$this->OTLtags['Plus'] = str_replace('dlig', '', $this->OTLtags['Plus']);
					} elseif (strpos($v, 'DISCRETIONARY-LIGATURES') !== false) {
						$this->OTLtags['Plus'] .= ' dlig';
					}
					if (strpos($v, 'NO-HISTORICAL-LIGATURES') !== false) {
						$this->OTLtags['Plus'] = str_replace('hlig', '', $this->OTLtags['Plus']);
					} elseif (strpos($v, 'HISTORICAL-LIGATURES') !== false) {
						$this->OTLtags['Plus'] .= ' hlig';
					}

					break;

				case 'FONT-VARIANT-NUMERIC':
					$v = strtoupper($v);
					if (!isset($this->OTLtags['Plus'])) {
						$this->OTLtags['Plus'] = '';
					}
					if (strpos($v, 'NORMAL') !== false) {
						$this->OTLtags['Plus'] = str_replace(array('ordn', 'zero', 'lnum', 'onum', 'pnum', 'tnum', 'frac', 'afrc'), '', $this->OTLtags['Plus']);
					}
					if (strpos($v, 'ORDINAL') !== false) {
						$this->OTLtags['Plus'] .= ' ordn';
					}
					if (strpos($v, 'SLASHED-ZERO') !== false) {
						$this->OTLtags['Plus'] .= ' zero';
					}
					if (strpos($v, 'LINING-NUMS') !== false) {
						$this->OTLtags['Plus'] .= ' lnum';
						$this->OTLtags['Plus'] = str_replace('onum', '', $this->OTLtags['Plus']);
					} elseif (strpos($v, 'OLDSTYLE-NUMS') !== false) {
						$this->OTLtags['Plus'] .= ' onum';
						$this->OTLtags['Plus'] = str_replace('lnum', '', $this->OTLtags['Plus']);
					}
					if (strpos($v, 'PROPORTIONAL-NUMS') !== false) {
						$this->OTLtags['Plus'] .= ' pnum';
						$this->OTLtags['Plus'] = str_replace('tnum', '', $this->OTLtags['Plus']);
					} elseif (strpos($v, 'TABULAR-NUMS') !== false) {
						$this->OTLtags['Plus'] .= ' tnum';
						$this->OTLtags['Plus'] = str_replace('pnum', '', $this->OTLtags['Plus']);
					}
					if (strpos($v, 'DIAGONAL-FRACTIONS') !== false) {
						$this->OTLtags['Plus'] .= ' frac';
						$this->OTLtags['Plus'] = str_replace('afrc', '', $this->OTLtags['Plus']);
					} elseif (strpos($v, 'STACKED-FRACTIONS') !== false) {
						$this->OTLtags['Plus'] .= ' afrc';
						$this->OTLtags['Plus'] = str_replace('frac', '', $this->OTLtags['Plus']);
					}
					break;

				case 'FONT-VARIANT-ALTERNATES':  // Only supports historical-forms
					$v = strtoupper($v);
					if (!isset($this->OTLtags['Plus'])) {
						$this->OTLtags['Plus'] = '';
					}
					if (strpos($v, 'NORMAL') !== false) {
						$this->OTLtags['Plus'] = str_replace('hist', '', $this->OTLtags['Plus']);
					}
					if (strpos($v, 'HISTORICAL-FORMS') !== false) {
						$this->OTLtags['Plus'] .= ' hist';
					}
					break;


				case 'FONT-FEATURE-SETTINGS':
					$v = strtolower($v);
					if (strpos($v, 'normal') !== false) {
						$this->OTLtags['FFMinus'] = '';
						$this->OTLtags['FFPlus'] = '';
					} else {
						if (!isset($this->OTLtags['FFPlus'])) {
							$this->OTLtags['FFPlus'] = '';
						}
						if (!isset($this->OTLtags['FFMinus'])) {
							$this->OTLtags['FFMinus'] = '';
						}
						$tags = preg_split('/[,]/', $v);
						foreach ($tags AS $t) {
							if (preg_match('/[\"\']([a-zA-Z0-9]{4})[\"\']\s*(on|off|\d*){0,1}/', $t, $m)) {
								if ($m[2] == 'off' || $m[2] === '0') {
									if (strpos($this->OTLtags['FFMinus'], $m[1]) === false) {
										$this->OTLtags['FFMinus'] .= ' ' . $m[1];
									}
									$this->OTLtags['FFPlus'] = preg_replace('/' . $m[1] . '[\d]*/', '', $this->OTLtags['FFPlus']);
								} else {
									if ($m[2] == 'on') {
										$m[2] = '1';
									}
									if (strpos($this->OTLtags['FFPlus'], $m[1]) === false) {
										$this->OTLtags['FFPlus'] .= ' ' . $m[1] . $m[2];
									}
									$this->OTLtags['FFMinus'] = str_replace($m[1], '', $this->OTLtags['FFMinus']);
								}
							}
						}
					}
					break;
				/* -- END OTL -- */


				case 'TEXT-TRANSFORM': // none uppercase lowercase //Does support: capitalize
					switch (strtoupper($v)) { //Not working 100%
						case 'CAPITALIZE':
							$this->textvar = ($this->textvar | FT_CAPITALIZE); // mPDF 5.7.1
							$this->textvar = ($this->textvar & ~FT_UPPERCASE); // mPDF 5.7.1
							$this->textvar = ($this->textvar & ~FT_LOWERCASE); // mPDF 5.7.1
							break;
						case 'UPPERCASE':
							$this->textvar = ($this->textvar | FT_UPPERCASE); // mPDF 5.7.1
							$this->textvar = ($this->textvar & ~FT_LOWERCASE); // mPDF 5.7.1
							$this->textvar = ($this->textvar & ~FT_CAPITALIZE); // mPDF 5.7.1
							break;
						case 'LOWERCASE':
							$this->textvar = ($this->textvar | FT_LOWERCASE); // mPDF 5.7.1
							$this->textvar = ($this->textvar & ~FT_UPPERCASE); // mPDF 5.7.1
							$this->textvar = ($this->textvar & ~FT_CAPITALIZE); // mPDF 5.7.1
							break;
						case 'NONE': break;
							$this->textvar = ($this->textvar & ~FT_UPPERCASE); // mPDF 5.7.1
							$this->textvar = ($this->textvar & ~FT_LOWERCASE); // mPDF 5.7.1
							$this->textvar = ($this->textvar & ~FT_CAPITALIZE); // mPDF 5.7.1
					}
					break;

				case 'TEXT-SHADOW':
					$ts = $this->cssmgr->setCSStextshadow($v);
					if ($ts) {
						$this->textshadow = $ts;
					}
					break;

				case 'HYPHENS':
					if (strtoupper($v) == 'NONE') {
						$this->textparam['hyphens'] = 2;
					} elseif (strtoupper($v) == 'AUTO') {
						$this->textparam['hyphens'] = 1;
					} elseif (strtoupper($v) == 'MANUAL') {
						$this->textparam['hyphens'] = 0;
					}
					break;

				case 'TEXT-OUTLINE':
					if (strtoupper($v) == 'NONE') {
						$this->textparam['outline-s'] = false;
					}
					break;

				case 'TEXT-OUTLINE-WIDTH':
				case 'OUTLINE-WIDTH':
					switch (strtoupper($v)) {
						case 'THIN': $v = '0.03em';
							break;
						case 'MEDIUM': $v = '0.05em';
							break;
						case 'THICK': $v = '0.07em';
							break;
					}
					$w = $this->ConvertSize($v, $this->FontSize, $this->FontSize);
					if ($w) {
						$this->textparam['outline-WIDTH'] = $w;
						$this->textparam['outline-s'] = true;
					} else {
						$this->textparam['outline-s'] = false;
					}
					break;

				case 'TEXT-OUTLINE-COLOR':
				case 'OUTLINE-COLOR':
					if (strtoupper($v) == 'INVERT') {
						if ($this->colorarray) {
							$cor = $this->colorarray;
							$this->textparam['outline-COLOR'] = $this->_invertColor($cor);
						} else {
							$this->textparam['outline-COLOR'] = $this->ConvertColor(255);
						}
					} else {
						$cor = $this->ConvertColor($v);
						if ($cor) {
							$this->textparam['outline-COLOR'] = $cor;
						}
					}
					break;

				case 'COLOR': // font color
					$cor = $this->ConvertColor($v);
					if ($cor) {
						$this->colorarray = $cor;
						$this->SetTColor($cor);
					}
					break;
			}//end of switch($k)
		}//end of foreach
		// mPDF 5.7.3  inline text-decoration parameters
		// Needs to be set at the end - after vertical-align = super/sub, so that textparam['text-baseline'] is set
		if (isset($arrayaux['TEXT-DECORATION'])) {
			$v = $arrayaux['TEXT-DECORATION']; // none underline line-through (strikeout) //Does not support: blink
			if (stristr($v, 'LINE-THROUGH')) {
				$this->textvar = ($this->textvar | FD_LINETHROUGH);
				// mPDF 5.7.3  inline text-decoration parameters
				if (isset($this->textparam['text-baseline'])) {
					$this->textparam['s-decoration']['baseline'] = $this->textparam['text-baseline'];
				} else {
					$this->textparam['s-decoration']['baseline'] = 0;
				}
				$this->textparam['s-decoration']['fontkey'] = $this->FontFamily . $this->FontStyle;
				$this->textparam['s-decoration']['fontsize'] = $this->FontSize;
				$this->textparam['s-decoration']['color'] = strtoupper($this->TextColor); // change 0 0 0 rg to 0 0 0 RG
			}
			if (stristr($v, 'UNDERLINE')) {
				$this->textvar = ($this->textvar | FD_UNDERLINE);
				// mPDF 5.7.3  inline text-decoration parameters
				if (isset($this->textparam['text-baseline'])) {
					$this->textparam['u-decoration']['baseline'] = $this->textparam['text-baseline'];
				} else {
					$this->textparam['u-decoration']['baseline'] = 0;
				}
				$this->textparam['u-decoration']['fontkey'] = $this->FontFamily . $this->FontStyle;
				$this->textparam['u-decoration']['fontsize'] = $this->FontSize;
				$this->textparam['u-decoration']['color'] = strtoupper($this->TextColor); // change 0 0 0 rg to 0 0 0 RG
			}
			if (stristr($v, 'OVERLINE')) {
				$this->textvar = ($this->textvar | FD_OVERLINE);
				// mPDF 5.7.3  inline text-decoration parameters
				if (isset($this->textparam['text-baseline'])) {
					$this->textparam['o-decoration']['baseline'] = $this->textparam['text-baseline'];
				} else {
					$this->textparam['o-decoration']['baseline'] = 0;
				}
				$this->textparam['o-decoration']['fontkey'] = $this->FontFamily . $this->FontStyle;
				$this->textparam['o-decoration']['fontsize'] = $this->FontSize;
				$this->textparam['o-decoration']['color'] = strtoupper($this->TextColor); // change 0 0 0 rg to 0 0 0 RG
			}
			if (stristr($v, 'NONE')) {
				$this->textvar = ($this->textvar & ~FD_UNDERLINE);
				$this->textvar = ($this->textvar & ~FD_LINETHROUGH);
				$this->textvar = ($this->textvar & ~FD_OVERLINE);
				// mPDF 5.7.3  inline text-decoration parameters
				if (isset($this->textparam['u-decoration'])) {
					unset($this->textparam['u-decoration']);
				}
				if (isset($this->textparam['s-decoration'])) {
					unset($this->textparam['s-decoration']);
				}
				if (isset($this->textparam['o-decoration'])) {
					unset($this->textparam['o-decoration']);
				}
			}
		}
		// mPDF 6
		if ($spanbordset) { // BORDER has been set on this INLINE element
			if (isset($this->textparam['text-baseline'])) {
				$this->textparam['bord-decoration']['baseline'] = $this->textparam['text-baseline'];
			} else {
				$this->textparam['bord-decoration']['baseline'] = 0;
			}
			$this->textparam['bord-decoration']['fontkey'] = $this->FontFamily . $this->FontStyle;
			$this->textparam['bord-decoration']['fontsize'] = $this->FontSize;
		}
		if ($spanbgset) { // BACKGROUND[-COLOR] has been set on this INLINE element
			if (isset($this->textparam['text-baseline'])) {
				$this->textparam['bg-decoration']['baseline'] = $this->textparam['text-baseline'];
			} else {
				$this->textparam['bg-decoration']['baseline'] = 0;
			}
			$this->textparam['bg-decoration']['fontkey'] = $this->FontFamily . $this->FontStyle;
			$this->textparam['bg-decoration']['fontsize'] = $this->FontSize;
		}
	}

	/* -- END HTML-CSS -- */

	function SetStyle($tag, $enable)
	{
		$this->$tag = $enable;
		$style = '';
		foreach (array('B', 'I') as $s) {
			if ($this->$s) {
				$style.=$s;
			}
		}
		$this->currentfontstyle = $style;
		$this->SetFont('', $style, 0, false);
	}

	// Set multiple styles at one time
	function SetStylesArray($arr)
	{
		$style = '';
		foreach (array('B', 'I') as $s) {
			if (isset($arr[$s])) {
				if ($arr[$s]) {
					$this->$s = true;
					$style.=$s;
				} else {
					$this->$s = false;
				}
			} elseif ($this->$s) {
				$style.=$s;
			}
		}
		$this->currentfontstyle = $style;
		$this->SetFont('', $style, 0, false);
	}

	// Set multiple styles at one $str e.g. "BI"
	function SetStyles($str)
	{
		$style = '';
		foreach (array('B', 'I') as $s) {
			if (strpos($str, $s) !== false) {
				$this->$s = true;
				$style.=$s;
			} else {
				$this->$s = false;
			}
		}
		$this->currentfontstyle = $style;
		$this->SetFont('', $style, 0, false);
	}

	function ResetStyles()
	{
		foreach (array('B', 'I') as $s) {
			$this->$s = false;
		}
		$this->currentfontstyle = '';
		$this->SetFont('', '', 0, false);
	}

	function DisableTags($str = '')
	{
		if ($str == '') { //enable all tags
			//Insert new supported tags in the long string below.
			$this->enabledtags = "<a><acronym><address><article><aside><b><bdi><bdo><big><blockquote><br><caption><center><cite><code><del><details><dd><div><dl><dt><em><fieldset><figcaption><figure><font><form><h1><h2><h3><h4><h5><h6><hgroup><hr><i><img><input><ins><kbd><legend><li><main><mark><meter><nav><ol><option><p><pre><progress><q><s><samp><section><select><small><span><strike><strong><sub><summary><sup><table><tbody><td><template><textarea><tfoot><th><thead><time><tr><tt><u><ul><var><footer><header><annotation><bookmark><jpgraph><textcircle><barcode><dottab><indexentry><indexinsert><watermarktext><watermarkimage><tts><ttz><tta><column_break><columnbreak><newcolumn><newpage><page_break><pagebreak><formfeed><columns><toc><tocentry><tocpagebreak><pageheader><pagefooter><setpageheader><setpagefooter><sethtmlpageheader><sethtmlpagefooter>";
		} else {
			$str = explode(",", $str);
			foreach ($str as $v)
				$this->enabledtags = str_replace(trim($v), '', $this->enabledtags);
		}
	}

	/* -- TABLES -- */

	function TableCheckMinWidth($maxwidth, $forcewrap = 0, $textbuffer, $checkletter = false)
	{ // mPDF 6
		$acclength = 0; // mPDF 6 (accumulated length across > 1 chunk)
		$acclongest = 0; // mPDF 6 (accumulated length max across > 1 chunk)
		$biggestword = 0;
		$toonarrow = false;
		if ((count($textbuffer) == 0) or ( (count($textbuffer) == 1) && ($textbuffer[0][0] == ''))) {
			return 0;
		}

		foreach ($textbuffer as $chunk) {

			$line = $chunk[0];
			$OTLdata = (isset($chunk[18]) ? $chunk[18] : NULL);

			// mPDF ITERATION
			if ($this->iterationCounter)
				$line = preg_replace('/{iteration ([a-zA-Z0-9_]+)}/', '\\1', $line);

			// IMAGES & FORM ELEMENTS
			if (substr($line, 0, 3) == "\xbb\xa4\xac") { //inline object - FORM element or IMAGE!
				$objattr = $this->_getObjAttr($line);
				if ($objattr['type'] != 'hr' && isset($objattr['width']) && ($objattr['width'] / $this->shrin_k) > ($maxwidth + 0.0001)) {
					if (($objattr['width'] / $this->shrin_k) > $biggestword) {
						$biggestword = ($objattr['width'] / $this->shrin_k);
					}
					$toonarrow = true;
				}
				continue;
			}

			if ($line == "\n") {
				$acclength = 0; // mPDF 6 (accumulated length across > 1 chunk)
				continue;
			}
			$line = trim($line);
			if (!empty($OTLdata)) {
				$this->otl->trimOTLdata($OTLdata, true, true);
			} // *OTL*
			// SET FONT SIZE/STYLE from $chunk[n]
			// FONTSIZE
			if (isset($chunk[11]) and $chunk[11] != '') {
				if ($this->shrin_k) {
					$this->SetFontSize($chunk[11] / $this->shrin_k, false);
				} else {
					$this->SetFontSize($chunk[11], false);
				}
			}
			// FONTFAMILY
			if (isset($chunk[4]) and $chunk[4] != '') {
				$font = $this->SetFont($chunk[4], $this->FontStyle, 0, false);
			}
			// B I
			if (isset($chunk[2]) and $chunk[2] != '') {
				$this->SetStyles($chunk[2]);
			}

			$lbw = $rbw = 0; // Border widths
			if (isset($chunk[16]) && !empty($chunk[16])) { //Border
				$this->spanborddet = $chunk[16];
				$lbw = (isset($this->spanborddet['L']['w']) ? $this->spanborddet['L']['w'] : 0);
				$rbw = (isset($this->spanborddet['R']['w']) ? $this->spanborddet['R']['w'] : 0);
			}
			if (isset($chunk[15])) {   // Word spacing
				$this->wSpacingCSS = $chunk[15];
				if ($this->wSpacingCSS && strtoupper($this->wSpacingCSS) != 'NORMAL') {
					$this->minwSpacing = $this->ConvertSize($this->wSpacingCSS, $this->FontSize) / $this->shrin_k; // mPDF 5.7.3
				}
			}
			if (isset($chunk[14])) {   // Letter spacing
				$this->lSpacingCSS = $chunk[14];
				if (($this->lSpacingCSS || $this->lSpacingCSS === '0') && strtoupper($this->lSpacingCSS) != 'NORMAL') {
					$this->fixedlSpacing = $this->ConvertSize($this->lSpacingCSS, $this->FontSize) / $this->shrin_k; // mPDF 5.7.3
				}
			}
			if (isset($chunk[8])) { // mPDF 5.7.1
				$this->textvar = $chunk[8];
			}

			// mPDF 6
			// If overflow==wrap ($checkletter) OR (No word breaks and contains CJK)
			if ($checkletter || (!preg_match('/(\xe2\x80\x8b| )/', trim($line)) && preg_match("/([" . $this->pregCJKchars . "])/u", $line) )) {
				if (preg_match("/([" . $this->pregCJKchars . "])/u", $line)) {
					$checkCJK = true;
				} else {
					$checkCJK = false;
				}

				$letters = preg_split('//u', $line);
				foreach ($letters as $k => $letter) {

					// mPDF 6
					if ($checkCJK) {
						if (preg_match("/[" . $this->CJKleading . "]/u", $letter) && $k > 0) {
							$letter = $letters[$k - 1] . $letter;
						}
						if (preg_match("/[" . $this->CJKfollowing . "]/u", $letter) && $k < (count($letters) - 1)) {
							$letter = $letter . $letters[$k + 1];
						}
					}

					$letterwidth = $this->GetStringWidth($letter, false, false, $chunk[8]); // Pass $textvar ($chunk[8]), but do OTLdata here
					// so don't have to split OTLdata for each word
					if ($k == 0) {
						$letterwidth += $lbw;
					}
					if ($k == (count($letters) - 1)) {
						$letterwidth += $rbw;
					}

					//Warn user that maxwidth is insufficient
					if ($letterwidth > $maxwidth + 0.0001) {
						if ($letterwidth > $biggestword) {
							$biggestword = $letterwidth;
						}
						$toonarrow = true;
					}
				}
			} else {
				// mPDF 6
				// Need to account for any XAdvance in GPOSinfo (OTLdata = $chunk[18])
				$wordXAdvance = array();
				if (isset($chunk[18]) && $chunk[18]) {
					preg_match_all('/(\xe2\x80\x8b| )/', $line, $spaces, PREG_OFFSET_CAPTURE); // U+200B Zero Width word boundary, or space
					$lastoffset = 0;
					$k = -1; // Added so that if no spaces found, "last word" later is calculated for the one and only word
					foreach ($spaces[0] as $k => $m) {
						$offset = $m[1];
						// ...TableCheckMinWidth...
						// At this point, BIDI not applied, Writing direction is not set, and XAdvanceL balances XAdvanceR
						for ($n = $lastoffset; $n < $offset; $n++) {
							if (isset($chunk[18]['GPOSinfo'][$n]['XAdvanceL'])) {
								if (isset($wordXAdvance[$k])) {
									$wordXAdvance[$k] += $chunk[18]['GPOSinfo'][$n]['XAdvanceL'];
								} else {
									$wordXAdvance[$k] = $chunk[18]['GPOSinfo'][$n]['XAdvanceL'];
								}
							}
						}
						$lastoffset = $offset + 1;
					}

					$k++;  // last word
					foreach ($chunk[18]['GPOSinfo'] AS $n => $gpos) {
						if ($n >= $lastoffset && isset($chunk[18]['GPOSinfo'][$n]['XAdvanceL'])) {
							if (isset($wordXAdvance[$k])) {
								$wordXAdvance[$k] += $chunk[18]['GPOSinfo'][$n]['XAdvanceL'];
							} else {
								$wordXAdvance[$k] = $chunk[18]['GPOSinfo'][$n]['XAdvanceL'];
							}
						}
					}
				}

				$words = preg_split('/(\xe2\x80\x8b| )/', $line); // U+200B Zero Width word boundary, or space
				foreach ($words as $k => $word) {
					$word = trim($word);
					$wordwidth = $this->GetStringWidth($word, false, false, $chunk[8]); // Pass $textvar ($chunk[8]), but do OTLdata here
					// so don't have to split OTLdata for each word
					if (isset($wordXAdvance[$k])) {
						$wordwidth += ($wordXAdvance[$k] * 1000 / $this->CurrentFont['unitsPerEm']) * ($this->FontSize / 1000);
					}
					if ($k == 0) {
						$wordwidth += $lbw;
					}
					if ($k == (count($words) - 1)) {
						$wordwidth += $rbw;
					}

					// mPDF 6
					if (count($words) == 1 && substr($chunk[0], 0, 1) != ' ') {
						$acclength += $wordwidth;
					} elseif (count($words) > 1 && $k == 0 && substr($chunk[0], 0, 1) != ' ') {
						$acclength += $wordwidth;
					} else {
						$acclength = $wordwidth;
					}
					$acclongest = max($acclongest, $acclength);
					if (count($words) == 1 && substr($chunk[0], -1, 1) == ' ') {
						$acclength = 0;
					} elseif (count($words) > 1 && ($k != (count($words) - 1) || substr($chunk[0], -1, 1) == ' ')) {
						$acclength = 0;
					}

					//Warn user that maxwidth is insufficient
					if ($wordwidth > $maxwidth + 0.0001) {
						if ($wordwidth > $biggestword) {
							$biggestword = $wordwidth;
						}
						$toonarrow = true;
					}
				}
			}

			// mPDF 6  Accumulated length of biggest word - across multiple chunks
			if ($acclongest > $maxwidth + 0.0001) {
				if ($acclongest > $biggestword) {
					$biggestword = $acclongest;
				}
				$toonarrow = true;
			}

			// RESET FONT SIZE/STYLE
			// RESETTING VALUES
			//Now we must deactivate what we have used
			if (isset($chunk[2]) and $chunk[2] != '') {
				$this->ResetStyles();
			}
			if (isset($chunk[4]) and $chunk[4] != '') {
				$this->SetFont($this->default_font, $this->FontStyle, 0, false);
			}
			if (isset($chunk[11]) and $chunk[11] != '') {
				$this->SetFontSize($this->default_font_size, false);
			}
			$this->spanborddet = array();
			$this->textvar = 0x00; // mPDF 5.7.1
			$this->OTLtags = array();
			$this->lSpacingCSS = '';
			$this->wSpacingCSS = '';
			$this->fixedlSpacing = false;
			$this->minwSpacing = 0;
		}

		//Return -(wordsize) if word is bigger than maxwidth
		// ADDED
		if (($toonarrow) && ($this->table_error_report)) {
			throw new MpdfException("Word is too long to fit in table - " . $this->table_error_report_param);
		}
		if ($toonarrow)
			return -$biggestword;
		else
			return 1;
	}

	function shrinkTable(&$table, $k)
	{
		$table['border_spacing_H'] /= $k;
		$table['border_spacing_V'] /= $k;

		$table['padding']['T'] /= $k;
		$table['padding']['R'] /= $k;
		$table['padding']['B'] /= $k;
		$table['padding']['L'] /= $k;

		$table['margin']['T'] /= $k;
		$table['margin']['R'] /= $k;
		$table['margin']['B'] /= $k;
		$table['margin']['L'] /= $k;

		$table['border_details']['T']['w'] /= $k;
		$table['border_details']['R']['w'] /= $k;
		$table['border_details']['B']['w'] /= $k;
		$table['border_details']['L']['w'] /= $k;

		if (isset($table['max_cell_border_width']['T']))
			$table['max_cell_border_width']['T'] /= $k;
		if (isset($table['max_cell_border_width']['R']))
			$table['max_cell_border_width']['R'] /= $k;
		if (isset($table['max_cell_border_width']['B']))
			$table['max_cell_border_width']['B'] /= $k;
		if (isset($table['max_cell_border_width']['L']))
			$table['max_cell_border_width']['L'] /= $k;

		if ($this->simpleTables) {
			$table['simple']['border_details']['T']['w'] /= $k;
			$table['simple']['border_details']['R']['w'] /= $k;
			$table['simple']['border_details']['B']['w'] /= $k;
			$table['simple']['border_details']['L']['w'] /= $k;
		}

		$table['miw'] /= $k;
		$table['maw'] /= $k;

		for ($j = 0; $j < $table['nc']; $j++) { //columns
			$table['wc'][$j]['miw'] /= $k;
			$table['wc'][$j]['maw'] /= $k;

			if (isset($table['decimal_align'][$j]['maxs0']) && $table['decimal_align'][$j]['maxs0']) {
				$table['decimal_align'][$j]['maxs0'] /= $k;
			}
			if (isset($table['decimal_align'][$j]['maxs1']) && $table['decimal_align'][$j]['maxs1']) {
				$table['decimal_align'][$j]['maxs1'] /= $k;
			}

			if (isset($table['wc'][$j]['absmiw']) && $table['wc'][$j]['absmiw'])
				$table['wc'][$j]['absmiw'] /= $k;

			for ($i = 0; $i < $table['nr']; $i++) { //rows
				$c = &$table['cells'][$i][$j];
				if (isset($c) && $c) {
					if (!$this->simpleTables) {
						if ($this->packTableData) {
							$cell = $this->_unpackCellBorder($c['borderbin']);
							$cell['border_details']['T']['w'] /= $k;
							$cell['border_details']['R']['w'] /= $k;
							$cell['border_details']['B']['w'] /= $k;
							$cell['border_details']['L']['w'] /= $k;
							$cell['border_details']['mbw']['TL'] /= $k;
							$cell['border_details']['mbw']['TR'] /= $k;
							$cell['border_details']['mbw']['BL'] /= $k;
							$cell['border_details']['mbw']['BR'] /= $k;
							$cell['border_details']['mbw']['LT'] /= $k;
							$cell['border_details']['mbw']['LB'] /= $k;
							$cell['border_details']['mbw']['RT'] /= $k;
							$cell['border_details']['mbw']['RB'] /= $k;
							$c['borderbin'] = $this->_packCellBorder($cell);
						} else {
							$c['border_details']['T']['w'] /= $k;
							$c['border_details']['R']['w'] /= $k;
							$c['border_details']['B']['w'] /= $k;
							$c['border_details']['L']['w'] /= $k;
							$c['border_details']['mbw']['TL'] /= $k;
							$c['border_details']['mbw']['TR'] /= $k;
							$c['border_details']['mbw']['BL'] /= $k;
							$c['border_details']['mbw']['BR'] /= $k;
							$c['border_details']['mbw']['LT'] /= $k;
							$c['border_details']['mbw']['LB'] /= $k;
							$c['border_details']['mbw']['RT'] /= $k;
							$c['border_details']['mbw']['RB'] /= $k;
						}
					}
					$c['padding']['T'] /= $k;
					$c['padding']['R'] /= $k;
					$c['padding']['B'] /= $k;
					$c['padding']['L'] /= $k;
					if (isset($c['maxs'])) {
						$c['maxs'] /= $k;
					}
					if (isset($c['w'])) {
						$c['w'] /= $k;
					}
					$c['s'] /= $k;
					$c['maw'] /= $k;
					$c['miw'] /= $k;
					if (isset($c['h'])) {
						$c['h'] /= $k;
					} // mPDF 5.7.4
					if (isset($c['absmiw']))
						$c['absmiw'] /= $k;
					if (isset($c['nestedmaw']))
						$c['nestedmaw'] /= $k;
					if (isset($c['nestedmiw']))
						$c['nestedmiw'] /= $k;
					if (isset($c['textbuffer'])) {
						foreach ($c['textbuffer'] AS $n => $tb) {
							if (!empty($tb[16])) {
								$c['textbuffer'][$n][16]['T']['w'] /= $k;
								$c['textbuffer'][$n][16]['B']['w'] /= $k;
								$c['textbuffer'][$n][16]['L']['w'] /= $k;
								$c['textbuffer'][$n][16]['R']['w'] /= $k;
							}
						}
					}
					unset($c);
				}
			}//rows
		}//columns
	}

	function read_short(&$fh)
	{
		$s = fread($fh, 2);
		$a = (ord($s[0]) << 8) + ord($s[1]);
		if ($a & (1 << 15)) {
			$a = ($a - (1 << 16));
		}
		return $a;
	}

	function _packCellBorder($cell)
	{
		if (!is_array($cell) || !isset($cell)) {
			return '';
		}

		if (!$this->packTableData) {
			return $cell;
		}
		// = 186 bytes
		$bindata = pack("nnda6A10nnda6A10nnda6A10nnda6A10nd9", $cell['border'], $cell['border_details']['R']['s'], $cell['border_details']['R']['w'], $cell['border_details']['R']['c'], $cell['border_details']['R']['style'], $cell['border_details']['R']['dom'], $cell['border_details']['L']['s'], $cell['border_details']['L']['w'], $cell['border_details']['L']['c'], $cell['border_details']['L']['style'], $cell['border_details']['L']['dom'], $cell['border_details']['T']['s'], $cell['border_details']['T']['w'], $cell['border_details']['T']['c'], $cell['border_details']['T']['style'], $cell['border_details']['T']['dom'], $cell['border_details']['B']['s'], $cell['border_details']['B']['w'], $cell['border_details']['B']['c'], $cell['border_details']['B']['style'], $cell['border_details']['B']['dom'], $cell['border_details']['mbw']['BL'], $cell['border_details']['mbw']['BR'], $cell['border_details']['mbw']['RT'], $cell['border_details']['mbw']['RB'], $cell['border_details']['mbw']['TL'], $cell['border_details']['mbw']['TR'], $cell['border_details']['mbw']['LT'], $cell['border_details']['mbw']['LB'], (isset($cell['border_details']['cellposdom']) ? $cell['border_details']['cellposdom'] : 0)
		);
		return $bindata;
	}

	function _getBorderWidths($bindata)
	{
		if (!$bindata) {
			return array(0, 0, 0, 0);
		}
		if (!$this->packTableData) {
			return array($bindata['border_details']['T']['w'], $bindata['border_details']['R']['w'], $bindata['border_details']['B']['w'], $bindata['border_details']['L']['w']);
		}

		$bd = unpack("nbord/nrs/drw/a6rca/A10rst/nrd/nls/dlw/a6lca/A10lst/nld/nts/dtw/a6tca/A10tst/ntd/nbs/dbw/a6bca/A10bst/nbd/dmbl/dmbr/dmrt/dmrb/dmtl/dmtr/dmlt/dmlb/dcpd", $bindata);
		$cell['border_details']['R']['w'] = $bd['rw'];
		$cell['border_details']['L']['w'] = $bd['lw'];
		$cell['border_details']['T']['w'] = $bd['tw'];
		$cell['border_details']['B']['w'] = $bd['bw'];
		return array($bd['tw'], $bd['rw'], $bd['bw'], $bd['lw']);
	}

	function _unpackCellBorder($bindata)
	{
		if (!$bindata) {
			return array();
		}
		if (!$this->packTableData) {
			return $bindata;
		}

		$bd = unpack("nbord/nrs/drw/a6rca/A10rst/nrd/nls/dlw/a6lca/A10lst/nld/nts/dtw/a6tca/A10tst/ntd/nbs/dbw/a6bca/A10bst/nbd/dmbl/dmbr/dmrt/dmrb/dmtl/dmtr/dmlt/dmlb/dcpd", $bindata);

		$cell['border'] = $bd['bord'];
		$cell['border_details']['R']['s'] = $bd['rs'];
		$cell['border_details']['R']['w'] = $bd['rw'];
		$cell['border_details']['R']['c'] = str_pad($bd['rca'], 6, "\x00");
		$cell['border_details']['R']['style'] = trim($bd['rst']);
		$cell['border_details']['R']['dom'] = $bd['rd'];

		$cell['border_details']['L']['s'] = $bd['ls'];
		$cell['border_details']['L']['w'] = $bd['lw'];
		$cell['border_details']['L']['c'] = str_pad($bd['lca'], 6, "\x00");
		$cell['border_details']['L']['style'] = trim($bd['lst']);
		$cell['border_details']['L']['dom'] = $bd['ld'];

		$cell['border_details']['T']['s'] = $bd['ts'];
		$cell['border_details']['T']['w'] = $bd['tw'];
		$cell['border_details']['T']['c'] = str_pad($bd['tca'], 6, "\x00");
		$cell['border_details']['T']['style'] = trim($bd['tst']);
		$cell['border_details']['T']['dom'] = $bd['td'];

		$cell['border_details']['B']['s'] = $bd['bs'];
		$cell['border_details']['B']['w'] = $bd['bw'];
		$cell['border_details']['B']['c'] = str_pad($bd['bca'], 6, "\x00");
		$cell['border_details']['B']['style'] = trim($bd['bst']);
		$cell['border_details']['B']['dom'] = $bd['bd'];

		$cell['border_details']['mbw']['BL'] = $bd['mbl'];
		$cell['border_details']['mbw']['BR'] = $bd['mbr'];
		$cell['border_details']['mbw']['RT'] = $bd['mrt'];
		$cell['border_details']['mbw']['RB'] = $bd['mrb'];
		$cell['border_details']['mbw']['TL'] = $bd['mtl'];
		$cell['border_details']['mbw']['TR'] = $bd['mtr'];
		$cell['border_details']['mbw']['LT'] = $bd['mlt'];
		$cell['border_details']['mbw']['LB'] = $bd['mlb'];
		$cell['border_details']['cellposdom'] = $bd['cpd'];


		return($cell);
	}

	////////////////////////TABLE CODE (from PDFTable)/////////////////////////////////////
	////////////////////////TABLE CODE (from PDFTable)/////////////////////////////////////
	////////////////////////TABLE CODE (from PDFTable)/////////////////////////////////////
	//table		Array of (w, h, bc, nr, wc, hr, cells)
	//w			Width of table
	//h			Height of table
	//nc			Number column
	//nr			Number row
	//hr			List of height of each row
	//wc			List of width of each column
	//cells		List of cells of each rows, cells[i][j] is a cell in the table
	function _tableColumnWidth(&$table, $firstpass = false)
	{
		$cs = &$table['cells'];

		$nc = $table['nc'];
		$nr = $table['nr'];
		$listspan = array();

		if ($table['borders_separate']) {
			$tblbw = $table['border_details']['L']['w'] + $table['border_details']['R']['w'] + $table['margin']['L'] + $table['margin']['R'] + $table['padding']['L'] + $table['padding']['R'] + $table['border_spacing_H'];
		} else {
			$tblbw = $table['max_cell_border_width']['L'] / 2 + $table['max_cell_border_width']['R'] / 2 + $table['margin']['L'] + $table['margin']['R'];
		}

		// ADDED table['l'][colno]
		// = total length of text approx (using $c['s']) in that column - used to approximately distribute col widths in _tableWidth
		//
	for ($j = 0; $j < $nc; $j++) { //columns
			$wc = &$table['wc'][$j];
			for ($i = 0; $i < $nr; $i++) { //rows
				if (isset($cs[$i][$j]) && $cs[$i][$j]) {
					$c = &$cs[$i][$j];

					if ($this->simpleTables) {
						if ($table['borders_separate']) { // NB twice border width
							$extrcw = $table['simple']['border_details']['L']['w'] + $table['simple']['border_details']['R']['w'] + $c['padding']['L'] + $c['padding']['R'] + $table['border_spacing_H'];
						} else {
							$extrcw = $table['simple']['border_details']['L']['w'] / 2 + $table['simple']['border_details']['R']['w'] / 2 + $c['padding']['L'] + $c['padding']['R'];
						}
					} else {
						if ($this->packTableData) {
							list($bt, $br, $bb, $bl) = $this->_getBorderWidths($c['borderbin']);
						} else {
							$br = $c['border_details']['R']['w'];
							$bl = $c['border_details']['L']['w'];
						}
						if ($table['borders_separate']) { // NB twice border width
							$extrcw = $bl + $br + $c['padding']['L'] + $c['padding']['R'] + $table['border_spacing_H'];
						} else {
							$extrcw = $bl / 2 + $br / 2 + $c['padding']['L'] + $c['padding']['R'];
						}
					}

					//$mw = $this->GetStringWidth('W') + $extrcw ;
					$mw = $extrcw; // mPDF 6
					if (substr($c['a'], 0, 1) == 'D') {
						$mw = $table['decimal_align'][$j]['maxs0'] + $table['decimal_align'][$j]['maxs1'] + $extrcw;
					}

					$c['absmiw'] = $mw;

					if (isset($c['R']) && $c['R']) {
						$c['maw'] = $c['miw'] = $this->FontSize + $extrcw;
						if (isset($c['w'])) { // If cell width is specified
							if ($c['miw'] < $c['w']) {
								$c['miw'] = $c['w'];
							}
						}
						if (!isset($c['colspan'])) {
							if ($wc['miw'] < $c['miw']) {
								$wc['miw'] = $c['miw'];
							}
							if ($wc['maw'] < $c['maw']) {
								$wc['maw'] = $c['maw'];
							}

							if ($firstpass) {
								if (isset($table['l'][$j])) {
									$table['l'][$j] += $c['miw'];
								} else {
									$table['l'][$j] = $c['miw'];
								}
							}
						}
						if ($c['miw'] > $wc['miw']) {
							$wc['miw'] = $c['miw'];
						}
						if ($wc['miw'] > $wc['maw']) {
							$wc['maw'] = $wc['miw'];
						}
						continue;
					}

					if ($firstpass) {
						if (isset($c['s'])) {
							$c['s'] += $extrcw;
						}
						if (isset($c['maxs'])) {
							$c['maxs'] += $extrcw;
						}
						if (isset($c['nestedmiw'])) {
							$c['nestedmiw'] += $extrcw;
						}
						if (isset($c['nestedmaw'])) {
							$c['nestedmaw'] += $extrcw;
						}
					}


					// If minimum width has already been set by a nested table or inline object (image/form), use it
					if (isset($c['nestedmiw']) && (!isset($this->table[1][1]['overflow']) || $this->table[1][1]['overflow'] != 'visible')) {
						$miw = $c['nestedmiw'];
					} else {
						$miw = $mw;
					}

					if (isset($c['maxs']) && $c['maxs'] != '') {
						$c['s'] = $c['maxs'];
					}

					// If maximum width has already been set by a nested table, use it
					if (isset($c['nestedmaw'])) {
						$c['maw'] = $c['nestedmaw'];
					} else
						$c['maw'] = $c['s'];

					if (isset($table['overflow']) && $table['overflow'] == 'visible' && $table['level'] == 1) {
						if (($c['maw'] + $tblbw) > $this->blk[$this->blklvl]['inner_width']) {
							$c['maw'] = $this->blk[$this->blklvl]['inner_width'] - $tblbw;
						}
					}

					if (isset($c['nowrap']) && $c['nowrap']) {
						$miw = $c['maw'];
					}

					if (isset($c['wpercent']) && $firstpass) {
						if (isset($c['colspan'])) { // Not perfect - but % set on colspan is shared equally on cols.
							for ($k = 0; $k < $c['colspan']; $k++) {
								$table['wc'][($j + $k)]['wpercent'] = $c['wpercent'] / $c['colspan'];
							}
						} else {
							if (isset($table['w']) && $table['w']) {
								$c['w'] = $c['wpercent'] / 100 * ($table['w'] - $tblbw );
							}
							$wc['wpercent'] = $c['wpercent'];
						}
					}

					if (isset($table['overflow']) && $table['overflow'] == 'visible' && $table['level'] == 1) {
						if (isset($c['w']) && ($c['w'] + $tblbw) > $this->blk[$this->blklvl]['inner_width']) {
							$c['w'] = $this->blk[$this->blklvl]['inner_width'] - $tblbw;
						}
					}


					if (isset($c['w'])) { // If cell width is specified
						if ($miw < $c['w']) {
							$c['miw'] = $c['w'];
						} // Cell min width = that specified
						if ($miw > $c['w']) {
							$c['miw'] = $c['w'] = $miw;
						} // If width specified is less than minimum allowed (W) increase it
						// mPDF 5.7.4  Do not set column width in colspan
						// cf. http://www.mpdf1.com/forum/discussion/2221/colspan-bug
						if (!isset($c['colspan'])) {
							if (!isset($wc['w'])) {
								$wc['w'] = 1;
							}  // If the Col width is not specified = set it to 1
						}
						// mPDF 5.7.3  cf. http://www.mpdf1.com/forum/discussion/1648/nested-table-bug-
						$c['maw'] = $c['w'];
					} else {
						$c['miw'] = $miw;
					} // If cell width not specified -> set Cell min width it to minimum allowed (W)

					if (isset($c['miw']) && $c['maw'] < $c['miw']) {
						$c['maw'] = $c['miw'];
					} // If Cell max width < Minwidth - increase it to =
					if (!isset($c['colspan'])) {
						if (isset($c['miw']) && $wc['miw'] < $c['miw']) {
							$wc['miw'] = $c['miw'];
						} // Update Col Minimum and maximum widths
						if ($wc['maw'] < $c['maw']) {
							$wc['maw'] = $c['maw'];
						}
						if ((isset($wc['absmiw']) && $wc['absmiw'] < $c['absmiw']) || !isset($wc['absmiw'])) {
							$wc['absmiw'] = $c['absmiw'];
						} // Update Col Minimum and maximum widths

						if (isset($table['l'][$j])) {
							$table['l'][$j] += $c['s'];
						} else {
							$table['l'][$j] = $c['s'];
						}
					} else {
						$listspan[] = array($i, $j);
					}

					//Check if minimum width of the whole column is big enough for largest word to fit
					// mPDF 6
					if (isset($c['textbuffer'])) {
						if (isset($table['overflow']) && $table['overflow'] == 'wrap') {
							$letter = true;
						} // check for maximum width of letters
						else {
							$letter = false;
						}
						$minwidth = $this->TableCheckMinWidth($wc['miw'] - $extrcw, 0, $c['textbuffer'], $letter);
					} else {
						$minwidth = 0;
					}
					if ($minwidth < 0) {
						//increase minimum width
						if (!isset($c['colspan'])) {
							$wc['miw'] = max($wc['miw'], ((-$minwidth) + $extrcw));
						} else {
							$c['miw'] = max($c['miw'], ((-$minwidth) + $extrcw));
						}
					}
					if (!isset($c['colspan'])) {
						if ($wc['miw'] > $wc['maw']) {
							$wc['maw'] = $wc['miw'];
						} //update maximum width, if needed
					}
				}
				unset($c);
			}//rows
		}//columns
		// COLUMN SPANS
		$wc = &$table['wc'];
		foreach ($listspan as $span) {
			list($i, $j) = $span;
			$c = &$cs[$i][$j];
			$lc = $j + $c['colspan'];
			if ($lc > $nc) {
				$lc = $nc;
			}
			$wis = $wisa = 0;
			$was = $wasa = 0;
			$list = array();
			for ($k = $j; $k < $lc; $k++) {
				if (isset($table['l'][$k])) {
					if ($c['R']) {
						$table['l'][$k] += $c['miw'] / $c['colspan'];
					} else {
						$table['l'][$k] += $c['s'] / $c['colspan'];
					}
				} else {
					if ($c['R']) {
						$table['l'][$k] = $c['miw'] / $c['colspan'];
					} else {
						$table['l'][$k] = $c['s'] / $c['colspan'];
					}
				}
				$wis += $wc[$k]['miw'];   // $wis is the sum of the column miw in the colspan
				$was += $wc[$k]['maw'];   // $was is the sum of the column maw in the colspan
				if (!isset($c['w'])) {
					$list[] = $k;
					$wisa += $wc[$k]['miw']; // $wisa is the sum of the column miw in cells with no width specified in the colspan
					$wasa += $wc[$k]['maw']; // $wasa is the sum of the column maw in cells with no width specified in the colspan
				}
			}
			if ($c['miw'] > $wis) {
				if (!$wis) {
					for ($k = $j; $k < $lc; $k++) {
						$wc[$k]['miw'] = $c['miw'] / $c['colspan'];
					}
				} elseif (!count($list)) {
					$wi = $c['miw'] - $wis;
					for ($k = $j; $k < $lc; $k++) {
						$wc[$k]['miw'] += ($wc[$k]['miw'] / $wis) * $wi;
					}
				} else {
					$wi = $c['miw'] - $wis;
					// mPDF 5.7.2   Extra min width distributed proportionately to all cells in colspan without a specified width
					// cf. http://www.mpdf1.com/forum/discussion/1607#Item_4
					foreach ($list as $k) {
						if (!isset($wc[$k]['w']) || !$wc[$k]['w'])
							$wc[$k]['miw'] += ($wc[$k]['miw'] / $wisa) * $wi;
					} // mPDF 5.7.2
				}
			}
			if ($c['maw'] > $was) {
				if (!$wis) {
					for ($k = $j; $k < $lc; $k++) {
						$wc[$k]['maw'] = $c['maw'] / $c['colspan'];
					}
				} elseif (!count($list)) {
					$wi = $c['maw'] - $was;
					for ($k = $j; $k < $lc; $k++) {
						$wc[$k]['maw'] += ($wc[$k]['maw'] / $was) * $wi;
					}
				} else {
					$wi = $c['maw'] - $was;
					// mPDF 5.7.4  Extra max width distributed evenly to all cells in colspan without a specified width
					// cf. http://www.mpdf1.com/forum/discussion/2221/colspan-bug
					foreach ($list as $k) {
						$wc[$k]['maw'] += $wi / count($list);
					}
				}
			}
			unset($c);
		}

		$checkminwidth = 0;
		$checkmaxwidth = 0;
		$totallength = 0;

		for ($i = 0; $i < $nc; $i++) {
			$checkminwidth += $table['wc'][$i]['miw'];
			$checkmaxwidth += $table['wc'][$i]['maw'];
			$totallength += $table['l'][$i];
		}

		if (!isset($table['w']) && $firstpass) {
			$sumpc = 0;
			$notset = 0;
			for ($i = 0; $i < $nc; $i++) {
				if (isset($table['wc'][$i]['wpercent']) && $table['wc'][$i]['wpercent']) {
					$sumpc += $table['wc'][$i]['wpercent'];
				} else {
					$notset++;
				}
			}

			// If sum of widths as %  >= 100% and not all columns are set
			// Set a nominal width of 1% for unset columns
			if ($sumpc >= 100 && $notset) {
				for ($i = 0; $i < $nc; $i++) {
					if ((!isset($table['wc'][$i]['wpercent']) || !$table['wc'][$i]['wpercent']) &&
						(!isset($table['wc'][$i]['w']) || !$table['wc'][$i]['w'])) {
						$table['wc'][$i]['wpercent'] = 1;
					}
				}
			}


			if ($sumpc) { // if any percents are set
				$sumnonpc = (100 - $sumpc);
				$sumpc = max($sumpc, 100);
				$miwleft = 0;
				$miwleftcount = 0;
				$miwsurplusnonpc = 0;
				$maxcalcmiw = 0;
				$mawleft = 0;
				$mawleftcount = 0;
				$mawsurplusnonpc = 0;
				$maxcalcmaw = 0;
				$mawnon = 0;
				$miwnon = 0;
				for ($i = 0; $i < $nc; $i++) {
					if (isset($table['wc'][$i]['wpercent'])) {
						$maxcalcmiw = max($maxcalcmiw, ($table['wc'][$i]['miw'] * $sumpc / $table['wc'][$i]['wpercent']));
						$maxcalcmaw = max($maxcalcmaw, ($table['wc'][$i]['maw'] * $sumpc / $table['wc'][$i]['wpercent']));
					} else {
						$miwleft += $table['wc'][$i]['miw'];
						$mawleft += $table['wc'][$i]['maw'];
						if (!isset($table['wc'][$i]['w'])) {
							$miwleftcount++;
							$mawleftcount++;
						}
					}
				}
				if ($miwleft && $sumnonpc > 0) {
					$miwnon = $miwleft * 100 / $sumnonpc;
				}
				if ($mawleft && $sumnonpc > 0) {
					$mawnon = $mawleft * 100 / $sumnonpc;
				}
				if (($miwnon > $checkminwidth || $maxcalcmiw > $checkminwidth) && $this->keep_table_proportions) {
					if ($miwnon > $maxcalcmiw) {
						$miwsurplusnonpc = round((($miwnon * $sumnonpc / 100) - $miwleft), 3);
						$checkminwidth = $miwnon;
					} else {
						$checkminwidth = $maxcalcmiw;
					}
					for ($i = 0; $i < $nc; $i++) {
						if (isset($table['wc'][$i]['wpercent'])) {
							$newmiw = $checkminwidth * $table['wc'][$i]['wpercent'] / 100;
							if ($table['wc'][$i]['miw'] < $newmiw) {
								$table['wc'][$i]['miw'] = $newmiw;
							}
							$table['wc'][$i]['w'] = 1;
						} elseif ($miwsurplusnonpc && !$table['wc'][$i]['w']) {
							$table['wc'][$i]['miw'] += $miwsurplusnonpc / $miwleftcount;
						}
					}
				}
				if (($mawnon > $checkmaxwidth || $maxcalcmaw > $checkmaxwidth)) {
					if ($mawnon > $maxcalcmaw) {
						$mawsurplusnonpc = round((($mawnon * $sumnonpc / 100) - $mawleft), 3);
						$checkmaxwidth = $mawnon;
					} else {
						$checkmaxwidth = $maxcalcmaw;
					}
					for ($i = 0; $i < $nc; $i++) {
						if (isset($table['wc'][$i]['wpercent'])) {
							$newmaw = $checkmaxwidth * $table['wc'][$i]['wpercent'] / 100;
							if ($table['wc'][$i]['maw'] < $newmaw) {
								$table['wc'][$i]['maw'] = $newmaw;
							}
							$table['wc'][$i]['w'] = 1;
						} elseif ($mawsurplusnonpc && !$table['wc'][$i]['w']) {
							$table['wc'][$i]['maw'] += $mawsurplusnonpc / $mawleftcount;
						}
						if ($table['wc'][$i]['maw'] < $table['wc'][$i]['miw']) {
							$table['wc'][$i]['maw'] = $table['wc'][$i]['miw'];
						}
					}
				}
				if ($checkminwidth > $checkmaxwidth) {
					$checkmaxwidth = $checkminwidth;
				}
			}
		}

		if (isset($table['wpercent']) && $table['wpercent']) {
			$checkminwidth *= (100 / $table['wpercent']);
			$checkmaxwidth *= (100 / $table['wpercent']);
		}


		$checkminwidth += $tblbw;
		$checkmaxwidth += $tblbw;

		// Table['miw'] set by percent in first pass may be larger than sum of column miw
		if ((isset($table['miw']) && $checkminwidth > $table['miw']) || !isset($table['miw'])) {
			$table['miw'] = $checkminwidth;
		}
		if ((isset($table['maw']) && $checkmaxwidth > $table['maw']) || !isset($table['maw'])) {
			$table['maw'] = $checkmaxwidth;
		}
		$table['tl'] = $totallength;


		// mPDF 6
		if ($this->table_rotate) {
			$mxw = $this->tbrot_maxw;
		} else {
			$mxw = $this->blk[$this->blklvl]['inner_width'];
		}
		if (!isset($table['overflow'])) {
			$table['overflow'] = null;
		}
		if ($table['overflow'] == 'visible') {
			return array(0, 0);
		} elseif ($table['overflow'] == 'hidden' && !$this->table_rotate && !$this->ColActive && $checkminwidth > $mxw) {
			$table['w'] = $table['miw'];
			return array(0, 0);
		}
		//elseif ($table['overflow']=='wrap') { return array(0,0); }	// mPDF 6

		if (isset($table['w']) && $table['w']) {
			if ($table['w'] >= $checkminwidth && $table['w'] <= $mxw) {
				$table['maw'] = $mxw = $table['w'];
			} elseif ($table['w'] >= $checkminwidth && $table['w'] > $mxw && $this->keep_table_proportions) {
				$checkminwidth = $table['w'];
			} elseif ($table['w'] < $checkminwidth && $checkminwidth < $mxw && $this->keep_table_proportions) {
				$table['maw'] = $table['w'] = $checkminwidth;
			} // mPDF 5.7.4
			else {
				unset($table['w']);
			}
		}
		$ratio = $checkminwidth / $mxw;
		if ($checkminwidth > $mxw) {
			return array(($ratio + 0.001), $checkminwidth);
		} // 0.001 to allow for rounded numbers when resizing
		unset($cs);
		return array(0, 0);
	}

	function _tableWidth(&$table)
	{
		$widthcols = &$table['wc'];
		$numcols = $table['nc'];
		$tablewidth = 0;
		if ($table['borders_separate']) {
			$tblbw = $table['border_details']['L']['w'] + $table['border_details']['R']['w'] + $table['margin']['L'] + $table['margin']['R'] + $table['padding']['L'] + $table['padding']['R'] + $table['border_spacing_H'];
		} else {
			$tblbw = $table['max_cell_border_width']['L'] / 2 + $table['max_cell_border_width']['R'] / 2 + $table['margin']['L'] + $table['margin']['R'];
		}

		if ($table['level'] > 1 && isset($table['w'])) {
			if (isset($table['wpercent']) && $table['wpercent']) {
				$table['w'] = $temppgwidth = (($table['w'] - $tblbw) * $table['wpercent'] / 100) + $tblbw;
			} else {
				$temppgwidth = $table['w'];
			}
		} elseif ($this->table_rotate) {
			$temppgwidth = $this->tbrot_maxw;
			// If it is less than 1/20th of the remaining page height to finish the DIV (i.e. DIV padding + table bottom margin)
			// then allow for this
			$enddiv = $this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['border_bottom']['w'];
			if ($enddiv / $temppgwidth < 0.05) {
				$temppgwidth -= $enddiv;
			}
		} else {
			if (isset($table['w']) && $table['w'] < $this->blk[$this->blklvl]['inner_width']) {
				$notfullwidth = 1;
				$temppgwidth = $table['w'];
			} elseif ($table['overflow'] == 'visible' && $table['level'] == 1) {
				$temppgwidth = null;
			} elseif ($table['overflow'] == 'hidden' && !$this->ColActive && isset($table['w']) && $table['w'] > $this->blk[$this->blklvl]['inner_width'] && $table['w'] == $table['miw']) {
				//$temppgwidth = $this->blk[$this->blklvl]['inner_width'];
				$temppgwidth = $table['w'];
			} else {
				$temppgwidth = $this->blk[$this->blklvl]['inner_width'];
			}
		}


		$totaltextlength = 0; // Added - to sum $table['l'][colno]
		$totalatextlength = 0; // Added - to sum $table['l'][colno] for those columns where width not set
		$percentages_set = 0;
		for ($i = 0; $i < $numcols; $i++) {
			if (isset($widthcols[$i]['wpercent'])) {
				$tablewidth += $widthcols[$i]['maw'];
				$percentages_set = 1;
			} elseif (isset($widthcols[$i]['w'])) {
				$tablewidth += $widthcols[$i]['miw'];
			} else {
				$tablewidth += $widthcols[$i]['maw'];
			}
			$totaltextlength += $table['l'][$i];
		}
		if (!$totaltextlength) {
			$totaltextlength = 1;
		}
		$tablewidth += $tblbw; // Outer half of table borders

		if ($tablewidth > $temppgwidth) {
			$table['w'] = $temppgwidth;
		}
		// if any widths set as percentages and max width fits < page width
		elseif ($tablewidth < $temppgwidth && !isset($table['w']) && $percentages_set) {
			$table['w'] = $table['maw'];
		}
		// if table width is set and is > allowed width
		if (isset($table['w']) && $table['w'] > $temppgwidth) {
			$table['w'] = $temppgwidth;
		}

		// IF the table width is now set - Need to distribute columns widths
		// mPDF 5.7.3
		// If the table width is already set to the maximum width (e.g. nested table), then use maximum column widths exactly
		if (isset($table['w']) && ($table['w'] == $tablewidth) && !$percentages_set) {
			// This sets the columns all to maximum width
			for ($i = 0; $i < $numcols; $i++) {
				$widthcols[$i] = $widthcols[$i]['maw'];
			}
		}
		// elseif the table width is set distribute width using algorithm
		elseif (isset($table['w'])) {
			$wis = $wisa = 0;
			$list = array();
			$notsetlist = array();
			for ($i = 0; $i < $numcols; $i++) {
				$wis += $widthcols[$i]['miw'];
				if (!isset($widthcols[$i]['w']) || ($widthcols[$i]['w'] && $table['w'] > $temppgwidth && !$this->keep_table_proportions && !$notfullwidth )) {
					$list[] = $i;
					$wisa += $widthcols[$i]['miw'];
					$totalatextlength += $table['l'][$i];
				}
			}
			if (!$totalatextlength) {
				$totalatextlength = 1;
			}

			// Allocate spare (more than col's minimum width) across the cols according to their approx total text length
			// Do it by setting minimum width here
			if ($table['w'] > $wis + $tblbw) {
				// First set any cell widths set as percentages
				if ($table['w'] < $temppgwidth || $this->keep_table_proportions) {
					for ($k = 0; $k < $numcols; $k++) {
						if (isset($widthcols[$k]['wpercent'])) {
							$curr = $widthcols[$k]['miw'];
							$widthcols[$k]['miw'] = ($table['w'] - $tblbw) * $widthcols[$k]['wpercent'] / 100;
							$wis += $widthcols[$k]['miw'] - $curr;
							$wisa += $widthcols[$k]['miw'] - $curr;
						}
					}
				}
				// Now allocate surplus up to maximum width of each column
				$surplus = 0;
				$ttl = 0; // number of surplus columns
				if (!count($list)) {
					$wi = ($table['w'] - ($wis + $tblbw)); //	i.e. extra space to distribute
					for ($k = 0; $k < $numcols; $k++) {
						$spareratio = ($table['l'][$k] / $totaltextlength); //  gives ratio to divide up free space
						// Don't allocate more than Maximum required width - save rest in surplus
						if ($widthcols[$k]['miw'] + ($wi * $spareratio) >= $widthcols[$k]['maw']) { // mPDF 5.7.3
							$surplus += ($wi * $spareratio) - ($widthcols[$k]['maw'] - $widthcols[$k]['miw']);
							$widthcols[$k]['miw'] = $widthcols[$k]['maw'];
						} else {
							$notsetlist[] = $k;
							$ttl += $table['l'][$k];
							$widthcols[$k]['miw'] += ($wi * $spareratio);
						}
					}
				} else {
					$wi = ($table['w'] - ($wis + $tblbw)); //	i.e. extra space to distribute
					foreach ($list as $k) {
						$spareratio = ($table['l'][$k] / $totalatextlength); //  gives ratio to divide up free space
						// Don't allocate more than Maximum required width - save rest in surplus
						if ($widthcols[$k]['miw'] + ($wi * $spareratio) >= $widthcols[$k]['maw']) { // mPDF 5.7.3
							$surplus += ($wi * $spareratio) - ($widthcols[$k]['maw'] - $widthcols[$k]['miw']);
							$widthcols[$k]['miw'] = $widthcols[$k]['maw'];
						} else {
							$notsetlist[] = $k;
							$ttl += $table['l'][$k];
							$widthcols[$k]['miw'] += ($wi * $spareratio);
						}
					}
				}
				// If surplus still left over apportion it across columns
				if ($surplus) {
					// if some are set only add to remaining - otherwise add to all of them
					if (count($notsetlist) && count($notsetlist) < $numcols) {
						foreach ($notsetlist AS $i) {
							if ($ttl)
								$widthcols[$i]['miw'] += $surplus * $table['l'][$i] / $ttl;
						}
					}
					// If some widths are defined, and others have been added up to their maxmum
					elseif (count($list) && count($list) < $numcols) {
						foreach ($list AS $i) {
							$widthcols[$i]['miw'] += $surplus / count($list);
						}
					} elseif ($numcols) { // If all columns
						$ttl = array_sum($table['l']);
						for ($i = 0; $i < $numcols; $i++) {
							$widthcols[$i]['miw'] += $surplus * $table['l'][$i] / $ttl;
						}
					}
				}
			}

			// This sets the columns all to minimum width (which has been increased above if appropriate)
			for ($i = 0; $i < $numcols; $i++) {
				$widthcols[$i] = $widthcols[$i]['miw'];
			}

			// TABLE NOT WIDE ENOUGH EVEN FOR MINIMUM CONTENT WIDTH
			// If sum of column widths set are too wide for table
			$checktablewidth = 0;
			for ($i = 0; $i < $numcols; $i++) {
				$checktablewidth += $widthcols[$i];
			}
			if ($checktablewidth > ($temppgwidth + 0.001 - $tblbw)) {
				$usedup = 0;
				$numleft = 0;
				for ($i = 0; $i < $numcols; $i++) {
					if ((isset($widthcols[$i]) && $widthcols[$i] > (($temppgwidth - $tblbw) / $numcols)) && (!isset($widthcols[$i]['w']))) {
						$numleft++;
						unset($widthcols[$i]);
					} else {
						$usedup += $widthcols[$i];
					}
				}
				for ($i = 0; $i < $numcols; $i++) {
					if (!isset($widthcols[$i]) || !$widthcols[$i]) {
						$widthcols[$i] = ((($temppgwidth - $tblbw) - $usedup) / ($numleft));
					}
				}
			}
		} else { //table has no width defined
			$table['w'] = $tablewidth;
			for ($i = 0; $i < $numcols; $i++) {
				if (isset($widthcols[$i]['wpercent']) && $this->keep_table_proportions) {
					$colwidth = $widthcols[$i]['maw'];
				} elseif (isset($widthcols[$i]['w'])) {
					$colwidth = $widthcols[$i]['miw'];
				} else {
					$colwidth = $widthcols[$i]['maw'];
				}
				unset($widthcols[$i]);
				$widthcols[$i] = $colwidth;
			}
		}

		if ($table['overflow'] == 'visible' && $table['level'] == 1) {
			if ($tablewidth > $this->blk[$this->blklvl]['inner_width']) {
				for ($j = 0; $j < $numcols; $j++) { //columns
					for ($i = 0; $i < $table['nr']; $i++) { //rows
						if (isset($table['cells'][$i][$j]) && $table['cells'][$i][$j]) {
							$colspan = (isset($table['cells'][$i][$j]['colspan']) ? $table['cells'][$i][$j]['colspan'] : 1);
							if ($colspan > 1) {
								$w = 0;
								for ($c = $j; $c < ($j + $colspan); $c++) {
									$w += $widthcols[$c];
								}
								if ($w > $this->blk[$this->blklvl]['inner_width']) {
									$diff = $w - ($this->blk[$this->blklvl]['inner_width'] - $tblbw);
									for ($c = $j; $c < ($j + $colspan); $c++) {
										$widthcols[$c] -= $diff * ($widthcols[$c] / $w);
									}
									$table['w'] -= $diff;
									$table['csp'][$j] = $w - $diff;
								}
							}
						}
					}
				}
			}
			$pgNo = 0;
			$currWc = 0;
			for ($i = 0; $i < $numcols; $i++) { //columns
				if (isset($table['csp'][$i])) {
					$w = $table['csp'][$i];
					unset($table['csp'][$i]);
				} else {
					$w = $widthcols[$i];
				}
				if (($currWc + $w + $tblbw) > $this->blk[$this->blklvl]['inner_width']) {
					$pgNo++;
					$currWc = $widthcols[$i];
				} else {
					$currWc += $widthcols[$i];
				}
				$table['colPg'][$i] = $pgNo;
			}
		}
	}

	function _tableHeight(&$table)
	{
		$level = $table['level'];
		$levelid = $table['levelid'];
		$cells = &$table['cells'];
		$numcols = $table['nc'];
		$numrows = $table['nr'];
		$listspan = array();
		$checkmaxheight = 0;
		$headerrowheight = 0;
		$checkmaxheightplus = 0;
		$headerrowheightplus = 0;
		$firstrowheight = 0;

		$footerrowheight = 0;
		$footerrowheightplus = 0;
		if ($this->table_rotate) {
			$temppgheight = $this->tbrot_maxh;
			$remainingpage = $this->tbrot_maxh;
		} else {
			$temppgheight = ($this->h - $this->bMargin - $this->tMargin) - $this->kwt_height;
			$remainingpage = ($this->h - $this->bMargin - $this->y) - $this->kwt_height;

			// If it is less than 1/20th of the remaining page height to finish the DIV (i.e. DIV padding + table bottom margin)
			// then allow for this
			$enddiv = $this->blk[$this->blklvl]['padding_bottom'] + $this->blk[$this->blklvl]['border_bottom']['w'] + $table['margin']['B'];
			if ($remainingpage > $enddiv && $enddiv / $remainingpage < 0.05) {
				$remainingpage -= $enddiv;
			} elseif ($remainingpage == 0) {
				$remainingpage = 0.001;
			}
			if ($temppgheight > $enddiv && $enddiv / $temppgheight < 0.05) {
				$temppgheight -= $enddiv;
			} elseif ($temppgheight == 0) {
				$temppgheight = 0.001;
			}
		}
		if ($remainingpage < 0) {
			$remainingpage = 0.001;
		}
		if ($temppgheight < 0) {
			$temppgheight = 0.001;
		}

		for ($i = 0; $i < $numrows; $i++) { //rows
			$heightrow = &$table['hr'][$i];
			for ($j = 0; $j < $numcols; $j++) { //columns
				if (isset($cells[$i][$j]) && $cells[$i][$j]) {
					$c = &$cells[$i][$j];

					if ($this->simpleTables) {
						if ($table['borders_separate']) { // NB twice border width
							$extraWLR = ($table['simple']['border_details']['L']['w'] + $table['simple']['border_details']['R']['w']) + ($c['padding']['L'] + $c['padding']['R']) + $table['border_spacing_H'];
							$extrh = ($table['simple']['border_details']['T']['w'] + $table['simple']['border_details']['B']['w']) + ($c['padding']['T'] + $c['padding']['B']) + $table['border_spacing_V'];
						} else {
							$extraWLR = ($table['simple']['border_details']['L']['w'] + $table['simple']['border_details']['R']['w']) / 2 + ($c['padding']['L'] + $c['padding']['R']);
							$extrh = ($table['simple']['border_details']['T']['w'] + $table['simple']['border_details']['B']['w']) / 2 + ($c['padding']['T'] + $c['padding']['B']);
						}
					} else {
						if ($this->packTableData) {
							list($bt, $br, $bb, $bl) = $this->_getBorderWidths($c['borderbin']);
						} else {
							$bt = $c['border_details']['T']['w'];
							$bb = $c['border_details']['B']['w'];
							$br = $c['border_details']['R']['w'];
							$bl = $c['border_details']['L']['w'];
						}
						if ($table['borders_separate']) { // NB twice border width
							$extraWLR = $bl + $br + $c['padding']['L'] + $c['padding']['R'] + $table['border_spacing_H'];
							$extrh = $bt + $bb + $c['padding']['T'] + $c['padding']['B'] + $table['border_spacing_V'];
						} else {
							$extraWLR = $bl / 2 + $br / 2 + $c['padding']['L'] + $c['padding']['R'];
							$extrh = $bt / 2 + $bb / 2 + $c['padding']['T'] + $c['padding']['B'];
						}
					}

					if ($table['overflow'] == 'visible' && $level == 1)
						list($x, $cw) = $this->_splitTableGetWidth($table, $i, $j);
					else
						list($x, $cw) = $this->_tableGetWidth($table, $i, $j);


					// Get CELL HEIGHT
					// ++ extra parameter forces wrap to break word
					if ($c['R'] && isset($c['textbuffer'])) {
						$str = '';
						foreach ($c['textbuffer'] AS $t) {
							$str .= $t[0] . ' ';
						}
						$str = rtrim($str);
						$s_fs = $this->FontSizePt;
						$s_f = $this->FontFamily;
						$s_st = $this->FontStyle;
						$this->SetFont($c['textbuffer'][0][4], $c['textbuffer'][0][2], $c['textbuffer'][0][11] / $this->shrin_k, true, true);
						$tempch = $this->GetStringWidth($str, true, $c['textbuffer'][0][18], $c['textbuffer'][0][8]);
						if ($c['R'] >= 45 && $c['R'] < 90) {
							$tempch = ((sin(deg2rad($c['R']))) * $tempch ) + ((sin(deg2rad($c['R']))) * (($c['textbuffer'][0][11] / _MPDFK) / $this->shrin_k));
						}
						$this->SetFont($s_f, $s_st, $s_fs, true, true);
						$ch = ($tempch ) + $extrh;
					} else {
						if (isset($c['textbuffer']) && !empty($c['textbuffer'])) {
							$this->cellLineHeight = $c['cellLineHeight'];
							$this->cellLineStackingStrategy = $c['cellLineStackingStrategy'];
							$this->cellLineStackingShift = $c['cellLineStackingShift'];
							$this->divwidth = $cw - $extraWLR;
							$tempch = $this->printbuffer($c['textbuffer'], '', true, true);
						} else {
							$tempch = 0;
						}

						// Added cellpadding top and bottom. (Lineheight already adjusted)
						$ch = $tempch + $extrh;
					}
					//If height is defined and it is bigger than calculated $ch then update values
					if (isset($c['h']) && $c['h'] > $ch) {
						$c['mih'] = $ch; //in order to keep valign working
						$ch = $c['h'];
					} else
						$c['mih'] = $ch;
					if (isset($c['rowspan']))
						$listspan[] = array($i, $j);
					elseif ($heightrow < $ch)
						$heightrow = $ch;

					// this is the extra used in _tableWrite to determine whether to trigger a page change
					if ($table['borders_separate']) {
						if ($i == ($numrows - 1) || (isset($c['rowspan']) && ($i + $c['rowspan']) == ($numrows))) {
							$extra = $table['margin']['B'] + $table['padding']['B'] + $table['border_details']['B']['w'] + $table['border_spacing_V'] / 2;
						} else {
							$extra = $table['border_spacing_V'] / 2;
						}
					} else {
						if (!$this->simpleTables) {
							$extra = $bb / 2;
						} elseif ($this->simpleTables) {
							$extra = $table['simple']['border_details']['B']['w'] / 2;
						}
					}
					if (isset($table['is_thead'][$i]) && $table['is_thead'][$i]) {
						if ($j == 0) {
							$headerrowheight += $ch;
							$headerrowheightplus += $ch + $extra;
						}
					} elseif (isset($table['is_tfoot'][$i]) && $table['is_tfoot'][$i]) {
						if ($j == 0) {
							$footerrowheight += $ch;
							$footerrowheightplus += $ch + $extra;
						}
					} else {
						$checkmaxheight = max($checkmaxheight, $ch);
						$checkmaxheightplus = max($checkmaxheightplus, $ch + $extra);
					}
					if ($this->tableLevel == 1 && $i == (isset($table['headernrows']) ? $table['headernrows'] : 0)) {
						$firstrowheight = max($ch, $firstrowheight);
					}
					unset($c);
				}
			}//end of columns
		}//end of rows

		$heightrow = &$table['hr'];
		foreach ($listspan as $span) {
			list($i, $j) = $span;
			$c = &$cells[$i][$j];
			$lr = $i + $c['rowspan'];
			if ($lr > $numrows)
				$lr = $numrows;
			$hs = $hsa = 0;
			$list = array();
			for ($k = $i; $k < $lr; $k++) {
				$hs += $heightrow[$k];
				// mPDF 6
				$sh = false; // specified height
				for ($m = 0; $m < $numcols; $m++) { //columns
					$tc = &$cells[$k][$m];
					if (isset($tc['rowspan'])) {
						continue;
					}
					if (isset($tc['h'])) {
						$sh = true;
						break;
					}
				}
				if (!$sh) {
					$list[] = $k;
				}
			}

			if ($table['borders_separate']) {
				if ($i == ($numrows - 1) || ($i + $c['rowspan']) == ($numrows)) {
					$extra = $table['margin']['B'] + $table['padding']['B'] + $table['border_details']['B']['w'] + $table['border_spacing_V'] / 2;
				} else {
					$extra = $table['border_spacing_V'] / 2;
				}
			} else {
				if (!$this->simpleTables) {
					if ($this->packTableData) {
						list($bt, $br, $bb, $bl) = $this->_getBorderWidths($c['borderbin']);
					} else {
						$bb = $c['border_details']['B']['w'];
					}
					$extra = $bb / 2;
				} elseif ($this->simpleTables) {
					$extra = $table['simple']['border_details']['B']['w'] / 2;
				}
			}
			if (!empty($table['is_thead'][$i])) {
				$headerrowheight = max($headerrowheight, $hs);
				$headerrowheightplus = max($headerrowheightplus, $hs + $extra);
			} elseif (!empty($table['is_tfoot'][$i])) {
				$footerrowheight = max($footerrowheight, $hs);
				$footerrowheightplus = max($footerrowheightplus, $hs + $extra);
			} else {
				$checkmaxheight = max($checkmaxheight, $hs);
				$checkmaxheightplus = max($checkmaxheightplus, $hs + $extra);
			}
			if ($this->tableLevel == 1 && $i == (isset($table['headernrows']) ? $table['headernrows'] : 0)) {
				$firstrowheight = max($hs, $firstrowheight);
			}

			if ($c['mih'] > $hs) {
				if (!$hs) {
					for ($k = $i; $k < $lr; $k++)
						$heightrow[$k] = $c['mih'] / $c['rowspan'];
				} elseif (!count($list)) { // no rows in the rowspan have a height specified, so share amongst all rows equally
					$hi = $c['mih'] - $hs;
					for ($k = $i; $k < $lr; $k++)
						$heightrow[$k] += ($heightrow[$k] / $hs) * $hi;
				} else {
					$hi = $c['mih'] - $hs; // mPDF 6
					foreach ($list as $k)
						$heightrow[$k] += $hi / (count($list)); // mPDF 6
				}
			}
			unset($c);

			// If rowspans overlap so that one or more rows do not have a height set...
			// i.e. for one or more rows, the only cells (explicit) in that row have rowspan>1
			// so heightrow is still == 0
			if ($heightrow[$i] == 0) {
				// Get row extent to analyse above and below
				$top = $i;
				foreach ($listspan as $checkspan) {
					list($cki, $ckj) = $checkspan;
					$c = &$cells[$cki][$ckj];
					if (isset($c['rowspan']) && $c['rowspan'] > 1) {
						if (($cki + $c['rowspan'] - 1) >= $i) {
							$top = min($top, $cki);
						}
					}
				}
				$bottom = $i + $c['rowspan'] - 1;
				// Check for overconstrained conditions
				for ($k = $top; $k <= $bottom; $k++) {
					// if ['hr'] for any of the others is also 0, then abort (too complicated)
					if ($k != $i && $heightrow[$k] == 0) {
						break(1);
					}
					// check again that top and bottom are not crossed by rowspans - or abort (too complicated)
					if ($k == $top) {
						// ???? take account of colspan as well???
						for ($m = 0; $m < $numcols; $m++) { //columns
							if (!isset($cells[$k][$m]) || $cells[$k][$m] == 0) {
								break(2);
							}
						}
					} elseif ($k == $bottom) {
						// ???? take account of colspan as well???
						for ($m = 0; $m < $numcols; $m++) { //columns
							$c = &$cells[$k][$m];
							if (isset($c['rowspan']) && $c['rowspan'] > 1) {
								break(2);
							}
						}
					}
				}
				// By columns add up col height using ['h'] if set or ['mih'] if not
				// Intentionally do not substract border-spacing
				$colH = array();
				$extH = 0;
				$newhr = array();
				for ($m = 0; $m < $numcols; $m++) { //columns
					for ($k = $top; $k <= $bottom; $k++) {
						if (isset($cells[$k][$m]) && $cells[$k][$m] != 0) {
							$c = &$cells[$k][$m];
							if (isset($c['h']) && $c['h']) {
								$useh = $c['h'];
							}
							// ???? take account of colspan as well???
							else {
								$useh = $c['mih'];
							}
							if (isset($colH[$m])) {
								$colH[$m] += $useh;
							} else {
								$colH[$m] = $useh;
							}
							if (!isset($c['rowspan']) || $c['rowspan'] < 2) {
								$newhr[$k] = max((isset($newhr[$k]) ? $newhr[$k] : 0), $useh);
							}
						}
					}
					$extH = max($extH, $colH[$m]); // mPDF 6
				}
				$newhr[$i] = $extH - array_sum($newhr);
				for ($k = $top; $k <= $bottom; $k++) {
					$heightrow[$k] = $newhr[$k];
				}
			}


			unset($c);
		}

		$table['h'] = array_sum($heightrow);
		unset($heightrow);

		if ($table['borders_separate']) {
			$table['h'] += $table['margin']['T'] + $table['margin']['B'] + $table['border_details']['T']['w'] + $table['border_details']['B']['w'] + $table['border_spacing_V'] + $table['padding']['T'] + $table['padding']['B'];
		} else {
			$table['h'] += $table['margin']['T'] + $table['margin']['B'] + $table['max_cell_border_width']['T'] / 2 + $table['max_cell_border_width']['B'] / 2;
		}

		$maxrowheight = $checkmaxheightplus + $headerrowheightplus + $footerrowheightplus;
		$maxfirstrowheight = $firstrowheight + $headerrowheightplus + $footerrowheightplus; // includes thead, 1st row and tfoot
		return array($table['h'], $maxrowheight, $temppgheight, $remainingpage, $maxfirstrowheight);
	}

	function _tableGetWidth(&$table, $i, $j)
	{
		$cell = &$table['cells'][$i][$j];
		if ($cell) {
			if (isset($cell['x0'])) {
				return array($cell['x0'], $cell['w0']);
			}
			$x = 0;
			$widthcols = &$table['wc'];
			for ($k = 0; $k < $j; $k++)
				$x += $widthcols[$k];
			$w = $widthcols[$j];
			if (isset($cell['colspan'])) {
				for ($k = $j + $cell['colspan'] - 1; $k > $j; $k--)
					$w += $widthcols[$k];
			}
			$cell['x0'] = $x;
			$cell['w0'] = $w;
			return array($x, $w);
		}
		return array(0, 0);
	}

	function _splitTableGetWidth(&$table, $i, $j)
	{
		$cell = &$table['cells'][$i][$j];
		if ($cell) {
			if (isset($cell['x0']))
				return array($cell['x0'], $cell['w0']);
			$x = 0;
			$widthcols = &$table['wc'];
			$pg = $table['colPg'][$j];
			for ($k = 0; $k < $j; $k++) {
				if ($table['colPg'][$k] == $pg)
					$x += $widthcols[$k];
			}
			$w = $widthcols[$j];
			if (isset($cell['colspan'])) {
				for ($k = $j + $cell['colspan'] - 1; $k > $j; $k--)
					if ($table['colPg'][$k] == $pg)
						$w += $widthcols[$k];
			}
			$cell['x0'] = $x;
			$cell['w0'] = $w;
			return array($x, $w);
		}
		return array(0, 0);
	}

	function _tableGetHeight(&$table, $i, $j)
	{
		$cell = &$table['cells'][$i][$j];
		if ($cell) {
			if (isset($cell['y0']))
				return array($cell['y0'], $cell['h0']);
			$y = 0;
			$heightrow = &$table['hr'];
			for ($k = 0; $k < $i; $k++)
				$y += $heightrow[$k];
			$h = $heightrow[$i];
			if (isset($cell['rowspan'])) {
				for ($k = $i + $cell['rowspan'] - 1; $k > $i; $k--)
					$h += $heightrow[$k];
			}
			$cell['y0'] = $y;
			$cell['h0'] = $h;
			return array($y, $h);
		}
		return array(0, 0);
	}

	function _tableGetMaxRowHeight($table, $row)
	{
		if ($row == $table['nc'] - 1) {
			return $table['hr'][$row];
		}
		$maxrowheight = $table['hr'][$row];
		for ($i = $row + 1; $i < $table['nr']; $i++) {
			$cellsset = 0;
			for ($j = 0; $j < $table['nc']; $j++) {
				if ($table['cells'][$i][$j]) {
					if (isset($table['cells'][$i][$j]['colspan'])) {
						$cellsset += $table['cells'][$i][$j]['colspan'];
					} else
						$cellsset += 1;
				}
			}
			if ($cellsset == $table['nc']) {
				return $maxrowheight;
			} else {
				$maxrowheight += $table['hr'][$i];
			}
		}
		return $maxrowheight;
	}

	// CHANGED TO ALLOW TABLE BORDER TO BE SPECIFIED CORRECTLY - added border_details
	function _tableRect($x, $y, $w, $h, $bord = -1, $details = array(), $buffer = false, $bSeparate = false, $cort = 'cell', $tablecorner = '', $bsv = 0, $bsh = 0)
	{
		$cellBorderOverlay = array();

		if ($bord == -1) {
			$this->Rect($x, $y, $w, $h);
		} elseif ($this->simpleTables && ($cort == 'cell')) {
			$this->SetLineWidth($details['L']['w']);
			if ($details['L']['c']) {
				$this->SetDColor($details['L']['c']);
			} else {
				$this->SetDColor($this->ConvertColor(0));
			}
			$this->SetLineJoin(0);
			$this->Rect($x, $y, $w, $h);
		} elseif ($bord) {
			if (!$bSeparate && $buffer) {
				$priority = 'LRTB';
				for ($p = 0; $p < strlen($priority); $p++) {
					$side = $priority[$p];
					$details['p'] = $side;

					$dom = 0;
					if (isset($details[$side]['w'])) {
						$dom += ($details[$side]['w'] * 100000);
					}
					if (isset($details[$side]['style'])) {
						$dom += (array_search($details[$side]['style'], $this->borderstyles) * 100);
					}
					if (isset($details[$side]['dom'])) {
						$dom += ($details[$side]['dom'] * 10);
					}

					// Precedence to darker colours at joins
					$coldom = 0;
					if (isset($details[$side]['c']) && is_array($details[$side]['c'])) {
						if ($details[$side]['c']{0} == 3) {  // RGB
							$coldom = 10 - (((ord($details[$side]['c']{1}) * 1.00) + (ord($details[$side]['c']{2}) * 1.00) + (ord($details[$side]['c']{3}) * 1.00)) / 76.5);
						}
					} // 10 black - 0 white
					if ($coldom) {
						$dom += $coldom;
					}
					// Lastly precedence to RIGHT and BOTTOM cells at joins
					if (isset($details['cellposdom'])) {
						$dom += $details['cellposdom'];
					}

					$save = false;
					if ($side == 'T' && $this->issetBorder($bord, _BORDER_TOP)) {
						$cbord = _BORDER_TOP;
						$save = true;
					} elseif ($side == 'L' && $this->issetBorder($bord, _BORDER_LEFT)) {
						$cbord = _BORDER_LEFT;
						$save = true;
					} elseif ($side == 'R' && $this->issetBorder($bord, _BORDER_RIGHT)) {
						$cbord = _BORDER_RIGHT;
						$save = true;
					} elseif ($side == 'B' && $this->issetBorder($bord, _BORDER_BOTTOM)) {
						$cbord = _BORDER_BOTTOM;
						$save = true;
					}

					if ($save) {
						$this->cellBorderBuffer[] = pack("A16nCnda6A10d14", str_pad(sprintf("%08.7f", $dom), 16, "0", STR_PAD_LEFT), $cbord, ord($side), $details[$side]['s'], $details[$side]['w'], $details[$side]['c'], $details[$side]['style'], $x, $y, $w, $h, $details['mbw']['BL'], $details['mbw']['BR'], $details['mbw']['RT'], $details['mbw']['RB'], $details['mbw']['TL'], $details['mbw']['TR'], $details['mbw']['LT'], $details['mbw']['LB'], $details['cellposdom'], 0
						);
						if ($details[$side]['style'] == 'ridge' || $details[$side]['style'] == 'groove' || $details[$side]['style'] == 'inset' || $details[$side]['style'] == 'outset' || $details[$side]['style'] == 'double') {
							$details[$side]['overlay'] = true;
							$this->cellBorderBuffer[] = pack("A16nCnda6A10d14", str_pad(sprintf("%08.7f", ($dom + 4)), 16, "0", STR_PAD_LEFT), $cbord, ord($side), $details[$side]['s'], $details[$side]['w'], $details[$side]['c'], $details[$side]['style'], $x, $y, $w, $h, $details['mbw']['BL'], $details['mbw']['BR'], $details['mbw']['RT'], $details['mbw']['RB'], $details['mbw']['TL'], $details['mbw']['TR'], $details['mbw']['LT'], $details['mbw']['LB'], $details['cellposdom'], 1
							);
						}
					}
				}
				return;
			}

			if (isset($details['p']) && strlen($details['p']) > 1) {
				$priority = $details['p'];
			} else {
				$priority = 'LTRB';
			}
			$Tw = 0;
			$Rw = 0;
			$Bw = 0;
			$Lw = 0;
			if (isset($details['T']['w'])) {
				$Tw = $details['T']['w'];
			}
			if (isset($details['R']['w'])) {
				$Rw = $details['R']['w'];
			}
			if (isset($details['B']['w'])) {
				$Bw = $details['B']['w'];
			}
			if (isset($details['L']['w'])) {
				$Lw = $details['L']['w'];
			}

			$x2 = $x + $w;
			$y2 = $y + $h;
			$oldlinewidth = $this->LineWidth;

			for ($p = 0; $p < strlen($priority); $p++) {
				$side = $priority[$p];
				$xadj = 0;
				$xadj2 = 0;
				$yadj = 0;
				$yadj2 = 0;
				$print = false;
				if ($Tw && $side == 'T' && $this->issetBorder($bord, _BORDER_TOP)) { // TOP
					$ly1 = $y;
					$ly2 = $y;
					$lx1 = $x;
					$lx2 = $x2;
					$this->SetLineWidth($Tw);
					if ($cort == 'cell' || strpos($tablecorner, 'L') !== false) {
						if ($Tw > $Lw)
							$xadj = ($Tw - $Lw) / 2;
						if ($Tw < $Lw)
							$xadj = ($Tw + $Lw) / 2;
					}
					else {
						$xadj = $Tw / 2 - $bsh / 2;
					}
					if ($cort == 'cell' || strpos($tablecorner, 'R') !== false) {
						if ($Tw > $Rw)
							$xadj2 = ($Tw - $Rw) / 2;
						if ($Tw < $Rw)
							$xadj2 = ($Tw + $Rw) / 2;
					}
					else {
						$xadj2 = $Tw / 2 - $bsh / 2;
					}
					if (!$bSeparate && $details['mbw']['TL']) {
						$xadj = ($Tw - $details['mbw']['TL']) / 2;
					}
					if (!$bSeparate && $details['mbw']['TR']) {
						$xadj2 = ($Tw - $details['mbw']['TR']) / 2;
					}
					$print = true;
				}
				if ($Lw && $side == 'L' && $this->issetBorder($bord, _BORDER_LEFT)) { // LEFT
					$ly1 = $y;
					$ly2 = $y2;
					$lx1 = $x;
					$lx2 = $x;
					$this->SetLineWidth($Lw);
					if ($cort == 'cell' || strpos($tablecorner, 'T') !== false) {
						if ($Lw > $Tw)
							$yadj = ($Lw - $Tw) / 2;
						if ($Lw < $Tw)
							$yadj = ($Lw + $Tw) / 2;
					}
					else {
						$yadj = $Lw / 2 - $bsv / 2;
					}
					if ($cort == 'cell' || strpos($tablecorner, 'B') !== false) {
						if ($Lw > $Bw)
							$yadj2 = ($Lw - $Bw) / 2;
						if ($Lw < $Bw)
							$yadj2 = ($Lw + $Bw) / 2;
					}
					else {
						$yadj2 = $Lw / 2 - $bsv / 2;
					}
					if (!$bSeparate && $details['mbw']['LT']) {
						$yadj = ($Lw - $details['mbw']['LT']) / 2;
					}
					if (!$bSeparate && $details['mbw']['LB']) {
						$yadj2 = ($Lw - $details['mbw']['LB']) / 2;
					}
					$print = true;
				}
				if ($Rw && $side == 'R' && $this->issetBorder($bord, _BORDER_RIGHT)) { // RIGHT
					$ly1 = $y;
					$ly2 = $y2;
					$lx1 = $x2;
					$lx2 = $x2;
					$this->SetLineWidth($Rw);
					if ($cort == 'cell' || strpos($tablecorner, 'T') !== false) {
						if ($Rw < $Tw)
							$yadj = ($Rw + $Tw) / 2;
						if ($Rw > $Tw)
							$yadj = ($Rw - $Tw) / 2;
					}
					else {
						$yadj = $Rw / 2 - $bsv / 2;
					}

					if ($cort == 'cell' || strpos($tablecorner, 'B') !== false) {
						if ($Rw > $Bw)
							$yadj2 = ($Rw - $Bw) / 2;
						if ($Rw < $Bw)
							$yadj2 = ($Rw + $Bw) / 2;
					}
					else {
						$yadj2 = $Rw / 2 - $bsv / 2;
					}

					if (!$bSeparate && $details['mbw']['RT']) {
						$yadj = ($Rw - $details['mbw']['RT']) / 2;
					}
					if (!$bSeparate && $details['mbw']['RB']) {
						$yadj2 = ($Rw - $details['mbw']['RB']) / 2;
					}
					$print = true;
				}
				if ($Bw && $side == 'B' && $this->issetBorder($bord, _BORDER_BOTTOM)) { // BOTTOM
					$ly1 = $y2;
					$ly2 = $y2;
					$lx1 = $x;
					$lx2 = $x2;
					$this->SetLineWidth($Bw);
					if ($cort == 'cell' || strpos($tablecorner, 'L') !== false) {
						if ($Bw > $Lw)
							$xadj = ($Bw - $Lw) / 2;
						if ($Bw < $Lw)
							$xadj = ($Bw + $Lw) / 2;
					}
					else {
						$xadj = $Bw / 2 - $bsh / 2;
					}
					if ($cort == 'cell' || strpos($tablecorner, 'R') !== false) {
						if ($Bw > $Rw)
							$xadj2 = ($Bw - $Rw) / 2;
						if ($Bw < $Rw)
							$xadj2 = ($Bw + $Rw) / 2;
					}
					else {
						$xadj2 = $Bw / 2 - $bsh / 2;
					}
					if (!$bSeparate && $details['mbw']['BL']) {
						$xadj = ($Bw - $details['mbw']['BL']) / 2;
					}
					if (!$bSeparate && $details['mbw']['BR']) {
						$xadj2 = ($Bw - $details['mbw']['BR']) / 2;
					}
					$print = true;
				}

				// Now draw line
				if ($print) {
					/* -- TABLES-ADVANCED-BORDERS -- */
					if ($details[$side]['style'] == 'double') {
						if (!isset($details[$side]['overlay']) || !$details[$side]['overlay'] || $bSeparate) {
							if ($details[$side]['c']) {
								$this->SetDColor($details[$side]['c']);
							} else {
								$this->SetDColor($this->ConvertColor(0));
							}
							$this->Line($lx1 + $xadj, $ly1 + $yadj, $lx2 - $xadj2, $ly2 - $yadj2);
						}
						if ((isset($details[$side]['overlay']) && $details[$side]['overlay']) || $bSeparate) {
							if ($bSeparate && $cort == 'table') {
								if ($side == 'T') {
									$xadj -= $this->LineWidth / 2;
									$xadj2 -= $this->LineWidth;
									if ($this->issetBorder($bord, _BORDER_LEFT)) {
										$xadj += $this->LineWidth / 2;
									}
									if ($this->issetBorder($bord, _BORDER_RIGHT)) {
										$xadj2 += $this->LineWidth;
									}
								}
								if ($side == 'L') {
									$yadj -= $this->LineWidth / 2;
									$yadj2 -= $this->LineWidth;
									if ($this->issetBorder($bord, _BORDER_TOP)) {
										$yadj += $this->LineWidth / 2;
									}
									if ($this->issetBorder($bord, _BORDER_BOTTOM)) {
										$yadj2 += $this->LineWidth;
									}
								}
								if ($side == 'B') {
									$xadj -= $this->LineWidth / 2;
									$xadj2 -= $this->LineWidth;
									if ($this->issetBorder($bord, _BORDER_LEFT)) {
										$xadj += $this->LineWidth / 2;
									}
									if ($this->issetBorder($bord, _BORDER_RIGHT)) {
										$xadj2 += $this->LineWidth;
									}
								}
								if ($side == 'R') {
									$yadj -= $this->LineWidth / 2;
									$yadj2 -= $this->LineWidth;
									if ($this->issetBorder($bord, _BORDER_TOP)) {
										$yadj += $this->LineWidth / 2;
									}
									if ($this->issetBorder($bord, _BORDER_BOTTOM)) {
										$yadj2 += $this->LineWidth;
									}
								}
							}

							$this->SetLineWidth($this->LineWidth / 3);

							$tbcol = $this->ConvertColor(255);
							for ($l = 0; $l <= $this->blklvl; $l++) {
								if ($this->blk[$l]['bgcolor']) {
									$tbcol = ($this->blk[$l]['bgcolorarray']);
								}
							}

							if ($bSeparate) {
								$cellBorderOverlay[] = array(
									'x' => $lx1 + $xadj,
									'y' => $ly1 + $yadj,
									'x2' => $lx2 - $xadj2,
									'y2' => $ly2 - $yadj2,
									'col' => $tbcol,
									'lw' => $this->LineWidth,
								);
							} else {
								$this->SetDColor($tbcol);
								$this->Line($lx1 + $xadj, $ly1 + $yadj, $lx2 - $xadj2, $ly2 - $yadj2);
							}
						}
					} elseif (isset($details[$side]['style']) && ($details[$side]['style'] == 'ridge' || $details[$side]['style'] == 'groove' || $details[$side]['style'] == 'inset' || $details[$side]['style'] == 'outset')) {
						if (!isset($details[$side]['overlay']) || !$details[$side]['overlay'] || $bSeparate) {
							if ($details[$side]['c']) {
								$this->SetDColor($details[$side]['c']);
							} else {
								$this->SetDColor($this->ConvertColor(0));
							}
							if ($details[$side]['style'] == 'outset' || $details[$side]['style'] == 'groove') {
								$nc = $this->_darkenColor($details[$side]['c']);
								$this->SetDColor($nc);
							} elseif ($details[$side]['style'] == 'ridge' || $details[$side]['style'] == 'inset') {
								$nc = $this->_lightenColor($details[$side]['c']);
								$this->SetDColor($nc);
							}
							$this->Line($lx1 + $xadj, $ly1 + $yadj, $lx2 - $xadj2, $ly2 - $yadj2);
						}
						if ((isset($details[$side]['overlay']) && $details[$side]['overlay']) || $bSeparate) {
							if ($details[$side]['c']) {
								$this->SetDColor($details[$side]['c']);
							} else {
								$this->SetDColor($this->ConvertColor(0));
							}
							$doubleadj = ($this->LineWidth) / 3;
							$this->SetLineWidth($this->LineWidth / 2);
							$xadj3 = $yadj3 = $wadj3 = $hadj3 = 0;

							if ($details[$side]['style'] == 'ridge' || $details[$side]['style'] == 'inset') {
								$nc = $this->_darkenColor($details[$side]['c']);

								if ($bSeparate && $cort == 'table') {
									if ($side == 'T') {
										$yadj3 = $this->LineWidth / 2;
										$xadj3 = -$this->LineWidth / 2;
										$wadj3 = $this->LineWidth;
										if ($this->issetBorder($bord, _BORDER_LEFT)) {
											$xadj3 += $this->LineWidth;
											$wadj3 -= $this->LineWidth;
										}
										if ($this->issetBorder($bord, _BORDER_RIGHT)) {
											$wadj3 -= $this->LineWidth * 2;
										}
									}
									if ($side == 'L') {
										$xadj3 = $this->LineWidth / 2;
										$yadj3 = -$this->LineWidth / 2;
										$hadj3 = $this->LineWidth;
										if ($this->issetBorder($bord, _BORDER_TOP)) {
											$yadj3 += $this->LineWidth;
											$hadj3 -= $this->LineWidth;
										}
										if ($this->issetBorder($bord, _BORDER_BOTTOM)) {
											$hadj3 -= $this->LineWidth * 2;
										}
									}
									if ($side == 'B') {
										$yadj3 = $this->LineWidth / 2;
										$xadj3 = -$this->LineWidth / 2;
										$wadj3 = $this->LineWidth;
									}
									if ($side == 'R') {
										$xadj3 = $this->LineWidth / 2;
										$yadj3 = -$this->LineWidth / 2;
										$hadj3 = $this->LineWidth;
									}
								} elseif ($side == 'T') {
									$yadj3 = $this->LineWidth / 2;
									$xadj3 = $this->LineWidth / 2;
									$wadj3 = -$this->LineWidth * 2;
								} elseif ($side == 'L') {
									$xadj3 = $this->LineWidth / 2;
									$yadj3 = $this->LineWidth / 2;
									$hadj3 = -$this->LineWidth * 2;
								} elseif ($side == 'B' && $bSeparate) {
									$yadj3 = $this->LineWidth / 2;
									$wadj3 = $this->LineWidth / 2;
								} elseif ($side == 'R' && $bSeparate) {
									$xadj3 = $this->LineWidth / 2;
									$hadj3 = $this->LineWidth / 2;
								} elseif ($side == 'B') {
									$yadj3 = $this->LineWidth / 2;
									$xadj3 = $this->LineWidth / 2;
								} elseif ($side == 'R') {
									$xadj3 = $this->LineWidth / 2;
									$yadj3 = $this->LineWidth / 2;
								}
							} else {
								$nc = $this->_lightenColor($details[$side]['c']);

								if ($bSeparate && $cort == 'table') {
									if ($side == 'T') {
										$yadj3 = $this->LineWidth / 2;
										$xadj3 = -$this->LineWidth / 2;
										$wadj3 = $this->LineWidth;
										if ($this->issetBorder($bord, _BORDER_LEFT)) {
											$xadj3 += $this->LineWidth;
											$wadj3 -= $this->LineWidth;
										}
									}
									if ($side == 'L') {
										$xadj3 = $this->LineWidth / 2;
										$yadj3 = -$this->LineWidth / 2;
										$hadj3 = $this->LineWidth;
										if ($this->issetBorder($bord, _BORDER_TOP)) {
											$yadj3 += $this->LineWidth;
											$hadj3 -= $this->LineWidth;
										}
									}
									if ($side == 'B') {
										$yadj3 = $this->LineWidth / 2;
										$xadj3 = -$this->LineWidth / 2;
										$wadj3 = $this->LineWidth;
										if ($this->issetBorder($bord, _BORDER_LEFT)) {
											$xadj3 += $this->LineWidth;
											$wadj3 -= $this->LineWidth;
										}
									}
									if ($side == 'R') {
										$xadj3 = $this->LineWidth / 2;
										$yadj3 = -$this->LineWidth / 2;
										$hadj3 = $this->LineWidth;
										if ($this->issetBorder($bord, _BORDER_TOP)) {
											$yadj3 += $this->LineWidth;
											$hadj3 -= $this->LineWidth;
										}
									}
								} elseif ($side == 'T') {
									$yadj3 = $this->LineWidth / 2;
									$xadj3 = $this->LineWidth / 2;
								} elseif ($side == 'L') {
									$xadj3 = $this->LineWidth / 2;
									$yadj3 = $this->LineWidth / 2;
								} elseif ($side == 'B' && $bSeparate) {
									$yadj3 = $this->LineWidth / 2;
									$xadj3 = $this->LineWidth / 2;
								} elseif ($side == 'R' && $bSeparate) {
									$xadj3 = $this->LineWidth / 2;
									$yadj3 = $this->LineWidth / 2;
								} elseif ($side == 'B') {
									$yadj3 = $this->LineWidth / 2;
									$xadj3 = -$this->LineWidth / 2;
									$wadj3 = $this->LineWidth;
								} elseif ($side == 'R') {
									$xadj3 = $this->LineWidth / 2;
									$yadj3 = -$this->LineWidth / 2;
									$hadj3 = $this->LineWidth;
								}
							}

							if ($bSeparate) {
								$cellBorderOverlay[] = array(
									'x' => $lx1 + $xadj + $xadj3,
									'y' => $ly1 + $yadj + $yadj3,
									'x2' => $lx2 - $xadj2 + $xadj3 + $wadj3,
									'y2' => $ly2 - $yadj2 + $yadj3 + $hadj3,
									'col' => $nc,
									'lw' => $this->LineWidth,
								);
							} else {
								$this->SetDColor($nc);
								$this->Line($lx1 + $xadj + $xadj3, $ly1 + $yadj + $yadj3, $lx2 - $xadj2 + $xadj3 + $wadj3, $ly2 - $yadj2 + $yadj3 + $hadj3);
							}
						}
					} else {
						/* -- END TABLES-ADVANCED-BORDERS -- */
						if ($details[$side]['style'] == 'dashed') {
							$dashsize = 2; // final dash will be this + 1*linewidth
							$dashsizek = 1.5; // ratio of Dash/Blank
							$this->SetDash($dashsize, ($dashsize / $dashsizek) + ($this->LineWidth * 2));
						} elseif ($details[$side]['style'] == 'dotted') {
							$this->SetLineJoin(1);
							$this->SetLineCap(1);
							$this->SetDash(0.001, ($this->LineWidth * 2));
						}
						if ($details[$side]['c']) {
							$this->SetDColor($details[$side]['c']);
						} else {
							$this->SetDColor($this->ConvertColor(0));
						}
						$this->Line($lx1 + $xadj, $ly1 + $yadj, $lx2 - $xadj2, $ly2 - $yadj2);
						/* -- TABLES-ADVANCED-BORDERS -- */
					}
					/* -- END TABLES-ADVANCED-BORDERS -- */

					// Reset Corners
					$this->SetDash();
					//BUTT style line cap
					$this->SetLineCap(2);
				}
			}

			if ($bSeparate && count($cellBorderOverlay)) {
				foreach ($cellBorderOverlay AS $cbo) {
					$this->SetLineWidth($cbo['lw']);
					$this->SetDColor($cbo['col']);
					$this->Line($cbo['x'], $cbo['y'], $cbo['x2'], $cbo['y2']);
				}
			}

			// $this->SetLineWidth($oldlinewidth);
			// $this->SetDColor($this->ConvertColor(0));
		}
	}

	/* -- TABLES -- */
	/* -- TABLES-ADVANCED-BORDERS -- */

	function _lightenColor($c)
	{
		if (is_array($c)) {
			throw new MpdfException('Color error in _lightencolor');
		}
		if ($c{0} == 3 || $c{0} == 5) {  // RGB
			list($h, $s, $l) = $this->rgb2hsl(ord($c{1}) / 255, ord($c{2}) / 255, ord($c{3}) / 255);
			$l += ((1 - $l) * 0.8);
			list($r, $g, $b) = $this->hsl2rgb($h, $s, $l);
			$ret = array(3, $r, $g, $b);
		} elseif ($c{0} == 4 || $c{0} == 6) {  // CMYK
			$ret = array(4, max(0, (ord($c{1}) - 20)), max(0, (ord($c{2}) - 20)), max(0, (ord($c{3}) - 20)), max(0, (ord($c{4}) - 20)));
		} elseif ($c{0} == 1) { // Grayscale
			$ret = array(1, min(255, (ord($c{1}) + 32)));
		}
		$c = array_pad($ret, 6, 0);
		$cstr = pack("a1ccccc", $c[0], ($c[1] & 0xFF), ($c[2] & 0xFF), ($c[3] & 0xFF), ($c[4] & 0xFF), ($c[5] & 0xFF));
		return $cstr;
	}

	function _darkenColor($c)
	{
		if (is_array($c)) {
			throw new MpdfException('Color error in _darkenColor');
		}
		if ($c{0} == 3 || $c{0} == 5) {  // RGB
			list($h, $s, $l) = $this->rgb2hsl(ord($c{1}) / 255, ord($c{2}) / 255, ord($c{3}) / 255);
			$s *= 0.25;
			$l *= 0.75;
			list($r, $g, $b) = $this->hsl2rgb($h, $s, $l);
			$ret = array(3, $r, $g, $b);
		} elseif ($c{0} == 4 || $c{0} == 6) {  // CMYK
			$ret = array(4, min(100, (ord($c{1}) + 20)), min(100, (ord($c{2}) + 20)), min(100, (ord($c{3}) + 20)), min(100, (ord($c{4}) + 20)));
		} elseif ($c{0} == 1) { // Grayscale
			$ret = array(1, max(0, (ord($c{1}) - 32)));
		}
		$c = array_pad($ret, 6, 0);
		$cstr = pack("a1ccccc", $c[0], ($c[1] & 0xFF), ($c[2] & 0xFF), ($c[3] & 0xFF), ($c[4] & 0xFF), ($c[5] & 0xFF));
		return $cstr;
	}

	/* -- END TABLES-ADVANCED-BORDERS -- */

	function setBorder(&$var, $flag, $set = true)
	{
		$flag = intval($flag);
		if ($set) {
			$set = true;
		}
		$var = intval($var);
		$var = $set ? ($var | $flag) : ($var & ~$flag);
	}

	function issetBorder($var, $flag)
	{
		$flag = intval($flag);
		$var = intval($var);
		return (($var & $flag) == $flag);
	}

	function _table2cellBorder(&$tableb, &$cbdb, &$cellb, $bval)
	{
		if ($tableb && $tableb['w'] > $cbdb['w']) {
			$cbdb = $tableb;
			$this->setBorder($cellb, $bval);
		} elseif ($tableb && $tableb['w'] == $cbdb['w'] && array_search($tableb['style'], $this->borderstyles) > array_search($cbdb['style'], $this->borderstyles)) {
			$cbdb = $tableb;
			$this->setBorder($cellb, $bval);
		}
	}

	// FIX BORDERS ********************************************
	function _fixTableBorders(&$table)
	{
		if (!$table['borders_separate'] && $table['border_details']['L']['w']) {
			$table['max_cell_border_width']['L'] = $table['border_details']['L']['w'];
		}
		if (!$table['borders_separate'] && $table['border_details']['R']['w']) {
			$table['max_cell_border_width']['R'] = $table['border_details']['R']['w'];
		}
		if (!$table['borders_separate'] && $table['border_details']['T']['w']) {
			$table['max_cell_border_width']['T'] = $table['border_details']['T']['w'];
		}
		if (!$table['borders_separate'] && $table['border_details']['B']['w']) {
			$table['max_cell_border_width']['B'] = $table['border_details']['B']['w'];
		}
		if ($this->simpleTables) {
			return;
		}
		$cells = &$table['cells'];
		$numcols = $table['nc'];
		$numrows = $table['nr'];
		/* -- TABLES-ADVANCED-BORDERS -- */
		if (isset($table['topntail']) && $table['topntail']) {
			$tntborddet = $this->border_details($table['topntail']);
		}
		if (isset($table['thead-underline']) && $table['thead-underline']) {
			$thuborddet = $this->border_details($table['thead-underline']);
		}
		/* -- END TABLES-ADVANCED-BORDERS -- */

		for ($i = 0; $i < $numrows; $i++) { //Rows
			for ($j = 0; $j < $numcols; $j++) { //Columns
				if (isset($cells[$i][$j]) && $cells[$i][$j]) {
					$cell = &$cells[$i][$j];
					if ($this->packTableData) {
						$cbord = $this->_unpackCellBorder($cell['borderbin']);
					} else {
						$cbord = &$cells[$i][$j];
					}

					// mPDF 5.7.3
					if (!$cbord['border'] && $cbord['border'] !== 0 && isset($table['border']) && $table['border'] && $this->table_border_attr_set) {
						$cbord['border'] = $table['border'];
						$cbord['border_details'] = $table['border_details'];
					}

					if (isset($cell['colspan']) && $cell['colspan'] > 1) {
						$ccolsp = $cell['colspan'];
					} else {
						$ccolsp = 1;
					}
					if (isset($cell['rowspan']) && $cell['rowspan'] > 1) {
						$crowsp = $cell['rowspan'];
					} else {
						$crowsp = 1;
					}

					$cbord['border_details']['cellposdom'] = ((($i + 1) / $numrows) / 10000 ) + ((($j + 1) / $numcols) / 10 );
					// Inherit Cell border from Table border
					if ($this->table_border_css_set && !$table['borders_separate']) {
						if ($i == 0) {
							$this->_table2cellBorder($table['border_details']['T'], $cbord['border_details']['T'], $cbord['border'], _BORDER_TOP);
						}
						if ($i == ($numrows - 1) || ($i + $crowsp) == ($numrows)) {
							$this->_table2cellBorder($table['border_details']['B'], $cbord['border_details']['B'], $cbord['border'], _BORDER_BOTTOM);
						}
						if ($j == 0) {
							$this->_table2cellBorder($table['border_details']['L'], $cbord['border_details']['L'], $cbord['border'], _BORDER_LEFT);
						}
						if ($j == ($numcols - 1) || ($j + $ccolsp) == ($numcols)) {
							$this->_table2cellBorder($table['border_details']['R'], $cbord['border_details']['R'], $cbord['border'], _BORDER_RIGHT);
						}
					}

					/* -- TABLES-ADVANCED-BORDERS -- */
					$fixbottom = true;
					if (isset($table['topntail']) && $table['topntail']) {
						if ($i == 0) {
							$cbord['border_details']['T'] = $tntborddet;
							$this->setBorder($cbord['border'], _BORDER_TOP);
						}
						if ($this->tableLevel == 1 && $table['headernrows'] > 0 && $i == $table['headernrows'] - 1) {
							$cbord['border_details']['B'] = $tntborddet;
							$this->setBorder($cbord['border'], _BORDER_BOTTOM);
							$fixbottom = false;
						} elseif ($this->tableLevel == 1 && $table['headernrows'] > 0 && $i == $table['headernrows']) {
							if (!$table['borders_separate']) {
								$cbord['border_details']['T'] = $tntborddet;
								$this->setBorder($cbord['border'], _BORDER_TOP);
							}
						}
						if ($this->tableLevel == 1 && $table['footernrows'] > 0 && $i == ($numrows - $table['footernrows'] - 1)) {
							if (!$table['borders_separate']) {
								$cbord['border_details']['B'] = $tntborddet;
								$this->setBorder($cbord['border'], _BORDER_BOTTOM);
								$fixbottom = false;
							}
						} elseif ($this->tableLevel == 1 && $table['footernrows'] > 0 && $i == ($numrows - $table['footernrows'])) {
							$cbord['border_details']['T'] = $tntborddet;
							$this->setBorder($cbord['border'], _BORDER_TOP);
						}
						if ($this->tabletheadjustfinished) { // $this->tabletheadjustfinished called from tableheader
							if (!$table['borders_separate']) {
								$cbord['border_details']['T'] = $tntborddet;
								$this->setBorder($cbord['border'], _BORDER_TOP);
							}
						}
						if ($i == ($numrows - 1) || ($i + $crowsp) == ($numrows)) {
							$cbord['border_details']['B'] = $tntborddet;
							$this->setBorder($cbord['border'], _BORDER_BOTTOM);
						}
					}
					if (isset($table['thead-underline']) && $table['thead-underline']) {
						if ($table['borders_separate']) {
							if ($i == 0) {
								$cbord['border_details']['B'] = $thuborddet;
								$this->setBorder($cbord['border'], _BORDER_BOTTOM);
								$fixbottom = false;
							}
						} else {
							if ($this->tableLevel == 1 && $table['headernrows'] > 0 && $i == $table['headernrows'] - 1) {
								$cbord['border_details']['T'] = $thuborddet;
								$this->setBorder($cbord['border'], _BORDER_TOP);
							} elseif ($this->tabletheadjustfinished) { // $this->tabletheadjustfinished called from tableheader
								$cbord['border_details']['T'] = $thuborddet;
								$this->setBorder($cbord['border'], _BORDER_TOP);
							}
						}
					}

					// Collapse Border - Algorithm for conflicting borders
					// Hidden >> Width >> double>solid>dashed>dotted... >> style set on cell>table >> top/left>bottom/right
					// Do not turn off border which is overridden
					// Needed for page break for TOP/BOTTOM both to be defined in Collapsed borders
					// Means it is painted twice. (Left/Right can still disable overridden border)
					if (!$table['borders_separate']) {
						if (($i < ($numrows - 1) || ($i + $crowsp) < $numrows ) && $fixbottom) { // Bottom
							for ($cspi = 0; $cspi < $ccolsp; $cspi++) {
								// already defined Top for adjacent cell below
								if (isset($cells[($i + $crowsp)][$j + $cspi])) {
									if ($this->packTableData) {
										$adjc = $cells[($i + $crowsp)][$j + $cspi];
										$celladj = $this->_unpackCellBorder($adjc['borderbin']);
									} else {
										$celladj = & $cells[($i + $crowsp)][$j + $cspi];
									}
								} else {
									$celladj = false;
								}
								if ($celladj && $celladj['border_details']['T']['s'] == 1) {
									$csadj = $celladj['border_details']['T']['w'];
									$csthis = $cbord['border_details']['B']['w'];
									// Hidden
									if ($cbord['border_details']['B']['style'] == 'hidden') {
										$celladj['border_details']['T'] = $cbord['border_details']['B'];
										$this->setBorder($celladj['border'], _BORDER_TOP, false);
										$this->setBorder($cbord['border'], _BORDER_BOTTOM, false);
									} elseif ($celladj['border_details']['T']['style'] == 'hidden') {
										$cbord['border_details']['B'] = $celladj['border_details']['T'];
										$this->setBorder($cbord['border'], _BORDER_BOTTOM, false);
										$this->setBorder($celladj['border'], _BORDER_TOP, false);
									}
									// Width
									elseif ($csthis > $csadj) {
										if (!isset($cells[($i + $crowsp)][$j + $cspi]['colspan']) || (isset($cells[($i + $crowsp)][$j + $cspi]['colspan']) && $cells[($i + $crowsp)][$j + $cspi]['colspan'] < 2)) { // don't overwrite bordering cells that span
											$celladj['border_details']['T'] = $cbord['border_details']['B'];
											$this->setBorder($cbord['border'], _BORDER_BOTTOM);
										}
									} elseif ($csadj > $csthis) {
										if ($ccolsp < 2) { // don't overwrite this cell if it spans
											$cbord['border_details']['B'] = $celladj['border_details']['T'];
											$this->setBorder($celladj['border'], _BORDER_TOP);
										}
									}

									// double>solid>dashed>dotted...
									elseif (array_search($cbord['border_details']['B']['style'], $this->borderstyles) > array_search($celladj['border_details']['T']['style'], $this->borderstyles)) {
										if (!isset($cells[($i + $crowsp)][$j + $cspi]['colspan']) || (isset($cells[($i + $crowsp)][$j + $cspi]['colspan']) && $cells[($i + $crowsp)][$j + $cspi]['colspan'] < 2)) { // don't overwrite bordering cells that span
											$celladj['border_details']['T'] = $cbord['border_details']['B'];
											$this->setBorder($cbord['border'], _BORDER_BOTTOM);
										}
									} elseif (array_search($celladj['border_details']['T']['style'], $this->borderstyles) > array_search($cbord['border_details']['B']['style'], $this->borderstyles)) {
										if ($ccolsp < 2) { // don't overwrite this cell if it spans
											$cbord['border_details']['B'] = $celladj['border_details']['T'];
											$this->setBorder($celladj['border'], _BORDER_TOP);
										}
									}



									// Style set on cell vs. table
									elseif ($celladj['border_details']['T']['dom'] > $cbord['border_details']['B']['dom']) {
										if ($ccolsp < 2) { // don't overwrite this cell if it spans
											$cbord['border_details']['B'] = $celladj['border_details']['T'];
											$this->setBorder($celladj['border'], _BORDER_TOP);
										}
									}
									// Style set on cell vs. table  - OR - LEFT/TOP (cell) in preference to BOTTOM/RIGHT
									else {
										if (!isset($cells[($i + $crowsp)][$j + $cspi]['colspan']) || (isset($cells[($i + $crowsp)][$j + $cspi]['colspan']) && $cells[($i + $crowsp)][$j + $cspi]['colspan'] < 2)) { // don't overwrite bordering cells that span
											$celladj['border_details']['T'] = $cbord['border_details']['B'];
											$this->setBorder($cbord['border'], _BORDER_BOTTOM);
										}
									}
								} elseif ($celladj) {
									if (!isset($cells[($i + $crowsp)][$j + $cspi]['colspan']) || (isset($cells[($i + $crowsp)][$j + $cspi]['colspan']) && $cells[($i + $crowsp)][$j + $cspi]['colspan'] < 2)) { // don't overwrite bordering cells that span
										$celladj['border_details']['T'] = $cbord['border_details']['B'];
									}
								}
								// mPDF 5.7.4
								if ($celladj && $this->packTableData) {
									$cells[$i + $crowsp][$j + $cspi]['borderbin'] = $this->_packCellBorder($celladj);
								}
								unset($celladj);
							}
						}

						if ($j < ($numcols - 1) || ($j + $ccolsp) < $numcols) { // Right-Left
							for ($cspi = 0; $cspi < $crowsp; $cspi++) {
								// already defined Left for adjacent cell to R
								if (isset($cells[($i + $cspi)][$j + $ccolsp])) {
									if ($this->packTableData) {
										$adjc = $cells[($i + $cspi)][$j + $ccolsp];
										$celladj = $this->_unpackCellBorder($adjc['borderbin']);
									} else {
										$celladj = & $cells[$i + $cspi][$j + $ccolsp];
									}
								} else {
									$celladj = false;
								}
								if ($celladj && $celladj['border_details']['L']['s'] == 1) {
									$csadj = $celladj['border_details']['L']['w'];
									$csthis = $cbord['border_details']['R']['w'];
									// Hidden
									if ($cbord['border_details']['R']['style'] == 'hidden') {
										$celladj['border_details']['L'] = $cbord['border_details']['R'];
										$this->setBorder($celladj['border'], _BORDER_LEFT, false);
										$this->setBorder($cbord['border'], _BORDER_RIGHT, false);
									} elseif ($celladj['border_details']['L']['style'] == 'hidden') {
										$cbord['border_details']['R'] = $celladj['border_details']['L'];
										$this->setBorder($cbord['border'], _BORDER_RIGHT, false);
										$this->setBorder($celladj['border'], _BORDER_LEFT, false);
									}
									// Width
									elseif ($csthis > $csadj) {
										if (!isset($cells[($i + $cspi)][$j + $ccolsp]['rowspan']) || (isset($cells[($i + $cspi)][$j + $ccolsp]['rowspan']) && $cells[($i + $cspi)][$j + $ccolsp]['rowspan'] < 2)) { // don't overwrite bordering cells that span
											$celladj['border_details']['L'] = $cbord['border_details']['R'];
											$this->setBorder($cbord['border'], _BORDER_RIGHT);
											$this->setBorder($celladj['border'], _BORDER_LEFT, false);
										}
									} elseif ($csadj > $csthis) {
										if ($crowsp < 2) { // don't overwrite this cell if it spans
											$cbord['border_details']['R'] = $celladj['border_details']['L'];
											$this->setBorder($cbord['border'], _BORDER_RIGHT, false);
											$this->setBorder($celladj['border'], _BORDER_LEFT);
										}
									}

									// double>solid>dashed>dotted...
									elseif (array_search($cbord['border_details']['R']['style'], $this->borderstyles) > array_search($celladj['border_details']['L']['style'], $this->borderstyles)) {
										if (!isset($cells[($i + $cspi)][$j + $ccolsp]['rowspan']) || (isset($cells[($i + $cspi)][$j + $ccolsp]['rowspan']) && $cells[($i + $cspi)][$j + $ccolsp]['rowspan'] < 2)) { // don't overwrite bordering cells that span
											$celladj['border_details']['L'] = $cbord['border_details']['R'];
											$this->setBorder($celladj['border'], _BORDER_LEFT, false);
											$this->setBorder($cbord['border'], _BORDER_RIGHT);
										}
									} elseif (array_search($celladj['border_details']['L']['style'], $this->borderstyles) > array_search($cbord['border_details']['R']['style'], $this->borderstyles)) {
										if ($crowsp < 2) { // don't overwrite this cell if it spans
											$cbord['border_details']['R'] = $celladj['border_details']['L'];
											$this->setBorder($cbord['border'], _BORDER_RIGHT, false);
											$this->setBorder($celladj['border'], _BORDER_LEFT);
										}
									}


									// Style set on cell vs. table
									elseif ($celladj['border_details']['L']['dom'] > $cbord['border_details']['R']['dom']) {
										if ($crowsp < 2) { // don't overwrite this cell if it spans
											$cbord['border_details']['R'] = $celladj['border_details']['L'];
											$this->setBorder($celladj['border'], _BORDER_LEFT);
										}
									}
									// Style set on cell vs. table  - OR - LEFT/TOP (cell) in preference to BOTTOM/RIGHT
									else {
										if (!isset($cells[($i + $cspi)][$j + $ccolsp]['rowspan']) || (isset($cells[($i + $cspi)][$j + $ccolsp]['rowspan']) && $cells[($i + $cspi)][$j + $ccolsp]['rowspan'] < 2)) { // don't overwrite bordering cells that span
											$celladj['border_details']['L'] = $cbord['border_details']['R'];
											$this->setBorder($cbord['border'], _BORDER_RIGHT);
										}
									}
								} elseif ($celladj) {
									// if right-cell border is not set
									if (!isset($cells[($i + $cspi)][$j + $ccolsp]['rowspan']) || (isset($cells[($i + $cspi)][$j + $ccolsp]['rowspan']) && $cells[($i + $cspi)][$j + $ccolsp]['rowspan'] < 2)) { // don't overwrite bordering cells that span
										$celladj['border_details']['L'] = $cbord['border_details']['R'];
									}
								}
								// mPDF 5.7.4
								if ($celladj && $this->packTableData) {
									$cells[$i + $cspi][$j + $ccolsp]['borderbin'] = $this->_packCellBorder($celladj);
								}
								unset($celladj);
							}
						}
					}


					// Set maximum cell border width meeting at LRTB edges of cell - used for extended cell border
					// ['border_details']['mbw']['LT'] = meeting border width - Left border - Top end
					if (!$table['borders_separate']) {
						$cbord['border_details']['mbw']['BL'] = max($cbord['border_details']['mbw']['BL'], $cbord['border_details']['L']['w']);
						$cbord['border_details']['mbw']['BR'] = max($cbord['border_details']['mbw']['BR'], $cbord['border_details']['R']['w']);
						$cbord['border_details']['mbw']['RT'] = max($cbord['border_details']['mbw']['RT'], $cbord['border_details']['T']['w']);
						$cbord['border_details']['mbw']['RB'] = max($cbord['border_details']['mbw']['RB'], $cbord['border_details']['B']['w']);
						$cbord['border_details']['mbw']['TL'] = max($cbord['border_details']['mbw']['TL'], $cbord['border_details']['L']['w']);
						$cbord['border_details']['mbw']['TR'] = max($cbord['border_details']['mbw']['TR'], $cbord['border_details']['R']['w']);
						$cbord['border_details']['mbw']['LT'] = max($cbord['border_details']['mbw']['LT'], $cbord['border_details']['T']['w']);
						$cbord['border_details']['mbw']['LB'] = max($cbord['border_details']['mbw']['LB'], $cbord['border_details']['B']['w']);
						if (($i + $crowsp) < $numrows && isset($cells[$i + $crowsp][$j])) { // Has Bottom adjoining cell
							if ($this->packTableData) {
								$adjc = $cells[$i + $crowsp][$j];
								$celladj = $this->_unpackCellBorder($adjc['borderbin']);
							} else {
								$celladj = & $cells[$i + $crowsp][$j];
							}
							$cbord['border_details']['mbw']['BL'] = max($cbord['border_details']['mbw']['BL'], $celladj['border_details']['L']['w'], $celladj['border_details']['mbw']['TL']);
							$cbord['border_details']['mbw']['BR'] = max($cbord['border_details']['mbw']['BR'], $celladj['border_details']['R']['w'], $celladj['border_details']['mbw']['TR']);
							$cbord['border_details']['mbw']['LB'] = max($cbord['border_details']['mbw']['LB'], $celladj['border_details']['mbw']['LT']);
							$cbord['border_details']['mbw']['RB'] = max($cbord['border_details']['mbw']['RB'], $celladj['border_details']['mbw']['RT']);
							unset($celladj);
						}
						if (($j + $ccolsp) < $numcols && isset($cells[$i][$j + $ccolsp])) { // Has Right adjoining cell
							if ($this->packTableData) {
								$adjc = $cells[$i][$j + $ccolsp];
								$celladj = $this->_unpackCellBorder($adjc['borderbin']);
							} else {
								$celladj = & $cells[$i][$j + $ccolsp];
							}
							$cbord['border_details']['mbw']['RT'] = max($cbord['border_details']['mbw']['RT'], $celladj['border_details']['T']['w'], $celladj['border_details']['mbw']['LT']);
							$cbord['border_details']['mbw']['RB'] = max($cbord['border_details']['mbw']['RB'], $celladj['border_details']['B']['w'], $celladj['border_details']['mbw']['LB']);
							$cbord['border_details']['mbw']['TR'] = max($cbord['border_details']['mbw']['TR'], $celladj['border_details']['mbw']['TL']);
							$cbord['border_details']['mbw']['BR'] = max($cbord['border_details']['mbw']['BR'], $celladj['border_details']['mbw']['BL']);
							unset($celladj);
						}

						if ($i > 0 && isset($cells[$i - 1][$j]) && (($this->packTableData && $cells[$i - 1][$j]['borderbin']) || $cells[$i - 1][$j]['border'])) { // Has Top adjoining cell
							if ($this->packTableData) {
								$adjc = $cells[$i - 1][$j];
								$celladj = $this->_unpackCellBorder($adjc['borderbin']);
							} else {
								$celladj = & $cells[$i - 1][$j];
							}
							$cbord['border_details']['mbw']['TL'] = max($cbord['border_details']['mbw']['TL'], $celladj['border_details']['L']['w'], $celladj['border_details']['mbw']['BL']);
							$cbord['border_details']['mbw']['TR'] = max($cbord['border_details']['mbw']['TR'], $celladj['border_details']['R']['w'], $celladj['border_details']['mbw']['BR']);
							$cbord['border_details']['mbw']['LT'] = max($cbord['border_details']['mbw']['LT'], $celladj['border_details']['mbw']['LB']);
							$cbord['border_details']['mbw']['RT'] = max($cbord['border_details']['mbw']['RT'], $celladj['border_details']['mbw']['RB']);

							if ($celladj['border_details']['mbw']['BL']) {
								$celladj['border_details']['mbw']['BL'] = max($cbord['border_details']['mbw']['TL'], $celladj['border_details']['mbw']['BL']);
							}
							if ($celladj['border_details']['mbw']['BR']) {
								$celladj['border_details']['mbw']['BR'] = max($celladj['border_details']['mbw']['BR'], $cbord['border_details']['mbw']['TR']);
							}
							if ($this->packTableData) {
								$cells[$i - 1][$j]['borderbin'] = $this->_packCellBorder($celladj);
							}
							unset($celladj);
						}
						if ($j > 0 && isset($cells[$i][$j - 1]) && (($this->packTableData && $cells[$i][$j - 1]['borderbin']) || $cells[$i][$j - 1]['border'])) { // Has Left adjoining cell
							if ($this->packTableData) {
								$adjc = $cells[$i][$j - 1];
								$celladj = $this->_unpackCellBorder($adjc['borderbin']);
							} else {
								$celladj = & $cells[$i][$j - 1];
							}
							$cbord['border_details']['mbw']['LT'] = max($cbord['border_details']['mbw']['LT'], $celladj['border_details']['T']['w'], $celladj['border_details']['mbw']['RT']);
							$cbord['border_details']['mbw']['LB'] = max($cbord['border_details']['mbw']['LB'], $celladj['border_details']['B']['w'], $celladj['border_details']['mbw']['RB']);
							$cbord['border_details']['mbw']['BL'] = max($cbord['border_details']['mbw']['BL'], $celladj['border_details']['mbw']['BR']);
							$cbord['border_details']['mbw']['TL'] = max($cbord['border_details']['mbw']['TL'], $celladj['border_details']['mbw']['TR']);

							if ($celladj['border_details']['mbw']['RT']) {
								$celladj['border_details']['mbw']['RT'] = max($celladj['border_details']['mbw']['RT'], $cbord['border_details']['mbw']['LT']);
							}
							if ($celladj['border_details']['mbw']['RB']) {
								$celladj['border_details']['mbw']['RB'] = max($celladj['border_details']['mbw']['RB'], $cbord['border_details']['mbw']['LB']);
							}
							if ($this->packTableData) {
								$cells[$i][$j - 1]['borderbin'] = $this->_packCellBorder($celladj);
							}
							unset($celladj);
						}


						// Update maximum cell border width at LRTB edges of table - used for overall table width
						if ($j == 0 && $cbord['border_details']['L']['w']) {
							$table['max_cell_border_width']['L'] = max($table['max_cell_border_width']['L'], $cbord['border_details']['L']['w']);
						}
						if (($j == ($numcols - 1) || ($j + $ccolsp) == $numcols ) && $cbord['border_details']['R']['w']) {
							$table['max_cell_border_width']['R'] = max($table['max_cell_border_width']['R'], $cbord['border_details']['R']['w']);
						}
						if ($i == 0 && $cbord['border_details']['T']['w']) {
							$table['max_cell_border_width']['T'] = max($table['max_cell_border_width']['T'], $cbord['border_details']['T']['w']);
						}
						if (($i == ($numrows - 1) || ($i + $crowsp) == $numrows ) && $cbord['border_details']['B']['w']) {
							$table['max_cell_border_width']['B'] = max($table['max_cell_border_width']['B'], $cbord['border_details']['B']['w']);
						}
					}
					/* -- END TABLES-ADVANCED-BORDERS -- */

					if ($this->packTableData) {
						$cell['borderbin'] = $this->_packCellBorder($cbord);
					}

					unset($cbord);

					unset($cell);
				}
			}
		}
		unset($cell);
	}

	// END FIX BORDERS ************************************************************************************

	function _reverseTableDir(&$table)
	{
		$cells = &$table['cells'];
		$numcols = $table['nc'];
		$numrows = $table['nr'];
		for ($i = 0; $i < $numrows; $i++) { //Rows
			$row = array();
			for ($j = ($numcols - 1); $j >= 0; $j--) { //Columns
				if (isset($cells[$i][$j]) && $cells[$i][$j]) {
					$cell = &$cells[$i][$j];
					$col = $numcols - $j - 1;
					if (isset($cell['colspan']) && $cell['colspan'] > 1) {
						$col -= ($cell['colspan'] - 1);
					}
					// Nested content
					if (isset($cell['textbuffer'])) {
						for ($n = 0; $n < count($cell['textbuffer']); $n++) {
							$t = $cell['textbuffer'][$n][0];
							if (substr($t, 0, 19) == "\xbb\xa4\xactype=nestedtable") {
								$objattr = $this->_getObjAttr($t);
								$objattr['col'] = $col;
								$cell['textbuffer'][$n][0] = "\xbb\xa4\xactype=nestedtable,objattr=" . serialize($objattr) . "\xbb\xa4\xac";
								$this->table[($this->tableLevel + 1)][$objattr['nestedcontent']]['nestedpos'][1] = $col;
							}
						}
					}
					$row[$col] = $cells[$i][$j];
					unset($cell);
				}
			}
			for ($f = 0; $f < $numcols; $f++) {
				if (!isset($row[$f])) {
					$row[$f] = 0;
				}
			}
			$table['cells'][$i] = $row;
		}
	}

	function _tableWrite(&$table, $split = false, $startrow = 0, $startcol = 0, $splitpg = 0, $rety = 0)
	{
		$level = $table['level'];
		$levelid = $table['levelid'];

		$cells = &$table['cells'];
		$numcols = $table['nc'];
		$numrows = $table['nr'];
		$maxbwtop = 0;
		if ($this->ColActive && $level == 1) {
			$this->breakpoints[$this->CurrCol][] = $this->y;
		} // *COLUMNS*

		if (!$split || ($startrow == 0 && $splitpg == 0) || $startrow > 0) {
			// TABLE TOP MARGIN
			if ($table['margin']['T']) {
				if (!$this->table_rotate && $level == 1) {
					$this->DivLn($table['margin']['T'], $this->blklvl, true, 1);  // collapsible
				} else {
					$this->y += ($table['margin']['T']);
				}
			}
			// Advance down page by half width of top border
			if ($table['borders_separate']) {
				if ($startrow > 0 && (!isset($table['is_thead']) || count($table['is_thead']) == 0))
					$adv = $table['border_spacing_V'] / 2;
				else
					$adv = $table['padding']['T'] + $table['border_details']['T']['w'] + $table['border_spacing_V'] / 2;
			}
			else {
				$adv = $table['max_cell_border_width']['T'] / 2;
			}
			if (!$this->table_rotate && $level == 1) {
				$this->DivLn($adv);
			} else {
				$this->y += $adv;
			}
		}

		if ($level == 1) {
			$this->x = $this->lMargin + $this->blk[$this->blklvl]['outer_left_margin'] + $this->blk[$this->blklvl]['padding_left'] + $this->blk[$this->blklvl]['border_left']['w'];
			$x0 = $this->x;
			$y0 = $this->y;
			$right = $x0 + $this->blk[$this->blklvl]['inner_width'];
			$outerfilled = $this->y; // Keep track of how far down the outer DIV bgcolor is painted (NB rowspans)
			$this->outerfilled = $this->y;
			$this->colsums = array();
		} else {
			$x0 = $this->x;
			$y0 = $this->y;
			$right = $x0 + $table['w'];
		}

		if ($this->table_rotate) {
			$temppgwidth = $this->tbrot_maxw;
			$this->PageBreakTrigger = $pagetrigger = $y0 + ($this->blk[$this->blklvl]['inner_width']);
			if ($level == 1) {
				$this->tbrot_y0 = $this->y - $adv - $table['margin']['T'];
				$this->tbrot_x0 = $this->x;
				$this->tbrot_w = $table['w'];
				if ($table['borders_separate']) {
					$this->tbrot_h = $table['margin']['T'] + $table['padding']['T'] + $table['border_details']['T']['w'] + $table['border_spacing_V'] / 2;
				} else {
					$this->tbrot_h = $table['margin']['T'] + $table['padding']['T'] + $table['max_cell_border_width']['T'];
				}
			}
		} else {
			$this->PageBreakTrigger = $pagetrigger = ($this->h - $this->bMargin);
			if ($level == 1) {
				$temppgwidth = $this->blk[$this->blklvl]['inner_width'];
				if (isset($table['a']) and ( $table['w'] < $this->blk[$this->blklvl]['inner_width'])) {
					if ($table['a'] == 'C') {
						$x0 += ((($right - $x0) - $table['w']) / 2);
					} elseif ($table['a'] == 'R') {
						$x0 = $right - $table['w'];
					}
				}
			} else {
				$temppgwidth = $table['w'];
			}
		}
		if (!isset($table['overflow'])) {
			$table['overflow'] = null;
		}
		if ($table['overflow'] == 'hidden' && $level == 1 && !$this->table_rotate && !$this->ColActive) {
			//Bounding rectangle to clip
			$this->tableClipPath = sprintf('q %.3F %.3F %.3F %.3F re W n', $x0 * _MPDFK, $this->h * _MPDFK, $this->blk[$this->blklvl]['inner_width'] * _MPDFK, -$this->h * _MPDFK);
			$this->_out($this->tableClipPath);
		} else {
			$this->tableClipPath = '';
		}


		if ($table['borders_separate']) {
			$indent = $table['margin']['L'] + $table['border_details']['L']['w'] + $table['padding']['L'] + $table['border_spacing_H'] / 2;
		} else {
			$indent = $table['margin']['L'] + $table['max_cell_border_width']['L'] / 2;
		}
		$x0 += $indent;

		$returny = 0;
		$lastCol = 0;
		$tableheader = array();
		$tablefooter = array();
		$tableheaderrowheight = 0;
		$tablefooterrowheight = 0;
		$footery = 0;

		// mPD 3.0 Set the Page & Column where table starts
		if (($this->mirrorMargins) && (($this->page) % 2 == 0)) { // EVEN
			$tablestartpage = 'EVEN';
		} elseif (($this->mirrorMargins) && (($this->page) % 2 == 1)) { // ODD
			$tablestartpage = 'ODD';
		} else {
			$tablestartpage = '';
		}
		if ($this->ColActive) {
			$tablestartcolumn = $this->CurrCol;
		} else {
			$tablestartcolumn = '';
		}

		$y = $h = 0;
		for ($i = 0; $i < $numrows; $i++) { //Rows
			if ($this->progressBar) {
				$this->UpdateProgressBar(7, intval(30 + ($i * 40 / $numrows)), ' ');
			} // *PROGRESS-BAR*
			if (isset($table['is_tfoot'][$i]) && $table['is_tfoot'][$i] && $level == 1) {
				$tablefooterrowheight += $table['hr'][$i];
				$tablefooter[$i][0]['trbackground-images'] = $table['trbackground-images'][$i];
				$tablefooter[$i][0]['trgradients'] = $table['trgradients'][$i];
				$tablefooter[$i][0]['trbgcolor'] = $table['bgcolor'][$i];
				for ($j = $startcol; $j < $numcols; $j++) { //Columns
					if (isset($cells[$i][$j]) && $cells[$i][$j]) {
						$cell = &$cells[$i][$j];
						if ($split) {
							if ($table['colPg'][$j] != $splitpg) {
								continue;
							}
							list($x, $w) = $this->_splitTableGetWidth($table, $i, $j);
							$js = $j - $startcol;
						} else {
							list($x, $w) = $this->_tableGetWidth($table, $i, $j);
							$js = $j;
						}

						list($y, $h) = $this->_tableGetHeight($table, $i, $j);
						$x += $x0;
						$y += $y0;
						//Get info of tfoot ==>> table footer
						$tablefooter[$i][$js]['x'] = $x;
						$tablefooter[$i][$js]['y'] = $y;
						$tablefooter[$i][$js]['h'] = $h;
						$tablefooter[$i][$js]['w'] = $w;
						if (isset($cell['textbuffer'])) {
							$tablefooter[$i][$js]['textbuffer'] = $cell['textbuffer'];
						} else {
							$tablefooter[$i][$js]['textbuffer'] = '';
						}
						$tablefooter[$i][$js]['a'] = $cell['a'];
						$tablefooter[$i][$js]['R'] = $cell['R'];
						$tablefooter[$i][$js]['va'] = $cell['va'];
						$tablefooter[$i][$js]['mih'] = $cell['mih'];
						if (isset($cell['gradient']))
							$tablefooter[$i][$js]['gradient'] = $cell['gradient']; // *BACKGROUNDS*
						if (isset($cell['background-image']))
							$tablefooter[$i][$js]['background-image'] = $cell['background-image']; // *BACKGROUNDS*

						//CELL FILL BGCOLOR
						if (!$this->simpleTables) {
							if ($this->packTableData) {
								$c = $this->_unpackCellBorder($cell['borderbin']);
								$tablefooter[$i][$js]['border'] = $c['border'];
								$tablefooter[$i][$js]['border_details'] = $c['border_details'];
							} else {
								$tablefooter[$i][$js]['border'] = $cell['border'];
								$tablefooter[$i][$js]['border_details'] = $cell['border_details'];
							}
						} elseif ($this->simpleTables) {
							$tablefooter[$i][$js]['border'] = $table['simple']['border'];
							$tablefooter[$i][$js]['border_details'] = $table['simple']['border_details'];
						}
						$tablefooter[$i][$js]['bgcolor'] = $cell['bgcolor'];
						$tablefooter[$i][$js]['padding'] = $cell['padding'];
						if (isset($cell['rowspan']))
							$tablefooter[$i][$js]['rowspan'] = $cell['rowspan'];
						if (isset($cell['colspan']))
							$tablefooter[$i][$js]['colspan'] = $cell['colspan'];
						if (isset($cell['direction']))
							$tablefooter[$i][$js]['direction'] = $cell['direction'];
						if (isset($cell['cellLineHeight']))
							$tablefooter[$i][$js]['cellLineHeight'] = $cell['cellLineHeight'];
						if (isset($cell['cellLineStackingStrategy']))
							$tablefooter[$i][$js]['cellLineStackingStrategy'] = $cell['cellLineStackingStrategy'];
						if (isset($cell['cellLineStackingShift']))
							$tablefooter[$i][$js]['cellLineStackingShift'] = $cell['cellLineStackingShift'];
					}
				}
			}
		}

		if ($level == 1) {
			$this->_out('___TABLE___BACKGROUNDS' . $this->uniqstr);
		}
		$tableheaderadj = 0;
		$tablefooteradj = 0;

		$tablestartpageno = $this->page;

		//Draw Table Contents and Borders
		for ($i = 0; $i < $numrows; $i++) { //Rows
			if ($split && $startrow > 0) {
				$thnr = (isset($table['is_thead']) ? count($table['is_thead']) : 0);
				if ($i >= $thnr && $i < $startrow) {
					continue;
				}
				if ($i == $startrow) {
					$returny = $rety - $tableheaderrowheight;
				}
			}

			// Get Maximum row/cell height in row - including rowspan>1 + 1 overlapping
			$maxrowheight = $this->_tableGetMaxRowHeight($table, $i);

			$skippage = false;
			$newpagestarted = false;
			for ($j = $startcol; $j < $numcols; $j++) { //Columns
				if ($split) {
					if ($table['colPg'][$j] > $splitpg) {
						break;
					}
					$lastCol = $j;
				}
				if (isset($cells[$i][$j]) && $cells[$i][$j]) {
					$cell = &$cells[$i][$j];
					if ($split) {
						$lastCol = $j + (isset($cell['colspan']) ? ($cell['colspan'] - 1) : 0);
						list($x, $w) = $this->_splitTableGetWidth($table, $i, $j);
					} else {
						list($x, $w) = $this->_tableGetWidth($table, $i, $j);
					}

					list($y, $h) = $this->_tableGetHeight($table, $i, $j);
					$x += $x0;
					$y += $y0;
					$y -= $returny;

					if ($table['borders_separate']) {
						if (!empty($tablefooter) || $i == ($numrows - 1) || (isset($cell['rowspan']) && ($i + $cell['rowspan']) == $numrows) || (!isset($cell['rowspan']) && ($i + 1) == $numrows)) {
							$extra = $table['padding']['B'] + $table['border_details']['B']['w'] + $table['border_spacing_V'] / 2;
							//$extra = $table['margin']['B'] + $table['padding']['B'] + $table['border_details']['B']['w'] + $table['border_spacing_V']/2;
						} else {
							$extra = $table['border_spacing_V'] / 2;
						}
					} else {
						$extra = $table['max_cell_border_width']['B'] / 2;
					}

                    //ITS4YOU VlZa subtotal for last row of table starts
                    if($this->PDFMakerSubtotalAble == true && count($this->PDFMakerSubtotalsArray) > 0 && $j==$startcol && !empty($tablefooter) && isset($tablefooter[$i]))
                    {
                        $lastReplacements = array();
                        $lastReplacements = end($this->PDFMakerSubtotalsArray);
                        $pdf_toChangeArr = $this->PDFGetToChangeArray($tablefooter, $lastReplacements);
                        foreach($pdf_toChangeArr as $path=>$val)
                        {
                            list($pdf_rows_key,$pdf_cells_key,$pdf_buff_key) = explode("#@#", $path, 3);
                            $cells[$pdf_rows_key][$pdf_cells_key]['textbuffer'][$pdf_buff_key][0] = $val;
                        }
                    }
                    //ITS4YOU-END subtotal for last row of table

					if ($j == $startcol && ((($y + $maxrowheight + $extra ) > ($pagetrigger + 0.001)) || (($this->keepColumns || !$this->ColActive) && !empty($tablefooter) && ($y + $maxrowheight + $tablefooterrowheight + $extra) > $pagetrigger) && ($this->tableLevel == 1 && $i < ($numrows - $table['headernrows']))) && ($y0 > 0 || $x0 > 0) && !$this->InFooter && $this->autoPageBreak) {

						if (!$skippage) {
							$finalSpread = true;
							$firstSpread = true;
							if ($split) {
								for ($t = $startcol; $t < $numcols; $t++) {
									// Are there more columns to print on a next page?
									if ($table['colPg'][$t] > $splitpg) {
										$finalSpread = false;
										break;
									}
								}
								if ($startcol > 0) {
									$firstSpread = false;
								}
							}

							if (($this->keepColumns || !$this->ColActive) && !empty($tablefooter) && $i > 0) {
								$this->y = $y;
								$ya = $this->y;
								//$this->TableHeaderFooter($tablefooter,$tablestartpage,$tablestartcolumn,'F',$level, $firstSpread, $finalSpread);
        						if($this->PDFMakerSubtotalAble == true && count($this->PDFMakerSubtotalsArray) > 0)
                                {
                                    $preceedingIdx = ($i - $table['headernrows'] - $this->PDFMakerSplitCounter);
                                    
                                    $replacements = array();
                                    if(isset($this->PDFMakerSubtotalsArray[$preceedingIdx]))
                                    {
                                        $replacements = $this->PDFMakerSubtotalsArray[$preceedingIdx];
                                    }
                                    $copyTF = $tablefooter;
                                    $pdf_toChangeArr = $this->PDFGetToChangeArray($copyTF, $replacements);
                                    foreach($pdf_toChangeArr as $path=>$val)
                                    {
                                        list($pdf_rows_key,$pdf_cells_key,$pdf_buff_key) = explode("#@#", $path, 3);
                                        $copyTF[$pdf_rows_key][$pdf_cells_key]['textbuffer'][$pdf_buff_key][0] = $val;
                                    }
        
                                    $this->TableHeaderFooter($copyTF,$tablestartpage,$tablestartcolumn,'F',$level, $firstSpread, $finalSpread);
                                }
                                else
                                {
                                    $this->TableHeaderFooter($tablefooter,$tablestartpage,$tablestartcolumn,'F',$level, $firstSpread, $finalSpread);
                                }
                                //ITS4YOU-END
                                
                                
                                if ($this->table_rotate) {
									$this->tbrot_h += $this->y - $ya;
								}
								$tablefooteradj = $this->y - $ya;
							}
							$y -= $y0;
							$returny += $y;

							$oldcolumn = $this->CurrCol;
							if ($this->AcceptPageBreak()) {
								$newpagestarted = true;
                                // ITS4YOU MaJu
        						$this->PDFMakerSplitCounter++;
        						// ITS4YOU-END
								$this->y = $y + $y0;

								// Move down to account for border-spacing or
								// extra half border width in case page breaks in middle
								if ($i > 0 && !$this->table_rotate && $level == 1 && !$this->ColActive) {
									if ($table['borders_separate']) {
										$adv = $table['border_spacing_V'] / 2;
										// If table footer
										if (($this->keepColumns || !$this->ColActive) && !empty($tablefooter) && $i > 0) {
											$adv += ($table['padding']['B'] + $table['border_details']['B']['w']);
										}
									} else {
										$maxbwtop = 0;
										$maxbwbottom = 0;
										if (!$this->simpleTables) {
											if (!empty($tablefooter)) {
												$maxbwbottom = $table['max_cell_border_width']['B'];
											} else {
												$brow = $i - 1;
												for ($ctj = 0; $ctj < $numcols; $ctj++) {
													if (isset($cells[$brow][$ctj]) && $cells[$brow][$ctj]) {
														if ($this->packTableData) {
															list($bt, $br, $bb, $bl) = $this->_getBorderWidths($cells[$brow][$ctj]['borderbin']);
														} else {
															$bb = $cells[$brow][$ctj]['border_details']['B']['w'];
														}
														$maxbwbottom = max($maxbwbottom, $bb);
													}
												}
											}
											if (!empty($tableheader)) {
												$maxbwtop = $table['max_cell_border_width']['T'];
											} else {
												$trow = $i - 1;
												for ($ctj = 0; $ctj < $numcols; $ctj++) {
													if (isset($cells[$trow][$ctj]) && $cells[$trow][$ctj]) {
														if ($this->packTableData) {
															list($bt, $br, $bb, $bl) = $this->_getBorderWidths($cells[$trow][$ctj]['borderbin']);
														} else {
															$bt = $cells[$trow][$ctj]['border_details']['T']['w'];
														}
														$maxbwtop = max($maxbwtop, $bt);
													}
												}
											}
										} elseif ($this->simpleTables) {
											$maxbwtop = $table['simple']['border_details']['T']['w'];
											$maxbwbottom = $table['simple']['border_details']['B']['w'];
										}
										$adv = $maxbwbottom / 2;
									}
									$this->y += $adv;
								}

								// Rotated table split over pages - needs this->y for borders/backgrounds
								if ($i > 0 && $this->table_rotate && $level == 1) {
									//			$this->y = $y0 + $this->tbrot_w;
								}

								if ($this->tableClipPath) {
									$this->_out("Q");
								}

								$bx = $x0;
								$by = $y0;

								if ($table['borders_separate']) {
									$bx -= ($table['padding']['L'] + $table['border_details']['L']['w'] + $table['border_spacing_H'] / 2);
									if ($tablestartpageno != $this->page) { // IF already broken across a previous pagebreak
										$by += $table['max_cell_border_width']['T'] / 2;
										if (empty($tableheader)) {
											$by -= ($table['border_spacing_V'] / 2);
										}
									} else {
										$by -= ($table['padding']['T'] + $table['border_details']['T']['w'] + $table['border_spacing_V'] / 2);
									}
								} elseif ($tablestartpageno != $this->page && !empty($tableheader)) {
									$by += $maxbwtop / 2;
								}

								$by -= $tableheaderadj;
								$bh = $this->y - $by + $tablefooteradj;
								if (!$table['borders_separate']) {
									$bh -= $adv;
								}
								if ($split) {
									$bw = 0;
									for ($t = $startcol; $t < $numcols; $t++) {
										if ($table['colPg'][$t] == $splitpg) {
											$bw += $table['wc'][$t];
										}
										if ($table['colPg'][$t] > $splitpg) {
											break;
										}
									}
									if ($table['borders_separate']) {
										if ($firstSpread) {
											$bw += $table['padding']['L'] + $table['border_details']['L']['w'] + $table['border_spacing_H'];
										} else {
											$bx += ($table['padding']['L'] + $table['border_details']['L']['w']);
											$bw += $table['border_spacing_H'];
										}
										if ($finalSpread) {
											$bw += $table['padding']['R'] + $table['border_details']['R']['w'] / 2 + $table['border_spacing_H'];
										}
									}
								} else {
									$bw = $table['w'] - ($table['max_cell_border_width']['L'] / 2) - ($table['max_cell_border_width']['R'] / 2) - $table['margin']['L'] - $table['margin']['R'];
								}

								if ($this->splitTableBorderWidth && ($this->keepColumns || !$this->ColActive) && empty($tablefooter) && $i > 0 && $table['border_details']['B']['w']) {
									$prevDrawColor = $this->DrawColor;
									$lw = $this->LineWidth;
									$this->SetLineWidth($this->splitTableBorderWidth);
									$this->SetDColor($table['border_details']['B']['c']);
									$this->SetLineJoin(0);
									$this->SetLineCap(0);
									$blx = $bx;
									$blw = $bw;
									if (!$table['borders_separate']) {
										$blx -= ($table['max_cell_border_width']['L'] / 2);
										$blw += ($table['max_cell_border_width']['L'] / 2 + $table['max_cell_border_width']['R'] / 2);
									}
									$this->Line($blx, $this->y + ($this->splitTableBorderWidth / 2), $blx + $blw, $this->y + ($this->splitTableBorderWidth / 2));
									$this->DrawColor = $prevDrawColor;
									$this->_out($this->DrawColor);
									$this->SetLineWidth($lw);
									$this->SetLineJoin(2);
									$this->SetLineCap(2);
								}

								if (!$this->ColActive && ($i > 0 || $j > 0)) {
									if (isset($table['bgcolor'][-1])) {
										$color = $this->ConvertColor($table['bgcolor'][-1]);
										if ($color) {
											if (!$table['borders_separate']) {
												$bh -= $table['max_cell_border_width']['B'] / 2;
											}
											$this->tableBackgrounds[$level * 9][] = array('gradient' => false, 'x' => $bx, 'y' => $by, 'w' => $bw, 'h' => $bh, 'col' => $color);
										}
									}

									/* -- BACKGROUNDS -- */
									if (isset($table['gradient'])) {
										$g = $this->grad->parseBackgroundGradient($table['gradient']);
										if ($g) {
											$this->tableBackgrounds[$level * 9 + 1][] = array('gradient' => true, 'x' => $bx, 'y' => $by, 'w' => $bw, 'h' => $bh, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
										}
									}

									if (isset($table['background-image'])) {
										if ($table['background-image']['gradient'] && preg_match('/(-moz-)*(repeating-)*(linear|radial)-gradient/', $table['background-image']['gradient'])) {
											$g = $this->grad->parseMozGradient($table['background-image']['gradient']);
											if ($g) {
												$this->tableBackgrounds[$level * 9 + 1][] = array('gradient' => true, 'x' => $bx, 'y' => $by, 'w' => $bw, 'h' => $bh, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
											}
										} else {
											$image_id = $table['background-image']['image_id'];
											$orig_w = $table['background-image']['orig_w'];
											$orig_h = $table['background-image']['orig_h'];
											$x_pos = $table['background-image']['x_pos'];
											$y_pos = $table['background-image']['y_pos'];
											$x_repeat = $table['background-image']['x_repeat'];
											$y_repeat = $table['background-image']['y_repeat'];
											$resize = $table['background-image']['resize'];
											$opacity = $table['background-image']['opacity'];
											$itype = $table['background-image']['itype'];
											$this->tableBackgrounds[$level * 9 + 2][] = array('x' => $bx, 'y' => $by, 'w' => $bw, 'h' => $bh, 'image_id' => $image_id, 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $x_pos, 'y_pos' => $y_pos, 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'clippath' => '', 'resize' => $resize, 'opacity' => $opacity, 'itype' => $itype);
										}
									}
									/* -- END BACKGROUNDS -- */
								}

								// $this->AcceptPageBreak() has moved tablebuffer to $this->pages content
								if ($this->tableBackgrounds) {
									$s = $this->PrintTableBackgrounds();
									if ($this->bufferoutput) {
										$this->headerbuffer = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', '\\1' . "\n" . $s . "\n", $this->headerbuffer);
										$this->headerbuffer = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', " ", $this->headerbuffer);
									} else {
										$this->pages[$this->page] = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', '\\1' . "\n" . $s . "\n", $this->pages[$this->page]);
										$this->pages[$this->page] = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', " ", $this->pages[$this->page]);
									}
									$this->tableBackgrounds = array();
								}

								if ($split) {
									if ($i == 0 && $j == 0) {
										$y0 = -1;
									} elseif ($finalSpread) {
										$splitpg = 0;
										$startcol = 0;
										$startrow = $i;
									} else {
										$splitpg++;
										$startcol = $t;
										$returny -= $y;
									}
									return array(false, $startrow, $startcol, $splitpg, $returny, $y0);
								}

								$this->AddPage($this->CurOrientation);

								$this->_out('___TABLE___BACKGROUNDS' . $this->uniqstr);


								if ($this->tableClipPath) {
									$this->_out($this->tableClipPath);
								}

								// Added to correct for OddEven Margins
								$x = $x + $this->MarginCorrection;
								$x0 = $x0 + $this->MarginCorrection;

								if ($this->splitTableBorderWidth && ($this->keepColumns || !$this->ColActive) && empty($tableheader) && $i > 0 && $table['border_details']['T']['w']) {
									$prevDrawColor = $this->DrawColor;
									$lw = $this->LineWidth;
									$this->SetLineWidth($this->splitTableBorderWidth);
									$this->SetDColor($table['border_details']['T']['c']);
									$this->SetLineJoin(0);
									$this->SetLineCap(0);
									$blx += $this->MarginCorrection;
									$this->Line($blx, $this->y - ($this->splitTableBorderWidth / 2), $blx + $blw, $this->y - ($this->splitTableBorderWidth / 2));
									$this->DrawColor = $prevDrawColor;
									$this->_out($this->DrawColor);
									$this->SetLineWidth($lw);
									$this->SetLineJoin(2);
									$this->SetLineCap(2);
								}

								// Move down to account for half of top border-spacing or
								// extra half border width in case page was broken in middle
								if ($i > 0 && !$this->table_rotate && $level == 1 && $table['headernrows'] == 0) {
									if ($table['borders_separate']) {
										$adv = $table['border_spacing_V'] / 2;
									} else {
										$maxbwtop = 0;
										for ($ctj = 0; $ctj < $numcols; $ctj++) {
											if (isset($cells[$i][$ctj]) && $cells[$i][$ctj]) {
												if (!$this->simpleTables) {
													if ($this->packTableData) {
														list($bt, $br, $bb, $bl) = $this->_getBorderWidths($cells[$i][$ctj]['borderbin']);
													} else {
														$bt = $cells[$i][$ctj]['border_details']['T']['w'];
													}
													$maxbwtop = max($maxbwtop, $bt);
												} elseif ($this->simpleTables) {
													$maxbwtop = max($maxbwtop, $table['simple']['border_details']['T']['w']);
												}
											}
										}
										$adv = $maxbwtop / 2;
									}
									$this->y += $adv;
								}


								if ($this->table_rotate) {
									$this->tbrot_x0 = $this->lMargin + $this->blk[$this->blklvl]['outer_left_margin'] + $this->blk[$this->blklvl]['padding_left'] + $this->blk[$this->blklvl]['border_left']['w'];
									if ($table['borders_separate']) {
										$this->tbrot_h = $table['margin']['T'] + $table['padding']['T'] + $table['border_details']['T']['w'] + $table['border_spacing_V'] / 2;
									} else {
										$this->tbrot_h = $table['margin']['T'] + $table['max_cell_border_width']['T'];
									}
									$this->tbrot_y0 = $this->y;
									$pagetrigger = $y0 - $tableheaderadj + ($this->blk[$this->blklvl]['inner_width']);
								} else {
									$pagetrigger = $this->PageBreakTrigger;
								}

								if ($this->kwt_saved && $level == 1) {
									$this->kwt_moved = true;
								}


								if (!empty($tableheader)) {
									$ya = $this->y;
									$this->TableHeaderFooter($tableheader, $tablestartpage, $tablestartcolumn, 'H', $level);
									if ($this->table_rotate) {
										$this->tbrot_h = $this->y - $ya;
									}
									$tableheaderadj = $this->y - $ya;
								} elseif ($i == 0 && !$this->table_rotate && $level == 1 && !$this->ColActive) {
									// Advance down page
									if ($table['borders_separate']) {
										$adv = $table['border_spacing_V'] / 2 + $table['border_details']['T']['w'] + $table['padding']['T'];
									} else {
										$adv = $table['max_cell_border_width']['T'] / 2;
									}
									if ($adv) {
										if ($this->table_rotate) {
											$this->y += ($adv);
										} else {
											$this->DivLn($adv, $this->blklvl, true);
										}
									}
								}

								$outerfilled = 0;
								$y = $y0 = $this->y;
							}

							/* -- COLUMNS -- */
							// COLS
							// COLUMN CHANGE
							if ($this->CurrCol != $oldcolumn) {
								// Added to correct for Columns
								$x += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
								$x0 += $this->ChangeColumn * ($this->ColWidth + $this->ColGap);
								if ($this->CurrCol == 0) {  // just added a page - possibly with tableheader
									$y0 = $this->y;  // this->y0 is global used by Columns - $y0 is internal to tablewrite
								} else {
									$y0 = $this->y0;  // this->y0 is global used by Columns - $y0 is internal to tablewrite
								}
								$y = $y0;
								$outerfilled = 0;
								if ($this->CurrCol != 0 && ($this->keepColumns && $this->ColActive) && !empty($tableheader) && $i > 0) {
									$this->x = $x;
									$this->y = $y;
									$this->TableHeaderFooter($tableheader, $tablestartpage, $tablestartcolumn, 'H', $level);
									$y0 = $y = $this->y;
								}
							}
							/* -- END COLUMNS -- */
						}
						$skippage = true;
					}

					$this->x = $x;
					$this->y = $y;

					if ($this->kwt_saved && $level == 1) {
						$this->printkwtbuffer();
						$x0 = $x = $this->x;
						$y0 = $y = $this->y;
						$this->kwt_moved = false;
						$this->kwt_saved = false;
					}


					// Set the Page & Column where table actually starts
					if ($i == 0 && $j == 0 && $level == 1) {
						if (($this->mirrorMargins) && (($this->page) % 2 == 0)) {    // EVEN
							$tablestartpage = 'EVEN';
						} elseif (($this->mirrorMargins) && (($this->page) % 2 == 1)) {    // ODD
							$tablestartpage = 'ODD';
						} else {
							$tablestartpage = '';
						}
						$tablestartpageno = $this->page;
						if ($this->ColActive) {
							$tablestartcolumn = $this->CurrCol;
						} // *COLUMNS*
					}


					//ALIGN
					$align = $cell['a'];


					/* -- COLUMNS -- */
					// If outside columns, this is done in PaintDivBB
					if ($this->ColActive) {
						//OUTER FILL BGCOLOR of DIVS
						if ($this->blklvl > 0 && ($j == 0) && !$this->table_rotate && $level == 1) {
							$firstblockfill = $this->GetFirstBlockFill();
							if ($firstblockfill && $this->blklvl >= $firstblockfill) {
								$divh = $maxrowheight;
								// Last row
								if ((!isset($cell['rowspan']) && $i == $numrows - 1) || (isset($cell['rowspan']) && (($i == $numrows - 1 && $cell['rowspan'] < 2) || ($cell['rowspan'] > 1 && ($i + $cell['rowspan'] - 1) == $numrows - 1)))) {
									if ($table['borders_separate']) {
										$adv = $table['margin']['B'] + $table['padding']['B'] + $table['border_details']['B']['w'] + $table['border_spacing_V'] / 2;
									} else {
										$adv = $table['margin']['B'] + $table['max_cell_border_width']['B'] / 2;
									}
									$divh += $adv;  //last row: fill bottom half of bottom border (y advanced at end)
								}

								if (($this->y + $divh) > $outerfilled) { // if not already painted by previous rowspan
									$bak_x = $this->x;
									$bak_y = $this->y;
									if ($outerfilled > $this->y) {
										$divh = ($this->y + $divh) - $outerfilled;
										$this->y = $outerfilled;
									}

									$this->DivLn($divh, -3, false);
									$outerfilled = $this->y + $divh;
									// Reset current block fill
									$bcor = $this->blk[$this->blklvl]['bgcolorarray'];
									if ($bcor)
										$this->SetFColor($bcor);
									$this->x = $bak_x;
									$this->y = $bak_y;
								}
							}
						}
					}


					//TABLE BACKGROUND FILL BGCOLOR - for cellSpacing
					if ($this->ColActive) {
						if ($table['borders_separate']) {
							$fill = isset($table['bgcolor'][-1]) ? $table['bgcolor'][-1] : 0;
							if ($fill) {
								$color = $this->ConvertColor($fill);
								if ($color) {
									$xadj = ($table['border_spacing_H'] / 2);
									$yadj = ($table['border_spacing_V'] / 2);
									$wadj = $table['border_spacing_H'];
									$hadj = $table['border_spacing_V'];
									if ($i == 0) {  // Top
										$yadj += $table['padding']['T'] + $table['border_details']['T']['w'];
										$hadj += $table['padding']['T'] + $table['border_details']['T']['w'];
									}
									if ($j == 0) {  // Left
										$xadj += $table['padding']['L'] + $table['border_details']['L']['w'];
										$wadj += $table['padding']['L'] + $table['border_details']['L']['w'];
									}
									if ($i == ($numrows - 1) || (isset($cell['rowspan']) && ($i + $cell['rowspan']) == $numrows) || (!isset($cell['rowspan']) && ($i + 1) == $numrows)) { // Bottom
										$hadj += $table['padding']['B'] + $table['border_details']['B']['w'];
									}
									if ($j == ($numcols - 1) || (isset($cell['colspan']) && ($j + $cell['colspan']) == $numcols) || (!isset($cell['colspan']) && ($j + 1) == $numcols)) { // Right
										$wadj += $table['padding']['R'] + $table['border_details']['R']['w'];
									}
									$this->SetFColor($color);
									$this->Rect($x - $xadj, $y - $yadj, $w + $wadj, $h + $hadj, 'F');
								}
							}
						}
					}
					/* -- END COLUMNS -- */

					if ($table['empty_cells'] != 'hide' || !empty($cell['textbuffer']) || (isset($cell['nestedcontent']) && $cell['nestedcontent']) || !$table['borders_separate']) {
						$paintcell = true;
					} else {
						$paintcell = false;
					}

					//Set Borders
					$bord = 0;
					$bord_det = array();

					if (!$this->simpleTables) {
						if ($this->packTableData) {
							$c = $this->_unpackCellBorder($cell['borderbin']);
							$bord = $c['border'];
							$bord_det = $c['border_details'];
						} else {
							$bord = $cell['border'];
							$bord_det = $cell['border_details'];
						}
					} elseif ($this->simpleTables) {
						$bord = $table['simple']['border'];
						$bord_det = $table['simple']['border_details'];
					}

					//TABLE ROW OR CELL FILL BGCOLOR
					$fill = 0;
					if (isset($cell['bgcolor']) && $cell['bgcolor'] && $cell['bgcolor'] != 'transparent') {
						$fill = $cell['bgcolor'];
						$leveladj = 6;
					} elseif (isset($table['bgcolor'][$i]) && $table['bgcolor'][$i] && $table['bgcolor'][$i] != 'transparent') { // Row color
						$fill = $table['bgcolor'][$i];
						$leveladj = 3;
					}
					if ($fill && $paintcell) {
						$color = $this->ConvertColor($fill);
						if ($color) {
							if ($table['borders_separate']) {
								if ($this->ColActive) {
									$this->SetFColor($color);
									$this->Rect($x + ($table['border_spacing_H'] / 2), $y + ($table['border_spacing_V'] / 2), $w - $table['border_spacing_H'], $h - $table['border_spacing_V'], 'F');
								} else {
									$this->tableBackgrounds[$level * 9 + $leveladj][] = array('gradient' => false, 'x' => ($x + ($table['border_spacing_H'] / 2)), 'y' => ($y + ($table['border_spacing_V'] / 2)), 'w' => ($w - $table['border_spacing_H']), 'h' => ($h - $table['border_spacing_V']), 'col' => $color);
								}
							} else {
								if ($this->ColActive) {
									$this->SetFColor($color);
									$this->Rect($x, $y, $w, $h, 'F');
								} else {
									$this->tableBackgrounds[$level * 9 + $leveladj][] = array('gradient' => false, 'x' => $x, 'y' => $y, 'w' => $w, 'h' => $h, 'col' => $color);
								}
							}
						}
					}

					/* -- BACKGROUNDS -- */
					if (isset($cell['gradient']) && $cell['gradient'] && $paintcell) {
						$g = $this->grad->parseBackgroundGradient($cell['gradient']);
						if ($g) {
							if ($table['borders_separate']) {
								$px = $x + ($table['border_spacing_H'] / 2);
								$py = $y + ($table['border_spacing_V'] / 2);
								$pw = $w - $table['border_spacing_H'];
								$ph = $h - $table['border_spacing_V'];
							} else {
								$px = $x;
								$py = $y;
								$pw = $w;
								$ph = $h;
							}
							if ($this->ColActive) {
								$this->grad->Gradient($px, $py, $pw, $ph, $g['type'], $g['stops'], $g['colorspace'], $g['coords'], $g['extend']);
							} else {
								$this->tableBackgrounds[$level * 9 + 7][] = array('gradient' => true, 'x' => $px, 'y' => $py, 'w' => $pw, 'h' => $ph, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
							}
						}
					}

					if (isset($cell['background-image']) && $paintcell) {
						if (isset($cell['background-image']['gradient']) && $cell['background-image']['gradient'] && preg_match('/(-moz-)*(repeating-)*(linear|radial)-gradient/', $cell['background-image']['gradient'])) {
							$g = $this->grad->parseMozGradient($cell['background-image']['gradient']);
							if ($g) {
								if ($table['borders_separate']) {
									$px = $x + ($table['border_spacing_H'] / 2);
									$py = $y + ($table['border_spacing_V'] / 2);
									$pw = $w - $table['border_spacing_H'];
									$ph = $h - $table['border_spacing_V'];
								} else {
									$px = $x;
									$py = $y;
									$pw = $w;
									$ph = $h;
								}
								if ($this->ColActive) {
									$this->grad->Gradient($px, $py, $pw, $ph, $g['type'], $g['stops'], $g['colorspace'], $g['coords'], $g['extend']);
								} else {
									$this->tableBackgrounds[$level * 9 + 7][] = array('gradient' => true, 'x' => $px, 'y' => $py, 'w' => $pw, 'h' => $ph, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
								}
							}
						} elseif (isset($cell['background-image']['image_id']) && $cell['background-image']['image_id']) { // Background pattern
							$n = count($this->patterns) + 1;
							if ($table['borders_separate']) {
								$px = $x + ($table['border_spacing_H'] / 2);
								$py = $y + ($table['border_spacing_V'] / 2);
								$pw = $w - $table['border_spacing_H'];
								$ph = $h - $table['border_spacing_V'];
							} else {
								$px = $x;
								$py = $y;
								$pw = $w;
								$ph = $h;
							}
							if ($this->ColActive) {
								list($orig_w, $orig_h, $x_repeat, $y_repeat) = $this->_resizeBackgroundImage($cell['background-image']['orig_w'], $cell['background-image']['orig_h'], $pw, $ph, $cell['background-image']['resize'], $cell['background-image']['x_repeat'], $cell['background-image']['y_repeat']);
								$this->patterns[$n] = array('x' => $px, 'y' => $py, 'w' => $pw, 'h' => $ph, 'pgh' => $this->h, 'image_id' => $cell['background-image']['image_id'], 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $cell['background-image']['x_pos'], 'y_pos' => $cell['background-image']['y_pos'], 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat);
								if ($cell['background-image']['opacity'] > 0 && $cell['background-image']['opacity'] < 1) {
									$opac = $this->SetAlpha($cell['background-image']['opacity'], 'Normal', true);
								} else {
									$opac = '';
								}
								$this->_out(sprintf('q /Pattern cs /P%d scn %s %.3F %.3F %.3F %.3F re f Q', $n, $opac, $px * _MPDFK, ($this->h - $py) * _MPDFK, $pw * _MPDFK, -$ph * _MPDFK));
							} else {
								$image_id = $cell['background-image']['image_id'];
								$orig_w = $cell['background-image']['orig_w'];
								$orig_h = $cell['background-image']['orig_h'];
								$x_pos = $cell['background-image']['x_pos'];
								$y_pos = $cell['background-image']['y_pos'];
								$x_repeat = $cell['background-image']['x_repeat'];
								$y_repeat = $cell['background-image']['y_repeat'];
								$resize = $cell['background-image']['resize'];
								$opacity = $cell['background-image']['opacity'];
								$itype = $cell['background-image']['itype'];
								$this->tableBackgrounds[$level * 9 + 8][] = array('x' => $px, 'y' => $py, 'w' => $pw, 'h' => $ph, 'image_id' => $image_id, 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $x_pos, 'y_pos' => $y_pos, 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'clippath' => '', 'resize' => $resize, 'opacity' => $opacity, 'itype' => $itype);
							}
						}
					}
					/* -- END BACKGROUNDS -- */

					if (isset($cell['colspan']) && $cell['colspan'] > 1) {
						$ccolsp = $cell['colspan'];
					} else {
						$ccolsp = 1;
					}
					if (isset($cell['rowspan']) && $cell['rowspan'] > 1) {
						$crowsp = $cell['rowspan'];
					} else {
						$crowsp = 1;
					}


					// but still need to do this for repeated headers...
					if (!$table['borders_separate'] && $this->tabletheadjustfinished && !$this->simpleTables) {
						if (isset($table['topntail']) && $table['topntail']) {
							$bord_det['T'] = $this->border_details($table['topntail']);
							$bord_det['T']['w'] /= $this->shrin_k;
							$this->setBorder($bord, _BORDER_TOP);
						}
						if (isset($table['thead-underline']) && $table['thead-underline']) {
							$bord_det['T'] = $this->border_details($table['thead-underline']);
							$bord_det['T']['w'] /= $this->shrin_k;
							$this->setBorder($bord, _BORDER_TOP);
						}
					}


					//Get info of first row ==>> table header
					//Use > 1 row if THEAD
					if (isset($table['is_thead'][$i]) && $table['is_thead'][$i] && $level == 1) {
						if ($j == 0)
							$tableheaderrowheight += $table['hr'][$i];
						$tableheader[$i][0]['trbackground-images'] = (isset($table['trbackground-images'][$i]) ? $table['trbackground-images'][$i] : null);
						$tableheader[$i][0]['trgradients'] = (isset($table['trgradients'][$i]) ? $table['trgradients'][$i] : null);
						$tableheader[$i][0]['trbgcolor'] = (isset($table['bgcolor'][$i]) ? $table['bgcolor'][$i] : null);
						$tableheader[$i][$j]['x'] = $x;
						$tableheader[$i][$j]['y'] = $y;
						$tableheader[$i][$j]['h'] = $h;
						$tableheader[$i][$j]['w'] = $w;
						if (isset($cell['textbuffer'])) {
							$tableheader[$i][$j]['textbuffer'] = $cell['textbuffer'];
						} else {
							$tableheader[$i][$j]['textbuffer'] = '';
						}
						$tableheader[$i][$j]['a'] = $cell['a'];
						$tableheader[$i][$j]['R'] = $cell['R'];

						$tableheader[$i][$j]['va'] = $cell['va'];
						$tableheader[$i][$j]['mih'] = $cell['mih'];
						$tableheader[$i][$j]['gradient'] = (isset($cell['gradient']) ? $cell['gradient'] : null); // *BACKGROUNDS*
						$tableheader[$i][$j]['background-image'] = (isset($cell['background-image']) ? $cell['background-image'] : null); // *BACKGROUNDS*
						$tableheader[$i][$j]['rowspan'] = (isset($cell['rowspan']) ? $cell['rowspan'] : null);
						$tableheader[$i][$j]['colspan'] = (isset($cell['colspan']) ? $cell['colspan'] : null);
						$tableheader[$i][$j]['bgcolor'] = $cell['bgcolor'];

						if (!$this->simpleTables) {
							$tableheader[$i][$j]['border'] = $bord;
							$tableheader[$i][$j]['border_details'] = $bord_det;
						} elseif ($this->simpleTables) {
							$tableheader[$i][$j]['border'] = $table['simple']['border'];
							$tableheader[$i][$j]['border_details'] = $table['simple']['border_details'];
						}
						$tableheader[$i][$j]['padding'] = $cell['padding'];
						if (isset($cell['direction']))
							$tableheader[$i][$j]['direction'] = $cell['direction'];
						if (isset($cell['cellLineHeight']))
							$tableheader[$i][$j]['cellLineHeight'] = $cell['cellLineHeight'];
						if (isset($cell['cellLineStackingStrategy']))
							$tableheader[$i][$j]['cellLineStackingStrategy'] = $cell['cellLineStackingStrategy'];
						if (isset($cell['cellLineStackingShift']))
							$tableheader[$i][$j]['cellLineStackingShift'] = $cell['cellLineStackingShift'];
					}

					// CELL BORDER
					if ($bord) {
						if ($table['borders_separate'] && $paintcell) {
							$this->_tableRect($x + ($table['border_spacing_H'] / 2) + ($bord_det['L']['w'] / 2), $y + ($table['border_spacing_V'] / 2) + ($bord_det['T']['w'] / 2), $w - $table['border_spacing_H'] - ($bord_det['L']['w'] / 2) - ($bord_det['R']['w'] / 2), $h - $table['border_spacing_V'] - ($bord_det['T']['w'] / 2) - ($bord_det['B']['w'] / 2), $bord, $bord_det, false, $table['borders_separate']);
						} elseif (!$table['borders_separate']) {
							$this->_tableRect($x, $y, $w, $h, $bord, $bord_det, true, $table['borders_separate']);  // true causes buffer
						}
					}

					//VERTICAL ALIGN
					if ($cell['R'] && INTVAL($cell['R']) > 0 && INTVAL($cell['R']) < 90 && isset($cell['va']) && $cell['va'] != 'B') {
						$cell['va'] = 'B';
					}
					if (!isset($cell['va']) || $cell['va'] == 'M')
						$this->y += ($h - $cell['mih']) / 2;
					elseif (isset($cell['va']) && $cell['va'] == 'B')
						$this->y += $h - $cell['mih'];

					// NESTED CONTENT
					// TEXT (and nested tables)

					$this->divwidth = $w;
					if (!empty($cell['textbuffer'])) {
						$this->cellTextAlign = $align;
						$this->cellLineHeight = $cell['cellLineHeight'];
						$this->cellLineStackingStrategy = $cell['cellLineStackingStrategy'];
						$this->cellLineStackingShift = $cell['cellLineStackingShift'];
						if ($level == 1) {
							if (isset($table['is_tfoot'][$i]) && $table['is_tfoot'][$i]) {
								if (preg_match('/{colsum([0-9]*)[_]*}/', $cell['textbuffer'][0][0], $m)) {
									$rep = sprintf("%01." . intval($m[1]) . "f", $this->colsums[$j]);
									$cell['textbuffer'][0][0] = preg_replace('/{colsum[0-9_]*}/', $rep, $cell['textbuffer'][0][0]);
								}
							} elseif (!isset($table['is_thead'][$i])) {
								if (isset($this->colsums[$j])) {
									$this->colsums[$j] += floatval(preg_replace('/^[^0-9\.\,]*/', '', $cell['textbuffer'][0][0]));
								} else {
									$this->colsums[$j] = floatval(preg_replace('/^[^0-9\.\,]*/', '', $cell['textbuffer'][0][0]));
								}
							}
						}
						$opy = $this->y;
						// mPDF ITERATION
						if ($this->iterationCounter) {
							foreach ($cell['textbuffer'] AS $k => $t) {
								if (preg_match('/{iteration ([a-zA-Z0-9_]+)}/', $t[0], $m)) {
									$vname = '__' . $m[1] . '_';
									if (!isset($this->$vname)) {
										$this->$vname = 1;
									} else {
										$this->$vname++;
									}
									$cell['textbuffer'][$k][0] = preg_replace('/{iteration ' . $m[1] . '}/', $this->$vname, $cell['textbuffer'][$k][0]);
								}
							}
						}


						if ($cell['R']) {
							$cellPtSize = $cell['textbuffer'][0][11] / $this->shrin_k;
							if (!$cellPtSize) {
								$cellPtSize = $this->default_font_size;
							}
							$cellFontHeight = ($cellPtSize / _MPDFK);
							$opx = $this->x;
							$angle = INTVAL($cell['R']);
							// Only allow 45 to 89 degrees (when bottom-aligned) or exactly 90 or -90
							if ($angle > 90) {
								$angle = 90;
							} elseif ($angle > 0 && $angle < 45) {
								$angle = 45;
							} elseif ($angle < 0) {
								$angle = -90;
							}
							$offset = ((sin(deg2rad($angle))) * 0.37 * $cellFontHeight);
							if (isset($cell['a']) && $cell['a'] == 'R') {
								$this->x += ($w) + ($offset) - ($cellFontHeight / 3) - ($cell['padding']['R'] + ($table['border_spacing_H'] / 2));
							} elseif (!isset($cell['a']) || $cell['a'] == 'C') {
								$this->x += ($w / 2) + ($offset);
							} else {
								$this->x += ($offset) + ($cellFontHeight / 3) + ($cell['padding']['L'] + ($table['border_spacing_H'] / 2));
							}
							$str = '';
							foreach ($cell['textbuffer'] AS $t) {
								$str .= $t[0] . ' ';
							}
							$str = rtrim($str);
							if (!isset($cell['va']) || $cell['va'] == 'M') {
								$this->y -= ($h - $cell['mih']) / 2; //Undo what was added earlier VERTICAL ALIGN
								if ($angle > 0) {
									$this->y += (($h - $cell['mih']) / 2) + $cell['padding']['T'] + ($cell['mih'] - ($cell['padding']['T'] + $cell['padding']['B']));
								} elseif ($angle < 0) {
									$this->y += (($h - $cell['mih']) / 2) + ($cell['padding']['T'] + ($table['border_spacing_V'] / 2));
								}
							} elseif (isset($cell['va']) && $cell['va'] == 'B') {
								$this->y -= $h - $cell['mih']; //Undo what was added earlier VERTICAL ALIGN
								if ($angle > 0) {
									$this->y += $h - ($cell['padding']['B'] + ($table['border_spacing_V'] / 2));
								} elseif ($angle < 0) {
									$this->y += $h - $cell['mih'] + ($cell['padding']['T'] + ($table['border_spacing_V'] / 2));
								}
							} elseif (isset($cell['va']) && $cell['va'] == 'T') {
								if ($angle > 0) {
									$this->y += $cell['mih'] - ($cell['padding']['B'] + ($table['border_spacing_V'] / 2));
								} elseif ($angle < 0) {
									$this->y += ($cell['padding']['T'] + ($table['border_spacing_V'] / 2));
								}
							}
							$this->Rotate($angle, $this->x, $this->y);
							$s_fs = $this->FontSizePt;
							$s_f = $this->FontFamily;
							$s_st = $this->FontStyle;
							if (!empty($cell['textbuffer'][0][3])) { //Font Color
								$cor = $cell['textbuffer'][0][3];
								$this->SetTColor($cor);
							}
							$this->SetFont($cell['textbuffer'][0][4], $cell['textbuffer'][0][2], $cellPtSize, true, true);

							$this->magic_reverse_dir($str, $this->directionality, $cell['textbuffer'][0][18]);
							$this->Text($this->x, $this->y, $str, $cell['textbuffer'][0][18], $cell['textbuffer'][0][8]); // textvar
							$this->Rotate(0);
							$this->SetFont($s_f, $s_st, $s_fs, true, true);
							$this->SetTColor(0);
							$this->x = $opx;
						} else {

							if (!$this->simpleTables) {
								if ($bord_det) {
									$btlw = $bord_det['L']['w'];
									$btrw = $bord_det['R']['w'];
									$bttw = $bord_det['T']['w'];
								} else {
									$btlw = 0;
									$btrw = 0;
									$bttw = 0;
								}
								if ($table['borders_separate']) {
									$xadj = $btlw + $cell['padding']['L'] + ($table['border_spacing_H'] / 2);
									$wadj = $btlw + $btrw + $cell['padding']['L'] + $cell['padding']['R'] + $table['border_spacing_H'];
									$yadj = $bttw + $cell['padding']['T'] + ($table['border_spacing_H'] / 2);
								} else {
									$xadj = $btlw / 2 + $cell['padding']['L'];
									$wadj = ($btlw + $btrw) / 2 + $cell['padding']['L'] + $cell['padding']['R'];
									$yadj = $bttw / 2 + $cell['padding']['T'];
								}
							} elseif ($this->simpleTables) {
								if ($table['borders_separate']) { // NB twice border width
									$xadj = $table['simple']['border_details']['L']['w'] + $cell['padding']['L'] + ($table['border_spacing_H'] / 2);
									$wadj = $table['simple']['border_details']['L']['w'] + $table['simple']['border_details']['R']['w'] + $cell['padding']['L'] + $cell['padding']['R'] + $table['border_spacing_H'];
									$yadj = $table['simple']['border_details']['T']['w'] + $cell['padding']['T'] + ($table['border_spacing_H'] / 2);
								} else {
									$xadj = $table['simple']['border_details']['L']['w'] / 2 + $cell['padding']['L'];
									$wadj = ($table['simple']['border_details']['L']['w'] + $table['simple']['border_details']['R']['w']) / 2 + $cell['padding']['L'] + $cell['padding']['R'];
									$yadj = $table['simple']['border_details']['T']['w'] / 2 + $cell['padding']['T'];
								}
							}
							$this->decimal_offset = 0;
							if (substr($cell['a'], 0, 1) == 'D') {
								if (isset($cell['colspan']) && $cell['colspan'] > 1) {
									$this->cellTextAlign = $c['a'] = substr($cell['a'], 2, 1);
								} else {
									$smax = $table['decimal_align'][$j]['maxs0'];
									$d_content = $table['decimal_align'][$j]['maxs0'] + $table['decimal_align'][$j]['maxs1'];
									$this->decimal_offset = $smax;
									$extra = ($w - $d_content - $wadj);
									if ($extra > 0) {
										if (substr($cell['a'], 2, 1) == 'R') {
											$this->decimal_offset += $extra;
										} elseif (substr($cell['a'], 2, 1) == 'C') {
											$this->decimal_offset += ($extra) / 2;
										}
									}
								}
							}
							$this->divwidth = $w - $wadj;
							if ($this->divwidth == 0) {
								$this->divwidth = 0.0001;
							}
							$this->x += $xadj;
							$this->y += $yadj;
							$this->printbuffer($cell['textbuffer'], '', true, false, $cell['direction']);
						}
						$this->y = $opy;
					}

					/* -- BACKGROUNDS -- */
					if (!$this->ColActive) {
						if (isset($table['trgradients'][$i]) && ($j == 0 || $table['borders_separate'])) {
							$g = $this->grad->parseBackgroundGradient($table['trgradients'][$i]);
							if ($g) {
								$gx = $x0;
								$gy = $y;
								$gh = $h;
								$gw = $table['w'] - ($table['max_cell_border_width']['L'] / 2) - ($table['max_cell_border_width']['R'] / 2) - $table['margin']['L'] - $table['margin']['R'];
								if ($table['borders_separate']) {
									$gw -= ($table['padding']['L'] + $table['border_details']['L']['w'] + $table['padding']['R'] + $table['border_details']['R']['w'] + $table['border_spacing_H']);
									$clx = $x + ($table['border_spacing_H'] / 2);
									$cly = $y + ($table['border_spacing_V'] / 2);
									$clw = $w - $table['border_spacing_H'];
									$clh = $h - $table['border_spacing_V'];
									// Set clipping path
									$s = $this->_setClippingPath($clx, $cly, $clw, $clh); // mPDF 6
									$this->tableBackgrounds[$level * 9 + 4][] = array('gradient' => true, 'x' => $gx + ($table['border_spacing_H'] / 2), 'y' => $gy + ($table['border_spacing_V'] / 2), 'w' => $gw - $table['border_spacing_V'], 'h' => $gh - $table['border_spacing_H'], 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => $s);
								} else {
									$this->tableBackgrounds[$level * 9 + 4][] = array('gradient' => true, 'x' => $gx, 'y' => $gy, 'w' => $gw, 'h' => $gh, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
								}
							}
						}
						if (isset($table['trbackground-images'][$i]) && ($j == 0 || $table['borders_separate'])) {
							if (isset($table['trbackground-images'][$i]['gradient']) && preg_match('/(-moz-)*(repeating-)*(linear|radial)-gradient/', $table['trbackground-images'][$i]['gradient'])) {
								$g = $this->grad->parseMozGradient($table['trbackground-images'][$i]['gradient']);
								if ($g) {
									$gx = $x0;
									$gy = $y;
									$gh = $h;
									$gw = $table['w'] - ($table['max_cell_border_width']['L'] / 2) - ($table['max_cell_border_width']['R'] / 2) - $table['margin']['L'] - $table['margin']['R'];
									if ($table['borders_separate']) {
										$gw -= ($table['padding']['L'] + $table['border_details']['L']['w'] + $table['padding']['R'] + $table['border_details']['R']['w'] + $table['border_spacing_H']);
										$clx = $x + ($table['border_spacing_H'] / 2);
										$cly = $y + ($table['border_spacing_V'] / 2);
										$clw = $w - $table['border_spacing_H'];
										$clh = $h - $table['border_spacing_V'];
										// Set clipping path
										$s = $this->_setClippingPath($clx, $cly, $clw, $clh); // mPDF 6
										$this->tableBackgrounds[$level * 9 + 4][] = array('gradient' => true, 'x' => $gx + ($table['border_spacing_H'] / 2), 'y' => $gy + ($table['border_spacing_V'] / 2), 'w' => $gw - $table['border_spacing_V'], 'h' => $gh - $table['border_spacing_H'], 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => $s);
									} else {
										$this->tableBackgrounds[$level * 9 + 4][] = array('gradient' => true, 'x' => $gx, 'y' => $gy, 'w' => $gw, 'h' => $gh, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
									}
								}
							} else {
								$image_id = $table['trbackground-images'][$i]['image_id'];
								$orig_w = $table['trbackground-images'][$i]['orig_w'];
								$orig_h = $table['trbackground-images'][$i]['orig_h'];
								$x_pos = $table['trbackground-images'][$i]['x_pos'];
								$y_pos = $table['trbackground-images'][$i]['y_pos'];
								$x_repeat = $table['trbackground-images'][$i]['x_repeat'];
								$y_repeat = $table['trbackground-images'][$i]['y_repeat'];
								$resize = $table['trbackground-images'][$i]['resize'];
								$opacity = $table['trbackground-images'][$i]['opacity'];
								$itype = $table['trbackground-images'][$i]['itype'];
								$clippath = '';
								$gx = $x0;
								$gy = $y;
								$gh = $h;
								$gw = $table['w'] - ($table['max_cell_border_width']['L'] / 2) - ($table['max_cell_border_width']['R'] / 2) - $table['margin']['L'] - $table['margin']['R'];
								if ($table['borders_separate']) {
									$gw -= ($table['padding']['L'] + $table['border_details']['L']['w'] + $table['padding']['R'] + $table['border_details']['R']['w'] + $table['border_spacing_H']);
									$clx = $x + ($table['border_spacing_H'] / 2);
									$cly = $y + ($table['border_spacing_V'] / 2);
									$clw = $w - $table['border_spacing_H'];
									$clh = $h - $table['border_spacing_V'];
									// Set clipping path
									$s = $this->_setClippingPath($clx, $cly, $clw, $clh); // mPDF 6
									$this->tableBackgrounds[$level * 9 + 5][] = array('x' => $gx + ($table['border_spacing_H'] / 2), 'y' => $gy + ($table['border_spacing_V'] / 2), 'w' => $gw - $table['border_spacing_V'], 'h' => $gh - $table['border_spacing_H'], 'image_id' => $image_id, 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $x_pos, 'y_pos' => $y_pos, 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'clippath' => $s, 'resize' => $resize, 'opacity' => $opacity, 'itype' => $itype);
								} else {
									$this->tableBackgrounds[$level * 9 + 5][] = array('x' => $gx, 'y' => $gy, 'w' => $gw, 'h' => $gh, 'image_id' => $image_id, 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $x_pos, 'y_pos' => $y_pos, 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'clippath' => '', 'resize' => $resize, 'opacity' => $opacity, 'itype' => $itype);
								}
							}
						}
					}

					/* -- END BACKGROUNDS -- */

					// TABLE BORDER - if separate
					if (($table['borders_separate'] || ($this->simpleTables && !$table['simple']['border'])) && $table['border']) {
						$halfspaceL = $table['padding']['L'] + ($table['border_spacing_H'] / 2);
						$halfspaceR = $table['padding']['R'] + ($table['border_spacing_H'] / 2);
						$halfspaceT = $table['padding']['T'] + ($table['border_spacing_V'] / 2);
						$halfspaceB = $table['padding']['B'] + ($table['border_spacing_V'] / 2);
						$tbx = $x;
						$tby = $y;
						$tbw = $w;
						$tbh = $h;
						$tab_bord = 0;

						$corner = '';
						if ($i == 0) {  // Top
							$tby -= $halfspaceT + ($table['border_details']['T']['w'] / 2);
							$tbh += $halfspaceT + ($table['border_details']['T']['w'] / 2);
							$this->setBorder($tab_bord, _BORDER_TOP);
							$corner .= 'T';
						}
						if ($i == ($numrows - 1) || (isset($cell['rowspan']) && ($i + $cell['rowspan']) == $numrows)) { // Bottom
							$tbh += $halfspaceB + ($table['border_details']['B']['w'] / 2);
							$this->setBorder($tab_bord, _BORDER_BOTTOM);
							$corner .= 'B';
						}
						if ($j == 0) {  // Left
							$tbx -= $halfspaceL + ($table['border_details']['L']['w'] / 2);
							$tbw += $halfspaceL + ($table['border_details']['L']['w'] / 2);
							$this->setBorder($tab_bord, _BORDER_LEFT);
							$corner .= 'L';
						}
						if ($j == ($numcols - 1) || (isset($cell['colspan']) && ($j + $cell['colspan']) == $numcols)) { // Right
							$tbw += $halfspaceR + ($table['border_details']['R']['w'] / 2);
							$this->setBorder($tab_bord, _BORDER_RIGHT);
							$corner .= 'R';
						}
						$this->_tableRect($tbx, $tby, $tbw, $tbh, $tab_bord, $table['border_details'], false, $table['borders_separate'], 'table', $corner, $table['border_spacing_V'], $table['border_spacing_H']);
					}

					unset($cell);
					//Reset values
					$this->Reset();
				}//end of (if isset(cells)...)
			}// end of columns

			$newpagestarted = false;
			$this->tabletheadjustfinished = false;

			/* -- COLUMNS -- */
			if ($this->ColActive) {
				if (!$this->table_keep_together && $i < $numrows - 1 && $level == 1) {
					$this->breakpoints[$this->CurrCol][] = $y + $h;
				} // mPDF 6
				if (count($this->cellBorderBuffer)) {
					$this->printcellbuffer();
				}
			}
			/* -- END COLUMNS -- */

			if ($i == $numrows - 1) {
				$this->y = $y + $h;
			} //last row jump (update this->y position)
			if ($this->table_rotate && $level == 1) {
				$this->tbrot_h += $h;
			}
		}// end of rows

		if ($this->progressBar) {
			$this->UpdateProgressBar(7, 70, ' ');
		} // *PROGRESS-BAR*

		if (count($this->cellBorderBuffer)) {
			$this->printcellbuffer();
		}


		if ($this->tableClipPath) {
			$this->_out("Q");
		}
		$this->tableClipPath = '';

		// Advance down page by half width of bottom border
		if ($table['borders_separate']) {
			$this->y += $table['padding']['B'] + $table['border_details']['B']['w'] + $table['border_spacing_V'] / 2;
		} else {
			$this->y += $table['max_cell_border_width']['B'] / 2;
		}

		if ($table['borders_separate'] && $level == 1) {
			$this->tbrot_h += $table['margin']['B'] + $table['padding']['B'] + $table['border_details']['B']['w'] + $table['border_spacing_V'] / 2;
		} elseif ($level == 1) {
			$this->tbrot_h += $table['margin']['B'] + $table['max_cell_border_width']['B'] / 2;
		}

		$bx = $x0;
		$by = $y0;
		if ($table['borders_separate']) {
			$bx -= ($table['padding']['L'] + $table['border_details']['L']['w'] + $table['border_spacing_H'] / 2);
			if ($tablestartpageno != $this->page) { // IF broken across page
				$by += $table['max_cell_border_width']['T'] / 2;
				if (empty($tableheader)) {
					$by -= ($table['border_spacing_V'] / 2);
				}
			} elseif ($split && $startrow > 0 && empty($tableheader)) {
				$by -= ($table['border_spacing_V'] / 2);
			} else {
				$by -= ($table['padding']['T'] + $table['border_details']['T']['w'] + $table['border_spacing_V'] / 2);
			}
		} elseif ($tablestartpageno != $this->page && !empty($tableheader)) {
			$by += $maxbwtop / 2;
		}
		$by -= $tableheaderadj;
		$bh = $this->y - $by;
		if (!$table['borders_separate']) {
			$bh -= $table['max_cell_border_width']['B'] / 2;
		}

		if ($split) {
			$bw = 0;
			$finalSpread = true;
			for ($t = $startcol; $t < $numcols; $t++) {
				if ($table['colPg'][$t] == $splitpg) {
					$bw += $table['wc'][$t];
				}
				if ($table['colPg'][$t] > $splitpg) {
					$finalSpread = false;
					break;
				}
			}
			if ($startcol == 0) {
				$firstSpread = true;
			} else {
				$firstSpread = false;
			}
			if ($table['borders_separate']) {
				$bw += $table['border_spacing_H'];
				if ($firstSpread) {
					$bw += $table['padding']['L'] + $table['border_details']['L']['w'];
				} else {
					$bx += ($table['padding']['L'] + $table['border_details']['L']['w']);
				}
				if ($finalSpread) {
					$bw += $table['padding']['R'] + $table['border_details']['R']['w'];
				}
			}
		} else {
			$bw = $table['w'] - ($table['max_cell_border_width']['L'] / 2) - ($table['max_cell_border_width']['R'] / 2) - $table['margin']['L'] - $table['margin']['R'];
		}

		if (!$this->ColActive) {
			if (isset($table['bgcolor'][-1])) {
				$color = $this->ConvertColor($table['bgcolor'][-1]);
				if ($color) {
					$this->tableBackgrounds[$level * 9][] = array('gradient' => false, 'x' => $bx, 'y' => $by, 'w' => $bw, 'h' => $bh, 'col' => $color);
				}
			}

			/* -- BACKGROUNDS -- */
			if (isset($table['gradient'])) {
				$g = $this->grad->parseBackgroundGradient($table['gradient']);
				if ($g) {
					$this->tableBackgrounds[$level * 9 + 1][] = array('gradient' => true, 'x' => $bx, 'y' => $by, 'w' => $bw, 'h' => $bh, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
				}
			}

			if (isset($table['background-image'])) {
				if (isset($table['background-image']['gradient']) && $table['background-image']['gradient'] && preg_match('/(-moz-)*(repeating-)*(linear|radial)-gradient/', $table['background-image']['gradient'])) {
					$g = $this->grad->parseMozGradient($table['background-image']['gradient']);
					if ($g) {
						$this->tableBackgrounds[$level * 9 + 1][] = array('gradient' => true, 'x' => $bx, 'y' => $by, 'w' => $bw, 'h' => $bh, 'gradtype' => $g['type'], 'stops' => $g['stops'], 'colorspace' => $g['colorspace'], 'coords' => $g['coords'], 'extend' => $g['extend'], 'clippath' => '');
					}
				} else {
					$image_id = $table['background-image']['image_id'];
					$orig_w = $table['background-image']['orig_w'];
					$orig_h = $table['background-image']['orig_h'];
					$x_pos = $table['background-image']['x_pos'];
					$y_pos = $table['background-image']['y_pos'];
					$x_repeat = $table['background-image']['x_repeat'];
					$y_repeat = $table['background-image']['y_repeat'];
					$resize = $table['background-image']['resize'];
					$opacity = $table['background-image']['opacity'];
					$itype = $table['background-image']['itype'];
					$this->tableBackgrounds[$level * 9 + 2][] = array('x' => $bx, 'y' => $by, 'w' => $bw, 'h' => $bh, 'image_id' => $image_id, 'orig_w' => $orig_w, 'orig_h' => $orig_h, 'x_pos' => $x_pos, 'y_pos' => $y_pos, 'x_repeat' => $x_repeat, 'y_repeat' => $y_repeat, 'clippath' => '', 'resize' => $resize, 'opacity' => $opacity, 'itype' => $itype);
				}
			}
			/* -- END BACKGROUNDS -- */
		}

		if ($this->tableBackgrounds && $level == 1) {
			$s = $this->PrintTableBackgrounds();
			if ($this->table_rotate && !$this->processingHeader && !$this->processingFooter) {
				$this->tablebuffer = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', '\\1' . "\n" . $s . "\n", $this->tablebuffer);
				if ($level == 1) {
					$this->tablebuffer = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', " ", $this->tablebuffer);
				}
			} elseif ($this->bufferoutput) {
				$this->headerbuffer = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', '\\1' . "\n" . $s . "\n", $this->headerbuffer);
				if ($level == 1) {
					$this->headerbuffer = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', " ", $this->headerbuffer);
				}
			} else {
				$this->pages[$this->page] = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', '\\1' . "\n" . $s . "\n", $this->pages[$this->page]);
				if ($level == 1) {
					$this->pages[$this->page] = preg_replace('/(___TABLE___BACKGROUNDS' . $this->uniqstr . ')/', " ", $this->pages[$this->page]);
				}
			}
			$this->tableBackgrounds = array();
		}


		// TABLE BOTTOM MARGIN
		if ($table['margin']['B']) {
			if (!$this->table_rotate && $level == 1) {
				$this->DivLn($table['margin']['B'], $this->blklvl, true);  // collapsible
			} else {
				$this->y += ($table['margin']['B']);
			}
		}

		if ($this->ColActive && $level == 1) {
			$this->breakpoints[$this->CurrCol][] = $this->y;
		} // *COLUMNS*

		if ($split) {
			// Are there more columns to print on a next page?
			if ($lastCol < $numcols - 1) {
				$splitpg++;
				$startcol = $lastCol + 1;
				return array(false, $startrow, $startcol, $splitpg, $returny, $y0);
			} else {
				return array(true, 0, 0, 0, false, false);
			}
		}
	}

	//END OF FUNCTION _tableWrite()
	/////////////////////////END OF TABLE CODE//////////////////////////////////
	/* -- END TABLES -- */

	function _putextgstates()
	{
		for ($i = 1; $i <= count($this->extgstates); $i++) {
			$this->_newobj();
			$this->extgstates[$i]['n'] = $this->n;
			$this->_out('<</Type /ExtGState');
			foreach ($this->extgstates[$i]['parms'] as $k => $v)
				$this->_out('/' . $k . ' ' . $v);
			$this->_out('>>');
			$this->_out('endobj');
		}
	}

	function _putocg()
	{
		if ($this->hasOC) {
			$this->_newobj();
			$this->n_ocg_print = $this->n;
			$this->_out('<</Type /OCG /Name ' . $this->_textstring('Print only'));
			$this->_out('/Usage <</Print <</PrintState /ON>> /View <</ViewState /OFF>>>>>>');
			$this->_out('endobj');
			$this->_newobj();
			$this->n_ocg_view = $this->n;
			$this->_out('<</Type /OCG /Name ' . $this->_textstring('Screen only'));
			$this->_out('/Usage <</Print <</PrintState /OFF>> /View <</ViewState /ON>>>>>>');
			$this->_out('endobj');
			$this->_newobj();
			$this->n_ocg_hidden = $this->n;
			$this->_out('<</Type /OCG /Name ' . $this->_textstring('Hidden'));
			$this->_out('/Usage <</Print <</PrintState /OFF>> /View <</ViewState /OFF>>>>>>');
			$this->_out('endobj');
		}
		if (count($this->layers)) {
			ksort($this->layers);
			foreach ($this->layers as $id => $layer) {
				$this->_newobj();
				$this->layers[$id]['n'] = $this->n;
				if (isset($this->layerDetails[$id]['name']) && $this->layerDetails[$id]['name']) {
					$name = $this->layerDetails[$id]['name'];
				} else {
					$name = $layer['name'];
				}
				$this->_out('<</Type /OCG /Name ' . $this->_UTF16BEtextstring($name) . '>>');
				$this->_out('endobj');
			}
		}
	}

	/* -- IMPORTS -- */

	// from mPDFI
	function _putimportedobjects()
	{
		if (is_array($this->parsers) && count($this->parsers) > 0) {
			foreach ($this->parsers AS $filename => $p) {
				$this->current_parser = $this->parsers[$filename];
				if (is_array($this->_obj_stack[$filename])) {
					while ($n = key($this->_obj_stack[$filename])) {
						$nObj = $this->current_parser->resolveObject($this->_obj_stack[$filename][$n][1]);
						$this->_newobj($this->_obj_stack[$filename][$n][0]);
						if ($nObj[0] == pdf_parser::TYPE_STREAM) {
							$this->pdf_write_value($nObj);
						} else {
							$this->pdf_write_value($nObj[1]);
						}
						$this->_out('endobj');
						$this->_obj_stack[$filename][$n] = null; // free memory
						unset($this->_obj_stack[$filename][$n]);
						reset($this->_obj_stack[$filename]);
					}
				}
			}
		}
	}

	function _putformxobjects()
	{
		$filter = ($this->compress) ? '/Filter /FlateDecode ' : '';
		reset($this->tpls);
		foreach ($this->tpls AS $tplidx => $tpl) {
			$p = ($this->compress) ? gzcompress($tpl['buffer']) : $tpl['buffer'];
			$this->_newobj();
			$this->tpls[$tplidx]['n'] = $this->n;
			$this->_out('<<' . $filter . '/Type /XObject');
			$this->_out('/Subtype /Form');
			$this->_out('/FormType 1');
			// Left/Bottom/Right/Top
			$this->_out(sprintf('/BBox [%.2F %.2F %.2F %.2F]', $tpl['box']['x'] * _MPDFK, $tpl['box']['y'] * _MPDFK, ($tpl['box']['x'] + $tpl['box']['w']) * _MPDFK, ($tpl['box']['y'] + $tpl['box']['h']) * _MPDFK)
			);


			if (isset($tpl['box']))
				$this->_out(sprintf('/Matrix [1 0 0 1 %.5F %.5F]', -$tpl['box']['x'] * _MPDFK, -$tpl['box']['y'] * _MPDFK));
			$this->_out('/Resources ');

			if (isset($tpl['resources'])) {
				$this->current_parser = $tpl['parser'];
				$this->pdf_write_value($tpl['resources']);
			} else {
				$this->_out('<</ProcSet [/PDF /Text /ImageB /ImageC /ImageI]');
				if (isset($this->_res['tpl'][$tplidx]['fonts']) && count($this->_res['tpl'][$tplidx]['fonts'])) {
					$this->_out('/Font <<');
					foreach ($this->_res['tpl'][$tplidx]['fonts'] as $font)
						$this->_out('/F' . $font['i'] . ' ' . $font['n'] . ' 0 R');
					$this->_out('>>');
				}
				if (isset($this->_res['tpl'][$tplidx]['images']) && count($this->_res['tpl'][$tplidx]['images']) ||
					isset($this->_res['tpl'][$tplidx]['tpls']) && count($this->_res['tpl'][$tplidx]['tpls'])) {
					$this->_out('/XObject <<');
					if (isset($this->_res['tpl'][$tplidx]['images']) && count($this->_res['tpl'][$tplidx]['images'])) {
						foreach ($this->_res['tpl'][$tplidx]['images'] as $image)
							$this->_out('/I' . $image['i'] . ' ' . $image['n'] . ' 0 R');
					}
					if (isset($this->_res['tpl'][$tplidx]['tpls']) && count($this->_res['tpl'][$tplidx]['tpls'])) {
						foreach ($this->_res['tpl'][$tplidx]['tpls'] as $i => $itpl)
							$this->_out($this->tplprefix . $i . ' ' . $itpl['n'] . ' 0 R');
					}
					$this->_out('>>');
				}
				$this->_out('>>');
			}

			$this->_out('/Length ' . strlen($p) . ' >>');
			$this->_putstream($p);
			$this->_out('endobj');
		}
	}

	/* -- END IMPORTS -- */

	function _putpatterns()
	{
		for ($i = 1; $i <= count($this->patterns); $i++) {
			$x = $this->patterns[$i]['x'];
			$y = $this->patterns[$i]['y'];
			$w = $this->patterns[$i]['w'];
			$h = $this->patterns[$i]['h'];
			$pgh = $this->patterns[$i]['pgh'];
			$orig_w = $this->patterns[$i]['orig_w'];
			$orig_h = $this->patterns[$i]['orig_h'];
			$image_id = $this->patterns[$i]['image_id'];
			$itype = $this->patterns[$i]['itype'];
			if (isset($this->patterns[$i]['bpa'])) {
				$bpa = $this->patterns[$i]['bpa'];
			} // background positioning area
			else {
				$bpa = array();
			}

			if ($this->patterns[$i]['x_repeat']) {
				$x_repeat = true;
			} else {
				$x_repeat = false;
			}
			if ($this->patterns[$i]['y_repeat']) {
				$y_repeat = true;
			} else {
				$y_repeat = false;
			}
			$x_pos = $this->patterns[$i]['x_pos'];
			if (stristr($x_pos, '%')) {
				$x_pos += 0;
				$x_pos /= 100;
				if (isset($bpa['w']) && $bpa['w'])
					$x_pos = ($bpa['w'] * $x_pos) - ($orig_w / _MPDFK * $x_pos);
				else
					$x_pos = ($w * $x_pos) - ($orig_w / _MPDFK * $x_pos);
			}
			$y_pos = $this->patterns[$i]['y_pos'];
			if (stristr($y_pos, '%')) {
				$y_pos += 0;
				$y_pos /= 100;
				if (isset($bpa['h']) && $bpa['h'])
					$y_pos = ($bpa['h'] * $y_pos) - ($orig_h / _MPDFK * $y_pos);
				else
					$y_pos = ($h * $y_pos) - ($orig_h / _MPDFK * $y_pos);
			}
			if (isset($bpa['x']) && $bpa['x'])
				$adj_x = ($x_pos + $bpa['x']) * _MPDFK;
			else
				$adj_x = ($x_pos + $x) * _MPDFK;
			if (isset($bpa['y']) && $bpa['y'])
				$adj_y = (($pgh - $y_pos - $bpa['y']) * _MPDFK) - $orig_h;
			else
				$adj_y = (($pgh - $y_pos - $y) * _MPDFK) - $orig_h;
			$img_obj = false;
			if ($itype == 'svg' || $itype == 'wmf') {
				foreach ($this->formobjects AS $fo) {
					if ($fo['i'] == $image_id) {
						$img_obj = $fo['n'];
						$fo_w = $fo['w'];
						$fo_h = -$fo['h'];
						$wmf_x = $fo['x'];
						$wmf_y = $fo['y'];
						break;
					}
				}
			} else {
				foreach ($this->images AS $img) {
					if ($img['i'] == $image_id) {
						$img_obj = $img['n'];
						break;
					}
				}
			}
			if (!$img_obj) {
				echo "Problem: Image object not found for background pattern " . $img['i'];
				exit;
			}

			$this->_newobj();
			$this->_out('<</ProcSet [/PDF /Text /ImageB /ImageC /ImageI]');
			if ($itype == 'svg' || $itype == 'wmf') {
				$this->_out('/XObject <</FO' . $image_id . ' ' . $img_obj . ' 0 R >>');
				// ******* ADD ANY ExtGStates, Shading AND Fonts needed for the FormObject
				// Set in classes/svg array['fo'] = true
				// Required that _putshaders comes before _putpatterns in _putresources
				// This adds any resources associated with any FormObject to every Formobject - overkill but works!
				if (count($this->extgstates)) {
					$this->_out('/ExtGState <<');
					foreach ($this->extgstates as $k => $extgstate)
						if (isset($extgstate['fo']) && $extgstate['fo']) {
							if (isset($extgstate['trans']))
								$this->_out('/' . $extgstate['trans'] . ' ' . $extgstate['n'] . ' 0 R');
							else
								$this->_out('/GS' . $k . ' ' . $extgstate['n'] . ' 0 R');
						}
					$this->_out('>>');
				}
				/* -- BACKGROUNDS -- */
				if (isset($this->gradients) AND ( count($this->gradients) > 0)) {
					$this->_out('/Shading <<');
					foreach ($this->gradients as $id => $grad) {
						if (isset($grad['fo']) && $grad['fo']) {
							$this->_out('/Sh' . $id . ' ' . $grad['id'] . ' 0 R');
						}
					}
					$this->_out('>>');
				}
				/* -- END BACKGROUNDS -- */
				$this->_out('/Font <<');
				foreach ($this->fonts as $font) {
					if (!$font['used'] && $font['type'] == 'TTF') {
						continue;
					}
					if (isset($font['fo']) && $font['fo']) {
						if ($font['type'] == 'TTF' && ($font['sip'] || $font['smp'])) {
							foreach ($font['n'] AS $k => $fid) {
								$this->_out('/F' . $font['subsetfontids'][$k] . ' ' . $font['n'][$k] . ' 0 R');
							}
						} else {
							$this->_out('/F' . $font['i'] . ' ' . $font['n'] . ' 0 R');
						}
					}
				}
				$this->_out('>>');
			} else {
				$this->_out('/XObject <</I' . $image_id . ' ' . $img_obj . ' 0 R >>');
			}
			$this->_out('>>');
			$this->_out('endobj');

			$this->_newobj();
			$this->patterns[$i]['n'] = $this->n;
			$this->_out('<< /Type /Pattern /PatternType 1 /PaintType 1 /TilingType 2');
			$this->_out('/Resources ' . ($this->n - 1) . ' 0 R');

			$this->_out(sprintf('/BBox [0 0 %.3F %.3F]', $orig_w, $orig_h));
			if ($x_repeat) {
				$this->_out(sprintf('/XStep %.3F', $orig_w));
			} else {
				$this->_out(sprintf('/XStep %d', 99999));
			}
			if ($y_repeat) {
				$this->_out(sprintf('/YStep %.3F', $orig_h));
			} else {
				$this->_out(sprintf('/YStep %d', 99999));
			}

			if ($itype == 'svg' || $itype == 'wmf') {
				$this->_out(sprintf('/Matrix [1 0 0 -1 %.3F %.3F]', $adj_x, ($adj_y + $orig_h)));
				$s = sprintf("q %.3F 0 0 %.3F %.3F %.3F cm /FO%d Do Q", ($orig_w / $fo_w), (-$orig_h / $fo_h), -($orig_w / $fo_w) * $wmf_x, ($orig_w / $fo_w) * $wmf_y, $image_id);
			} else {
				$this->_out(sprintf('/Matrix [1 0 0 1 %.3F %.3F]', $adj_x, $adj_y));
				$s = sprintf("q %.3F 0 0 %.3F 0 0 cm /I%d Do Q", $orig_w, $orig_h, $image_id);
			}

			if ($this->compress) {
				$this->_out('/Filter /FlateDecode');
				$s = gzcompress($s);
			}
			$this->_out('/Length ' . strlen($s) . '>>');
			$this->_putstream($s);
			$this->_out('endobj');
		}
	}

	/* -- BACKGROUNDS -- */

	function _putshaders()
	{
		$maxid = count($this->gradients); //index for transparency gradients
		foreach ($this->gradients as $id => $grad) {
			if (($grad['type'] == 2 || $grad['type'] == 3) && empty($grad['is_mask'])) {
				$this->_newobj();
				$this->_out('<<');
				$this->_out('/FunctionType 3');
				$this->_out('/Domain [0 1]');
				$fn = array();
				$bd = array();
				$en = array();
				for ($i = 0; $i < (count($grad['stops']) - 1); $i++) {
					$fn[] = ($this->n + 1 + $i) . ' 0 R';
					$en[] = '0 1';
					if ($i > 0) {
						$bd[] = sprintf('%.3F', $grad['stops'][$i]['offset']);
					}
				}
				$this->_out('/Functions [' . implode(' ', $fn) . ']');
				$this->_out('/Bounds [' . implode(' ', $bd) . ']');
				$this->_out('/Encode [' . implode(' ', $en) . ']');
				$this->_out('>>');
				$this->_out('endobj');
				$f1 = $this->n;
				for ($i = 0; $i < (count($grad['stops']) - 1); $i++) {
					$this->_newobj();
					$this->_out('<<');
					$this->_out('/FunctionType 2');
					$this->_out('/Domain [0 1]');
					$this->_out('/C0 [' . $grad['stops'][$i]['col'] . ']');
					$this->_out('/C1 [' . $grad['stops'][$i + 1]['col'] . ']');
					$this->_out('/N 1');
					$this->_out('>>');
					$this->_out('endobj');
				}
			}
			if ($grad['type'] == 2 || $grad['type'] == 3) {
				if (isset($grad['trans']) && $grad['trans']) {
					$this->_newobj();
					$this->_out('<<');
					$this->_out('/FunctionType 3');
					$this->_out('/Domain [0 1]');
					$fn = array();
					$bd = array();
					$en = array();
					for ($i = 0; $i < (count($grad['stops']) - 1); $i++) {
						$fn[] = ($this->n + 1 + $i) . ' 0 R';
						$en[] = '0 1';
						if ($i > 0) {
							$bd[] = sprintf('%.3F', $grad['stops'][$i]['offset']);
						}
					}
					$this->_out('/Functions [' . implode(' ', $fn) . ']');
					$this->_out('/Bounds [' . implode(' ', $bd) . ']');
					$this->_out('/Encode [' . implode(' ', $en) . ']');
					$this->_out('>>');
					$this->_out('endobj');
					$f2 = $this->n;
					for ($i = 0; $i < (count($grad['stops']) - 1); $i++) {
						$this->_newobj();
						$this->_out('<<');
						$this->_out('/FunctionType 2');
						$this->_out('/Domain [0 1]');
						$this->_out(sprintf('/C0 [%.3F]', $grad['stops'][$i]['opacity']));
						$this->_out(sprintf('/C1 [%.3F]', $grad['stops'][$i + 1]['opacity']));
						$this->_out('/N 1');
						$this->_out('>>');
						$this->_out('endobj');
					}
				}
			}

			if (empty($grad['is_mask'])) {
				$this->_newobj();
				$this->_out('<<');
				$this->_out('/ShadingType ' . $grad['type']);
				if (isset($grad['colorspace'])) {
					$this->_out('/ColorSpace /Device' . $grad['colorspace']);  // Can use CMYK if all C0 and C1 above have 4 values
				} else {
					$this->_out('/ColorSpace /DeviceRGB');
				}
				if ($grad['type'] == 2) {
					$this->_out(sprintf('/Coords [%.3F %.3F %.3F %.3F]', $grad['coords'][0], $grad['coords'][1], $grad['coords'][2], $grad['coords'][3]));
					$this->_out('/Function ' . $f1 . ' 0 R');
					$this->_out('/Extend [' . $grad['extend'][0] . ' ' . $grad['extend'][1] . '] ');
					$this->_out('>>');
				} elseif ($grad['type'] == 3) {
					//x0, y0, r0, x1, y1, r1
					//at this this time radius of inner circle is 0
					$ir = 0;
					if (isset($grad['coords'][5]) && $grad['coords'][5]) {
						$ir = $grad['coords'][5];
					}
					$this->_out(sprintf('/Coords [%.3F %.3F %.3F %.3F %.3F %.3F]', $grad['coords'][0], $grad['coords'][1], $ir, $grad['coords'][2], $grad['coords'][3], $grad['coords'][4]));
					$this->_out('/Function ' . $f1 . ' 0 R');
					$this->_out('/Extend [' . $grad['extend'][0] . ' ' . $grad['extend'][1] . '] ');
					$this->_out('>>');
				} elseif ($grad['type'] == 6) {
					$this->_out('/BitsPerCoordinate 16');
					$this->_out('/BitsPerComponent 8');
					if ($grad['colorspace'] == 'CMYK') {
						$this->_out('/Decode[0 1 0 1 0 1 0 1 0 1 0 1]');
					} elseif ($grad['colorspace'] == 'Gray') {
						$this->_out('/Decode[0 1 0 1 0 1]');
					} else {
						$this->_out('/Decode[0 1 0 1 0 1 0 1 0 1]');
					}
					$this->_out('/BitsPerFlag 8');
					$this->_out('/Length ' . strlen($grad['stream']));
					$this->_out('>>');
					$this->_putstream($grad['stream']);
				}
				$this->_out('endobj');
			}

			$this->gradients[$id]['id'] = $this->n;

			// set pattern object
			$this->_newobj();
			$out = '<< /Type /Pattern /PatternType 2';
			$out .= ' /Shading ' . $this->gradients[$id]['id'] . ' 0 R';
			$out .= ' >>';
			$out .= "\n" . 'endobj';
			$this->_out($out);


			$this->gradients[$id]['pattern'] = $this->n;

			if (isset($grad['trans']) && $grad['trans']) {
				// luminosity pattern
				$transid = $id + $maxid;
				$this->_newobj();
				$this->_out('<<');
				$this->_out('/ShadingType ' . $grad['type']);
				$this->_out('/ColorSpace /DeviceGray');
				if ($grad['type'] == 2) {
					$this->_out(sprintf('/Coords [%.3F %.3F %.3F %.3F]', $grad['coords'][0], $grad['coords'][1], $grad['coords'][2], $grad['coords'][3]));
					$this->_out('/Function ' . $f2 . ' 0 R');
					$this->_out('/Extend [' . $grad['extend'][0] . ' ' . $grad['extend'][1] . '] ');
					$this->_out('>>');
				} elseif ($grad['type'] == 3) {
					//x0, y0, r0, x1, y1, r1
					//at this this time radius of inner circle is 0
					$ir = 0;
					if (isset($grad['coords'][5]) && $grad['coords'][5]) {
						$ir = $grad['coords'][5];
					}
					$this->_out(sprintf('/Coords [%.3F %.3F %.3F %.3F %.3F %.3F]', $grad['coords'][0], $grad['coords'][1], $ir, $grad['coords'][2], $grad['coords'][3], $grad['coords'][4]));
					$this->_out('/Function ' . $f2 . ' 0 R');
					$this->_out('/Extend [' . $grad['extend'][0] . ' ' . $grad['extend'][1] . '] ');
					$this->_out('>>');
				} elseif ($grad['type'] == 6) {
					$this->_out('/BitsPerCoordinate 16');
					$this->_out('/BitsPerComponent 8');
					$this->_out('/Decode[0 1 0 1 0 1]');
					$this->_out('/BitsPerFlag 8');
					$this->_out('/Length ' . strlen($grad['stream_trans']));
					$this->_out('>>');
					$this->_putstream($grad['stream_trans']);
				}
				$this->_out('endobj');

				$this->gradients[$transid]['id'] = $this->n;
				$this->_newobj();
				$this->_out('<< /Type /Pattern /PatternType 2');
				$this->_out('/Shading ' . $this->gradients[$transid]['id'] . ' 0 R');
				$this->_out('>>');
				$this->_out('endobj');
				$this->gradients[$transid]['pattern'] = $this->n;
				$this->_newobj();
				// Need to extend size of viewing box in case of transformations
				$str = 'q /a0 gs /Pattern cs /p' . $transid . ' scn -' . ($this->wPt / 2) . ' -' . ($this->hPt / 2) . ' ' . (2 * $this->wPt) . ' ' . (2 * $this->hPt) . ' re f Q';
				$filter = ($this->compress) ? '/Filter /FlateDecode ' : '';
				$p = ($this->compress) ? gzcompress($str) : $str;
				$this->_out('<< /Type /XObject /Subtype /Form /FormType 1 ' . $filter);
				$this->_out('/Length ' . strlen($p));
				$this->_out('/BBox [-' . ($this->wPt / 2) . ' -' . ($this->hPt / 2) . ' ' . (2 * $this->wPt) . ' ' . (2 * $this->hPt) . ']');
				$this->_out('/Group << /Type /Group /S /Transparency /CS /DeviceGray >>');
				$this->_out('/Resources <<');
				$this->_out('/ExtGState << /a0 << /ca 1 /CA 1 >> >>');
				$this->_out('/Pattern << /p' . $transid . ' ' . $this->gradients[$transid]['pattern'] . ' 0 R >>');
				$this->_out('>>');
				$this->_out('>>');
				$this->_putstream($p);
				$this->_out('endobj');
				$this->_newobj();
				$this->_out('<< /Type /Mask /S /Luminosity /G ' . ($this->n - 1) . ' 0 R >>' . "\n" . 'endobj');
				$this->_newobj();
				$this->_out('<< /Type /ExtGState /SMask ' . ($this->n - 1) . ' 0 R /AIS false >>' . "\n" . 'endobj');
				if (isset($grad['fo']) && $grad['fo']) {
					$this->extgstates[] = array('n' => $this->n, 'trans' => 'TGS' . $id, 'fo' => true);
				} else {
					$this->extgstates[] = array('n' => $this->n, 'trans' => 'TGS' . $id);
				}
			}
		}
	}

	/* -- END BACKGROUNDS -- */

	function _putspotcolors()
	{
		foreach ($this->spotColors as $name => $color) {
			$this->_newobj();
			$this->_out('[/Separation /' . str_replace(' ', '#20', $name));
			$this->_out('/DeviceCMYK <<');
			$this->_out('/Range [0 1 0 1 0 1 0 1] /C0 [0 0 0 0] ');
			$this->_out(sprintf('/C1 [%.3F %.3F %.3F %.3F] ', $color['c'] / 100, $color['m'] / 100, $color['y'] / 100, $color['k'] / 100));
			$this->_out('/FunctionType 2 /Domain [0 1] /N 1>>]');
			$this->_out('endobj');
			$this->spotColors[$name]['n'] = $this->n;
		}
	}

	function _putresources()
	{
		if ($this->hasOC || count($this->layers))
			$this->_putocg();
		$this->_putextgstates();
		$this->_putspotcolors();
		if ($this->progressBar) {
			$this->UpdateProgressBar(2, '40', 'Compiling Fonts');
		} // *PROGRESS-BAR*
		$this->_putfonts();
		if ($this->progressBar) {
			$this->UpdateProgressBar(2, '50', 'Compiling Images');
		} // *PROGRESS-BAR*
		$this->_putimages();
		$this->_putformobjects(); // *IMAGES-CORE*

		/* -- IMPORTS -- */
		if ($this->enableImports) {
			$this->_putformxobjects();
			$this->_putimportedobjects();
		}
		/* -- END IMPORTS -- */

		/* -- BACKGROUNDS -- */
		$this->_putshaders();
		$this->_putpatterns();
		/* -- END BACKGROUNDS -- */


		//Resource dictionary
		$this->offsets[2] = strlen($this->buffer);
		$this->_out('2 0 obj');
		$this->_out('<</ProcSet [/PDF /Text /ImageB /ImageC /ImageI]');

		$this->_out('/Font <<');
		foreach ($this->fonts as $font) {
			if (isset($font['type']) && $font['type'] == 'TTF' && !$font['used']) {
				continue;
			}
			if (isset($font['type']) && $font['type'] == 'TTF' && ($font['sip'] || $font['smp'])) {
				foreach ($font['n'] AS $k => $fid) {
					$this->_out('/F' . $font['subsetfontids'][$k] . ' ' . $font['n'][$k] . ' 0 R');
				}
			} else {
				$this->_out('/F' . $font['i'] . ' ' . $font['n'] . ' 0 R');
			}
		}
		$this->_out('>>');

		if (count($this->spotColors)) {
			$this->_out('/ColorSpace <<');
			foreach ($this->spotColors as $color)
				$this->_out('/CS' . $color['i'] . ' ' . $color['n'] . ' 0 R');
			$this->_out('>>');
		}

		if (count($this->extgstates)) {
			$this->_out('/ExtGState <<');
			foreach ($this->extgstates as $k => $extgstate)
				if (isset($extgstate['trans']))
					$this->_out('/' . $extgstate['trans'] . ' ' . $extgstate['n'] . ' 0 R');
				else
					$this->_out('/GS' . $k . ' ' . $extgstate['n'] . ' 0 R');
			$this->_out('>>');
		}

		/* -- BACKGROUNDS -- */
		if ((isset($this->gradients) AND ( count($this->gradients) > 0)) || ($this->enableImports && count($this->tpls))) { // mPDF 5.7.3
			$this->_out('/Shading <<');
			foreach ($this->gradients as $id => $grad) {
				$this->_out('/Sh' . $id . ' ' . $grad['id'] . ' 0 R');
			}
			// mPDF 5.7.3
			// If a shading dictionary is in an object (tpl) imported from another PDF, it needs to be included
			// in the document resources, as well as the object resources
			// Otherwise get an error in some PDF viewers
			if ($this->enableImports && count($this->tpls)) {
				foreach ($this->tpls as $tplidx => $tpl) {
					if (isset($tpl['resources'])) {
						$this->current_parser = $tpl['parser'];
						reset($tpl['resources'][1]);
						while (list($k, $v) = each($tpl['resources'][1])) {
							if ($k == '/Shading') {
								while (list($k2, $v2) = each($v[1])) {
									$this->_out($k2 . " ", false);
									$this->pdf_write_value($v2);
								}
							}
						}
					}
				}
			}

			$this->_out('>>');
			/*
			  // ??? Not needed !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			  $this->_out('/Pattern <<');
			  foreach ($this->gradients as $id => $grad) {
			  $this->_out('/P'.$id.' '.$grad['pattern'].' 0 R');
			  }
			  $this->_out('>>');
			 */
		}
		/* -- END BACKGROUNDS -- */


		if (count($this->images) || count($this->formobjects) || ($this->enableImports && count($this->tpls))) {
			$this->_out('/XObject <<');
			foreach ($this->images as $image)
				$this->_out('/I' . $image['i'] . ' ' . $image['n'] . ' 0 R');
			foreach ($this->formobjects as $formobject)
				$this->_out('/FO' . $formobject['i'] . ' ' . $formobject['n'] . ' 0 R');
			/* -- IMPORTS -- */
			if ($this->enableImports && count($this->tpls)) {
				foreach ($this->tpls as $tplidx => $tpl) {
					$this->_out($this->tplprefix . $tplidx . ' ' . $tpl['n'] . ' 0 R');
				}
			}
			/* -- END IMPORTS -- */
			$this->_out('>>');
		}

		/* -- BACKGROUNDS -- */

		if (count($this->patterns)) {
			$this->_out('/Pattern <<');
			foreach ($this->patterns as $k => $patterns)
				$this->_out('/P' . $k . ' ' . $patterns['n'] . ' 0 R');
			$this->_out('>>');
		}
		/* -- END BACKGROUNDS -- */

		if ($this->hasOC || count($this->layers)) {
			$this->_out('/Properties <<');
			if ($this->hasOC) {
				$this->_out('/OC1 ' . $this->n_ocg_print . ' 0 R /OC2 ' . $this->n_ocg_view . ' 0 R /OC3 ' . $this->n_ocg_hidden . ' 0 R ');
			}
			if (count($this->layers)) {
				foreach ($this->layers as $id => $layer)
					$this->_out('/ZI' . $id . ' ' . $layer['n'] . ' 0 R');
			}
			$this->_out('>>');
		}

		$this->_out('>>');
		$this->_out('endobj'); // end resource dictionary

		$this->_putbookmarks();  // *BOOKMARKS*

		if (isset($this->js) && $this->js) {
			$this->_putjavascript();
		}

		/* -- ENCRYPTION -- */
		if ($this->encrypted) {
			$this->_newobj();
			$this->enc_obj_id = $this->n;
			$this->_out('<<');
			$this->_putencryption();
			$this->_out('>>');
			$this->_out('endobj');
		}
		/* -- END ENCRYPTION -- */
	}

	function _putjavascript()
	{
		$this->_newobj();
		$this->n_js = $this->n;
		$this->_out('<<');
		$this->_out('/Names [(EmbeddedJS) ' . (1 + $this->n) . ' 0 R ]');
		$this->_out('>>');
		$this->_out('endobj');

		$this->_newobj();
		$this->_out('<<');
		$this->_out('/S /JavaScript');
		$this->_out('/JS ' . $this->_textstring($this->js));
		$this->_out('>>');
		$this->_out('endobj');
	}

	/* -- ENCRYPTION -- */

	function _putencryption()
	{
		$this->_out('/Filter /Standard');
		if ($this->useRC128encryption) {
			$this->_out('/V 2');
			$this->_out('/R 3');
			$this->_out('/Length 128');
		} else {
			$this->_out('/V 1');
			$this->_out('/R 2');
		}
		$this->_out('/O (' . $this->_escape($this->Ovalue) . ')');
		$this->_out('/U (' . $this->_escape($this->Uvalue) . ')');
		$this->_out('/P ' . $this->Pvalue);
	}

	/* -- END ENCRYPTION -- */

	function _puttrailer()
	{
		$this->_out('/Size ' . ($this->n + 1));
		$this->_out('/Root ' . $this->n . ' 0 R');
		$this->_out('/Info ' . $this->InfoRoot . ' 0 R');
		/* -- ENCRYPTION -- */
		if ($this->encrypted) {
			$this->_out('/Encrypt ' . $this->enc_obj_id . ' 0 R');
			$this->_out('/ID [<' . $this->uniqid . '> <' . $this->uniqid . '>]');
		} else {
			/* -- END ENCRYPTION -- */
			$uniqid = md5(time() . $this->buffer);
			$this->_out('/ID [<' . $uniqid . '> <' . $uniqid . '>]');
			/* -- ENCRYPTION -- */
		}
		/* -- END ENCRYPTION -- */
	}

	/* -- ENCRYPTION -- */

	function SetProtection($permissions = array(), $user_pass = '', $owner_pass = null, $length = 40)
	{
		$this->encrypted = false;
		if (is_string($permissions) && strlen($permissions) > 0) {
			$permissions = array($permissions);
		} elseif (!is_array($permissions)) {
			return 0;
		}
		$this->last_rc4_key = '';
		$this->padding = "\x28\xBF\x4E\x5E\x4E\x75\x8A\x41\x64\x00\x4E\x56\xFF\xFA\x01\x08" .
			"\x2E\x2E\x00\xB6\xD0\x68\x3E\x80\x2F\x0C\xA9\xFE\x64\x53\x69\x7A";

		$options = array(
			'print' => 4, // bit 3
			'modify' => 8, // bit 4
			'copy' => 16, // bit 5
			'annot-forms' => 32, // bit 6
			'fill-forms' => 256, // bit 9
			'extract' => 512, // bit 10
			'assemble' => 1024, // bit 11
			'print-highres' => 2048 // bit 12
		);
		// bit 31 = 1073741824
		// bit 32 = 2147483648
		// bits 13-31 = 2147479552
		// bits 13-32 = 4294963200 + 192 = 4294963392
		$protection = 4294963392; // bits 7,8,13-32
		foreach ($permissions as $permission) {
			if (!isset($options[$permission]))
				throw new MpdfException('Incorrect permission: ' . $permission);
			if ($options[$permission] > 32) {
				$this->useRC128encryption = true;
			}
			if (isset($options[$permission]))
				$protection += $options[$permission];
		}
		if ($length == 128) {
			$this->useRC128encryption = true;
		}
		if ($owner_pass === null)
			$owner_pass = uniqid(rand());
		$this->encrypted = true;
		$this->_generateencryptionkey($user_pass, $owner_pass, $protection);
	}

	// Compute key depending on object number where the encrypted data is stored
	function _objectkey($n)
	{
		if ($this->useRC128encryption)
			$len = 16;
		else
			$len = 10;
		return substr($this->_md5_16($this->encryption_key . pack('VXxx', $n)), 0, $len);
	}

	// RC4 is the standard encryption algorithm used in PDF format
	function _RC4($key, $text)
	{
		if ($this->last_rc4_key != $key) {
			$k = str_repeat($key, 256 / strlen($key) + 1);
			$rc4 = range(0, 255);
			$j = 0;
			for ($i = 0; $i < 256; $i++) {
				$t = $rc4[$i];
				$j = ($j + $t + ord($k[$i])) % 256;
				$rc4[$i] = $rc4[$j];
				$rc4[$j] = $t;
			}
			$this->last_rc4_key = $key;
			$this->last_rc4_key_c = $rc4;
		} else {
			$rc4 = $this->last_rc4_key_c;
		}

		$len = strlen($text);
		$a = 0;
		$b = 0;
		$out = '';
		for ($i = 0; $i < $len; $i++) {
			$a = ($a + 1) % 256;
			$t = $rc4[$a];
			$b = ($b + $t) % 256;
			$rc4[$a] = $rc4[$b];
			$rc4[$b] = $t;
			$k = $rc4[($rc4[$a] + $rc4[$b]) % 256];
			$out.= chr(ord($text[$i]) ^ $k);
		}
		return $out;
	}

	// Get MD5 as binary string
	function _md5_16($string)
	{
		return pack('H*', md5($string));
	}

	// Compute O value
	function _Ovalue($user_pass, $owner_pass)
	{
		$tmp = $this->_md5_16($owner_pass);
		if ($this->useRC128encryption) {
			for ($i = 0; $i < 50; ++$i) {
				$tmp = $this->_md5_16($tmp);
			}
		}
		if ($this->useRC128encryption)
			$keybytelen = (128 / 8);
		else
			$keybytelen = (40 / 8);
		$owner_RC4_key = substr($tmp, 0, $keybytelen);
		$enc = $this->_RC4($owner_RC4_key, $user_pass);
		if ($this->useRC128encryption) {
			$len = strlen($owner_RC4_key);
			for ($i = 1; $i <= 19; ++$i) {
				$key = '';
				for ($j = 0; $j < $len; ++$j) {
					$key .= chr(ord($owner_RC4_key{$j}) ^ $i);
				}
				$enc = $this->_RC4($key, $enc);
			}
		}
		return $enc;
	}

	// Compute U value
	function _Uvalue()
	{
		if ($this->useRC128encryption) {
			$tmp = $this->_md5_16($this->padding . $this->_hexToString($this->uniqid));
			$enc = $this->_RC4($this->encryption_key, $tmp);
			$len = strlen($tmp);
			for ($i = 1; $i <= 19; ++$i) {
				$key = '';
				for ($j = 0; $j < $len; ++$j) {
					$key .= chr(ord($this->encryption_key{$j}) ^ $i);
				}
				$enc = $this->_RC4($key, $enc);
			}
			$enc .= str_repeat("\x00", 16);
			return substr($enc, 0, 32);
		} else {
			return $this->_RC4($this->encryption_key, $this->padding);
		}
	}

	// Compute encryption key
	function _generateencryptionkey($user_pass, $owner_pass, $protection)
	{
		// Pad passwords
		$user_pass = substr($user_pass . $this->padding, 0, 32);
		$owner_pass = substr($owner_pass . $this->padding, 0, 32);
		$chars = 'ABCDEF1234567890';
		$id = '';
		for ($i = 0; $i < 32; $i++) {
			$id .= $chars{rand(0, 15)};
		}
		$this->uniqid = md5($id);
		// Compute O value
		$this->Ovalue = $this->_Ovalue($user_pass, $owner_pass);
		// Compute encyption key
		if ($this->useRC128encryption)
			$keybytelen = (128 / 8);
		else
			$keybytelen = (40 / 8);
		$prot = sprintf('%032b', $protection);
		$perms = chr(bindec(substr($prot, 24, 8)));
		$perms .= chr(bindec(substr($prot, 16, 8)));
		$perms .= chr(bindec(substr($prot, 8, 8)));
		$perms .= chr(bindec(substr($prot, 0, 8)));
		$tmp = $this->_md5_16($user_pass . $this->Ovalue . $perms . $this->_hexToString($this->uniqid));
		if ($this->useRC128encryption) {
			for ($i = 0; $i < 50; ++$i) {
				$tmp = $this->_md5_16(substr($tmp, 0, $keybytelen));
			}
		}
		$this->encryption_key = substr($tmp, 0, $keybytelen);
		// Compute U value
		$this->Uvalue = $this->_Uvalue();
		// Compute P value
		$this->Pvalue = $protection;
	}

	function _hexToString($hs)
	{
		$s = '';
		$len = strlen($hs);
		if (($len % 2) != 0) {
			$hs .= '0';
			++$len;
		}
		for ($i = 0; $i < $len; $i += 2) {
			$s .= chr(hexdec($hs{$i} . $hs{($i + 1)}));
		}
		return $s;
	}

	/* -- END ENCRYPTION -- */

	//=========================================
	/* -- BOOKMARKS -- */
	// FROM class PDF_Bookmark

	function Bookmark($txt, $level = 0, $y = 0)
	{
		$txt = $this->purify_utf8_text($txt);
		if ($this->text_input_as_HTML) {
			$txt = $this->all_entities_to_utf8($txt);
		}
		if ($y == -1) {
			if (!$this->ColActive) {
				$y = $this->y;
			} else {
				$y = $this->y0;
			} // If columns are on - mark top of columns
		}
		// else y is used as set, or =0 i.e. top of page
		// DIRECTIONALITY RTL
		$bmo = array('t' => $txt, 'l' => $level, 'y' => $y, 'p' => $this->page);
		if ($this->keep_block_together) {
			// do nothing
		}
		/* -- TABLES -- */ elseif ($this->table_rotate) {
			$this->tbrot_BMoutlines[] = $bmo;
		} elseif ($this->kwt) {
			$this->kwt_BMoutlines[] = $bmo;
		}
		/* -- END TABLES -- */ elseif ($this->ColActive) { // *COLUMNS*
			$this->col_BMoutlines[] = $bmo; // *COLUMNS*
		} // *COLUMNS*
		else {
			$this->BMoutlines[] = $bmo;
		}
	}

	function _putbookmarks()
	{
		$nb = count($this->BMoutlines);
		if ($nb == 0)
			return;

		$bmo = $this->BMoutlines;
		$this->BMoutlines = array();
		$lastlevel = -1;
		for ($i = 0; $i < count($bmo); $i++) {
			if ($bmo[$i]['l'] > 0) {
				while ($bmo[$i]['l'] - $lastlevel > 1) { // If jump down more than one level, insert a new entry
					$new = $bmo[$i];
					$new['t'] = "[" . $new['t'] . "]"; // Put [] around text/title to highlight
					$new['l'] = $lastlevel + 1;
					$lastlevel++;
					$this->BMoutlines[] = $new;
				}
			}
			$this->BMoutlines[] = $bmo[$i];
			$lastlevel = $bmo[$i]['l'];
		}
		$nb = count($this->BMoutlines);

		$lru = array();
		$level = 0;
		foreach ($this->BMoutlines as $i => $o) {
			if ($o['l'] > 0) {
				$parent = $lru[$o['l'] - 1];
				//Set parent and last pointers
				$this->BMoutlines[$i]['parent'] = $parent;
				$this->BMoutlines[$parent]['last'] = $i;
				if ($o['l'] > $level) {
					//Level increasing: set first pointer
					$this->BMoutlines[$parent]['first'] = $i;
				}
			} else {
				$this->BMoutlines[$i]['parent'] = $nb;
			}
			if ($o['l'] <= $level and $i > 0) {
				//Set prev and next pointers
				$prev = $lru[$o['l']];
				$this->BMoutlines[$prev]['next'] = $i;
				$this->BMoutlines[$i]['prev'] = $prev;
			}
			$lru[$o['l']] = $i;
			$level = $o['l'];
		}


		//Outline items
		$n = $this->n + 1;
		foreach ($this->BMoutlines as $i => $o) {
			$this->_newobj();
			$this->_out('<</Title ' . $this->_UTF16BEtextstring($o['t']));
			$this->_out('/Parent ' . ($n + $o['parent']) . ' 0 R');
			if (isset($o['prev']))
				$this->_out('/Prev ' . ($n + $o['prev']) . ' 0 R');
			if (isset($o['next']))
				$this->_out('/Next ' . ($n + $o['next']) . ' 0 R');
			if (isset($o['first']))
				$this->_out('/First ' . ($n + $o['first']) . ' 0 R');
			if (isset($o['last']))
				$this->_out('/Last ' . ($n + $o['last']) . ' 0 R');


			if (isset($this->pageDim[$o['p']]['h'])) {
				$h = $this->pageDim[$o['p']]['h'];
			} else {
				$h = 0;
			}

			$this->_out(sprintf('/Dest [%d 0 R /XYZ 0 %.3F null]', 1 + 2 * ($o['p']), ($h - $o['y']) * _MPDFK));
			if (isset($this->bookmarkStyles) && isset($this->bookmarkStyles[$o['l']])) {
				// font style
				$bms = $this->bookmarkStyles[$o['l']]['style'];
				$style = 0;
				if (strpos($bms, 'B') !== false) {
					$style += 2;
				}
				if (strpos($bms, 'I') !== false) {
					$style += 1;
				}
				$this->_out(sprintf('/F %d', $style));
				// Colour
				$col = $this->bookmarkStyles[$o['l']]['color'];
				if (isset($col) && is_array($col) && count($col) == 3) {
					$this->_out(sprintf('/C [%.3F %.3F %.3F]', ($col[0] / 255), ($col[1] / 255), ($col[2] / 255)));
				}
			}

			$this->_out('/Count 0>>');
			$this->_out('endobj');
		}
		//Outline root
		$this->_newobj();
		$this->OutlineRoot = $this->n;
		$this->_out('<</Type /BMoutlines /First ' . $n . ' 0 R');
		$this->_out('/Last ' . ($n + $lru[0]) . ' 0 R>>');
		$this->_out('endobj');
	}

	/* -- END BOOKMARKS -- */

	//======================================================
		/* -- TOC -- */
	// ToC TABLE OF CONTENTS
	// Initiate, and Mark a place for the Table of Contents to be inserted
	function TOC($tocfont = '', $tocfontsize = 0, $tocindent = 0, $resetpagenum = '', $pagenumstyle = '', $suppress = '', $toc_orientation = '', $TOCusePaging = true, $TOCuseLinking = false, $toc_id = 0, $tocoutdent = '')
	{
		if (!class_exists('tocontents', false)) {
			include(_MPDF_PATH . 'classes/tocontents.php');
		}
		if (empty($this->tocontents)) {
			$this->tocontents = new tocontents($this);
		}
		$this->tocontents->TOC($tocfont, $tocfontsize, $tocindent, $resetpagenum, $pagenumstyle, $suppress, $toc_orientation, $TOCusePaging, $TOCuseLinking, $toc_id, $tocoutdent);
	}

	function TOCpagebreakByArray($a)
	{
		if (!is_array($a)) {
			$a = array();
		}
		if (!class_exists('tocontents', false)) {
			include(_MPDF_PATH . 'classes/tocontents.php');
		}
		if (empty($this->tocontents)) {
			$this->tocontents = new tocontents($this);
		}
		$tocoutdent = (isset($a['tocoutdent']) ? $a['tocoutdent'] : (isset($a['outdent']) ? $a['outdent'] : ''));
		$TOCusePaging = (isset($a['TOCusePaging']) ? $a['TOCusePaging'] : (isset($a['paging']) ? $a['paging'] : true));
		$TOCuseLinking = (isset($a['TOCuseLinking']) ? $a['TOCuseLinking'] : (isset($a['links']) ? $a['links'] : ''));
		$toc_orientation = (isset($a['toc_orientation']) ? $a['toc_orientation'] : (isset($a['toc-orientation']) ? $a['toc-orientation'] : ''));
		$toc_mgl = (isset($a['toc_mgl']) ? $a['toc_mgl'] : (isset($a['toc-margin-left']) ? $a['toc-margin-left'] : ''));
		$toc_mgr = (isset($a['toc_mgr']) ? $a['toc_mgr'] : (isset($a['toc-margin-right']) ? $a['toc-margin-right'] : ''));
		$toc_mgt = (isset($a['toc_mgt']) ? $a['toc_mgt'] : (isset($a['toc-margin-top']) ? $a['toc-margin-top'] : ''));
		$toc_mgb = (isset($a['toc_mgb']) ? $a['toc_mgb'] : (isset($a['toc-margin-bottom']) ? $a['toc-margin-bottom'] : ''));
		$toc_mgh = (isset($a['toc_mgh']) ? $a['toc_mgh'] : (isset($a['toc-margin-header']) ? $a['toc-margin-header'] : ''));
		$toc_mgf = (isset($a['toc_mgf']) ? $a['toc_mgf'] : (isset($a['toc-margin-footer']) ? $a['toc-margin-footer'] : ''));
		$toc_ohname = (isset($a['toc_ohname']) ? $a['toc_ohname'] : (isset($a['toc-odd-header-name']) ? $a['toc-odd-header-name'] : ''));
		$toc_ehname = (isset($a['toc_ehname']) ? $a['toc_ehname'] : (isset($a['toc-even-header-name']) ? $a['toc-even-header-name'] : ''));
		$toc_ofname = (isset($a['toc_ofname']) ? $a['toc_ofname'] : (isset($a['toc-odd-footer-name']) ? $a['toc-odd-footer-name'] : ''));
		$toc_efname = (isset($a['toc_efname']) ? $a['toc_efname'] : (isset($a['toc-even-footer-name']) ? $a['toc-even-footer-name'] : ''));
		$toc_ohvalue = (isset($a['toc_ohvalue']) ? $a['toc_ohvalue'] : (isset($a['toc-odd-header-value']) ? $a['toc-odd-header-value'] : 0));
		$toc_ehvalue = (isset($a['toc_ehvalue']) ? $a['toc_ehvalue'] : (isset($a['toc-even-header-value']) ? $a['toc-even-header-value'] : 0));
		$toc_ofvalue = (isset($a['toc_ofvalue']) ? $a['toc_ofvalue'] : (isset($a['toc-odd-footer-value']) ? $a['toc-odd-footer-value'] : 0));
		$toc_efvalue = (isset($a['toc_efvalue']) ? $a['toc_efvalue'] : (isset($a['toc-even-footer-value']) ? $a['toc-even-footer-value'] : 0));
		$toc_preHTML = (isset($a['toc_preHTML']) ? $a['toc_preHTML'] : (isset($a['toc-preHTML']) ? $a['toc-preHTML'] : ''));
		$toc_postHTML = (isset($a['toc_postHTML']) ? $a['toc_postHTML'] : (isset($a['toc-postHTML']) ? $a['toc-postHTML'] : ''));
		$toc_bookmarkText = (isset($a['toc_bookmarkText']) ? $a['toc_bookmarkText'] : (isset($a['toc-bookmarkText']) ? $a['toc-bookmarkText'] : ''));
		$resetpagenum = (isset($a['resetpagenum']) ? $a['resetpagenum'] : '');
		$pagenumstyle = (isset($a['pagenumstyle']) ? $a['pagenumstyle'] : '');
		$suppress = (isset($a['suppress']) ? $a['suppress'] : '');
		$orientation = (isset($a['orientation']) ? $a['orientation'] : '');
		$mgl = (isset($a['mgl']) ? $a['mgl'] : (isset($a['margin-left']) ? $a['margin-left'] : ''));
		$mgr = (isset($a['mgr']) ? $a['mgr'] : (isset($a['margin-right']) ? $a['margin-right'] : ''));
		$mgt = (isset($a['mgt']) ? $a['mgt'] : (isset($a['margin-top']) ? $a['margin-top'] : ''));
		$mgb = (isset($a['mgb']) ? $a['mgb'] : (isset($a['margin-bottom']) ? $a['margin-bottom'] : ''));
		$mgh = (isset($a['mgh']) ? $a['mgh'] : (isset($a['margin-header']) ? $a['margin-header'] : ''));
		$mgf = (isset($a['mgf']) ? $a['mgf'] : (isset($a['margin-footer']) ? $a['margin-footer'] : ''));
		$ohname = (isset($a['ohname']) ? $a['ohname'] : (isset($a['odd-header-name']) ? $a['odd-header-name'] : ''));
		$ehname = (isset($a['ehname']) ? $a['ehname'] : (isset($a['even-header-name']) ? $a['even-header-name'] : ''));
		$ofname = (isset($a['ofname']) ? $a['ofname'] : (isset($a['odd-footer-name']) ? $a['odd-footer-name'] : ''));
		$efname = (isset($a['efname']) ? $a['efname'] : (isset($a['even-footer-name']) ? $a['even-footer-name'] : ''));
		$ohvalue = (isset($a['ohvalue']) ? $a['ohvalue'] : (isset($a['odd-header-value']) ? $a['odd-header-value'] : 0));
		$ehvalue = (isset($a['ehvalue']) ? $a['ehvalue'] : (isset($a['even-header-value']) ? $a['even-header-value'] : 0));
		$ofvalue = (isset($a['ofvalue']) ? $a['ofvalue'] : (isset($a['odd-footer-value']) ? $a['odd-footer-value'] : 0));
		$efvalue = (isset($a['efvalue']) ? $a['efvalue'] : (isset($a['even-footer-value']) ? $a['even-footer-value'] : 0));
		$toc_id = (isset($a['toc_id']) ? $a['toc_id'] : (isset($a['name']) ? $a['name'] : 0));
		$pagesel = (isset($a['pagesel']) ? $a['pagesel'] : (isset($a['pageselector']) ? $a['pageselector'] : ''));
		$toc_pagesel = (isset($a['toc_pagesel']) ? $a['toc_pagesel'] : (isset($a['toc-pageselector']) ? $a['toc-pageselector'] : ''));
		$sheetsize = (isset($a['sheetsize']) ? $a['sheetsize'] : (isset($a['sheet-size']) ? $a['sheet-size'] : ''));
		$toc_sheetsize = (isset($a['toc_sheetsize']) ? $a['toc_sheetsize'] : (isset($a['toc-sheet-size']) ? $a['toc-sheet-size'] : ''));

		$this->TOCpagebreak($tocfont, $tocfontsize, $tocindent, $TOCusePaging, $TOCuseLinking, $toc_orientation, $toc_mgl, $toc_mgr, $toc_mgt, $toc_mgb, $toc_mgh, $toc_mgf, $toc_ohname, $toc_ehname, $toc_ofname, $toc_efname, $toc_ohvalue, $toc_ehvalue, $toc_ofvalue, $toc_efvalue, $toc_preHTML, $toc_postHTML, $toc_bookmarkText, $resetpagenum, $pagenumstyle, $suppress, $orientation, $mgl, $mgr, $mgt, $mgb, $mgh, $mgf, $ohname, $ehname, $ofname, $efname, $ohvalue, $ehvalue, $ofvalue, $efvalue, $toc_id, $pagesel, $toc_pagesel, $sheetsize, $toc_sheetsize, $tocoutdent);
	}

	function TOCpagebreak($tocfont = '', $tocfontsize = '', $tocindent = '', $TOCusePaging = true, $TOCuseLinking = '', $toc_orientation = '', $toc_mgl = '', $toc_mgr = '', $toc_mgt = '', $toc_mgb = '', $toc_mgh = '', $toc_mgf = '', $toc_ohname = '', $toc_ehname = '', $toc_ofname = '', $toc_efname = '', $toc_ohvalue = 0, $toc_ehvalue = 0, $toc_ofvalue = 0, $toc_efvalue = 0, $toc_preHTML = '', $toc_postHTML = '', $toc_bookmarkText = '', $resetpagenum = '', $pagenumstyle = '', $suppress = '', $orientation = '', $mgl = '', $mgr = '', $mgt = '', $mgb = '', $mgh = '', $mgf = '', $ohname = '', $ehname = '', $ofname = '', $efname = '', $ohvalue = 0, $ehvalue = 0, $ofvalue = 0, $efvalue = 0, $toc_id = 0, $pagesel = '', $toc_pagesel = '', $sheetsize = '', $toc_sheetsize = '', $tocoutdent = '')
	{
		if (!class_exists('tocontents', false)) {
			include(_MPDF_PATH . 'classes/tocontents.php');
		}
		if (empty($this->tocontents)) {
			$this->tocontents = new tocontents($this);
		}
		if (!$resetpagenum) {
			$resetpagenum = 1;
		} // mPDF 6
		//Start a new page
		if ($this->state == 0)
			$this->AddPage();
		if ($this->y == $this->tMargin && (!$this->mirrorMargins || ($this->mirrorMargins && $this->page % 2 == 1))) {
			// Don't add a page
			if ($this->page == 1 && count($this->PageNumSubstitutions) == 0) {
				if (!$suppress) {
					$suppress = 'off';
				}
				//$this->PageNumSubstitutions[] = array('from'=>1, 'reset'=> $resetpagenum, 'type'=>$pagenumstyle, 'suppress'=> $suppress);
			}
			$this->PageNumSubstitutions[] = array('from' => $this->page, 'reset' => $resetpagenum, 'type' => $pagenumstyle, 'suppress' => $suppress);
		} else {
			$this->AddPage($orientation, 'NEXT-ODD', $resetpagenum, $pagenumstyle, $suppress, $mgl, $mgr, $mgt, $mgb, $mgh, $mgf, $ohname, $ehname, $ofname, $efname, $ohvalue, $ehvalue, $ofvalue, $efvalue, $pagesel, $sheetsize);
		}
		$this->tocontents->TOCpagebreak($tocfont, $tocfontsize, $tocindent, $TOCusePaging, $TOCuseLinking, $toc_orientation, $toc_mgl, $toc_mgr, $toc_mgt, $toc_mgb, $toc_mgh, $toc_mgf, $toc_ohname, $toc_ehname, $toc_ofname, $toc_efname, $toc_ohvalue, $toc_ehvalue, $toc_ofvalue, $toc_efvalue, $toc_preHTML, $toc_postHTML, $toc_bookmarkText, $resetpagenum, $pagenumstyle, $suppress, $orientation, $mgl, $mgr, $mgt, $mgb, $mgh, $mgf, $ohname, $ehname, $ofname, $efname, $ohvalue, $ehvalue, $ofvalue, $efvalue, $toc_id, $pagesel, $toc_pagesel, $sheetsize, $toc_sheetsize, $tocoutdent);
	}

	function TOC_Entry($txt, $level = 0, $toc_id = 0)
	{
		if ($this->ColActive) {
			$ily = $this->y0;
		} else {
			$ily = $this->y;
		} // use top of columns

		if (!class_exists('tocontents', false)) {
			include(_MPDF_PATH . 'classes/tocontents.php');
		}
		if (empty($this->tocontents)) {
			$this->tocontents = new tocontents($this);
		}
		$linkn = $this->AddLink();
		$uid = '__mpdfinternallink_' . $linkn;
		if ($this->table_rotate) {
			$this->internallink[$uid] = array("Y" => $ily, "PAGE" => $this->page, "tbrot" => true);
		} elseif ($this->kwt) {
			$this->internallink[$uid] = array("Y" => $ily, "PAGE" => $this->page, "kwt" => true);
		} elseif ($this->ColActive) {
			$this->internallink[$uid] = array("Y" => $ily, "PAGE" => $this->page, "col" => $this->CurrCol);
		} elseif (!$this->keep_block_together) {
			$this->internallink[$uid] = array("Y" => $ily, "PAGE" => $this->page);
		}
		$this->internallink['#' . $uid] = $linkn;
		$this->SetLink($linkn, $ily, $this->page);

		if (strtoupper($toc_id) == 'ALL') {
			$toc_id = '_mpdf_all';
		} elseif (!$toc_id) {
			$toc_id = 0;
		} else {
			$toc_id = strtolower($toc_id);
		}
		$btoc = array('t' => $txt, 'l' => $level, 'p' => $this->page, 'link' => $linkn, 'toc_id' => $toc_id);
		if ($this->keep_block_together) {
			// do nothing
		}
		/* -- TABLES -- */ elseif ($this->table_rotate) {
			$this->tbrot_toc[] = $btoc;
		} elseif ($this->kwt) {
			$this->kwt_toc[] = $btoc;
		}
		/* -- END TABLES -- */ elseif ($this->ColAct